# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Dataplex
      module V1
        module DataplexService
          # Path helper methods for the DataplexService API.
          module Paths
            ##
            # Create a fully-qualified Asset resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/lakes/{lake}/zones/{zone}/assets/{asset}`
            #
            # @param project [String]
            # @param location [String]
            # @param lake [String]
            # @param zone [String]
            # @param asset [String]
            #
            # @return [::String]
            def asset_path project:, location:, lake:, zone:, asset:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "lake cannot contain /" if lake.to_s.include? "/"
              raise ::ArgumentError, "zone cannot contain /" if zone.to_s.include? "/"

              "projects/#{project}/locations/#{location}/lakes/#{lake}/zones/#{zone}/assets/#{asset}"
            end

            ##
            # Create a fully-qualified Environment resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/lakes/{lake}/environments/{environment}`
            #
            # @param project [String]
            # @param location [String]
            # @param lake [String]
            # @param environment [String]
            #
            # @return [::String]
            def environment_path project:, location:, lake:, environment:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "lake cannot contain /" if lake.to_s.include? "/"

              "projects/#{project}/locations/#{location}/lakes/#{lake}/environments/#{environment}"
            end

            ##
            # Create a fully-qualified Job resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/lakes/{lake}/tasks/{task}/jobs/{job}`
            #
            # @param project [String]
            # @param location [String]
            # @param lake [String]
            # @param task [String]
            # @param job [String]
            #
            # @return [::String]
            def job_path project:, location:, lake:, task:, job:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "lake cannot contain /" if lake.to_s.include? "/"
              raise ::ArgumentError, "task cannot contain /" if task.to_s.include? "/"

              "projects/#{project}/locations/#{location}/lakes/#{lake}/tasks/#{task}/jobs/#{job}"
            end

            ##
            # Create a fully-qualified Lake resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/lakes/{lake}`
            #
            # @param project [String]
            # @param location [String]
            # @param lake [String]
            #
            # @return [::String]
            def lake_path project:, location:, lake:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/lakes/#{lake}"
            end

            ##
            # Create a fully-qualified Location resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}`
            #
            # @param project [String]
            # @param location [String]
            #
            # @return [::String]
            def location_path project:, location:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/locations/#{location}"
            end

            ##
            # Create a fully-qualified Task resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/lakes/{lake}/tasks/{task}`
            #
            # @param project [String]
            # @param location [String]
            # @param lake [String]
            # @param task [String]
            #
            # @return [::String]
            def task_path project:, location:, lake:, task:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "lake cannot contain /" if lake.to_s.include? "/"

              "projects/#{project}/locations/#{location}/lakes/#{lake}/tasks/#{task}"
            end

            ##
            # Create a fully-qualified Zone resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/lakes/{lake}/zones/{zone}`
            #
            # @param project [String]
            # @param location [String]
            # @param lake [String]
            # @param zone [String]
            #
            # @return [::String]
            def zone_path project:, location:, lake:, zone:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "lake cannot contain /" if lake.to_s.include? "/"

              "projects/#{project}/locations/#{location}/lakes/#{lake}/zones/#{zone}"
            end

            extend self
          end
        end
      end
    end
  end
end
