# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/dataplex/v1/data_taxonomy_pb"
require "google/cloud/location"
require "google/iam/v1"

module Google
  module Cloud
    module Dataplex
      module V1
        module DataTaxonomyService
          ##
          # Client for the DataTaxonomyService service.
          #
          # DataTaxonomyService enables attribute-based governance. The resources
          # currently offered include DataTaxonomy and DataAttribute.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "dataplex.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :data_taxonomy_service_stub

            ##
            # Configure the DataTaxonomyService Client class.
            #
            # See {::Google::Cloud::Dataplex::V1::DataTaxonomyService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @deprecated This service is deprecated and may be removed in the next major version update.
            #
            # @example
            #
            #   # Modify the configuration for all DataTaxonomyService clients
            #   ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "Dataplex", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the DataTaxonomyService Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::Dataplex::V1::DataTaxonomyService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @data_taxonomy_service_stub.universe_domain
            end

            ##
            # Create a new DataTaxonomyService client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the DataTaxonomyService client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/dataplex/v1/data_taxonomy_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @data_taxonomy_service_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @data_taxonomy_service_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @location_client = Google::Cloud::Location::Locations::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @data_taxonomy_service_stub.endpoint
                config.universe_domain = @data_taxonomy_service_stub.universe_domain
                config.logger = @data_taxonomy_service_stub.logger if config.respond_to? :logger=
              end

              @iam_policy_client = Google::Iam::V1::IAMPolicy::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @data_taxonomy_service_stub.endpoint
                config.universe_domain = @data_taxonomy_service_stub.universe_domain
                config.logger = @data_taxonomy_service_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Cloud::Dataplex::V1::DataTaxonomyService::Operations]
            #
            attr_reader :operations_client

            ##
            # Get the associated client for mix-in of the Locations.
            #
            # @return [Google::Cloud::Location::Locations::Client]
            #
            attr_reader :location_client

            ##
            # Get the associated client for mix-in of the IAMPolicy.
            #
            # @return [Google::Iam::V1::IAMPolicy::Client]
            #
            attr_reader :iam_policy_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @data_taxonomy_service_stub.logger
            end

            # Service calls

            ##
            # Create a DataTaxonomy resource.
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload create_data_taxonomy(request, options = nil)
            #   Pass arguments to `create_data_taxonomy` via a request object, either of type
            #   {::Google::Cloud::Dataplex::V1::CreateDataTaxonomyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataplex::V1::CreateDataTaxonomyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_data_taxonomy(parent: nil, data_taxonomy_id: nil, data_taxonomy: nil, validate_only: nil)
            #   Pass arguments to `create_data_taxonomy` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #   @param data_taxonomy_id [::String]
            #     Required. DataTaxonomy identifier.
            #     * Must contain only lowercase letters, numbers and hyphens.
            #     * Must start with a letter.
            #     * Must be between 1-63 characters.
            #     * Must end with a number or a letter.
            #     * Must be unique within the Project.
            #   @param data_taxonomy [::Google::Cloud::Dataplex::V1::DataTaxonomy, ::Hash]
            #     Required. DataTaxonomy resource.
            #   @param validate_only [::Boolean]
            #     Optional. Only validate the request, but do not perform mutations.
            #     The default is false.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataplex/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataplex::V1::DataTaxonomyService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataplex::V1::CreateDataTaxonomyRequest.new
            #
            #   # Call the create_data_taxonomy method.
            #   result = client.create_data_taxonomy request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_data_taxonomy request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::CreateDataTaxonomyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_data_taxonomy.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataplex::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_data_taxonomy.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_data_taxonomy.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_taxonomy_service_stub.call_rpc :create_data_taxonomy, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a DataTaxonomy resource.
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload update_data_taxonomy(request, options = nil)
            #   Pass arguments to `update_data_taxonomy` via a request object, either of type
            #   {::Google::Cloud::Dataplex::V1::UpdateDataTaxonomyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataplex::V1::UpdateDataTaxonomyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_data_taxonomy(update_mask: nil, data_taxonomy: nil, validate_only: nil)
            #   Pass arguments to `update_data_taxonomy` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. Mask of fields to update.
            #   @param data_taxonomy [::Google::Cloud::Dataplex::V1::DataTaxonomy, ::Hash]
            #     Required. Only fields specified in `update_mask` are updated.
            #   @param validate_only [::Boolean]
            #     Optional. Only validate the request, but do not perform mutations.
            #     The default is false.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataplex/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataplex::V1::DataTaxonomyService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataplex::V1::UpdateDataTaxonomyRequest.new
            #
            #   # Call the update_data_taxonomy method.
            #   result = client.update_data_taxonomy request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_data_taxonomy request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::UpdateDataTaxonomyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_data_taxonomy.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataplex::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.data_taxonomy&.name
                header_params["data_taxonomy.name"] = request.data_taxonomy.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_data_taxonomy.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_data_taxonomy.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_taxonomy_service_stub.call_rpc :update_data_taxonomy, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a DataTaxonomy resource. All attributes within the DataTaxonomy
            # must be deleted before the DataTaxonomy can be deleted.
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload delete_data_taxonomy(request, options = nil)
            #   Pass arguments to `delete_data_taxonomy` via a request object, either of type
            #   {::Google::Cloud::Dataplex::V1::DeleteDataTaxonomyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataplex::V1::DeleteDataTaxonomyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_data_taxonomy(name: nil, etag: nil)
            #   Pass arguments to `delete_data_taxonomy` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the DataTaxonomy:
            #     projects/\\{project_number}/locations/\\{location_id}/dataTaxonomies/\\{data_taxonomy_id}
            #   @param etag [::String]
            #     Optional. If the client provided etag value does not match the current etag
            #     value,the DeleteDataTaxonomy method returns an ABORTED error.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataplex/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataplex::V1::DataTaxonomyService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataplex::V1::DeleteDataTaxonomyRequest.new
            #
            #   # Call the delete_data_taxonomy method.
            #   result = client.delete_data_taxonomy request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_data_taxonomy request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::DeleteDataTaxonomyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_data_taxonomy.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataplex::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_data_taxonomy.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_data_taxonomy.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_taxonomy_service_stub.call_rpc :delete_data_taxonomy, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists DataTaxonomy resources in a project and location.
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload list_data_taxonomies(request, options = nil)
            #   Pass arguments to `list_data_taxonomies` via a request object, either of type
            #   {::Google::Cloud::Dataplex::V1::ListDataTaxonomiesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataplex::V1::ListDataTaxonomiesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_data_taxonomies(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_data_taxonomies` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the DataTaxonomy location, of the form:
            #     projects/\\{project_number}/locations/\\{location_id}
            #     where `location_id` refers to a Google Cloud region.
            #   @param page_size [::Integer]
            #     Optional. Maximum number of DataTaxonomies to return. The service may
            #     return fewer than this value. If unspecified, at most 10 DataTaxonomies
            #     will be returned. The maximum value is 1000; values above 1000 will be
            #     coerced to 1000.
            #   @param page_token [::String]
            #     Optional. Page token received from a previous ` ListDataTaxonomies` call.
            #     Provide this to retrieve the subsequent page. When paginating, all other
            #     parameters provided to ` ListDataTaxonomies` must match the call that
            #     provided the page token.
            #   @param filter [::String]
            #     Optional. Filter request.
            #   @param order_by [::String]
            #     Optional. Order by fields for the result.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Dataplex::V1::DataTaxonomy>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Dataplex::V1::DataTaxonomy>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataplex/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataplex::V1::DataTaxonomyService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataplex::V1::ListDataTaxonomiesRequest.new
            #
            #   # Call the list_data_taxonomies method.
            #   result = client.list_data_taxonomies request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Dataplex::V1::DataTaxonomy.
            #     p item
            #   end
            #
            def list_data_taxonomies request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::ListDataTaxonomiesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_data_taxonomies.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataplex::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_data_taxonomies.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_data_taxonomies.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_taxonomy_service_stub.call_rpc :list_data_taxonomies, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @data_taxonomy_service_stub, :list_data_taxonomies, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Retrieves a DataTaxonomy resource.
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload get_data_taxonomy(request, options = nil)
            #   Pass arguments to `get_data_taxonomy` via a request object, either of type
            #   {::Google::Cloud::Dataplex::V1::GetDataTaxonomyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataplex::V1::GetDataTaxonomyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_data_taxonomy(name: nil)
            #   Pass arguments to `get_data_taxonomy` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Dataplex::V1::DataTaxonomy]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Dataplex::V1::DataTaxonomy]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataplex/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataplex::V1::DataTaxonomyService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataplex::V1::GetDataTaxonomyRequest.new
            #
            #   # Call the get_data_taxonomy method.
            #   result = client.get_data_taxonomy request
            #
            #   # The returned object is of type Google::Cloud::Dataplex::V1::DataTaxonomy.
            #   p result
            #
            def get_data_taxonomy request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::GetDataTaxonomyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_data_taxonomy.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataplex::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_data_taxonomy.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_data_taxonomy.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_taxonomy_service_stub.call_rpc :get_data_taxonomy, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Create a DataAttributeBinding resource.
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload create_data_attribute_binding(request, options = nil)
            #   Pass arguments to `create_data_attribute_binding` via a request object, either of type
            #   {::Google::Cloud::Dataplex::V1::CreateDataAttributeBindingRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataplex::V1::CreateDataAttributeBindingRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_data_attribute_binding(parent: nil, data_attribute_binding_id: nil, data_attribute_binding: nil, validate_only: nil)
            #   Pass arguments to `create_data_attribute_binding` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the parent data taxonomy
            #     projects/\\{project_number}/locations/\\{location_id}
            #   @param data_attribute_binding_id [::String]
            #     Required. DataAttributeBinding identifier.
            #     * Must contain only lowercase letters, numbers and hyphens.
            #     * Must start with a letter.
            #     * Must be between 1-63 characters.
            #     * Must end with a number or a letter.
            #     * Must be unique within the Location.
            #   @param data_attribute_binding [::Google::Cloud::Dataplex::V1::DataAttributeBinding, ::Hash]
            #     Required. DataAttributeBinding resource.
            #   @param validate_only [::Boolean]
            #     Optional. Only validate the request, but do not perform mutations.
            #     The default is false.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataplex/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataplex::V1::DataTaxonomyService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataplex::V1::CreateDataAttributeBindingRequest.new
            #
            #   # Call the create_data_attribute_binding method.
            #   result = client.create_data_attribute_binding request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_data_attribute_binding request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::CreateDataAttributeBindingRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_data_attribute_binding.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataplex::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_data_attribute_binding.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_data_attribute_binding.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_taxonomy_service_stub.call_rpc :create_data_attribute_binding, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a DataAttributeBinding resource.
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload update_data_attribute_binding(request, options = nil)
            #   Pass arguments to `update_data_attribute_binding` via a request object, either of type
            #   {::Google::Cloud::Dataplex::V1::UpdateDataAttributeBindingRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataplex::V1::UpdateDataAttributeBindingRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_data_attribute_binding(update_mask: nil, data_attribute_binding: nil, validate_only: nil)
            #   Pass arguments to `update_data_attribute_binding` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. Mask of fields to update.
            #   @param data_attribute_binding [::Google::Cloud::Dataplex::V1::DataAttributeBinding, ::Hash]
            #     Required. Only fields specified in `update_mask` are updated.
            #   @param validate_only [::Boolean]
            #     Optional. Only validate the request, but do not perform mutations.
            #     The default is false.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataplex/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataplex::V1::DataTaxonomyService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataplex::V1::UpdateDataAttributeBindingRequest.new
            #
            #   # Call the update_data_attribute_binding method.
            #   result = client.update_data_attribute_binding request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_data_attribute_binding request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::UpdateDataAttributeBindingRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_data_attribute_binding.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataplex::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.data_attribute_binding&.name
                header_params["data_attribute_binding.name"] = request.data_attribute_binding.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_data_attribute_binding.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_data_attribute_binding.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_taxonomy_service_stub.call_rpc :update_data_attribute_binding, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a DataAttributeBinding resource. All attributes within the
            # DataAttributeBinding must be deleted before the DataAttributeBinding can be
            # deleted.
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload delete_data_attribute_binding(request, options = nil)
            #   Pass arguments to `delete_data_attribute_binding` via a request object, either of type
            #   {::Google::Cloud::Dataplex::V1::DeleteDataAttributeBindingRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataplex::V1::DeleteDataAttributeBindingRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_data_attribute_binding(name: nil, etag: nil)
            #   Pass arguments to `delete_data_attribute_binding` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the DataAttributeBinding:
            #     projects/\\{project_number}/locations/\\{location_id}/dataAttributeBindings/\\{data_attribute_binding_id}
            #   @param etag [::String]
            #     Required. If the client provided etag value does not match the current etag
            #     value, the DeleteDataAttributeBindingRequest method returns an ABORTED
            #     error response. Etags must be used when calling the
            #     DeleteDataAttributeBinding.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataplex/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataplex::V1::DataTaxonomyService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataplex::V1::DeleteDataAttributeBindingRequest.new
            #
            #   # Call the delete_data_attribute_binding method.
            #   result = client.delete_data_attribute_binding request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_data_attribute_binding request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::DeleteDataAttributeBindingRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_data_attribute_binding.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataplex::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_data_attribute_binding.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_data_attribute_binding.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_taxonomy_service_stub.call_rpc :delete_data_attribute_binding, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists DataAttributeBinding resources in a project and location.
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload list_data_attribute_bindings(request, options = nil)
            #   Pass arguments to `list_data_attribute_bindings` via a request object, either of type
            #   {::Google::Cloud::Dataplex::V1::ListDataAttributeBindingsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataplex::V1::ListDataAttributeBindingsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_data_attribute_bindings(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_data_attribute_bindings` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the Location:
            #     projects/\\{project_number}/locations/\\{location_id}
            #   @param page_size [::Integer]
            #     Optional. Maximum number of DataAttributeBindings to return. The service
            #     may return fewer than this value. If unspecified, at most 10
            #     DataAttributeBindings will be returned. The maximum value is 1000; values
            #     above 1000 will be coerced to 1000.
            #   @param page_token [::String]
            #     Optional. Page token received from a previous `ListDataAttributeBindings`
            #     call. Provide this to retrieve the subsequent page. When paginating, all
            #     other parameters provided to `ListDataAttributeBindings` must match the
            #     call that provided the page token.
            #   @param filter [::String]
            #     Optional. Filter request.
            #     Filter using resource: filter=resource:"resource-name"
            #     Filter using attribute: filter=attributes:"attribute-name"
            #     Filter using attribute in paths list:
            #     filter=paths.attributes:"attribute-name"
            #   @param order_by [::String]
            #     Optional. Order by fields for the result.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Dataplex::V1::DataAttributeBinding>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Dataplex::V1::DataAttributeBinding>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataplex/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataplex::V1::DataTaxonomyService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataplex::V1::ListDataAttributeBindingsRequest.new
            #
            #   # Call the list_data_attribute_bindings method.
            #   result = client.list_data_attribute_bindings request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Dataplex::V1::DataAttributeBinding.
            #     p item
            #   end
            #
            def list_data_attribute_bindings request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::ListDataAttributeBindingsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_data_attribute_bindings.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataplex::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_data_attribute_bindings.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_data_attribute_bindings.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_taxonomy_service_stub.call_rpc :list_data_attribute_bindings, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @data_taxonomy_service_stub, :list_data_attribute_bindings, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Retrieves a DataAttributeBinding resource.
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload get_data_attribute_binding(request, options = nil)
            #   Pass arguments to `get_data_attribute_binding` via a request object, either of type
            #   {::Google::Cloud::Dataplex::V1::GetDataAttributeBindingRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataplex::V1::GetDataAttributeBindingRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_data_attribute_binding(name: nil)
            #   Pass arguments to `get_data_attribute_binding` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the DataAttributeBinding:
            #     projects/\\{project_number}/locations/\\{location_id}/dataAttributeBindings/\\{data_attribute_binding_id}
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Dataplex::V1::DataAttributeBinding]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Dataplex::V1::DataAttributeBinding]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataplex/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataplex::V1::DataTaxonomyService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataplex::V1::GetDataAttributeBindingRequest.new
            #
            #   # Call the get_data_attribute_binding method.
            #   result = client.get_data_attribute_binding request
            #
            #   # The returned object is of type Google::Cloud::Dataplex::V1::DataAttributeBinding.
            #   p result
            #
            def get_data_attribute_binding request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::GetDataAttributeBindingRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_data_attribute_binding.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataplex::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_data_attribute_binding.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_data_attribute_binding.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_taxonomy_service_stub.call_rpc :get_data_attribute_binding, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Create a DataAttribute resource.
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload create_data_attribute(request, options = nil)
            #   Pass arguments to `create_data_attribute` via a request object, either of type
            #   {::Google::Cloud::Dataplex::V1::CreateDataAttributeRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataplex::V1::CreateDataAttributeRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_data_attribute(parent: nil, data_attribute_id: nil, data_attribute: nil, validate_only: nil)
            #   Pass arguments to `create_data_attribute` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the parent data taxonomy
            #     projects/\\{project_number}/locations/\\{location_id}/dataTaxonomies/\\{data_taxonomy_id}
            #   @param data_attribute_id [::String]
            #     Required. DataAttribute identifier.
            #     * Must contain only lowercase letters, numbers and hyphens.
            #     * Must start with a letter.
            #     * Must be between 1-63 characters.
            #     * Must end with a number or a letter.
            #     * Must be unique within the DataTaxonomy.
            #   @param data_attribute [::Google::Cloud::Dataplex::V1::DataAttribute, ::Hash]
            #     Required. DataAttribute resource.
            #   @param validate_only [::Boolean]
            #     Optional. Only validate the request, but do not perform mutations.
            #     The default is false.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataplex/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataplex::V1::DataTaxonomyService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataplex::V1::CreateDataAttributeRequest.new
            #
            #   # Call the create_data_attribute method.
            #   result = client.create_data_attribute request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_data_attribute request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::CreateDataAttributeRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_data_attribute.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataplex::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_data_attribute.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_data_attribute.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_taxonomy_service_stub.call_rpc :create_data_attribute, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a DataAttribute resource.
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload update_data_attribute(request, options = nil)
            #   Pass arguments to `update_data_attribute` via a request object, either of type
            #   {::Google::Cloud::Dataplex::V1::UpdateDataAttributeRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataplex::V1::UpdateDataAttributeRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_data_attribute(update_mask: nil, data_attribute: nil, validate_only: nil)
            #   Pass arguments to `update_data_attribute` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. Mask of fields to update.
            #   @param data_attribute [::Google::Cloud::Dataplex::V1::DataAttribute, ::Hash]
            #     Required. Only fields specified in `update_mask` are updated.
            #   @param validate_only [::Boolean]
            #     Optional. Only validate the request, but do not perform mutations.
            #     The default is false.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataplex/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataplex::V1::DataTaxonomyService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataplex::V1::UpdateDataAttributeRequest.new
            #
            #   # Call the update_data_attribute method.
            #   result = client.update_data_attribute request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_data_attribute request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::UpdateDataAttributeRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_data_attribute.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataplex::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.data_attribute&.name
                header_params["data_attribute.name"] = request.data_attribute.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_data_attribute.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_data_attribute.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_taxonomy_service_stub.call_rpc :update_data_attribute, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a Data Attribute resource.
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload delete_data_attribute(request, options = nil)
            #   Pass arguments to `delete_data_attribute` via a request object, either of type
            #   {::Google::Cloud::Dataplex::V1::DeleteDataAttributeRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataplex::V1::DeleteDataAttributeRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_data_attribute(name: nil, etag: nil)
            #   Pass arguments to `delete_data_attribute` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the DataAttribute:
            #     projects/\\{project_number}/locations/\\{location_id}/dataTaxonomies/\\{dataTaxonomy}/attributes/\\{data_attribute_id}
            #   @param etag [::String]
            #     Optional. If the client provided etag value does not match the current etag
            #     value, the DeleteDataAttribute method returns an ABORTED error response.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataplex/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataplex::V1::DataTaxonomyService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataplex::V1::DeleteDataAttributeRequest.new
            #
            #   # Call the delete_data_attribute method.
            #   result = client.delete_data_attribute request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_data_attribute request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::DeleteDataAttributeRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_data_attribute.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataplex::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_data_attribute.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_data_attribute.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_taxonomy_service_stub.call_rpc :delete_data_attribute, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists Data Attribute resources in a DataTaxonomy.
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload list_data_attributes(request, options = nil)
            #   Pass arguments to `list_data_attributes` via a request object, either of type
            #   {::Google::Cloud::Dataplex::V1::ListDataAttributesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataplex::V1::ListDataAttributesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_data_attributes(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_data_attributes` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the DataTaxonomy:
            #     projects/\\{project_number}/locations/\\{location_id}/dataTaxonomies/\\{data_taxonomy_id}
            #   @param page_size [::Integer]
            #     Optional. Maximum number of DataAttributes to return. The service may
            #     return fewer than this value. If unspecified, at most 10 dataAttributes
            #     will be returned. The maximum value is 1000; values above 1000 will be
            #     coerced to 1000.
            #   @param page_token [::String]
            #     Optional. Page token received from a previous `ListDataAttributes` call.
            #     Provide this to retrieve the subsequent page. When paginating, all other
            #     parameters provided to `ListDataAttributes` must match the call that
            #     provided the page token.
            #   @param filter [::String]
            #     Optional. Filter request.
            #   @param order_by [::String]
            #     Optional. Order by fields for the result.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Dataplex::V1::DataAttribute>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Dataplex::V1::DataAttribute>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataplex/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataplex::V1::DataTaxonomyService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataplex::V1::ListDataAttributesRequest.new
            #
            #   # Call the list_data_attributes method.
            #   result = client.list_data_attributes request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Dataplex::V1::DataAttribute.
            #     p item
            #   end
            #
            def list_data_attributes request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::ListDataAttributesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_data_attributes.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataplex::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_data_attributes.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_data_attributes.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_taxonomy_service_stub.call_rpc :list_data_attributes, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @data_taxonomy_service_stub, :list_data_attributes, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Retrieves a Data Attribute resource.
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload get_data_attribute(request, options = nil)
            #   Pass arguments to `get_data_attribute` via a request object, either of type
            #   {::Google::Cloud::Dataplex::V1::GetDataAttributeRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataplex::V1::GetDataAttributeRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_data_attribute(name: nil)
            #   Pass arguments to `get_data_attribute` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the dataAttribute:
            #     projects/\\{project_number}/locations/\\{location_id}/dataTaxonomies/\\{dataTaxonomy}/attributes/\\{data_attribute_id}
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Dataplex::V1::DataAttribute]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Dataplex::V1::DataAttribute]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataplex/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataplex::V1::DataTaxonomyService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataplex::V1::GetDataAttributeRequest.new
            #
            #   # Call the get_data_attribute method.
            #   result = client.get_data_attribute request
            #
            #   # The returned object is of type Google::Cloud::Dataplex::V1::DataAttribute.
            #   p result
            #
            def get_data_attribute request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::GetDataAttributeRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_data_attribute.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataplex::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_data_attribute.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_data_attribute.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_taxonomy_service_stub.call_rpc :get_data_attribute, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the DataTaxonomyService API.
            #
            # This class represents the configuration for DataTaxonomyService,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::Dataplex::V1::DataTaxonomyService::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # create_data_taxonomy to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_data_taxonomy.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_data_taxonomy.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "dataplex.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the DataTaxonomyService API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `create_data_taxonomy`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_data_taxonomy
                ##
                # RPC-specific configuration for `update_data_taxonomy`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_data_taxonomy
                ##
                # RPC-specific configuration for `delete_data_taxonomy`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_data_taxonomy
                ##
                # RPC-specific configuration for `list_data_taxonomies`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_data_taxonomies
                ##
                # RPC-specific configuration for `get_data_taxonomy`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_data_taxonomy
                ##
                # RPC-specific configuration for `create_data_attribute_binding`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_data_attribute_binding
                ##
                # RPC-specific configuration for `update_data_attribute_binding`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_data_attribute_binding
                ##
                # RPC-specific configuration for `delete_data_attribute_binding`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_data_attribute_binding
                ##
                # RPC-specific configuration for `list_data_attribute_bindings`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_data_attribute_bindings
                ##
                # RPC-specific configuration for `get_data_attribute_binding`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_data_attribute_binding
                ##
                # RPC-specific configuration for `create_data_attribute`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_data_attribute
                ##
                # RPC-specific configuration for `update_data_attribute`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_data_attribute
                ##
                # RPC-specific configuration for `delete_data_attribute`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_data_attribute
                ##
                # RPC-specific configuration for `list_data_attributes`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_data_attributes
                ##
                # RPC-specific configuration for `get_data_attribute`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_data_attribute

                # @private
                def initialize parent_rpcs = nil
                  create_data_taxonomy_config = parent_rpcs.create_data_taxonomy if parent_rpcs.respond_to? :create_data_taxonomy
                  @create_data_taxonomy = ::Gapic::Config::Method.new create_data_taxonomy_config
                  update_data_taxonomy_config = parent_rpcs.update_data_taxonomy if parent_rpcs.respond_to? :update_data_taxonomy
                  @update_data_taxonomy = ::Gapic::Config::Method.new update_data_taxonomy_config
                  delete_data_taxonomy_config = parent_rpcs.delete_data_taxonomy if parent_rpcs.respond_to? :delete_data_taxonomy
                  @delete_data_taxonomy = ::Gapic::Config::Method.new delete_data_taxonomy_config
                  list_data_taxonomies_config = parent_rpcs.list_data_taxonomies if parent_rpcs.respond_to? :list_data_taxonomies
                  @list_data_taxonomies = ::Gapic::Config::Method.new list_data_taxonomies_config
                  get_data_taxonomy_config = parent_rpcs.get_data_taxonomy if parent_rpcs.respond_to? :get_data_taxonomy
                  @get_data_taxonomy = ::Gapic::Config::Method.new get_data_taxonomy_config
                  create_data_attribute_binding_config = parent_rpcs.create_data_attribute_binding if parent_rpcs.respond_to? :create_data_attribute_binding
                  @create_data_attribute_binding = ::Gapic::Config::Method.new create_data_attribute_binding_config
                  update_data_attribute_binding_config = parent_rpcs.update_data_attribute_binding if parent_rpcs.respond_to? :update_data_attribute_binding
                  @update_data_attribute_binding = ::Gapic::Config::Method.new update_data_attribute_binding_config
                  delete_data_attribute_binding_config = parent_rpcs.delete_data_attribute_binding if parent_rpcs.respond_to? :delete_data_attribute_binding
                  @delete_data_attribute_binding = ::Gapic::Config::Method.new delete_data_attribute_binding_config
                  list_data_attribute_bindings_config = parent_rpcs.list_data_attribute_bindings if parent_rpcs.respond_to? :list_data_attribute_bindings
                  @list_data_attribute_bindings = ::Gapic::Config::Method.new list_data_attribute_bindings_config
                  get_data_attribute_binding_config = parent_rpcs.get_data_attribute_binding if parent_rpcs.respond_to? :get_data_attribute_binding
                  @get_data_attribute_binding = ::Gapic::Config::Method.new get_data_attribute_binding_config
                  create_data_attribute_config = parent_rpcs.create_data_attribute if parent_rpcs.respond_to? :create_data_attribute
                  @create_data_attribute = ::Gapic::Config::Method.new create_data_attribute_config
                  update_data_attribute_config = parent_rpcs.update_data_attribute if parent_rpcs.respond_to? :update_data_attribute
                  @update_data_attribute = ::Gapic::Config::Method.new update_data_attribute_config
                  delete_data_attribute_config = parent_rpcs.delete_data_attribute if parent_rpcs.respond_to? :delete_data_attribute
                  @delete_data_attribute = ::Gapic::Config::Method.new delete_data_attribute_config
                  list_data_attributes_config = parent_rpcs.list_data_attributes if parent_rpcs.respond_to? :list_data_attributes
                  @list_data_attributes = ::Gapic::Config::Method.new list_data_attributes_config
                  get_data_attribute_config = parent_rpcs.get_data_attribute if parent_rpcs.respond_to? :get_data_attribute
                  @get_data_attribute = ::Gapic::Config::Method.new get_data_attribute_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
