# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/dataplex/v1/datascans_pb"
require "google/cloud/dataplex/v1/data_scan_service/rest/service_stub"
require "google/cloud/location/rest"
require "google/iam/v1/rest"

module Google
  module Cloud
    module Dataplex
      module V1
        module DataScanService
          module Rest
            ##
            # REST client for the DataScanService service.
            #
            # DataScanService manages DataScan resources which can be configured to run
            # various types of data scanning workload and generate enriched metadata (e.g.
            # Data Profile, Data Quality) for the data source.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "dataplex.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :data_scan_service_stub

              ##
              # Configure the DataScanService Client class.
              #
              # See {::Google::Cloud::Dataplex::V1::DataScanService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all DataScanService clients
              #   ::Google::Cloud::Dataplex::V1::DataScanService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "Dataplex", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the DataScanService Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::Dataplex::V1::DataScanService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @data_scan_service_stub.universe_domain
              end

              ##
              # Create a new DataScanService REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::Dataplex::V1::DataScanService::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::Dataplex::V1::DataScanService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the DataScanService client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = ::Google::Cloud::Dataplex::V1::DataScanService::Rest::Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @data_scan_service_stub = ::Google::Cloud::Dataplex::V1::DataScanService::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @data_scan_service_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @data_scan_service_stub.endpoint
                  config.universe_domain = @data_scan_service_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @data_scan_service_stub.logger if config.respond_to? :logger=
                end

                @iam_policy_client = Google::Iam::V1::IAMPolicy::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @data_scan_service_stub.endpoint
                  config.universe_domain = @data_scan_service_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @data_scan_service_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::Dataplex::V1::DataScanService::Rest::Operations]
              #
              attr_reader :operations_client

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Rest::Client]
              #
              attr_reader :location_client

              ##
              # Get the associated client for mix-in of the IAMPolicy.
              #
              # @return [Google::Iam::V1::IAMPolicy::Rest::Client]
              #
              attr_reader :iam_policy_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @data_scan_service_stub.logger
              end

              # Service calls

              ##
              # Creates a DataScan resource.
              #
              # @overload create_data_scan(request, options = nil)
              #   Pass arguments to `create_data_scan` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::CreateDataScanRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::CreateDataScanRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_data_scan(parent: nil, data_scan: nil, data_scan_id: nil, validate_only: nil)
              #   Pass arguments to `create_data_scan` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the parent location:
              #     `projects/{project}/locations/{location_id}`
              #     where `project` refers to a *project_id* or *project_number* and
              #     `location_id` refers to a Google Cloud region.
              #   @param data_scan [::Google::Cloud::Dataplex::V1::DataScan, ::Hash]
              #     Required. DataScan resource.
              #   @param data_scan_id [::String]
              #     Required. DataScan identifier.
              #
              #     * Must contain only lowercase letters, numbers and hyphens.
              #     * Must start with a letter.
              #     * Must end with a number or a letter.
              #     * Must be between 1-63 characters.
              #     * Must be unique within the customer project / location.
              #   @param validate_only [::Boolean]
              #     Optional. Only validate the request, but do not perform mutations.
              #     The default is `false`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::DataScanService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::CreateDataScanRequest.new
              #
              #   # Call the create_data_scan method.
              #   result = client.create_data_scan request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_data_scan request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::CreateDataScanRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_data_scan.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_data_scan.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_data_scan.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_scan_service_stub.create_data_scan request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a DataScan resource.
              #
              # @overload update_data_scan(request, options = nil)
              #   Pass arguments to `update_data_scan` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::UpdateDataScanRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::UpdateDataScanRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_data_scan(data_scan: nil, update_mask: nil, validate_only: nil)
              #   Pass arguments to `update_data_scan` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param data_scan [::Google::Cloud::Dataplex::V1::DataScan, ::Hash]
              #     Required. DataScan resource to be updated.
              #
              #     Only fields specified in `update_mask` are updated.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Optional. Mask of fields to update.
              #   @param validate_only [::Boolean]
              #     Optional. Only validate the request, but do not perform mutations.
              #     The default is `false`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::DataScanService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::UpdateDataScanRequest.new
              #
              #   # Call the update_data_scan method.
              #   result = client.update_data_scan request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_data_scan request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::UpdateDataScanRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_data_scan.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_data_scan.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_data_scan.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_scan_service_stub.update_data_scan request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a DataScan resource.
              #
              # @overload delete_data_scan(request, options = nil)
              #   Pass arguments to `delete_data_scan` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::DeleteDataScanRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::DeleteDataScanRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_data_scan(name: nil, force: nil)
              #   Pass arguments to `delete_data_scan` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the dataScan:
              #     `projects/{project}/locations/{location_id}/dataScans/{data_scan_id}`
              #     where `project` refers to a *project_id* or *project_number* and
              #     `location_id` refers to a Google Cloud region.
              #   @param force [::Boolean]
              #     Optional. If set to true, any child resources of this data scan will also
              #     be deleted. (Otherwise, the request will only work if the data scan has no
              #     child resources.)
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::DataScanService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::DeleteDataScanRequest.new
              #
              #   # Call the delete_data_scan method.
              #   result = client.delete_data_scan request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_data_scan request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::DeleteDataScanRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_data_scan.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_data_scan.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_data_scan.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_scan_service_stub.delete_data_scan request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a DataScan resource.
              #
              # @overload get_data_scan(request, options = nil)
              #   Pass arguments to `get_data_scan` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::GetDataScanRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::GetDataScanRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_data_scan(name: nil, view: nil)
              #   Pass arguments to `get_data_scan` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the dataScan:
              #     `projects/{project}/locations/{location_id}/dataScans/{data_scan_id}`
              #     where `project` refers to a *project_id* or *project_number* and
              #     `location_id` refers to a Google Cloud region.
              #   @param view [::Google::Cloud::Dataplex::V1::GetDataScanRequest::DataScanView]
              #     Optional. Select the DataScan view to return. Defaults to `BASIC`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dataplex::V1::DataScan]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dataplex::V1::DataScan]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::DataScanService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::GetDataScanRequest.new
              #
              #   # Call the get_data_scan method.
              #   result = client.get_data_scan request
              #
              #   # The returned object is of type Google::Cloud::Dataplex::V1::DataScan.
              #   p result
              #
              def get_data_scan request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::GetDataScanRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_data_scan.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_data_scan.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_data_scan.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_scan_service_stub.get_data_scan request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists DataScans.
              #
              # @overload list_data_scans(request, options = nil)
              #   Pass arguments to `list_data_scans` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::ListDataScansRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::ListDataScansRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_data_scans(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_data_scans` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the parent location:
              #     `projects/{project}/locations/{location_id}`
              #     where `project` refers to a *project_id* or *project_number* and
              #     `location_id` refers to a Google Cloud region.
              #   @param page_size [::Integer]
              #     Optional. Maximum number of dataScans to return. The service may return
              #     fewer than this value. If unspecified, at most 500 scans will be returned.
              #     The maximum value is 1000; values above 1000 will be coerced to 1000.
              #   @param page_token [::String]
              #     Optional. Page token received from a previous `ListDataScans` call. Provide
              #     this to retrieve the subsequent page. When paginating, all other parameters
              #     provided to `ListDataScans` must match the call that provided the
              #     page token.
              #   @param filter [::String]
              #     Optional. Filter request.
              #   @param order_by [::String]
              #     Optional. Order by fields (`name` or `create_time`) for the result.
              #     If not specified, the ordering is undefined.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dataplex::V1::DataScan>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dataplex::V1::DataScan>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::DataScanService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::ListDataScansRequest.new
              #
              #   # Call the list_data_scans method.
              #   result = client.list_data_scans request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Dataplex::V1::DataScan.
              #     p item
              #   end
              #
              def list_data_scans request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::ListDataScansRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_data_scans.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_data_scans.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_data_scans.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_scan_service_stub.list_data_scans request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @data_scan_service_stub, :list_data_scans, "data_scans", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Runs an on-demand execution of a DataScan
              #
              # @overload run_data_scan(request, options = nil)
              #   Pass arguments to `run_data_scan` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::RunDataScanRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::RunDataScanRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload run_data_scan(name: nil)
              #   Pass arguments to `run_data_scan` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the DataScan:
              #     `projects/{project}/locations/{location_id}/dataScans/{data_scan_id}`.
              #     where `project` refers to a *project_id* or *project_number* and
              #     `location_id` refers to a Google Cloud region.
              #
              #     Only **OnDemand** data scans are allowed.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dataplex::V1::RunDataScanResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dataplex::V1::RunDataScanResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::DataScanService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::RunDataScanRequest.new
              #
              #   # Call the run_data_scan method.
              #   result = client.run_data_scan request
              #
              #   # The returned object is of type Google::Cloud::Dataplex::V1::RunDataScanResponse.
              #   p result
              #
              def run_data_scan request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::RunDataScanRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.run_data_scan.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.run_data_scan.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.run_data_scan.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_scan_service_stub.run_data_scan request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a DataScanJob resource.
              #
              # @overload get_data_scan_job(request, options = nil)
              #   Pass arguments to `get_data_scan_job` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::GetDataScanJobRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::GetDataScanJobRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_data_scan_job(name: nil, view: nil)
              #   Pass arguments to `get_data_scan_job` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the DataScanJob:
              #     `projects/{project}/locations/{location_id}/dataScans/{data_scan_id}/jobs/{data_scan_job_id}`
              #     where `project` refers to a *project_id* or *project_number* and
              #     `location_id` refers to a Google Cloud region.
              #   @param view [::Google::Cloud::Dataplex::V1::GetDataScanJobRequest::DataScanJobView]
              #     Optional. Select the DataScanJob view to return. Defaults to `BASIC`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dataplex::V1::DataScanJob]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dataplex::V1::DataScanJob]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::DataScanService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::GetDataScanJobRequest.new
              #
              #   # Call the get_data_scan_job method.
              #   result = client.get_data_scan_job request
              #
              #   # The returned object is of type Google::Cloud::Dataplex::V1::DataScanJob.
              #   p result
              #
              def get_data_scan_job request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::GetDataScanJobRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_data_scan_job.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_data_scan_job.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_data_scan_job.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_scan_service_stub.get_data_scan_job request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists DataScanJobs under the given DataScan.
              #
              # @overload list_data_scan_jobs(request, options = nil)
              #   Pass arguments to `list_data_scan_jobs` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::ListDataScanJobsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::ListDataScanJobsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_data_scan_jobs(parent: nil, page_size: nil, page_token: nil, filter: nil)
              #   Pass arguments to `list_data_scan_jobs` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the parent environment:
              #     `projects/{project}/locations/{location_id}/dataScans/{data_scan_id}`
              #     where `project` refers to a *project_id* or *project_number* and
              #     `location_id` refers to a Google Cloud region.
              #   @param page_size [::Integer]
              #     Optional. Maximum number of DataScanJobs to return. The service may return
              #     fewer than this value. If unspecified, at most 10 DataScanJobs will be
              #     returned. The maximum value is 1000; values above 1000 will be coerced to
              #     1000.
              #   @param page_token [::String]
              #     Optional. Page token received from a previous `ListDataScanJobs` call.
              #     Provide this to retrieve the subsequent page. When paginating, all other
              #     parameters provided to `ListDataScanJobs` must match the call that provided
              #     the page token.
              #   @param filter [::String]
              #     Optional. An expression for filtering the results of the ListDataScanJobs
              #     request.
              #
              #     If unspecified, all datascan jobs will be returned. Multiple filters can be
              #     applied (with `AND`, `OR` logical operators). Filters are case-sensitive.
              #
              #     Allowed fields are:
              #
              #     - `start_time`
              #     - `end_time`
              #
              #     `start_time` and `end_time` expect RFC-3339 formatted strings (e.g.
              #     2018-10-08T18:30:00-07:00).
              #
              #     For instance, 'start_time > 2018-10-08T00:00:00.123456789Z AND end_time <
              #     2018-10-09T00:00:00.123456789Z' limits results to DataScanJobs between
              #     specified start and end times.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dataplex::V1::DataScanJob>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dataplex::V1::DataScanJob>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::DataScanService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::ListDataScanJobsRequest.new
              #
              #   # Call the list_data_scan_jobs method.
              #   result = client.list_data_scan_jobs request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Dataplex::V1::DataScanJob.
              #     p item
              #   end
              #
              def list_data_scan_jobs request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::ListDataScanJobsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_data_scan_jobs.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_data_scan_jobs.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_data_scan_jobs.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_scan_service_stub.list_data_scan_jobs request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @data_scan_service_stub, :list_data_scan_jobs, "data_scan_jobs", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Generates recommended data quality rules based on the results of a data
              # profiling scan.
              #
              # Use the recommendations to build rules for a data quality scan.
              #
              # @overload generate_data_quality_rules(request, options = nil)
              #   Pass arguments to `generate_data_quality_rules` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::GenerateDataQualityRulesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::GenerateDataQualityRulesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload generate_data_quality_rules(name: nil)
              #   Pass arguments to `generate_data_quality_rules` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name must be one of the following:
              #
              #     * The name of a data scan with at least one successful, completed data
              #     profiling job
              #     * The name of a successful, completed data profiling job (a data scan job
              #     where the job type is data profiling)
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dataplex::V1::GenerateDataQualityRulesResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dataplex::V1::GenerateDataQualityRulesResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::DataScanService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::GenerateDataQualityRulesRequest.new
              #
              #   # Call the generate_data_quality_rules method.
              #   result = client.generate_data_quality_rules request
              #
              #   # The returned object is of type Google::Cloud::Dataplex::V1::GenerateDataQualityRulesResponse.
              #   p result
              #
              def generate_data_quality_rules request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::GenerateDataQualityRulesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.generate_data_quality_rules.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.generate_data_quality_rules.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.generate_data_quality_rules.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @data_scan_service_stub.generate_data_quality_rules request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the DataScanService REST API.
              #
              # This class represents the configuration for DataScanService REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::Dataplex::V1::DataScanService::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # create_data_scan to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::Dataplex::V1::DataScanService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_data_scan.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::Dataplex::V1::DataScanService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_data_scan.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "dataplex.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil

                # @private
                # Overrides for http bindings for the RPCs of this service
                # are only used when this service is used as mixin, and only
                # by the host service.
                # @return [::Hash{::Symbol=>::Array<::Gapic::Rest::GrpcTranscoder::HttpBinding>}]
                config_attr :bindings_override, {}, ::Hash, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the DataScanService API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `create_data_scan`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_data_scan
                  ##
                  # RPC-specific configuration for `update_data_scan`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_data_scan
                  ##
                  # RPC-specific configuration for `delete_data_scan`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_data_scan
                  ##
                  # RPC-specific configuration for `get_data_scan`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_data_scan
                  ##
                  # RPC-specific configuration for `list_data_scans`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_data_scans
                  ##
                  # RPC-specific configuration for `run_data_scan`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :run_data_scan
                  ##
                  # RPC-specific configuration for `get_data_scan_job`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_data_scan_job
                  ##
                  # RPC-specific configuration for `list_data_scan_jobs`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_data_scan_jobs
                  ##
                  # RPC-specific configuration for `generate_data_quality_rules`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :generate_data_quality_rules

                  # @private
                  def initialize parent_rpcs = nil
                    create_data_scan_config = parent_rpcs.create_data_scan if parent_rpcs.respond_to? :create_data_scan
                    @create_data_scan = ::Gapic::Config::Method.new create_data_scan_config
                    update_data_scan_config = parent_rpcs.update_data_scan if parent_rpcs.respond_to? :update_data_scan
                    @update_data_scan = ::Gapic::Config::Method.new update_data_scan_config
                    delete_data_scan_config = parent_rpcs.delete_data_scan if parent_rpcs.respond_to? :delete_data_scan
                    @delete_data_scan = ::Gapic::Config::Method.new delete_data_scan_config
                    get_data_scan_config = parent_rpcs.get_data_scan if parent_rpcs.respond_to? :get_data_scan
                    @get_data_scan = ::Gapic::Config::Method.new get_data_scan_config
                    list_data_scans_config = parent_rpcs.list_data_scans if parent_rpcs.respond_to? :list_data_scans
                    @list_data_scans = ::Gapic::Config::Method.new list_data_scans_config
                    run_data_scan_config = parent_rpcs.run_data_scan if parent_rpcs.respond_to? :run_data_scan
                    @run_data_scan = ::Gapic::Config::Method.new run_data_scan_config
                    get_data_scan_job_config = parent_rpcs.get_data_scan_job if parent_rpcs.respond_to? :get_data_scan_job
                    @get_data_scan_job = ::Gapic::Config::Method.new get_data_scan_job_config
                    list_data_scan_jobs_config = parent_rpcs.list_data_scan_jobs if parent_rpcs.respond_to? :list_data_scan_jobs
                    @list_data_scan_jobs = ::Gapic::Config::Method.new list_data_scan_jobs_config
                    generate_data_quality_rules_config = parent_rpcs.generate_data_quality_rules if parent_rpcs.respond_to? :generate_data_quality_rules
                    @generate_data_quality_rules = ::Gapic::Config::Method.new generate_data_quality_rules_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
