# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/dataplex/v1/content_pb"
require "google/cloud/dataplex/v1/content_service/rest/service_stub"
require "google/cloud/location/rest"
require "google/iam/v1/rest"

module Google
  module Cloud
    module Dataplex
      module V1
        module ContentService
          module Rest
            ##
            # REST client for the ContentService service.
            #
            # ContentService manages Notebook and SQL Scripts for Dataplex Universal
            # Catalog.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "dataplex.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :content_service_stub

              ##
              # Configure the ContentService Client class.
              #
              # See {::Google::Cloud::Dataplex::V1::ContentService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all ContentService clients
              #   ::Google::Cloud::Dataplex::V1::ContentService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "Dataplex", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.rpcs.create_content.timeout = 60.0

                  default_config.rpcs.update_content.timeout = 60.0

                  default_config.rpcs.delete_content.timeout = 60.0

                  default_config.rpcs.get_content.timeout = 60.0
                  default_config.rpcs.get_content.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_iam_policy.timeout = 60.0
                  default_config.rpcs.get_iam_policy.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.set_iam_policy.timeout = 60.0

                  default_config.rpcs.test_iam_permissions.timeout = 60.0
                  default_config.rpcs.test_iam_permissions.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.list_content.timeout = 60.0
                  default_config.rpcs.list_content.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the ContentService Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::Dataplex::V1::ContentService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @content_service_stub.universe_domain
              end

              ##
              # Create a new ContentService REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::Dataplex::V1::ContentService::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::Dataplex::V1::ContentService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the ContentService client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @content_service_stub = ::Google::Cloud::Dataplex::V1::ContentService::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @content_service_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @content_service_stub.endpoint
                  config.universe_domain = @content_service_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @content_service_stub.logger if config.respond_to? :logger=
                end

                @iam_policy_client = Google::Iam::V1::IAMPolicy::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @content_service_stub.endpoint
                  config.universe_domain = @content_service_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @content_service_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Rest::Client]
              #
              attr_reader :location_client

              ##
              # Get the associated client for mix-in of the IAMPolicy.
              #
              # @return [Google::Iam::V1::IAMPolicy::Rest::Client]
              #
              attr_reader :iam_policy_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @content_service_stub.logger
              end

              # Service calls

              ##
              # Create a content.
              #
              # @overload create_content(request, options = nil)
              #   Pass arguments to `create_content` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::CreateContentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::CreateContentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_content(parent: nil, content: nil, validate_only: nil)
              #   Pass arguments to `create_content` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the parent lake:
              #     projects/\\{project_id}/locations/\\{location_id}/lakes/\\{lake_id}
              #   @param content [::Google::Cloud::Dataplex::V1::Content, ::Hash]
              #     Required. Content resource.
              #   @param validate_only [::Boolean]
              #     Optional. Only validate the request, but do not perform mutations.
              #     The default is false.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dataplex::V1::Content]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dataplex::V1::Content]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::ContentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::CreateContentRequest.new
              #
              #   # Call the create_content method.
              #   result = client.create_content request
              #
              #   # The returned object is of type Google::Cloud::Dataplex::V1::Content.
              #   p result
              #
              def create_content request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::CreateContentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_content.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_content.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_content.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @content_service_stub.create_content request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Update a content. Only supports full resource update.
              #
              # @overload update_content(request, options = nil)
              #   Pass arguments to `update_content` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::UpdateContentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::UpdateContentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_content(update_mask: nil, content: nil, validate_only: nil)
              #   Pass arguments to `update_content` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. Mask of fields to update.
              #   @param content [::Google::Cloud::Dataplex::V1::Content, ::Hash]
              #     Required. Update description.
              #     Only fields specified in `update_mask` are updated.
              #   @param validate_only [::Boolean]
              #     Optional. Only validate the request, but do not perform mutations.
              #     The default is false.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dataplex::V1::Content]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dataplex::V1::Content]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::ContentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::UpdateContentRequest.new
              #
              #   # Call the update_content method.
              #   result = client.update_content request
              #
              #   # The returned object is of type Google::Cloud::Dataplex::V1::Content.
              #   p result
              #
              def update_content request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::UpdateContentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_content.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_content.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_content.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @content_service_stub.update_content request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Delete a content.
              #
              # @overload delete_content(request, options = nil)
              #   Pass arguments to `delete_content` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::DeleteContentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::DeleteContentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_content(name: nil)
              #   Pass arguments to `delete_content` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the content:
              #     projects/\\{project_id}/locations/\\{location_id}/lakes/\\{lake_id}/content/\\{content_id}
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::ContentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::DeleteContentRequest.new
              #
              #   # Call the delete_content method.
              #   result = client.delete_content request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_content request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::DeleteContentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_content.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_content.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_content.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @content_service_stub.delete_content request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Get a content resource.
              #
              # @overload get_content(request, options = nil)
              #   Pass arguments to `get_content` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::GetContentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::GetContentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_content(name: nil, view: nil)
              #   Pass arguments to `get_content` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the content:
              #     projects/\\{project_id}/locations/\\{location_id}/lakes/\\{lake_id}/content/\\{content_id}
              #   @param view [::Google::Cloud::Dataplex::V1::GetContentRequest::ContentView]
              #     Optional. Specify content view to make a partial request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dataplex::V1::Content]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dataplex::V1::Content]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::ContentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::GetContentRequest.new
              #
              #   # Call the get_content method.
              #   result = client.get_content request
              #
              #   # The returned object is of type Google::Cloud::Dataplex::V1::Content.
              #   p result
              #
              def get_content request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::GetContentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_content.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_content.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_content.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @content_service_stub.get_content request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the access control policy for a contentitem resource. A `NOT_FOUND`
              # error is returned if the resource does not exist. An empty policy is
              # returned if the resource exists but does not have a policy set on it.
              #
              # Caller must have Google IAM `dataplex.content.getIamPolicy` permission
              # on the resource.
              #
              # @overload get_iam_policy(request, options = nil)
              #   Pass arguments to `get_iam_policy` via a request object, either of type
              #   {::Google::Iam::V1::GetIamPolicyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Iam::V1::GetIamPolicyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_iam_policy(resource: nil, options: nil)
              #   Pass arguments to `get_iam_policy` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param resource [::String]
              #     REQUIRED: The resource for which the policy is being requested.
              #     See the operation documentation for the appropriate value for this field.
              #   @param options [::Google::Iam::V1::GetPolicyOptions, ::Hash]
              #     OPTIONAL: A `GetPolicyOptions` object for specifying options to
              #     `GetIamPolicy`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Iam::V1::Policy]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Iam::V1::Policy]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::ContentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Iam::V1::GetIamPolicyRequest.new
              #
              #   # Call the get_iam_policy method.
              #   result = client.get_iam_policy request
              #
              #   # The returned object is of type Google::Iam::V1::Policy.
              #   p result
              #
              def get_iam_policy request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::GetIamPolicyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_iam_policy.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_iam_policy.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_iam_policy.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @content_service_stub.get_iam_policy request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Sets the access control policy on the specified contentitem resource.
              # Replaces any existing policy.
              #
              # Caller must have Google IAM `dataplex.content.setIamPolicy` permission
              # on the resource.
              #
              # @overload set_iam_policy(request, options = nil)
              #   Pass arguments to `set_iam_policy` via a request object, either of type
              #   {::Google::Iam::V1::SetIamPolicyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Iam::V1::SetIamPolicyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload set_iam_policy(resource: nil, policy: nil, update_mask: nil)
              #   Pass arguments to `set_iam_policy` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param resource [::String]
              #     REQUIRED: The resource for which the policy is being specified.
              #     See the operation documentation for the appropriate value for this field.
              #   @param policy [::Google::Iam::V1::Policy, ::Hash]
              #     REQUIRED: The complete policy to be applied to the `resource`. The size of
              #     the policy is limited to a few 10s of KB. An empty policy is a
              #     valid policy but certain Cloud Platform services (such as Projects)
              #     might reject them.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     OPTIONAL: A FieldMask specifying which fields of the policy to modify. Only
              #     the fields in the mask will be modified. If no mask is provided, the
              #     following default mask is used:
              #
              #     `paths: "bindings, etag"`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Iam::V1::Policy]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Iam::V1::Policy]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::ContentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Iam::V1::SetIamPolicyRequest.new
              #
              #   # Call the set_iam_policy method.
              #   result = client.set_iam_policy request
              #
              #   # The returned object is of type Google::Iam::V1::Policy.
              #   p result
              #
              def set_iam_policy request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::SetIamPolicyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.set_iam_policy.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.set_iam_policy.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.set_iam_policy.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @content_service_stub.set_iam_policy request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns the caller's permissions on a resource.
              # If the resource does not exist, an empty set of
              # permissions is returned (a `NOT_FOUND` error is not returned).
              #
              # A caller is not required to have Google IAM permission to make this
              # request.
              #
              # Note: This operation is designed to be used for building permission-aware
              # UIs and command-line tools, not for authorization checking. This operation
              # may "fail open" without warning.
              #
              # @overload test_iam_permissions(request, options = nil)
              #   Pass arguments to `test_iam_permissions` via a request object, either of type
              #   {::Google::Iam::V1::TestIamPermissionsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Iam::V1::TestIamPermissionsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload test_iam_permissions(resource: nil, permissions: nil)
              #   Pass arguments to `test_iam_permissions` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param resource [::String]
              #     REQUIRED: The resource for which the policy detail is being requested.
              #     See the operation documentation for the appropriate value for this field.
              #   @param permissions [::Array<::String>]
              #     The set of permissions to check for the `resource`. Permissions with
              #     wildcards (such as '*' or 'storage.*') are not allowed. For more
              #     information see
              #     [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Iam::V1::TestIamPermissionsResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Iam::V1::TestIamPermissionsResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::ContentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Iam::V1::TestIamPermissionsRequest.new
              #
              #   # Call the test_iam_permissions method.
              #   result = client.test_iam_permissions request
              #
              #   # The returned object is of type Google::Iam::V1::TestIamPermissionsResponse.
              #   p result
              #
              def test_iam_permissions request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::TestIamPermissionsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.test_iam_permissions.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.test_iam_permissions.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.test_iam_permissions.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @content_service_stub.test_iam_permissions request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # List content.
              #
              # @overload list_content(request, options = nil)
              #   Pass arguments to `list_content` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::ListContentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::ListContentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_content(parent: nil, page_size: nil, page_token: nil, filter: nil)
              #   Pass arguments to `list_content` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the parent lake:
              #     projects/\\{project_id}/locations/\\{location_id}/lakes/\\{lake_id}
              #   @param page_size [::Integer]
              #     Optional. Maximum number of content to return. The service may return fewer
              #     than this value. If unspecified, at most 10 content will be returned. The
              #     maximum value is 1000; values above 1000 will be coerced to 1000.
              #   @param page_token [::String]
              #     Optional. Page token received from a previous `ListContent` call. Provide
              #     this to retrieve the subsequent page. When paginating, all other parameters
              #     provided to `ListContent` must match the call that provided the page
              #     token.
              #   @param filter [::String]
              #     Optional. Filter request. Filters are case-sensitive.
              #     The following formats are supported:
              #
              #     labels.key1 = "value1"
              #     labels:key1
              #     type = "NOTEBOOK"
              #     type = "SQL_SCRIPT"
              #
              #     These restrictions can be coinjoined with AND, OR and NOT conjunctions.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dataplex::V1::Content>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dataplex::V1::Content>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::ContentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::ListContentRequest.new
              #
              #   # Call the list_content method.
              #   result = client.list_content request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Dataplex::V1::Content.
              #     p item
              #   end
              #
              def list_content request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::ListContentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_content.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_content.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_content.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @content_service_stub.list_content request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @content_service_stub, :list_content, "content", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the ContentService REST API.
              #
              # This class represents the configuration for ContentService REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::Dataplex::V1::ContentService::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # create_content to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::Dataplex::V1::ContentService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_content.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::Dataplex::V1::ContentService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_content.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "dataplex.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil

                # @private
                # Overrides for http bindings for the RPCs of this service
                # are only used when this service is used as mixin, and only
                # by the host service.
                # @return [::Hash{::Symbol=>::Array<::Gapic::Rest::GrpcTranscoder::HttpBinding>}]
                config_attr :bindings_override, {}, ::Hash, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the ContentService API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `create_content`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_content
                  ##
                  # RPC-specific configuration for `update_content`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_content
                  ##
                  # RPC-specific configuration for `delete_content`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_content
                  ##
                  # RPC-specific configuration for `get_content`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_content
                  ##
                  # RPC-specific configuration for `get_iam_policy`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_iam_policy
                  ##
                  # RPC-specific configuration for `set_iam_policy`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :set_iam_policy
                  ##
                  # RPC-specific configuration for `test_iam_permissions`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :test_iam_permissions
                  ##
                  # RPC-specific configuration for `list_content`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_content

                  # @private
                  def initialize parent_rpcs = nil
                    create_content_config = parent_rpcs.create_content if parent_rpcs.respond_to? :create_content
                    @create_content = ::Gapic::Config::Method.new create_content_config
                    update_content_config = parent_rpcs.update_content if parent_rpcs.respond_to? :update_content
                    @update_content = ::Gapic::Config::Method.new update_content_config
                    delete_content_config = parent_rpcs.delete_content if parent_rpcs.respond_to? :delete_content
                    @delete_content = ::Gapic::Config::Method.new delete_content_config
                    get_content_config = parent_rpcs.get_content if parent_rpcs.respond_to? :get_content
                    @get_content = ::Gapic::Config::Method.new get_content_config
                    get_iam_policy_config = parent_rpcs.get_iam_policy if parent_rpcs.respond_to? :get_iam_policy
                    @get_iam_policy = ::Gapic::Config::Method.new get_iam_policy_config
                    set_iam_policy_config = parent_rpcs.set_iam_policy if parent_rpcs.respond_to? :set_iam_policy
                    @set_iam_policy = ::Gapic::Config::Method.new set_iam_policy_config
                    test_iam_permissions_config = parent_rpcs.test_iam_permissions if parent_rpcs.respond_to? :test_iam_permissions
                    @test_iam_permissions = ::Gapic::Config::Method.new test_iam_permissions_config
                    list_content_config = parent_rpcs.list_content if parent_rpcs.respond_to? :list_content
                    @list_content = ::Gapic::Config::Method.new list_content_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
