# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Dataplex
      module V1
        module ContentService
          # Path helper methods for the ContentService API.
          module Paths
            ##
            # Create a fully-qualified Content resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/lakes/{lake}/content/{content}`
            #
            # @param project [String]
            # @param location [String]
            # @param lake [String]
            # @param content [String]
            #
            # @return [::String]
            def content_path project:, location:, lake:, content:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "lake cannot contain /" if lake.to_s.include? "/"

              "projects/#{project}/locations/#{location}/lakes/#{lake}/content/#{content}"
            end

            ##
            # Create a fully-qualified Lake resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/lakes/{lake}`
            #
            # @param project [String]
            # @param location [String]
            # @param lake [String]
            #
            # @return [::String]
            def lake_path project:, location:, lake:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/lakes/#{lake}"
            end

            extend self
          end
        end
      end
    end
  end
end
