# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Dataplex
      module V1
        module CatalogService
          # Path helper methods for the CatalogService API.
          module Paths
            ##
            # Create a fully-qualified AspectType resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/aspectTypes/{aspect_type}`
            #
            # @param project [String]
            # @param location [String]
            # @param aspect_type [String]
            #
            # @return [::String]
            def aspect_type_path project:, location:, aspect_type:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/aspectTypes/#{aspect_type}"
            end

            ##
            # Create a fully-qualified Entry resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/entryGroups/{entry_group}/entries/{entry}`
            #
            # @param project [String]
            # @param location [String]
            # @param entry_group [String]
            # @param entry [String]
            #
            # @return [::String]
            def entry_path project:, location:, entry_group:, entry:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "entry_group cannot contain /" if entry_group.to_s.include? "/"

              "projects/#{project}/locations/#{location}/entryGroups/#{entry_group}/entries/#{entry}"
            end

            ##
            # Create a fully-qualified EntryGroup resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/entryGroups/{entry_group}`
            #
            # @param project [String]
            # @param location [String]
            # @param entry_group [String]
            #
            # @return [::String]
            def entry_group_path project:, location:, entry_group:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/entryGroups/#{entry_group}"
            end

            ##
            # Create a fully-qualified EntryLink resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/entryGroups/{entry_group}/entryLinks/{entry_link}`
            #
            # @param project [String]
            # @param location [String]
            # @param entry_group [String]
            # @param entry_link [String]
            #
            # @return [::String]
            def entry_link_path project:, location:, entry_group:, entry_link:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "entry_group cannot contain /" if entry_group.to_s.include? "/"

              "projects/#{project}/locations/#{location}/entryGroups/#{entry_group}/entryLinks/#{entry_link}"
            end

            ##
            # Create a fully-qualified EntryType resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/entryTypes/{entry_type}`
            #
            # @param project [String]
            # @param location [String]
            # @param entry_type [String]
            #
            # @return [::String]
            def entry_type_path project:, location:, entry_type:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/entryTypes/#{entry_type}"
            end

            ##
            # Create a fully-qualified Glossary resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/glossaries/{glossary}`
            #
            # @param project [String]
            # @param location [String]
            # @param glossary [String]
            #
            # @return [::String]
            def glossary_path project:, location:, glossary:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/glossaries/#{glossary}"
            end

            ##
            # Create a fully-qualified Location resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}`
            #
            # @param project [String]
            # @param location [String]
            #
            # @return [::String]
            def location_path project:, location:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/locations/#{location}"
            end

            ##
            # Create a fully-qualified MetadataJob resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/metadataJobs/{metadata_job}`
            #
            # @param project [String]
            # @param location [String]
            # @param metadata_job [String]
            #
            # @return [::String]
            def metadata_job_path project:, location:, metadata_job:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/metadataJobs/#{metadata_job}"
            end

            ##
            # Create a fully-qualified Project resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}`
            #
            # @param project [String]
            #
            # @return [::String]
            def project_path project:
              "projects/#{project}"
            end

            extend self
          end
        end
      end
    end
  end
end
