# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/dataplex/v1/catalog_pb"
require "google/cloud/location"
require "google/iam/v1"

module Google
  module Cloud
    module Dataplex
      module V1
        module CatalogService
          ##
          # Client for the CatalogService service.
          #
          # The primary resources offered by this service are EntryGroups, EntryTypes,
          # AspectTypes, Entries and EntryLinks. They collectively let data
          # administrators organize, manage, secure, and catalog data located across
          # cloud projects in their organization in a variety of storage systems,
          # including Cloud Storage and BigQuery.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "dataplex.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :catalog_service_stub

            ##
            # Configure the CatalogService Client class.
            #
            # See {::Google::Cloud::Dataplex::V1::CatalogService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all CatalogService clients
            #   ::Google::Cloud::Dataplex::V1::CatalogService::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "Dataplex", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.rpcs.create_entry_type.timeout = 60.0

                default_config.rpcs.update_entry_type.timeout = 60.0

                default_config.rpcs.delete_entry_type.timeout = 60.0

                default_config.rpcs.list_entry_types.timeout = 60.0
                default_config.rpcs.list_entry_types.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 8]
                }

                default_config.rpcs.get_entry_type.timeout = 60.0
                default_config.rpcs.get_entry_type.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 8]
                }

                default_config.rpcs.create_aspect_type.timeout = 60.0

                default_config.rpcs.update_aspect_type.timeout = 60.0

                default_config.rpcs.delete_aspect_type.timeout = 60.0

                default_config.rpcs.list_aspect_types.timeout = 60.0
                default_config.rpcs.list_aspect_types.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 8]
                }

                default_config.rpcs.get_aspect_type.timeout = 60.0
                default_config.rpcs.get_aspect_type.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 8]
                }

                default_config.rpcs.create_entry_group.timeout = 60.0

                default_config.rpcs.update_entry_group.timeout = 60.0

                default_config.rpcs.delete_entry_group.timeout = 60.0

                default_config.rpcs.list_entry_groups.timeout = 60.0
                default_config.rpcs.list_entry_groups.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 8]
                }

                default_config.rpcs.get_entry_group.timeout = 60.0
                default_config.rpcs.get_entry_group.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 8]
                }

                default_config.rpcs.create_entry.timeout = 60.0

                default_config.rpcs.update_entry.timeout = 60.0
                default_config.rpcs.update_entry.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 8]
                }

                default_config.rpcs.delete_entry.timeout = 60.0

                default_config.rpcs.list_entries.timeout = 20.0
                default_config.rpcs.list_entries.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 8]
                }

                default_config.rpcs.get_entry.timeout = 20.0
                default_config.rpcs.get_entry.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 8]
                }

                default_config.rpcs.lookup_entry.timeout = 20.0
                default_config.rpcs.lookup_entry.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 8]
                }

                default_config.rpcs.search_entries.timeout = 60.0
                default_config.rpcs.search_entries.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 8]
                }

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the CatalogService Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::Dataplex::V1::CatalogService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @catalog_service_stub.universe_domain
            end

            ##
            # Create a new CatalogService client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::Dataplex::V1::CatalogService::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::Dataplex::V1::CatalogService::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the CatalogService client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/dataplex/v1/catalog_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @catalog_service_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::Dataplex::V1::CatalogService::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @catalog_service_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @location_client = Google::Cloud::Location::Locations::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @catalog_service_stub.endpoint
                config.universe_domain = @catalog_service_stub.universe_domain
                config.logger = @catalog_service_stub.logger if config.respond_to? :logger=
              end

              @iam_policy_client = Google::Iam::V1::IAMPolicy::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @catalog_service_stub.endpoint
                config.universe_domain = @catalog_service_stub.universe_domain
                config.logger = @catalog_service_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Cloud::Dataplex::V1::CatalogService::Operations]
            #
            attr_reader :operations_client

            ##
            # Get the associated client for mix-in of the Locations.
            #
            # @return [Google::Cloud::Location::Locations::Client]
            #
            attr_reader :location_client

            ##
            # Get the associated client for mix-in of the IAMPolicy.
            #
            # @return [Google::Iam::V1::IAMPolicy::Client]
            #
            attr_reader :iam_policy_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @catalog_service_stub.logger
            end

            # Service calls

            ##
            # Creates an EntryType.
            #
            # @overload create_entry_type(request, options = nil)
            #   Pass arguments to `create_entry_type` via a request object, either of type
            #   {::Google::Cloud::Dataplex::V1::CreateEntryTypeRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataplex::V1::CreateEntryTypeRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_entry_type(parent: nil, entry_type_id: nil, entry_type: nil, validate_only: nil)
            #   Pass arguments to `create_entry_type` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the EntryType, of the form:
            #     projects/\\{project_number}/locations/\\{location_id}
            #     where `location_id` refers to a Google Cloud region.
            #   @param entry_type_id [::String]
            #     Required. EntryType identifier.
            #   @param entry_type [::Google::Cloud::Dataplex::V1::EntryType, ::Hash]
            #     Required. EntryType Resource.
            #   @param validate_only [::Boolean]
            #     Optional. The service validates the request without performing any
            #     mutations. The default is false.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataplex/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataplex::V1::CatalogService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataplex::V1::CreateEntryTypeRequest.new
            #
            #   # Call the create_entry_type method.
            #   result = client.create_entry_type request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_entry_type request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::CreateEntryTypeRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_entry_type.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataplex::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_entry_type.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_entry_type.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @catalog_service_stub.call_rpc :create_entry_type, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates an EntryType.
            #
            # @overload update_entry_type(request, options = nil)
            #   Pass arguments to `update_entry_type` via a request object, either of type
            #   {::Google::Cloud::Dataplex::V1::UpdateEntryTypeRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataplex::V1::UpdateEntryTypeRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_entry_type(entry_type: nil, update_mask: nil, validate_only: nil)
            #   Pass arguments to `update_entry_type` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param entry_type [::Google::Cloud::Dataplex::V1::EntryType, ::Hash]
            #     Required. EntryType Resource.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. Mask of fields to update.
            #   @param validate_only [::Boolean]
            #     Optional. The service validates the request without performing any
            #     mutations. The default is false.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataplex/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataplex::V1::CatalogService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataplex::V1::UpdateEntryTypeRequest.new
            #
            #   # Call the update_entry_type method.
            #   result = client.update_entry_type request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_entry_type request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::UpdateEntryTypeRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_entry_type.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataplex::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.entry_type&.name
                header_params["entry_type.name"] = request.entry_type.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_entry_type.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_entry_type.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @catalog_service_stub.call_rpc :update_entry_type, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes an EntryType.
            #
            # @overload delete_entry_type(request, options = nil)
            #   Pass arguments to `delete_entry_type` via a request object, either of type
            #   {::Google::Cloud::Dataplex::V1::DeleteEntryTypeRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataplex::V1::DeleteEntryTypeRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_entry_type(name: nil, etag: nil)
            #   Pass arguments to `delete_entry_type` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the EntryType:
            #     `projects/{project_number}/locations/{location_id}/entryTypes/{entry_type_id}`.
            #   @param etag [::String]
            #     Optional. If the client provided etag value does not match the current etag
            #     value, the DeleteEntryTypeRequest method returns an ABORTED error response.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataplex/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataplex::V1::CatalogService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataplex::V1::DeleteEntryTypeRequest.new
            #
            #   # Call the delete_entry_type method.
            #   result = client.delete_entry_type request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_entry_type request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::DeleteEntryTypeRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_entry_type.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataplex::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_entry_type.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_entry_type.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @catalog_service_stub.call_rpc :delete_entry_type, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists EntryType resources in a project and location.
            #
            # @overload list_entry_types(request, options = nil)
            #   Pass arguments to `list_entry_types` via a request object, either of type
            #   {::Google::Cloud::Dataplex::V1::ListEntryTypesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataplex::V1::ListEntryTypesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_entry_types(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_entry_types` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the EntryType location, of the form:
            #     `projects/{project_number}/locations/{location_id}`
            #     where `location_id` refers to a Google Cloud region.
            #   @param page_size [::Integer]
            #     Optional. Maximum number of EntryTypes to return. The service may return
            #     fewer than this value. If unspecified, the service returns at most 10
            #     EntryTypes. The maximum value is 1000; values above 1000 will be coerced to
            #     1000.
            #   @param page_token [::String]
            #     Optional. Page token received from a previous `ListEntryTypes` call.
            #     Provide this to retrieve the subsequent page. When paginating, all other
            #     parameters you provided to `ListEntryTypes` must match the call that
            #     provided the page token.
            #   @param filter [::String]
            #     Optional. Filter request. Filters are case-sensitive.
            #     The service supports the following formats:
            #
            #     * labels.key1 = "value1"
            #     * labels:key1
            #     * name = "value"
            #
            #     These restrictions can be conjoined with AND, OR, and NOT conjunctions.
            #   @param order_by [::String]
            #     Optional. Orders the result by `name` or `create_time` fields.
            #     If not specified, the ordering is undefined.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Dataplex::V1::EntryType>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Dataplex::V1::EntryType>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataplex/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataplex::V1::CatalogService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataplex::V1::ListEntryTypesRequest.new
            #
            #   # Call the list_entry_types method.
            #   result = client.list_entry_types request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Dataplex::V1::EntryType.
            #     p item
            #   end
            #
            def list_entry_types request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::ListEntryTypesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_entry_types.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataplex::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_entry_types.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_entry_types.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @catalog_service_stub.call_rpc :list_entry_types, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @catalog_service_stub, :list_entry_types, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets an EntryType.
            #
            # @overload get_entry_type(request, options = nil)
            #   Pass arguments to `get_entry_type` via a request object, either of type
            #   {::Google::Cloud::Dataplex::V1::GetEntryTypeRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataplex::V1::GetEntryTypeRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_entry_type(name: nil)
            #   Pass arguments to `get_entry_type` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the EntryType:
            #     `projects/{project_number}/locations/{location_id}/entryTypes/{entry_type_id}`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Dataplex::V1::EntryType]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Dataplex::V1::EntryType]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataplex/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataplex::V1::CatalogService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataplex::V1::GetEntryTypeRequest.new
            #
            #   # Call the get_entry_type method.
            #   result = client.get_entry_type request
            #
            #   # The returned object is of type Google::Cloud::Dataplex::V1::EntryType.
            #   p result
            #
            def get_entry_type request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::GetEntryTypeRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_entry_type.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataplex::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_entry_type.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_entry_type.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @catalog_service_stub.call_rpc :get_entry_type, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates an AspectType.
            #
            # @overload create_aspect_type(request, options = nil)
            #   Pass arguments to `create_aspect_type` via a request object, either of type
            #   {::Google::Cloud::Dataplex::V1::CreateAspectTypeRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataplex::V1::CreateAspectTypeRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_aspect_type(parent: nil, aspect_type_id: nil, aspect_type: nil, validate_only: nil)
            #   Pass arguments to `create_aspect_type` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the AspectType, of the form:
            #     projects/\\{project_number}/locations/\\{location_id}
            #     where `location_id` refers to a Google Cloud region.
            #   @param aspect_type_id [::String]
            #     Required. AspectType identifier.
            #   @param aspect_type [::Google::Cloud::Dataplex::V1::AspectType, ::Hash]
            #     Required. AspectType Resource.
            #   @param validate_only [::Boolean]
            #     Optional. The service validates the request without performing any
            #     mutations. The default is false.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataplex/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataplex::V1::CatalogService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataplex::V1::CreateAspectTypeRequest.new
            #
            #   # Call the create_aspect_type method.
            #   result = client.create_aspect_type request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_aspect_type request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::CreateAspectTypeRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_aspect_type.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataplex::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_aspect_type.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_aspect_type.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @catalog_service_stub.call_rpc :create_aspect_type, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates an AspectType.
            #
            # @overload update_aspect_type(request, options = nil)
            #   Pass arguments to `update_aspect_type` via a request object, either of type
            #   {::Google::Cloud::Dataplex::V1::UpdateAspectTypeRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataplex::V1::UpdateAspectTypeRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_aspect_type(aspect_type: nil, update_mask: nil, validate_only: nil)
            #   Pass arguments to `update_aspect_type` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param aspect_type [::Google::Cloud::Dataplex::V1::AspectType, ::Hash]
            #     Required. AspectType Resource
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. Mask of fields to update.
            #   @param validate_only [::Boolean]
            #     Optional. Only validate the request, but do not perform mutations.
            #     The default is false.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataplex/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataplex::V1::CatalogService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataplex::V1::UpdateAspectTypeRequest.new
            #
            #   # Call the update_aspect_type method.
            #   result = client.update_aspect_type request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_aspect_type request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::UpdateAspectTypeRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_aspect_type.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataplex::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.aspect_type&.name
                header_params["aspect_type.name"] = request.aspect_type.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_aspect_type.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_aspect_type.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @catalog_service_stub.call_rpc :update_aspect_type, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes an AspectType.
            #
            # @overload delete_aspect_type(request, options = nil)
            #   Pass arguments to `delete_aspect_type` via a request object, either of type
            #   {::Google::Cloud::Dataplex::V1::DeleteAspectTypeRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataplex::V1::DeleteAspectTypeRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_aspect_type(name: nil, etag: nil)
            #   Pass arguments to `delete_aspect_type` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the AspectType:
            #     `projects/{project_number}/locations/{location_id}/aspectTypes/{aspect_type_id}`.
            #   @param etag [::String]
            #     Optional. If the client provided etag value does not match the current etag
            #     value, the DeleteAspectTypeRequest method returns an ABORTED error
            #     response.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataplex/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataplex::V1::CatalogService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataplex::V1::DeleteAspectTypeRequest.new
            #
            #   # Call the delete_aspect_type method.
            #   result = client.delete_aspect_type request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_aspect_type request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::DeleteAspectTypeRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_aspect_type.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataplex::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_aspect_type.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_aspect_type.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @catalog_service_stub.call_rpc :delete_aspect_type, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists AspectType resources in a project and location.
            #
            # @overload list_aspect_types(request, options = nil)
            #   Pass arguments to `list_aspect_types` via a request object, either of type
            #   {::Google::Cloud::Dataplex::V1::ListAspectTypesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataplex::V1::ListAspectTypesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_aspect_types(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_aspect_types` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the AspectType location, of the form:
            #     `projects/{project_number}/locations/{location_id}`
            #     where `location_id` refers to a Google Cloud region.
            #   @param page_size [::Integer]
            #     Optional. Maximum number of AspectTypes to return. The service may return
            #     fewer than this value. If unspecified, the service returns at most 10
            #     AspectTypes. The maximum value is 1000; values above 1000 will be coerced
            #     to 1000.
            #   @param page_token [::String]
            #     Optional. Page token received from a previous `ListAspectTypes` call.
            #     Provide this to retrieve the subsequent page. When paginating, all other
            #     parameters you provide to `ListAspectTypes` must match the call that
            #     provided the page token.
            #   @param filter [::String]
            #     Optional. Filter request. Filters are case-sensitive.
            #     The service supports the following formats:
            #
            #     * labels.key1 = "value1"
            #     * labels:key1
            #     * name = "value"
            #
            #     These restrictions can be conjoined with AND, OR, and NOT conjunctions.
            #   @param order_by [::String]
            #     Optional. Orders the result by `name` or `create_time` fields.
            #     If not specified, the ordering is undefined.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Dataplex::V1::AspectType>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Dataplex::V1::AspectType>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataplex/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataplex::V1::CatalogService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataplex::V1::ListAspectTypesRequest.new
            #
            #   # Call the list_aspect_types method.
            #   result = client.list_aspect_types request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Dataplex::V1::AspectType.
            #     p item
            #   end
            #
            def list_aspect_types request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::ListAspectTypesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_aspect_types.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataplex::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_aspect_types.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_aspect_types.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @catalog_service_stub.call_rpc :list_aspect_types, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @catalog_service_stub, :list_aspect_types, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets an AspectType.
            #
            # @overload get_aspect_type(request, options = nil)
            #   Pass arguments to `get_aspect_type` via a request object, either of type
            #   {::Google::Cloud::Dataplex::V1::GetAspectTypeRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataplex::V1::GetAspectTypeRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_aspect_type(name: nil)
            #   Pass arguments to `get_aspect_type` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the AspectType:
            #     `projects/{project_number}/locations/{location_id}/aspectTypes/{aspect_type_id}`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Dataplex::V1::AspectType]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Dataplex::V1::AspectType]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataplex/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataplex::V1::CatalogService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataplex::V1::GetAspectTypeRequest.new
            #
            #   # Call the get_aspect_type method.
            #   result = client.get_aspect_type request
            #
            #   # The returned object is of type Google::Cloud::Dataplex::V1::AspectType.
            #   p result
            #
            def get_aspect_type request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::GetAspectTypeRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_aspect_type.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataplex::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_aspect_type.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_aspect_type.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @catalog_service_stub.call_rpc :get_aspect_type, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates an EntryGroup.
            #
            # @overload create_entry_group(request, options = nil)
            #   Pass arguments to `create_entry_group` via a request object, either of type
            #   {::Google::Cloud::Dataplex::V1::CreateEntryGroupRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataplex::V1::CreateEntryGroupRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_entry_group(parent: nil, entry_group_id: nil, entry_group: nil, validate_only: nil)
            #   Pass arguments to `create_entry_group` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the entryGroup, of the form:
            #     projects/\\{project_number}/locations/\\{location_id}
            #     where `location_id` refers to a Google Cloud region.
            #   @param entry_group_id [::String]
            #     Required. EntryGroup identifier.
            #   @param entry_group [::Google::Cloud::Dataplex::V1::EntryGroup, ::Hash]
            #     Required. EntryGroup Resource.
            #   @param validate_only [::Boolean]
            #     Optional. The service validates the request without performing any
            #     mutations. The default is false.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataplex/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataplex::V1::CatalogService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataplex::V1::CreateEntryGroupRequest.new
            #
            #   # Call the create_entry_group method.
            #   result = client.create_entry_group request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_entry_group request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::CreateEntryGroupRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_entry_group.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataplex::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_entry_group.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_entry_group.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @catalog_service_stub.call_rpc :create_entry_group, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates an EntryGroup.
            #
            # @overload update_entry_group(request, options = nil)
            #   Pass arguments to `update_entry_group` via a request object, either of type
            #   {::Google::Cloud::Dataplex::V1::UpdateEntryGroupRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataplex::V1::UpdateEntryGroupRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_entry_group(entry_group: nil, update_mask: nil, validate_only: nil)
            #   Pass arguments to `update_entry_group` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param entry_group [::Google::Cloud::Dataplex::V1::EntryGroup, ::Hash]
            #     Required. EntryGroup Resource.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. Mask of fields to update.
            #   @param validate_only [::Boolean]
            #     Optional. The service validates the request, without performing any
            #     mutations. The default is false.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataplex/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataplex::V1::CatalogService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataplex::V1::UpdateEntryGroupRequest.new
            #
            #   # Call the update_entry_group method.
            #   result = client.update_entry_group request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_entry_group request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::UpdateEntryGroupRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_entry_group.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataplex::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.entry_group&.name
                header_params["entry_group.name"] = request.entry_group.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_entry_group.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_entry_group.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @catalog_service_stub.call_rpc :update_entry_group, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes an EntryGroup.
            #
            # @overload delete_entry_group(request, options = nil)
            #   Pass arguments to `delete_entry_group` via a request object, either of type
            #   {::Google::Cloud::Dataplex::V1::DeleteEntryGroupRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataplex::V1::DeleteEntryGroupRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_entry_group(name: nil, etag: nil)
            #   Pass arguments to `delete_entry_group` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the EntryGroup:
            #     `projects/{project_number}/locations/{location_id}/entryGroups/{entry_group_id}`.
            #   @param etag [::String]
            #     Optional. If the client provided etag value does not match the current etag
            #     value, the DeleteEntryGroupRequest method returns an ABORTED error
            #     response.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataplex/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataplex::V1::CatalogService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataplex::V1::DeleteEntryGroupRequest.new
            #
            #   # Call the delete_entry_group method.
            #   result = client.delete_entry_group request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_entry_group request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::DeleteEntryGroupRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_entry_group.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataplex::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_entry_group.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_entry_group.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @catalog_service_stub.call_rpc :delete_entry_group, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists EntryGroup resources in a project and location.
            #
            # @overload list_entry_groups(request, options = nil)
            #   Pass arguments to `list_entry_groups` via a request object, either of type
            #   {::Google::Cloud::Dataplex::V1::ListEntryGroupsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataplex::V1::ListEntryGroupsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_entry_groups(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_entry_groups` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the entryGroup location, of the form:
            #     `projects/{project_number}/locations/{location_id}`
            #     where `location_id` refers to a Google Cloud region.
            #   @param page_size [::Integer]
            #     Optional. Maximum number of EntryGroups to return. The service may return
            #     fewer than this value. If unspecified, the service returns at most 10
            #     EntryGroups. The maximum value is 1000; values above 1000 will be coerced
            #     to 1000.
            #   @param page_token [::String]
            #     Optional. Page token received from a previous `ListEntryGroups` call.
            #     Provide this to retrieve the subsequent page. When paginating, all other
            #     parameters you provide to `ListEntryGroups` must match the call that
            #     provided the page token.
            #   @param filter [::String]
            #     Optional. Filter request.
            #   @param order_by [::String]
            #     Optional. Order by fields for the result.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Dataplex::V1::EntryGroup>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Dataplex::V1::EntryGroup>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataplex/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataplex::V1::CatalogService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataplex::V1::ListEntryGroupsRequest.new
            #
            #   # Call the list_entry_groups method.
            #   result = client.list_entry_groups request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Dataplex::V1::EntryGroup.
            #     p item
            #   end
            #
            def list_entry_groups request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::ListEntryGroupsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_entry_groups.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataplex::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_entry_groups.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_entry_groups.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @catalog_service_stub.call_rpc :list_entry_groups, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @catalog_service_stub, :list_entry_groups, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets an EntryGroup.
            #
            # @overload get_entry_group(request, options = nil)
            #   Pass arguments to `get_entry_group` via a request object, either of type
            #   {::Google::Cloud::Dataplex::V1::GetEntryGroupRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataplex::V1::GetEntryGroupRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_entry_group(name: nil)
            #   Pass arguments to `get_entry_group` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the EntryGroup:
            #     `projects/{project_number}/locations/{location_id}/entryGroups/{entry_group_id}`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Dataplex::V1::EntryGroup]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Dataplex::V1::EntryGroup]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataplex/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataplex::V1::CatalogService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataplex::V1::GetEntryGroupRequest.new
            #
            #   # Call the get_entry_group method.
            #   result = client.get_entry_group request
            #
            #   # The returned object is of type Google::Cloud::Dataplex::V1::EntryGroup.
            #   p result
            #
            def get_entry_group request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::GetEntryGroupRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_entry_group.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataplex::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_entry_group.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_entry_group.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @catalog_service_stub.call_rpc :get_entry_group, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates an Entry.
            #
            # @overload create_entry(request, options = nil)
            #   Pass arguments to `create_entry` via a request object, either of type
            #   {::Google::Cloud::Dataplex::V1::CreateEntryRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataplex::V1::CreateEntryRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_entry(parent: nil, entry_id: nil, entry: nil)
            #   Pass arguments to `create_entry` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the parent Entry Group:
            #     `projects/{project}/locations/{location}/entryGroups/{entry_group}`.
            #   @param entry_id [::String]
            #     Required. Entry identifier. It has to be unique within an Entry Group.
            #
            #     Entries corresponding to Google Cloud resources use an Entry ID format
            #     based on [full resource
            #     names](https://cloud.google.com/apis/design/resource_names#full_resource_name).
            #     The format is a full resource name of the resource without the
            #     prefix double slashes in the API service name part of the full resource
            #     name. This allows retrieval of entries using their associated resource
            #     name.
            #
            #     For example, if the full resource name of a resource is
            #     `//library.googleapis.com/shelves/shelf1/books/book2`,
            #     then the suggested entry_id is
            #     `library.googleapis.com/shelves/shelf1/books/book2`.
            #
            #     It is also suggested to follow the same convention for entries
            #     corresponding to resources from providers or systems other than Google
            #     Cloud.
            #
            #     The maximum size of the field is 4000 characters.
            #   @param entry [::Google::Cloud::Dataplex::V1::Entry, ::Hash]
            #     Required. Entry resource.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Dataplex::V1::Entry]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Dataplex::V1::Entry]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataplex/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataplex::V1::CatalogService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataplex::V1::CreateEntryRequest.new
            #
            #   # Call the create_entry method.
            #   result = client.create_entry request
            #
            #   # The returned object is of type Google::Cloud::Dataplex::V1::Entry.
            #   p result
            #
            def create_entry request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::CreateEntryRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_entry.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataplex::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_entry.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_entry.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @catalog_service_stub.call_rpc :create_entry, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates an Entry.
            #
            # @overload update_entry(request, options = nil)
            #   Pass arguments to `update_entry` via a request object, either of type
            #   {::Google::Cloud::Dataplex::V1::UpdateEntryRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataplex::V1::UpdateEntryRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_entry(entry: nil, update_mask: nil, allow_missing: nil, delete_missing_aspects: nil, aspect_keys: nil)
            #   Pass arguments to `update_entry` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param entry [::Google::Cloud::Dataplex::V1::Entry, ::Hash]
            #     Required. Entry resource.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Optional. Mask of fields to update. To update Aspects, the update_mask must
            #     contain the value "aspects".
            #
            #     If the update_mask is empty, the service will update all modifiable fields
            #     present in the request.
            #   @param allow_missing [::Boolean]
            #     Optional. If set to true and the entry doesn't exist, the service will
            #     create it.
            #   @param delete_missing_aspects [::Boolean]
            #     Optional. If set to true and the aspect_keys specify aspect ranges, the
            #     service deletes any existing aspects from that range that weren't provided
            #     in the request.
            #   @param aspect_keys [::Array<::String>]
            #     Optional. The map keys of the Aspects which the service should modify. It
            #     supports the following syntaxes:
            #
            #     * `<aspect_type_reference>` - matches an aspect of the given type and empty
            #     path.
            #     * `<aspect_type_reference>@path` - matches an aspect of the given type and
            #     specified path. For example, to attach an aspect to a field that is
            #     specified by the `schema` aspect, the path should have the format
            #     `Schema.<field_name>`.
            #     * `<aspect_type_reference>@*` - matches aspects of the given type for all
            #     paths.
            #     * `*@path` - matches aspects of all types on the given path.
            #
            #     The service will not remove existing aspects matching the syntax unless
            #     `delete_missing_aspects` is set to true.
            #
            #     If this field is left empty, the service treats it as specifying
            #     exactly those Aspects present in the request.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Dataplex::V1::Entry]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Dataplex::V1::Entry]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataplex/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataplex::V1::CatalogService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataplex::V1::UpdateEntryRequest.new
            #
            #   # Call the update_entry method.
            #   result = client.update_entry request
            #
            #   # The returned object is of type Google::Cloud::Dataplex::V1::Entry.
            #   p result
            #
            def update_entry request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::UpdateEntryRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_entry.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataplex::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.entry&.name
                header_params["entry.name"] = request.entry.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_entry.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_entry.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @catalog_service_stub.call_rpc :update_entry, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes an Entry.
            #
            # @overload delete_entry(request, options = nil)
            #   Pass arguments to `delete_entry` via a request object, either of type
            #   {::Google::Cloud::Dataplex::V1::DeleteEntryRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataplex::V1::DeleteEntryRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_entry(name: nil)
            #   Pass arguments to `delete_entry` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the Entry:
            #     `projects/{project}/locations/{location}/entryGroups/{entry_group}/entries/{entry}`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Dataplex::V1::Entry]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Dataplex::V1::Entry]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataplex/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataplex::V1::CatalogService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataplex::V1::DeleteEntryRequest.new
            #
            #   # Call the delete_entry method.
            #   result = client.delete_entry request
            #
            #   # The returned object is of type Google::Cloud::Dataplex::V1::Entry.
            #   p result
            #
            def delete_entry request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::DeleteEntryRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_entry.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataplex::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_entry.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_entry.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @catalog_service_stub.call_rpc :delete_entry, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists Entries within an EntryGroup.
            # Caution: The Vertex AI, Bigtable, Spanner, Pub/Sub, Dataform, and Dataproc
            # Metastore metadata that is stored in Dataplex Universal Catalog is
            # changing. For more information, see [Changes to metadata stored in
            # Dataplex Universal
            # Catalog](https://cloud.google.com/dataplex/docs/metadata-changes).
            #
            # @overload list_entries(request, options = nil)
            #   Pass arguments to `list_entries` via a request object, either of type
            #   {::Google::Cloud::Dataplex::V1::ListEntriesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataplex::V1::ListEntriesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_entries(parent: nil, page_size: nil, page_token: nil, filter: nil)
            #   Pass arguments to `list_entries` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the parent Entry Group:
            #     `projects/{project}/locations/{location}/entryGroups/{entry_group}`.
            #   @param page_size [::Integer]
            #     Optional. Number of items to return per page. If there are remaining
            #     results, the service returns a next_page_token. If unspecified, the service
            #     returns at most 10 Entries. The maximum value is 100; values above 100 will
            #     be coerced to 100.
            #   @param page_token [::String]
            #     Optional. Page token received from a previous `ListEntries` call. Provide
            #     this to retrieve the subsequent page.
            #   @param filter [::String]
            #     Optional. A filter on the entries to return. Filters are case-sensitive.
            #     You can filter the request by the following fields:
            #
            #     * entry_type
            #     * entry_source.display_name
            #     * parent_entry
            #
            #     The comparison operators are =, !=, <, >, <=, >=. The service compares
            #     strings according to lexical order.
            #
            #     You can use the logical operators AND, OR, NOT in the filter.
            #
            #     You can use Wildcard "*", but for entry_type and parent_entry you need to
            #     provide the full project id or number.
            #
            #     You cannot use parent_entry in conjunction with other fields.
            #
            #     Example filter expressions:
            #
            #     * "entry_source.display_name=AnExampleDisplayName"
            #     * "entry_type=projects/example-project/locations/global/entryTypes/example-entry_type"
            #     * "entry_type=projects/example-project/locations/us/entryTypes/a* OR
            #     entry_type=projects/another-project/locations/*"
            #     * "NOT entry_source.display_name=AnotherExampleDisplayName"
            #     * "parent_entry=projects/example-project/locations/us/entryGroups/example-entry-group/entries/example-entry"
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Dataplex::V1::Entry>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Dataplex::V1::Entry>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataplex/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataplex::V1::CatalogService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataplex::V1::ListEntriesRequest.new
            #
            #   # Call the list_entries method.
            #   result = client.list_entries request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Dataplex::V1::Entry.
            #     p item
            #   end
            #
            def list_entries request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::ListEntriesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_entries.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataplex::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_entries.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_entries.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @catalog_service_stub.call_rpc :list_entries, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @catalog_service_stub, :list_entries, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets an Entry.
            # Caution: The Vertex AI, Bigtable, Spanner, Pub/Sub, Dataform, and Dataproc
            # Metastore metadata that is stored in Dataplex Universal Catalog is
            # changing. For more information, see [Changes to metadata stored in
            # Dataplex Universal
            # Catalog](https://cloud.google.com/dataplex/docs/metadata-changes).
            #
            # @overload get_entry(request, options = nil)
            #   Pass arguments to `get_entry` via a request object, either of type
            #   {::Google::Cloud::Dataplex::V1::GetEntryRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataplex::V1::GetEntryRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_entry(name: nil, view: nil, aspect_types: nil, paths: nil)
            #   Pass arguments to `get_entry` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the Entry:
            #     `projects/{project}/locations/{location}/entryGroups/{entry_group}/entries/{entry}`.
            #   @param view [::Google::Cloud::Dataplex::V1::EntryView]
            #     Optional. View to control which parts of an entry the service should
            #     return.
            #   @param aspect_types [::Array<::String>]
            #     Optional. Limits the aspects returned to the provided aspect types.
            #     It only works for CUSTOM view.
            #   @param paths [::Array<::String>]
            #     Optional. Limits the aspects returned to those associated with the provided
            #     paths within the Entry. It only works for CUSTOM view.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Dataplex::V1::Entry]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Dataplex::V1::Entry]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataplex/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataplex::V1::CatalogService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataplex::V1::GetEntryRequest.new
            #
            #   # Call the get_entry method.
            #   result = client.get_entry request
            #
            #   # The returned object is of type Google::Cloud::Dataplex::V1::Entry.
            #   p result
            #
            def get_entry request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::GetEntryRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_entry.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataplex::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_entry.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_entry.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @catalog_service_stub.call_rpc :get_entry, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Looks up an entry by name using the permission on the source system.
            # Caution: The Vertex AI, Bigtable, Spanner, Pub/Sub, Dataform, and Dataproc
            # Metastore metadata that is stored in Dataplex Universal Catalog is
            # changing. For more information, see [Changes to metadata stored in
            # Dataplex Universal
            # Catalog](https://cloud.google.com/dataplex/docs/metadata-changes).
            #
            # @overload lookup_entry(request, options = nil)
            #   Pass arguments to `lookup_entry` via a request object, either of type
            #   {::Google::Cloud::Dataplex::V1::LookupEntryRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataplex::V1::LookupEntryRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload lookup_entry(name: nil, view: nil, aspect_types: nil, paths: nil, entry: nil)
            #   Pass arguments to `lookup_entry` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The project to which the request should be attributed in the
            #     following form: `projects/{project}/locations/{location}`.
            #   @param view [::Google::Cloud::Dataplex::V1::EntryView]
            #     Optional. View to control which parts of an entry the service should
            #     return.
            #   @param aspect_types [::Array<::String>]
            #     Optional. Limits the aspects returned to the provided aspect types.
            #     It only works for CUSTOM view.
            #   @param paths [::Array<::String>]
            #     Optional. Limits the aspects returned to those associated with the provided
            #     paths within the Entry. It only works for CUSTOM view.
            #   @param entry [::String]
            #     Required. The resource name of the Entry:
            #     `projects/{project}/locations/{location}/entryGroups/{entry_group}/entries/{entry}`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Dataplex::V1::Entry]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Dataplex::V1::Entry]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataplex/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataplex::V1::CatalogService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataplex::V1::LookupEntryRequest.new
            #
            #   # Call the lookup_entry method.
            #   result = client.lookup_entry request
            #
            #   # The returned object is of type Google::Cloud::Dataplex::V1::Entry.
            #   p result
            #
            def lookup_entry request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::LookupEntryRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.lookup_entry.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataplex::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.lookup_entry.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.lookup_entry.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @catalog_service_stub.call_rpc :lookup_entry, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Searches for Entries matching the given query and scope.
            #
            # @overload search_entries(request, options = nil)
            #   Pass arguments to `search_entries` via a request object, either of type
            #   {::Google::Cloud::Dataplex::V1::SearchEntriesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataplex::V1::SearchEntriesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload search_entries(name: nil, query: nil, page_size: nil, page_token: nil, order_by: nil, scope: nil, semantic_search: nil)
            #   Pass arguments to `search_entries` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The project to which the request should be attributed in the
            #     following form: `projects/{project}/locations/global`.
            #   @param query [::String]
            #     Required. The query against which entries in scope should be matched.
            #     The query syntax is defined in [Search syntax for Dataplex Universal
            #     Catalog](https://cloud.google.com/dataplex/docs/search-syntax).
            #   @param page_size [::Integer]
            #     Optional. Number of results in the search page. If <=0, then defaults
            #     to 10. Max limit for page_size is 1000. Throws an invalid argument for
            #     page_size > 1000.
            #   @param page_token [::String]
            #     Optional. Page token received from a previous `SearchEntries` call. Provide
            #     this to retrieve the subsequent page.
            #   @param order_by [::String]
            #     Optional. Specifies the ordering of results.
            #     Supported values are:
            #
            #     * `relevance`
            #     * `last_modified_timestamp`
            #     * `last_modified_timestamp asc`
            #   @param scope [::String]
            #     Optional. The scope under which the search should be operating. It must
            #     either be `organizations/<org_id>` or `projects/<project_ref>`. If it is
            #     unspecified, it defaults to the organization where the project provided in
            #     `name` is located.
            #   @param semantic_search [::Boolean]
            #     Optional. Specifies whether the search should understand the meaning and
            #     intent behind the query, rather than just matching keywords.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Dataplex::V1::SearchEntriesResult>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Dataplex::V1::SearchEntriesResult>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataplex/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataplex::V1::CatalogService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataplex::V1::SearchEntriesRequest.new
            #
            #   # Call the search_entries method.
            #   result = client.search_entries request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Dataplex::V1::SearchEntriesResult.
            #     p item
            #   end
            #
            def search_entries request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::SearchEntriesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.search_entries.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataplex::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.search_entries.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.search_entries.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @catalog_service_stub.call_rpc :search_entries, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @catalog_service_stub, :search_entries, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a metadata job. For example, use a metadata job to import metadata
            # from a third-party system into Dataplex Universal Catalog.
            #
            # @overload create_metadata_job(request, options = nil)
            #   Pass arguments to `create_metadata_job` via a request object, either of type
            #   {::Google::Cloud::Dataplex::V1::CreateMetadataJobRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataplex::V1::CreateMetadataJobRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_metadata_job(parent: nil, metadata_job: nil, metadata_job_id: nil, validate_only: nil)
            #   Pass arguments to `create_metadata_job` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the parent location, in the format
            #     `projects/{project_id_or_number}/locations/{location_id}`
            #   @param metadata_job [::Google::Cloud::Dataplex::V1::MetadataJob, ::Hash]
            #     Required. The metadata job resource.
            #   @param metadata_job_id [::String]
            #     Optional. The metadata job ID. If not provided, a unique ID is generated
            #     with the prefix `metadata-job-`.
            #   @param validate_only [::Boolean]
            #     Optional. The service validates the request without performing any
            #     mutations. The default is false.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataplex/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataplex::V1::CatalogService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataplex::V1::CreateMetadataJobRequest.new
            #
            #   # Call the create_metadata_job method.
            #   result = client.create_metadata_job request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_metadata_job request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::CreateMetadataJobRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_metadata_job.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataplex::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_metadata_job.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_metadata_job.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @catalog_service_stub.call_rpc :create_metadata_job, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a metadata job.
            #
            # @overload get_metadata_job(request, options = nil)
            #   Pass arguments to `get_metadata_job` via a request object, either of type
            #   {::Google::Cloud::Dataplex::V1::GetMetadataJobRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataplex::V1::GetMetadataJobRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_metadata_job(name: nil)
            #   Pass arguments to `get_metadata_job` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the metadata job, in the format
            #     `projects/{project_id_or_number}/locations/{location_id}/metadataJobs/{metadata_job_id}`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Dataplex::V1::MetadataJob]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Dataplex::V1::MetadataJob]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataplex/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataplex::V1::CatalogService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataplex::V1::GetMetadataJobRequest.new
            #
            #   # Call the get_metadata_job method.
            #   result = client.get_metadata_job request
            #
            #   # The returned object is of type Google::Cloud::Dataplex::V1::MetadataJob.
            #   p result
            #
            def get_metadata_job request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::GetMetadataJobRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_metadata_job.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataplex::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_metadata_job.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_metadata_job.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @catalog_service_stub.call_rpc :get_metadata_job, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists metadata jobs.
            #
            # @overload list_metadata_jobs(request, options = nil)
            #   Pass arguments to `list_metadata_jobs` via a request object, either of type
            #   {::Google::Cloud::Dataplex::V1::ListMetadataJobsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataplex::V1::ListMetadataJobsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_metadata_jobs(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_metadata_jobs` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the parent location, in the format
            #     `projects/{project_id_or_number}/locations/{location_id}`
            #   @param page_size [::Integer]
            #     Optional. The maximum number of metadata jobs to return. The service might
            #     return fewer jobs than this value. If unspecified, at most 10 jobs are
            #     returned. The maximum value is 1,000.
            #   @param page_token [::String]
            #     Optional. The page token received from a previous `ListMetadataJobs` call.
            #     Provide this token to retrieve the subsequent page of results. When
            #     paginating, all other parameters that are provided to the
            #     `ListMetadataJobs` request must match the call that provided the page
            #     token.
            #   @param filter [::String]
            #     Optional. Filter request. Filters are case-sensitive.
            #     The service supports the following formats:
            #
            #     * `labels.key1 = "value1"`
            #     * `labels:key1`
            #     * `name = "value"`
            #
            #     You can combine filters with `AND`, `OR`, and `NOT` operators.
            #   @param order_by [::String]
            #     Optional. The field to sort the results by, either `name` or `create_time`.
            #     If not specified, the ordering is undefined.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Dataplex::V1::MetadataJob>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Dataplex::V1::MetadataJob>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataplex/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataplex::V1::CatalogService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataplex::V1::ListMetadataJobsRequest.new
            #
            #   # Call the list_metadata_jobs method.
            #   result = client.list_metadata_jobs request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Dataplex::V1::MetadataJob.
            #     p item
            #   end
            #
            def list_metadata_jobs request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::ListMetadataJobsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_metadata_jobs.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataplex::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_metadata_jobs.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_metadata_jobs.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @catalog_service_stub.call_rpc :list_metadata_jobs, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @catalog_service_stub, :list_metadata_jobs, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Cancels a metadata job.
            #
            # If you cancel a metadata import job that is in progress, the changes in the
            # job might be partially applied. We recommend that you reset the state of
            # the entry groups in your project by running another metadata job that
            # reverts the changes from the canceled job.
            #
            # @overload cancel_metadata_job(request, options = nil)
            #   Pass arguments to `cancel_metadata_job` via a request object, either of type
            #   {::Google::Cloud::Dataplex::V1::CancelMetadataJobRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataplex::V1::CancelMetadataJobRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload cancel_metadata_job(name: nil)
            #   Pass arguments to `cancel_metadata_job` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the job, in the format
            #     `projects/{project_id_or_number}/locations/{location_id}/metadataJobs/{metadata_job_id}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataplex/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataplex::V1::CatalogService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataplex::V1::CancelMetadataJobRequest.new
            #
            #   # Call the cancel_metadata_job method.
            #   result = client.cancel_metadata_job request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def cancel_metadata_job request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::CancelMetadataJobRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.cancel_metadata_job.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataplex::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.cancel_metadata_job.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.cancel_metadata_job.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @catalog_service_stub.call_rpc :cancel_metadata_job, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates an Entry Link.
            #
            # @overload create_entry_link(request, options = nil)
            #   Pass arguments to `create_entry_link` via a request object, either of type
            #   {::Google::Cloud::Dataplex::V1::CreateEntryLinkRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataplex::V1::CreateEntryLinkRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_entry_link(parent: nil, entry_link_id: nil, entry_link: nil)
            #   Pass arguments to `create_entry_link` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the parent Entry Group:
            #     `projects/{project_id_or_number}/locations/{location_id}/entryGroups/{entry_group_id}`.
            #   @param entry_link_id [::String]
            #     Required. Entry Link identifier
            #     * Must contain only lowercase letters, numbers and hyphens.
            #     * Must start with a letter.
            #     * Must be between 1-63 characters.
            #     * Must end with a number or a letter.
            #     * Must be unique within the EntryGroup.
            #   @param entry_link [::Google::Cloud::Dataplex::V1::EntryLink, ::Hash]
            #     Required. Entry Link resource.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Dataplex::V1::EntryLink]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Dataplex::V1::EntryLink]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataplex/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataplex::V1::CatalogService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataplex::V1::CreateEntryLinkRequest.new
            #
            #   # Call the create_entry_link method.
            #   result = client.create_entry_link request
            #
            #   # The returned object is of type Google::Cloud::Dataplex::V1::EntryLink.
            #   p result
            #
            def create_entry_link request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::CreateEntryLinkRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_entry_link.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataplex::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_entry_link.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_entry_link.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @catalog_service_stub.call_rpc :create_entry_link, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes an Entry Link.
            #
            # @overload delete_entry_link(request, options = nil)
            #   Pass arguments to `delete_entry_link` via a request object, either of type
            #   {::Google::Cloud::Dataplex::V1::DeleteEntryLinkRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataplex::V1::DeleteEntryLinkRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_entry_link(name: nil)
            #   Pass arguments to `delete_entry_link` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the Entry Link:
            #     `projects/{project_id_or_number}/locations/{location_id}/entryGroups/{entry_group_id}/entryLinks/{entry_link_id}`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Dataplex::V1::EntryLink]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Dataplex::V1::EntryLink]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataplex/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataplex::V1::CatalogService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataplex::V1::DeleteEntryLinkRequest.new
            #
            #   # Call the delete_entry_link method.
            #   result = client.delete_entry_link request
            #
            #   # The returned object is of type Google::Cloud::Dataplex::V1::EntryLink.
            #   p result
            #
            def delete_entry_link request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::DeleteEntryLinkRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_entry_link.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataplex::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_entry_link.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_entry_link.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @catalog_service_stub.call_rpc :delete_entry_link, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets an Entry Link.
            #
            # @overload get_entry_link(request, options = nil)
            #   Pass arguments to `get_entry_link` via a request object, either of type
            #   {::Google::Cloud::Dataplex::V1::GetEntryLinkRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataplex::V1::GetEntryLinkRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_entry_link(name: nil)
            #   Pass arguments to `get_entry_link` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the Entry Link:
            #     `projects/{project_id_or_number}/locations/{location_id}/entryGroups/{entry_group_id}/entryLinks/{entry_link_id}`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Dataplex::V1::EntryLink]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Dataplex::V1::EntryLink]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataplex/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataplex::V1::CatalogService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataplex::V1::GetEntryLinkRequest.new
            #
            #   # Call the get_entry_link method.
            #   result = client.get_entry_link request
            #
            #   # The returned object is of type Google::Cloud::Dataplex::V1::EntryLink.
            #   p result
            #
            def get_entry_link request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::GetEntryLinkRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_entry_link.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataplex::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_entry_link.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_entry_link.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @catalog_service_stub.call_rpc :get_entry_link, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the CatalogService API.
            #
            # This class represents the configuration for CatalogService,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::Dataplex::V1::CatalogService::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # create_entry_type to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::Dataplex::V1::CatalogService::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_entry_type.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::Dataplex::V1::CatalogService::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_entry_type.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::Dataplex::V1::CatalogService::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "dataplex.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the CatalogService API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `create_entry_type`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_entry_type
                ##
                # RPC-specific configuration for `update_entry_type`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_entry_type
                ##
                # RPC-specific configuration for `delete_entry_type`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_entry_type
                ##
                # RPC-specific configuration for `list_entry_types`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_entry_types
                ##
                # RPC-specific configuration for `get_entry_type`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_entry_type
                ##
                # RPC-specific configuration for `create_aspect_type`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_aspect_type
                ##
                # RPC-specific configuration for `update_aspect_type`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_aspect_type
                ##
                # RPC-specific configuration for `delete_aspect_type`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_aspect_type
                ##
                # RPC-specific configuration for `list_aspect_types`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_aspect_types
                ##
                # RPC-specific configuration for `get_aspect_type`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_aspect_type
                ##
                # RPC-specific configuration for `create_entry_group`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_entry_group
                ##
                # RPC-specific configuration for `update_entry_group`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_entry_group
                ##
                # RPC-specific configuration for `delete_entry_group`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_entry_group
                ##
                # RPC-specific configuration for `list_entry_groups`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_entry_groups
                ##
                # RPC-specific configuration for `get_entry_group`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_entry_group
                ##
                # RPC-specific configuration for `create_entry`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_entry
                ##
                # RPC-specific configuration for `update_entry`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_entry
                ##
                # RPC-specific configuration for `delete_entry`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_entry
                ##
                # RPC-specific configuration for `list_entries`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_entries
                ##
                # RPC-specific configuration for `get_entry`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_entry
                ##
                # RPC-specific configuration for `lookup_entry`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :lookup_entry
                ##
                # RPC-specific configuration for `search_entries`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :search_entries
                ##
                # RPC-specific configuration for `create_metadata_job`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_metadata_job
                ##
                # RPC-specific configuration for `get_metadata_job`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_metadata_job
                ##
                # RPC-specific configuration for `list_metadata_jobs`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_metadata_jobs
                ##
                # RPC-specific configuration for `cancel_metadata_job`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :cancel_metadata_job
                ##
                # RPC-specific configuration for `create_entry_link`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_entry_link
                ##
                # RPC-specific configuration for `delete_entry_link`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_entry_link
                ##
                # RPC-specific configuration for `get_entry_link`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_entry_link

                # @private
                def initialize parent_rpcs = nil
                  create_entry_type_config = parent_rpcs.create_entry_type if parent_rpcs.respond_to? :create_entry_type
                  @create_entry_type = ::Gapic::Config::Method.new create_entry_type_config
                  update_entry_type_config = parent_rpcs.update_entry_type if parent_rpcs.respond_to? :update_entry_type
                  @update_entry_type = ::Gapic::Config::Method.new update_entry_type_config
                  delete_entry_type_config = parent_rpcs.delete_entry_type if parent_rpcs.respond_to? :delete_entry_type
                  @delete_entry_type = ::Gapic::Config::Method.new delete_entry_type_config
                  list_entry_types_config = parent_rpcs.list_entry_types if parent_rpcs.respond_to? :list_entry_types
                  @list_entry_types = ::Gapic::Config::Method.new list_entry_types_config
                  get_entry_type_config = parent_rpcs.get_entry_type if parent_rpcs.respond_to? :get_entry_type
                  @get_entry_type = ::Gapic::Config::Method.new get_entry_type_config
                  create_aspect_type_config = parent_rpcs.create_aspect_type if parent_rpcs.respond_to? :create_aspect_type
                  @create_aspect_type = ::Gapic::Config::Method.new create_aspect_type_config
                  update_aspect_type_config = parent_rpcs.update_aspect_type if parent_rpcs.respond_to? :update_aspect_type
                  @update_aspect_type = ::Gapic::Config::Method.new update_aspect_type_config
                  delete_aspect_type_config = parent_rpcs.delete_aspect_type if parent_rpcs.respond_to? :delete_aspect_type
                  @delete_aspect_type = ::Gapic::Config::Method.new delete_aspect_type_config
                  list_aspect_types_config = parent_rpcs.list_aspect_types if parent_rpcs.respond_to? :list_aspect_types
                  @list_aspect_types = ::Gapic::Config::Method.new list_aspect_types_config
                  get_aspect_type_config = parent_rpcs.get_aspect_type if parent_rpcs.respond_to? :get_aspect_type
                  @get_aspect_type = ::Gapic::Config::Method.new get_aspect_type_config
                  create_entry_group_config = parent_rpcs.create_entry_group if parent_rpcs.respond_to? :create_entry_group
                  @create_entry_group = ::Gapic::Config::Method.new create_entry_group_config
                  update_entry_group_config = parent_rpcs.update_entry_group if parent_rpcs.respond_to? :update_entry_group
                  @update_entry_group = ::Gapic::Config::Method.new update_entry_group_config
                  delete_entry_group_config = parent_rpcs.delete_entry_group if parent_rpcs.respond_to? :delete_entry_group
                  @delete_entry_group = ::Gapic::Config::Method.new delete_entry_group_config
                  list_entry_groups_config = parent_rpcs.list_entry_groups if parent_rpcs.respond_to? :list_entry_groups
                  @list_entry_groups = ::Gapic::Config::Method.new list_entry_groups_config
                  get_entry_group_config = parent_rpcs.get_entry_group if parent_rpcs.respond_to? :get_entry_group
                  @get_entry_group = ::Gapic::Config::Method.new get_entry_group_config
                  create_entry_config = parent_rpcs.create_entry if parent_rpcs.respond_to? :create_entry
                  @create_entry = ::Gapic::Config::Method.new create_entry_config
                  update_entry_config = parent_rpcs.update_entry if parent_rpcs.respond_to? :update_entry
                  @update_entry = ::Gapic::Config::Method.new update_entry_config
                  delete_entry_config = parent_rpcs.delete_entry if parent_rpcs.respond_to? :delete_entry
                  @delete_entry = ::Gapic::Config::Method.new delete_entry_config
                  list_entries_config = parent_rpcs.list_entries if parent_rpcs.respond_to? :list_entries
                  @list_entries = ::Gapic::Config::Method.new list_entries_config
                  get_entry_config = parent_rpcs.get_entry if parent_rpcs.respond_to? :get_entry
                  @get_entry = ::Gapic::Config::Method.new get_entry_config
                  lookup_entry_config = parent_rpcs.lookup_entry if parent_rpcs.respond_to? :lookup_entry
                  @lookup_entry = ::Gapic::Config::Method.new lookup_entry_config
                  search_entries_config = parent_rpcs.search_entries if parent_rpcs.respond_to? :search_entries
                  @search_entries = ::Gapic::Config::Method.new search_entries_config
                  create_metadata_job_config = parent_rpcs.create_metadata_job if parent_rpcs.respond_to? :create_metadata_job
                  @create_metadata_job = ::Gapic::Config::Method.new create_metadata_job_config
                  get_metadata_job_config = parent_rpcs.get_metadata_job if parent_rpcs.respond_to? :get_metadata_job
                  @get_metadata_job = ::Gapic::Config::Method.new get_metadata_job_config
                  list_metadata_jobs_config = parent_rpcs.list_metadata_jobs if parent_rpcs.respond_to? :list_metadata_jobs
                  @list_metadata_jobs = ::Gapic::Config::Method.new list_metadata_jobs_config
                  cancel_metadata_job_config = parent_rpcs.cancel_metadata_job if parent_rpcs.respond_to? :cancel_metadata_job
                  @cancel_metadata_job = ::Gapic::Config::Method.new cancel_metadata_job_config
                  create_entry_link_config = parent_rpcs.create_entry_link if parent_rpcs.respond_to? :create_entry_link
                  @create_entry_link = ::Gapic::Config::Method.new create_entry_link_config
                  delete_entry_link_config = parent_rpcs.delete_entry_link if parent_rpcs.respond_to? :delete_entry_link
                  @delete_entry_link = ::Gapic::Config::Method.new delete_entry_link_config
                  get_entry_link_config = parent_rpcs.get_entry_link if parent_rpcs.respond_to? :get_entry_link
                  @get_entry_link = ::Gapic::Config::Method.new get_entry_link_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
