# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/dataplex/v1/business_glossary_pb"
require "google/cloud/dataplex/v1/business_glossary_service/rest/service_stub"
require "google/cloud/location/rest"
require "google/iam/v1/rest"

module Google
  module Cloud
    module Dataplex
      module V1
        module BusinessGlossaryService
          module Rest
            ##
            # REST client for the BusinessGlossaryService service.
            #
            # BusinessGlossaryService provides APIs for managing business glossary
            # resources for enterprise customers.
            # The resources currently supported in Business Glossary are:
            # 1. Glossary
            # 2. GlossaryCategory
            # 3. GlossaryTerm
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "dataplex.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :business_glossary_service_stub

              ##
              # Configure the BusinessGlossaryService Client class.
              #
              # See {::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all BusinessGlossaryService clients
              #   ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "Dataplex", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the BusinessGlossaryService Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @business_glossary_service_stub.universe_domain
              end

              ##
              # Create a new BusinessGlossaryService REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the BusinessGlossaryService client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Rest::Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @business_glossary_service_stub = ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @business_glossary_service_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @business_glossary_service_stub.endpoint
                  config.universe_domain = @business_glossary_service_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @business_glossary_service_stub.logger if config.respond_to? :logger=
                end

                @iam_policy_client = Google::Iam::V1::IAMPolicy::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @business_glossary_service_stub.endpoint
                  config.universe_domain = @business_glossary_service_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @business_glossary_service_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Rest::Operations]
              #
              attr_reader :operations_client

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Rest::Client]
              #
              attr_reader :location_client

              ##
              # Get the associated client for mix-in of the IAMPolicy.
              #
              # @return [Google::Iam::V1::IAMPolicy::Rest::Client]
              #
              attr_reader :iam_policy_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @business_glossary_service_stub.logger
              end

              # Service calls

              ##
              # Creates a new Glossary resource.
              #
              # @overload create_glossary(request, options = nil)
              #   Pass arguments to `create_glossary` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::CreateGlossaryRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::CreateGlossaryRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_glossary(parent: nil, glossary_id: nil, glossary: nil, validate_only: nil)
              #   Pass arguments to `create_glossary` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource where this Glossary will be created.
              #     Format: projects/\\{project_id_or_number}/locations/\\{location_id}
              #     where `location_id` refers to a Google Cloud region.
              #   @param glossary_id [::String]
              #     Required. Glossary ID: Glossary identifier.
              #   @param glossary [::Google::Cloud::Dataplex::V1::Glossary, ::Hash]
              #     Required. The Glossary to create.
              #   @param validate_only [::Boolean]
              #     Optional. Validates the request without actually creating the Glossary.
              #     Default: false.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::BusinessGlossaryService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::CreateGlossaryRequest.new
              #
              #   # Call the create_glossary method.
              #   result = client.create_glossary request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_glossary request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::CreateGlossaryRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_glossary.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_glossary.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_glossary.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @business_glossary_service_stub.create_glossary request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a Glossary resource.
              #
              # @overload update_glossary(request, options = nil)
              #   Pass arguments to `update_glossary` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::UpdateGlossaryRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::UpdateGlossaryRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_glossary(glossary: nil, update_mask: nil, validate_only: nil)
              #   Pass arguments to `update_glossary` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param glossary [::Google::Cloud::Dataplex::V1::Glossary, ::Hash]
              #     Required. The Glossary to update.
              #     The Glossary's `name` field is used to identify the Glossary to update.
              #     Format:
              #     projects/\\{project_id_or_number}/locations/\\{location_id}/glossaries/\\{glossary_id}
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The list of fields to update.
              #   @param validate_only [::Boolean]
              #     Optional. Validates the request without actually updating the Glossary.
              #     Default: false.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::BusinessGlossaryService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::UpdateGlossaryRequest.new
              #
              #   # Call the update_glossary method.
              #   result = client.update_glossary request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_glossary request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::UpdateGlossaryRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_glossary.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_glossary.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_glossary.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @business_glossary_service_stub.update_glossary request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a Glossary resource. All the categories and terms within the
              # Glossary must be deleted before the Glossary can be deleted.
              #
              # @overload delete_glossary(request, options = nil)
              #   Pass arguments to `delete_glossary` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::DeleteGlossaryRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::DeleteGlossaryRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_glossary(name: nil, etag: nil)
              #   Pass arguments to `delete_glossary` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the Glossary to delete.
              #     Format:
              #     projects/\\{project_id_or_number}/locations/\\{location_id}/glossaries/\\{glossary_id}
              #   @param etag [::String]
              #     Optional. The etag of the Glossary.
              #     If this is provided, it must match the server's etag.
              #     If the etag is provided and does not match the server-computed etag,
              #     the request must fail with a ABORTED error code.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::BusinessGlossaryService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::DeleteGlossaryRequest.new
              #
              #   # Call the delete_glossary method.
              #   result = client.delete_glossary request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_glossary request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::DeleteGlossaryRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_glossary.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_glossary.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_glossary.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @business_glossary_service_stub.delete_glossary request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a Glossary resource.
              #
              # @overload get_glossary(request, options = nil)
              #   Pass arguments to `get_glossary` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::GetGlossaryRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::GetGlossaryRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_glossary(name: nil)
              #   Pass arguments to `get_glossary` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the Glossary to retrieve.
              #     Format:
              #     projects/\\{project_id_or_number}/locations/\\{location_id}/glossaries/\\{glossary_id}
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dataplex::V1::Glossary]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dataplex::V1::Glossary]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::BusinessGlossaryService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::GetGlossaryRequest.new
              #
              #   # Call the get_glossary method.
              #   result = client.get_glossary request
              #
              #   # The returned object is of type Google::Cloud::Dataplex::V1::Glossary.
              #   p result
              #
              def get_glossary request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::GetGlossaryRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_glossary.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_glossary.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_glossary.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @business_glossary_service_stub.get_glossary request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists Glossary resources in a project and location.
              #
              # @overload list_glossaries(request, options = nil)
              #   Pass arguments to `list_glossaries` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::ListGlossariesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::ListGlossariesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_glossaries(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_glossaries` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent, which has this collection of Glossaries.
              #     Format: projects/\\{project_id_or_number}/locations/\\{location_id}
              #     where `location_id` refers to a Google Cloud region.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of Glossaries to return. The service may
              #     return fewer than this value. If unspecified, at most 50 Glossaries will be
              #     returned. The maximum value is 1000; values above 1000 will be coerced to
              #     1000.
              #   @param page_token [::String]
              #     Optional. A page token, received from a previous `ListGlossaries` call.
              #     Provide this to retrieve the subsequent page.
              #     When paginating, all other parameters provided to `ListGlossaries` must
              #     match the call that provided the page token.
              #   @param filter [::String]
              #     Optional. Filter expression that filters Glossaries listed in the response.
              #     Filters on proto fields of Glossary are supported.
              #     Examples of using a filter are:
              #       - `display_name="my-glossary"`
              #       - `categoryCount=1`
              #       - `termCount=0`
              #   @param order_by [::String]
              #     Optional. Order by expression that orders Glossaries listed in the
              #     response. Order by fields are: `name` or `create_time` for the result. If
              #     not specified, the ordering is undefined.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dataplex::V1::Glossary>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dataplex::V1::Glossary>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::BusinessGlossaryService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::ListGlossariesRequest.new
              #
              #   # Call the list_glossaries method.
              #   result = client.list_glossaries request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Dataplex::V1::Glossary.
              #     p item
              #   end
              #
              def list_glossaries request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::ListGlossariesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_glossaries.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_glossaries.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_glossaries.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @business_glossary_service_stub.list_glossaries request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @business_glossary_service_stub, :list_glossaries, "glossaries", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new GlossaryCategory resource.
              #
              # @overload create_glossary_category(request, options = nil)
              #   Pass arguments to `create_glossary_category` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::CreateGlossaryCategoryRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::CreateGlossaryCategoryRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_glossary_category(parent: nil, category_id: nil, category: nil)
              #   Pass arguments to `create_glossary_category` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource where this GlossaryCategory will be created.
              #     Format:
              #     projects/\\{project_id_or_number}/locations/\\{location_id}/glossaries/\\{glossary_id}
              #     where `locationId` refers to a Google Cloud region.
              #   @param category_id [::String]
              #     Required. GlossaryCategory identifier.
              #   @param category [::Google::Cloud::Dataplex::V1::GlossaryCategory, ::Hash]
              #     Required. The GlossaryCategory to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dataplex::V1::GlossaryCategory]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dataplex::V1::GlossaryCategory]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::BusinessGlossaryService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::CreateGlossaryCategoryRequest.new
              #
              #   # Call the create_glossary_category method.
              #   result = client.create_glossary_category request
              #
              #   # The returned object is of type Google::Cloud::Dataplex::V1::GlossaryCategory.
              #   p result
              #
              def create_glossary_category request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::CreateGlossaryCategoryRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_glossary_category.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_glossary_category.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_glossary_category.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @business_glossary_service_stub.create_glossary_category request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a GlossaryCategory resource.
              #
              # @overload update_glossary_category(request, options = nil)
              #   Pass arguments to `update_glossary_category` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::UpdateGlossaryCategoryRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::UpdateGlossaryCategoryRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_glossary_category(category: nil, update_mask: nil)
              #   Pass arguments to `update_glossary_category` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param category [::Google::Cloud::Dataplex::V1::GlossaryCategory, ::Hash]
              #     Required. The GlossaryCategory to update.
              #     The GlossaryCategory's `name` field is used to identify the
              #     GlossaryCategory to update. Format:
              #     projects/\\{project_id_or_number}/locations/\\{location_id}/glossaries/\\{glossary_id}/categories/\\{category_id}
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The list of fields to update.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dataplex::V1::GlossaryCategory]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dataplex::V1::GlossaryCategory]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::BusinessGlossaryService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::UpdateGlossaryCategoryRequest.new
              #
              #   # Call the update_glossary_category method.
              #   result = client.update_glossary_category request
              #
              #   # The returned object is of type Google::Cloud::Dataplex::V1::GlossaryCategory.
              #   p result
              #
              def update_glossary_category request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::UpdateGlossaryCategoryRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_glossary_category.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_glossary_category.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_glossary_category.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @business_glossary_service_stub.update_glossary_category request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a GlossaryCategory resource. All the GlossaryCategories and
              # GlossaryTerms nested directly under the specified GlossaryCategory will be
              # moved one level up to the parent in the hierarchy.
              #
              # @overload delete_glossary_category(request, options = nil)
              #   Pass arguments to `delete_glossary_category` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::DeleteGlossaryCategoryRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::DeleteGlossaryCategoryRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_glossary_category(name: nil)
              #   Pass arguments to `delete_glossary_category` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the GlossaryCategory to delete.
              #     Format:
              #     projects/\\{project_id_or_number}/locations/\\{location_id}/glossaries/\\{glossary_id}/categories/\\{category_id}
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::BusinessGlossaryService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::DeleteGlossaryCategoryRequest.new
              #
              #   # Call the delete_glossary_category method.
              #   result = client.delete_glossary_category request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_glossary_category request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::DeleteGlossaryCategoryRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_glossary_category.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_glossary_category.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_glossary_category.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @business_glossary_service_stub.delete_glossary_category request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a GlossaryCategory resource.
              #
              # @overload get_glossary_category(request, options = nil)
              #   Pass arguments to `get_glossary_category` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::GetGlossaryCategoryRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::GetGlossaryCategoryRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_glossary_category(name: nil)
              #   Pass arguments to `get_glossary_category` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the GlossaryCategory to retrieve.
              #     Format:
              #     projects/\\{project_id_or_number}/locations/\\{location_id}/glossaries/\\{glossary_id}/categories/\\{category_id}
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dataplex::V1::GlossaryCategory]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dataplex::V1::GlossaryCategory]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::BusinessGlossaryService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::GetGlossaryCategoryRequest.new
              #
              #   # Call the get_glossary_category method.
              #   result = client.get_glossary_category request
              #
              #   # The returned object is of type Google::Cloud::Dataplex::V1::GlossaryCategory.
              #   p result
              #
              def get_glossary_category request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::GetGlossaryCategoryRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_glossary_category.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_glossary_category.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_glossary_category.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @business_glossary_service_stub.get_glossary_category request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists GlossaryCategory resources in a Glossary.
              #
              # @overload list_glossary_categories(request, options = nil)
              #   Pass arguments to `list_glossary_categories` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::ListGlossaryCategoriesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::ListGlossaryCategoriesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_glossary_categories(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_glossary_categories` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent, which has this collection of GlossaryCategories.
              #     Format:
              #     projects/\\{project_id_or_number}/locations/\\{location_id}/glossaries/\\{glossary_id}
              #     Location is the Google Cloud region.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of GlossaryCategories to return. The service
              #     may return fewer than this value. If unspecified, at most 50
              #     GlossaryCategories will be returned. The maximum value is 1000; values
              #     above 1000 will be coerced to 1000.
              #   @param page_token [::String]
              #     Optional. A page token, received from a previous `ListGlossaryCategories`
              #     call. Provide this to retrieve the subsequent page. When paginating, all
              #     other parameters provided to `ListGlossaryCategories` must match the call
              #     that provided the page token.
              #   @param filter [::String]
              #     Optional. Filter expression that filters GlossaryCategories listed in the
              #     response. Filters are supported on the following fields:
              #       - immediate_parent
              #
              #     Examples of using a filter are:
              #       -
              #       `immediate_parent="projects/{project_id_or_number}/locations/{location_id}/glossaries/{glossary_id}"`
              #       -
              #       `immediate_parent="projects/{project_id_or_number}/locations/{location_id}/glossaries/{glossary_id}/categories/{category_id}"`
              #
              #     This will only return the GlossaryCategories that are directly nested
              #     under the specified parent.
              #   @param order_by [::String]
              #     Optional. Order by expression that orders GlossaryCategories listed in the
              #     response. Order by fields are: `name` or `create_time` for the result. If
              #     not specified, the ordering is undefined.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dataplex::V1::GlossaryCategory>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dataplex::V1::GlossaryCategory>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::BusinessGlossaryService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::ListGlossaryCategoriesRequest.new
              #
              #   # Call the list_glossary_categories method.
              #   result = client.list_glossary_categories request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Dataplex::V1::GlossaryCategory.
              #     p item
              #   end
              #
              def list_glossary_categories request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::ListGlossaryCategoriesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_glossary_categories.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_glossary_categories.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_glossary_categories.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @business_glossary_service_stub.list_glossary_categories request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @business_glossary_service_stub, :list_glossary_categories, "categories", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new GlossaryTerm resource.
              #
              # @overload create_glossary_term(request, options = nil)
              #   Pass arguments to `create_glossary_term` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::CreateGlossaryTermRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::CreateGlossaryTermRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_glossary_term(parent: nil, term_id: nil, term: nil)
              #   Pass arguments to `create_glossary_term` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource where the GlossaryTerm will be created.
              #     Format:
              #     projects/\\{project_id_or_number}/locations/\\{location_id}/glossaries/\\{glossary_id}
              #     where `location_id` refers to a Google Cloud region.
              #   @param term_id [::String]
              #     Required. GlossaryTerm identifier.
              #   @param term [::Google::Cloud::Dataplex::V1::GlossaryTerm, ::Hash]
              #     Required. The GlossaryTerm to create.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dataplex::V1::GlossaryTerm]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dataplex::V1::GlossaryTerm]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::BusinessGlossaryService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::CreateGlossaryTermRequest.new
              #
              #   # Call the create_glossary_term method.
              #   result = client.create_glossary_term request
              #
              #   # The returned object is of type Google::Cloud::Dataplex::V1::GlossaryTerm.
              #   p result
              #
              def create_glossary_term request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::CreateGlossaryTermRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_glossary_term.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_glossary_term.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_glossary_term.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @business_glossary_service_stub.create_glossary_term request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a GlossaryTerm resource.
              #
              # @overload update_glossary_term(request, options = nil)
              #   Pass arguments to `update_glossary_term` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::UpdateGlossaryTermRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::UpdateGlossaryTermRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_glossary_term(term: nil, update_mask: nil)
              #   Pass arguments to `update_glossary_term` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param term [::Google::Cloud::Dataplex::V1::GlossaryTerm, ::Hash]
              #     Required. The GlossaryTerm to update.
              #     The GlossaryTerm's `name` field is used to identify the GlossaryTerm to
              #     update. Format:
              #     projects/\\{project_id_or_number}/locations/\\{location_id}/glossaries/\\{glossary_id}/terms/\\{term_id}
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The list of fields to update.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dataplex::V1::GlossaryTerm]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dataplex::V1::GlossaryTerm]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::BusinessGlossaryService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::UpdateGlossaryTermRequest.new
              #
              #   # Call the update_glossary_term method.
              #   result = client.update_glossary_term request
              #
              #   # The returned object is of type Google::Cloud::Dataplex::V1::GlossaryTerm.
              #   p result
              #
              def update_glossary_term request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::UpdateGlossaryTermRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_glossary_term.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_glossary_term.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_glossary_term.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @business_glossary_service_stub.update_glossary_term request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a GlossaryTerm resource.
              #
              # @overload delete_glossary_term(request, options = nil)
              #   Pass arguments to `delete_glossary_term` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::DeleteGlossaryTermRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::DeleteGlossaryTermRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_glossary_term(name: nil)
              #   Pass arguments to `delete_glossary_term` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the GlossaryTerm to delete.
              #     Format:
              #     projects/\\{project_id_or_number}/locations/\\{location_id}/glossaries/\\{glossary_id}/terms/\\{term_id}
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::BusinessGlossaryService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::DeleteGlossaryTermRequest.new
              #
              #   # Call the delete_glossary_term method.
              #   result = client.delete_glossary_term request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_glossary_term request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::DeleteGlossaryTermRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_glossary_term.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_glossary_term.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_glossary_term.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @business_glossary_service_stub.delete_glossary_term request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a GlossaryTerm resource.
              #
              # @overload get_glossary_term(request, options = nil)
              #   Pass arguments to `get_glossary_term` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::GetGlossaryTermRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::GetGlossaryTermRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_glossary_term(name: nil)
              #   Pass arguments to `get_glossary_term` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the GlossaryTerm to retrieve.
              #     Format:
              #     projects/\\{project_id_or_number}/locations/\\{location_id}/glossaries/\\{glossary_id}/terms/\\{term_id}
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dataplex::V1::GlossaryTerm]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dataplex::V1::GlossaryTerm]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::BusinessGlossaryService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::GetGlossaryTermRequest.new
              #
              #   # Call the get_glossary_term method.
              #   result = client.get_glossary_term request
              #
              #   # The returned object is of type Google::Cloud::Dataplex::V1::GlossaryTerm.
              #   p result
              #
              def get_glossary_term request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::GetGlossaryTermRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_glossary_term.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_glossary_term.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_glossary_term.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @business_glossary_service_stub.get_glossary_term request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists GlossaryTerm resources in a Glossary.
              #
              # @overload list_glossary_terms(request, options = nil)
              #   Pass arguments to `list_glossary_terms` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::ListGlossaryTermsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::ListGlossaryTermsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_glossary_terms(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_glossary_terms` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent, which has this collection of GlossaryTerms.
              #     Format:
              #     projects/\\{project_id_or_number}/locations/\\{location_id}/glossaries/\\{glossary_id}
              #     where `location_id` refers to a Google Cloud region.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of GlossaryTerms to return. The service may
              #     return fewer than this value. If unspecified, at most 50 GlossaryTerms will
              #     be returned. The maximum value is 1000; values above 1000 will be coerced
              #     to 1000.
              #   @param page_token [::String]
              #     Optional. A page token, received from a previous `ListGlossaryTerms` call.
              #     Provide this to retrieve the subsequent page.
              #     When paginating, all other parameters provided to `ListGlossaryTerms` must
              #     match the call that provided the page token.
              #   @param filter [::String]
              #     Optional. Filter expression that filters GlossaryTerms listed in the
              #     response. Filters are supported on the following fields:
              #       - immediate_parent
              #
              #     Examples of using a filter are:
              #       -
              #       `immediate_parent="projects/{project_id_or_number}/locations/{location_id}/glossaries/{glossary_id}"`
              #       -
              #       `immediate_parent="projects/{project_id_or_number}/locations/{location_id}/glossaries/{glossary_id}/categories/{category_id}"`
              #
              #     This will only return the GlossaryTerms that are directly nested under the
              #     specified parent.
              #   @param order_by [::String]
              #     Optional. Order by expression that orders GlossaryTerms listed in the
              #     response. Order by fields are: `name` or `create_time` for the result. If
              #     not specified, the ordering is undefined.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dataplex::V1::GlossaryTerm>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dataplex::V1::GlossaryTerm>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::BusinessGlossaryService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::ListGlossaryTermsRequest.new
              #
              #   # Call the list_glossary_terms method.
              #   result = client.list_glossary_terms request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Dataplex::V1::GlossaryTerm.
              #     p item
              #   end
              #
              def list_glossary_terms request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::ListGlossaryTermsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_glossary_terms.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_glossary_terms.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_glossary_terms.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @business_glossary_service_stub.list_glossary_terms request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @business_glossary_service_stub, :list_glossary_terms, "terms", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the BusinessGlossaryService REST API.
              #
              # This class represents the configuration for BusinessGlossaryService REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # create_glossary to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_glossary.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_glossary.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "dataplex.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil

                # @private
                # Overrides for http bindings for the RPCs of this service
                # are only used when this service is used as mixin, and only
                # by the host service.
                # @return [::Hash{::Symbol=>::Array<::Gapic::Rest::GrpcTranscoder::HttpBinding>}]
                config_attr :bindings_override, {}, ::Hash, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the BusinessGlossaryService API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `create_glossary`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_glossary
                  ##
                  # RPC-specific configuration for `update_glossary`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_glossary
                  ##
                  # RPC-specific configuration for `delete_glossary`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_glossary
                  ##
                  # RPC-specific configuration for `get_glossary`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_glossary
                  ##
                  # RPC-specific configuration for `list_glossaries`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_glossaries
                  ##
                  # RPC-specific configuration for `create_glossary_category`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_glossary_category
                  ##
                  # RPC-specific configuration for `update_glossary_category`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_glossary_category
                  ##
                  # RPC-specific configuration for `delete_glossary_category`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_glossary_category
                  ##
                  # RPC-specific configuration for `get_glossary_category`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_glossary_category
                  ##
                  # RPC-specific configuration for `list_glossary_categories`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_glossary_categories
                  ##
                  # RPC-specific configuration for `create_glossary_term`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_glossary_term
                  ##
                  # RPC-specific configuration for `update_glossary_term`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_glossary_term
                  ##
                  # RPC-specific configuration for `delete_glossary_term`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_glossary_term
                  ##
                  # RPC-specific configuration for `get_glossary_term`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_glossary_term
                  ##
                  # RPC-specific configuration for `list_glossary_terms`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_glossary_terms

                  # @private
                  def initialize parent_rpcs = nil
                    create_glossary_config = parent_rpcs.create_glossary if parent_rpcs.respond_to? :create_glossary
                    @create_glossary = ::Gapic::Config::Method.new create_glossary_config
                    update_glossary_config = parent_rpcs.update_glossary if parent_rpcs.respond_to? :update_glossary
                    @update_glossary = ::Gapic::Config::Method.new update_glossary_config
                    delete_glossary_config = parent_rpcs.delete_glossary if parent_rpcs.respond_to? :delete_glossary
                    @delete_glossary = ::Gapic::Config::Method.new delete_glossary_config
                    get_glossary_config = parent_rpcs.get_glossary if parent_rpcs.respond_to? :get_glossary
                    @get_glossary = ::Gapic::Config::Method.new get_glossary_config
                    list_glossaries_config = parent_rpcs.list_glossaries if parent_rpcs.respond_to? :list_glossaries
                    @list_glossaries = ::Gapic::Config::Method.new list_glossaries_config
                    create_glossary_category_config = parent_rpcs.create_glossary_category if parent_rpcs.respond_to? :create_glossary_category
                    @create_glossary_category = ::Gapic::Config::Method.new create_glossary_category_config
                    update_glossary_category_config = parent_rpcs.update_glossary_category if parent_rpcs.respond_to? :update_glossary_category
                    @update_glossary_category = ::Gapic::Config::Method.new update_glossary_category_config
                    delete_glossary_category_config = parent_rpcs.delete_glossary_category if parent_rpcs.respond_to? :delete_glossary_category
                    @delete_glossary_category = ::Gapic::Config::Method.new delete_glossary_category_config
                    get_glossary_category_config = parent_rpcs.get_glossary_category if parent_rpcs.respond_to? :get_glossary_category
                    @get_glossary_category = ::Gapic::Config::Method.new get_glossary_category_config
                    list_glossary_categories_config = parent_rpcs.list_glossary_categories if parent_rpcs.respond_to? :list_glossary_categories
                    @list_glossary_categories = ::Gapic::Config::Method.new list_glossary_categories_config
                    create_glossary_term_config = parent_rpcs.create_glossary_term if parent_rpcs.respond_to? :create_glossary_term
                    @create_glossary_term = ::Gapic::Config::Method.new create_glossary_term_config
                    update_glossary_term_config = parent_rpcs.update_glossary_term if parent_rpcs.respond_to? :update_glossary_term
                    @update_glossary_term = ::Gapic::Config::Method.new update_glossary_term_config
                    delete_glossary_term_config = parent_rpcs.delete_glossary_term if parent_rpcs.respond_to? :delete_glossary_term
                    @delete_glossary_term = ::Gapic::Config::Method.new delete_glossary_term_config
                    get_glossary_term_config = parent_rpcs.get_glossary_term if parent_rpcs.respond_to? :get_glossary_term
                    @get_glossary_term = ::Gapic::Config::Method.new get_glossary_term_config
                    list_glossary_terms_config = parent_rpcs.list_glossary_terms if parent_rpcs.respond_to? :list_glossary_terms
                    @list_glossary_terms = ::Gapic::Config::Method.new list_glossary_terms_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
