# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Dataplex
      module V1
        module BusinessGlossaryService
          # Path helper methods for the BusinessGlossaryService API.
          module Paths
            ##
            # Create a fully-qualified Glossary resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/glossaries/{glossary}`
            #
            # @param project [String]
            # @param location [String]
            # @param glossary [String]
            #
            # @return [::String]
            def glossary_path project:, location:, glossary:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/glossaries/#{glossary}"
            end

            ##
            # Create a fully-qualified GlossaryCategory resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/glossaries/{glossary}/categories/{glossary_category}`
            #
            # @param project [String]
            # @param location [String]
            # @param glossary [String]
            # @param glossary_category [String]
            #
            # @return [::String]
            def glossary_category_path project:, location:, glossary:, glossary_category:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "glossary cannot contain /" if glossary.to_s.include? "/"

              "projects/#{project}/locations/#{location}/glossaries/#{glossary}/categories/#{glossary_category}"
            end

            ##
            # Create a fully-qualified GlossaryTerm resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/glossaries/{glossary}/terms/{glossary_term}`
            #
            # @param project [String]
            # @param location [String]
            # @param glossary [String]
            # @param glossary_term [String]
            #
            # @return [::String]
            def glossary_term_path project:, location:, glossary:, glossary_term:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "glossary cannot contain /" if glossary.to_s.include? "/"

              "projects/#{project}/locations/#{location}/glossaries/#{glossary}/terms/#{glossary_term}"
            end

            ##
            # Create a fully-qualified Location resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}`
            #
            # @param project [String]
            # @param location [String]
            #
            # @return [::String]
            def location_path project:, location:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/locations/#{location}"
            end

            extend self
          end
        end
      end
    end
  end
end
