# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/dataform/v1beta1/dataform_pb"
require "google/cloud/dataform/v1beta1/dataform/rest"


class ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_repositories
    # Create test objects.
    client_result = ::Google::Cloud::Dataform::V1beta1::ListRepositoriesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"
    filter = "hello world"

    list_repositories_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::ServiceStub.stub :transcode_list_repositories_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_repositories_client_stub do
        # Create client
        client = ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_repositories({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_repositories parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_repositories ::Google::Cloud::Dataform::V1beta1::ListRepositoriesRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_repositories({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_repositories(::Google::Cloud::Dataform::V1beta1::ListRepositoriesRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_repositories_client_stub.call_count
      end
    end
  end

  def test_get_repository
    # Create test objects.
    client_result = ::Google::Cloud::Dataform::V1beta1::Repository.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_repository_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::ServiceStub.stub :transcode_get_repository_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_repository_client_stub do
        # Create client
        client = ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_repository({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_repository name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_repository ::Google::Cloud::Dataform::V1beta1::GetRepositoryRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_repository({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_repository(::Google::Cloud::Dataform::V1beta1::GetRepositoryRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_repository_client_stub.call_count
      end
    end
  end

  def test_create_repository
    # Create test objects.
    client_result = ::Google::Cloud::Dataform::V1beta1::Repository.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    repository = {}
    repository_id = "hello world"

    create_repository_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::ServiceStub.stub :transcode_create_repository_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_repository_client_stub do
        # Create client
        client = ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_repository({ parent: parent, repository: repository, repository_id: repository_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_repository parent: parent, repository: repository, repository_id: repository_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_repository ::Google::Cloud::Dataform::V1beta1::CreateRepositoryRequest.new(parent: parent, repository: repository, repository_id: repository_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_repository({ parent: parent, repository: repository, repository_id: repository_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_repository(::Google::Cloud::Dataform::V1beta1::CreateRepositoryRequest.new(parent: parent, repository: repository, repository_id: repository_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_repository_client_stub.call_count
      end
    end
  end

  def test_update_repository
    # Create test objects.
    client_result = ::Google::Cloud::Dataform::V1beta1::Repository.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    repository = {}

    update_repository_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::ServiceStub.stub :transcode_update_repository_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_repository_client_stub do
        # Create client
        client = ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_repository({ update_mask: update_mask, repository: repository }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_repository update_mask: update_mask, repository: repository do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_repository ::Google::Cloud::Dataform::V1beta1::UpdateRepositoryRequest.new(update_mask: update_mask, repository: repository) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_repository({ update_mask: update_mask, repository: repository }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_repository(::Google::Cloud::Dataform::V1beta1::UpdateRepositoryRequest.new(update_mask: update_mask, repository: repository), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_repository_client_stub.call_count
      end
    end
  end

  def test_delete_repository
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    force = true

    delete_repository_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::ServiceStub.stub :transcode_delete_repository_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_repository_client_stub do
        # Create client
        client = ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_repository({ name: name, force: force }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_repository name: name, force: force do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_repository ::Google::Cloud::Dataform::V1beta1::DeleteRepositoryRequest.new(name: name, force: force) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_repository({ name: name, force: force }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_repository(::Google::Cloud::Dataform::V1beta1::DeleteRepositoryRequest.new(name: name, force: force), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_repository_client_stub.call_count
      end
    end
  end

  def test_commit_repository_changes
    # Create test objects.
    client_result = ::Google::Cloud::Dataform::V1beta1::CommitRepositoryChangesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    commit_metadata = {}
    required_head_commit_sha = "hello world"
    file_operations = {}

    commit_repository_changes_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::ServiceStub.stub :transcode_commit_repository_changes_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, commit_repository_changes_client_stub do
        # Create client
        client = ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.commit_repository_changes({ name: name, commit_metadata: commit_metadata, required_head_commit_sha: required_head_commit_sha, file_operations: file_operations }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.commit_repository_changes name: name, commit_metadata: commit_metadata, required_head_commit_sha: required_head_commit_sha, file_operations: file_operations do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.commit_repository_changes ::Google::Cloud::Dataform::V1beta1::CommitRepositoryChangesRequest.new(name: name, commit_metadata: commit_metadata, required_head_commit_sha: required_head_commit_sha, file_operations: file_operations) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.commit_repository_changes({ name: name, commit_metadata: commit_metadata, required_head_commit_sha: required_head_commit_sha, file_operations: file_operations }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.commit_repository_changes(::Google::Cloud::Dataform::V1beta1::CommitRepositoryChangesRequest.new(name: name, commit_metadata: commit_metadata, required_head_commit_sha: required_head_commit_sha, file_operations: file_operations), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, commit_repository_changes_client_stub.call_count
      end
    end
  end

  def test_read_repository_file
    # Create test objects.
    client_result = ::Google::Cloud::Dataform::V1beta1::ReadRepositoryFileResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    commit_sha = "hello world"
    path = "hello world"

    read_repository_file_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::ServiceStub.stub :transcode_read_repository_file_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, read_repository_file_client_stub do
        # Create client
        client = ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.read_repository_file({ name: name, commit_sha: commit_sha, path: path }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.read_repository_file name: name, commit_sha: commit_sha, path: path do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.read_repository_file ::Google::Cloud::Dataform::V1beta1::ReadRepositoryFileRequest.new(name: name, commit_sha: commit_sha, path: path) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.read_repository_file({ name: name, commit_sha: commit_sha, path: path }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.read_repository_file(::Google::Cloud::Dataform::V1beta1::ReadRepositoryFileRequest.new(name: name, commit_sha: commit_sha, path: path), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, read_repository_file_client_stub.call_count
      end
    end
  end

  def test_query_repository_directory_contents
    # Create test objects.
    client_result = ::Google::Cloud::Dataform::V1beta1::QueryRepositoryDirectoryContentsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    commit_sha = "hello world"
    path = "hello world"
    page_size = 42
    page_token = "hello world"

    query_repository_directory_contents_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::ServiceStub.stub :transcode_query_repository_directory_contents_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, query_repository_directory_contents_client_stub do
        # Create client
        client = ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.query_repository_directory_contents({ name: name, commit_sha: commit_sha, path: path, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.query_repository_directory_contents name: name, commit_sha: commit_sha, path: path, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.query_repository_directory_contents ::Google::Cloud::Dataform::V1beta1::QueryRepositoryDirectoryContentsRequest.new(name: name, commit_sha: commit_sha, path: path, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.query_repository_directory_contents({ name: name, commit_sha: commit_sha, path: path, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.query_repository_directory_contents(::Google::Cloud::Dataform::V1beta1::QueryRepositoryDirectoryContentsRequest.new(name: name, commit_sha: commit_sha, path: path, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, query_repository_directory_contents_client_stub.call_count
      end
    end
  end

  def test_fetch_repository_history
    # Create test objects.
    client_result = ::Google::Cloud::Dataform::V1beta1::FetchRepositoryHistoryResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    page_size = 42
    page_token = "hello world"

    fetch_repository_history_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::ServiceStub.stub :transcode_fetch_repository_history_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, fetch_repository_history_client_stub do
        # Create client
        client = ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.fetch_repository_history({ name: name, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.fetch_repository_history name: name, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.fetch_repository_history ::Google::Cloud::Dataform::V1beta1::FetchRepositoryHistoryRequest.new(name: name, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.fetch_repository_history({ name: name, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.fetch_repository_history(::Google::Cloud::Dataform::V1beta1::FetchRepositoryHistoryRequest.new(name: name, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, fetch_repository_history_client_stub.call_count
      end
    end
  end

  def test_compute_repository_access_token_status
    # Create test objects.
    client_result = ::Google::Cloud::Dataform::V1beta1::ComputeRepositoryAccessTokenStatusResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    compute_repository_access_token_status_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::ServiceStub.stub :transcode_compute_repository_access_token_status_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, compute_repository_access_token_status_client_stub do
        # Create client
        client = ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.compute_repository_access_token_status({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.compute_repository_access_token_status name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.compute_repository_access_token_status ::Google::Cloud::Dataform::V1beta1::ComputeRepositoryAccessTokenStatusRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.compute_repository_access_token_status({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.compute_repository_access_token_status(::Google::Cloud::Dataform::V1beta1::ComputeRepositoryAccessTokenStatusRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, compute_repository_access_token_status_client_stub.call_count
      end
    end
  end

  def test_fetch_remote_branches
    # Create test objects.
    client_result = ::Google::Cloud::Dataform::V1beta1::FetchRemoteBranchesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    fetch_remote_branches_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::ServiceStub.stub :transcode_fetch_remote_branches_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, fetch_remote_branches_client_stub do
        # Create client
        client = ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.fetch_remote_branches({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.fetch_remote_branches name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.fetch_remote_branches ::Google::Cloud::Dataform::V1beta1::FetchRemoteBranchesRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.fetch_remote_branches({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.fetch_remote_branches(::Google::Cloud::Dataform::V1beta1::FetchRemoteBranchesRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, fetch_remote_branches_client_stub.call_count
      end
    end
  end

  def test_list_workspaces
    # Create test objects.
    client_result = ::Google::Cloud::Dataform::V1beta1::ListWorkspacesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"
    filter = "hello world"

    list_workspaces_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::ServiceStub.stub :transcode_list_workspaces_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_workspaces_client_stub do
        # Create client
        client = ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_workspaces({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_workspaces parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_workspaces ::Google::Cloud::Dataform::V1beta1::ListWorkspacesRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_workspaces({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_workspaces(::Google::Cloud::Dataform::V1beta1::ListWorkspacesRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_workspaces_client_stub.call_count
      end
    end
  end

  def test_get_workspace
    # Create test objects.
    client_result = ::Google::Cloud::Dataform::V1beta1::Workspace.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_workspace_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::ServiceStub.stub :transcode_get_workspace_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_workspace_client_stub do
        # Create client
        client = ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_workspace({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_workspace name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_workspace ::Google::Cloud::Dataform::V1beta1::GetWorkspaceRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_workspace({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_workspace(::Google::Cloud::Dataform::V1beta1::GetWorkspaceRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_workspace_client_stub.call_count
      end
    end
  end

  def test_create_workspace
    # Create test objects.
    client_result = ::Google::Cloud::Dataform::V1beta1::Workspace.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    workspace = {}
    workspace_id = "hello world"

    create_workspace_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::ServiceStub.stub :transcode_create_workspace_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_workspace_client_stub do
        # Create client
        client = ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_workspace({ parent: parent, workspace: workspace, workspace_id: workspace_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_workspace parent: parent, workspace: workspace, workspace_id: workspace_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_workspace ::Google::Cloud::Dataform::V1beta1::CreateWorkspaceRequest.new(parent: parent, workspace: workspace, workspace_id: workspace_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_workspace({ parent: parent, workspace: workspace, workspace_id: workspace_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_workspace(::Google::Cloud::Dataform::V1beta1::CreateWorkspaceRequest.new(parent: parent, workspace: workspace, workspace_id: workspace_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_workspace_client_stub.call_count
      end
    end
  end

  def test_delete_workspace
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_workspace_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::ServiceStub.stub :transcode_delete_workspace_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_workspace_client_stub do
        # Create client
        client = ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_workspace({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_workspace name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_workspace ::Google::Cloud::Dataform::V1beta1::DeleteWorkspaceRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_workspace({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_workspace(::Google::Cloud::Dataform::V1beta1::DeleteWorkspaceRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_workspace_client_stub.call_count
      end
    end
  end

  def test_install_npm_packages
    # Create test objects.
    client_result = ::Google::Cloud::Dataform::V1beta1::InstallNpmPackagesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    workspace = "hello world"

    install_npm_packages_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::ServiceStub.stub :transcode_install_npm_packages_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, install_npm_packages_client_stub do
        # Create client
        client = ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.install_npm_packages({ workspace: workspace }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.install_npm_packages workspace: workspace do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.install_npm_packages ::Google::Cloud::Dataform::V1beta1::InstallNpmPackagesRequest.new(workspace: workspace) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.install_npm_packages({ workspace: workspace }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.install_npm_packages(::Google::Cloud::Dataform::V1beta1::InstallNpmPackagesRequest.new(workspace: workspace), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, install_npm_packages_client_stub.call_count
      end
    end
  end

  def test_pull_git_commits
    # Create test objects.
    client_result = ::Google::Cloud::Dataform::V1beta1::PullGitCommitsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    remote_branch = "hello world"
    author = {}

    pull_git_commits_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::ServiceStub.stub :transcode_pull_git_commits_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, pull_git_commits_client_stub do
        # Create client
        client = ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.pull_git_commits({ name: name, remote_branch: remote_branch, author: author }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.pull_git_commits name: name, remote_branch: remote_branch, author: author do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.pull_git_commits ::Google::Cloud::Dataform::V1beta1::PullGitCommitsRequest.new(name: name, remote_branch: remote_branch, author: author) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.pull_git_commits({ name: name, remote_branch: remote_branch, author: author }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.pull_git_commits(::Google::Cloud::Dataform::V1beta1::PullGitCommitsRequest.new(name: name, remote_branch: remote_branch, author: author), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, pull_git_commits_client_stub.call_count
      end
    end
  end

  def test_push_git_commits
    # Create test objects.
    client_result = ::Google::Cloud::Dataform::V1beta1::PushGitCommitsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    remote_branch = "hello world"

    push_git_commits_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::ServiceStub.stub :transcode_push_git_commits_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, push_git_commits_client_stub do
        # Create client
        client = ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.push_git_commits({ name: name, remote_branch: remote_branch }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.push_git_commits name: name, remote_branch: remote_branch do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.push_git_commits ::Google::Cloud::Dataform::V1beta1::PushGitCommitsRequest.new(name: name, remote_branch: remote_branch) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.push_git_commits({ name: name, remote_branch: remote_branch }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.push_git_commits(::Google::Cloud::Dataform::V1beta1::PushGitCommitsRequest.new(name: name, remote_branch: remote_branch), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, push_git_commits_client_stub.call_count
      end
    end
  end

  def test_fetch_file_git_statuses
    # Create test objects.
    client_result = ::Google::Cloud::Dataform::V1beta1::FetchFileGitStatusesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    fetch_file_git_statuses_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::ServiceStub.stub :transcode_fetch_file_git_statuses_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, fetch_file_git_statuses_client_stub do
        # Create client
        client = ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.fetch_file_git_statuses({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.fetch_file_git_statuses name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.fetch_file_git_statuses ::Google::Cloud::Dataform::V1beta1::FetchFileGitStatusesRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.fetch_file_git_statuses({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.fetch_file_git_statuses(::Google::Cloud::Dataform::V1beta1::FetchFileGitStatusesRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, fetch_file_git_statuses_client_stub.call_count
      end
    end
  end

  def test_fetch_git_ahead_behind
    # Create test objects.
    client_result = ::Google::Cloud::Dataform::V1beta1::FetchGitAheadBehindResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    remote_branch = "hello world"

    fetch_git_ahead_behind_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::ServiceStub.stub :transcode_fetch_git_ahead_behind_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, fetch_git_ahead_behind_client_stub do
        # Create client
        client = ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.fetch_git_ahead_behind({ name: name, remote_branch: remote_branch }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.fetch_git_ahead_behind name: name, remote_branch: remote_branch do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.fetch_git_ahead_behind ::Google::Cloud::Dataform::V1beta1::FetchGitAheadBehindRequest.new(name: name, remote_branch: remote_branch) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.fetch_git_ahead_behind({ name: name, remote_branch: remote_branch }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.fetch_git_ahead_behind(::Google::Cloud::Dataform::V1beta1::FetchGitAheadBehindRequest.new(name: name, remote_branch: remote_branch), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, fetch_git_ahead_behind_client_stub.call_count
      end
    end
  end

  def test_commit_workspace_changes
    # Create test objects.
    client_result = ::Google::Cloud::Dataform::V1beta1::CommitWorkspaceChangesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    author = {}
    commit_message = "hello world"
    paths = ["hello world"]

    commit_workspace_changes_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::ServiceStub.stub :transcode_commit_workspace_changes_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, commit_workspace_changes_client_stub do
        # Create client
        client = ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.commit_workspace_changes({ name: name, author: author, commit_message: commit_message, paths: paths }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.commit_workspace_changes name: name, author: author, commit_message: commit_message, paths: paths do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.commit_workspace_changes ::Google::Cloud::Dataform::V1beta1::CommitWorkspaceChangesRequest.new(name: name, author: author, commit_message: commit_message, paths: paths) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.commit_workspace_changes({ name: name, author: author, commit_message: commit_message, paths: paths }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.commit_workspace_changes(::Google::Cloud::Dataform::V1beta1::CommitWorkspaceChangesRequest.new(name: name, author: author, commit_message: commit_message, paths: paths), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, commit_workspace_changes_client_stub.call_count
      end
    end
  end

  def test_reset_workspace_changes
    # Create test objects.
    client_result = ::Google::Cloud::Dataform::V1beta1::ResetWorkspaceChangesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    paths = ["hello world"]
    clean = true

    reset_workspace_changes_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::ServiceStub.stub :transcode_reset_workspace_changes_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, reset_workspace_changes_client_stub do
        # Create client
        client = ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.reset_workspace_changes({ name: name, paths: paths, clean: clean }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.reset_workspace_changes name: name, paths: paths, clean: clean do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.reset_workspace_changes ::Google::Cloud::Dataform::V1beta1::ResetWorkspaceChangesRequest.new(name: name, paths: paths, clean: clean) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.reset_workspace_changes({ name: name, paths: paths, clean: clean }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.reset_workspace_changes(::Google::Cloud::Dataform::V1beta1::ResetWorkspaceChangesRequest.new(name: name, paths: paths, clean: clean), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, reset_workspace_changes_client_stub.call_count
      end
    end
  end

  def test_fetch_file_diff
    # Create test objects.
    client_result = ::Google::Cloud::Dataform::V1beta1::FetchFileDiffResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    workspace = "hello world"
    path = "hello world"

    fetch_file_diff_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::ServiceStub.stub :transcode_fetch_file_diff_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, fetch_file_diff_client_stub do
        # Create client
        client = ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.fetch_file_diff({ workspace: workspace, path: path }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.fetch_file_diff workspace: workspace, path: path do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.fetch_file_diff ::Google::Cloud::Dataform::V1beta1::FetchFileDiffRequest.new(workspace: workspace, path: path) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.fetch_file_diff({ workspace: workspace, path: path }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.fetch_file_diff(::Google::Cloud::Dataform::V1beta1::FetchFileDiffRequest.new(workspace: workspace, path: path), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, fetch_file_diff_client_stub.call_count
      end
    end
  end

  def test_query_directory_contents
    # Create test objects.
    client_result = ::Google::Cloud::Dataform::V1beta1::QueryDirectoryContentsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    workspace = "hello world"
    path = "hello world"
    page_size = 42
    page_token = "hello world"

    query_directory_contents_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::ServiceStub.stub :transcode_query_directory_contents_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, query_directory_contents_client_stub do
        # Create client
        client = ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.query_directory_contents({ workspace: workspace, path: path, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.query_directory_contents workspace: workspace, path: path, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.query_directory_contents ::Google::Cloud::Dataform::V1beta1::QueryDirectoryContentsRequest.new(workspace: workspace, path: path, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.query_directory_contents({ workspace: workspace, path: path, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.query_directory_contents(::Google::Cloud::Dataform::V1beta1::QueryDirectoryContentsRequest.new(workspace: workspace, path: path, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, query_directory_contents_client_stub.call_count
      end
    end
  end

  def test_search_files
    # Create test objects.
    client_result = ::Google::Cloud::Dataform::V1beta1::SearchFilesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    workspace = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    search_files_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::ServiceStub.stub :transcode_search_files_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, search_files_client_stub do
        # Create client
        client = ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.search_files({ workspace: workspace, page_size: page_size, page_token: page_token, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.search_files workspace: workspace, page_size: page_size, page_token: page_token, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.search_files ::Google::Cloud::Dataform::V1beta1::SearchFilesRequest.new(workspace: workspace, page_size: page_size, page_token: page_token, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.search_files({ workspace: workspace, page_size: page_size, page_token: page_token, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.search_files(::Google::Cloud::Dataform::V1beta1::SearchFilesRequest.new(workspace: workspace, page_size: page_size, page_token: page_token, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, search_files_client_stub.call_count
      end
    end
  end

  def test_make_directory
    # Create test objects.
    client_result = ::Google::Cloud::Dataform::V1beta1::MakeDirectoryResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    workspace = "hello world"
    path = "hello world"

    make_directory_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::ServiceStub.stub :transcode_make_directory_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, make_directory_client_stub do
        # Create client
        client = ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.make_directory({ workspace: workspace, path: path }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.make_directory workspace: workspace, path: path do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.make_directory ::Google::Cloud::Dataform::V1beta1::MakeDirectoryRequest.new(workspace: workspace, path: path) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.make_directory({ workspace: workspace, path: path }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.make_directory(::Google::Cloud::Dataform::V1beta1::MakeDirectoryRequest.new(workspace: workspace, path: path), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, make_directory_client_stub.call_count
      end
    end
  end

  def test_remove_directory
    # Create test objects.
    client_result = ::Google::Cloud::Dataform::V1beta1::RemoveDirectoryResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    workspace = "hello world"
    path = "hello world"

    remove_directory_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::ServiceStub.stub :transcode_remove_directory_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, remove_directory_client_stub do
        # Create client
        client = ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.remove_directory({ workspace: workspace, path: path }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.remove_directory workspace: workspace, path: path do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.remove_directory ::Google::Cloud::Dataform::V1beta1::RemoveDirectoryRequest.new(workspace: workspace, path: path) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.remove_directory({ workspace: workspace, path: path }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.remove_directory(::Google::Cloud::Dataform::V1beta1::RemoveDirectoryRequest.new(workspace: workspace, path: path), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, remove_directory_client_stub.call_count
      end
    end
  end

  def test_move_directory
    # Create test objects.
    client_result = ::Google::Cloud::Dataform::V1beta1::MoveDirectoryResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    workspace = "hello world"
    path = "hello world"
    new_path = "hello world"

    move_directory_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::ServiceStub.stub :transcode_move_directory_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, move_directory_client_stub do
        # Create client
        client = ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.move_directory({ workspace: workspace, path: path, new_path: new_path }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.move_directory workspace: workspace, path: path, new_path: new_path do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.move_directory ::Google::Cloud::Dataform::V1beta1::MoveDirectoryRequest.new(workspace: workspace, path: path, new_path: new_path) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.move_directory({ workspace: workspace, path: path, new_path: new_path }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.move_directory(::Google::Cloud::Dataform::V1beta1::MoveDirectoryRequest.new(workspace: workspace, path: path, new_path: new_path), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, move_directory_client_stub.call_count
      end
    end
  end

  def test_read_file
    # Create test objects.
    client_result = ::Google::Cloud::Dataform::V1beta1::ReadFileResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    workspace = "hello world"
    path = "hello world"
    revision = "hello world"

    read_file_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::ServiceStub.stub :transcode_read_file_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, read_file_client_stub do
        # Create client
        client = ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.read_file({ workspace: workspace, path: path, revision: revision }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.read_file workspace: workspace, path: path, revision: revision do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.read_file ::Google::Cloud::Dataform::V1beta1::ReadFileRequest.new(workspace: workspace, path: path, revision: revision) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.read_file({ workspace: workspace, path: path, revision: revision }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.read_file(::Google::Cloud::Dataform::V1beta1::ReadFileRequest.new(workspace: workspace, path: path, revision: revision), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, read_file_client_stub.call_count
      end
    end
  end

  def test_remove_file
    # Create test objects.
    client_result = ::Google::Cloud::Dataform::V1beta1::RemoveFileResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    workspace = "hello world"
    path = "hello world"

    remove_file_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::ServiceStub.stub :transcode_remove_file_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, remove_file_client_stub do
        # Create client
        client = ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.remove_file({ workspace: workspace, path: path }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.remove_file workspace: workspace, path: path do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.remove_file ::Google::Cloud::Dataform::V1beta1::RemoveFileRequest.new(workspace: workspace, path: path) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.remove_file({ workspace: workspace, path: path }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.remove_file(::Google::Cloud::Dataform::V1beta1::RemoveFileRequest.new(workspace: workspace, path: path), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, remove_file_client_stub.call_count
      end
    end
  end

  def test_move_file
    # Create test objects.
    client_result = ::Google::Cloud::Dataform::V1beta1::MoveFileResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    workspace = "hello world"
    path = "hello world"
    new_path = "hello world"

    move_file_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::ServiceStub.stub :transcode_move_file_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, move_file_client_stub do
        # Create client
        client = ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.move_file({ workspace: workspace, path: path, new_path: new_path }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.move_file workspace: workspace, path: path, new_path: new_path do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.move_file ::Google::Cloud::Dataform::V1beta1::MoveFileRequest.new(workspace: workspace, path: path, new_path: new_path) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.move_file({ workspace: workspace, path: path, new_path: new_path }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.move_file(::Google::Cloud::Dataform::V1beta1::MoveFileRequest.new(workspace: workspace, path: path, new_path: new_path), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, move_file_client_stub.call_count
      end
    end
  end

  def test_write_file
    # Create test objects.
    client_result = ::Google::Cloud::Dataform::V1beta1::WriteFileResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    workspace = "hello world"
    path = "hello world"
    contents = "hello world"

    write_file_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::ServiceStub.stub :transcode_write_file_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, write_file_client_stub do
        # Create client
        client = ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.write_file({ workspace: workspace, path: path, contents: contents }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.write_file workspace: workspace, path: path, contents: contents do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.write_file ::Google::Cloud::Dataform::V1beta1::WriteFileRequest.new(workspace: workspace, path: path, contents: contents) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.write_file({ workspace: workspace, path: path, contents: contents }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.write_file(::Google::Cloud::Dataform::V1beta1::WriteFileRequest.new(workspace: workspace, path: path, contents: contents), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, write_file_client_stub.call_count
      end
    end
  end

  def test_list_release_configs
    # Create test objects.
    client_result = ::Google::Cloud::Dataform::V1beta1::ListReleaseConfigsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_release_configs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::ServiceStub.stub :transcode_list_release_configs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_release_configs_client_stub do
        # Create client
        client = ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_release_configs({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_release_configs parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_release_configs ::Google::Cloud::Dataform::V1beta1::ListReleaseConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_release_configs({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_release_configs(::Google::Cloud::Dataform::V1beta1::ListReleaseConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_release_configs_client_stub.call_count
      end
    end
  end

  def test_get_release_config
    # Create test objects.
    client_result = ::Google::Cloud::Dataform::V1beta1::ReleaseConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_release_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::ServiceStub.stub :transcode_get_release_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_release_config_client_stub do
        # Create client
        client = ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_release_config({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_release_config name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_release_config ::Google::Cloud::Dataform::V1beta1::GetReleaseConfigRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_release_config({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_release_config(::Google::Cloud::Dataform::V1beta1::GetReleaseConfigRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_release_config_client_stub.call_count
      end
    end
  end

  def test_create_release_config
    # Create test objects.
    client_result = ::Google::Cloud::Dataform::V1beta1::ReleaseConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    release_config = {}
    release_config_id = "hello world"

    create_release_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::ServiceStub.stub :transcode_create_release_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_release_config_client_stub do
        # Create client
        client = ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_release_config({ parent: parent, release_config: release_config, release_config_id: release_config_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_release_config parent: parent, release_config: release_config, release_config_id: release_config_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_release_config ::Google::Cloud::Dataform::V1beta1::CreateReleaseConfigRequest.new(parent: parent, release_config: release_config, release_config_id: release_config_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_release_config({ parent: parent, release_config: release_config, release_config_id: release_config_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_release_config(::Google::Cloud::Dataform::V1beta1::CreateReleaseConfigRequest.new(parent: parent, release_config: release_config, release_config_id: release_config_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_release_config_client_stub.call_count
      end
    end
  end

  def test_update_release_config
    # Create test objects.
    client_result = ::Google::Cloud::Dataform::V1beta1::ReleaseConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    release_config = {}

    update_release_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::ServiceStub.stub :transcode_update_release_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_release_config_client_stub do
        # Create client
        client = ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_release_config({ update_mask: update_mask, release_config: release_config }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_release_config update_mask: update_mask, release_config: release_config do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_release_config ::Google::Cloud::Dataform::V1beta1::UpdateReleaseConfigRequest.new(update_mask: update_mask, release_config: release_config) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_release_config({ update_mask: update_mask, release_config: release_config }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_release_config(::Google::Cloud::Dataform::V1beta1::UpdateReleaseConfigRequest.new(update_mask: update_mask, release_config: release_config), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_release_config_client_stub.call_count
      end
    end
  end

  def test_delete_release_config
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_release_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::ServiceStub.stub :transcode_delete_release_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_release_config_client_stub do
        # Create client
        client = ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_release_config({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_release_config name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_release_config ::Google::Cloud::Dataform::V1beta1::DeleteReleaseConfigRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_release_config({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_release_config(::Google::Cloud::Dataform::V1beta1::DeleteReleaseConfigRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_release_config_client_stub.call_count
      end
    end
  end

  def test_list_compilation_results
    # Create test objects.
    client_result = ::Google::Cloud::Dataform::V1beta1::ListCompilationResultsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"
    filter = "hello world"

    list_compilation_results_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::ServiceStub.stub :transcode_list_compilation_results_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_compilation_results_client_stub do
        # Create client
        client = ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_compilation_results({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_compilation_results parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_compilation_results ::Google::Cloud::Dataform::V1beta1::ListCompilationResultsRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_compilation_results({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_compilation_results(::Google::Cloud::Dataform::V1beta1::ListCompilationResultsRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_compilation_results_client_stub.call_count
      end
    end
  end

  def test_get_compilation_result
    # Create test objects.
    client_result = ::Google::Cloud::Dataform::V1beta1::CompilationResult.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_compilation_result_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::ServiceStub.stub :transcode_get_compilation_result_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_compilation_result_client_stub do
        # Create client
        client = ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_compilation_result({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_compilation_result name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_compilation_result ::Google::Cloud::Dataform::V1beta1::GetCompilationResultRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_compilation_result({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_compilation_result(::Google::Cloud::Dataform::V1beta1::GetCompilationResultRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_compilation_result_client_stub.call_count
      end
    end
  end

  def test_create_compilation_result
    # Create test objects.
    client_result = ::Google::Cloud::Dataform::V1beta1::CompilationResult.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    compilation_result = {}

    create_compilation_result_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::ServiceStub.stub :transcode_create_compilation_result_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_compilation_result_client_stub do
        # Create client
        client = ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_compilation_result({ parent: parent, compilation_result: compilation_result }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_compilation_result parent: parent, compilation_result: compilation_result do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_compilation_result ::Google::Cloud::Dataform::V1beta1::CreateCompilationResultRequest.new(parent: parent, compilation_result: compilation_result) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_compilation_result({ parent: parent, compilation_result: compilation_result }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_compilation_result(::Google::Cloud::Dataform::V1beta1::CreateCompilationResultRequest.new(parent: parent, compilation_result: compilation_result), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_compilation_result_client_stub.call_count
      end
    end
  end

  def test_query_compilation_result_actions
    # Create test objects.
    client_result = ::Google::Cloud::Dataform::V1beta1::QueryCompilationResultActionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    query_compilation_result_actions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::ServiceStub.stub :transcode_query_compilation_result_actions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, query_compilation_result_actions_client_stub do
        # Create client
        client = ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.query_compilation_result_actions({ name: name, page_size: page_size, page_token: page_token, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.query_compilation_result_actions name: name, page_size: page_size, page_token: page_token, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.query_compilation_result_actions ::Google::Cloud::Dataform::V1beta1::QueryCompilationResultActionsRequest.new(name: name, page_size: page_size, page_token: page_token, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.query_compilation_result_actions({ name: name, page_size: page_size, page_token: page_token, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.query_compilation_result_actions(::Google::Cloud::Dataform::V1beta1::QueryCompilationResultActionsRequest.new(name: name, page_size: page_size, page_token: page_token, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, query_compilation_result_actions_client_stub.call_count
      end
    end
  end

  def test_list_workflow_configs
    # Create test objects.
    client_result = ::Google::Cloud::Dataform::V1beta1::ListWorkflowConfigsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_workflow_configs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::ServiceStub.stub :transcode_list_workflow_configs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_workflow_configs_client_stub do
        # Create client
        client = ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_workflow_configs({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_workflow_configs parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_workflow_configs ::Google::Cloud::Dataform::V1beta1::ListWorkflowConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_workflow_configs({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_workflow_configs(::Google::Cloud::Dataform::V1beta1::ListWorkflowConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_workflow_configs_client_stub.call_count
      end
    end
  end

  def test_get_workflow_config
    # Create test objects.
    client_result = ::Google::Cloud::Dataform::V1beta1::WorkflowConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_workflow_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::ServiceStub.stub :transcode_get_workflow_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_workflow_config_client_stub do
        # Create client
        client = ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_workflow_config({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_workflow_config name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_workflow_config ::Google::Cloud::Dataform::V1beta1::GetWorkflowConfigRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_workflow_config({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_workflow_config(::Google::Cloud::Dataform::V1beta1::GetWorkflowConfigRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_workflow_config_client_stub.call_count
      end
    end
  end

  def test_create_workflow_config
    # Create test objects.
    client_result = ::Google::Cloud::Dataform::V1beta1::WorkflowConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    workflow_config = {}
    workflow_config_id = "hello world"

    create_workflow_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::ServiceStub.stub :transcode_create_workflow_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_workflow_config_client_stub do
        # Create client
        client = ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_workflow_config({ parent: parent, workflow_config: workflow_config, workflow_config_id: workflow_config_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_workflow_config parent: parent, workflow_config: workflow_config, workflow_config_id: workflow_config_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_workflow_config ::Google::Cloud::Dataform::V1beta1::CreateWorkflowConfigRequest.new(parent: parent, workflow_config: workflow_config, workflow_config_id: workflow_config_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_workflow_config({ parent: parent, workflow_config: workflow_config, workflow_config_id: workflow_config_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_workflow_config(::Google::Cloud::Dataform::V1beta1::CreateWorkflowConfigRequest.new(parent: parent, workflow_config: workflow_config, workflow_config_id: workflow_config_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_workflow_config_client_stub.call_count
      end
    end
  end

  def test_update_workflow_config
    # Create test objects.
    client_result = ::Google::Cloud::Dataform::V1beta1::WorkflowConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    workflow_config = {}

    update_workflow_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::ServiceStub.stub :transcode_update_workflow_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_workflow_config_client_stub do
        # Create client
        client = ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_workflow_config({ update_mask: update_mask, workflow_config: workflow_config }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_workflow_config update_mask: update_mask, workflow_config: workflow_config do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_workflow_config ::Google::Cloud::Dataform::V1beta1::UpdateWorkflowConfigRequest.new(update_mask: update_mask, workflow_config: workflow_config) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_workflow_config({ update_mask: update_mask, workflow_config: workflow_config }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_workflow_config(::Google::Cloud::Dataform::V1beta1::UpdateWorkflowConfigRequest.new(update_mask: update_mask, workflow_config: workflow_config), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_workflow_config_client_stub.call_count
      end
    end
  end

  def test_delete_workflow_config
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_workflow_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::ServiceStub.stub :transcode_delete_workflow_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_workflow_config_client_stub do
        # Create client
        client = ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_workflow_config({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_workflow_config name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_workflow_config ::Google::Cloud::Dataform::V1beta1::DeleteWorkflowConfigRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_workflow_config({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_workflow_config(::Google::Cloud::Dataform::V1beta1::DeleteWorkflowConfigRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_workflow_config_client_stub.call_count
      end
    end
  end

  def test_list_workflow_invocations
    # Create test objects.
    client_result = ::Google::Cloud::Dataform::V1beta1::ListWorkflowInvocationsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"
    filter = "hello world"

    list_workflow_invocations_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::ServiceStub.stub :transcode_list_workflow_invocations_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_workflow_invocations_client_stub do
        # Create client
        client = ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_workflow_invocations({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_workflow_invocations parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_workflow_invocations ::Google::Cloud::Dataform::V1beta1::ListWorkflowInvocationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_workflow_invocations({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_workflow_invocations(::Google::Cloud::Dataform::V1beta1::ListWorkflowInvocationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_workflow_invocations_client_stub.call_count
      end
    end
  end

  def test_get_workflow_invocation
    # Create test objects.
    client_result = ::Google::Cloud::Dataform::V1beta1::WorkflowInvocation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_workflow_invocation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::ServiceStub.stub :transcode_get_workflow_invocation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_workflow_invocation_client_stub do
        # Create client
        client = ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_workflow_invocation({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_workflow_invocation name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_workflow_invocation ::Google::Cloud::Dataform::V1beta1::GetWorkflowInvocationRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_workflow_invocation({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_workflow_invocation(::Google::Cloud::Dataform::V1beta1::GetWorkflowInvocationRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_workflow_invocation_client_stub.call_count
      end
    end
  end

  def test_create_workflow_invocation
    # Create test objects.
    client_result = ::Google::Cloud::Dataform::V1beta1::WorkflowInvocation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    workflow_invocation = {}

    create_workflow_invocation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::ServiceStub.stub :transcode_create_workflow_invocation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_workflow_invocation_client_stub do
        # Create client
        client = ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_workflow_invocation({ parent: parent, workflow_invocation: workflow_invocation }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_workflow_invocation parent: parent, workflow_invocation: workflow_invocation do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_workflow_invocation ::Google::Cloud::Dataform::V1beta1::CreateWorkflowInvocationRequest.new(parent: parent, workflow_invocation: workflow_invocation) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_workflow_invocation({ parent: parent, workflow_invocation: workflow_invocation }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_workflow_invocation(::Google::Cloud::Dataform::V1beta1::CreateWorkflowInvocationRequest.new(parent: parent, workflow_invocation: workflow_invocation), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_workflow_invocation_client_stub.call_count
      end
    end
  end

  def test_delete_workflow_invocation
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_workflow_invocation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::ServiceStub.stub :transcode_delete_workflow_invocation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_workflow_invocation_client_stub do
        # Create client
        client = ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_workflow_invocation({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_workflow_invocation name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_workflow_invocation ::Google::Cloud::Dataform::V1beta1::DeleteWorkflowInvocationRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_workflow_invocation({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_workflow_invocation(::Google::Cloud::Dataform::V1beta1::DeleteWorkflowInvocationRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_workflow_invocation_client_stub.call_count
      end
    end
  end

  def test_cancel_workflow_invocation
    # Create test objects.
    client_result = ::Google::Cloud::Dataform::V1beta1::CancelWorkflowInvocationResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    cancel_workflow_invocation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::ServiceStub.stub :transcode_cancel_workflow_invocation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, cancel_workflow_invocation_client_stub do
        # Create client
        client = ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.cancel_workflow_invocation({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.cancel_workflow_invocation name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.cancel_workflow_invocation ::Google::Cloud::Dataform::V1beta1::CancelWorkflowInvocationRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.cancel_workflow_invocation({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.cancel_workflow_invocation(::Google::Cloud::Dataform::V1beta1::CancelWorkflowInvocationRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, cancel_workflow_invocation_client_stub.call_count
      end
    end
  end

  def test_query_workflow_invocation_actions
    # Create test objects.
    client_result = ::Google::Cloud::Dataform::V1beta1::QueryWorkflowInvocationActionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    page_size = 42
    page_token = "hello world"

    query_workflow_invocation_actions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::ServiceStub.stub :transcode_query_workflow_invocation_actions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, query_workflow_invocation_actions_client_stub do
        # Create client
        client = ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.query_workflow_invocation_actions({ name: name, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.query_workflow_invocation_actions name: name, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.query_workflow_invocation_actions ::Google::Cloud::Dataform::V1beta1::QueryWorkflowInvocationActionsRequest.new(name: name, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.query_workflow_invocation_actions({ name: name, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.query_workflow_invocation_actions(::Google::Cloud::Dataform::V1beta1::QueryWorkflowInvocationActionsRequest.new(name: name, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, query_workflow_invocation_actions_client_stub.call_count
      end
    end
  end

  def test_get_config
    # Create test objects.
    client_result = ::Google::Cloud::Dataform::V1beta1::Config.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::ServiceStub.stub :transcode_get_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_config_client_stub do
        # Create client
        client = ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_config({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_config name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_config ::Google::Cloud::Dataform::V1beta1::GetConfigRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_config({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_config(::Google::Cloud::Dataform::V1beta1::GetConfigRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_config_client_stub.call_count
      end
    end
  end

  def test_update_config
    # Create test objects.
    client_result = ::Google::Cloud::Dataform::V1beta1::Config.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    config = {}
    update_mask = {}

    update_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::ServiceStub.stub :transcode_update_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_config_client_stub do
        # Create client
        client = ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_config({ config: config, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_config config: config, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_config ::Google::Cloud::Dataform::V1beta1::UpdateConfigRequest.new(config: config, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_config({ config: config, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_config(::Google::Cloud::Dataform::V1beta1::UpdateConfigRequest.new(config: config, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_config_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Dataform::V1beta1::Dataform::Rest::Client::Configuration, config
  end
end
