# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/dataform/v1beta1/dataform_pb"
require "google/cloud/location"
require "google/iam/v1"

module Google
  module Cloud
    module Dataform
      module V1beta1
        module Dataform
          ##
          # Client for the Dataform service.
          #
          # Dataform is a service to develop, create, document, test, and update curated
          # tables in BigQuery.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "dataform.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :dataform_stub

            ##
            # Configure the Dataform Client class.
            #
            # See {::Google::Cloud::Dataform::V1beta1::Dataform::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all Dataform clients
            #   ::Google::Cloud::Dataform::V1beta1::Dataform::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "Dataform", "V1beta1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the Dataform Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::Dataform::V1beta1::Dataform::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @dataform_stub.universe_domain
            end

            ##
            # Create a new Dataform client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::Dataform::V1beta1::Dataform::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::Dataform::V1beta1::Dataform::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Dataform client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/dataform/v1beta1/dataform_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @dataform_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::Dataform::V1beta1::Dataform::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @dataform_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @location_client = Google::Cloud::Location::Locations::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @dataform_stub.endpoint
                config.universe_domain = @dataform_stub.universe_domain
                config.logger = @dataform_stub.logger if config.respond_to? :logger=
              end

              @iam_policy_client = Google::Iam::V1::IAMPolicy::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @dataform_stub.endpoint
                config.universe_domain = @dataform_stub.universe_domain
                config.logger = @dataform_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for mix-in of the Locations.
            #
            # @return [Google::Cloud::Location::Locations::Client]
            #
            attr_reader :location_client

            ##
            # Get the associated client for mix-in of the IAMPolicy.
            #
            # @return [Google::Iam::V1::IAMPolicy::Client]
            #
            attr_reader :iam_policy_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @dataform_stub.logger
            end

            # Service calls

            ##
            # Lists Repositories in a given project and location.
            #
            # **Note:** *This method can return repositories not shown in the [Dataform
            # UI](https://console.cloud.google.com/bigquery/dataform)*.
            #
            # @overload list_repositories(request, options = nil)
            #   Pass arguments to `list_repositories` via a request object, either of type
            #   {::Google::Cloud::Dataform::V1beta1::ListRepositoriesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataform::V1beta1::ListRepositoriesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_repositories(parent: nil, page_size: nil, page_token: nil, order_by: nil, filter: nil)
            #   Pass arguments to `list_repositories` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The location in which to list repositories. Must be in the format
            #     `projects/*/locations/*`.
            #   @param page_size [::Integer]
            #     Optional. Maximum number of repositories to return. The server may return
            #     fewer items than requested. If unspecified, the server will pick an
            #     appropriate default.
            #   @param page_token [::String]
            #     Optional. Page token received from a previous `ListRepositories` call.
            #     Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to `ListRepositories`,
            #     with the exception of `page_size`, must match the call that provided the
            #     page token.
            #   @param order_by [::String]
            #     Optional. This field only supports ordering by `name`. If unspecified, the
            #     server will choose the ordering. If specified, the default order is
            #     ascending for the `name` field.
            #   @param filter [::String]
            #     Optional. Filter for the returned list.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Dataform::V1beta1::Repository>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Dataform::V1beta1::Repository>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataform/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataform::V1beta1::Dataform::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataform::V1beta1::ListRepositoriesRequest.new
            #
            #   # Call the list_repositories method.
            #   result = client.list_repositories request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Dataform::V1beta1::Repository.
            #     p item
            #   end
            #
            def list_repositories request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataform::V1beta1::ListRepositoriesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_repositories.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataform::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_repositories.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_repositories.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dataform_stub.call_rpc :list_repositories, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @dataform_stub, :list_repositories, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Fetches a single Repository.
            #
            # @overload get_repository(request, options = nil)
            #   Pass arguments to `get_repository` via a request object, either of type
            #   {::Google::Cloud::Dataform::V1beta1::GetRepositoryRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataform::V1beta1::GetRepositoryRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_repository(name: nil)
            #   Pass arguments to `get_repository` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The repository's name.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Dataform::V1beta1::Repository]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Dataform::V1beta1::Repository]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataform/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataform::V1beta1::Dataform::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataform::V1beta1::GetRepositoryRequest.new
            #
            #   # Call the get_repository method.
            #   result = client.get_repository request
            #
            #   # The returned object is of type Google::Cloud::Dataform::V1beta1::Repository.
            #   p result
            #
            def get_repository request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataform::V1beta1::GetRepositoryRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_repository.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataform::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_repository.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_repository.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dataform_stub.call_rpc :get_repository, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new Repository in a given project and location.
            #
            # @overload create_repository(request, options = nil)
            #   Pass arguments to `create_repository` via a request object, either of type
            #   {::Google::Cloud::Dataform::V1beta1::CreateRepositoryRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataform::V1beta1::CreateRepositoryRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_repository(parent: nil, repository: nil, repository_id: nil)
            #   Pass arguments to `create_repository` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The location in which to create the repository. Must be in the
            #     format `projects/*/locations/*`.
            #   @param repository [::Google::Cloud::Dataform::V1beta1::Repository, ::Hash]
            #     Required. The repository to create.
            #   @param repository_id [::String]
            #     Required. The ID to use for the repository, which will become the final
            #     component of the repository's resource name.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Dataform::V1beta1::Repository]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Dataform::V1beta1::Repository]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataform/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataform::V1beta1::Dataform::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataform::V1beta1::CreateRepositoryRequest.new
            #
            #   # Call the create_repository method.
            #   result = client.create_repository request
            #
            #   # The returned object is of type Google::Cloud::Dataform::V1beta1::Repository.
            #   p result
            #
            def create_repository request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataform::V1beta1::CreateRepositoryRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_repository.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataform::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_repository.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_repository.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dataform_stub.call_rpc :create_repository, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a single Repository.
            #
            # **Note:** *This method does not fully implement
            # [AIP/134](https://google.aip.dev/134). The wildcard entry (\*) is treated
            # as a bad request, and when the `field_mask` is omitted, the request is
            # treated as a full update on all modifiable fields.*
            #
            # @overload update_repository(request, options = nil)
            #   Pass arguments to `update_repository` via a request object, either of type
            #   {::Google::Cloud::Dataform::V1beta1::UpdateRepositoryRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataform::V1beta1::UpdateRepositoryRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_repository(update_mask: nil, repository: nil)
            #   Pass arguments to `update_repository` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Optional. Specifies the fields to be updated in the repository. If left
            #     unset, all fields will be updated.
            #   @param repository [::Google::Cloud::Dataform::V1beta1::Repository, ::Hash]
            #     Required. The repository to update.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Dataform::V1beta1::Repository]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Dataform::V1beta1::Repository]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataform/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataform::V1beta1::Dataform::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataform::V1beta1::UpdateRepositoryRequest.new
            #
            #   # Call the update_repository method.
            #   result = client.update_repository request
            #
            #   # The returned object is of type Google::Cloud::Dataform::V1beta1::Repository.
            #   p result
            #
            def update_repository request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataform::V1beta1::UpdateRepositoryRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_repository.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataform::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.repository&.name
                header_params["repository.name"] = request.repository.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_repository.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_repository.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dataform_stub.call_rpc :update_repository, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single Repository.
            #
            # @overload delete_repository(request, options = nil)
            #   Pass arguments to `delete_repository` via a request object, either of type
            #   {::Google::Cloud::Dataform::V1beta1::DeleteRepositoryRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataform::V1beta1::DeleteRepositoryRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_repository(name: nil, force: nil)
            #   Pass arguments to `delete_repository` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The repository's name.
            #   @param force [::Boolean]
            #     Optional. If set to true, any child resources of this repository will also
            #     be deleted. (Otherwise, the request will only succeed if the repository has
            #     no child resources.)
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataform/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataform::V1beta1::Dataform::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataform::V1beta1::DeleteRepositoryRequest.new
            #
            #   # Call the delete_repository method.
            #   result = client.delete_repository request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_repository request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataform::V1beta1::DeleteRepositoryRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_repository.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataform::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_repository.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_repository.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dataform_stub.call_rpc :delete_repository, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Applies a Git commit to a Repository. The Repository must not have a value
            # for `git_remote_settings.url`.
            #
            # @overload commit_repository_changes(request, options = nil)
            #   Pass arguments to `commit_repository_changes` via a request object, either of type
            #   {::Google::Cloud::Dataform::V1beta1::CommitRepositoryChangesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataform::V1beta1::CommitRepositoryChangesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload commit_repository_changes(name: nil, commit_metadata: nil, required_head_commit_sha: nil, file_operations: nil)
            #   Pass arguments to `commit_repository_changes` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The repository's name.
            #   @param commit_metadata [::Google::Cloud::Dataform::V1beta1::CommitMetadata, ::Hash]
            #     Required. The changes to commit to the repository.
            #   @param required_head_commit_sha [::String]
            #     Optional. The commit SHA which must be the repository's current HEAD before
            #     applying this commit; otherwise this request will fail. If unset, no
            #     validation on the current HEAD commit SHA is performed.
            #   @param file_operations [::Hash{::String => ::Google::Cloud::Dataform::V1beta1::CommitRepositoryChangesRequest::FileOperation, ::Hash}]
            #     Optional. A map to the path of the file to the operation. The path is the
            #     full file path including filename, from repository root.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Dataform::V1beta1::CommitRepositoryChangesResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Dataform::V1beta1::CommitRepositoryChangesResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataform/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataform::V1beta1::Dataform::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataform::V1beta1::CommitRepositoryChangesRequest.new
            #
            #   # Call the commit_repository_changes method.
            #   result = client.commit_repository_changes request
            #
            #   # The returned object is of type Google::Cloud::Dataform::V1beta1::CommitRepositoryChangesResponse.
            #   p result
            #
            def commit_repository_changes request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataform::V1beta1::CommitRepositoryChangesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.commit_repository_changes.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataform::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.commit_repository_changes.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.commit_repository_changes.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dataform_stub.call_rpc :commit_repository_changes, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns the contents of a file (inside a Repository). The Repository
            # must not have a value for `git_remote_settings.url`.
            #
            # @overload read_repository_file(request, options = nil)
            #   Pass arguments to `read_repository_file` via a request object, either of type
            #   {::Google::Cloud::Dataform::V1beta1::ReadRepositoryFileRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataform::V1beta1::ReadRepositoryFileRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload read_repository_file(name: nil, commit_sha: nil, path: nil)
            #   Pass arguments to `read_repository_file` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The repository's name.
            #   @param commit_sha [::String]
            #     Optional. The commit SHA for the commit to read from. If unset, the file
            #     will be read from HEAD.
            #   @param path [::String]
            #     Required. Full file path to read including filename, from repository root.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Dataform::V1beta1::ReadRepositoryFileResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Dataform::V1beta1::ReadRepositoryFileResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataform/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataform::V1beta1::Dataform::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataform::V1beta1::ReadRepositoryFileRequest.new
            #
            #   # Call the read_repository_file method.
            #   result = client.read_repository_file request
            #
            #   # The returned object is of type Google::Cloud::Dataform::V1beta1::ReadRepositoryFileResponse.
            #   p result
            #
            def read_repository_file request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataform::V1beta1::ReadRepositoryFileRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.read_repository_file.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataform::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.read_repository_file.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.read_repository_file.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dataform_stub.call_rpc :read_repository_file, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns the contents of a given Repository directory. The Repository must
            # not have a value for `git_remote_settings.url`.
            #
            # @overload query_repository_directory_contents(request, options = nil)
            #   Pass arguments to `query_repository_directory_contents` via a request object, either of type
            #   {::Google::Cloud::Dataform::V1beta1::QueryRepositoryDirectoryContentsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataform::V1beta1::QueryRepositoryDirectoryContentsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload query_repository_directory_contents(name: nil, commit_sha: nil, path: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `query_repository_directory_contents` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The repository's name.
            #   @param commit_sha [::String]
            #     Optional. The Commit SHA for the commit to query from. If unset, the
            #     directory will be queried from HEAD.
            #   @param path [::String]
            #     Optional. The directory's full path including directory name, relative to
            #     root. If left unset, the root is used.
            #   @param page_size [::Integer]
            #     Optional. Maximum number of paths to return. The server may return fewer
            #     items than requested. If unspecified, the server will pick an appropriate
            #     default.
            #   @param page_token [::String]
            #     Optional. Page token received from a previous
            #     `QueryRepositoryDirectoryContents` call. Provide this to retrieve the
            #     subsequent page.
            #
            #     When paginating, all other parameters provided to
            #     `QueryRepositoryDirectoryContents`, with the exception of `page_size`, must
            #     match the call that provided the page token.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Dataform::V1beta1::DirectoryEntry>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Dataform::V1beta1::DirectoryEntry>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataform/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataform::V1beta1::Dataform::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataform::V1beta1::QueryRepositoryDirectoryContentsRequest.new
            #
            #   # Call the query_repository_directory_contents method.
            #   result = client.query_repository_directory_contents request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Dataform::V1beta1::DirectoryEntry.
            #     p item
            #   end
            #
            def query_repository_directory_contents request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataform::V1beta1::QueryRepositoryDirectoryContentsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.query_repository_directory_contents.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataform::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.query_repository_directory_contents.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.query_repository_directory_contents.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dataform_stub.call_rpc :query_repository_directory_contents, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @dataform_stub, :query_repository_directory_contents, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Fetches a Repository's history of commits.  The Repository must not have a
            # value for `git_remote_settings.url`.
            #
            # @overload fetch_repository_history(request, options = nil)
            #   Pass arguments to `fetch_repository_history` via a request object, either of type
            #   {::Google::Cloud::Dataform::V1beta1::FetchRepositoryHistoryRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataform::V1beta1::FetchRepositoryHistoryRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload fetch_repository_history(name: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `fetch_repository_history` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The repository's name.
            #   @param page_size [::Integer]
            #     Optional. Maximum number of commits to return. The server may return fewer
            #     items than requested. If unspecified, the server will pick an appropriate
            #     default.
            #   @param page_token [::String]
            #     Optional. Page token received from a previous `FetchRepositoryHistory`
            #     call. Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to `FetchRepositoryHistory`,
            #     with the exception of `page_size`, must match the call that provided the
            #     page token.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Dataform::V1beta1::CommitLogEntry>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Dataform::V1beta1::CommitLogEntry>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataform/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataform::V1beta1::Dataform::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataform::V1beta1::FetchRepositoryHistoryRequest.new
            #
            #   # Call the fetch_repository_history method.
            #   result = client.fetch_repository_history request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Dataform::V1beta1::CommitLogEntry.
            #     p item
            #   end
            #
            def fetch_repository_history request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataform::V1beta1::FetchRepositoryHistoryRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.fetch_repository_history.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataform::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.fetch_repository_history.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.fetch_repository_history.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dataform_stub.call_rpc :fetch_repository_history, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @dataform_stub, :fetch_repository_history, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Computes a Repository's Git access token status.
            #
            # @overload compute_repository_access_token_status(request, options = nil)
            #   Pass arguments to `compute_repository_access_token_status` via a request object, either of type
            #   {::Google::Cloud::Dataform::V1beta1::ComputeRepositoryAccessTokenStatusRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataform::V1beta1::ComputeRepositoryAccessTokenStatusRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload compute_repository_access_token_status(name: nil)
            #   Pass arguments to `compute_repository_access_token_status` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The repository's name.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Dataform::V1beta1::ComputeRepositoryAccessTokenStatusResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Dataform::V1beta1::ComputeRepositoryAccessTokenStatusResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataform/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataform::V1beta1::Dataform::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataform::V1beta1::ComputeRepositoryAccessTokenStatusRequest.new
            #
            #   # Call the compute_repository_access_token_status method.
            #   result = client.compute_repository_access_token_status request
            #
            #   # The returned object is of type Google::Cloud::Dataform::V1beta1::ComputeRepositoryAccessTokenStatusResponse.
            #   p result
            #
            def compute_repository_access_token_status request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataform::V1beta1::ComputeRepositoryAccessTokenStatusRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.compute_repository_access_token_status.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataform::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.compute_repository_access_token_status.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.compute_repository_access_token_status.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dataform_stub.call_rpc :compute_repository_access_token_status, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Fetches a Repository's remote branches.
            #
            # @overload fetch_remote_branches(request, options = nil)
            #   Pass arguments to `fetch_remote_branches` via a request object, either of type
            #   {::Google::Cloud::Dataform::V1beta1::FetchRemoteBranchesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataform::V1beta1::FetchRemoteBranchesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload fetch_remote_branches(name: nil)
            #   Pass arguments to `fetch_remote_branches` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The repository's name.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Dataform::V1beta1::FetchRemoteBranchesResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Dataform::V1beta1::FetchRemoteBranchesResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataform/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataform::V1beta1::Dataform::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataform::V1beta1::FetchRemoteBranchesRequest.new
            #
            #   # Call the fetch_remote_branches method.
            #   result = client.fetch_remote_branches request
            #
            #   # The returned object is of type Google::Cloud::Dataform::V1beta1::FetchRemoteBranchesResponse.
            #   p result
            #
            def fetch_remote_branches request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataform::V1beta1::FetchRemoteBranchesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.fetch_remote_branches.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataform::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.fetch_remote_branches.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.fetch_remote_branches.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dataform_stub.call_rpc :fetch_remote_branches, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists Workspaces in a given Repository.
            #
            # @overload list_workspaces(request, options = nil)
            #   Pass arguments to `list_workspaces` via a request object, either of type
            #   {::Google::Cloud::Dataform::V1beta1::ListWorkspacesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataform::V1beta1::ListWorkspacesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_workspaces(parent: nil, page_size: nil, page_token: nil, order_by: nil, filter: nil)
            #   Pass arguments to `list_workspaces` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The repository in which to list workspaces. Must be in the
            #     format `projects/*/locations/*/repositories/*`.
            #   @param page_size [::Integer]
            #     Optional. Maximum number of workspaces to return. The server may return
            #     fewer items than requested. If unspecified, the server will pick an
            #     appropriate default.
            #   @param page_token [::String]
            #     Optional. Page token received from a previous `ListWorkspaces` call.
            #     Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to `ListWorkspaces`, with
            #     the exception of `page_size`, must match the call that provided the page
            #     token.
            #   @param order_by [::String]
            #     Optional. This field only supports ordering by `name`. If unspecified, the
            #     server will choose the ordering. If specified, the default order is
            #     ascending for the `name` field.
            #   @param filter [::String]
            #     Optional. Filter for the returned list.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Dataform::V1beta1::Workspace>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Dataform::V1beta1::Workspace>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataform/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataform::V1beta1::Dataform::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataform::V1beta1::ListWorkspacesRequest.new
            #
            #   # Call the list_workspaces method.
            #   result = client.list_workspaces request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Dataform::V1beta1::Workspace.
            #     p item
            #   end
            #
            def list_workspaces request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataform::V1beta1::ListWorkspacesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_workspaces.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataform::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_workspaces.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_workspaces.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dataform_stub.call_rpc :list_workspaces, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @dataform_stub, :list_workspaces, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Fetches a single Workspace.
            #
            # @overload get_workspace(request, options = nil)
            #   Pass arguments to `get_workspace` via a request object, either of type
            #   {::Google::Cloud::Dataform::V1beta1::GetWorkspaceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataform::V1beta1::GetWorkspaceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_workspace(name: nil)
            #   Pass arguments to `get_workspace` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The workspace's name.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Dataform::V1beta1::Workspace]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Dataform::V1beta1::Workspace]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataform/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataform::V1beta1::Dataform::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataform::V1beta1::GetWorkspaceRequest.new
            #
            #   # Call the get_workspace method.
            #   result = client.get_workspace request
            #
            #   # The returned object is of type Google::Cloud::Dataform::V1beta1::Workspace.
            #   p result
            #
            def get_workspace request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataform::V1beta1::GetWorkspaceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_workspace.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataform::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_workspace.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_workspace.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dataform_stub.call_rpc :get_workspace, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new Workspace in a given Repository.
            #
            # @overload create_workspace(request, options = nil)
            #   Pass arguments to `create_workspace` via a request object, either of type
            #   {::Google::Cloud::Dataform::V1beta1::CreateWorkspaceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataform::V1beta1::CreateWorkspaceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_workspace(parent: nil, workspace: nil, workspace_id: nil)
            #   Pass arguments to `create_workspace` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The repository in which to create the workspace. Must be in the
            #     format `projects/*/locations/*/repositories/*`.
            #   @param workspace [::Google::Cloud::Dataform::V1beta1::Workspace, ::Hash]
            #     Required. The workspace to create.
            #   @param workspace_id [::String]
            #     Required. The ID to use for the workspace, which will become the final
            #     component of the workspace's resource name.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Dataform::V1beta1::Workspace]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Dataform::V1beta1::Workspace]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataform/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataform::V1beta1::Dataform::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataform::V1beta1::CreateWorkspaceRequest.new
            #
            #   # Call the create_workspace method.
            #   result = client.create_workspace request
            #
            #   # The returned object is of type Google::Cloud::Dataform::V1beta1::Workspace.
            #   p result
            #
            def create_workspace request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataform::V1beta1::CreateWorkspaceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_workspace.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataform::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_workspace.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_workspace.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dataform_stub.call_rpc :create_workspace, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single Workspace.
            #
            # @overload delete_workspace(request, options = nil)
            #   Pass arguments to `delete_workspace` via a request object, either of type
            #   {::Google::Cloud::Dataform::V1beta1::DeleteWorkspaceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataform::V1beta1::DeleteWorkspaceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_workspace(name: nil)
            #   Pass arguments to `delete_workspace` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The workspace resource's name.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataform/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataform::V1beta1::Dataform::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataform::V1beta1::DeleteWorkspaceRequest.new
            #
            #   # Call the delete_workspace method.
            #   result = client.delete_workspace request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_workspace request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataform::V1beta1::DeleteWorkspaceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_workspace.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataform::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_workspace.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_workspace.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dataform_stub.call_rpc :delete_workspace, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Installs dependency NPM packages (inside a Workspace).
            #
            # @overload install_npm_packages(request, options = nil)
            #   Pass arguments to `install_npm_packages` via a request object, either of type
            #   {::Google::Cloud::Dataform::V1beta1::InstallNpmPackagesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataform::V1beta1::InstallNpmPackagesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload install_npm_packages(workspace: nil)
            #   Pass arguments to `install_npm_packages` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param workspace [::String]
            #     Required. The workspace's name.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Dataform::V1beta1::InstallNpmPackagesResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Dataform::V1beta1::InstallNpmPackagesResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataform/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataform::V1beta1::Dataform::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataform::V1beta1::InstallNpmPackagesRequest.new
            #
            #   # Call the install_npm_packages method.
            #   result = client.install_npm_packages request
            #
            #   # The returned object is of type Google::Cloud::Dataform::V1beta1::InstallNpmPackagesResponse.
            #   p result
            #
            def install_npm_packages request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataform::V1beta1::InstallNpmPackagesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.install_npm_packages.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataform::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.workspace
                header_params["workspace"] = request.workspace
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.install_npm_packages.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.install_npm_packages.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dataform_stub.call_rpc :install_npm_packages, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Pulls Git commits from the Repository's remote into a Workspace.
            #
            # @overload pull_git_commits(request, options = nil)
            #   Pass arguments to `pull_git_commits` via a request object, either of type
            #   {::Google::Cloud::Dataform::V1beta1::PullGitCommitsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataform::V1beta1::PullGitCommitsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload pull_git_commits(name: nil, remote_branch: nil, author: nil)
            #   Pass arguments to `pull_git_commits` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The workspace's name.
            #   @param remote_branch [::String]
            #     Optional. The name of the branch in the Git remote from which to pull
            #     commits. If left unset, the repository's default branch name will be used.
            #   @param author [::Google::Cloud::Dataform::V1beta1::CommitAuthor, ::Hash]
            #     Required. The author of any merge commit which may be created as a result
            #     of merging fetched Git commits into this workspace.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Dataform::V1beta1::PullGitCommitsResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Dataform::V1beta1::PullGitCommitsResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataform/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataform::V1beta1::Dataform::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataform::V1beta1::PullGitCommitsRequest.new
            #
            #   # Call the pull_git_commits method.
            #   result = client.pull_git_commits request
            #
            #   # The returned object is of type Google::Cloud::Dataform::V1beta1::PullGitCommitsResponse.
            #   p result
            #
            def pull_git_commits request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataform::V1beta1::PullGitCommitsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.pull_git_commits.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataform::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.pull_git_commits.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.pull_git_commits.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dataform_stub.call_rpc :pull_git_commits, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Pushes Git commits from a Workspace to the Repository's remote.
            #
            # @overload push_git_commits(request, options = nil)
            #   Pass arguments to `push_git_commits` via a request object, either of type
            #   {::Google::Cloud::Dataform::V1beta1::PushGitCommitsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataform::V1beta1::PushGitCommitsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload push_git_commits(name: nil, remote_branch: nil)
            #   Pass arguments to `push_git_commits` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The workspace's name.
            #   @param remote_branch [::String]
            #     Optional. The name of the branch in the Git remote to which commits should
            #     be pushed. If left unset, the repository's default branch name will be
            #     used.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Dataform::V1beta1::PushGitCommitsResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Dataform::V1beta1::PushGitCommitsResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataform/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataform::V1beta1::Dataform::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataform::V1beta1::PushGitCommitsRequest.new
            #
            #   # Call the push_git_commits method.
            #   result = client.push_git_commits request
            #
            #   # The returned object is of type Google::Cloud::Dataform::V1beta1::PushGitCommitsResponse.
            #   p result
            #
            def push_git_commits request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataform::V1beta1::PushGitCommitsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.push_git_commits.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataform::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.push_git_commits.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.push_git_commits.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dataform_stub.call_rpc :push_git_commits, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Fetches Git statuses for the files in a Workspace.
            #
            # @overload fetch_file_git_statuses(request, options = nil)
            #   Pass arguments to `fetch_file_git_statuses` via a request object, either of type
            #   {::Google::Cloud::Dataform::V1beta1::FetchFileGitStatusesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataform::V1beta1::FetchFileGitStatusesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload fetch_file_git_statuses(name: nil)
            #   Pass arguments to `fetch_file_git_statuses` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The workspace's name.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Dataform::V1beta1::FetchFileGitStatusesResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Dataform::V1beta1::FetchFileGitStatusesResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataform/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataform::V1beta1::Dataform::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataform::V1beta1::FetchFileGitStatusesRequest.new
            #
            #   # Call the fetch_file_git_statuses method.
            #   result = client.fetch_file_git_statuses request
            #
            #   # The returned object is of type Google::Cloud::Dataform::V1beta1::FetchFileGitStatusesResponse.
            #   p result
            #
            def fetch_file_git_statuses request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataform::V1beta1::FetchFileGitStatusesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.fetch_file_git_statuses.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataform::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.fetch_file_git_statuses.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.fetch_file_git_statuses.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dataform_stub.call_rpc :fetch_file_git_statuses, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Fetches Git ahead/behind against a remote branch.
            #
            # @overload fetch_git_ahead_behind(request, options = nil)
            #   Pass arguments to `fetch_git_ahead_behind` via a request object, either of type
            #   {::Google::Cloud::Dataform::V1beta1::FetchGitAheadBehindRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataform::V1beta1::FetchGitAheadBehindRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload fetch_git_ahead_behind(name: nil, remote_branch: nil)
            #   Pass arguments to `fetch_git_ahead_behind` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The workspace's name.
            #   @param remote_branch [::String]
            #     Optional. The name of the branch in the Git remote against which this
            #     workspace should be compared. If left unset, the repository's default
            #     branch name will be used.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Dataform::V1beta1::FetchGitAheadBehindResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Dataform::V1beta1::FetchGitAheadBehindResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataform/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataform::V1beta1::Dataform::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataform::V1beta1::FetchGitAheadBehindRequest.new
            #
            #   # Call the fetch_git_ahead_behind method.
            #   result = client.fetch_git_ahead_behind request
            #
            #   # The returned object is of type Google::Cloud::Dataform::V1beta1::FetchGitAheadBehindResponse.
            #   p result
            #
            def fetch_git_ahead_behind request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataform::V1beta1::FetchGitAheadBehindRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.fetch_git_ahead_behind.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataform::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.fetch_git_ahead_behind.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.fetch_git_ahead_behind.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dataform_stub.call_rpc :fetch_git_ahead_behind, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Applies a Git commit for uncommitted files in a Workspace.
            #
            # @overload commit_workspace_changes(request, options = nil)
            #   Pass arguments to `commit_workspace_changes` via a request object, either of type
            #   {::Google::Cloud::Dataform::V1beta1::CommitWorkspaceChangesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataform::V1beta1::CommitWorkspaceChangesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload commit_workspace_changes(name: nil, author: nil, commit_message: nil, paths: nil)
            #   Pass arguments to `commit_workspace_changes` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The workspace's name.
            #   @param author [::Google::Cloud::Dataform::V1beta1::CommitAuthor, ::Hash]
            #     Required. The commit's author.
            #   @param commit_message [::String]
            #     Optional. The commit's message.
            #   @param paths [::Array<::String>]
            #     Optional. Full file paths to commit including filename, rooted at workspace
            #     root. If left empty, all files will be committed.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Dataform::V1beta1::CommitWorkspaceChangesResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Dataform::V1beta1::CommitWorkspaceChangesResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataform/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataform::V1beta1::Dataform::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataform::V1beta1::CommitWorkspaceChangesRequest.new
            #
            #   # Call the commit_workspace_changes method.
            #   result = client.commit_workspace_changes request
            #
            #   # The returned object is of type Google::Cloud::Dataform::V1beta1::CommitWorkspaceChangesResponse.
            #   p result
            #
            def commit_workspace_changes request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataform::V1beta1::CommitWorkspaceChangesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.commit_workspace_changes.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataform::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.commit_workspace_changes.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.commit_workspace_changes.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dataform_stub.call_rpc :commit_workspace_changes, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Performs a Git reset for uncommitted files in a Workspace.
            #
            # @overload reset_workspace_changes(request, options = nil)
            #   Pass arguments to `reset_workspace_changes` via a request object, either of type
            #   {::Google::Cloud::Dataform::V1beta1::ResetWorkspaceChangesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataform::V1beta1::ResetWorkspaceChangesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload reset_workspace_changes(name: nil, paths: nil, clean: nil)
            #   Pass arguments to `reset_workspace_changes` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The workspace's name.
            #   @param paths [::Array<::String>]
            #     Optional. Full file paths to reset back to their committed state including
            #     filename, rooted at workspace root. If left empty, all files will be reset.
            #   @param clean [::Boolean]
            #     Optional. If set to true, untracked files will be deleted.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Dataform::V1beta1::ResetWorkspaceChangesResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Dataform::V1beta1::ResetWorkspaceChangesResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataform/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataform::V1beta1::Dataform::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataform::V1beta1::ResetWorkspaceChangesRequest.new
            #
            #   # Call the reset_workspace_changes method.
            #   result = client.reset_workspace_changes request
            #
            #   # The returned object is of type Google::Cloud::Dataform::V1beta1::ResetWorkspaceChangesResponse.
            #   p result
            #
            def reset_workspace_changes request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataform::V1beta1::ResetWorkspaceChangesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.reset_workspace_changes.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataform::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.reset_workspace_changes.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.reset_workspace_changes.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dataform_stub.call_rpc :reset_workspace_changes, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Fetches Git diff for an uncommitted file in a Workspace.
            #
            # @overload fetch_file_diff(request, options = nil)
            #   Pass arguments to `fetch_file_diff` via a request object, either of type
            #   {::Google::Cloud::Dataform::V1beta1::FetchFileDiffRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataform::V1beta1::FetchFileDiffRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload fetch_file_diff(workspace: nil, path: nil)
            #   Pass arguments to `fetch_file_diff` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param workspace [::String]
            #     Required. The workspace's name.
            #   @param path [::String]
            #     Required. The file's full path including filename, relative to the
            #     workspace root.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Dataform::V1beta1::FetchFileDiffResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Dataform::V1beta1::FetchFileDiffResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataform/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataform::V1beta1::Dataform::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataform::V1beta1::FetchFileDiffRequest.new
            #
            #   # Call the fetch_file_diff method.
            #   result = client.fetch_file_diff request
            #
            #   # The returned object is of type Google::Cloud::Dataform::V1beta1::FetchFileDiffResponse.
            #   p result
            #
            def fetch_file_diff request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataform::V1beta1::FetchFileDiffRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.fetch_file_diff.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataform::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.workspace
                header_params["workspace"] = request.workspace
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.fetch_file_diff.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.fetch_file_diff.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dataform_stub.call_rpc :fetch_file_diff, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns the contents of a given Workspace directory.
            #
            # @overload query_directory_contents(request, options = nil)
            #   Pass arguments to `query_directory_contents` via a request object, either of type
            #   {::Google::Cloud::Dataform::V1beta1::QueryDirectoryContentsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataform::V1beta1::QueryDirectoryContentsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload query_directory_contents(workspace: nil, path: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `query_directory_contents` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param workspace [::String]
            #     Required. The workspace's name.
            #   @param path [::String]
            #     Optional. The directory's full path including directory name, relative to
            #     the workspace root. If left unset, the workspace root is used.
            #   @param page_size [::Integer]
            #     Optional. Maximum number of paths to return. The server may return fewer
            #     items than requested. If unspecified, the server will pick an appropriate
            #     default.
            #   @param page_token [::String]
            #     Optional. Page token received from a previous `QueryDirectoryContents`
            #     call. Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to
            #     `QueryDirectoryContents`, with the exception of `page_size`, must match the
            #     call that provided the page token.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Dataform::V1beta1::DirectoryEntry>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Dataform::V1beta1::DirectoryEntry>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataform/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataform::V1beta1::Dataform::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataform::V1beta1::QueryDirectoryContentsRequest.new
            #
            #   # Call the query_directory_contents method.
            #   result = client.query_directory_contents request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Dataform::V1beta1::DirectoryEntry.
            #     p item
            #   end
            #
            def query_directory_contents request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataform::V1beta1::QueryDirectoryContentsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.query_directory_contents.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataform::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.workspace
                header_params["workspace"] = request.workspace
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.query_directory_contents.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.query_directory_contents.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dataform_stub.call_rpc :query_directory_contents, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @dataform_stub, :query_directory_contents, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Finds the contents of a given Workspace directory by filter.
            #
            # @overload search_files(request, options = nil)
            #   Pass arguments to `search_files` via a request object, either of type
            #   {::Google::Cloud::Dataform::V1beta1::SearchFilesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataform::V1beta1::SearchFilesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload search_files(workspace: nil, page_size: nil, page_token: nil, filter: nil)
            #   Pass arguments to `search_files` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param workspace [::String]
            #     Required. The workspace's name.
            #   @param page_size [::Integer]
            #     Optional. Maximum number of search results to return. The server may return
            #     fewer items than requested. If unspecified, the server will pick an
            #     appropriate default.
            #   @param page_token [::String]
            #     Optional. Page token received from a previous `SearchFilesRequest`
            #     call. Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to `SearchFilesRequest`,
            #     with the exception of `page_size`, must match the call that provided the
            #     page token.
            #   @param filter [::String]
            #     Optional. Optional filter for the returned list in filtering format.
            #     Filtering is only currently supported on the `path` field.
            #     See https://google.aip.dev/160 for details.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Dataform::V1beta1::SearchResult>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Dataform::V1beta1::SearchResult>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataform/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataform::V1beta1::Dataform::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataform::V1beta1::SearchFilesRequest.new
            #
            #   # Call the search_files method.
            #   result = client.search_files request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Dataform::V1beta1::SearchResult.
            #     p item
            #   end
            #
            def search_files request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataform::V1beta1::SearchFilesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.search_files.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataform::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.workspace
                header_params["workspace"] = request.workspace
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.search_files.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.search_files.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dataform_stub.call_rpc :search_files, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @dataform_stub, :search_files, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a directory inside a Workspace.
            #
            # @overload make_directory(request, options = nil)
            #   Pass arguments to `make_directory` via a request object, either of type
            #   {::Google::Cloud::Dataform::V1beta1::MakeDirectoryRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataform::V1beta1::MakeDirectoryRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload make_directory(workspace: nil, path: nil)
            #   Pass arguments to `make_directory` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param workspace [::String]
            #     Required. The workspace's name.
            #   @param path [::String]
            #     Required. The directory's full path including directory name, relative to
            #     the workspace root.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Dataform::V1beta1::MakeDirectoryResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Dataform::V1beta1::MakeDirectoryResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataform/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataform::V1beta1::Dataform::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataform::V1beta1::MakeDirectoryRequest.new
            #
            #   # Call the make_directory method.
            #   result = client.make_directory request
            #
            #   # The returned object is of type Google::Cloud::Dataform::V1beta1::MakeDirectoryResponse.
            #   p result
            #
            def make_directory request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataform::V1beta1::MakeDirectoryRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.make_directory.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataform::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.workspace
                header_params["workspace"] = request.workspace
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.make_directory.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.make_directory.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dataform_stub.call_rpc :make_directory, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a directory (inside a Workspace) and all of its contents.
            #
            # @overload remove_directory(request, options = nil)
            #   Pass arguments to `remove_directory` via a request object, either of type
            #   {::Google::Cloud::Dataform::V1beta1::RemoveDirectoryRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataform::V1beta1::RemoveDirectoryRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload remove_directory(workspace: nil, path: nil)
            #   Pass arguments to `remove_directory` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param workspace [::String]
            #     Required. The workspace's name.
            #   @param path [::String]
            #     Required. The directory's full path including directory name, relative to
            #     the workspace root.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Dataform::V1beta1::RemoveDirectoryResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Dataform::V1beta1::RemoveDirectoryResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataform/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataform::V1beta1::Dataform::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataform::V1beta1::RemoveDirectoryRequest.new
            #
            #   # Call the remove_directory method.
            #   result = client.remove_directory request
            #
            #   # The returned object is of type Google::Cloud::Dataform::V1beta1::RemoveDirectoryResponse.
            #   p result
            #
            def remove_directory request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataform::V1beta1::RemoveDirectoryRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.remove_directory.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataform::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.workspace
                header_params["workspace"] = request.workspace
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.remove_directory.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.remove_directory.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dataform_stub.call_rpc :remove_directory, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Moves a directory (inside a Workspace), and all of its contents, to a new
            # location.
            #
            # @overload move_directory(request, options = nil)
            #   Pass arguments to `move_directory` via a request object, either of type
            #   {::Google::Cloud::Dataform::V1beta1::MoveDirectoryRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataform::V1beta1::MoveDirectoryRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload move_directory(workspace: nil, path: nil, new_path: nil)
            #   Pass arguments to `move_directory` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param workspace [::String]
            #     Required. The workspace's name.
            #   @param path [::String]
            #     Required. The directory's full path including directory name, relative to
            #     the workspace root.
            #   @param new_path [::String]
            #     Required. The new path for the directory including directory name, rooted
            #     at workspace root.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Dataform::V1beta1::MoveDirectoryResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Dataform::V1beta1::MoveDirectoryResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataform/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataform::V1beta1::Dataform::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataform::V1beta1::MoveDirectoryRequest.new
            #
            #   # Call the move_directory method.
            #   result = client.move_directory request
            #
            #   # The returned object is of type Google::Cloud::Dataform::V1beta1::MoveDirectoryResponse.
            #   p result
            #
            def move_directory request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataform::V1beta1::MoveDirectoryRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.move_directory.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataform::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.workspace
                header_params["workspace"] = request.workspace
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.move_directory.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.move_directory.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dataform_stub.call_rpc :move_directory, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns the contents of a file (inside a Workspace).
            #
            # @overload read_file(request, options = nil)
            #   Pass arguments to `read_file` via a request object, either of type
            #   {::Google::Cloud::Dataform::V1beta1::ReadFileRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataform::V1beta1::ReadFileRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload read_file(workspace: nil, path: nil, revision: nil)
            #   Pass arguments to `read_file` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param workspace [::String]
            #     Required. The workspace's name.
            #   @param path [::String]
            #     Required. The file's full path including filename, relative to the
            #     workspace root.
            #   @param revision [::String]
            #     Optional. The Git revision of the file to return. If left empty, the
            #     current contents of `path` will be returned.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Dataform::V1beta1::ReadFileResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Dataform::V1beta1::ReadFileResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataform/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataform::V1beta1::Dataform::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataform::V1beta1::ReadFileRequest.new
            #
            #   # Call the read_file method.
            #   result = client.read_file request
            #
            #   # The returned object is of type Google::Cloud::Dataform::V1beta1::ReadFileResponse.
            #   p result
            #
            def read_file request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataform::V1beta1::ReadFileRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.read_file.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataform::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.workspace
                header_params["workspace"] = request.workspace
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.read_file.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.read_file.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dataform_stub.call_rpc :read_file, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a file (inside a Workspace).
            #
            # @overload remove_file(request, options = nil)
            #   Pass arguments to `remove_file` via a request object, either of type
            #   {::Google::Cloud::Dataform::V1beta1::RemoveFileRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataform::V1beta1::RemoveFileRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload remove_file(workspace: nil, path: nil)
            #   Pass arguments to `remove_file` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param workspace [::String]
            #     Required. The workspace's name.
            #   @param path [::String]
            #     Required. The file's full path including filename, relative to the
            #     workspace root.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Dataform::V1beta1::RemoveFileResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Dataform::V1beta1::RemoveFileResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataform/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataform::V1beta1::Dataform::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataform::V1beta1::RemoveFileRequest.new
            #
            #   # Call the remove_file method.
            #   result = client.remove_file request
            #
            #   # The returned object is of type Google::Cloud::Dataform::V1beta1::RemoveFileResponse.
            #   p result
            #
            def remove_file request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataform::V1beta1::RemoveFileRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.remove_file.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataform::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.workspace
                header_params["workspace"] = request.workspace
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.remove_file.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.remove_file.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dataform_stub.call_rpc :remove_file, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Moves a file (inside a Workspace) to a new location.
            #
            # @overload move_file(request, options = nil)
            #   Pass arguments to `move_file` via a request object, either of type
            #   {::Google::Cloud::Dataform::V1beta1::MoveFileRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataform::V1beta1::MoveFileRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload move_file(workspace: nil, path: nil, new_path: nil)
            #   Pass arguments to `move_file` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param workspace [::String]
            #     Required. The workspace's name.
            #   @param path [::String]
            #     Required. The file's full path including filename, relative to the
            #     workspace root.
            #   @param new_path [::String]
            #     Required. The file's new path including filename, relative to the workspace
            #     root.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Dataform::V1beta1::MoveFileResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Dataform::V1beta1::MoveFileResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataform/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataform::V1beta1::Dataform::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataform::V1beta1::MoveFileRequest.new
            #
            #   # Call the move_file method.
            #   result = client.move_file request
            #
            #   # The returned object is of type Google::Cloud::Dataform::V1beta1::MoveFileResponse.
            #   p result
            #
            def move_file request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataform::V1beta1::MoveFileRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.move_file.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataform::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.workspace
                header_params["workspace"] = request.workspace
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.move_file.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.move_file.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dataform_stub.call_rpc :move_file, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Writes to a file (inside a Workspace).
            #
            # @overload write_file(request, options = nil)
            #   Pass arguments to `write_file` via a request object, either of type
            #   {::Google::Cloud::Dataform::V1beta1::WriteFileRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataform::V1beta1::WriteFileRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload write_file(workspace: nil, path: nil, contents: nil)
            #   Pass arguments to `write_file` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param workspace [::String]
            #     Required. The workspace's name.
            #   @param path [::String]
            #     Required. The file.
            #   @param contents [::String]
            #     Required. The file's contents.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Dataform::V1beta1::WriteFileResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Dataform::V1beta1::WriteFileResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataform/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataform::V1beta1::Dataform::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataform::V1beta1::WriteFileRequest.new
            #
            #   # Call the write_file method.
            #   result = client.write_file request
            #
            #   # The returned object is of type Google::Cloud::Dataform::V1beta1::WriteFileResponse.
            #   p result
            #
            def write_file request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataform::V1beta1::WriteFileRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.write_file.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataform::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.workspace
                header_params["workspace"] = request.workspace
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.write_file.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.write_file.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dataform_stub.call_rpc :write_file, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists ReleaseConfigs in a given Repository.
            #
            # @overload list_release_configs(request, options = nil)
            #   Pass arguments to `list_release_configs` via a request object, either of type
            #   {::Google::Cloud::Dataform::V1beta1::ListReleaseConfigsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataform::V1beta1::ListReleaseConfigsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_release_configs(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_release_configs` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The repository in which to list release configs. Must be in the
            #     format `projects/*/locations/*/repositories/*`.
            #   @param page_size [::Integer]
            #     Optional. Maximum number of release configs to return. The server may
            #     return fewer items than requested. If unspecified, the server will pick an
            #     appropriate default.
            #   @param page_token [::String]
            #     Optional. Page token received from a previous `ListReleaseConfigs` call.
            #     Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to `ListReleaseConfigs`,
            #     with the exception of `page_size`, must match the call that provided the
            #     page token.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Dataform::V1beta1::ReleaseConfig>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Dataform::V1beta1::ReleaseConfig>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataform/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataform::V1beta1::Dataform::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataform::V1beta1::ListReleaseConfigsRequest.new
            #
            #   # Call the list_release_configs method.
            #   result = client.list_release_configs request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Dataform::V1beta1::ReleaseConfig.
            #     p item
            #   end
            #
            def list_release_configs request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataform::V1beta1::ListReleaseConfigsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_release_configs.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataform::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_release_configs.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_release_configs.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dataform_stub.call_rpc :list_release_configs, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @dataform_stub, :list_release_configs, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Fetches a single ReleaseConfig.
            #
            # @overload get_release_config(request, options = nil)
            #   Pass arguments to `get_release_config` via a request object, either of type
            #   {::Google::Cloud::Dataform::V1beta1::GetReleaseConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataform::V1beta1::GetReleaseConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_release_config(name: nil)
            #   Pass arguments to `get_release_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The release config's name.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Dataform::V1beta1::ReleaseConfig]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Dataform::V1beta1::ReleaseConfig]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataform/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataform::V1beta1::Dataform::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataform::V1beta1::GetReleaseConfigRequest.new
            #
            #   # Call the get_release_config method.
            #   result = client.get_release_config request
            #
            #   # The returned object is of type Google::Cloud::Dataform::V1beta1::ReleaseConfig.
            #   p result
            #
            def get_release_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataform::V1beta1::GetReleaseConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_release_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataform::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_release_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_release_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dataform_stub.call_rpc :get_release_config, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new ReleaseConfig in a given Repository.
            #
            # @overload create_release_config(request, options = nil)
            #   Pass arguments to `create_release_config` via a request object, either of type
            #   {::Google::Cloud::Dataform::V1beta1::CreateReleaseConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataform::V1beta1::CreateReleaseConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_release_config(parent: nil, release_config: nil, release_config_id: nil)
            #   Pass arguments to `create_release_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The repository in which to create the release config. Must be in
            #     the format `projects/*/locations/*/repositories/*`.
            #   @param release_config [::Google::Cloud::Dataform::V1beta1::ReleaseConfig, ::Hash]
            #     Required. The release config to create.
            #   @param release_config_id [::String]
            #     Required. The ID to use for the release config, which will become the final
            #     component of the release config's resource name.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Dataform::V1beta1::ReleaseConfig]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Dataform::V1beta1::ReleaseConfig]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataform/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataform::V1beta1::Dataform::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataform::V1beta1::CreateReleaseConfigRequest.new
            #
            #   # Call the create_release_config method.
            #   result = client.create_release_config request
            #
            #   # The returned object is of type Google::Cloud::Dataform::V1beta1::ReleaseConfig.
            #   p result
            #
            def create_release_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataform::V1beta1::CreateReleaseConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_release_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataform::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_release_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_release_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dataform_stub.call_rpc :create_release_config, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a single ReleaseConfig.
            #
            # **Note:** *This method does not fully implement
            # [AIP/134](https://google.aip.dev/134). The wildcard entry (\*) is treated
            # as a bad request, and when the `field_mask` is omitted, the request is
            # treated as a full update on all modifiable fields.*
            #
            # @overload update_release_config(request, options = nil)
            #   Pass arguments to `update_release_config` via a request object, either of type
            #   {::Google::Cloud::Dataform::V1beta1::UpdateReleaseConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataform::V1beta1::UpdateReleaseConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_release_config(update_mask: nil, release_config: nil)
            #   Pass arguments to `update_release_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Optional. Specifies the fields to be updated in the release config. If left
            #     unset, all fields will be updated.
            #   @param release_config [::Google::Cloud::Dataform::V1beta1::ReleaseConfig, ::Hash]
            #     Required. The release config to update.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Dataform::V1beta1::ReleaseConfig]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Dataform::V1beta1::ReleaseConfig]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataform/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataform::V1beta1::Dataform::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataform::V1beta1::UpdateReleaseConfigRequest.new
            #
            #   # Call the update_release_config method.
            #   result = client.update_release_config request
            #
            #   # The returned object is of type Google::Cloud::Dataform::V1beta1::ReleaseConfig.
            #   p result
            #
            def update_release_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataform::V1beta1::UpdateReleaseConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_release_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataform::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.release_config&.name
                header_params["release_config.name"] = request.release_config.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_release_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_release_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dataform_stub.call_rpc :update_release_config, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single ReleaseConfig.
            #
            # @overload delete_release_config(request, options = nil)
            #   Pass arguments to `delete_release_config` via a request object, either of type
            #   {::Google::Cloud::Dataform::V1beta1::DeleteReleaseConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataform::V1beta1::DeleteReleaseConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_release_config(name: nil)
            #   Pass arguments to `delete_release_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The release config's name.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataform/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataform::V1beta1::Dataform::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataform::V1beta1::DeleteReleaseConfigRequest.new
            #
            #   # Call the delete_release_config method.
            #   result = client.delete_release_config request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_release_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataform::V1beta1::DeleteReleaseConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_release_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataform::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_release_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_release_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dataform_stub.call_rpc :delete_release_config, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists CompilationResults in a given Repository.
            #
            # @overload list_compilation_results(request, options = nil)
            #   Pass arguments to `list_compilation_results` via a request object, either of type
            #   {::Google::Cloud::Dataform::V1beta1::ListCompilationResultsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataform::V1beta1::ListCompilationResultsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_compilation_results(parent: nil, page_size: nil, page_token: nil, order_by: nil, filter: nil)
            #   Pass arguments to `list_compilation_results` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The repository in which to list compilation results. Must be in
            #     the format `projects/*/locations/*/repositories/*`.
            #   @param page_size [::Integer]
            #     Optional. Maximum number of compilation results to return. The server may
            #     return fewer items than requested. If unspecified, the server will pick an
            #     appropriate default.
            #   @param page_token [::String]
            #     Optional. Page token received from a previous `ListCompilationResults`
            #     call. Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to `ListCompilationResults`,
            #     with the exception of `page_size`, must match the call that provided the
            #     page token.
            #   @param order_by [::String]
            #     Optional. This field only supports ordering by `name` and `create_time`.
            #     If unspecified, the server will choose the ordering.
            #     If specified, the default order is ascending for the `name` field.
            #   @param filter [::String]
            #     Optional. Filter for the returned list.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Dataform::V1beta1::CompilationResult>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Dataform::V1beta1::CompilationResult>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataform/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataform::V1beta1::Dataform::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataform::V1beta1::ListCompilationResultsRequest.new
            #
            #   # Call the list_compilation_results method.
            #   result = client.list_compilation_results request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Dataform::V1beta1::CompilationResult.
            #     p item
            #   end
            #
            def list_compilation_results request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataform::V1beta1::ListCompilationResultsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_compilation_results.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataform::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_compilation_results.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_compilation_results.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dataform_stub.call_rpc :list_compilation_results, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @dataform_stub, :list_compilation_results, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Fetches a single CompilationResult.
            #
            # @overload get_compilation_result(request, options = nil)
            #   Pass arguments to `get_compilation_result` via a request object, either of type
            #   {::Google::Cloud::Dataform::V1beta1::GetCompilationResultRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataform::V1beta1::GetCompilationResultRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_compilation_result(name: nil)
            #   Pass arguments to `get_compilation_result` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The compilation result's name.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Dataform::V1beta1::CompilationResult]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Dataform::V1beta1::CompilationResult]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataform/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataform::V1beta1::Dataform::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataform::V1beta1::GetCompilationResultRequest.new
            #
            #   # Call the get_compilation_result method.
            #   result = client.get_compilation_result request
            #
            #   # The returned object is of type Google::Cloud::Dataform::V1beta1::CompilationResult.
            #   p result
            #
            def get_compilation_result request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataform::V1beta1::GetCompilationResultRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_compilation_result.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataform::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_compilation_result.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_compilation_result.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dataform_stub.call_rpc :get_compilation_result, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new CompilationResult in a given project and location.
            #
            # @overload create_compilation_result(request, options = nil)
            #   Pass arguments to `create_compilation_result` via a request object, either of type
            #   {::Google::Cloud::Dataform::V1beta1::CreateCompilationResultRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataform::V1beta1::CreateCompilationResultRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_compilation_result(parent: nil, compilation_result: nil)
            #   Pass arguments to `create_compilation_result` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The repository in which to create the compilation result. Must be
            #     in the format `projects/*/locations/*/repositories/*`.
            #   @param compilation_result [::Google::Cloud::Dataform::V1beta1::CompilationResult, ::Hash]
            #     Required. The compilation result to create.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Dataform::V1beta1::CompilationResult]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Dataform::V1beta1::CompilationResult]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataform/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataform::V1beta1::Dataform::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataform::V1beta1::CreateCompilationResultRequest.new
            #
            #   # Call the create_compilation_result method.
            #   result = client.create_compilation_result request
            #
            #   # The returned object is of type Google::Cloud::Dataform::V1beta1::CompilationResult.
            #   p result
            #
            def create_compilation_result request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataform::V1beta1::CreateCompilationResultRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_compilation_result.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataform::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_compilation_result.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_compilation_result.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dataform_stub.call_rpc :create_compilation_result, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns CompilationResultActions in a given CompilationResult.
            #
            # @overload query_compilation_result_actions(request, options = nil)
            #   Pass arguments to `query_compilation_result_actions` via a request object, either of type
            #   {::Google::Cloud::Dataform::V1beta1::QueryCompilationResultActionsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataform::V1beta1::QueryCompilationResultActionsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload query_compilation_result_actions(name: nil, page_size: nil, page_token: nil, filter: nil)
            #   Pass arguments to `query_compilation_result_actions` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The compilation result's name.
            #   @param page_size [::Integer]
            #     Optional. Maximum number of compilation results to return. The server may
            #     return fewer items than requested. If unspecified, the server will pick an
            #     appropriate default.
            #   @param page_token [::String]
            #     Optional. Page token received from a previous
            #     `QueryCompilationResultActions` call. Provide this to retrieve the
            #     subsequent page.
            #
            #     When paginating, all other parameters provided to
            #     `QueryCompilationResultActions`, with the exception of `page_size`, must
            #     match the call that provided the page token.
            #   @param filter [::String]
            #     Optional. Optional filter for the returned list. Filtering is only
            #     currently supported on the `file_path` field.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Dataform::V1beta1::CompilationResultAction>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Dataform::V1beta1::CompilationResultAction>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataform/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataform::V1beta1::Dataform::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataform::V1beta1::QueryCompilationResultActionsRequest.new
            #
            #   # Call the query_compilation_result_actions method.
            #   result = client.query_compilation_result_actions request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Dataform::V1beta1::CompilationResultAction.
            #     p item
            #   end
            #
            def query_compilation_result_actions request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataform::V1beta1::QueryCompilationResultActionsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.query_compilation_result_actions.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataform::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.query_compilation_result_actions.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.query_compilation_result_actions.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dataform_stub.call_rpc :query_compilation_result_actions, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @dataform_stub, :query_compilation_result_actions, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists WorkflowConfigs in a given Repository.
            #
            # @overload list_workflow_configs(request, options = nil)
            #   Pass arguments to `list_workflow_configs` via a request object, either of type
            #   {::Google::Cloud::Dataform::V1beta1::ListWorkflowConfigsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataform::V1beta1::ListWorkflowConfigsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_workflow_configs(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_workflow_configs` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The repository in which to list workflow configs. Must be in the
            #     format `projects/*/locations/*/repositories/*`.
            #   @param page_size [::Integer]
            #     Optional. Maximum number of workflow configs to return. The server may
            #     return fewer items than requested. If unspecified, the server will pick an
            #     appropriate default.
            #   @param page_token [::String]
            #     Optional. Page token received from a previous `ListWorkflowConfigs` call.
            #     Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to `ListWorkflowConfigs`,
            #     with the exception of `page_size`, must match the call that provided the
            #     page token.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Dataform::V1beta1::WorkflowConfig>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Dataform::V1beta1::WorkflowConfig>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataform/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataform::V1beta1::Dataform::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataform::V1beta1::ListWorkflowConfigsRequest.new
            #
            #   # Call the list_workflow_configs method.
            #   result = client.list_workflow_configs request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Dataform::V1beta1::WorkflowConfig.
            #     p item
            #   end
            #
            def list_workflow_configs request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataform::V1beta1::ListWorkflowConfigsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_workflow_configs.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataform::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_workflow_configs.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_workflow_configs.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dataform_stub.call_rpc :list_workflow_configs, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @dataform_stub, :list_workflow_configs, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Fetches a single WorkflowConfig.
            #
            # @overload get_workflow_config(request, options = nil)
            #   Pass arguments to `get_workflow_config` via a request object, either of type
            #   {::Google::Cloud::Dataform::V1beta1::GetWorkflowConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataform::V1beta1::GetWorkflowConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_workflow_config(name: nil)
            #   Pass arguments to `get_workflow_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The workflow config's name.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Dataform::V1beta1::WorkflowConfig]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Dataform::V1beta1::WorkflowConfig]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataform/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataform::V1beta1::Dataform::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataform::V1beta1::GetWorkflowConfigRequest.new
            #
            #   # Call the get_workflow_config method.
            #   result = client.get_workflow_config request
            #
            #   # The returned object is of type Google::Cloud::Dataform::V1beta1::WorkflowConfig.
            #   p result
            #
            def get_workflow_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataform::V1beta1::GetWorkflowConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_workflow_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataform::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_workflow_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_workflow_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dataform_stub.call_rpc :get_workflow_config, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new WorkflowConfig in a given Repository.
            #
            # @overload create_workflow_config(request, options = nil)
            #   Pass arguments to `create_workflow_config` via a request object, either of type
            #   {::Google::Cloud::Dataform::V1beta1::CreateWorkflowConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataform::V1beta1::CreateWorkflowConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_workflow_config(parent: nil, workflow_config: nil, workflow_config_id: nil)
            #   Pass arguments to `create_workflow_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The repository in which to create the workflow config. Must be in
            #     the format `projects/*/locations/*/repositories/*`.
            #   @param workflow_config [::Google::Cloud::Dataform::V1beta1::WorkflowConfig, ::Hash]
            #     Required. The workflow config to create.
            #   @param workflow_config_id [::String]
            #     Required. The ID to use for the workflow config, which will become the
            #     final component of the workflow config's resource name.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Dataform::V1beta1::WorkflowConfig]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Dataform::V1beta1::WorkflowConfig]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataform/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataform::V1beta1::Dataform::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataform::V1beta1::CreateWorkflowConfigRequest.new
            #
            #   # Call the create_workflow_config method.
            #   result = client.create_workflow_config request
            #
            #   # The returned object is of type Google::Cloud::Dataform::V1beta1::WorkflowConfig.
            #   p result
            #
            def create_workflow_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataform::V1beta1::CreateWorkflowConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_workflow_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataform::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_workflow_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_workflow_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dataform_stub.call_rpc :create_workflow_config, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a single WorkflowConfig.
            #
            # **Note:** *This method does not fully implement
            # [AIP/134](https://google.aip.dev/134). The wildcard entry (\*) is treated
            # as a bad request, and when the `field_mask` is omitted, the request is
            # treated as a full update on all modifiable fields.*
            #
            # @overload update_workflow_config(request, options = nil)
            #   Pass arguments to `update_workflow_config` via a request object, either of type
            #   {::Google::Cloud::Dataform::V1beta1::UpdateWorkflowConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataform::V1beta1::UpdateWorkflowConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_workflow_config(update_mask: nil, workflow_config: nil)
            #   Pass arguments to `update_workflow_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Optional. Specifies the fields to be updated in the workflow config. If
            #     left unset, all fields will be updated.
            #   @param workflow_config [::Google::Cloud::Dataform::V1beta1::WorkflowConfig, ::Hash]
            #     Required. The workflow config to update.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Dataform::V1beta1::WorkflowConfig]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Dataform::V1beta1::WorkflowConfig]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataform/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataform::V1beta1::Dataform::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataform::V1beta1::UpdateWorkflowConfigRequest.new
            #
            #   # Call the update_workflow_config method.
            #   result = client.update_workflow_config request
            #
            #   # The returned object is of type Google::Cloud::Dataform::V1beta1::WorkflowConfig.
            #   p result
            #
            def update_workflow_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataform::V1beta1::UpdateWorkflowConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_workflow_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataform::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.workflow_config&.name
                header_params["workflow_config.name"] = request.workflow_config.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_workflow_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_workflow_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dataform_stub.call_rpc :update_workflow_config, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single WorkflowConfig.
            #
            # @overload delete_workflow_config(request, options = nil)
            #   Pass arguments to `delete_workflow_config` via a request object, either of type
            #   {::Google::Cloud::Dataform::V1beta1::DeleteWorkflowConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataform::V1beta1::DeleteWorkflowConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_workflow_config(name: nil)
            #   Pass arguments to `delete_workflow_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The workflow config's name.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataform/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataform::V1beta1::Dataform::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataform::V1beta1::DeleteWorkflowConfigRequest.new
            #
            #   # Call the delete_workflow_config method.
            #   result = client.delete_workflow_config request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_workflow_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataform::V1beta1::DeleteWorkflowConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_workflow_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataform::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_workflow_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_workflow_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dataform_stub.call_rpc :delete_workflow_config, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists WorkflowInvocations in a given Repository.
            #
            # @overload list_workflow_invocations(request, options = nil)
            #   Pass arguments to `list_workflow_invocations` via a request object, either of type
            #   {::Google::Cloud::Dataform::V1beta1::ListWorkflowInvocationsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataform::V1beta1::ListWorkflowInvocationsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_workflow_invocations(parent: nil, page_size: nil, page_token: nil, order_by: nil, filter: nil)
            #   Pass arguments to `list_workflow_invocations` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource of the WorkflowInvocation type. Must be in
            #     the format `projects/*/locations/*/repositories/*`.
            #   @param page_size [::Integer]
            #     Optional. Maximum number of workflow invocations to return. The server may
            #     return fewer items than requested. If unspecified, the server will pick an
            #     appropriate default.
            #   @param page_token [::String]
            #     Optional. Page token received from a previous `ListWorkflowInvocations`
            #     call. Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to
            #     `ListWorkflowInvocations`, with the exception of `page_size`, must match
            #     the call that provided the page token.
            #   @param order_by [::String]
            #     Optional. This field only supports ordering by `name`. If unspecified, the
            #     server will choose the ordering. If specified, the default order is
            #     ascending for the `name` field.
            #   @param filter [::String]
            #     Optional. Filter for the returned list.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Dataform::V1beta1::WorkflowInvocation>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Dataform::V1beta1::WorkflowInvocation>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataform/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataform::V1beta1::Dataform::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataform::V1beta1::ListWorkflowInvocationsRequest.new
            #
            #   # Call the list_workflow_invocations method.
            #   result = client.list_workflow_invocations request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Dataform::V1beta1::WorkflowInvocation.
            #     p item
            #   end
            #
            def list_workflow_invocations request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataform::V1beta1::ListWorkflowInvocationsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_workflow_invocations.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataform::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_workflow_invocations.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_workflow_invocations.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dataform_stub.call_rpc :list_workflow_invocations, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @dataform_stub, :list_workflow_invocations, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Fetches a single WorkflowInvocation.
            #
            # @overload get_workflow_invocation(request, options = nil)
            #   Pass arguments to `get_workflow_invocation` via a request object, either of type
            #   {::Google::Cloud::Dataform::V1beta1::GetWorkflowInvocationRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataform::V1beta1::GetWorkflowInvocationRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_workflow_invocation(name: nil)
            #   Pass arguments to `get_workflow_invocation` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The workflow invocation resource's name.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Dataform::V1beta1::WorkflowInvocation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Dataform::V1beta1::WorkflowInvocation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataform/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataform::V1beta1::Dataform::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataform::V1beta1::GetWorkflowInvocationRequest.new
            #
            #   # Call the get_workflow_invocation method.
            #   result = client.get_workflow_invocation request
            #
            #   # The returned object is of type Google::Cloud::Dataform::V1beta1::WorkflowInvocation.
            #   p result
            #
            def get_workflow_invocation request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataform::V1beta1::GetWorkflowInvocationRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_workflow_invocation.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataform::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_workflow_invocation.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_workflow_invocation.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dataform_stub.call_rpc :get_workflow_invocation, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new WorkflowInvocation in a given Repository.
            #
            # @overload create_workflow_invocation(request, options = nil)
            #   Pass arguments to `create_workflow_invocation` via a request object, either of type
            #   {::Google::Cloud::Dataform::V1beta1::CreateWorkflowInvocationRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataform::V1beta1::CreateWorkflowInvocationRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_workflow_invocation(parent: nil, workflow_invocation: nil)
            #   Pass arguments to `create_workflow_invocation` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The repository in which to create the workflow invocation. Must
            #     be in the format `projects/*/locations/*/repositories/*`.
            #   @param workflow_invocation [::Google::Cloud::Dataform::V1beta1::WorkflowInvocation, ::Hash]
            #     Required. The workflow invocation resource to create.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Dataform::V1beta1::WorkflowInvocation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Dataform::V1beta1::WorkflowInvocation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataform/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataform::V1beta1::Dataform::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataform::V1beta1::CreateWorkflowInvocationRequest.new
            #
            #   # Call the create_workflow_invocation method.
            #   result = client.create_workflow_invocation request
            #
            #   # The returned object is of type Google::Cloud::Dataform::V1beta1::WorkflowInvocation.
            #   p result
            #
            def create_workflow_invocation request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataform::V1beta1::CreateWorkflowInvocationRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_workflow_invocation.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataform::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_workflow_invocation.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_workflow_invocation.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dataform_stub.call_rpc :create_workflow_invocation, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single WorkflowInvocation.
            #
            # @overload delete_workflow_invocation(request, options = nil)
            #   Pass arguments to `delete_workflow_invocation` via a request object, either of type
            #   {::Google::Cloud::Dataform::V1beta1::DeleteWorkflowInvocationRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataform::V1beta1::DeleteWorkflowInvocationRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_workflow_invocation(name: nil)
            #   Pass arguments to `delete_workflow_invocation` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The workflow invocation resource's name.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataform/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataform::V1beta1::Dataform::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataform::V1beta1::DeleteWorkflowInvocationRequest.new
            #
            #   # Call the delete_workflow_invocation method.
            #   result = client.delete_workflow_invocation request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_workflow_invocation request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataform::V1beta1::DeleteWorkflowInvocationRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_workflow_invocation.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataform::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_workflow_invocation.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_workflow_invocation.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dataform_stub.call_rpc :delete_workflow_invocation, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Requests cancellation of a running WorkflowInvocation.
            #
            # @overload cancel_workflow_invocation(request, options = nil)
            #   Pass arguments to `cancel_workflow_invocation` via a request object, either of type
            #   {::Google::Cloud::Dataform::V1beta1::CancelWorkflowInvocationRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataform::V1beta1::CancelWorkflowInvocationRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload cancel_workflow_invocation(name: nil)
            #   Pass arguments to `cancel_workflow_invocation` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The workflow invocation resource's name.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Dataform::V1beta1::CancelWorkflowInvocationResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Dataform::V1beta1::CancelWorkflowInvocationResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataform/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataform::V1beta1::Dataform::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataform::V1beta1::CancelWorkflowInvocationRequest.new
            #
            #   # Call the cancel_workflow_invocation method.
            #   result = client.cancel_workflow_invocation request
            #
            #   # The returned object is of type Google::Cloud::Dataform::V1beta1::CancelWorkflowInvocationResponse.
            #   p result
            #
            def cancel_workflow_invocation request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataform::V1beta1::CancelWorkflowInvocationRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.cancel_workflow_invocation.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataform::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.cancel_workflow_invocation.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.cancel_workflow_invocation.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dataform_stub.call_rpc :cancel_workflow_invocation, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns WorkflowInvocationActions in a given WorkflowInvocation.
            #
            # @overload query_workflow_invocation_actions(request, options = nil)
            #   Pass arguments to `query_workflow_invocation_actions` via a request object, either of type
            #   {::Google::Cloud::Dataform::V1beta1::QueryWorkflowInvocationActionsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataform::V1beta1::QueryWorkflowInvocationActionsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload query_workflow_invocation_actions(name: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `query_workflow_invocation_actions` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The workflow invocation's name.
            #   @param page_size [::Integer]
            #     Optional. Maximum number of workflow invocations to return. The server may
            #     return fewer items than requested. If unspecified, the server will pick an
            #     appropriate default.
            #   @param page_token [::String]
            #     Optional. Page token received from a previous
            #     `QueryWorkflowInvocationActions` call. Provide this to retrieve the
            #     subsequent page.
            #
            #     When paginating, all other parameters provided to
            #     `QueryWorkflowInvocationActions`, with the exception of `page_size`, must
            #     match the call that provided the page token.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Dataform::V1beta1::WorkflowInvocationAction>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Dataform::V1beta1::WorkflowInvocationAction>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataform/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataform::V1beta1::Dataform::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataform::V1beta1::QueryWorkflowInvocationActionsRequest.new
            #
            #   # Call the query_workflow_invocation_actions method.
            #   result = client.query_workflow_invocation_actions request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Dataform::V1beta1::WorkflowInvocationAction.
            #     p item
            #   end
            #
            def query_workflow_invocation_actions request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataform::V1beta1::QueryWorkflowInvocationActionsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.query_workflow_invocation_actions.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataform::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.query_workflow_invocation_actions.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.query_workflow_invocation_actions.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dataform_stub.call_rpc :query_workflow_invocation_actions, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @dataform_stub, :query_workflow_invocation_actions, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Get default config for a given project and location.
            #
            # @overload get_config(request, options = nil)
            #   Pass arguments to `get_config` via a request object, either of type
            #   {::Google::Cloud::Dataform::V1beta1::GetConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataform::V1beta1::GetConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_config(name: nil)
            #   Pass arguments to `get_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The config name.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Dataform::V1beta1::Config]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Dataform::V1beta1::Config]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataform/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataform::V1beta1::Dataform::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataform::V1beta1::GetConfigRequest.new
            #
            #   # Call the get_config method.
            #   result = client.get_config request
            #
            #   # The returned object is of type Google::Cloud::Dataform::V1beta1::Config.
            #   p result
            #
            def get_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataform::V1beta1::GetConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataform::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dataform_stub.call_rpc :get_config, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Update default config for a given project and location.
            #
            # **Note:** *This method does not fully implement
            # [AIP/134](https://google.aip.dev/134). The wildcard entry (\*) is treated
            # as a bad request, and when the `field_mask` is omitted, the request is
            # treated as a full update on all modifiable fields.*
            #
            # @overload update_config(request, options = nil)
            #   Pass arguments to `update_config` via a request object, either of type
            #   {::Google::Cloud::Dataform::V1beta1::UpdateConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataform::V1beta1::UpdateConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_config(config: nil, update_mask: nil)
            #   Pass arguments to `update_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param config [::Google::Cloud::Dataform::V1beta1::Config, ::Hash]
            #     Required. The config to update.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Optional. Specifies the fields to be updated in the config.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Dataform::V1beta1::Config]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Dataform::V1beta1::Config]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataform/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataform::V1beta1::Dataform::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataform::V1beta1::UpdateConfigRequest.new
            #
            #   # Call the update_config method.
            #   result = client.update_config request
            #
            #   # The returned object is of type Google::Cloud::Dataform::V1beta1::Config.
            #   p result
            #
            def update_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataform::V1beta1::UpdateConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataform::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.config&.name
                header_params["config.name"] = request.config.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dataform_stub.call_rpc :update_config, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the Dataform API.
            #
            # This class represents the configuration for Dataform,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::Dataform::V1beta1::Dataform::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # list_repositories to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::Dataform::V1beta1::Dataform::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_repositories.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::Dataform::V1beta1::Dataform::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_repositories.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::Dataform::V1beta1::Dataform::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "dataform.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the Dataform API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `list_repositories`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_repositories
                ##
                # RPC-specific configuration for `get_repository`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_repository
                ##
                # RPC-specific configuration for `create_repository`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_repository
                ##
                # RPC-specific configuration for `update_repository`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_repository
                ##
                # RPC-specific configuration for `delete_repository`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_repository
                ##
                # RPC-specific configuration for `commit_repository_changes`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :commit_repository_changes
                ##
                # RPC-specific configuration for `read_repository_file`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :read_repository_file
                ##
                # RPC-specific configuration for `query_repository_directory_contents`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :query_repository_directory_contents
                ##
                # RPC-specific configuration for `fetch_repository_history`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :fetch_repository_history
                ##
                # RPC-specific configuration for `compute_repository_access_token_status`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :compute_repository_access_token_status
                ##
                # RPC-specific configuration for `fetch_remote_branches`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :fetch_remote_branches
                ##
                # RPC-specific configuration for `list_workspaces`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_workspaces
                ##
                # RPC-specific configuration for `get_workspace`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_workspace
                ##
                # RPC-specific configuration for `create_workspace`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_workspace
                ##
                # RPC-specific configuration for `delete_workspace`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_workspace
                ##
                # RPC-specific configuration for `install_npm_packages`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :install_npm_packages
                ##
                # RPC-specific configuration for `pull_git_commits`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :pull_git_commits
                ##
                # RPC-specific configuration for `push_git_commits`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :push_git_commits
                ##
                # RPC-specific configuration for `fetch_file_git_statuses`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :fetch_file_git_statuses
                ##
                # RPC-specific configuration for `fetch_git_ahead_behind`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :fetch_git_ahead_behind
                ##
                # RPC-specific configuration for `commit_workspace_changes`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :commit_workspace_changes
                ##
                # RPC-specific configuration for `reset_workspace_changes`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :reset_workspace_changes
                ##
                # RPC-specific configuration for `fetch_file_diff`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :fetch_file_diff
                ##
                # RPC-specific configuration for `query_directory_contents`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :query_directory_contents
                ##
                # RPC-specific configuration for `search_files`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :search_files
                ##
                # RPC-specific configuration for `make_directory`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :make_directory
                ##
                # RPC-specific configuration for `remove_directory`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :remove_directory
                ##
                # RPC-specific configuration for `move_directory`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :move_directory
                ##
                # RPC-specific configuration for `read_file`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :read_file
                ##
                # RPC-specific configuration for `remove_file`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :remove_file
                ##
                # RPC-specific configuration for `move_file`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :move_file
                ##
                # RPC-specific configuration for `write_file`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :write_file
                ##
                # RPC-specific configuration for `list_release_configs`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_release_configs
                ##
                # RPC-specific configuration for `get_release_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_release_config
                ##
                # RPC-specific configuration for `create_release_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_release_config
                ##
                # RPC-specific configuration for `update_release_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_release_config
                ##
                # RPC-specific configuration for `delete_release_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_release_config
                ##
                # RPC-specific configuration for `list_compilation_results`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_compilation_results
                ##
                # RPC-specific configuration for `get_compilation_result`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_compilation_result
                ##
                # RPC-specific configuration for `create_compilation_result`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_compilation_result
                ##
                # RPC-specific configuration for `query_compilation_result_actions`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :query_compilation_result_actions
                ##
                # RPC-specific configuration for `list_workflow_configs`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_workflow_configs
                ##
                # RPC-specific configuration for `get_workflow_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_workflow_config
                ##
                # RPC-specific configuration for `create_workflow_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_workflow_config
                ##
                # RPC-specific configuration for `update_workflow_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_workflow_config
                ##
                # RPC-specific configuration for `delete_workflow_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_workflow_config
                ##
                # RPC-specific configuration for `list_workflow_invocations`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_workflow_invocations
                ##
                # RPC-specific configuration for `get_workflow_invocation`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_workflow_invocation
                ##
                # RPC-specific configuration for `create_workflow_invocation`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_workflow_invocation
                ##
                # RPC-specific configuration for `delete_workflow_invocation`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_workflow_invocation
                ##
                # RPC-specific configuration for `cancel_workflow_invocation`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :cancel_workflow_invocation
                ##
                # RPC-specific configuration for `query_workflow_invocation_actions`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :query_workflow_invocation_actions
                ##
                # RPC-specific configuration for `get_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_config
                ##
                # RPC-specific configuration for `update_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_config

                # @private
                def initialize parent_rpcs = nil
                  list_repositories_config = parent_rpcs.list_repositories if parent_rpcs.respond_to? :list_repositories
                  @list_repositories = ::Gapic::Config::Method.new list_repositories_config
                  get_repository_config = parent_rpcs.get_repository if parent_rpcs.respond_to? :get_repository
                  @get_repository = ::Gapic::Config::Method.new get_repository_config
                  create_repository_config = parent_rpcs.create_repository if parent_rpcs.respond_to? :create_repository
                  @create_repository = ::Gapic::Config::Method.new create_repository_config
                  update_repository_config = parent_rpcs.update_repository if parent_rpcs.respond_to? :update_repository
                  @update_repository = ::Gapic::Config::Method.new update_repository_config
                  delete_repository_config = parent_rpcs.delete_repository if parent_rpcs.respond_to? :delete_repository
                  @delete_repository = ::Gapic::Config::Method.new delete_repository_config
                  commit_repository_changes_config = parent_rpcs.commit_repository_changes if parent_rpcs.respond_to? :commit_repository_changes
                  @commit_repository_changes = ::Gapic::Config::Method.new commit_repository_changes_config
                  read_repository_file_config = parent_rpcs.read_repository_file if parent_rpcs.respond_to? :read_repository_file
                  @read_repository_file = ::Gapic::Config::Method.new read_repository_file_config
                  query_repository_directory_contents_config = parent_rpcs.query_repository_directory_contents if parent_rpcs.respond_to? :query_repository_directory_contents
                  @query_repository_directory_contents = ::Gapic::Config::Method.new query_repository_directory_contents_config
                  fetch_repository_history_config = parent_rpcs.fetch_repository_history if parent_rpcs.respond_to? :fetch_repository_history
                  @fetch_repository_history = ::Gapic::Config::Method.new fetch_repository_history_config
                  compute_repository_access_token_status_config = parent_rpcs.compute_repository_access_token_status if parent_rpcs.respond_to? :compute_repository_access_token_status
                  @compute_repository_access_token_status = ::Gapic::Config::Method.new compute_repository_access_token_status_config
                  fetch_remote_branches_config = parent_rpcs.fetch_remote_branches if parent_rpcs.respond_to? :fetch_remote_branches
                  @fetch_remote_branches = ::Gapic::Config::Method.new fetch_remote_branches_config
                  list_workspaces_config = parent_rpcs.list_workspaces if parent_rpcs.respond_to? :list_workspaces
                  @list_workspaces = ::Gapic::Config::Method.new list_workspaces_config
                  get_workspace_config = parent_rpcs.get_workspace if parent_rpcs.respond_to? :get_workspace
                  @get_workspace = ::Gapic::Config::Method.new get_workspace_config
                  create_workspace_config = parent_rpcs.create_workspace if parent_rpcs.respond_to? :create_workspace
                  @create_workspace = ::Gapic::Config::Method.new create_workspace_config
                  delete_workspace_config = parent_rpcs.delete_workspace if parent_rpcs.respond_to? :delete_workspace
                  @delete_workspace = ::Gapic::Config::Method.new delete_workspace_config
                  install_npm_packages_config = parent_rpcs.install_npm_packages if parent_rpcs.respond_to? :install_npm_packages
                  @install_npm_packages = ::Gapic::Config::Method.new install_npm_packages_config
                  pull_git_commits_config = parent_rpcs.pull_git_commits if parent_rpcs.respond_to? :pull_git_commits
                  @pull_git_commits = ::Gapic::Config::Method.new pull_git_commits_config
                  push_git_commits_config = parent_rpcs.push_git_commits if parent_rpcs.respond_to? :push_git_commits
                  @push_git_commits = ::Gapic::Config::Method.new push_git_commits_config
                  fetch_file_git_statuses_config = parent_rpcs.fetch_file_git_statuses if parent_rpcs.respond_to? :fetch_file_git_statuses
                  @fetch_file_git_statuses = ::Gapic::Config::Method.new fetch_file_git_statuses_config
                  fetch_git_ahead_behind_config = parent_rpcs.fetch_git_ahead_behind if parent_rpcs.respond_to? :fetch_git_ahead_behind
                  @fetch_git_ahead_behind = ::Gapic::Config::Method.new fetch_git_ahead_behind_config
                  commit_workspace_changes_config = parent_rpcs.commit_workspace_changes if parent_rpcs.respond_to? :commit_workspace_changes
                  @commit_workspace_changes = ::Gapic::Config::Method.new commit_workspace_changes_config
                  reset_workspace_changes_config = parent_rpcs.reset_workspace_changes if parent_rpcs.respond_to? :reset_workspace_changes
                  @reset_workspace_changes = ::Gapic::Config::Method.new reset_workspace_changes_config
                  fetch_file_diff_config = parent_rpcs.fetch_file_diff if parent_rpcs.respond_to? :fetch_file_diff
                  @fetch_file_diff = ::Gapic::Config::Method.new fetch_file_diff_config
                  query_directory_contents_config = parent_rpcs.query_directory_contents if parent_rpcs.respond_to? :query_directory_contents
                  @query_directory_contents = ::Gapic::Config::Method.new query_directory_contents_config
                  search_files_config = parent_rpcs.search_files if parent_rpcs.respond_to? :search_files
                  @search_files = ::Gapic::Config::Method.new search_files_config
                  make_directory_config = parent_rpcs.make_directory if parent_rpcs.respond_to? :make_directory
                  @make_directory = ::Gapic::Config::Method.new make_directory_config
                  remove_directory_config = parent_rpcs.remove_directory if parent_rpcs.respond_to? :remove_directory
                  @remove_directory = ::Gapic::Config::Method.new remove_directory_config
                  move_directory_config = parent_rpcs.move_directory if parent_rpcs.respond_to? :move_directory
                  @move_directory = ::Gapic::Config::Method.new move_directory_config
                  read_file_config = parent_rpcs.read_file if parent_rpcs.respond_to? :read_file
                  @read_file = ::Gapic::Config::Method.new read_file_config
                  remove_file_config = parent_rpcs.remove_file if parent_rpcs.respond_to? :remove_file
                  @remove_file = ::Gapic::Config::Method.new remove_file_config
                  move_file_config = parent_rpcs.move_file if parent_rpcs.respond_to? :move_file
                  @move_file = ::Gapic::Config::Method.new move_file_config
                  write_file_config = parent_rpcs.write_file if parent_rpcs.respond_to? :write_file
                  @write_file = ::Gapic::Config::Method.new write_file_config
                  list_release_configs_config = parent_rpcs.list_release_configs if parent_rpcs.respond_to? :list_release_configs
                  @list_release_configs = ::Gapic::Config::Method.new list_release_configs_config
                  get_release_config_config = parent_rpcs.get_release_config if parent_rpcs.respond_to? :get_release_config
                  @get_release_config = ::Gapic::Config::Method.new get_release_config_config
                  create_release_config_config = parent_rpcs.create_release_config if parent_rpcs.respond_to? :create_release_config
                  @create_release_config = ::Gapic::Config::Method.new create_release_config_config
                  update_release_config_config = parent_rpcs.update_release_config if parent_rpcs.respond_to? :update_release_config
                  @update_release_config = ::Gapic::Config::Method.new update_release_config_config
                  delete_release_config_config = parent_rpcs.delete_release_config if parent_rpcs.respond_to? :delete_release_config
                  @delete_release_config = ::Gapic::Config::Method.new delete_release_config_config
                  list_compilation_results_config = parent_rpcs.list_compilation_results if parent_rpcs.respond_to? :list_compilation_results
                  @list_compilation_results = ::Gapic::Config::Method.new list_compilation_results_config
                  get_compilation_result_config = parent_rpcs.get_compilation_result if parent_rpcs.respond_to? :get_compilation_result
                  @get_compilation_result = ::Gapic::Config::Method.new get_compilation_result_config
                  create_compilation_result_config = parent_rpcs.create_compilation_result if parent_rpcs.respond_to? :create_compilation_result
                  @create_compilation_result = ::Gapic::Config::Method.new create_compilation_result_config
                  query_compilation_result_actions_config = parent_rpcs.query_compilation_result_actions if parent_rpcs.respond_to? :query_compilation_result_actions
                  @query_compilation_result_actions = ::Gapic::Config::Method.new query_compilation_result_actions_config
                  list_workflow_configs_config = parent_rpcs.list_workflow_configs if parent_rpcs.respond_to? :list_workflow_configs
                  @list_workflow_configs = ::Gapic::Config::Method.new list_workflow_configs_config
                  get_workflow_config_config = parent_rpcs.get_workflow_config if parent_rpcs.respond_to? :get_workflow_config
                  @get_workflow_config = ::Gapic::Config::Method.new get_workflow_config_config
                  create_workflow_config_config = parent_rpcs.create_workflow_config if parent_rpcs.respond_to? :create_workflow_config
                  @create_workflow_config = ::Gapic::Config::Method.new create_workflow_config_config
                  update_workflow_config_config = parent_rpcs.update_workflow_config if parent_rpcs.respond_to? :update_workflow_config
                  @update_workflow_config = ::Gapic::Config::Method.new update_workflow_config_config
                  delete_workflow_config_config = parent_rpcs.delete_workflow_config if parent_rpcs.respond_to? :delete_workflow_config
                  @delete_workflow_config = ::Gapic::Config::Method.new delete_workflow_config_config
                  list_workflow_invocations_config = parent_rpcs.list_workflow_invocations if parent_rpcs.respond_to? :list_workflow_invocations
                  @list_workflow_invocations = ::Gapic::Config::Method.new list_workflow_invocations_config
                  get_workflow_invocation_config = parent_rpcs.get_workflow_invocation if parent_rpcs.respond_to? :get_workflow_invocation
                  @get_workflow_invocation = ::Gapic::Config::Method.new get_workflow_invocation_config
                  create_workflow_invocation_config = parent_rpcs.create_workflow_invocation if parent_rpcs.respond_to? :create_workflow_invocation
                  @create_workflow_invocation = ::Gapic::Config::Method.new create_workflow_invocation_config
                  delete_workflow_invocation_config = parent_rpcs.delete_workflow_invocation if parent_rpcs.respond_to? :delete_workflow_invocation
                  @delete_workflow_invocation = ::Gapic::Config::Method.new delete_workflow_invocation_config
                  cancel_workflow_invocation_config = parent_rpcs.cancel_workflow_invocation if parent_rpcs.respond_to? :cancel_workflow_invocation
                  @cancel_workflow_invocation = ::Gapic::Config::Method.new cancel_workflow_invocation_config
                  query_workflow_invocation_actions_config = parent_rpcs.query_workflow_invocation_actions if parent_rpcs.respond_to? :query_workflow_invocation_actions
                  @query_workflow_invocation_actions = ::Gapic::Config::Method.new query_workflow_invocation_actions_config
                  get_config_config = parent_rpcs.get_config if parent_rpcs.respond_to? :get_config
                  @get_config = ::Gapic::Config::Method.new get_config_config
                  update_config_config = parent_rpcs.update_config if parent_rpcs.respond_to? :update_config
                  @update_config = ::Gapic::Config::Method.new update_config_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
