# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/dataform/v1/dataform_pb"
require "google/cloud/dataform/v1/dataform"

class ::Google::Cloud::Dataform::V1::Dataform::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_repositories
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataform::V1::ListRepositoriesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"
    filter = "hello world"

    list_repositories_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_repositories, name
      assert_kind_of ::Google::Cloud::Dataform::V1::ListRepositoriesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["order_by"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_repositories_client_stub do
      # Create client
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_repositories({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_repositories parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_repositories ::Google::Cloud::Dataform::V1::ListRepositoriesRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_repositories({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_repositories(::Google::Cloud::Dataform::V1::ListRepositoriesRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_repositories_client_stub.call_rpc_count
    end
  end

  def test_get_repository
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataform::V1::Repository.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_repository_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_repository, name
      assert_kind_of ::Google::Cloud::Dataform::V1::GetRepositoryRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_repository_client_stub do
      # Create client
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_repository({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_repository name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_repository ::Google::Cloud::Dataform::V1::GetRepositoryRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_repository({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_repository(::Google::Cloud::Dataform::V1::GetRepositoryRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_repository_client_stub.call_rpc_count
    end
  end

  def test_create_repository
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataform::V1::Repository.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    repository = {}
    repository_id = "hello world"

    create_repository_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_repository, name
      assert_kind_of ::Google::Cloud::Dataform::V1::CreateRepositoryRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Dataform::V1::Repository), request["repository"]
      assert_equal "hello world", request["repository_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_repository_client_stub do
      # Create client
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_repository({ parent: parent, repository: repository, repository_id: repository_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_repository parent: parent, repository: repository, repository_id: repository_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_repository ::Google::Cloud::Dataform::V1::CreateRepositoryRequest.new(parent: parent, repository: repository, repository_id: repository_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_repository({ parent: parent, repository: repository, repository_id: repository_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_repository(::Google::Cloud::Dataform::V1::CreateRepositoryRequest.new(parent: parent, repository: repository, repository_id: repository_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_repository_client_stub.call_rpc_count
    end
  end

  def test_update_repository
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataform::V1::Repository.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    repository = {}

    update_repository_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_repository, name
      assert_kind_of ::Google::Cloud::Dataform::V1::UpdateRepositoryRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Dataform::V1::Repository), request["repository"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_repository_client_stub do
      # Create client
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_repository({ update_mask: update_mask, repository: repository }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_repository update_mask: update_mask, repository: repository do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_repository ::Google::Cloud::Dataform::V1::UpdateRepositoryRequest.new(update_mask: update_mask, repository: repository) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_repository({ update_mask: update_mask, repository: repository }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_repository(::Google::Cloud::Dataform::V1::UpdateRepositoryRequest.new(update_mask: update_mask, repository: repository), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_repository_client_stub.call_rpc_count
    end
  end

  def test_delete_repository
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    force = true

    delete_repository_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_repository, name
      assert_kind_of ::Google::Cloud::Dataform::V1::DeleteRepositoryRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["force"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_repository_client_stub do
      # Create client
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_repository({ name: name, force: force }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_repository name: name, force: force do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_repository ::Google::Cloud::Dataform::V1::DeleteRepositoryRequest.new(name: name, force: force) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_repository({ name: name, force: force }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_repository(::Google::Cloud::Dataform::V1::DeleteRepositoryRequest.new(name: name, force: force), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_repository_client_stub.call_rpc_count
    end
  end

  def test_commit_repository_changes
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataform::V1::CommitRepositoryChangesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    commit_metadata = {}
    required_head_commit_sha = "hello world"
    file_operations = {}

    commit_repository_changes_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :commit_repository_changes, name
      assert_kind_of ::Google::Cloud::Dataform::V1::CommitRepositoryChangesRequest, request
      assert_equal "hello world", request["name"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Dataform::V1::CommitMetadata), request["commit_metadata"]
      assert_equal "hello world", request["required_head_commit_sha"]
      assert_equal({}, request["file_operations"].to_h)
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, commit_repository_changes_client_stub do
      # Create client
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.commit_repository_changes({ name: name, commit_metadata: commit_metadata, required_head_commit_sha: required_head_commit_sha, file_operations: file_operations }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.commit_repository_changes name: name, commit_metadata: commit_metadata, required_head_commit_sha: required_head_commit_sha, file_operations: file_operations do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.commit_repository_changes ::Google::Cloud::Dataform::V1::CommitRepositoryChangesRequest.new(name: name, commit_metadata: commit_metadata, required_head_commit_sha: required_head_commit_sha, file_operations: file_operations) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.commit_repository_changes({ name: name, commit_metadata: commit_metadata, required_head_commit_sha: required_head_commit_sha, file_operations: file_operations }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.commit_repository_changes(::Google::Cloud::Dataform::V1::CommitRepositoryChangesRequest.new(name: name, commit_metadata: commit_metadata, required_head_commit_sha: required_head_commit_sha, file_operations: file_operations), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, commit_repository_changes_client_stub.call_rpc_count
    end
  end

  def test_read_repository_file
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataform::V1::ReadRepositoryFileResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    commit_sha = "hello world"
    path = "hello world"

    read_repository_file_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :read_repository_file, name
      assert_kind_of ::Google::Cloud::Dataform::V1::ReadRepositoryFileRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["commit_sha"]
      assert_equal "hello world", request["path"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, read_repository_file_client_stub do
      # Create client
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.read_repository_file({ name: name, commit_sha: commit_sha, path: path }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.read_repository_file name: name, commit_sha: commit_sha, path: path do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.read_repository_file ::Google::Cloud::Dataform::V1::ReadRepositoryFileRequest.new(name: name, commit_sha: commit_sha, path: path) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.read_repository_file({ name: name, commit_sha: commit_sha, path: path }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.read_repository_file(::Google::Cloud::Dataform::V1::ReadRepositoryFileRequest.new(name: name, commit_sha: commit_sha, path: path), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, read_repository_file_client_stub.call_rpc_count
    end
  end

  def test_query_repository_directory_contents
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataform::V1::QueryRepositoryDirectoryContentsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    commit_sha = "hello world"
    path = "hello world"
    page_size = 42
    page_token = "hello world"

    query_repository_directory_contents_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :query_repository_directory_contents, name
      assert_kind_of ::Google::Cloud::Dataform::V1::QueryRepositoryDirectoryContentsRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["commit_sha"]
      assert_equal "hello world", request["path"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, query_repository_directory_contents_client_stub do
      # Create client
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.query_repository_directory_contents({ name: name, commit_sha: commit_sha, path: path, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.query_repository_directory_contents name: name, commit_sha: commit_sha, path: path, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.query_repository_directory_contents ::Google::Cloud::Dataform::V1::QueryRepositoryDirectoryContentsRequest.new(name: name, commit_sha: commit_sha, path: path, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.query_repository_directory_contents({ name: name, commit_sha: commit_sha, path: path, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.query_repository_directory_contents(::Google::Cloud::Dataform::V1::QueryRepositoryDirectoryContentsRequest.new(name: name, commit_sha: commit_sha, path: path, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, query_repository_directory_contents_client_stub.call_rpc_count
    end
  end

  def test_fetch_repository_history
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataform::V1::FetchRepositoryHistoryResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    page_size = 42
    page_token = "hello world"

    fetch_repository_history_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :fetch_repository_history, name
      assert_kind_of ::Google::Cloud::Dataform::V1::FetchRepositoryHistoryRequest, request
      assert_equal "hello world", request["name"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, fetch_repository_history_client_stub do
      # Create client
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.fetch_repository_history({ name: name, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.fetch_repository_history name: name, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.fetch_repository_history ::Google::Cloud::Dataform::V1::FetchRepositoryHistoryRequest.new(name: name, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.fetch_repository_history({ name: name, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.fetch_repository_history(::Google::Cloud::Dataform::V1::FetchRepositoryHistoryRequest.new(name: name, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, fetch_repository_history_client_stub.call_rpc_count
    end
  end

  def test_compute_repository_access_token_status
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataform::V1::ComputeRepositoryAccessTokenStatusResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    compute_repository_access_token_status_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :compute_repository_access_token_status, name
      assert_kind_of ::Google::Cloud::Dataform::V1::ComputeRepositoryAccessTokenStatusRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, compute_repository_access_token_status_client_stub do
      # Create client
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.compute_repository_access_token_status({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.compute_repository_access_token_status name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.compute_repository_access_token_status ::Google::Cloud::Dataform::V1::ComputeRepositoryAccessTokenStatusRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.compute_repository_access_token_status({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.compute_repository_access_token_status(::Google::Cloud::Dataform::V1::ComputeRepositoryAccessTokenStatusRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, compute_repository_access_token_status_client_stub.call_rpc_count
    end
  end

  def test_fetch_remote_branches
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataform::V1::FetchRemoteBranchesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    fetch_remote_branches_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :fetch_remote_branches, name
      assert_kind_of ::Google::Cloud::Dataform::V1::FetchRemoteBranchesRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, fetch_remote_branches_client_stub do
      # Create client
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.fetch_remote_branches({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.fetch_remote_branches name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.fetch_remote_branches ::Google::Cloud::Dataform::V1::FetchRemoteBranchesRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.fetch_remote_branches({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.fetch_remote_branches(::Google::Cloud::Dataform::V1::FetchRemoteBranchesRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, fetch_remote_branches_client_stub.call_rpc_count
    end
  end

  def test_list_workspaces
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataform::V1::ListWorkspacesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"
    filter = "hello world"

    list_workspaces_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_workspaces, name
      assert_kind_of ::Google::Cloud::Dataform::V1::ListWorkspacesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["order_by"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_workspaces_client_stub do
      # Create client
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_workspaces({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_workspaces parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_workspaces ::Google::Cloud::Dataform::V1::ListWorkspacesRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_workspaces({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_workspaces(::Google::Cloud::Dataform::V1::ListWorkspacesRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_workspaces_client_stub.call_rpc_count
    end
  end

  def test_get_workspace
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataform::V1::Workspace.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_workspace_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_workspace, name
      assert_kind_of ::Google::Cloud::Dataform::V1::GetWorkspaceRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_workspace_client_stub do
      # Create client
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_workspace({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_workspace name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_workspace ::Google::Cloud::Dataform::V1::GetWorkspaceRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_workspace({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_workspace(::Google::Cloud::Dataform::V1::GetWorkspaceRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_workspace_client_stub.call_rpc_count
    end
  end

  def test_create_workspace
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataform::V1::Workspace.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    workspace = {}
    workspace_id = "hello world"

    create_workspace_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_workspace, name
      assert_kind_of ::Google::Cloud::Dataform::V1::CreateWorkspaceRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Dataform::V1::Workspace), request["workspace"]
      assert_equal "hello world", request["workspace_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_workspace_client_stub do
      # Create client
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_workspace({ parent: parent, workspace: workspace, workspace_id: workspace_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_workspace parent: parent, workspace: workspace, workspace_id: workspace_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_workspace ::Google::Cloud::Dataform::V1::CreateWorkspaceRequest.new(parent: parent, workspace: workspace, workspace_id: workspace_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_workspace({ parent: parent, workspace: workspace, workspace_id: workspace_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_workspace(::Google::Cloud::Dataform::V1::CreateWorkspaceRequest.new(parent: parent, workspace: workspace, workspace_id: workspace_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_workspace_client_stub.call_rpc_count
    end
  end

  def test_delete_workspace
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_workspace_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_workspace, name
      assert_kind_of ::Google::Cloud::Dataform::V1::DeleteWorkspaceRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_workspace_client_stub do
      # Create client
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_workspace({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_workspace name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_workspace ::Google::Cloud::Dataform::V1::DeleteWorkspaceRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_workspace({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_workspace(::Google::Cloud::Dataform::V1::DeleteWorkspaceRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_workspace_client_stub.call_rpc_count
    end
  end

  def test_install_npm_packages
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataform::V1::InstallNpmPackagesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    workspace = "hello world"

    install_npm_packages_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :install_npm_packages, name
      assert_kind_of ::Google::Cloud::Dataform::V1::InstallNpmPackagesRequest, request
      assert_equal "hello world", request["workspace"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, install_npm_packages_client_stub do
      # Create client
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.install_npm_packages({ workspace: workspace }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.install_npm_packages workspace: workspace do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.install_npm_packages ::Google::Cloud::Dataform::V1::InstallNpmPackagesRequest.new(workspace: workspace) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.install_npm_packages({ workspace: workspace }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.install_npm_packages(::Google::Cloud::Dataform::V1::InstallNpmPackagesRequest.new(workspace: workspace), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, install_npm_packages_client_stub.call_rpc_count
    end
  end

  def test_pull_git_commits
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataform::V1::PullGitCommitsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    remote_branch = "hello world"
    author = {}

    pull_git_commits_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :pull_git_commits, name
      assert_kind_of ::Google::Cloud::Dataform::V1::PullGitCommitsRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["remote_branch"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Dataform::V1::CommitAuthor), request["author"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, pull_git_commits_client_stub do
      # Create client
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.pull_git_commits({ name: name, remote_branch: remote_branch, author: author }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.pull_git_commits name: name, remote_branch: remote_branch, author: author do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.pull_git_commits ::Google::Cloud::Dataform::V1::PullGitCommitsRequest.new(name: name, remote_branch: remote_branch, author: author) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.pull_git_commits({ name: name, remote_branch: remote_branch, author: author }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.pull_git_commits(::Google::Cloud::Dataform::V1::PullGitCommitsRequest.new(name: name, remote_branch: remote_branch, author: author), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, pull_git_commits_client_stub.call_rpc_count
    end
  end

  def test_push_git_commits
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataform::V1::PushGitCommitsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    remote_branch = "hello world"

    push_git_commits_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :push_git_commits, name
      assert_kind_of ::Google::Cloud::Dataform::V1::PushGitCommitsRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["remote_branch"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, push_git_commits_client_stub do
      # Create client
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.push_git_commits({ name: name, remote_branch: remote_branch }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.push_git_commits name: name, remote_branch: remote_branch do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.push_git_commits ::Google::Cloud::Dataform::V1::PushGitCommitsRequest.new(name: name, remote_branch: remote_branch) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.push_git_commits({ name: name, remote_branch: remote_branch }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.push_git_commits(::Google::Cloud::Dataform::V1::PushGitCommitsRequest.new(name: name, remote_branch: remote_branch), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, push_git_commits_client_stub.call_rpc_count
    end
  end

  def test_fetch_file_git_statuses
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataform::V1::FetchFileGitStatusesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    fetch_file_git_statuses_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :fetch_file_git_statuses, name
      assert_kind_of ::Google::Cloud::Dataform::V1::FetchFileGitStatusesRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, fetch_file_git_statuses_client_stub do
      # Create client
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.fetch_file_git_statuses({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.fetch_file_git_statuses name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.fetch_file_git_statuses ::Google::Cloud::Dataform::V1::FetchFileGitStatusesRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.fetch_file_git_statuses({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.fetch_file_git_statuses(::Google::Cloud::Dataform::V1::FetchFileGitStatusesRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, fetch_file_git_statuses_client_stub.call_rpc_count
    end
  end

  def test_fetch_git_ahead_behind
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataform::V1::FetchGitAheadBehindResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    remote_branch = "hello world"

    fetch_git_ahead_behind_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :fetch_git_ahead_behind, name
      assert_kind_of ::Google::Cloud::Dataform::V1::FetchGitAheadBehindRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["remote_branch"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, fetch_git_ahead_behind_client_stub do
      # Create client
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.fetch_git_ahead_behind({ name: name, remote_branch: remote_branch }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.fetch_git_ahead_behind name: name, remote_branch: remote_branch do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.fetch_git_ahead_behind ::Google::Cloud::Dataform::V1::FetchGitAheadBehindRequest.new(name: name, remote_branch: remote_branch) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.fetch_git_ahead_behind({ name: name, remote_branch: remote_branch }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.fetch_git_ahead_behind(::Google::Cloud::Dataform::V1::FetchGitAheadBehindRequest.new(name: name, remote_branch: remote_branch), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, fetch_git_ahead_behind_client_stub.call_rpc_count
    end
  end

  def test_commit_workspace_changes
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataform::V1::CommitWorkspaceChangesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    author = {}
    commit_message = "hello world"
    paths = ["hello world"]

    commit_workspace_changes_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :commit_workspace_changes, name
      assert_kind_of ::Google::Cloud::Dataform::V1::CommitWorkspaceChangesRequest, request
      assert_equal "hello world", request["name"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Dataform::V1::CommitAuthor), request["author"]
      assert_equal "hello world", request["commit_message"]
      assert_equal ["hello world"], request["paths"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, commit_workspace_changes_client_stub do
      # Create client
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.commit_workspace_changes({ name: name, author: author, commit_message: commit_message, paths: paths }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.commit_workspace_changes name: name, author: author, commit_message: commit_message, paths: paths do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.commit_workspace_changes ::Google::Cloud::Dataform::V1::CommitWorkspaceChangesRequest.new(name: name, author: author, commit_message: commit_message, paths: paths) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.commit_workspace_changes({ name: name, author: author, commit_message: commit_message, paths: paths }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.commit_workspace_changes(::Google::Cloud::Dataform::V1::CommitWorkspaceChangesRequest.new(name: name, author: author, commit_message: commit_message, paths: paths), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, commit_workspace_changes_client_stub.call_rpc_count
    end
  end

  def test_reset_workspace_changes
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataform::V1::ResetWorkspaceChangesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    paths = ["hello world"]
    clean = true

    reset_workspace_changes_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :reset_workspace_changes, name
      assert_kind_of ::Google::Cloud::Dataform::V1::ResetWorkspaceChangesRequest, request
      assert_equal "hello world", request["name"]
      assert_equal ["hello world"], request["paths"]
      assert_equal true, request["clean"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, reset_workspace_changes_client_stub do
      # Create client
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.reset_workspace_changes({ name: name, paths: paths, clean: clean }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.reset_workspace_changes name: name, paths: paths, clean: clean do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.reset_workspace_changes ::Google::Cloud::Dataform::V1::ResetWorkspaceChangesRequest.new(name: name, paths: paths, clean: clean) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.reset_workspace_changes({ name: name, paths: paths, clean: clean }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.reset_workspace_changes(::Google::Cloud::Dataform::V1::ResetWorkspaceChangesRequest.new(name: name, paths: paths, clean: clean), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, reset_workspace_changes_client_stub.call_rpc_count
    end
  end

  def test_fetch_file_diff
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataform::V1::FetchFileDiffResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    workspace = "hello world"
    path = "hello world"

    fetch_file_diff_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :fetch_file_diff, name
      assert_kind_of ::Google::Cloud::Dataform::V1::FetchFileDiffRequest, request
      assert_equal "hello world", request["workspace"]
      assert_equal "hello world", request["path"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, fetch_file_diff_client_stub do
      # Create client
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.fetch_file_diff({ workspace: workspace, path: path }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.fetch_file_diff workspace: workspace, path: path do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.fetch_file_diff ::Google::Cloud::Dataform::V1::FetchFileDiffRequest.new(workspace: workspace, path: path) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.fetch_file_diff({ workspace: workspace, path: path }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.fetch_file_diff(::Google::Cloud::Dataform::V1::FetchFileDiffRequest.new(workspace: workspace, path: path), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, fetch_file_diff_client_stub.call_rpc_count
    end
  end

  def test_query_directory_contents
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataform::V1::QueryDirectoryContentsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    workspace = "hello world"
    path = "hello world"
    page_size = 42
    page_token = "hello world"

    query_directory_contents_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :query_directory_contents, name
      assert_kind_of ::Google::Cloud::Dataform::V1::QueryDirectoryContentsRequest, request
      assert_equal "hello world", request["workspace"]
      assert_equal "hello world", request["path"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, query_directory_contents_client_stub do
      # Create client
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.query_directory_contents({ workspace: workspace, path: path, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.query_directory_contents workspace: workspace, path: path, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.query_directory_contents ::Google::Cloud::Dataform::V1::QueryDirectoryContentsRequest.new(workspace: workspace, path: path, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.query_directory_contents({ workspace: workspace, path: path, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.query_directory_contents(::Google::Cloud::Dataform::V1::QueryDirectoryContentsRequest.new(workspace: workspace, path: path, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, query_directory_contents_client_stub.call_rpc_count
    end
  end

  def test_search_files
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataform::V1::SearchFilesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    workspace = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    search_files_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :search_files, name
      assert_kind_of ::Google::Cloud::Dataform::V1::SearchFilesRequest, request
      assert_equal "hello world", request["workspace"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, search_files_client_stub do
      # Create client
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.search_files({ workspace: workspace, page_size: page_size, page_token: page_token, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.search_files workspace: workspace, page_size: page_size, page_token: page_token, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.search_files ::Google::Cloud::Dataform::V1::SearchFilesRequest.new(workspace: workspace, page_size: page_size, page_token: page_token, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.search_files({ workspace: workspace, page_size: page_size, page_token: page_token, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.search_files(::Google::Cloud::Dataform::V1::SearchFilesRequest.new(workspace: workspace, page_size: page_size, page_token: page_token, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, search_files_client_stub.call_rpc_count
    end
  end

  def test_make_directory
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataform::V1::MakeDirectoryResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    workspace = "hello world"
    path = "hello world"

    make_directory_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :make_directory, name
      assert_kind_of ::Google::Cloud::Dataform::V1::MakeDirectoryRequest, request
      assert_equal "hello world", request["workspace"]
      assert_equal "hello world", request["path"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, make_directory_client_stub do
      # Create client
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.make_directory({ workspace: workspace, path: path }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.make_directory workspace: workspace, path: path do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.make_directory ::Google::Cloud::Dataform::V1::MakeDirectoryRequest.new(workspace: workspace, path: path) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.make_directory({ workspace: workspace, path: path }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.make_directory(::Google::Cloud::Dataform::V1::MakeDirectoryRequest.new(workspace: workspace, path: path), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, make_directory_client_stub.call_rpc_count
    end
  end

  def test_remove_directory
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataform::V1::RemoveDirectoryResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    workspace = "hello world"
    path = "hello world"

    remove_directory_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :remove_directory, name
      assert_kind_of ::Google::Cloud::Dataform::V1::RemoveDirectoryRequest, request
      assert_equal "hello world", request["workspace"]
      assert_equal "hello world", request["path"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, remove_directory_client_stub do
      # Create client
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.remove_directory({ workspace: workspace, path: path }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.remove_directory workspace: workspace, path: path do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.remove_directory ::Google::Cloud::Dataform::V1::RemoveDirectoryRequest.new(workspace: workspace, path: path) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.remove_directory({ workspace: workspace, path: path }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.remove_directory(::Google::Cloud::Dataform::V1::RemoveDirectoryRequest.new(workspace: workspace, path: path), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, remove_directory_client_stub.call_rpc_count
    end
  end

  def test_move_directory
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataform::V1::MoveDirectoryResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    workspace = "hello world"
    path = "hello world"
    new_path = "hello world"

    move_directory_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :move_directory, name
      assert_kind_of ::Google::Cloud::Dataform::V1::MoveDirectoryRequest, request
      assert_equal "hello world", request["workspace"]
      assert_equal "hello world", request["path"]
      assert_equal "hello world", request["new_path"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, move_directory_client_stub do
      # Create client
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.move_directory({ workspace: workspace, path: path, new_path: new_path }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.move_directory workspace: workspace, path: path, new_path: new_path do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.move_directory ::Google::Cloud::Dataform::V1::MoveDirectoryRequest.new(workspace: workspace, path: path, new_path: new_path) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.move_directory({ workspace: workspace, path: path, new_path: new_path }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.move_directory(::Google::Cloud::Dataform::V1::MoveDirectoryRequest.new(workspace: workspace, path: path, new_path: new_path), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, move_directory_client_stub.call_rpc_count
    end
  end

  def test_read_file
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataform::V1::ReadFileResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    workspace = "hello world"
    path = "hello world"
    revision = "hello world"

    read_file_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :read_file, name
      assert_kind_of ::Google::Cloud::Dataform::V1::ReadFileRequest, request
      assert_equal "hello world", request["workspace"]
      assert_equal "hello world", request["path"]
      assert_equal "hello world", request["revision"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, read_file_client_stub do
      # Create client
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.read_file({ workspace: workspace, path: path, revision: revision }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.read_file workspace: workspace, path: path, revision: revision do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.read_file ::Google::Cloud::Dataform::V1::ReadFileRequest.new(workspace: workspace, path: path, revision: revision) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.read_file({ workspace: workspace, path: path, revision: revision }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.read_file(::Google::Cloud::Dataform::V1::ReadFileRequest.new(workspace: workspace, path: path, revision: revision), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, read_file_client_stub.call_rpc_count
    end
  end

  def test_remove_file
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataform::V1::RemoveFileResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    workspace = "hello world"
    path = "hello world"

    remove_file_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :remove_file, name
      assert_kind_of ::Google::Cloud::Dataform::V1::RemoveFileRequest, request
      assert_equal "hello world", request["workspace"]
      assert_equal "hello world", request["path"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, remove_file_client_stub do
      # Create client
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.remove_file({ workspace: workspace, path: path }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.remove_file workspace: workspace, path: path do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.remove_file ::Google::Cloud::Dataform::V1::RemoveFileRequest.new(workspace: workspace, path: path) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.remove_file({ workspace: workspace, path: path }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.remove_file(::Google::Cloud::Dataform::V1::RemoveFileRequest.new(workspace: workspace, path: path), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, remove_file_client_stub.call_rpc_count
    end
  end

  def test_move_file
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataform::V1::MoveFileResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    workspace = "hello world"
    path = "hello world"
    new_path = "hello world"

    move_file_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :move_file, name
      assert_kind_of ::Google::Cloud::Dataform::V1::MoveFileRequest, request
      assert_equal "hello world", request["workspace"]
      assert_equal "hello world", request["path"]
      assert_equal "hello world", request["new_path"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, move_file_client_stub do
      # Create client
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.move_file({ workspace: workspace, path: path, new_path: new_path }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.move_file workspace: workspace, path: path, new_path: new_path do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.move_file ::Google::Cloud::Dataform::V1::MoveFileRequest.new(workspace: workspace, path: path, new_path: new_path) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.move_file({ workspace: workspace, path: path, new_path: new_path }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.move_file(::Google::Cloud::Dataform::V1::MoveFileRequest.new(workspace: workspace, path: path, new_path: new_path), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, move_file_client_stub.call_rpc_count
    end
  end

  def test_write_file
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataform::V1::WriteFileResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    workspace = "hello world"
    path = "hello world"
    contents = "hello world"

    write_file_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :write_file, name
      assert_kind_of ::Google::Cloud::Dataform::V1::WriteFileRequest, request
      assert_equal "hello world", request["workspace"]
      assert_equal "hello world", request["path"]
      assert_equal "hello world", request["contents"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, write_file_client_stub do
      # Create client
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.write_file({ workspace: workspace, path: path, contents: contents }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.write_file workspace: workspace, path: path, contents: contents do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.write_file ::Google::Cloud::Dataform::V1::WriteFileRequest.new(workspace: workspace, path: path, contents: contents) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.write_file({ workspace: workspace, path: path, contents: contents }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.write_file(::Google::Cloud::Dataform::V1::WriteFileRequest.new(workspace: workspace, path: path, contents: contents), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, write_file_client_stub.call_rpc_count
    end
  end

  def test_list_release_configs
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataform::V1::ListReleaseConfigsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_release_configs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_release_configs, name
      assert_kind_of ::Google::Cloud::Dataform::V1::ListReleaseConfigsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_release_configs_client_stub do
      # Create client
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_release_configs({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_release_configs parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_release_configs ::Google::Cloud::Dataform::V1::ListReleaseConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_release_configs({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_release_configs(::Google::Cloud::Dataform::V1::ListReleaseConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_release_configs_client_stub.call_rpc_count
    end
  end

  def test_get_release_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataform::V1::ReleaseConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_release_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_release_config, name
      assert_kind_of ::Google::Cloud::Dataform::V1::GetReleaseConfigRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_release_config_client_stub do
      # Create client
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_release_config({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_release_config name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_release_config ::Google::Cloud::Dataform::V1::GetReleaseConfigRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_release_config({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_release_config(::Google::Cloud::Dataform::V1::GetReleaseConfigRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_release_config_client_stub.call_rpc_count
    end
  end

  def test_create_release_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataform::V1::ReleaseConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    release_config = {}
    release_config_id = "hello world"

    create_release_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_release_config, name
      assert_kind_of ::Google::Cloud::Dataform::V1::CreateReleaseConfigRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Dataform::V1::ReleaseConfig), request["release_config"]
      assert_equal "hello world", request["release_config_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_release_config_client_stub do
      # Create client
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_release_config({ parent: parent, release_config: release_config, release_config_id: release_config_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_release_config parent: parent, release_config: release_config, release_config_id: release_config_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_release_config ::Google::Cloud::Dataform::V1::CreateReleaseConfigRequest.new(parent: parent, release_config: release_config, release_config_id: release_config_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_release_config({ parent: parent, release_config: release_config, release_config_id: release_config_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_release_config(::Google::Cloud::Dataform::V1::CreateReleaseConfigRequest.new(parent: parent, release_config: release_config, release_config_id: release_config_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_release_config_client_stub.call_rpc_count
    end
  end

  def test_update_release_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataform::V1::ReleaseConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    release_config = {}

    update_release_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_release_config, name
      assert_kind_of ::Google::Cloud::Dataform::V1::UpdateReleaseConfigRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Dataform::V1::ReleaseConfig), request["release_config"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_release_config_client_stub do
      # Create client
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_release_config({ update_mask: update_mask, release_config: release_config }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_release_config update_mask: update_mask, release_config: release_config do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_release_config ::Google::Cloud::Dataform::V1::UpdateReleaseConfigRequest.new(update_mask: update_mask, release_config: release_config) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_release_config({ update_mask: update_mask, release_config: release_config }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_release_config(::Google::Cloud::Dataform::V1::UpdateReleaseConfigRequest.new(update_mask: update_mask, release_config: release_config), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_release_config_client_stub.call_rpc_count
    end
  end

  def test_delete_release_config
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_release_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_release_config, name
      assert_kind_of ::Google::Cloud::Dataform::V1::DeleteReleaseConfigRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_release_config_client_stub do
      # Create client
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_release_config({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_release_config name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_release_config ::Google::Cloud::Dataform::V1::DeleteReleaseConfigRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_release_config({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_release_config(::Google::Cloud::Dataform::V1::DeleteReleaseConfigRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_release_config_client_stub.call_rpc_count
    end
  end

  def test_list_compilation_results
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataform::V1::ListCompilationResultsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"
    filter = "hello world"

    list_compilation_results_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_compilation_results, name
      assert_kind_of ::Google::Cloud::Dataform::V1::ListCompilationResultsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["order_by"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_compilation_results_client_stub do
      # Create client
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_compilation_results({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_compilation_results parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_compilation_results ::Google::Cloud::Dataform::V1::ListCompilationResultsRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_compilation_results({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_compilation_results(::Google::Cloud::Dataform::V1::ListCompilationResultsRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_compilation_results_client_stub.call_rpc_count
    end
  end

  def test_get_compilation_result
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataform::V1::CompilationResult.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_compilation_result_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_compilation_result, name
      assert_kind_of ::Google::Cloud::Dataform::V1::GetCompilationResultRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_compilation_result_client_stub do
      # Create client
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_compilation_result({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_compilation_result name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_compilation_result ::Google::Cloud::Dataform::V1::GetCompilationResultRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_compilation_result({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_compilation_result(::Google::Cloud::Dataform::V1::GetCompilationResultRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_compilation_result_client_stub.call_rpc_count
    end
  end

  def test_create_compilation_result
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataform::V1::CompilationResult.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    compilation_result = {}

    create_compilation_result_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_compilation_result, name
      assert_kind_of ::Google::Cloud::Dataform::V1::CreateCompilationResultRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Dataform::V1::CompilationResult), request["compilation_result"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_compilation_result_client_stub do
      # Create client
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_compilation_result({ parent: parent, compilation_result: compilation_result }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_compilation_result parent: parent, compilation_result: compilation_result do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_compilation_result ::Google::Cloud::Dataform::V1::CreateCompilationResultRequest.new(parent: parent, compilation_result: compilation_result) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_compilation_result({ parent: parent, compilation_result: compilation_result }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_compilation_result(::Google::Cloud::Dataform::V1::CreateCompilationResultRequest.new(parent: parent, compilation_result: compilation_result), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_compilation_result_client_stub.call_rpc_count
    end
  end

  def test_query_compilation_result_actions
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataform::V1::QueryCompilationResultActionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    query_compilation_result_actions_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :query_compilation_result_actions, name
      assert_kind_of ::Google::Cloud::Dataform::V1::QueryCompilationResultActionsRequest, request
      assert_equal "hello world", request["name"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, query_compilation_result_actions_client_stub do
      # Create client
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.query_compilation_result_actions({ name: name, page_size: page_size, page_token: page_token, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.query_compilation_result_actions name: name, page_size: page_size, page_token: page_token, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.query_compilation_result_actions ::Google::Cloud::Dataform::V1::QueryCompilationResultActionsRequest.new(name: name, page_size: page_size, page_token: page_token, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.query_compilation_result_actions({ name: name, page_size: page_size, page_token: page_token, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.query_compilation_result_actions(::Google::Cloud::Dataform::V1::QueryCompilationResultActionsRequest.new(name: name, page_size: page_size, page_token: page_token, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, query_compilation_result_actions_client_stub.call_rpc_count
    end
  end

  def test_list_workflow_configs
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataform::V1::ListWorkflowConfigsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_workflow_configs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_workflow_configs, name
      assert_kind_of ::Google::Cloud::Dataform::V1::ListWorkflowConfigsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_workflow_configs_client_stub do
      # Create client
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_workflow_configs({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_workflow_configs parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_workflow_configs ::Google::Cloud::Dataform::V1::ListWorkflowConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_workflow_configs({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_workflow_configs(::Google::Cloud::Dataform::V1::ListWorkflowConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_workflow_configs_client_stub.call_rpc_count
    end
  end

  def test_get_workflow_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataform::V1::WorkflowConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_workflow_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_workflow_config, name
      assert_kind_of ::Google::Cloud::Dataform::V1::GetWorkflowConfigRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_workflow_config_client_stub do
      # Create client
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_workflow_config({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_workflow_config name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_workflow_config ::Google::Cloud::Dataform::V1::GetWorkflowConfigRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_workflow_config({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_workflow_config(::Google::Cloud::Dataform::V1::GetWorkflowConfigRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_workflow_config_client_stub.call_rpc_count
    end
  end

  def test_create_workflow_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataform::V1::WorkflowConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    workflow_config = {}
    workflow_config_id = "hello world"

    create_workflow_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_workflow_config, name
      assert_kind_of ::Google::Cloud::Dataform::V1::CreateWorkflowConfigRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Dataform::V1::WorkflowConfig), request["workflow_config"]
      assert_equal "hello world", request["workflow_config_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_workflow_config_client_stub do
      # Create client
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_workflow_config({ parent: parent, workflow_config: workflow_config, workflow_config_id: workflow_config_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_workflow_config parent: parent, workflow_config: workflow_config, workflow_config_id: workflow_config_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_workflow_config ::Google::Cloud::Dataform::V1::CreateWorkflowConfigRequest.new(parent: parent, workflow_config: workflow_config, workflow_config_id: workflow_config_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_workflow_config({ parent: parent, workflow_config: workflow_config, workflow_config_id: workflow_config_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_workflow_config(::Google::Cloud::Dataform::V1::CreateWorkflowConfigRequest.new(parent: parent, workflow_config: workflow_config, workflow_config_id: workflow_config_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_workflow_config_client_stub.call_rpc_count
    end
  end

  def test_update_workflow_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataform::V1::WorkflowConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    workflow_config = {}

    update_workflow_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_workflow_config, name
      assert_kind_of ::Google::Cloud::Dataform::V1::UpdateWorkflowConfigRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Dataform::V1::WorkflowConfig), request["workflow_config"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_workflow_config_client_stub do
      # Create client
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_workflow_config({ update_mask: update_mask, workflow_config: workflow_config }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_workflow_config update_mask: update_mask, workflow_config: workflow_config do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_workflow_config ::Google::Cloud::Dataform::V1::UpdateWorkflowConfigRequest.new(update_mask: update_mask, workflow_config: workflow_config) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_workflow_config({ update_mask: update_mask, workflow_config: workflow_config }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_workflow_config(::Google::Cloud::Dataform::V1::UpdateWorkflowConfigRequest.new(update_mask: update_mask, workflow_config: workflow_config), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_workflow_config_client_stub.call_rpc_count
    end
  end

  def test_delete_workflow_config
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_workflow_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_workflow_config, name
      assert_kind_of ::Google::Cloud::Dataform::V1::DeleteWorkflowConfigRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_workflow_config_client_stub do
      # Create client
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_workflow_config({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_workflow_config name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_workflow_config ::Google::Cloud::Dataform::V1::DeleteWorkflowConfigRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_workflow_config({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_workflow_config(::Google::Cloud::Dataform::V1::DeleteWorkflowConfigRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_workflow_config_client_stub.call_rpc_count
    end
  end

  def test_list_workflow_invocations
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataform::V1::ListWorkflowInvocationsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"
    filter = "hello world"

    list_workflow_invocations_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_workflow_invocations, name
      assert_kind_of ::Google::Cloud::Dataform::V1::ListWorkflowInvocationsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["order_by"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_workflow_invocations_client_stub do
      # Create client
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_workflow_invocations({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_workflow_invocations parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_workflow_invocations ::Google::Cloud::Dataform::V1::ListWorkflowInvocationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_workflow_invocations({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_workflow_invocations(::Google::Cloud::Dataform::V1::ListWorkflowInvocationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_workflow_invocations_client_stub.call_rpc_count
    end
  end

  def test_get_workflow_invocation
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataform::V1::WorkflowInvocation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_workflow_invocation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_workflow_invocation, name
      assert_kind_of ::Google::Cloud::Dataform::V1::GetWorkflowInvocationRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_workflow_invocation_client_stub do
      # Create client
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_workflow_invocation({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_workflow_invocation name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_workflow_invocation ::Google::Cloud::Dataform::V1::GetWorkflowInvocationRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_workflow_invocation({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_workflow_invocation(::Google::Cloud::Dataform::V1::GetWorkflowInvocationRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_workflow_invocation_client_stub.call_rpc_count
    end
  end

  def test_create_workflow_invocation
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataform::V1::WorkflowInvocation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    workflow_invocation = {}

    create_workflow_invocation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_workflow_invocation, name
      assert_kind_of ::Google::Cloud::Dataform::V1::CreateWorkflowInvocationRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Dataform::V1::WorkflowInvocation), request["workflow_invocation"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_workflow_invocation_client_stub do
      # Create client
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_workflow_invocation({ parent: parent, workflow_invocation: workflow_invocation }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_workflow_invocation parent: parent, workflow_invocation: workflow_invocation do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_workflow_invocation ::Google::Cloud::Dataform::V1::CreateWorkflowInvocationRequest.new(parent: parent, workflow_invocation: workflow_invocation) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_workflow_invocation({ parent: parent, workflow_invocation: workflow_invocation }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_workflow_invocation(::Google::Cloud::Dataform::V1::CreateWorkflowInvocationRequest.new(parent: parent, workflow_invocation: workflow_invocation), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_workflow_invocation_client_stub.call_rpc_count
    end
  end

  def test_delete_workflow_invocation
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_workflow_invocation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_workflow_invocation, name
      assert_kind_of ::Google::Cloud::Dataform::V1::DeleteWorkflowInvocationRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_workflow_invocation_client_stub do
      # Create client
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_workflow_invocation({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_workflow_invocation name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_workflow_invocation ::Google::Cloud::Dataform::V1::DeleteWorkflowInvocationRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_workflow_invocation({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_workflow_invocation(::Google::Cloud::Dataform::V1::DeleteWorkflowInvocationRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_workflow_invocation_client_stub.call_rpc_count
    end
  end

  def test_cancel_workflow_invocation
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataform::V1::CancelWorkflowInvocationResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    cancel_workflow_invocation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :cancel_workflow_invocation, name
      assert_kind_of ::Google::Cloud::Dataform::V1::CancelWorkflowInvocationRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, cancel_workflow_invocation_client_stub do
      # Create client
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.cancel_workflow_invocation({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.cancel_workflow_invocation name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.cancel_workflow_invocation ::Google::Cloud::Dataform::V1::CancelWorkflowInvocationRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.cancel_workflow_invocation({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.cancel_workflow_invocation(::Google::Cloud::Dataform::V1::CancelWorkflowInvocationRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, cancel_workflow_invocation_client_stub.call_rpc_count
    end
  end

  def test_query_workflow_invocation_actions
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataform::V1::QueryWorkflowInvocationActionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    page_size = 42
    page_token = "hello world"

    query_workflow_invocation_actions_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :query_workflow_invocation_actions, name
      assert_kind_of ::Google::Cloud::Dataform::V1::QueryWorkflowInvocationActionsRequest, request
      assert_equal "hello world", request["name"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, query_workflow_invocation_actions_client_stub do
      # Create client
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.query_workflow_invocation_actions({ name: name, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.query_workflow_invocation_actions name: name, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.query_workflow_invocation_actions ::Google::Cloud::Dataform::V1::QueryWorkflowInvocationActionsRequest.new(name: name, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.query_workflow_invocation_actions({ name: name, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.query_workflow_invocation_actions(::Google::Cloud::Dataform::V1::QueryWorkflowInvocationActionsRequest.new(name: name, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, query_workflow_invocation_actions_client_stub.call_rpc_count
    end
  end

  def test_get_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataform::V1::Config.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_config, name
      assert_kind_of ::Google::Cloud::Dataform::V1::GetConfigRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_config_client_stub do
      # Create client
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_config({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_config name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_config ::Google::Cloud::Dataform::V1::GetConfigRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_config({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_config(::Google::Cloud::Dataform::V1::GetConfigRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_config_client_stub.call_rpc_count
    end
  end

  def test_update_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataform::V1::Config.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    config = {}
    update_mask = {}

    update_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_config, name
      assert_kind_of ::Google::Cloud::Dataform::V1::UpdateConfigRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Dataform::V1::Config), request["config"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_config_client_stub do
      # Create client
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_config({ config: config, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_config config: config, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_config ::Google::Cloud::Dataform::V1::UpdateConfigRequest.new(config: config, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_config({ config: config, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_config(::Google::Cloud::Dataform::V1::UpdateConfigRequest.new(config: config, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_config_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Dataform::V1::Dataform::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::Dataform::V1::Dataform::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
