# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/dataform/v1/dataform"

class ::Google::Cloud::Dataform::V1::Dataform::ClientPathsTest < Minitest::Test
  class DummyStub
    def endpoint
      "endpoint.example.com"
    end
  
    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_compilation_result_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.compilation_result_path project: "value0", location: "value1", repository: "value2", compilation_result: "value3"
      assert_equal "projects/value0/locations/value1/repositories/value2/compilationResults/value3", path
    end
  end

  def test_config_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.config_path project: "value0", location: "value1"
      assert_equal "projects/value0/locations/value1/config", path
    end
  end

  def test_crypto_key_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.crypto_key_path project: "value0", location: "value1", key_ring: "value2", crypto_key: "value3"
      assert_equal "projects/value0/locations/value1/keyRings/value2/cryptoKeys/value3", path
    end
  end

  def test_crypto_key_version_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.crypto_key_version_path project: "value0", location: "value1", key_ring: "value2", crypto_key: "value3", crypto_key_version: "value4"
      assert_equal "projects/value0/locations/value1/keyRings/value2/cryptoKeys/value3/cryptoKeyVersions/value4", path
    end
  end

  def test_location_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.location_path project: "value0", location: "value1"
      assert_equal "projects/value0/locations/value1", path
    end
  end

  def test_notebook_runtime_template_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.notebook_runtime_template_path project: "value0", location: "value1", notebook_runtime_template: "value2"
      assert_equal "projects/value0/locations/value1/notebookRuntimeTemplates/value2", path
    end
  end

  def test_release_config_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.release_config_path project: "value0", location: "value1", repository: "value2", release_config: "value3"
      assert_equal "projects/value0/locations/value1/repositories/value2/releaseConfigs/value3", path
    end
  end

  def test_repository_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.repository_path project: "value0", location: "value1", repository: "value2"
      assert_equal "projects/value0/locations/value1/repositories/value2", path
    end
  end

  def test_secret_version_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.secret_version_path project: "value0", secret: "value1", version: "value2"
      assert_equal "projects/value0/secrets/value1/versions/value2", path
    end
  end

  def test_workflow_config_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.workflow_config_path project: "value0", location: "value1", repository: "value2", workflow_config: "value3"
      assert_equal "projects/value0/locations/value1/repositories/value2/workflowConfigs/value3", path
    end
  end

  def test_workflow_invocation_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.workflow_invocation_path project: "value0", location: "value1", repository: "value2", workflow_invocation: "value3"
      assert_equal "projects/value0/locations/value1/repositories/value2/workflowInvocations/value3", path
    end
  end

  def test_workspace_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Dataform::V1::Dataform::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.workspace_path project: "value0", location: "value1", repository: "value2", workspace: "value3"
      assert_equal "projects/value0/locations/value1/repositories/value2/workspaces/value3", path
    end
  end
end
