# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Dataform
      module V1
        # Describes encryption state of a resource.
        # @!attribute [rw] kms_key_version_name
        #   @return [::String]
        #     Required. The KMS key version name with which data of a resource is
        #     encrypted.
        class DataEncryptionState
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a Dataform Git repository.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The repository's name.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp of when the repository was created.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Optional. The repository's user-friendly name.
        # @!attribute [rw] git_remote_settings
        #   @return [::Google::Cloud::Dataform::V1::Repository::GitRemoteSettings]
        #     Optional. If set, configures this repository to be linked to a Git remote.
        # @!attribute [rw] npmrc_environment_variables_secret_version
        #   @return [::String]
        #     Optional. The name of the Secret Manager secret version to be used to
        #     interpolate variables into the .npmrc file for package installation
        #     operations. Must be in the format `projects/*/secrets/*/versions/*`. The
        #     file itself must be in a JSON format.
        # @!attribute [rw] workspace_compilation_overrides
        #   @return [::Google::Cloud::Dataform::V1::Repository::WorkspaceCompilationOverrides]
        #     Optional. If set, fields of `workspace_compilation_overrides` override the
        #     default compilation settings that are specified in dataform.json when
        #     creating workspace-scoped compilation results. See documentation for
        #     `WorkspaceCompilationOverrides` for more information.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Repository user labels.
        # @!attribute [rw] set_authenticated_user_admin
        #   @return [::Boolean]
        #     Optional. Input only. If set to true, the authenticated user will be
        #     granted the roles/dataform.admin role on the created repository.
        # @!attribute [rw] service_account
        #   @return [::String]
        #     Optional. The service account to run workflow invocations under.
        # @!attribute [rw] kms_key_name
        #   @return [::String]
        #     Optional. The reference to a KMS encryption key. If provided, it will be
        #     used to encrypt user data in the repository and all child resources. It is
        #     not possible to add or update the encryption key after the repository is
        #     created. Example:
        #     `projects/{kms_project}/locations/{location}/keyRings/{key_location}/cryptoKeys/{key}`
        # @!attribute [r] data_encryption_state
        #   @return [::Google::Cloud::Dataform::V1::DataEncryptionState]
        #     Output only. A data encryption state of a Git repository if this Repository
        #     is protected by a KMS key.
        # @!attribute [r] internal_metadata
        #   @return [::String]
        #     Output only. All the metadata information that is used internally to serve
        #     the resource. For example: timestamps, flags, status fields, etc. The
        #     format of this field is a JSON string.
        class Repository
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Controls Git remote configuration for a repository.
          # @!attribute [rw] url
          #   @return [::String]
          #     Required. The Git remote's URL.
          # @!attribute [rw] default_branch
          #   @return [::String]
          #     Required. The Git remote's default branch name.
          # @!attribute [rw] authentication_token_secret_version
          #   @return [::String]
          #     Optional. The name of the Secret Manager secret version to use as an
          #     authentication token for Git operations. Must be in the format
          #     `projects/*/secrets/*/versions/*`.
          # @!attribute [rw] ssh_authentication_config
          #   @return [::Google::Cloud::Dataform::V1::Repository::GitRemoteSettings::SshAuthenticationConfig]
          #     Optional. Authentication fields for remote uris using SSH protocol.
          # @!attribute [r] token_status
          #   @deprecated This field is deprecated and may be removed in the next major version update.
          #   @return [::Google::Cloud::Dataform::V1::Repository::GitRemoteSettings::TokenStatus]
          #     Output only. Deprecated: The field does not contain any token status
          #     information.
          class GitRemoteSettings
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Configures fields for performing SSH authentication.
            # @!attribute [rw] user_private_key_secret_version
            #   @return [::String]
            #     Required. The name of the Secret Manager secret version to use as a
            #     ssh private key for Git operations.
            #     Must be in the format `projects/*/secrets/*/versions/*`.
            # @!attribute [rw] host_public_key
            #   @return [::String]
            #     Required. Content of a public SSH key to verify an identity of a remote
            #     Git host.
            class SshAuthenticationConfig
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The status of the authentication token.
            module TokenStatus
              # Default value. This value is unused.
              TOKEN_STATUS_UNSPECIFIED = 0

              # The token could not be found in Secret Manager (or the Dataform
              # Service Account did not have permission to access it).
              NOT_FOUND = 1

              # The token could not be used to authenticate against the Git remote.
              INVALID = 2

              # The token was used successfully to authenticate against the Git remote.
              VALID = 3
            end
          end

          # Configures workspace compilation overrides for a repository.
          # @!attribute [rw] default_database
          #   @return [::String]
          #     Optional. The default database (Google Cloud project ID).
          # @!attribute [rw] schema_suffix
          #   @return [::String]
          #     Optional. The suffix that should be appended to all schema (BigQuery
          #     dataset ID) names.
          # @!attribute [rw] table_prefix
          #   @return [::String]
          #     Optional. The prefix that should be prepended to all table names.
          class WorkspaceCompilationOverrides
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # `ListRepositories` request message.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The location in which to list repositories. Must be in the format
        #     `projects/*/locations/*`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Maximum number of repositories to return. The server may return
        #     fewer items than requested. If unspecified, the server will pick an
        #     appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. Page token received from a previous `ListRepositories` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListRepositories`,
        #     with the exception of `page_size`, must match the call that provided the
        #     page token.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. This field only supports ordering by `name`. If unspecified, the
        #     server will choose the ordering. If specified, the default order is
        #     ascending for the `name` field.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filter for the returned list.
        class ListRepositoriesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `ListRepositories` response message.
        # @!attribute [rw] repositories
        #   @return [::Array<::Google::Cloud::Dataform::V1::Repository>]
        #     List of repositories.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations which could not be reached.
        class ListRepositoriesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `GetRepository` request message.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The repository's name.
        class GetRepositoryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `CreateRepository` request message.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The location in which to create the repository. Must be in the
        #     format `projects/*/locations/*`.
        # @!attribute [rw] repository
        #   @return [::Google::Cloud::Dataform::V1::Repository]
        #     Required. The repository to create.
        # @!attribute [rw] repository_id
        #   @return [::String]
        #     Required. The ID to use for the repository, which will become the final
        #     component of the repository's resource name.
        class CreateRepositoryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `UpdateRepository` request message.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Specifies the fields to be updated in the repository. If left
        #     unset, all fields will be updated.
        # @!attribute [rw] repository
        #   @return [::Google::Cloud::Dataform::V1::Repository]
        #     Required. The repository to update.
        class UpdateRepositoryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `DeleteRepository` request message.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The repository's name.
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     Optional. If set to true, any child resources of this repository will also
        #     be deleted. (Otherwise, the request will only succeed if the repository has
        #     no child resources.)
        class DeleteRepositoryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `CommitRepositoryChanges` request message.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The repository's name.
        # @!attribute [rw] commit_metadata
        #   @return [::Google::Cloud::Dataform::V1::CommitMetadata]
        #     Required. The changes to commit to the repository.
        # @!attribute [rw] required_head_commit_sha
        #   @return [::String]
        #     Optional. The commit SHA which must be the repository's current HEAD before
        #     applying this commit; otherwise this request will fail. If unset, no
        #     validation on the current HEAD commit SHA is performed.
        # @!attribute [rw] file_operations
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Dataform::V1::CommitRepositoryChangesRequest::FileOperation}]
        #     Optional. A map to the path of the file to the operation. The path is the
        #     full file path including filename, from repository root.
        class CommitRepositoryChangesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Represents a single file operation to the repository.
          # @!attribute [rw] write_file
          #   @return [::Google::Cloud::Dataform::V1::CommitRepositoryChangesRequest::FileOperation::WriteFile]
          #     Represents the write operation.
          #
          #     Note: The following fields are mutually exclusive: `write_file`, `delete_file`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] delete_file
          #   @return [::Google::Cloud::Dataform::V1::CommitRepositoryChangesRequest::FileOperation::DeleteFile]
          #     Represents the delete operation.
          #
          #     Note: The following fields are mutually exclusive: `delete_file`, `write_file`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class FileOperation
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Represents the write file operation (for files added or modified).
            # @!attribute [rw] contents
            #   @return [::String]
            #     The file's contents.
            class WriteFile
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Represents the delete file operation.
            class DeleteFile
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::Dataform::V1::CommitRepositoryChangesRequest::FileOperation]
          class FileOperationsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # `CommitRepositoryChanges` response message.
        # @!attribute [rw] commit_sha
        #   @return [::String]
        #     The commit SHA of the current commit.
        class CommitRepositoryChangesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `ReadRepositoryFile` request message.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The repository's name.
        # @!attribute [rw] commit_sha
        #   @return [::String]
        #     Optional. The commit SHA for the commit to read from. If unset, the file
        #     will be read from HEAD.
        # @!attribute [rw] path
        #   @return [::String]
        #     Required. Full file path to read including filename, from repository root.
        class ReadRepositoryFileRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `ReadRepositoryFile` response message.
        # @!attribute [rw] contents
        #   @return [::String]
        #     The file's contents.
        class ReadRepositoryFileResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `QueryRepositoryDirectoryContents` request message.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The repository's name.
        # @!attribute [rw] commit_sha
        #   @return [::String]
        #     Optional. The Commit SHA for the commit to query from. If unset, the
        #     directory will be queried from HEAD.
        # @!attribute [rw] path
        #   @return [::String]
        #     Optional. The directory's full path including directory name, relative to
        #     root. If left unset, the root is used.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Maximum number of paths to return. The server may return fewer
        #     items than requested. If unspecified, the server will pick an appropriate
        #     default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. Page token received from a previous
        #     `QueryRepositoryDirectoryContents` call. Provide this to retrieve the
        #     subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     `QueryRepositoryDirectoryContents`, with the exception of `page_size`, must
        #     match the call that provided the page token.
        class QueryRepositoryDirectoryContentsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `QueryRepositoryDirectoryContents` response message.
        # @!attribute [rw] directory_entries
        #   @return [::Array<::Google::Cloud::Dataform::V1::DirectoryEntry>]
        #     List of entries in the directory.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class QueryRepositoryDirectoryContentsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `FetchRepositoryHistory` request message.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The repository's name.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Maximum number of commits to return. The server may return fewer
        #     items than requested. If unspecified, the server will pick an appropriate
        #     default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. Page token received from a previous `FetchRepositoryHistory`
        #     call. Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `FetchRepositoryHistory`,
        #     with the exception of `page_size`, must match the call that provided the
        #     page token.
        class FetchRepositoryHistoryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `FetchRepositoryHistory` response message.
        # @!attribute [rw] commits
        #   @return [::Array<::Google::Cloud::Dataform::V1::CommitLogEntry>]
        #     A list of commit logs, ordered by 'git log' default order.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class FetchRepositoryHistoryResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a single commit log.
        # @!attribute [rw] commit_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Commit timestamp.
        # @!attribute [rw] commit_sha
        #   @return [::String]
        #     The commit SHA for this commit log entry.
        # @!attribute [rw] author
        #   @return [::Google::Cloud::Dataform::V1::CommitAuthor]
        #     The commit author for this commit log entry.
        # @!attribute [rw] commit_message
        #   @return [::String]
        #     The commit message for this commit log entry.
        class CommitLogEntry
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a Dataform Git commit.
        # @!attribute [rw] author
        #   @return [::Google::Cloud::Dataform::V1::CommitAuthor]
        #     Required. The commit's author.
        # @!attribute [rw] commit_message
        #   @return [::String]
        #     Optional. The commit's message.
        class CommitMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `ComputeRepositoryAccessTokenStatus` request message.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The repository's name.
        class ComputeRepositoryAccessTokenStatusRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `ComputeRepositoryAccessTokenStatus` response message.
        # @!attribute [rw] token_status
        #   @return [::Google::Cloud::Dataform::V1::ComputeRepositoryAccessTokenStatusResponse::TokenStatus]
        #     Indicates the status of the Git access token.
        class ComputeRepositoryAccessTokenStatusResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Indicates the status of a Git authentication token.
          module TokenStatus
            # Default value. This value is unused.
            TOKEN_STATUS_UNSPECIFIED = 0

            # The token could not be found in Secret Manager (or the Dataform
            # Service Account did not have permission to access it).
            NOT_FOUND = 1

            # The token could not be used to authenticate against the Git remote.
            INVALID = 2

            # The token was used successfully to authenticate against the Git remote.
            VALID = 3
          end
        end

        # `FetchRemoteBranches` request message.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The repository's name.
        class FetchRemoteBranchesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `FetchRemoteBranches` response message.
        # @!attribute [rw] branches
        #   @return [::Array<::String>]
        #     The remote repository's branch names.
        class FetchRemoteBranchesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a Dataform Git workspace.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The workspace's name.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp of when the workspace was created.
        # @!attribute [r] data_encryption_state
        #   @return [::Google::Cloud::Dataform::V1::DataEncryptionState]
        #     Output only. A data encryption state of a Git repository if this Workspace
        #     is protected by a KMS key.
        # @!attribute [r] internal_metadata
        #   @return [::String]
        #     Output only. All the metadata information that is used internally to serve
        #     the resource. For example: timestamps, flags, status fields, etc. The
        #     format of this field is a JSON string.
        class Workspace
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `ListWorkspaces` request message.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The repository in which to list workspaces. Must be in the
        #     format `projects/*/locations/*/repositories/*`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Maximum number of workspaces to return. The server may return
        #     fewer items than requested. If unspecified, the server will pick an
        #     appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. Page token received from a previous `ListWorkspaces` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListWorkspaces`, with
        #     the exception of `page_size`, must match the call that provided the page
        #     token.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. This field only supports ordering by `name`. If unspecified, the
        #     server will choose the ordering. If specified, the default order is
        #     ascending for the `name` field.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filter for the returned list.
        class ListWorkspacesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `ListWorkspaces` response message.
        # @!attribute [rw] workspaces
        #   @return [::Array<::Google::Cloud::Dataform::V1::Workspace>]
        #     List of workspaces.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations which could not be reached.
        class ListWorkspacesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `GetWorkspace` request message.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The workspace's name.
        class GetWorkspaceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `CreateWorkspace` request message.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The repository in which to create the workspace. Must be in the
        #     format `projects/*/locations/*/repositories/*`.
        # @!attribute [rw] workspace
        #   @return [::Google::Cloud::Dataform::V1::Workspace]
        #     Required. The workspace to create.
        # @!attribute [rw] workspace_id
        #   @return [::String]
        #     Required. The ID to use for the workspace, which will become the final
        #     component of the workspace's resource name.
        class CreateWorkspaceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `DeleteWorkspace` request message.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The workspace resource's name.
        class DeleteWorkspaceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the author of a Git commit.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The commit author's name.
        # @!attribute [rw] email_address
        #   @return [::String]
        #     Required. The commit author's email address.
        class CommitAuthor
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `PullGitCommits` request message.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The workspace's name.
        # @!attribute [rw] remote_branch
        #   @return [::String]
        #     Optional. The name of the branch in the Git remote from which to pull
        #     commits. If left unset, the repository's default branch name will be used.
        # @!attribute [rw] author
        #   @return [::Google::Cloud::Dataform::V1::CommitAuthor]
        #     Required. The author of any merge commit which may be created as a result
        #     of merging fetched Git commits into this workspace.
        class PullGitCommitsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `PullGitCommits` response message.
        class PullGitCommitsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `PushGitCommits` request message.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The workspace's name.
        # @!attribute [rw] remote_branch
        #   @return [::String]
        #     Optional. The name of the branch in the Git remote to which commits should
        #     be pushed. If left unset, the repository's default branch name will be
        #     used.
        class PushGitCommitsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `PushGitCommits` response message.
        class PushGitCommitsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `FetchFileGitStatuses` request message.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The workspace's name.
        class FetchFileGitStatusesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `FetchFileGitStatuses` response message.
        # @!attribute [rw] uncommitted_file_changes
        #   @return [::Array<::Google::Cloud::Dataform::V1::FetchFileGitStatusesResponse::UncommittedFileChange>]
        #     A list of all files which have uncommitted Git changes. There will only be
        #     a single entry for any given file.
        class FetchFileGitStatusesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Represents the Git state of a file with uncommitted changes.
          # @!attribute [rw] path
          #   @return [::String]
          #     The file's full path including filename, relative to the workspace root.
          # @!attribute [r] state
          #   @return [::Google::Cloud::Dataform::V1::FetchFileGitStatusesResponse::UncommittedFileChange::State]
          #     Output only. Indicates the status of the file.
          class UncommittedFileChange
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Indicates the status of an uncommitted file change.
            module State
              # Default value. This value is unused.
              STATE_UNSPECIFIED = 0

              # The file has been newly added.
              ADDED = 1

              # The file has been deleted.
              DELETED = 2

              # The file has been modified.
              MODIFIED = 3

              # The file contains merge conflicts.
              HAS_CONFLICTS = 4
            end
          end
        end

        # `FetchGitAheadBehind` request message.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The workspace's name.
        # @!attribute [rw] remote_branch
        #   @return [::String]
        #     Optional. The name of the branch in the Git remote against which this
        #     workspace should be compared. If left unset, the repository's default
        #     branch name will be used.
        class FetchGitAheadBehindRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `FetchGitAheadBehind` response message.
        # @!attribute [rw] commits_ahead
        #   @return [::Integer]
        #     The number of commits in the remote branch that are not in the workspace.
        # @!attribute [rw] commits_behind
        #   @return [::Integer]
        #     The number of commits in the workspace that are not in the remote branch.
        class FetchGitAheadBehindResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `CommitWorkspaceChanges` request message.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The workspace's name.
        # @!attribute [rw] author
        #   @return [::Google::Cloud::Dataform::V1::CommitAuthor]
        #     Required. The commit's author.
        # @!attribute [rw] commit_message
        #   @return [::String]
        #     Optional. The commit's message.
        # @!attribute [rw] paths
        #   @return [::Array<::String>]
        #     Optional. Full file paths to commit including filename, rooted at workspace
        #     root. If left empty, all files will be committed.
        class CommitWorkspaceChangesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `CommitWorkspaceChanges` response message.
        class CommitWorkspaceChangesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `ResetWorkspaceChanges` request message.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The workspace's name.
        # @!attribute [rw] paths
        #   @return [::Array<::String>]
        #     Optional. Full file paths to reset back to their committed state including
        #     filename, rooted at workspace root. If left empty, all files will be reset.
        # @!attribute [rw] clean
        #   @return [::Boolean]
        #     Optional. If set to true, untracked files will be deleted.
        class ResetWorkspaceChangesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `ResetWorkspaceChanges` response message.
        class ResetWorkspaceChangesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `FetchFileDiff` request message.
        # @!attribute [rw] workspace
        #   @return [::String]
        #     Required. The workspace's name.
        # @!attribute [rw] path
        #   @return [::String]
        #     Required. The file's full path including filename, relative to the
        #     workspace root.
        class FetchFileDiffRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `FetchFileDiff` response message.
        # @!attribute [rw] formatted_diff
        #   @return [::String]
        #     The raw formatted Git diff for the file.
        class FetchFileDiffResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `QueryDirectoryContents` request message.
        # @!attribute [rw] workspace
        #   @return [::String]
        #     Required. The workspace's name.
        # @!attribute [rw] path
        #   @return [::String]
        #     Optional. The directory's full path including directory name, relative to
        #     the workspace root. If left unset, the workspace root is used.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Maximum number of paths to return. The server may return fewer
        #     items than requested. If unspecified, the server will pick an appropriate
        #     default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. Page token received from a previous `QueryDirectoryContents`
        #     call. Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     `QueryDirectoryContents`, with the exception of `page_size`, must match the
        #     call that provided the page token.
        class QueryDirectoryContentsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `QueryDirectoryContents` response message.
        # @!attribute [rw] directory_entries
        #   @return [::Array<::Google::Cloud::Dataform::V1::DirectoryEntry>]
        #     List of entries in the directory.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class QueryDirectoryContentsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a single entry in a directory.
        # @!attribute [rw] file
        #   @return [::String]
        #     A file in the directory.
        #
        #     Note: The following fields are mutually exclusive: `file`, `directory`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] directory
        #   @return [::String]
        #     A child directory in the directory.
        #
        #     Note: The following fields are mutually exclusive: `directory`, `file`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class DirectoryEntry
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration containing file search request parameters.
        # @!attribute [rw] workspace
        #   @return [::String]
        #     Required. The workspace's name.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Maximum number of search results to return. The server may return
        #     fewer items than requested. If unspecified, the server will pick an
        #     appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. Page token received from a previous `SearchFilesRequest`
        #     call. Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `SearchFilesRequest`,
        #     with the exception of `page_size`, must match the call that provided the
        #     page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Optional filter for the returned list in filtering format.
        #     Filtering is only currently supported on the `path` field.
        #     See https://google.aip.dev/160 for details.
        class SearchFilesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Client-facing representation of a file search response.
        # @!attribute [rw] search_results
        #   @return [::Array<::Google::Cloud::Dataform::V1::SearchResult>]
        #     List of matched results.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Optional. A token, which can be sent as `page_token` to retrieve the next
        #     page. If this field is omitted, there are no subsequent pages.
        class SearchFilesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Client-facing representation of a search result entry.
        # @!attribute [rw] file
        #   @return [::Google::Cloud::Dataform::V1::FileSearchResult]
        #     Details when search result is a file.
        #
        #     Note: The following fields are mutually exclusive: `file`, `directory`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] directory
        #   @return [::Google::Cloud::Dataform::V1::DirectorySearchResult]
        #     Details when search result is a directory.
        #
        #     Note: The following fields are mutually exclusive: `directory`, `file`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class SearchResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Client-facing representation of a file entry in search results.
        # @!attribute [rw] path
        #   @return [::String]
        #     File system path relative to the workspace root.
        class FileSearchResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Client-facing representation of a directory entry in search results.
        # @!attribute [rw] path
        #   @return [::String]
        #     File system path relative to the workspace root.
        class DirectorySearchResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `MakeDirectory` request message.
        # @!attribute [rw] workspace
        #   @return [::String]
        #     Required. The workspace's name.
        # @!attribute [rw] path
        #   @return [::String]
        #     Required. The directory's full path including directory name, relative to
        #     the workspace root.
        class MakeDirectoryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `MakeDirectory` response message.
        class MakeDirectoryResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `RemoveDirectory` request message.
        # @!attribute [rw] workspace
        #   @return [::String]
        #     Required. The workspace's name.
        # @!attribute [rw] path
        #   @return [::String]
        #     Required. The directory's full path including directory name, relative to
        #     the workspace root.
        class RemoveDirectoryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `RemoveDirectory` response message.
        class RemoveDirectoryResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `MoveDirectory` request message.
        # @!attribute [rw] workspace
        #   @return [::String]
        #     Required. The workspace's name.
        # @!attribute [rw] path
        #   @return [::String]
        #     Required. The directory's full path including directory name, relative to
        #     the workspace root.
        # @!attribute [rw] new_path
        #   @return [::String]
        #     Required. The new path for the directory including directory name, rooted
        #     at workspace root.
        class MoveDirectoryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `MoveDirectory` response message.
        class MoveDirectoryResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `ReadFile` request message.
        # @!attribute [rw] workspace
        #   @return [::String]
        #     Required. The workspace's name.
        # @!attribute [rw] path
        #   @return [::String]
        #     Required. The file's full path including filename, relative to the
        #     workspace root.
        # @!attribute [rw] revision
        #   @return [::String]
        #     Optional. The Git revision of the file to return. If left empty, the
        #     current contents of `path` will be returned.
        class ReadFileRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `ReadFile` response message.
        # @!attribute [rw] file_contents
        #   @return [::String]
        #     The file's contents.
        class ReadFileResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `RemoveFile` request message.
        # @!attribute [rw] workspace
        #   @return [::String]
        #     Required. The workspace's name.
        # @!attribute [rw] path
        #   @return [::String]
        #     Required. The file's full path including filename, relative to the
        #     workspace root.
        class RemoveFileRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `RemoveFile` response message.
        class RemoveFileResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `MoveFile` request message.
        # @!attribute [rw] workspace
        #   @return [::String]
        #     Required. The workspace's name.
        # @!attribute [rw] path
        #   @return [::String]
        #     Required. The file's full path including filename, relative to the
        #     workspace root.
        # @!attribute [rw] new_path
        #   @return [::String]
        #     Required. The file's new path including filename, relative to the workspace
        #     root.
        class MoveFileRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `MoveFile` response message.
        class MoveFileResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `WriteFile` request message.
        # @!attribute [rw] workspace
        #   @return [::String]
        #     Required. The workspace's name.
        # @!attribute [rw] path
        #   @return [::String]
        #     Required. The file.
        # @!attribute [rw] contents
        #   @return [::String]
        #     Required. The file's contents.
        class WriteFileRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `WriteFile` response message.
        class WriteFileResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `InstallNpmPackages` request message.
        # @!attribute [rw] workspace
        #   @return [::String]
        #     Required. The workspace's name.
        class InstallNpmPackagesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `InstallNpmPackages` response message.
        class InstallNpmPackagesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a Dataform release configuration.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The release config's name.
        # @!attribute [rw] git_commitish
        #   @return [::String]
        #     Required. Git commit/tag/branch name at which the repository should be
        #     compiled. Must exist in the remote repository. Examples:
        #     - a commit SHA: `12ade345`
        #     - a tag: `tag1`
        #     - a branch name: `branch1`
        # @!attribute [rw] code_compilation_config
        #   @return [::Google::Cloud::Dataform::V1::CodeCompilationConfig]
        #     Optional. If set, fields of `code_compilation_config` override the default
        #     compilation settings that are specified in dataform.json.
        # @!attribute [rw] cron_schedule
        #   @return [::String]
        #     Optional. Optional schedule (in cron format) for automatic creation of
        #     compilation results.
        # @!attribute [rw] time_zone
        #   @return [::String]
        #     Optional. Specifies the time zone to be used when interpreting
        #     cron_schedule. Must be a time zone name from the time zone database
        #     (https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). If left
        #     unspecified, the default is UTC.
        # @!attribute [r] recent_scheduled_release_records
        #   @return [::Array<::Google::Cloud::Dataform::V1::ReleaseConfig::ScheduledReleaseRecord>]
        #     Output only. Records of the 10 most recent scheduled release attempts,
        #     ordered in descending order of `release_time`. Updated whenever automatic
        #     creation of a compilation result is triggered by cron_schedule.
        # @!attribute [rw] release_compilation_result
        #   @return [::String]
        #     Optional. The name of the currently released compilation result for this
        #     release config. This value is updated when a compilation result is
        #     automatically created from this release config (using cron_schedule), or
        #     when this resource is updated by API call (perhaps to roll back to an
        #     earlier release). The compilation result must have been created using this
        #     release config. Must be in the format
        #     `projects/*/locations/*/repositories/*/compilationResults/*`.
        # @!attribute [rw] disabled
        #   @return [::Boolean]
        #     Optional. Disables automatic creation of compilation results.
        # @!attribute [r] internal_metadata
        #   @return [::String]
        #     Output only. All the metadata information that is used internally to serve
        #     the resource. For example: timestamps, flags, status fields, etc. The
        #     format of this field is a JSON string.
        class ReleaseConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A record of an attempt to create a compilation result for this release
          # config.
          # @!attribute [rw] compilation_result
          #   @return [::String]
          #     The name of the created compilation result, if one was successfully
          #     created. Must be in the format
          #     `projects/*/locations/*/repositories/*/compilationResults/*`.
          #
          #     Note: The following fields are mutually exclusive: `compilation_result`, `error_status`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] error_status
          #   @return [::Google::Rpc::Status]
          #     The error status encountered upon this attempt to create the
          #     compilation result, if the attempt was unsuccessful.
          #
          #     Note: The following fields are mutually exclusive: `error_status`, `compilation_result`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [r] release_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The timestamp of this release attempt.
          class ScheduledReleaseRecord
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # `ListReleaseConfigs` request message.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The repository in which to list release configs. Must be in the
        #     format `projects/*/locations/*/repositories/*`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Maximum number of release configs to return. The server may
        #     return fewer items than requested. If unspecified, the server will pick an
        #     appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. Page token received from a previous `ListReleaseConfigs` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListReleaseConfigs`,
        #     with the exception of `page_size`, must match the call that provided the
        #     page token.
        class ListReleaseConfigsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `ListReleaseConfigs` response message.
        # @!attribute [rw] release_configs
        #   @return [::Array<::Google::Cloud::Dataform::V1::ReleaseConfig>]
        #     List of release configs.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations which could not be reached.
        class ListReleaseConfigsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `GetReleaseConfig` request message.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The release config's name.
        class GetReleaseConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `CreateReleaseConfig` request message.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The repository in which to create the release config. Must be in
        #     the format `projects/*/locations/*/repositories/*`.
        # @!attribute [rw] release_config
        #   @return [::Google::Cloud::Dataform::V1::ReleaseConfig]
        #     Required. The release config to create.
        # @!attribute [rw] release_config_id
        #   @return [::String]
        #     Required. The ID to use for the release config, which will become the final
        #     component of the release config's resource name.
        class CreateReleaseConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `UpdateReleaseConfig` request message.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Specifies the fields to be updated in the release config. If left
        #     unset, all fields will be updated.
        # @!attribute [rw] release_config
        #   @return [::Google::Cloud::Dataform::V1::ReleaseConfig]
        #     Required. The release config to update.
        class UpdateReleaseConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `DeleteReleaseConfig` request message.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The release config's name.
        class DeleteReleaseConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the result of compiling a Dataform project.
        # @!attribute [rw] git_commitish
        #   @return [::String]
        #     Immutable. Git commit/tag/branch name at which the repository should be
        #     compiled. Must exist in the remote repository. Examples:
        #     - a commit SHA: `12ade345`
        #     - a tag: `tag1`
        #     - a branch name: `branch1`
        #
        #     Note: The following fields are mutually exclusive: `git_commitish`, `workspace`, `release_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] workspace
        #   @return [::String]
        #     Immutable. The name of the workspace to compile. Must be in the format
        #     `projects/*/locations/*/repositories/*/workspaces/*`.
        #
        #     Note: The following fields are mutually exclusive: `workspace`, `git_commitish`, `release_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] release_config
        #   @return [::String]
        #     Immutable. The name of the release config to compile. Must be in the
        #     format `projects/*/locations/*/repositories/*/releaseConfigs/*`.
        #
        #     Note: The following fields are mutually exclusive: `release_config`, `git_commitish`, `workspace`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The compilation result's name.
        # @!attribute [rw] code_compilation_config
        #   @return [::Google::Cloud::Dataform::V1::CodeCompilationConfig]
        #     Immutable. If set, fields of `code_compilation_config` override the default
        #     compilation settings that are specified in dataform.json.
        # @!attribute [r] resolved_git_commit_sha
        #   @return [::String]
        #     Output only. The fully resolved Git commit SHA of the code that was
        #     compiled. Not set for compilation results whose source is a workspace.
        # @!attribute [r] dataform_core_version
        #   @return [::String]
        #     Output only. The version of `@dataform/core` that was used for compilation.
        # @!attribute [r] compilation_errors
        #   @return [::Array<::Google::Cloud::Dataform::V1::CompilationResult::CompilationError>]
        #     Output only. Errors encountered during project compilation.
        # @!attribute [r] data_encryption_state
        #   @return [::Google::Cloud::Dataform::V1::DataEncryptionState]
        #     Output only. Only set if the repository has a KMS Key.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp of when the compilation result was created.
        # @!attribute [r] internal_metadata
        #   @return [::String]
        #     Output only. All the metadata information that is used internally to serve
        #     the resource. For example: timestamps, flags, status fields, etc. The
        #     format of this field is a JSON string.
        class CompilationResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # An error encountered when attempting to compile a Dataform project.
          # @!attribute [r] message
          #   @return [::String]
          #     Output only. The error's top level message.
          # @!attribute [r] stack
          #   @return [::String]
          #     Output only. The error's full stack trace.
          # @!attribute [r] path
          #   @return [::String]
          #     Output only. The path of the file where this error occurred, if
          #     available, relative to the project root.
          # @!attribute [r] action_target
          #   @return [::Google::Cloud::Dataform::V1::Target]
          #     Output only. The identifier of the action where this error occurred, if
          #     available.
          class CompilationError
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Configures various aspects of Dataform code compilation.
        # @!attribute [rw] default_database
        #   @return [::String]
        #     Optional. The default database (Google Cloud project ID).
        # @!attribute [rw] default_schema
        #   @return [::String]
        #     Optional. The default schema (BigQuery dataset ID).
        # @!attribute [rw] default_location
        #   @return [::String]
        #     Optional. The default BigQuery location to use. Defaults to "US".
        #     See the BigQuery docs for a full list of locations:
        #     https://cloud.google.com/bigquery/docs/locations.
        # @!attribute [rw] assertion_schema
        #   @return [::String]
        #     Optional. The default schema (BigQuery dataset ID) for assertions.
        # @!attribute [rw] vars
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. User-defined variables that are made available to project code
        #     during compilation.
        # @!attribute [rw] database_suffix
        #   @return [::String]
        #     Optional. The suffix that should be appended to all database (Google Cloud
        #     project ID) names.
        # @!attribute [rw] schema_suffix
        #   @return [::String]
        #     Optional. The suffix that should be appended to all schema (BigQuery
        #     dataset ID) names.
        # @!attribute [rw] table_prefix
        #   @return [::String]
        #     Optional. The prefix that should be prepended to all table names.
        # @!attribute [rw] builtin_assertion_name_prefix
        #   @return [::String]
        #     Optional. The prefix to prepend to built-in assertion names.
        # @!attribute [rw] default_notebook_runtime_options
        #   @return [::Google::Cloud::Dataform::V1::NotebookRuntimeOptions]
        #     Optional. The default notebook runtime options.
        class CodeCompilationConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class VarsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Configures various aspects of Dataform notebook runtime.
        # @!attribute [rw] gcs_output_bucket
        #   @return [::String]
        #     Optional. The Google Cloud Storage location to upload the result to.
        #     Format: `gs://bucket-name`.
        # @!attribute [rw] ai_platform_notebook_runtime_template
        #   @return [::String]
        #     Optional. The resource name of the [Colab runtime template]
        #     (https://cloud.google.com/colab/docs/runtimes), from which a runtime is
        #     created for notebook executions. If not specified, a runtime is created
        #     with Colab's default specifications.
        class NotebookRuntimeOptions
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `ListCompilationResults` request message.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The repository in which to list compilation results. Must be in
        #     the format `projects/*/locations/*/repositories/*`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Maximum number of compilation results to return. The server may
        #     return fewer items than requested. If unspecified, the server will pick an
        #     appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. Page token received from a previous `ListCompilationResults`
        #     call. Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListCompilationResults`,
        #     with the exception of `page_size`, must match the call that provided the
        #     page token.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. This field only supports ordering by `name` and `create_time`.
        #     If unspecified, the server will choose the ordering.
        #     If specified, the default order is ascending for the `name` field.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filter for the returned list.
        class ListCompilationResultsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `ListCompilationResults` response message.
        # @!attribute [rw] compilation_results
        #   @return [::Array<::Google::Cloud::Dataform::V1::CompilationResult>]
        #     List of compilation results.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations which could not be reached.
        class ListCompilationResultsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `GetCompilationResult` request message.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The compilation result's name.
        class GetCompilationResultRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `CreateCompilationResult` request message.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The repository in which to create the compilation result. Must be
        #     in the format `projects/*/locations/*/repositories/*`.
        # @!attribute [rw] compilation_result
        #   @return [::Google::Cloud::Dataform::V1::CompilationResult]
        #     Required. The compilation result to create.
        class CreateCompilationResultRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents an action identifier. If the action writes output, the output
        # will be written to the referenced database object.
        # @!attribute [rw] database
        #   @return [::String]
        #     Optional. The action's database (Google Cloud project ID) .
        # @!attribute [rw] schema
        #   @return [::String]
        #     Optional. The action's schema (BigQuery dataset ID), within `database`.
        # @!attribute [rw] name
        #   @return [::String]
        #     Optional. The action's name, within `database` and `schema`.
        class Target
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Describes a relation and its columns.
        # @!attribute [rw] description
        #   @return [::String]
        #     A text description of the relation.
        # @!attribute [rw] columns
        #   @return [::Array<::Google::Cloud::Dataform::V1::RelationDescriptor::ColumnDescriptor>]
        #     A list of descriptions of columns within the relation.
        # @!attribute [rw] bigquery_labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     A set of BigQuery labels that should be applied to the relation.
        class RelationDescriptor
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Describes a column.
          # @!attribute [rw] path
          #   @return [::Array<::String>]
          #     The identifier for the column. Each entry in `path` represents one level
          #     of nesting.
          # @!attribute [rw] description
          #   @return [::String]
          #     A textual description of the column.
          # @!attribute [rw] bigquery_policy_tags
          #   @return [::Array<::String>]
          #     A list of BigQuery policy tags that will be applied to the column.
          class ColumnDescriptor
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class BigqueryLabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Represents a single Dataform action in a compilation result.
        # @!attribute [rw] relation
        #   @return [::Google::Cloud::Dataform::V1::CompilationResultAction::Relation]
        #     The database relation created/updated by this action.
        #
        #     Note: The following fields are mutually exclusive: `relation`, `operations`, `assertion`, `declaration`, `notebook`, `data_preparation`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] operations
        #   @return [::Google::Cloud::Dataform::V1::CompilationResultAction::Operations]
        #     The database operations executed by this action.
        #
        #     Note: The following fields are mutually exclusive: `operations`, `relation`, `assertion`, `declaration`, `notebook`, `data_preparation`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] assertion
        #   @return [::Google::Cloud::Dataform::V1::CompilationResultAction::Assertion]
        #     The assertion executed by this action.
        #
        #     Note: The following fields are mutually exclusive: `assertion`, `relation`, `operations`, `declaration`, `notebook`, `data_preparation`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] declaration
        #   @return [::Google::Cloud::Dataform::V1::CompilationResultAction::Declaration]
        #     The declaration declared by this action.
        #
        #     Note: The following fields are mutually exclusive: `declaration`, `relation`, `operations`, `assertion`, `notebook`, `data_preparation`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] notebook
        #   @return [::Google::Cloud::Dataform::V1::CompilationResultAction::Notebook]
        #     The notebook executed by this action.
        #
        #     Note: The following fields are mutually exclusive: `notebook`, `relation`, `operations`, `assertion`, `declaration`, `data_preparation`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] data_preparation
        #   @return [::Google::Cloud::Dataform::V1::CompilationResultAction::DataPreparation]
        #     The data preparation executed by this action.
        #
        #     Note: The following fields are mutually exclusive: `data_preparation`, `relation`, `operations`, `assertion`, `declaration`, `notebook`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] target
        #   @return [::Google::Cloud::Dataform::V1::Target]
        #     This action's identifier. Unique within the compilation result.
        # @!attribute [rw] canonical_target
        #   @return [::Google::Cloud::Dataform::V1::Target]
        #     The action's identifier if the project had been compiled without any
        #     overrides configured. Unique within the compilation result.
        # @!attribute [rw] file_path
        #   @return [::String]
        #     The full path including filename in which this action is located, relative
        #     to the workspace root.
        # @!attribute [r] internal_metadata
        #   @return [::String]
        #     Output only. All the metadata information that is used internally to serve
        #     the resource. For example: timestamps, flags, status fields, etc. The
        #     format of this field is a JSON string.
        class CompilationResultAction
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Represents a database relation.
          # @!attribute [rw] dependency_targets
          #   @return [::Array<::Google::Cloud::Dataform::V1::Target>]
          #     A list of actions that this action depends on.
          # @!attribute [rw] disabled
          #   @return [::Boolean]
          #     Whether this action is disabled (i.e. should not be run).
          # @!attribute [rw] tags
          #   @return [::Array<::String>]
          #     Arbitrary, user-defined tags on this action.
          # @!attribute [rw] relation_descriptor
          #   @return [::Google::Cloud::Dataform::V1::RelationDescriptor]
          #     Descriptor for the relation and its columns.
          # @!attribute [rw] relation_type
          #   @return [::Google::Cloud::Dataform::V1::CompilationResultAction::Relation::RelationType]
          #     The type of this relation.
          # @!attribute [rw] select_query
          #   @return [::String]
          #     The SELECT query which returns rows which this relation should contain.
          # @!attribute [rw] pre_operations
          #   @return [::Array<::String>]
          #     SQL statements to be executed before creating the relation.
          # @!attribute [rw] post_operations
          #   @return [::Array<::String>]
          #     SQL statements to be executed after creating the relation.
          # @!attribute [rw] incremental_table_config
          #   @return [::Google::Cloud::Dataform::V1::CompilationResultAction::Relation::IncrementalTableConfig]
          #     Configures `INCREMENTAL_TABLE` settings for this relation. Only set if
          #     `relation_type` is `INCREMENTAL_TABLE`.
          # @!attribute [rw] partition_expression
          #   @return [::String]
          #     The SQL expression used to partition the relation.
          # @!attribute [rw] cluster_expressions
          #   @return [::Array<::String>]
          #     A list of columns or SQL expressions used to cluster the table.
          # @!attribute [rw] partition_expiration_days
          #   @return [::Integer]
          #     Sets the partition expiration in days.
          # @!attribute [rw] require_partition_filter
          #   @return [::Boolean]
          #     Specifies whether queries on this table must include a predicate filter
          #     that filters on the partitioning column.
          # @!attribute [rw] additional_options
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Additional options that will be provided as key/value pairs into the
          #     options clause of a create table/view statement. See
          #     https://cloud.google.com/bigquery/docs/reference/standard-sql/data-definition-language
          #     for more information on which options are supported.
          class Relation
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Contains settings for relations of type `INCREMENTAL_TABLE`.
            # @!attribute [rw] incremental_select_query
            #   @return [::String]
            #     The SELECT query which returns rows which should be inserted into the
            #     relation if it already exists and is not being refreshed.
            # @!attribute [rw] refresh_disabled
            #   @return [::Boolean]
            #     Whether this table should be protected from being refreshed.
            # @!attribute [rw] unique_key_parts
            #   @return [::Array<::String>]
            #     A set of columns or SQL expressions used to define row uniqueness.
            #     If any duplicates are discovered (as defined by `unique_key_parts`),
            #     only the newly selected rows (as defined by `incremental_select_query`)
            #     will be included in the relation.
            # @!attribute [rw] update_partition_filter
            #   @return [::String]
            #     A SQL expression conditional used to limit the set of existing rows
            #     considered for a merge operation (see `unique_key_parts` for more
            #     information).
            # @!attribute [rw] incremental_pre_operations
            #   @return [::Array<::String>]
            #     SQL statements to be executed before inserting new rows into the
            #     relation.
            # @!attribute [rw] incremental_post_operations
            #   @return [::Array<::String>]
            #     SQL statements to be executed after inserting new rows into the
            #     relation.
            class IncrementalTableConfig
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class AdditionalOptionsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Indicates the type of this relation.
            module RelationType
              # Default value. This value is unused.
              RELATION_TYPE_UNSPECIFIED = 0

              # The relation is a table.
              TABLE = 1

              # The relation is a view.
              VIEW = 2

              # The relation is an incrementalized table.
              INCREMENTAL_TABLE = 3

              # The relation is a materialized view.
              MATERIALIZED_VIEW = 4
            end
          end

          # Represents a list of arbitrary database operations.
          # @!attribute [rw] dependency_targets
          #   @return [::Array<::Google::Cloud::Dataform::V1::Target>]
          #     A list of actions that this action depends on.
          # @!attribute [rw] disabled
          #   @return [::Boolean]
          #     Whether this action is disabled (i.e. should not be run).
          # @!attribute [rw] tags
          #   @return [::Array<::String>]
          #     Arbitrary, user-defined tags on this action.
          # @!attribute [rw] relation_descriptor
          #   @return [::Google::Cloud::Dataform::V1::RelationDescriptor]
          #     Descriptor for any output relation and its columns. Only set if
          #     `has_output` is true.
          # @!attribute [rw] queries
          #   @return [::Array<::String>]
          #     A list of arbitrary SQL statements that will be executed without
          #     alteration.
          # @!attribute [rw] has_output
          #   @return [::Boolean]
          #     Whether these operations produce an output relation.
          class Operations
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Represents an assertion upon a SQL query which is required return zero
          # rows.
          # @!attribute [rw] dependency_targets
          #   @return [::Array<::Google::Cloud::Dataform::V1::Target>]
          #     A list of actions that this action depends on.
          # @!attribute [rw] parent_action
          #   @return [::Google::Cloud::Dataform::V1::Target]
          #     The parent action of this assertion. Only set if this assertion was
          #     automatically generated.
          # @!attribute [rw] disabled
          #   @return [::Boolean]
          #     Whether this action is disabled (i.e. should not be run).
          # @!attribute [rw] tags
          #   @return [::Array<::String>]
          #     Arbitrary, user-defined tags on this action.
          # @!attribute [rw] select_query
          #   @return [::String]
          #     The SELECT query which must return zero rows in order for this assertion
          #     to succeed.
          # @!attribute [rw] relation_descriptor
          #   @return [::Google::Cloud::Dataform::V1::RelationDescriptor]
          #     Descriptor for the assertion's automatically-generated view and its
          #     columns.
          class Assertion
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Represents a relation which is not managed by Dataform but which may be
          # referenced by Dataform actions.
          # @!attribute [rw] relation_descriptor
          #   @return [::Google::Cloud::Dataform::V1::RelationDescriptor]
          #     Descriptor for the relation and its columns. Used as documentation only,
          #     i.e. values here will result in no changes to the relation's metadata.
          class Declaration
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Represents a notebook.
          # @!attribute [rw] dependency_targets
          #   @return [::Array<::Google::Cloud::Dataform::V1::Target>]
          #     A list of actions that this action depends on.
          # @!attribute [rw] disabled
          #   @return [::Boolean]
          #     Whether this action is disabled (i.e. should not be run).
          # @!attribute [rw] contents
          #   @return [::String]
          #     The contents of the notebook.
          # @!attribute [rw] tags
          #   @return [::Array<::String>]
          #     Arbitrary, user-defined tags on this action.
          class Notebook
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Defines a compiled Data Preparation entity
          # @!attribute [rw] contents_yaml
          #   @return [::String]
          #     The data preparation definition, stored as a YAML string.
          #
          #     Note: The following fields are mutually exclusive: `contents_yaml`, `contents_sql`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] contents_sql
          #   @return [::Google::Cloud::Dataform::V1::CompilationResultAction::DataPreparation::SqlDefinition]
          #     SQL definition for a Data Preparation. Contains a SQL query and
          #     additional context information.
          #
          #     Note: The following fields are mutually exclusive: `contents_sql`, `contents_yaml`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] dependency_targets
          #   @return [::Array<::Google::Cloud::Dataform::V1::Target>]
          #     A list of actions that this action depends on.
          # @!attribute [rw] disabled
          #   @return [::Boolean]
          #     Whether this action is disabled (i.e. should not be run).
          # @!attribute [rw] tags
          #   @return [::Array<::String>]
          #     Arbitrary, user-defined tags on this action.
          class DataPreparation
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Definition of a SQL Data Preparation
            # @!attribute [rw] query
            #   @return [::String]
            #     The SQL query representing the data preparation steps. Formatted as a
            #     Pipe SQL query statement.
            # @!attribute [rw] error_table
            #   @return [::Google::Cloud::Dataform::V1::CompilationResultAction::DataPreparation::ErrorTable]
            #     Error table configuration,
            # @!attribute [rw] load
            #   @return [::Google::Cloud::Dataform::V1::CompilationResultAction::LoadConfig]
            #     Load configuration.
            class SqlDefinition
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Error table information, used to write error data into a BigQuery
            # table.
            # @!attribute [rw] target
            #   @return [::Google::Cloud::Dataform::V1::Target]
            #     Error Table target.
            # @!attribute [rw] retention_days
            #   @return [::Integer]
            #     Error table partition expiration in days. Only positive values are
            #     allowed.
            class ErrorTable
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Simplified load configuration for actions
          # @!attribute [rw] replace
          #   @return [::Google::Cloud::Dataform::V1::CompilationResultAction::SimpleLoadMode]
          #     Replace destination table
          #
          #     Note: The following fields are mutually exclusive: `replace`, `append`, `maximum`, `unique`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] append
          #   @return [::Google::Cloud::Dataform::V1::CompilationResultAction::SimpleLoadMode]
          #     Append into destination table
          #
          #     Note: The following fields are mutually exclusive: `append`, `replace`, `maximum`, `unique`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] maximum
          #   @return [::Google::Cloud::Dataform::V1::CompilationResultAction::IncrementalLoadMode]
          #     Insert records where the value exceeds the previous maximum value for a
          #     column in the destination table
          #
          #     Note: The following fields are mutually exclusive: `maximum`, `replace`, `append`, `unique`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] unique
          #   @return [::Google::Cloud::Dataform::V1::CompilationResultAction::IncrementalLoadMode]
          #     Insert records where the value of a column is not already present in
          #     the destination table
          #
          #     Note: The following fields are mutually exclusive: `unique`, `replace`, `append`, `maximum`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class LoadConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Simple load definition
          class SimpleLoadMode
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Load definition for incremental load modes
          # @!attribute [rw] column
          #   @return [::String]
          #     Column name for incremental load modes
          class IncrementalLoadMode
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # `QueryCompilationResultActions` request message.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The compilation result's name.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Maximum number of compilation results to return. The server may
        #     return fewer items than requested. If unspecified, the server will pick an
        #     appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. Page token received from a previous
        #     `QueryCompilationResultActions` call. Provide this to retrieve the
        #     subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     `QueryCompilationResultActions`, with the exception of `page_size`, must
        #     match the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Optional filter for the returned list. Filtering is only
        #     currently supported on the `file_path` field.
        class QueryCompilationResultActionsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `QueryCompilationResultActions` response message.
        # @!attribute [rw] compilation_result_actions
        #   @return [::Array<::Google::Cloud::Dataform::V1::CompilationResultAction>]
        #     List of compilation result actions.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class QueryCompilationResultActionsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a Dataform workflow configuration.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The workflow config's name.
        # @!attribute [rw] release_config
        #   @return [::String]
        #     Required. The name of the release config whose release_compilation_result
        #     should be executed. Must be in the format
        #     `projects/*/locations/*/repositories/*/releaseConfigs/*`.
        # @!attribute [rw] invocation_config
        #   @return [::Google::Cloud::Dataform::V1::InvocationConfig]
        #     Optional. If left unset, a default InvocationConfig will be used.
        # @!attribute [rw] cron_schedule
        #   @return [::String]
        #     Optional. Optional schedule (in cron format) for automatic execution of
        #     this workflow config.
        # @!attribute [rw] time_zone
        #   @return [::String]
        #     Optional. Specifies the time zone to be used when interpreting
        #     cron_schedule. Must be a time zone name from the time zone database
        #     (https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). If left
        #     unspecified, the default is UTC.
        # @!attribute [r] recent_scheduled_execution_records
        #   @return [::Array<::Google::Cloud::Dataform::V1::WorkflowConfig::ScheduledExecutionRecord>]
        #     Output only. Records of the 10 most recent scheduled execution attempts,
        #     ordered in descending order of `execution_time`. Updated whenever automatic
        #     creation of a workflow invocation is triggered by cron_schedule.
        # @!attribute [rw] disabled
        #   @return [::Boolean]
        #     Optional. Disables automatic creation of workflow invocations.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp of when the WorkflowConfig was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp of when the WorkflowConfig was last updated.
        # @!attribute [r] internal_metadata
        #   @return [::String]
        #     Output only. All the metadata information that is used internally to serve
        #     the resource. For example: timestamps, flags, status fields, etc. The
        #     format of this field is a JSON string.
        class WorkflowConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A record of an attempt to create a workflow invocation for this workflow
          # config.
          # @!attribute [rw] workflow_invocation
          #   @return [::String]
          #     The name of the created workflow invocation, if one was successfully
          #     created. Must be in the format
          #     `projects/*/locations/*/repositories/*/workflowInvocations/*`.
          #
          #     Note: The following fields are mutually exclusive: `workflow_invocation`, `error_status`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] error_status
          #   @return [::Google::Rpc::Status]
          #     The error status encountered upon this attempt to create the
          #     workflow invocation, if the attempt was unsuccessful.
          #
          #     Note: The following fields are mutually exclusive: `error_status`, `workflow_invocation`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [r] execution_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The timestamp of this execution attempt.
          class ScheduledExecutionRecord
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Includes various configuration options for a workflow invocation.
        # If both `included_targets` and `included_tags` are unset, all actions
        # will be included.
        # @!attribute [rw] included_targets
        #   @return [::Array<::Google::Cloud::Dataform::V1::Target>]
        #     Optional. The set of action identifiers to include.
        # @!attribute [rw] included_tags
        #   @return [::Array<::String>]
        #     Optional. The set of tags to include.
        # @!attribute [rw] transitive_dependencies_included
        #   @return [::Boolean]
        #     Optional. When set to true, transitive dependencies of included actions
        #     will be executed.
        # @!attribute [rw] transitive_dependents_included
        #   @return [::Boolean]
        #     Optional. When set to true, transitive dependents of included actions will
        #     be executed.
        # @!attribute [rw] fully_refresh_incremental_tables_enabled
        #   @return [::Boolean]
        #     Optional. When set to true, any incremental tables will be fully refreshed.
        # @!attribute [rw] service_account
        #   @return [::String]
        #     Optional. The service account to run workflow invocations under.
        class InvocationConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `ListWorkflowConfigs` request message.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The repository in which to list workflow configs. Must be in the
        #     format `projects/*/locations/*/repositories/*`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Maximum number of workflow configs to return. The server may
        #     return fewer items than requested. If unspecified, the server will pick an
        #     appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. Page token received from a previous `ListWorkflowConfigs` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListWorkflowConfigs`,
        #     with the exception of `page_size`, must match the call that provided the
        #     page token.
        class ListWorkflowConfigsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `ListWorkflowConfigs` response message.
        # @!attribute [rw] workflow_configs
        #   @return [::Array<::Google::Cloud::Dataform::V1::WorkflowConfig>]
        #     List of workflow configs.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations which could not be reached.
        class ListWorkflowConfigsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `GetWorkflowConfig` request message.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The workflow config's name.
        class GetWorkflowConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `CreateWorkflowConfig` request message.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The repository in which to create the workflow config. Must be in
        #     the format `projects/*/locations/*/repositories/*`.
        # @!attribute [rw] workflow_config
        #   @return [::Google::Cloud::Dataform::V1::WorkflowConfig]
        #     Required. The workflow config to create.
        # @!attribute [rw] workflow_config_id
        #   @return [::String]
        #     Required. The ID to use for the workflow config, which will become the
        #     final component of the workflow config's resource name.
        class CreateWorkflowConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `UpdateWorkflowConfig` request message.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Specifies the fields to be updated in the workflow config. If
        #     left unset, all fields will be updated.
        # @!attribute [rw] workflow_config
        #   @return [::Google::Cloud::Dataform::V1::WorkflowConfig]
        #     Required. The workflow config to update.
        class UpdateWorkflowConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `DeleteWorkflowConfig` request message.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The workflow config's name.
        class DeleteWorkflowConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a single invocation of a compilation result.
        # @!attribute [rw] compilation_result
        #   @return [::String]
        #     Immutable. The name of the compilation result to use for this invocation.
        #     Must be in the format
        #     `projects/*/locations/*/repositories/*/compilationResults/*`.
        #
        #     Note: The following fields are mutually exclusive: `compilation_result`, `workflow_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] workflow_config
        #   @return [::String]
        #     Immutable. The name of the workflow config to invoke. Must be in the
        #     format `projects/*/locations/*/repositories/*/workflowConfigs/*`.
        #
        #     Note: The following fields are mutually exclusive: `workflow_config`, `compilation_result`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The workflow invocation's name.
        # @!attribute [rw] invocation_config
        #   @return [::Google::Cloud::Dataform::V1::InvocationConfig]
        #     Immutable. If left unset, a default InvocationConfig will be used.
        # @!attribute [r] state
        #   @return [::Google::Cloud::Dataform::V1::WorkflowInvocation::State]
        #     Output only. This workflow invocation's current state.
        # @!attribute [r] invocation_timing
        #   @return [::Google::Type::Interval]
        #     Output only. This workflow invocation's timing details.
        # @!attribute [r] resolved_compilation_result
        #   @return [::String]
        #     Output only. The resolved compilation result that was used to create this
        #     invocation. Will be in the format
        #     `projects/*/locations/*/repositories/*/compilationResults/*`.
        # @!attribute [r] data_encryption_state
        #   @return [::Google::Cloud::Dataform::V1::DataEncryptionState]
        #     Output only. Only set if the repository has a KMS Key.
        # @!attribute [r] internal_metadata
        #   @return [::String]
        #     Output only. All the metadata information that is used internally to serve
        #     the resource. For example: timestamps, flags, status fields, etc. The
        #     format of this field is a JSON string.
        class WorkflowInvocation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Represents the current state of a workflow invocation.
          module State
            # Default value. This value is unused.
            STATE_UNSPECIFIED = 0

            # The workflow invocation is currently running.
            RUNNING = 1

            # The workflow invocation succeeded. A terminal state.
            SUCCEEDED = 2

            # The workflow invocation was cancelled. A terminal state.
            CANCELLED = 3

            # The workflow invocation failed. A terminal state.
            FAILED = 4

            # The workflow invocation is being cancelled, but some actions are still
            # running.
            CANCELING = 5
          end
        end

        # `ListWorkflowInvocations` request message.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource of the WorkflowInvocation type. Must be in
        #     the format `projects/*/locations/*/repositories/*`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Maximum number of workflow invocations to return. The server may
        #     return fewer items than requested. If unspecified, the server will pick an
        #     appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. Page token received from a previous `ListWorkflowInvocations`
        #     call. Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     `ListWorkflowInvocations`, with the exception of `page_size`, must match
        #     the call that provided the page token.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. This field only supports ordering by `name`. If unspecified, the
        #     server will choose the ordering. If specified, the default order is
        #     ascending for the `name` field.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filter for the returned list.
        class ListWorkflowInvocationsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `ListWorkflowInvocations` response message.
        # @!attribute [rw] workflow_invocations
        #   @return [::Array<::Google::Cloud::Dataform::V1::WorkflowInvocation>]
        #     List of workflow invocations.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations which could not be reached.
        class ListWorkflowInvocationsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `GetWorkflowInvocation` request message.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The workflow invocation resource's name.
        class GetWorkflowInvocationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `CreateWorkflowInvocation` request message.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The repository in which to create the workflow invocation. Must
        #     be in the format `projects/*/locations/*/repositories/*`.
        # @!attribute [rw] workflow_invocation
        #   @return [::Google::Cloud::Dataform::V1::WorkflowInvocation]
        #     Required. The workflow invocation resource to create.
        class CreateWorkflowInvocationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `DeleteWorkflowInvocation` request message.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The workflow invocation resource's name.
        class DeleteWorkflowInvocationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `CancelWorkflowInvocation` request message.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The workflow invocation resource's name.
        class CancelWorkflowInvocationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `CancelWorkflowInvocation` response message.
        class CancelWorkflowInvocationResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a single action in a workflow invocation.
        # @!attribute [r] bigquery_action
        #   @return [::Google::Cloud::Dataform::V1::WorkflowInvocationAction::BigQueryAction]
        #     Output only. The workflow action's bigquery action details.
        #
        #     Note: The following fields are mutually exclusive: `bigquery_action`, `notebook_action`, `data_preparation_action`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] notebook_action
        #   @return [::Google::Cloud::Dataform::V1::WorkflowInvocationAction::NotebookAction]
        #     Output only. The workflow action's notebook action details.
        #
        #     Note: The following fields are mutually exclusive: `notebook_action`, `bigquery_action`, `data_preparation_action`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] data_preparation_action
        #   @return [::Google::Cloud::Dataform::V1::WorkflowInvocationAction::DataPreparationAction]
        #     Output only. The workflow action's data preparation action details.
        #
        #     Note: The following fields are mutually exclusive: `data_preparation_action`, `bigquery_action`, `notebook_action`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] target
        #   @return [::Google::Cloud::Dataform::V1::Target]
        #     Output only. This action's identifier. Unique within the workflow
        #     invocation.
        # @!attribute [r] canonical_target
        #   @return [::Google::Cloud::Dataform::V1::Target]
        #     Output only. The action's identifier if the project had been compiled
        #     without any overrides configured. Unique within the compilation result.
        # @!attribute [r] state
        #   @return [::Google::Cloud::Dataform::V1::WorkflowInvocationAction::State]
        #     Output only. This action's current state.
        # @!attribute [r] failure_reason
        #   @return [::String]
        #     Output only. If and only if action's state is FAILED a failure reason is
        #     set.
        # @!attribute [r] invocation_timing
        #   @return [::Google::Type::Interval]
        #     Output only. This action's timing details.
        #     `start_time` will be set if the action is in [RUNNING, SUCCEEDED,
        #     CANCELLED, FAILED] state.
        #     `end_time` will be set if the action is in [SUCCEEDED, CANCELLED, FAILED]
        #     state.
        # @!attribute [r] internal_metadata
        #   @return [::String]
        #     Output only. All the metadata information that is used internally to serve
        #     the resource. For example: timestamps, flags, status fields, etc. The
        #     format of this field is a JSON string.
        class WorkflowInvocationAction
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Represents a workflow action that will run against BigQuery.
          # @!attribute [r] sql_script
          #   @return [::String]
          #     Output only. The generated BigQuery SQL script that will be executed.
          # @!attribute [r] job_id
          #   @return [::String]
          #     Output only. The ID of the BigQuery job that executed the SQL in
          #     sql_script. Only set once the job has started to run.
          class BigQueryAction
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Represents a workflow action that will run against a Notebook runtime.
          # @!attribute [r] contents
          #   @return [::String]
          #     Output only. The code contents of a Notebook to be run.
          # @!attribute [r] job_id
          #   @return [::String]
          #     Output only. The ID of the Vertex job that executed the notebook in
          #     contents and also the ID used for the outputs created in Google Cloud
          #     Storage buckets. Only set once the job has started to run.
          class NotebookAction
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Represents a workflow action that will run a Data Preparation.
          # @!attribute [r] contents_yaml
          #   @return [::String]
          #     Output only. YAML representing the contents of the data preparation.
          #     Can be used to show the customer what the input was to their workflow.
          #
          #     Note: The following fields are mutually exclusive: `contents_yaml`, `contents_sql`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] contents_sql
          #   @return [::Google::Cloud::Dataform::V1::WorkflowInvocationAction::DataPreparationAction::ActionSqlDefinition]
          #     SQL definition for a Data Preparation. Contains a SQL query and
          #     additional context information.
          #
          #     Note: The following fields are mutually exclusive: `contents_sql`, `contents_yaml`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [r] generated_sql
          #   @return [::String]
          #     Output only. The generated BigQuery SQL script that will be executed. For
          #     reference only.
          # @!attribute [r] job_id
          #   @return [::String]
          #     Output only. The ID of the BigQuery job that executed the SQL in
          #     sql_script. Only set once the job has started to run.
          class DataPreparationAction
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Definition of a SQL Data Preparation
            # @!attribute [rw] query
            #   @return [::String]
            #     The SQL query representing the data preparation steps. Formatted as a
            #     Pipe SQL query statement.
            # @!attribute [rw] error_table
            #   @return [::Google::Cloud::Dataform::V1::WorkflowInvocationAction::DataPreparationAction::ActionErrorTable]
            #     Error table configuration,
            # @!attribute [rw] load_config
            #   @return [::Google::Cloud::Dataform::V1::WorkflowInvocationAction::DataPreparationAction::ActionLoadConfig]
            #     Load configuration.
            class ActionSqlDefinition
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Error table information, used to write error data into a BigQuery
            # table.
            # @!attribute [rw] target
            #   @return [::Google::Cloud::Dataform::V1::Target]
            #     Error Table target.
            # @!attribute [rw] retention_days
            #   @return [::Integer]
            #     Error table partition expiration in days. Only positive values are
            #     allowed.
            class ActionErrorTable
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Simplified load configuration for actions
            # @!attribute [rw] replace
            #   @return [::Google::Cloud::Dataform::V1::WorkflowInvocationAction::DataPreparationAction::ActionSimpleLoadMode]
            #     Replace destination table
            #
            #     Note: The following fields are mutually exclusive: `replace`, `append`, `maximum`, `unique`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] append
            #   @return [::Google::Cloud::Dataform::V1::WorkflowInvocationAction::DataPreparationAction::ActionSimpleLoadMode]
            #     Append into destination table
            #
            #     Note: The following fields are mutually exclusive: `append`, `replace`, `maximum`, `unique`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] maximum
            #   @return [::Google::Cloud::Dataform::V1::WorkflowInvocationAction::DataPreparationAction::ActionIncrementalLoadMode]
            #     Insert records where the value exceeds the previous maximum value for
            #     a column in the destination table
            #
            #     Note: The following fields are mutually exclusive: `maximum`, `replace`, `append`, `unique`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] unique
            #   @return [::Google::Cloud::Dataform::V1::WorkflowInvocationAction::DataPreparationAction::ActionIncrementalLoadMode]
            #     Insert records where the value of a column is not already present in
            #     the destination table
            #
            #     Note: The following fields are mutually exclusive: `unique`, `replace`, `append`, `maximum`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            class ActionLoadConfig
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Simple load definition
            class ActionSimpleLoadMode
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Load definition for incremental load modes
            # @!attribute [rw] column
            #   @return [::String]
            #     Column name for incremental load modes
            class ActionIncrementalLoadMode
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Represents the current state of a workflow invocation action.
          module State
            # The action has not yet been considered for invocation.
            PENDING = 0

            # The action is currently running.
            RUNNING = 1

            # Execution of the action was skipped because upstream dependencies did not
            # all complete successfully. A terminal state.
            SKIPPED = 2

            # Execution of the action was disabled as per the configuration of the
            # corresponding compilation result action. A terminal state.
            DISABLED = 3

            # The action succeeded. A terminal state.
            SUCCEEDED = 4

            # The action was cancelled. A terminal state.
            CANCELLED = 5

            # The action failed. A terminal state.
            FAILED = 6
          end
        end

        # `QueryWorkflowInvocationActions` request message.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The workflow invocation's name.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Maximum number of workflow invocations to return. The server may
        #     return fewer items than requested. If unspecified, the server will pick an
        #     appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. Page token received from a previous
        #     `QueryWorkflowInvocationActions` call. Provide this to retrieve the
        #     subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     `QueryWorkflowInvocationActions`, with the exception of `page_size`, must
        #     match the call that provided the page token.
        class QueryWorkflowInvocationActionsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `QueryWorkflowInvocationActions` response message.
        # @!attribute [rw] workflow_invocation_actions
        #   @return [::Array<::Google::Cloud::Dataform::V1::WorkflowInvocationAction>]
        #     List of workflow invocation actions.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class QueryWorkflowInvocationActionsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Config for all repositories in a given project and location.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The config name.
        # @!attribute [rw] default_kms_key_name
        #   @return [::String]
        #     Optional. The default KMS key that is used if no encryption key is provided
        #     when a repository is created.
        class Config
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `GetConfig` request message.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The config name.
        class GetConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `UpdateConfig` request message.
        # @!attribute [rw] config
        #   @return [::Google::Cloud::Dataform::V1::Config]
        #     Required. The config to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Specifies the fields to be updated in the config.
        class UpdateConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
