# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Dataform
      module V1
        module Dataform
          # Path helper methods for the Dataform API.
          module Paths
            ##
            # Create a fully-qualified CompilationResult resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/repositories/{repository}/compilationResults/{compilation_result}`
            #
            # @param project [String]
            # @param location [String]
            # @param repository [String]
            # @param compilation_result [String]
            #
            # @return [::String]
            def compilation_result_path project:, location:, repository:, compilation_result:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "repository cannot contain /" if repository.to_s.include? "/"

              "projects/#{project}/locations/#{location}/repositories/#{repository}/compilationResults/#{compilation_result}"
            end

            ##
            # Create a fully-qualified Config resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/config`
            #
            # @param project [String]
            # @param location [String]
            #
            # @return [::String]
            def config_path project:, location:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/locations/#{location}/config"
            end

            ##
            # Create a fully-qualified CryptoKey resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`
            #
            # @param project [String]
            # @param location [String]
            # @param key_ring [String]
            # @param crypto_key [String]
            #
            # @return [::String]
            def crypto_key_path project:, location:, key_ring:, crypto_key:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "key_ring cannot contain /" if key_ring.to_s.include? "/"

              "projects/#{project}/locations/#{location}/keyRings/#{key_ring}/cryptoKeys/#{crypto_key}"
            end

            ##
            # Create a fully-qualified CryptoKeyVersion resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{crypto_key_version}`
            #
            # @param project [String]
            # @param location [String]
            # @param key_ring [String]
            # @param crypto_key [String]
            # @param crypto_key_version [String]
            #
            # @return [::String]
            def crypto_key_version_path project:, location:, key_ring:, crypto_key:, crypto_key_version:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "key_ring cannot contain /" if key_ring.to_s.include? "/"
              raise ::ArgumentError, "crypto_key cannot contain /" if crypto_key.to_s.include? "/"

              "projects/#{project}/locations/#{location}/keyRings/#{key_ring}/cryptoKeys/#{crypto_key}/cryptoKeyVersions/#{crypto_key_version}"
            end

            ##
            # Create a fully-qualified Location resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}`
            #
            # @param project [String]
            # @param location [String]
            #
            # @return [::String]
            def location_path project:, location:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/locations/#{location}"
            end

            ##
            # Create a fully-qualified NotebookRuntimeTemplate resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/notebookRuntimeTemplates/{notebook_runtime_template}`
            #
            # @param project [String]
            # @param location [String]
            # @param notebook_runtime_template [String]
            #
            # @return [::String]
            def notebook_runtime_template_path project:, location:, notebook_runtime_template:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/notebookRuntimeTemplates/#{notebook_runtime_template}"
            end

            ##
            # Create a fully-qualified ReleaseConfig resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/repositories/{repository}/releaseConfigs/{release_config}`
            #
            # @param project [String]
            # @param location [String]
            # @param repository [String]
            # @param release_config [String]
            #
            # @return [::String]
            def release_config_path project:, location:, repository:, release_config:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "repository cannot contain /" if repository.to_s.include? "/"

              "projects/#{project}/locations/#{location}/repositories/#{repository}/releaseConfigs/#{release_config}"
            end

            ##
            # Create a fully-qualified Repository resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/repositories/{repository}`
            #
            # @param project [String]
            # @param location [String]
            # @param repository [String]
            #
            # @return [::String]
            def repository_path project:, location:, repository:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/repositories/#{repository}"
            end

            ##
            # Create a fully-qualified SecretVersion resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/secrets/{secret}/versions/{version}`
            #
            # @param project [String]
            # @param secret [String]
            # @param version [String]
            #
            # @return [::String]
            def secret_version_path project:, secret:, version:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "secret cannot contain /" if secret.to_s.include? "/"

              "projects/#{project}/secrets/#{secret}/versions/#{version}"
            end

            ##
            # Create a fully-qualified WorkflowConfig resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/repositories/{repository}/workflowConfigs/{workflow_config}`
            #
            # @param project [String]
            # @param location [String]
            # @param repository [String]
            # @param workflow_config [String]
            #
            # @return [::String]
            def workflow_config_path project:, location:, repository:, workflow_config:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "repository cannot contain /" if repository.to_s.include? "/"

              "projects/#{project}/locations/#{location}/repositories/#{repository}/workflowConfigs/#{workflow_config}"
            end

            ##
            # Create a fully-qualified WorkflowInvocation resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/repositories/{repository}/workflowInvocations/{workflow_invocation}`
            #
            # @param project [String]
            # @param location [String]
            # @param repository [String]
            # @param workflow_invocation [String]
            #
            # @return [::String]
            def workflow_invocation_path project:, location:, repository:, workflow_invocation:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "repository cannot contain /" if repository.to_s.include? "/"

              "projects/#{project}/locations/#{location}/repositories/#{repository}/workflowInvocations/#{workflow_invocation}"
            end

            ##
            # Create a fully-qualified Workspace resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/repositories/{repository}/workspaces/{workspace}`
            #
            # @param project [String]
            # @param location [String]
            # @param repository [String]
            # @param workspace [String]
            #
            # @return [::String]
            def workspace_path project:, location:, repository:, workspace:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "repository cannot contain /" if repository.to_s.include? "/"

              "projects/#{project}/locations/#{location}/repositories/#{repository}/workspaces/#{workspace}"
            end

            extend self
          end
        end
      end
    end
  end
end
