# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

# Require this file early so that the version constant gets defined before
# requiring "google/cloud". This is because google-cloud-core will load the
# entrypoint (gem name) file, which in turn re-requires this file (hence
# causing a require cycle) unless the version constant is already defined.
require "google/cloud/dataflow/version"

require "googleauth"
gem "google-cloud-core"
require "google/cloud" unless defined? ::Google::Cloud.new
require "google/cloud/config"

# Set the default configuration
::Google::Cloud.configure.add_config! :dataflow do |config|
  config.add_field! :endpoint,      nil, match: ::String
  config.add_field! :credentials,   nil, match: [::String, ::Hash, ::Google::Auth::Credentials]
  config.add_field! :scope,         nil, match: [::Array, ::String]
  config.add_field! :lib_name,      nil, match: ::String
  config.add_field! :lib_version,   nil, match: ::String
  config.add_field! :interceptors,  nil, match: ::Array
  config.add_field! :timeout,       nil, match: ::Numeric
  config.add_field! :metadata,      nil, match: ::Hash
  config.add_field! :retry_policy,  nil, match: [::Hash, ::Proc]
  config.add_field! :quota_project, nil, match: ::String
  config.add_field! :universe_domain, nil, match: ::String
end

module Google
  module Cloud
    module Dataflow
      ##
      # Create a new client object for Snapshots.
      #
      # By default, this returns an instance of
      # [Google::Cloud::Dataflow::V1beta3::Snapshots::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-dataflow-v1beta3/latest/Google-Cloud-Dataflow-V1beta3-Snapshots-Client)
      # for a gRPC client for version V1beta3 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the Snapshots service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the Snapshots service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::Dataflow.snapshots_available?}.
      #
      # ## About Snapshots
      #
      # Provides methods to manage snapshots of Google Cloud Dataflow jobs.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1beta3`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.snapshots version: :v1beta3, transport: :grpc, &block
        require "google/cloud/dataflow/#{version.to_s.downcase}"

        package_name = Google::Cloud::Dataflow
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::Dataflow.const_get(package_name).const_get(:Snapshots)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the Snapshots service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::Dataflow.snapshots}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the Snapshots service,
      # or if the versioned client gem needs an update to support the Snapshots service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1beta3`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.snapshots_available? version: :v1beta3, transport: :grpc
        require "google/cloud/dataflow/#{version.to_s.downcase}"
        package_name = Google::Cloud::Dataflow
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::Dataflow.const_get package_name
        return false unless service_module.const_defined? :Snapshots
        service_module = service_module.const_get :Snapshots
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for Jobs.
      #
      # By default, this returns an instance of
      # [Google::Cloud::Dataflow::V1beta3::Jobs::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-dataflow-v1beta3/latest/Google-Cloud-Dataflow-V1beta3-Jobs-Client)
      # for a gRPC client for version V1beta3 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the Jobs service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the Jobs service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::Dataflow.jobs_available?}.
      #
      # ## About Jobs
      #
      # Provides a method to create and modify Google Cloud Dataflow jobs.
      # A Job is a multi-stage computation graph run by the Cloud Dataflow service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1beta3`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.jobs version: :v1beta3, transport: :grpc, &block
        require "google/cloud/dataflow/#{version.to_s.downcase}"

        package_name = Google::Cloud::Dataflow
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::Dataflow.const_get(package_name).const_get(:Jobs)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the Jobs service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::Dataflow.jobs}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the Jobs service,
      # or if the versioned client gem needs an update to support the Jobs service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1beta3`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.jobs_available? version: :v1beta3, transport: :grpc
        require "google/cloud/dataflow/#{version.to_s.downcase}"
        package_name = Google::Cloud::Dataflow
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::Dataflow.const_get package_name
        return false unless service_module.const_defined? :Jobs
        service_module = service_module.const_get :Jobs
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for Messages.
      #
      # By default, this returns an instance of
      # [Google::Cloud::Dataflow::V1beta3::Messages::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-dataflow-v1beta3/latest/Google-Cloud-Dataflow-V1beta3-Messages-Client)
      # for a gRPC client for version V1beta3 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the Messages service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the Messages service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::Dataflow.messages_available?}.
      #
      # ## About Messages
      #
      # The Dataflow Messages API is used for monitoring the progress of
      # Dataflow jobs.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1beta3`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.messages version: :v1beta3, transport: :grpc, &block
        require "google/cloud/dataflow/#{version.to_s.downcase}"

        package_name = Google::Cloud::Dataflow
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::Dataflow.const_get(package_name).const_get(:Messages)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the Messages service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::Dataflow.messages}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the Messages service,
      # or if the versioned client gem needs an update to support the Messages service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1beta3`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.messages_available? version: :v1beta3, transport: :grpc
        require "google/cloud/dataflow/#{version.to_s.downcase}"
        package_name = Google::Cloud::Dataflow
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::Dataflow.const_get package_name
        return false unless service_module.const_defined? :Messages
        service_module = service_module.const_get :Messages
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for Metrics.
      #
      # By default, this returns an instance of
      # [Google::Cloud::Dataflow::V1beta3::Metrics::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-dataflow-v1beta3/latest/Google-Cloud-Dataflow-V1beta3-Metrics-Client)
      # for a gRPC client for version V1beta3 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the Metrics service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the Metrics service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::Dataflow.metrics_available?}.
      #
      # ## About Metrics
      #
      # The Dataflow Metrics API lets you monitor the progress of Dataflow
      # jobs.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1beta3`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.metrics version: :v1beta3, transport: :grpc, &block
        require "google/cloud/dataflow/#{version.to_s.downcase}"

        package_name = Google::Cloud::Dataflow
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::Dataflow.const_get(package_name).const_get(:Metrics)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the Metrics service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::Dataflow.metrics}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the Metrics service,
      # or if the versioned client gem needs an update to support the Metrics service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1beta3`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.metrics_available? version: :v1beta3, transport: :grpc
        require "google/cloud/dataflow/#{version.to_s.downcase}"
        package_name = Google::Cloud::Dataflow
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::Dataflow.const_get package_name
        return false unless service_module.const_defined? :Metrics
        service_module = service_module.const_get :Metrics
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for TemplatesService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::Dataflow::V1beta3::TemplatesService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-dataflow-v1beta3/latest/Google-Cloud-Dataflow-V1beta3-TemplatesService-Client)
      # for a gRPC client for version V1beta3 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the TemplatesService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the TemplatesService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::Dataflow.templates_service_available?}.
      #
      # ## About TemplatesService
      #
      # Provides a method to create Cloud Dataflow jobs from templates.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1beta3`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.templates_service version: :v1beta3, transport: :grpc, &block
        require "google/cloud/dataflow/#{version.to_s.downcase}"

        package_name = Google::Cloud::Dataflow
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::Dataflow.const_get(package_name).const_get(:TemplatesService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the TemplatesService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::Dataflow.templates_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the TemplatesService service,
      # or if the versioned client gem needs an update to support the TemplatesService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1beta3`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.templates_service_available? version: :v1beta3, transport: :grpc
        require "google/cloud/dataflow/#{version.to_s.downcase}"
        package_name = Google::Cloud::Dataflow
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::Dataflow.const_get package_name
        return false unless service_module.const_defined? :TemplatesService
        service_module = service_module.const_get :TemplatesService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for FlexTemplatesService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::Dataflow::V1beta3::FlexTemplatesService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-dataflow-v1beta3/latest/Google-Cloud-Dataflow-V1beta3-FlexTemplatesService-Client)
      # for a gRPC client for version V1beta3 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the FlexTemplatesService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the FlexTemplatesService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::Dataflow.flex_templates_service_available?}.
      #
      # ## About FlexTemplatesService
      #
      # Provides a service for Flex templates.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1beta3`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.flex_templates_service version: :v1beta3, transport: :grpc, &block
        require "google/cloud/dataflow/#{version.to_s.downcase}"

        package_name = Google::Cloud::Dataflow
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::Dataflow.const_get(package_name).const_get(:FlexTemplatesService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the FlexTemplatesService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::Dataflow.flex_templates_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the FlexTemplatesService service,
      # or if the versioned client gem needs an update to support the FlexTemplatesService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1beta3`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.flex_templates_service_available? version: :v1beta3, transport: :grpc
        require "google/cloud/dataflow/#{version.to_s.downcase}"
        package_name = Google::Cloud::Dataflow
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::Dataflow.const_get package_name
        return false unless service_module.const_defined? :FlexTemplatesService
        service_module = service_module.const_get :FlexTemplatesService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Configure the google-cloud-dataflow library.
      #
      # The following configuration parameters are supported:
      #
      # * `credentials` (*type:* `String, Hash, Google::Auth::Credentials`) -
      #   The path to the keyfile as a String, the contents of the keyfile as a
      #   Hash, or a Google::Auth::Credentials object.
      # * `lib_name` (*type:* `String`) -
      #   The library name as recorded in instrumentation and logging.
      # * `lib_version` (*type:* `String`) -
      #   The library version as recorded in instrumentation and logging.
      # * `interceptors` (*type:* `Array<GRPC::ClientInterceptor>`) -
      #   An array of interceptors that are run before calls are executed.
      # * `timeout` (*type:* `Numeric`) -
      #   Default timeout in seconds.
      # * `metadata` (*type:* `Hash{Symbol=>String}`) -
      #   Additional headers to be sent with the call.
      # * `retry_policy` (*type:* `Hash`) -
      #   The retry policy. The value is a hash with the following keys:
      #     * `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
      #     * `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
      #     * `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
      #     * `:retry_codes` (*type:* `Array<String>`) -
      #       The error codes that should trigger a retry.
      #
      # @return [::Google::Cloud::Config] The default configuration used by this library
      #
      def self.configure
        yield ::Google::Cloud.configure.dataflow if block_given?

        ::Google::Cloud.configure.dataflow
      end
    end
  end
end

helper_path = ::File.join __dir__, "dataflow", "helpers.rb"
require "google/cloud/dataflow/helpers" if ::File.file? helper_path
