# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/dataflow/v1beta3/templates_pb"
require "google/cloud/dataflow/v1beta3/templates_service"

class ::Google::Cloud::Dataflow::V1beta3::TemplatesService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_job_from_template
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataflow::V1beta3::Job.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    project_id = "hello world"
    job_name = "hello world"
    gcs_path = "hello world"
    parameters = {}
    environment = {}
    location = "hello world"

    create_job_from_template_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_job_from_template, name
      assert_kind_of ::Google::Cloud::Dataflow::V1beta3::CreateJobFromTemplateRequest, request
      assert_equal "hello world", request["project_id"]
      assert_equal "hello world", request["job_name"]
      assert_equal "hello world", request["gcs_path"]
      assert_equal :gcs_path, request.template
      assert_equal({}, request["parameters"].to_h)
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Dataflow::V1beta3::RuntimeEnvironment), request["environment"]
      assert_equal "hello world", request["location"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_job_from_template_client_stub do
      # Create client
      client = ::Google::Cloud::Dataflow::V1beta3::TemplatesService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_job_from_template({ project_id: project_id, job_name: job_name, gcs_path: gcs_path, parameters: parameters, environment: environment, location: location }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_job_from_template project_id: project_id, job_name: job_name, gcs_path: gcs_path, parameters: parameters, environment: environment, location: location do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_job_from_template ::Google::Cloud::Dataflow::V1beta3::CreateJobFromTemplateRequest.new(project_id: project_id, job_name: job_name, gcs_path: gcs_path, parameters: parameters, environment: environment, location: location) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_job_from_template({ project_id: project_id, job_name: job_name, gcs_path: gcs_path, parameters: parameters, environment: environment, location: location }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_job_from_template(::Google::Cloud::Dataflow::V1beta3::CreateJobFromTemplateRequest.new(project_id: project_id, job_name: job_name, gcs_path: gcs_path, parameters: parameters, environment: environment, location: location), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_job_from_template_client_stub.call_rpc_count
    end
  end

  def test_launch_template
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataflow::V1beta3::LaunchTemplateResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    project_id = "hello world"
    validate_only = true
    gcs_path = "hello world"
    launch_parameters = {}
    location = "hello world"

    launch_template_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :launch_template, name
      assert_kind_of ::Google::Cloud::Dataflow::V1beta3::LaunchTemplateRequest, request
      assert_equal "hello world", request["project_id"]
      assert_equal true, request["validate_only"]
      assert_equal "hello world", request["gcs_path"]
      assert_equal :gcs_path, request.template
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Dataflow::V1beta3::LaunchTemplateParameters), request["launch_parameters"]
      assert_equal "hello world", request["location"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, launch_template_client_stub do
      # Create client
      client = ::Google::Cloud::Dataflow::V1beta3::TemplatesService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.launch_template({ project_id: project_id, validate_only: validate_only, gcs_path: gcs_path, launch_parameters: launch_parameters, location: location }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.launch_template project_id: project_id, validate_only: validate_only, gcs_path: gcs_path, launch_parameters: launch_parameters, location: location do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.launch_template ::Google::Cloud::Dataflow::V1beta3::LaunchTemplateRequest.new(project_id: project_id, validate_only: validate_only, gcs_path: gcs_path, launch_parameters: launch_parameters, location: location) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.launch_template({ project_id: project_id, validate_only: validate_only, gcs_path: gcs_path, launch_parameters: launch_parameters, location: location }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.launch_template(::Google::Cloud::Dataflow::V1beta3::LaunchTemplateRequest.new(project_id: project_id, validate_only: validate_only, gcs_path: gcs_path, launch_parameters: launch_parameters, location: location), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, launch_template_client_stub.call_rpc_count
    end
  end

  def test_get_template
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataflow::V1beta3::GetTemplateResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    project_id = "hello world"
    gcs_path = "hello world"
    view = :METADATA_ONLY
    location = "hello world"

    get_template_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_template, name
      assert_kind_of ::Google::Cloud::Dataflow::V1beta3::GetTemplateRequest, request
      assert_equal "hello world", request["project_id"]
      assert_equal "hello world", request["gcs_path"]
      assert_equal :gcs_path, request.template
      assert_equal :METADATA_ONLY, request["view"]
      assert_equal "hello world", request["location"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_template_client_stub do
      # Create client
      client = ::Google::Cloud::Dataflow::V1beta3::TemplatesService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_template({ project_id: project_id, gcs_path: gcs_path, view: view, location: location }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_template project_id: project_id, gcs_path: gcs_path, view: view, location: location do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_template ::Google::Cloud::Dataflow::V1beta3::GetTemplateRequest.new(project_id: project_id, gcs_path: gcs_path, view: view, location: location) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_template({ project_id: project_id, gcs_path: gcs_path, view: view, location: location }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_template(::Google::Cloud::Dataflow::V1beta3::GetTemplateRequest.new(project_id: project_id, gcs_path: gcs_path, view: view, location: location), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_template_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Dataflow::V1beta3::TemplatesService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Dataflow::V1beta3::TemplatesService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Dataflow::V1beta3::TemplatesService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::Dataflow::V1beta3::TemplatesService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
