# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/dataflow/v1beta3/metrics_pb"
require "google/cloud/dataflow/v1beta3/metrics"

class ::Google::Cloud::Dataflow::V1beta3::Metrics::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_get_job_metrics
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataflow::V1beta3::JobMetrics.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    project_id = "hello world"
    job_id = "hello world"
    start_time = {}
    location = "hello world"

    get_job_metrics_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_job_metrics, name
      assert_kind_of ::Google::Cloud::Dataflow::V1beta3::GetJobMetricsRequest, request
      assert_equal "hello world", request["project_id"]
      assert_equal "hello world", request["job_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Timestamp), request["start_time"]
      assert_equal "hello world", request["location"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_job_metrics_client_stub do
      # Create client
      client = ::Google::Cloud::Dataflow::V1beta3::Metrics::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_job_metrics({ project_id: project_id, job_id: job_id, start_time: start_time, location: location }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_job_metrics project_id: project_id, job_id: job_id, start_time: start_time, location: location do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_job_metrics ::Google::Cloud::Dataflow::V1beta3::GetJobMetricsRequest.new(project_id: project_id, job_id: job_id, start_time: start_time, location: location) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_job_metrics({ project_id: project_id, job_id: job_id, start_time: start_time, location: location }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_job_metrics(::Google::Cloud::Dataflow::V1beta3::GetJobMetricsRequest.new(project_id: project_id, job_id: job_id, start_time: start_time, location: location), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_job_metrics_client_stub.call_rpc_count
    end
  end

  def test_get_job_execution_details
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataflow::V1beta3::JobExecutionDetails.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    project_id = "hello world"
    job_id = "hello world"
    location = "hello world"
    page_size = 42
    page_token = "hello world"

    get_job_execution_details_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_job_execution_details, name
      assert_kind_of ::Google::Cloud::Dataflow::V1beta3::GetJobExecutionDetailsRequest, request
      assert_equal "hello world", request["project_id"]
      assert_equal "hello world", request["job_id"]
      assert_equal "hello world", request["location"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_job_execution_details_client_stub do
      # Create client
      client = ::Google::Cloud::Dataflow::V1beta3::Metrics::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_job_execution_details({ project_id: project_id, job_id: job_id, location: location, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_job_execution_details project_id: project_id, job_id: job_id, location: location, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_job_execution_details ::Google::Cloud::Dataflow::V1beta3::GetJobExecutionDetailsRequest.new(project_id: project_id, job_id: job_id, location: location, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_job_execution_details({ project_id: project_id, job_id: job_id, location: location, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_job_execution_details(::Google::Cloud::Dataflow::V1beta3::GetJobExecutionDetailsRequest.new(project_id: project_id, job_id: job_id, location: location, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_job_execution_details_client_stub.call_rpc_count
    end
  end

  def test_get_stage_execution_details
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataflow::V1beta3::StageExecutionDetails.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    project_id = "hello world"
    job_id = "hello world"
    location = "hello world"
    stage_id = "hello world"
    page_size = 42
    page_token = "hello world"
    start_time = {}
    end_time = {}

    get_stage_execution_details_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_stage_execution_details, name
      assert_kind_of ::Google::Cloud::Dataflow::V1beta3::GetStageExecutionDetailsRequest, request
      assert_equal "hello world", request["project_id"]
      assert_equal "hello world", request["job_id"]
      assert_equal "hello world", request["location"]
      assert_equal "hello world", request["stage_id"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Timestamp), request["start_time"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Timestamp), request["end_time"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_stage_execution_details_client_stub do
      # Create client
      client = ::Google::Cloud::Dataflow::V1beta3::Metrics::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_stage_execution_details({ project_id: project_id, job_id: job_id, location: location, stage_id: stage_id, page_size: page_size, page_token: page_token, start_time: start_time, end_time: end_time }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_stage_execution_details project_id: project_id, job_id: job_id, location: location, stage_id: stage_id, page_size: page_size, page_token: page_token, start_time: start_time, end_time: end_time do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_stage_execution_details ::Google::Cloud::Dataflow::V1beta3::GetStageExecutionDetailsRequest.new(project_id: project_id, job_id: job_id, location: location, stage_id: stage_id, page_size: page_size, page_token: page_token, start_time: start_time, end_time: end_time) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_stage_execution_details({ project_id: project_id, job_id: job_id, location: location, stage_id: stage_id, page_size: page_size, page_token: page_token, start_time: start_time, end_time: end_time }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_stage_execution_details(::Google::Cloud::Dataflow::V1beta3::GetStageExecutionDetailsRequest.new(project_id: project_id, job_id: job_id, location: location, stage_id: stage_id, page_size: page_size, page_token: page_token, start_time: start_time, end_time: end_time), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_stage_execution_details_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Dataflow::V1beta3::Metrics::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Dataflow::V1beta3::Metrics::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Dataflow::V1beta3::Metrics::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::Dataflow::V1beta3::Metrics::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
