# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/dataflow/v1beta3/jobs_pb"
require "google/cloud/dataflow/v1beta3/jobs"

class ::Google::Cloud::Dataflow::V1beta3::Jobs::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_job
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataflow::V1beta3::Job.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    project_id = "hello world"
    job = {}
    view = :JOB_VIEW_UNKNOWN
    replace_job_id = "hello world"
    location = "hello world"

    create_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_job, name
      assert_kind_of ::Google::Cloud::Dataflow::V1beta3::CreateJobRequest, request
      assert_equal "hello world", request["project_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Dataflow::V1beta3::Job), request["job"]
      assert_equal :JOB_VIEW_UNKNOWN, request["view"]
      assert_equal "hello world", request["replace_job_id"]
      assert_equal "hello world", request["location"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_job_client_stub do
      # Create client
      client = ::Google::Cloud::Dataflow::V1beta3::Jobs::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_job({ project_id: project_id, job: job, view: view, replace_job_id: replace_job_id, location: location }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_job project_id: project_id, job: job, view: view, replace_job_id: replace_job_id, location: location do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_job ::Google::Cloud::Dataflow::V1beta3::CreateJobRequest.new(project_id: project_id, job: job, view: view, replace_job_id: replace_job_id, location: location) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_job({ project_id: project_id, job: job, view: view, replace_job_id: replace_job_id, location: location }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_job(::Google::Cloud::Dataflow::V1beta3::CreateJobRequest.new(project_id: project_id, job: job, view: view, replace_job_id: replace_job_id, location: location), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_job_client_stub.call_rpc_count
    end
  end

  def test_get_job
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataflow::V1beta3::Job.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    project_id = "hello world"
    job_id = "hello world"
    view = :JOB_VIEW_UNKNOWN
    location = "hello world"

    get_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_job, name
      assert_kind_of ::Google::Cloud::Dataflow::V1beta3::GetJobRequest, request
      assert_equal "hello world", request["project_id"]
      assert_equal "hello world", request["job_id"]
      assert_equal :JOB_VIEW_UNKNOWN, request["view"]
      assert_equal "hello world", request["location"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_job_client_stub do
      # Create client
      client = ::Google::Cloud::Dataflow::V1beta3::Jobs::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_job({ project_id: project_id, job_id: job_id, view: view, location: location }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_job project_id: project_id, job_id: job_id, view: view, location: location do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_job ::Google::Cloud::Dataflow::V1beta3::GetJobRequest.new(project_id: project_id, job_id: job_id, view: view, location: location) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_job({ project_id: project_id, job_id: job_id, view: view, location: location }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_job(::Google::Cloud::Dataflow::V1beta3::GetJobRequest.new(project_id: project_id, job_id: job_id, view: view, location: location), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_job_client_stub.call_rpc_count
    end
  end

  def test_update_job
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataflow::V1beta3::Job.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    project_id = "hello world"
    job_id = "hello world"
    job = {}
    location = "hello world"
    update_mask = {}

    update_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_job, name
      assert_kind_of ::Google::Cloud::Dataflow::V1beta3::UpdateJobRequest, request
      assert_equal "hello world", request["project_id"]
      assert_equal "hello world", request["job_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Dataflow::V1beta3::Job), request["job"]
      assert_equal "hello world", request["location"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert request.has_update_mask?
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_job_client_stub do
      # Create client
      client = ::Google::Cloud::Dataflow::V1beta3::Jobs::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_job({ project_id: project_id, job_id: job_id, job: job, location: location, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_job project_id: project_id, job_id: job_id, job: job, location: location, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_job ::Google::Cloud::Dataflow::V1beta3::UpdateJobRequest.new(project_id: project_id, job_id: job_id, job: job, location: location, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_job({ project_id: project_id, job_id: job_id, job: job, location: location, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_job(::Google::Cloud::Dataflow::V1beta3::UpdateJobRequest.new(project_id: project_id, job_id: job_id, job: job, location: location, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_job_client_stub.call_rpc_count
    end
  end

  def test_list_jobs
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataflow::V1beta3::ListJobsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    filter = :UNKNOWN
    project_id = "hello world"
    view = :JOB_VIEW_UNKNOWN
    page_size = 42
    page_token = "hello world"
    location = "hello world"
    name = "hello world"

    list_jobs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_jobs, name
      assert_kind_of ::Google::Cloud::Dataflow::V1beta3::ListJobsRequest, request
      assert_equal :UNKNOWN, request["filter"]
      assert_equal "hello world", request["project_id"]
      assert_equal :JOB_VIEW_UNKNOWN, request["view"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["location"]
      assert_equal "hello world", request["name"]
      assert request.has_name?
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_jobs_client_stub do
      # Create client
      client = ::Google::Cloud::Dataflow::V1beta3::Jobs::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_jobs({ filter: filter, project_id: project_id, view: view, page_size: page_size, page_token: page_token, location: location, name: name }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_jobs filter: filter, project_id: project_id, view: view, page_size: page_size, page_token: page_token, location: location, name: name do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_jobs ::Google::Cloud::Dataflow::V1beta3::ListJobsRequest.new(filter: filter, project_id: project_id, view: view, page_size: page_size, page_token: page_token, location: location, name: name) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_jobs({ filter: filter, project_id: project_id, view: view, page_size: page_size, page_token: page_token, location: location, name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_jobs(::Google::Cloud::Dataflow::V1beta3::ListJobsRequest.new(filter: filter, project_id: project_id, view: view, page_size: page_size, page_token: page_token, location: location, name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_jobs_client_stub.call_rpc_count
    end
  end

  def test_aggregated_list_jobs
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataflow::V1beta3::ListJobsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    filter = :UNKNOWN
    project_id = "hello world"
    view = :JOB_VIEW_UNKNOWN
    page_size = 42
    page_token = "hello world"
    location = "hello world"
    name = "hello world"

    aggregated_list_jobs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :aggregated_list_jobs, name
      assert_kind_of ::Google::Cloud::Dataflow::V1beta3::ListJobsRequest, request
      assert_equal :UNKNOWN, request["filter"]
      assert_equal "hello world", request["project_id"]
      assert_equal :JOB_VIEW_UNKNOWN, request["view"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["location"]
      assert_equal "hello world", request["name"]
      assert request.has_name?
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, aggregated_list_jobs_client_stub do
      # Create client
      client = ::Google::Cloud::Dataflow::V1beta3::Jobs::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.aggregated_list_jobs({ filter: filter, project_id: project_id, view: view, page_size: page_size, page_token: page_token, location: location, name: name }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.aggregated_list_jobs filter: filter, project_id: project_id, view: view, page_size: page_size, page_token: page_token, location: location, name: name do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.aggregated_list_jobs ::Google::Cloud::Dataflow::V1beta3::ListJobsRequest.new(filter: filter, project_id: project_id, view: view, page_size: page_size, page_token: page_token, location: location, name: name) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.aggregated_list_jobs({ filter: filter, project_id: project_id, view: view, page_size: page_size, page_token: page_token, location: location, name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.aggregated_list_jobs(::Google::Cloud::Dataflow::V1beta3::ListJobsRequest.new(filter: filter, project_id: project_id, view: view, page_size: page_size, page_token: page_token, location: location, name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, aggregated_list_jobs_client_stub.call_rpc_count
    end
  end

  def test_check_active_jobs
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataflow::V1beta3::CheckActiveJobsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    project_id = "hello world"

    check_active_jobs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :check_active_jobs, name
      assert_kind_of ::Google::Cloud::Dataflow::V1beta3::CheckActiveJobsRequest, request
      assert_equal "hello world", request["project_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, check_active_jobs_client_stub do
      # Create client
      client = ::Google::Cloud::Dataflow::V1beta3::Jobs::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.check_active_jobs({ project_id: project_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.check_active_jobs project_id: project_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.check_active_jobs ::Google::Cloud::Dataflow::V1beta3::CheckActiveJobsRequest.new(project_id: project_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.check_active_jobs({ project_id: project_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.check_active_jobs(::Google::Cloud::Dataflow::V1beta3::CheckActiveJobsRequest.new(project_id: project_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, check_active_jobs_client_stub.call_rpc_count
    end
  end

  def test_snapshot_job
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataflow::V1beta3::Snapshot.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    project_id = "hello world"
    job_id = "hello world"
    ttl = {}
    location = "hello world"
    snapshot_sources = true
    description = "hello world"

    snapshot_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :snapshot_job, name
      assert_kind_of ::Google::Cloud::Dataflow::V1beta3::SnapshotJobRequest, request
      assert_equal "hello world", request["project_id"]
      assert_equal "hello world", request["job_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Duration), request["ttl"]
      assert_equal "hello world", request["location"]
      assert_equal true, request["snapshot_sources"]
      assert_equal "hello world", request["description"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, snapshot_job_client_stub do
      # Create client
      client = ::Google::Cloud::Dataflow::V1beta3::Jobs::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.snapshot_job({ project_id: project_id, job_id: job_id, ttl: ttl, location: location, snapshot_sources: snapshot_sources, description: description }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.snapshot_job project_id: project_id, job_id: job_id, ttl: ttl, location: location, snapshot_sources: snapshot_sources, description: description do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.snapshot_job ::Google::Cloud::Dataflow::V1beta3::SnapshotJobRequest.new(project_id: project_id, job_id: job_id, ttl: ttl, location: location, snapshot_sources: snapshot_sources, description: description) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.snapshot_job({ project_id: project_id, job_id: job_id, ttl: ttl, location: location, snapshot_sources: snapshot_sources, description: description }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.snapshot_job(::Google::Cloud::Dataflow::V1beta3::SnapshotJobRequest.new(project_id: project_id, job_id: job_id, ttl: ttl, location: location, snapshot_sources: snapshot_sources, description: description), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, snapshot_job_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Dataflow::V1beta3::Jobs::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Dataflow::V1beta3::Jobs::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Dataflow::V1beta3::Jobs::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::Dataflow::V1beta3::Jobs::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
