# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/dataflow/v1beta3/jobs_pb"
require "google/cloud/dataflow/v1beta3/jobs/rest"


class ::Google::Cloud::Dataflow::V1beta3::Jobs::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_job
    # Create test objects.
    client_result = ::Google::Cloud::Dataflow::V1beta3::Job.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project_id = "hello world"
    job = {}
    view = :JOB_VIEW_UNKNOWN
    replace_job_id = "hello world"
    location = "hello world"

    create_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataflow::V1beta3::Jobs::Rest::ServiceStub.stub :transcode_create_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_job_client_stub do
        # Create client
        client = ::Google::Cloud::Dataflow::V1beta3::Jobs::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_job({ project_id: project_id, job: job, view: view, replace_job_id: replace_job_id, location: location }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_job project_id: project_id, job: job, view: view, replace_job_id: replace_job_id, location: location do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_job ::Google::Cloud::Dataflow::V1beta3::CreateJobRequest.new(project_id: project_id, job: job, view: view, replace_job_id: replace_job_id, location: location) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_job({ project_id: project_id, job: job, view: view, replace_job_id: replace_job_id, location: location }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_job(::Google::Cloud::Dataflow::V1beta3::CreateJobRequest.new(project_id: project_id, job: job, view: view, replace_job_id: replace_job_id, location: location), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_job_client_stub.call_count
      end
    end
  end

  def test_get_job
    # Create test objects.
    client_result = ::Google::Cloud::Dataflow::V1beta3::Job.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project_id = "hello world"
    job_id = "hello world"
    view = :JOB_VIEW_UNKNOWN
    location = "hello world"

    get_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataflow::V1beta3::Jobs::Rest::ServiceStub.stub :transcode_get_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_job_client_stub do
        # Create client
        client = ::Google::Cloud::Dataflow::V1beta3::Jobs::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_job({ project_id: project_id, job_id: job_id, view: view, location: location }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_job project_id: project_id, job_id: job_id, view: view, location: location do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_job ::Google::Cloud::Dataflow::V1beta3::GetJobRequest.new(project_id: project_id, job_id: job_id, view: view, location: location) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_job({ project_id: project_id, job_id: job_id, view: view, location: location }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_job(::Google::Cloud::Dataflow::V1beta3::GetJobRequest.new(project_id: project_id, job_id: job_id, view: view, location: location), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_job_client_stub.call_count
      end
    end
  end

  def test_update_job
    # Create test objects.
    client_result = ::Google::Cloud::Dataflow::V1beta3::Job.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project_id = "hello world"
    job_id = "hello world"
    job = {}
    location = "hello world"
    update_mask = {}

    update_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataflow::V1beta3::Jobs::Rest::ServiceStub.stub :transcode_update_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_job_client_stub do
        # Create client
        client = ::Google::Cloud::Dataflow::V1beta3::Jobs::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_job({ project_id: project_id, job_id: job_id, job: job, location: location, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_job project_id: project_id, job_id: job_id, job: job, location: location, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_job ::Google::Cloud::Dataflow::V1beta3::UpdateJobRequest.new(project_id: project_id, job_id: job_id, job: job, location: location, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_job({ project_id: project_id, job_id: job_id, job: job, location: location, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_job(::Google::Cloud::Dataflow::V1beta3::UpdateJobRequest.new(project_id: project_id, job_id: job_id, job: job, location: location, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_job_client_stub.call_count
      end
    end
  end

  def test_list_jobs
    # Create test objects.
    client_result = ::Google::Cloud::Dataflow::V1beta3::ListJobsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    filter = :UNKNOWN
    project_id = "hello world"
    view = :JOB_VIEW_UNKNOWN
    page_size = 42
    page_token = "hello world"
    location = "hello world"
    name = "hello world"

    list_jobs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataflow::V1beta3::Jobs::Rest::ServiceStub.stub :transcode_list_jobs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_jobs_client_stub do
        # Create client
        client = ::Google::Cloud::Dataflow::V1beta3::Jobs::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_jobs({ filter: filter, project_id: project_id, view: view, page_size: page_size, page_token: page_token, location: location, name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_jobs filter: filter, project_id: project_id, view: view, page_size: page_size, page_token: page_token, location: location, name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_jobs ::Google::Cloud::Dataflow::V1beta3::ListJobsRequest.new(filter: filter, project_id: project_id, view: view, page_size: page_size, page_token: page_token, location: location, name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_jobs({ filter: filter, project_id: project_id, view: view, page_size: page_size, page_token: page_token, location: location, name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_jobs(::Google::Cloud::Dataflow::V1beta3::ListJobsRequest.new(filter: filter, project_id: project_id, view: view, page_size: page_size, page_token: page_token, location: location, name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_jobs_client_stub.call_count
      end
    end
  end

  def test_aggregated_list_jobs
    # Create test objects.
    client_result = ::Google::Cloud::Dataflow::V1beta3::ListJobsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    filter = :UNKNOWN
    project_id = "hello world"
    view = :JOB_VIEW_UNKNOWN
    page_size = 42
    page_token = "hello world"
    location = "hello world"
    name = "hello world"

    aggregated_list_jobs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataflow::V1beta3::Jobs::Rest::ServiceStub.stub :transcode_aggregated_list_jobs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, aggregated_list_jobs_client_stub do
        # Create client
        client = ::Google::Cloud::Dataflow::V1beta3::Jobs::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.aggregated_list_jobs({ filter: filter, project_id: project_id, view: view, page_size: page_size, page_token: page_token, location: location, name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.aggregated_list_jobs filter: filter, project_id: project_id, view: view, page_size: page_size, page_token: page_token, location: location, name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.aggregated_list_jobs ::Google::Cloud::Dataflow::V1beta3::ListJobsRequest.new(filter: filter, project_id: project_id, view: view, page_size: page_size, page_token: page_token, location: location, name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.aggregated_list_jobs({ filter: filter, project_id: project_id, view: view, page_size: page_size, page_token: page_token, location: location, name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.aggregated_list_jobs(::Google::Cloud::Dataflow::V1beta3::ListJobsRequest.new(filter: filter, project_id: project_id, view: view, page_size: page_size, page_token: page_token, location: location, name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, aggregated_list_jobs_client_stub.call_count
      end
    end
  end

  def test_snapshot_job
    # Create test objects.
    client_result = ::Google::Cloud::Dataflow::V1beta3::Snapshot.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project_id = "hello world"
    job_id = "hello world"
    ttl = {}
    location = "hello world"
    snapshot_sources = true
    description = "hello world"

    snapshot_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataflow::V1beta3::Jobs::Rest::ServiceStub.stub :transcode_snapshot_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, snapshot_job_client_stub do
        # Create client
        client = ::Google::Cloud::Dataflow::V1beta3::Jobs::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.snapshot_job({ project_id: project_id, job_id: job_id, ttl: ttl, location: location, snapshot_sources: snapshot_sources, description: description }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.snapshot_job project_id: project_id, job_id: job_id, ttl: ttl, location: location, snapshot_sources: snapshot_sources, description: description do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.snapshot_job ::Google::Cloud::Dataflow::V1beta3::SnapshotJobRequest.new(project_id: project_id, job_id: job_id, ttl: ttl, location: location, snapshot_sources: snapshot_sources, description: description) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.snapshot_job({ project_id: project_id, job_id: job_id, ttl: ttl, location: location, snapshot_sources: snapshot_sources, description: description }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.snapshot_job(::Google::Cloud::Dataflow::V1beta3::SnapshotJobRequest.new(project_id: project_id, job_id: job_id, ttl: ttl, location: location, snapshot_sources: snapshot_sources, description: description), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, snapshot_job_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Dataflow::V1beta3::Jobs::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Dataflow::V1beta3::Jobs::Rest::Client::Configuration, config
  end
end
