# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Dataflow
      module V1beta3
        # Represents a Pubsub snapshot.
        # @!attribute [rw] topic_name
        #   @return [::String]
        #     The name of the Pubsub topic.
        # @!attribute [rw] snapshot_name
        #   @return [::String]
        #     The name of the Pubsub snapshot.
        # @!attribute [rw] expire_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The expire time of the Pubsub snapshot.
        class PubsubSnapshotMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a snapshot of a job.
        # @!attribute [rw] id
        #   @return [::String]
        #     The unique ID of this snapshot.
        # @!attribute [rw] project_id
        #   @return [::String]
        #     The project this snapshot belongs to.
        # @!attribute [rw] source_job_id
        #   @return [::String]
        #     The job this snapshot was created from.
        # @!attribute [rw] creation_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time this snapshot was created.
        # @!attribute [rw] ttl
        #   @return [::Google::Protobuf::Duration]
        #     The time after which this snapshot will be automatically deleted.
        # @!attribute [rw] state
        #   @return [::Google::Cloud::Dataflow::V1beta3::SnapshotState]
        #     State of the snapshot.
        # @!attribute [rw] pubsub_metadata
        #   @return [::Array<::Google::Cloud::Dataflow::V1beta3::PubsubSnapshotMetadata>]
        #     Pub/Sub snapshot metadata.
        # @!attribute [rw] description
        #   @return [::String]
        #     User specified description of the snapshot. Maybe empty.
        # @!attribute [rw] disk_size_bytes
        #   @return [::Integer]
        #     The disk byte size of the snapshot. Only available for snapshots in READY
        #     state.
        # @!attribute [rw] region
        #   @return [::String]
        #     Cloud region where this snapshot lives in, e.g., "us-central1".
        class Snapshot
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to get information about a snapshot
        # @!attribute [rw] project_id
        #   @return [::String]
        #     The ID of the Cloud Platform project that the snapshot belongs to.
        # @!attribute [rw] snapshot_id
        #   @return [::String]
        #     The ID of the snapshot.
        # @!attribute [rw] location
        #   @return [::String]
        #     The location that contains this snapshot.
        class GetSnapshotRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to delete a snapshot.
        # @!attribute [rw] project_id
        #   @return [::String]
        #     The ID of the Cloud Platform project that the snapshot belongs to.
        # @!attribute [rw] snapshot_id
        #   @return [::String]
        #     The ID of the snapshot.
        # @!attribute [rw] location
        #   @return [::String]
        #     The location that contains this snapshot.
        class DeleteSnapshotRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response from deleting a snapshot.
        class DeleteSnapshotResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to list snapshots.
        # @!attribute [rw] project_id
        #   @return [::String]
        #     The project ID to list snapshots for.
        # @!attribute [rw] job_id
        #   @return [::String]
        #     If specified, list snapshots created from this job.
        # @!attribute [rw] location
        #   @return [::String]
        #     The location to list snapshots in.
        class ListSnapshotsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # List of snapshots.
        # @!attribute [rw] snapshots
        #   @return [::Array<::Google::Cloud::Dataflow::V1beta3::Snapshot>]
        #     Returned snapshots.
        class ListSnapshotsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Snapshot state.
        module SnapshotState
          # Unknown state.
          UNKNOWN_SNAPSHOT_STATE = 0

          # Snapshot intent to create has been persisted, snapshotting of state has not
          # yet started.
          PENDING = 1

          # Snapshotting is being performed.
          RUNNING = 2

          # Snapshot has been created and is ready to be used.
          READY = 3

          # Snapshot failed to be created.
          FAILED = 4

          # Snapshot has been deleted.
          DELETED = 5
        end
      end
    end
  end
end
