# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Dataflow
      module V1beta3
        # Identifies a metric, by describing the source which generated the
        # metric.
        # @!attribute [rw] origin
        #   @return [::String]
        #     Origin (namespace) of metric name. May be blank for user-define metrics;
        #     will be "dataflow" for metrics defined by the Dataflow service or SDK.
        # @!attribute [rw] name
        #   @return [::String]
        #     Worker-defined metric name.
        # @!attribute [rw] context
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Zero or more labeled fields which identify the part of the job this
        #     metric is associated with, such as the name of a step or collection.
        #
        #     For example, built-in counters associated with steps will have
        #     context['step'] = <step-name>. Counters associated with PCollections
        #     in the SDK will have context['pcollection'] = <pcollection-name>.
        class MetricStructuredName
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class ContextEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Describes the state of a metric.
        # Next ID: 14
        # @!attribute [rw] name
        #   @return [::Google::Cloud::Dataflow::V1beta3::MetricStructuredName]
        #     Name of the metric.
        # @!attribute [rw] kind
        #   @return [::String]
        #     Metric aggregation kind.  The possible metric aggregation kinds are
        #     "Sum", "Max", "Min", "Mean", "Set", "And", "Or", and "Distribution".
        #     The specified aggregation kind is case-insensitive.
        #
        #     If omitted, this is not an aggregated value but instead
        #     a single metric sample value.
        # @!attribute [rw] cumulative
        #   @return [::Boolean]
        #     True if this metric is reported as the total cumulative aggregate
        #     value accumulated since the worker started working on this WorkItem.
        #     By default this is false, indicating that this metric is reported
        #     as a delta that is not associated with any WorkItem.
        # @!attribute [rw] scalar
        #   @return [::Google::Protobuf::Value]
        #     Worker-computed aggregate value for aggregation kinds "Sum", "Max", "Min",
        #     "And", and "Or".  The possible value types are Long, Double, and Boolean.
        # @!attribute [rw] mean_sum
        #   @return [::Google::Protobuf::Value]
        #     Worker-computed aggregate value for the "Mean" aggregation kind.
        #     This holds the sum of the aggregated values and is used in combination
        #     with mean_count below to obtain the actual mean aggregate value.
        #     The only possible value types are Long and Double.
        # @!attribute [rw] mean_count
        #   @return [::Google::Protobuf::Value]
        #     Worker-computed aggregate value for the "Mean" aggregation kind.
        #     This holds the count of the aggregated values and is used in combination
        #     with mean_sum above to obtain the actual mean aggregate value.
        #     The only possible value type is Long.
        # @!attribute [rw] set
        #   @return [::Google::Protobuf::Value]
        #     Worker-computed aggregate value for the "Set" aggregation kind.  The only
        #     possible value type is a list of Values whose type can be Long, Double,
        #     String, or BoundedTrie according to the metric's type.  All Values in the
        #     list must be of the same type.
        # @!attribute [rw] trie
        #   @return [::Google::Protobuf::Value]
        #     Worker-computed aggregate value for the "Trie" aggregation kind.  The only
        #     possible value type is a BoundedTrieNode.
        # @!attribute [rw] distribution
        #   @return [::Google::Protobuf::Value]
        #     A struct value describing properties of a distribution of numeric values.
        # @!attribute [rw] gauge
        #   @return [::Google::Protobuf::Value]
        #     A struct value describing properties of a Gauge.
        #     Metrics of gauge type show the value of a metric across time, and is
        #     aggregated based on the newest value.
        # @!attribute [rw] internal
        #   @return [::Google::Protobuf::Value]
        #     Worker-computed aggregate value for internal use by the Dataflow
        #     service.
        # @!attribute [rw] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Timestamp associated with the metric value. Optional when workers are
        #     reporting work progress; it will be filled in responses from the
        #     metrics API.
        class MetricUpdate
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to get job metrics.
        # @!attribute [rw] project_id
        #   @return [::String]
        #     A project id.
        # @!attribute [rw] job_id
        #   @return [::String]
        #     The job to get metrics for.
        # @!attribute [rw] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Return only metric data that has changed since this time.
        #     Default is to return all information about all metrics for the job.
        # @!attribute [rw] location
        #   @return [::String]
        #     The [regional endpoint]
        #     (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
        #     contains the job specified by job_id.
        class GetJobMetricsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # JobMetrics contains a collection of metrics describing the detailed progress
        # of a Dataflow job. Metrics correspond to user-defined and system-defined
        # metrics in the job. For more information, see [Dataflow job metrics]
        # (https://cloud.google.com/dataflow/docs/guides/using-monitoring-intf).
        #
        # This resource captures only the most recent values of each metric;
        # time-series data can be queried for them (under the same metric names)
        # from Cloud Monitoring.
        # @!attribute [rw] metric_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Timestamp as of which metric values are current.
        # @!attribute [rw] metrics
        #   @return [::Array<::Google::Cloud::Dataflow::V1beta3::MetricUpdate>]
        #     All metrics for this job.
        class JobMetrics
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to get job execution details.
        # @!attribute [rw] project_id
        #   @return [::String]
        #     A project id.
        # @!attribute [rw] job_id
        #   @return [::String]
        #     The job to get execution details for.
        # @!attribute [rw] location
        #   @return [::String]
        #     The [regional endpoint]
        #     (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
        #     contains the job specified by job_id.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     If specified, determines the maximum number of stages to
        #     return.  If unspecified, the service may choose an appropriate
        #     default, or may return an arbitrarily large number of results.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     If supplied, this should be the value of next_page_token returned
        #     by an earlier call. This will cause the next page of results to
        #     be returned.
        class GetJobExecutionDetailsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Information about the progress of some component of job execution.
        # @!attribute [rw] current_progress
        #   @return [::Float]
        #     The current progress of the component, in the range [0,1].
        # @!attribute [rw] data_points
        #   @return [::Array<::Google::Cloud::Dataflow::V1beta3::ProgressTimeseries::Point>]
        #     History of progress for the component.
        #
        #     Points are sorted by time.
        class ProgressTimeseries
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A point in the timeseries.
          # @!attribute [rw] time
          #   @return [::Google::Protobuf::Timestamp]
          #     The timestamp of the point.
          # @!attribute [rw] value
          #   @return [::Float]
          #     The value of the point.
          class Point
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Information useful for straggler identification and debugging.
        # @!attribute [rw] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time when the work item attempt became a straggler.
        # @!attribute [rw] causes
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Dataflow::V1beta3::StragglerInfo::StragglerDebuggingInfo}]
        #     The straggler causes, keyed by the string representation of the
        #     StragglerCause enum and contains specialized debugging information for each
        #     straggler cause.
        class StragglerInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Information useful for debugging a straggler. Each type will provide
          # specialized debugging information relevant for a particular cause.
          # The StragglerDebuggingInfo will be 1:1 mapping to the StragglerCause enum.
          # @!attribute [rw] hot_key
          #   @return [::Google::Cloud::Dataflow::V1beta3::HotKeyDebuggingInfo]
          #     Hot key debugging details.
          class StragglerDebuggingInfo
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::Dataflow::V1beta3::StragglerInfo::StragglerDebuggingInfo]
          class CausesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Information useful for streaming straggler identification and debugging.
        # @!attribute [rw] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Start time of this straggler.
        # @!attribute [rw] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     End time of this straggler.
        # @!attribute [rw] worker_name
        #   @return [::String]
        #     Name of the worker where the straggler was detected.
        # @!attribute [rw] data_watermark_lag
        #   @return [::Google::Protobuf::Duration]
        #     The event-time watermark lag at the time of the straggler detection.
        # @!attribute [rw] system_watermark_lag
        #   @return [::Google::Protobuf::Duration]
        #     The system watermark lag at the time of the straggler detection.
        class StreamingStragglerInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Information for a straggler.
        # @!attribute [rw] batch_straggler
        #   @return [::Google::Cloud::Dataflow::V1beta3::StragglerInfo]
        #     Batch straggler identification and debugging information.
        #
        #     Note: The following fields are mutually exclusive: `batch_straggler`, `streaming_straggler`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] streaming_straggler
        #   @return [::Google::Cloud::Dataflow::V1beta3::StreamingStragglerInfo]
        #     Streaming straggler identification and debugging information.
        #
        #     Note: The following fields are mutually exclusive: `streaming_straggler`, `batch_straggler`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class Straggler
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Information useful for debugging a hot key detection.
        # @!attribute [rw] detected_hot_keys
        #   @return [::Google::Protobuf::Map{::Integer => ::Google::Cloud::Dataflow::V1beta3::HotKeyDebuggingInfo::HotKeyInfo}]
        #     Debugging information for each detected hot key. Keyed by a hash of the
        #     key.
        class HotKeyDebuggingInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Information about a hot key.
          # @!attribute [rw] hot_key_age
          #   @return [::Google::Protobuf::Duration]
          #     The age of the hot key measured from when it was first detected.
          # @!attribute [rw] key
          #   @return [::String]
          #     A detected hot key that is causing limited parallelism. This field will
          #     be populated only if the following flag is set to true:
          #     "--enable_hot_key_logging".
          # @!attribute [rw] key_truncated
          #   @return [::Boolean]
          #     If true, then the above key is truncated and cannot be deserialized. This
          #     occurs if the key above is populated and the key size is >5MB.
          class HotKeyInfo
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::Integer]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::Dataflow::V1beta3::HotKeyDebuggingInfo::HotKeyInfo]
          class DetectedHotKeysEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Summarized straggler identification details.
        # @!attribute [rw] total_straggler_count
        #   @return [::Integer]
        #     The total count of stragglers.
        # @!attribute [rw] straggler_cause_count
        #   @return [::Google::Protobuf::Map{::String => ::Integer}]
        #     Aggregated counts of straggler causes, keyed by the string representation
        #     of the StragglerCause enum.
        # @!attribute [rw] recent_stragglers
        #   @return [::Array<::Google::Cloud::Dataflow::V1beta3::Straggler>]
        #     The most recent stragglers.
        class StragglerSummary
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Integer]
          class StragglerCauseCountEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Information about a particular execution stage of a job.
        # @!attribute [rw] stage_id
        #   @return [::String]
        #     ID of this stage
        # @!attribute [rw] state
        #   @return [::Google::Cloud::Dataflow::V1beta3::ExecutionState]
        #     State of this stage.
        # @!attribute [rw] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Start time of this stage.
        # @!attribute [rw] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     End time of this stage.
        #
        #     If the work item is completed, this is the actual end time of the stage.
        #     Otherwise, it is the predicted end time.
        # @!attribute [rw] progress
        #   @return [::Google::Cloud::Dataflow::V1beta3::ProgressTimeseries]
        #     Progress for this stage.
        #     Only applicable to Batch jobs.
        # @!attribute [rw] metrics
        #   @return [::Array<::Google::Cloud::Dataflow::V1beta3::MetricUpdate>]
        #     Metrics for this stage.
        # @!attribute [rw] straggler_summary
        #   @return [::Google::Cloud::Dataflow::V1beta3::StragglerSummary]
        #     Straggler summary for this stage.
        class StageSummary
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Information about the execution of a job.
        # @!attribute [rw] stages
        #   @return [::Array<::Google::Cloud::Dataflow::V1beta3::StageSummary>]
        #     The stages of the job execution.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     If present, this response does not contain all requested tasks.  To obtain
        #     the next page of results, repeat the request with page_token set to this
        #     value.
        class JobExecutionDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to get information about a particular execution stage of a job.
        # Currently only tracked for Batch jobs.
        # @!attribute [rw] project_id
        #   @return [::String]
        #     A project id.
        # @!attribute [rw] job_id
        #   @return [::String]
        #     The job to get execution details for.
        # @!attribute [rw] location
        #   @return [::String]
        #     The [regional endpoint]
        #     (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
        #     contains the job specified by job_id.
        # @!attribute [rw] stage_id
        #   @return [::String]
        #     The stage for which to fetch information.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     If specified, determines the maximum number of work items to
        #     return.  If unspecified, the service may choose an appropriate
        #     default, or may return an arbitrarily large number of results.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     If supplied, this should be the value of next_page_token returned
        #     by an earlier call. This will cause the next page of results to
        #     be returned.
        # @!attribute [rw] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Lower time bound of work items to include, by start time.
        # @!attribute [rw] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Upper time bound of work items to include, by start time.
        class GetStageExecutionDetailsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Information about an individual work item execution.
        # @!attribute [rw] task_id
        #   @return [::String]
        #     Name of this work item.
        # @!attribute [rw] attempt_id
        #   @return [::String]
        #     Attempt ID of this work item
        # @!attribute [rw] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Start time of this work item attempt.
        # @!attribute [rw] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     End time of this work item attempt.
        #
        #     If the work item is completed, this is the actual end time of the work
        #     item.  Otherwise, it is the predicted end time.
        # @!attribute [rw] state
        #   @return [::Google::Cloud::Dataflow::V1beta3::ExecutionState]
        #     State of this work item.
        # @!attribute [rw] progress
        #   @return [::Google::Cloud::Dataflow::V1beta3::ProgressTimeseries]
        #     Progress of this work item.
        # @!attribute [rw] metrics
        #   @return [::Array<::Google::Cloud::Dataflow::V1beta3::MetricUpdate>]
        #     Metrics for this work item.
        # @!attribute [rw] straggler_info
        #   @return [::Google::Cloud::Dataflow::V1beta3::StragglerInfo]
        #     Information about straggler detections for this work item.
        class WorkItemDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Information about a worker
        # @!attribute [rw] worker_name
        #   @return [::String]
        #     Name of this worker
        # @!attribute [rw] work_items
        #   @return [::Array<::Google::Cloud::Dataflow::V1beta3::WorkItemDetails>]
        #     Work items processed by this worker, sorted by time.
        class WorkerDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Information about the workers and work items within a stage.
        # @!attribute [rw] workers
        #   @return [::Array<::Google::Cloud::Dataflow::V1beta3::WorkerDetails>]
        #     Workers that have done work on the stage.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     If present, this response does not contain all requested tasks.  To obtain
        #     the next page of results, repeat the request with page_token set to this
        #     value.
        class StageExecutionDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The state of some component of job execution.
        module ExecutionState
          # The component state is unknown or unspecified.
          EXECUTION_STATE_UNKNOWN = 0

          # The component is not yet running.
          EXECUTION_STATE_NOT_STARTED = 1

          # The component is currently running.
          EXECUTION_STATE_RUNNING = 2

          # The component succeeded.
          EXECUTION_STATE_SUCCEEDED = 3

          # The component failed.
          EXECUTION_STATE_FAILED = 4

          # Execution of the component was cancelled.
          EXECUTION_STATE_CANCELLED = 5
        end
      end
    end
  end
end
