# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Dataflow
      module V1beta3
        # Defines a job to be run by the Cloud Dataflow service. Do not enter
        # confidential information when you supply string values using the API.
        # @!attribute [rw] id
        #   @return [::String]
        #     The unique ID of this job.
        #
        #     This field is set by the Dataflow service when the job is
        #     created, and is immutable for the life of the job.
        # @!attribute [rw] project_id
        #   @return [::String]
        #     The ID of the Google Cloud project that the job belongs to.
        # @!attribute [rw] name
        #   @return [::String]
        #     Optional. The user-specified Dataflow job name.
        #
        #     Only one active job with a given name can exist in a project within one
        #     region at
        #     any given time. Jobs in different regions can have the same name.
        #     If a caller attempts to create a job with the same
        #     name as an active job that already exists, the attempt returns the
        #     existing job.
        #
        #     The name must match the regular expression
        #     `[a-z]([-a-z0-9]{0,1022}[a-z0-9])?`
        # @!attribute [rw] type
        #   @return [::Google::Cloud::Dataflow::V1beta3::JobType]
        #     Optional. The type of Dataflow job.
        # @!attribute [rw] environment
        #   @return [::Google::Cloud::Dataflow::V1beta3::Environment]
        #     Optional. The environment for the job.
        # @!attribute [rw] steps
        #   @return [::Array<::Google::Cloud::Dataflow::V1beta3::Step>]
        #     Exactly one of step or steps_location should be specified.
        #
        #     The top-level steps that constitute the entire job. Only retrieved with
        #     JOB_VIEW_ALL.
        # @!attribute [rw] steps_location
        #   @return [::String]
        #     The Cloud Storage location where the steps are stored.
        # @!attribute [rw] current_state
        #   @return [::Google::Cloud::Dataflow::V1beta3::JobState]
        #     The current state of the job.
        #
        #     Jobs are created in the `JOB_STATE_STOPPED` state unless otherwise
        #     specified.
        #
        #     A job in the `JOB_STATE_RUNNING` state may asynchronously enter a
        #     terminal state. After a job has reached a terminal state, no
        #     further state updates may be made.
        #
        #     This field might be mutated by the Dataflow service;
        #     callers cannot mutate it.
        # @!attribute [rw] current_state_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The timestamp associated with the current state.
        # @!attribute [rw] requested_state
        #   @return [::Google::Cloud::Dataflow::V1beta3::JobState]
        #     The job's requested state. Applies to `UpdateJob` requests.
        #
        #     Set `requested_state` with `UpdateJob` requests to switch between the
        #     states `JOB_STATE_STOPPED` and `JOB_STATE_RUNNING`. You can also use
        #     `UpdateJob` requests to change a job's
        #     state from `JOB_STATE_RUNNING` to `JOB_STATE_CANCELLED`,
        #     `JOB_STATE_DONE`,  or `JOB_STATE_DRAINED`. These states irrevocably
        #     terminate the job if it hasn't already reached a terminal state.
        #
        #     This field has no effect on `CreateJob` requests.
        # @!attribute [rw] execution_info
        #   @return [::Google::Cloud::Dataflow::V1beta3::JobExecutionInfo]
        #     Deprecated.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The timestamp when the job was initially created. Immutable and set by the
        #     Cloud Dataflow service.
        # @!attribute [rw] replace_job_id
        #   @return [::String]
        #     If this job is an update of an existing job, this field is the job ID
        #     of the job it replaced.
        #
        #     When sending a `CreateJobRequest`, you can update a job by specifying it
        #     here. The job named here is stopped, and its intermediate state is
        #     transferred to this job.
        # @!attribute [rw] transform_name_mapping
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. The map of transform name prefixes of the job to be replaced to
        #     the corresponding name prefixes of the new job.
        # @!attribute [rw] client_request_id
        #   @return [::String]
        #     The client's unique identifier of the job, re-used across retried attempts.
        #     If this field is set, the service will ensure its uniqueness.
        #     The request to create a job will fail if the service has knowledge of a
        #     previously submitted job with the same client's ID and job name.
        #     The caller may use this field to ensure idempotence of job
        #     creation across retried attempts to create a job.
        #     By default, the field is empty and, in that case, the service ignores it.
        # @!attribute [rw] replaced_by_job_id
        #   @return [::String]
        #     If another job is an update of this job (and thus, this job is in
        #     `JOB_STATE_UPDATED`), this field contains the ID of that job.
        # @!attribute [rw] temp_files
        #   @return [::Array<::String>]
        #     A set of files the system should be aware of that are used
        #     for temporary storage. These temporary files will be
        #     removed on job completion.
        #     No duplicates are allowed.
        #     No file patterns are supported.
        #
        #     The supported files are:
        #
        #     Google Cloud Storage:
        #
        #        storage.googleapis.com/\\{bucket}/\\{object}
        #        bucket.storage.googleapis.com/\\{object}
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     User-defined labels for this job.
        #
        #     The labels map can contain no more than 64 entries.  Entries of the labels
        #     map are UTF8 strings that comply with the following restrictions:
        #
        #     * Keys must conform to regexp:  [\p\\{Ll}\p\\{Lo}][\p\\{Ll}\p\\{Lo}\p\\{N}_-]\\{0,62}
        #     * Values must conform to regexp:  [\p\\{Ll}\p\\{Lo}\p\\{N}_-]\\{0,63}
        #     * Both keys and values are additionally constrained to be <= 128 bytes in
        #     size.
        # @!attribute [rw] location
        #   @return [::String]
        #     Optional. The [regional endpoint]
        #     (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
        #     contains this job.
        # @!attribute [rw] pipeline_description
        #   @return [::Google::Cloud::Dataflow::V1beta3::PipelineDescription]
        #     Preliminary field: The format of this data may change at any time.
        #     A description of the user pipeline and stages through which it is executed.
        #     Created by Cloud Dataflow service.  Only retrieved with
        #     JOB_VIEW_DESCRIPTION or JOB_VIEW_ALL.
        # @!attribute [rw] stage_states
        #   @return [::Array<::Google::Cloud::Dataflow::V1beta3::ExecutionStageState>]
        #     This field may be mutated by the Cloud Dataflow service;
        #     callers cannot mutate it.
        # @!attribute [rw] job_metadata
        #   @return [::Google::Cloud::Dataflow::V1beta3::JobMetadata]
        #     This field is populated by the Dataflow service to support filtering jobs
        #     by the metadata values provided here. Populated for ListJobs and all GetJob
        #     views SUMMARY and higher.
        # @!attribute [rw] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The timestamp when the job was started (transitioned to JOB_STATE_PENDING).
        #     Flexible resource scheduling jobs are started with some delay after job
        #     creation, so start_time is unset before start and is updated when the
        #     job is started by the Cloud Dataflow service. For other jobs, start_time
        #     always equals to create_time and is immutable and set by the Cloud Dataflow
        #     service.
        # @!attribute [rw] created_from_snapshot_id
        #   @return [::String]
        #     If this is specified, the job's initial state is populated from the given
        #     snapshot.
        # @!attribute [rw] satisfies_pzs
        #   @return [::Boolean]
        #     Reserved for future use. This field is set only in responses from the
        #     server; it is ignored if it is set in any requests.
        # @!attribute [rw] runtime_updatable_params
        #   @return [::Google::Cloud::Dataflow::V1beta3::RuntimeUpdatableParams]
        #     This field may ONLY be modified at runtime using the projects.jobs.update
        #     method to adjust job behavior. This field has no effect when specified at
        #     job creation.
        # @!attribute [r] satisfies_pzi
        #   @return [::Boolean]
        #     Output only. Reserved for future use. This field is set only in responses
        #     from the server; it is ignored if it is set in any requests.
        # @!attribute [r] service_resources
        #   @return [::Google::Cloud::Dataflow::V1beta3::ServiceResources]
        #     Output only. Resources used by the Dataflow Service to run the job.
        class Job
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class TransformNameMappingEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Resources used by the Dataflow Service to run the job.
        # @!attribute [r] zones
        #   @return [::Array<::String>]
        #     Output only. List of Cloud Zones being used by the Dataflow Service for
        #     this job. Example: us-central1-c
        class ServiceResources
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Additional job parameters that can only be updated during runtime using the
        # projects.jobs.update method. These fields have no effect when specified
        # during job creation.
        # @!attribute [rw] max_num_workers
        #   @return [::Integer]
        #     The maximum number of workers to cap autoscaling at. This field is
        #     currently only supported for Streaming Engine jobs.
        # @!attribute [rw] min_num_workers
        #   @return [::Integer]
        #     The minimum number of workers to scale down to. This field is currently
        #     only supported for Streaming Engine jobs.
        # @!attribute [rw] worker_utilization_hint
        #   @return [::Float]
        #     Target worker utilization, compared against the aggregate utilization of
        #     the worker pool by autoscaler, to determine upscaling and downscaling when
        #     absent other constraints such as backlog.
        #     For more information, see
        #     [Update an existing
        #     pipeline](https://cloud.google.com/dataflow/docs/guides/updating-a-pipeline).
        class RuntimeUpdatableParams
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata for a Datastore connector used by the job.
        # @!attribute [rw] namespace
        #   @return [::String]
        #     Namespace used in the connection.
        # @!attribute [rw] project_id
        #   @return [::String]
        #     ProjectId accessed in the connection.
        class DatastoreIODetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata for a Pub/Sub connector used by the job.
        # @!attribute [rw] topic
        #   @return [::String]
        #     Topic accessed in the connection.
        # @!attribute [rw] subscription
        #   @return [::String]
        #     Subscription used in the connection.
        class PubSubIODetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata for a File connector used by the job.
        # @!attribute [rw] file_pattern
        #   @return [::String]
        #     File Pattern used to access files by the connector.
        class FileIODetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata for a Cloud Bigtable connector used by the job.
        # @!attribute [rw] project_id
        #   @return [::String]
        #     ProjectId accessed in the connection.
        # @!attribute [rw] instance_id
        #   @return [::String]
        #     InstanceId accessed in the connection.
        # @!attribute [rw] table_id
        #   @return [::String]
        #     TableId accessed in the connection.
        class BigTableIODetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata for a BigQuery connector used by the job.
        # @!attribute [rw] table
        #   @return [::String]
        #     Table accessed in the connection.
        # @!attribute [rw] dataset
        #   @return [::String]
        #     Dataset accessed in the connection.
        # @!attribute [rw] project_id
        #   @return [::String]
        #     Project accessed in the connection.
        # @!attribute [rw] query
        #   @return [::String]
        #     Query used to access data in the connection.
        class BigQueryIODetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata for a Spanner connector used by the job.
        # @!attribute [rw] project_id
        #   @return [::String]
        #     ProjectId accessed in the connection.
        # @!attribute [rw] instance_id
        #   @return [::String]
        #     InstanceId accessed in the connection.
        # @!attribute [rw] database_id
        #   @return [::String]
        #     DatabaseId accessed in the connection.
        class SpannerIODetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The version of the SDK used to run the job.
        # @!attribute [rw] version
        #   @return [::String]
        #     The version of the SDK used to run the job.
        # @!attribute [rw] version_display_name
        #   @return [::String]
        #     A readable string describing the version of the SDK.
        # @!attribute [rw] sdk_support_status
        #   @return [::Google::Cloud::Dataflow::V1beta3::SdkVersion::SdkSupportStatus]
        #     The support status for this SDK version.
        # @!attribute [r] bugs
        #   @return [::Array<::Google::Cloud::Dataflow::V1beta3::SdkBug>]
        #     Output only. Known bugs found in this SDK version.
        class SdkVersion
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The support status of the SDK used to run the job.
          module SdkSupportStatus
            # Cloud Dataflow is unaware of this version.
            UNKNOWN = 0

            # This is a known version of an SDK, and is supported.
            SUPPORTED = 1

            # A newer version of the SDK family exists, and an update is recommended.
            STALE = 2

            # This version of the SDK is deprecated and will eventually be
            # unsupported.
            DEPRECATED = 3

            # Support for this SDK version has ended and it should no longer be used.
            UNSUPPORTED = 4
          end
        end

        # A bug found in the Dataflow SDK.
        # @!attribute [r] type
        #   @return [::Google::Cloud::Dataflow::V1beta3::SdkBug::Type]
        #     Output only. Describes the impact of this SDK bug.
        # @!attribute [r] severity
        #   @return [::Google::Cloud::Dataflow::V1beta3::SdkBug::Severity]
        #     Output only. How severe the SDK bug is.
        # @!attribute [r] uri
        #   @return [::String]
        #     Output only. Link to more information on the bug.
        class SdkBug
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Nature of the issue, ordered from least severe to most. Other bug types may
          # be added to this list in the future.
          module Type
            # Unknown issue with this SDK.
            TYPE_UNSPECIFIED = 0

            # Catch-all for SDK bugs that don't fit in the below categories.
            GENERAL = 1

            # Using this version of the SDK may result in degraded performance.
            PERFORMANCE = 2

            # Using this version of the SDK may cause data loss.
            DATALOSS = 3
          end

          # Indicates the severity of the bug. Other severities may be added to this
          # list in the future.
          module Severity
            # A bug of unknown severity.
            SEVERITY_UNSPECIFIED = 0

            # A minor bug that that may reduce reliability or performance for some
            # jobs. Impact will be minimal or non-existent for most jobs.
            NOTICE = 1

            # A bug that has some likelihood of causing performance degradation, data
            # loss, or job failures.
            WARNING = 2

            # A bug with extremely significant impact. Jobs may fail erroneously,
            # performance may be severely degraded, and data loss may be very likely.
            SEVERE = 3
          end
        end

        # Metadata available primarily for filtering jobs. Will be included in the
        # ListJob response and Job SUMMARY view.
        # @!attribute [rw] sdk_version
        #   @return [::Google::Cloud::Dataflow::V1beta3::SdkVersion]
        #     The SDK version used to run the job.
        # @!attribute [rw] spanner_details
        #   @return [::Array<::Google::Cloud::Dataflow::V1beta3::SpannerIODetails>]
        #     Identification of a Spanner source used in the Dataflow job.
        # @!attribute [rw] bigquery_details
        #   @return [::Array<::Google::Cloud::Dataflow::V1beta3::BigQueryIODetails>]
        #     Identification of a BigQuery source used in the Dataflow job.
        # @!attribute [rw] big_table_details
        #   @return [::Array<::Google::Cloud::Dataflow::V1beta3::BigTableIODetails>]
        #     Identification of a Cloud Bigtable source used in the Dataflow job.
        # @!attribute [rw] pubsub_details
        #   @return [::Array<::Google::Cloud::Dataflow::V1beta3::PubSubIODetails>]
        #     Identification of a Pub/Sub source used in the Dataflow job.
        # @!attribute [rw] file_details
        #   @return [::Array<::Google::Cloud::Dataflow::V1beta3::FileIODetails>]
        #     Identification of a File source used in the Dataflow job.
        # @!attribute [rw] datastore_details
        #   @return [::Array<::Google::Cloud::Dataflow::V1beta3::DatastoreIODetails>]
        #     Identification of a Datastore source used in the Dataflow job.
        # @!attribute [rw] user_display_properties
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     List of display properties to help UI filter jobs.
        class JobMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class UserDisplayPropertiesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # A message describing the state of a particular execution stage.
        # @!attribute [rw] execution_stage_name
        #   @return [::String]
        #     The name of the execution stage.
        # @!attribute [rw] execution_stage_state
        #   @return [::Google::Cloud::Dataflow::V1beta3::JobState]
        #     Executions stage states allow the same set of values as JobState.
        # @!attribute [rw] current_state_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time at which the stage transitioned to this state.
        class ExecutionStageState
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A descriptive representation of submitted pipeline as well as the executed
        # form.  This data is provided by the Dataflow service for ease of visualizing
        # the pipeline and interpreting Dataflow provided metrics.
        # @!attribute [rw] original_pipeline_transform
        #   @return [::Array<::Google::Cloud::Dataflow::V1beta3::TransformSummary>]
        #     Description of each transform in the pipeline and collections between them.
        # @!attribute [rw] execution_pipeline_stage
        #   @return [::Array<::Google::Cloud::Dataflow::V1beta3::ExecutionStageSummary>]
        #     Description of each stage of execution of the pipeline.
        # @!attribute [rw] display_data
        #   @return [::Array<::Google::Cloud::Dataflow::V1beta3::DisplayData>]
        #     Pipeline level display data.
        # @!attribute [rw] step_names_hash
        #   @return [::String]
        #     A hash value of the submitted pipeline portable graph step names if exists.
        class PipelineDescription
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Description of the type, names/ids, and input/outputs for a transform.
        # @!attribute [rw] kind
        #   @return [::Google::Cloud::Dataflow::V1beta3::KindType]
        #     Type of transform.
        # @!attribute [rw] id
        #   @return [::String]
        #     SDK generated id of this transform instance.
        # @!attribute [rw] name
        #   @return [::String]
        #     User provided name for this transform instance.
        # @!attribute [rw] display_data
        #   @return [::Array<::Google::Cloud::Dataflow::V1beta3::DisplayData>]
        #     Transform-specific display data.
        # @!attribute [rw] output_collection_name
        #   @return [::Array<::String>]
        #     User  names for all collection outputs to this transform.
        # @!attribute [rw] input_collection_name
        #   @return [::Array<::String>]
        #     User names for all collection inputs to this transform.
        class TransformSummary
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Description of the composing transforms, names/ids, and input/outputs of a
        # stage of execution.  Some composing transforms and sources may have been
        # generated by the Dataflow service during execution planning.
        # @!attribute [rw] name
        #   @return [::String]
        #     Dataflow service generated name for this stage.
        # @!attribute [rw] id
        #   @return [::String]
        #     Dataflow service generated id for this stage.
        # @!attribute [rw] kind
        #   @return [::Google::Cloud::Dataflow::V1beta3::KindType]
        #     Type of transform this stage is executing.
        # @!attribute [rw] input_source
        #   @return [::Array<::Google::Cloud::Dataflow::V1beta3::ExecutionStageSummary::StageSource>]
        #     Input sources for this stage.
        # @!attribute [rw] output_source
        #   @return [::Array<::Google::Cloud::Dataflow::V1beta3::ExecutionStageSummary::StageSource>]
        #     Output sources for this stage.
        # @!attribute [rw] prerequisite_stage
        #   @return [::Array<::String>]
        #     Other stages that must complete before this stage can run.
        # @!attribute [rw] component_transform
        #   @return [::Array<::Google::Cloud::Dataflow::V1beta3::ExecutionStageSummary::ComponentTransform>]
        #     Transforms that comprise this execution stage.
        # @!attribute [rw] component_source
        #   @return [::Array<::Google::Cloud::Dataflow::V1beta3::ExecutionStageSummary::ComponentSource>]
        #     Collections produced and consumed by component transforms of this stage.
        class ExecutionStageSummary
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Description of an input or output of an execution stage.
          # @!attribute [rw] user_name
          #   @return [::String]
          #     Human-readable name for this source; may be user or system generated.
          # @!attribute [rw] name
          #   @return [::String]
          #     Dataflow service generated name for this source.
          # @!attribute [rw] original_transform_or_collection
          #   @return [::String]
          #     User name for the original user transform or collection with which this
          #     source is most closely associated.
          # @!attribute [rw] size_bytes
          #   @return [::Integer]
          #     Size of the source, if measurable.
          class StageSource
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Description of a transform executed as part of an execution stage.
          # @!attribute [rw] user_name
          #   @return [::String]
          #     Human-readable name for this transform; may be user or system generated.
          # @!attribute [rw] name
          #   @return [::String]
          #     Dataflow service generated name for this source.
          # @!attribute [rw] original_transform
          #   @return [::String]
          #     User name for the original user transform with which this transform is
          #     most closely associated.
          class ComponentTransform
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Description of an interstitial value between transforms in an execution
          # stage.
          # @!attribute [rw] user_name
          #   @return [::String]
          #     Human-readable name for this transform; may be user or system generated.
          # @!attribute [rw] name
          #   @return [::String]
          #     Dataflow service generated name for this source.
          # @!attribute [rw] original_transform_or_collection
          #   @return [::String]
          #     User name for the original user transform or collection with which this
          #     source is most closely associated.
          class ComponentSource
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Data provided with a pipeline or transform to provide descriptive info.
        # @!attribute [rw] key
        #   @return [::String]
        #     The key identifying the display data.
        #     This is intended to be used as a label for the display data
        #     when viewed in a dax monitoring system.
        # @!attribute [rw] namespace
        #   @return [::String]
        #     The namespace for the key. This is usually a class name or programming
        #     language namespace (i.e. python module) which defines the display data.
        #     This allows a dax monitoring system to specially handle the data
        #     and perform custom rendering.
        # @!attribute [rw] str_value
        #   @return [::String]
        #     Contains value if the data is of string type.
        #
        #     Note: The following fields are mutually exclusive: `str_value`, `int64_value`, `float_value`, `java_class_value`, `timestamp_value`, `duration_value`, `bool_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] int64_value
        #   @return [::Integer]
        #     Contains value if the data is of int64 type.
        #
        #     Note: The following fields are mutually exclusive: `int64_value`, `str_value`, `float_value`, `java_class_value`, `timestamp_value`, `duration_value`, `bool_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] float_value
        #   @return [::Float]
        #     Contains value if the data is of float type.
        #
        #     Note: The following fields are mutually exclusive: `float_value`, `str_value`, `int64_value`, `java_class_value`, `timestamp_value`, `duration_value`, `bool_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] java_class_value
        #   @return [::String]
        #     Contains value if the data is of java class type.
        #
        #     Note: The following fields are mutually exclusive: `java_class_value`, `str_value`, `int64_value`, `float_value`, `timestamp_value`, `duration_value`, `bool_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] timestamp_value
        #   @return [::Google::Protobuf::Timestamp]
        #     Contains value if the data is of timestamp type.
        #
        #     Note: The following fields are mutually exclusive: `timestamp_value`, `str_value`, `int64_value`, `float_value`, `java_class_value`, `duration_value`, `bool_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] duration_value
        #   @return [::Google::Protobuf::Duration]
        #     Contains value if the data is of duration type.
        #
        #     Note: The following fields are mutually exclusive: `duration_value`, `str_value`, `int64_value`, `float_value`, `java_class_value`, `timestamp_value`, `bool_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] bool_value
        #   @return [::Boolean]
        #     Contains value if the data is of a boolean type.
        #
        #     Note: The following fields are mutually exclusive: `bool_value`, `str_value`, `int64_value`, `float_value`, `java_class_value`, `timestamp_value`, `duration_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] short_str_value
        #   @return [::String]
        #     A possible additional shorter value to display.
        #     For example a java_class_name_value of com.mypackage.MyDoFn
        #     will be stored with MyDoFn as the short_str_value and
        #     com.mypackage.MyDoFn as the java_class_name value.
        #     short_str_value can be displayed and java_class_name_value
        #     will be displayed as a tooltip.
        # @!attribute [rw] url
        #   @return [::String]
        #     An optional full URL.
        # @!attribute [rw] label
        #   @return [::String]
        #     An optional label to display in a dax UI for the element.
        class DisplayData
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Defines a particular step within a Cloud Dataflow job.
        #
        # A job consists of multiple steps, each of which performs some
        # specific operation as part of the overall job.  Data is typically
        # passed from one step to another as part of the job.
        #
        # **Note:** The properties of this object are not stable and might change.
        #
        # Here's an example of a sequence of steps which together implement a
        # Map-Reduce job:
        #
        #   * Read a collection of data from some source, parsing the
        #     collection's elements.
        #
        #   * Validate the elements.
        #
        #   * Apply a user-defined function to map each element to some value
        #     and extract an element-specific key value.
        #
        #   * Group elements with the same key into a single element with
        #     that key, transforming a multiply-keyed collection into a
        #     uniquely-keyed collection.
        #
        #   * Write the elements out to some data sink.
        #
        # Note that the Cloud Dataflow service may be used to run many different
        # types of jobs, not just Map-Reduce.
        # @!attribute [rw] kind
        #   @return [::String]
        #     The kind of step in the Cloud Dataflow job.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name that identifies the step. This must be unique for each
        #     step with respect to all other steps in the Cloud Dataflow job.
        # @!attribute [rw] properties
        #   @return [::Google::Protobuf::Struct]
        #     Named properties associated with the step. Each kind of
        #     predefined step has its own required set of properties.
        #     Must be provided on Create.  Only retrieved with JOB_VIEW_ALL.
        class Step
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Additional information about how a Cloud Dataflow job will be executed that
        # isn't contained in the submitted job.
        # @!attribute [rw] stages
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Dataflow::V1beta3::JobExecutionStageInfo}]
        #     A mapping from each stage to the information about that stage.
        class JobExecutionInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::Dataflow::V1beta3::JobExecutionStageInfo]
          class StagesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Contains information about how a particular
        # {::Google::Cloud::Dataflow::V1beta3::Step google.dataflow.v1beta3.Step} will be
        # executed.
        # @!attribute [rw] step_name
        #   @return [::Array<::String>]
        #     The steps associated with the execution stage.
        #     Note that stages may have several steps, and that a given step
        #     might be run by more than one stage.
        class JobExecutionStageInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to create a Cloud Dataflow job.
        # @!attribute [rw] project_id
        #   @return [::String]
        #     The ID of the Cloud Platform project that the job belongs to.
        # @!attribute [rw] job
        #   @return [::Google::Cloud::Dataflow::V1beta3::Job]
        #     The job to create.
        # @!attribute [rw] view
        #   @return [::Google::Cloud::Dataflow::V1beta3::JobView]
        #     The level of information requested in response.
        # @!attribute [rw] replace_job_id
        #   @return [::String]
        #     Deprecated. This field is now in the Job message.
        # @!attribute [rw] location
        #   @return [::String]
        #     The [regional endpoint]
        #     (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
        #     contains this job.
        class CreateJobRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to get the state of a Cloud Dataflow job.
        # @!attribute [rw] project_id
        #   @return [::String]
        #     The ID of the Cloud Platform project that the job belongs to.
        # @!attribute [rw] job_id
        #   @return [::String]
        #     The job ID.
        # @!attribute [rw] view
        #   @return [::Google::Cloud::Dataflow::V1beta3::JobView]
        #     The level of information requested in response.
        # @!attribute [rw] location
        #   @return [::String]
        #     The [regional endpoint]
        #     (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
        #     contains this job.
        class GetJobRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to update a Cloud Dataflow job.
        # @!attribute [rw] project_id
        #   @return [::String]
        #     The ID of the Cloud Platform project that the job belongs to.
        # @!attribute [rw] job_id
        #   @return [::String]
        #     The job ID.
        # @!attribute [rw] job
        #   @return [::Google::Cloud::Dataflow::V1beta3::Job]
        #     The updated job.
        #     Only the job state is updatable; other fields will be ignored.
        # @!attribute [rw] location
        #   @return [::String]
        #     The [regional endpoint]
        #     (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
        #     contains this job.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The list of fields to update relative to Job. If empty, only
        #     RequestedJobState will be considered for update. If the FieldMask is not
        #     empty and RequestedJobState is none/empty, The fields specified in the
        #     update mask will be the only ones considered for update. If both
        #     RequestedJobState and update_mask are specified, an error will be returned
        #     as we cannot update both state and mask.
        class UpdateJobRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to list Cloud Dataflow jobs.
        # @!attribute [rw] filter
        #   @return [::Google::Cloud::Dataflow::V1beta3::ListJobsRequest::Filter]
        #     The kind of filter to use.
        # @!attribute [rw] project_id
        #   @return [::String]
        #     The project which owns the jobs.
        # @!attribute [rw] view
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Google::Cloud::Dataflow::V1beta3::JobView]
        #     Deprecated. ListJobs always returns summaries now.
        #     Use GetJob for other JobViews.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     If there are many jobs, limit response to at most this many.
        #     The actual number of jobs returned will be the lesser of max_responses
        #     and an unspecified server-defined limit.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Set this to the 'next_page_token' field of a previous response
        #     to request additional results in a long list.
        # @!attribute [rw] location
        #   @return [::String]
        #     The [regional endpoint]
        #     (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
        #     contains this job.
        # @!attribute [rw] name
        #   @return [::String]
        #     Optional. The job name.
        class ListJobsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # This field filters out and returns jobs in the specified job state. The
          # order of data returned is determined by the filter used, and is subject to
          # change.
          module Filter
            # The filter isn't specified, or is unknown. This returns all jobs ordered
            # on descending `JobUuid`.
            UNKNOWN = 0

            # Returns all running jobs first ordered on creation timestamp, then
            # returns all terminated jobs ordered on the termination timestamp.
            ALL = 1

            # Filters the jobs that have a terminated state, ordered on the
            # termination timestamp. Example terminated states: `JOB_STATE_STOPPED`,
            # `JOB_STATE_UPDATED`, `JOB_STATE_DRAINED`, etc.
            TERMINATED = 2

            # Filters the jobs that are running ordered on the creation timestamp.
            ACTIVE = 3
          end
        end

        # Indicates which [regional endpoint]
        # (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) failed
        # to respond to a request for data.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name of the [regional endpoint]
        #     (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
        #     failed to respond.
        class FailedLocation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response to a request to list Cloud Dataflow jobs in a project. This might
        # be a partial response, depending on the page size in the ListJobsRequest.
        # However, if the project does not have any jobs, an instance of
        # ListJobsResponse is not returned and the requests's response
        # body is empty {}.
        # @!attribute [rw] jobs
        #   @return [::Array<::Google::Cloud::Dataflow::V1beta3::Job>]
        #     A subset of the requested job information.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Set if there may be more results than fit in this response.
        # @!attribute [rw] failed_location
        #   @return [::Array<::Google::Cloud::Dataflow::V1beta3::FailedLocation>]
        #     Zero or more messages describing the [regional endpoints]
        #     (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
        #     failed to respond.
        class ListJobsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to create a snapshot of a job.
        # @!attribute [rw] project_id
        #   @return [::String]
        #     The project which owns the job to be snapshotted.
        # @!attribute [rw] job_id
        #   @return [::String]
        #     The job to be snapshotted.
        # @!attribute [rw] ttl
        #   @return [::Google::Protobuf::Duration]
        #     TTL for the snapshot.
        # @!attribute [rw] location
        #   @return [::String]
        #     The location that contains this job.
        # @!attribute [rw] snapshot_sources
        #   @return [::Boolean]
        #     If true, perform snapshots for sources which support this.
        # @!attribute [rw] description
        #   @return [::String]
        #     User specified description of the snapshot. Maybe empty.
        class SnapshotJobRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to check is active jobs exists for a project
        # @!attribute [rw] project_id
        #   @return [::String]
        #     The project which owns the jobs.
        class CheckActiveJobsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for CheckActiveJobsRequest.
        # @!attribute [rw] active_jobs_exist
        #   @return [::Boolean]
        #     If True, active jobs exists for project. False otherwise.
        class CheckActiveJobsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Type of transform or stage operation.
        module KindType
          # Unrecognized transform type.
          UNKNOWN_KIND = 0

          # ParDo transform.
          PAR_DO_KIND = 1

          # Group By Key transform.
          GROUP_BY_KEY_KIND = 2

          # Flatten transform.
          FLATTEN_KIND = 3

          # Read transform.
          READ_KIND = 4

          # Write transform.
          WRITE_KIND = 5

          # Constructs from a constant value, such as with Create.of.
          CONSTANT_KIND = 6

          # Creates a Singleton view of a collection.
          SINGLETON_KIND = 7

          # Opening or closing a shuffle session, often as part of a GroupByKey.
          SHUFFLE_KIND = 8
        end

        # Describes the overall state of a
        # {::Google::Cloud::Dataflow::V1beta3::Job google.dataflow.v1beta3.Job}.
        module JobState
          # The job's run state isn't specified.
          JOB_STATE_UNKNOWN = 0

          # `JOB_STATE_STOPPED` indicates that the job has not
          # yet started to run.
          JOB_STATE_STOPPED = 1

          # `JOB_STATE_RUNNING` indicates that the job is currently running.
          JOB_STATE_RUNNING = 2

          # `JOB_STATE_DONE` indicates that the job has successfully completed.
          # This is a terminal job state.  This state may be set by the Cloud Dataflow
          # service, as a transition from `JOB_STATE_RUNNING`. It may also be set via a
          # Cloud Dataflow `UpdateJob` call, if the job has not yet reached a terminal
          # state.
          JOB_STATE_DONE = 3

          # `JOB_STATE_FAILED` indicates that the job has failed.  This is a
          # terminal job state.  This state may only be set by the Cloud Dataflow
          # service, and only as a transition from `JOB_STATE_RUNNING`.
          JOB_STATE_FAILED = 4

          # `JOB_STATE_CANCELLED` indicates that the job has been explicitly
          # cancelled. This is a terminal job state. This state may only be
          # set via a Cloud Dataflow `UpdateJob` call, and only if the job has not
          # yet reached another terminal state.
          JOB_STATE_CANCELLED = 5

          # `JOB_STATE_UPDATED` indicates that the job was successfully updated,
          # meaning that this job was stopped and another job was started, inheriting
          # state from this one. This is a terminal job state. This state may only be
          # set by the Cloud Dataflow service, and only as a transition from
          # `JOB_STATE_RUNNING`.
          JOB_STATE_UPDATED = 6

          # `JOB_STATE_DRAINING` indicates that the job is in the process of draining.
          # A draining job has stopped pulling from its input sources and is processing
          # any data that remains in-flight. This state may be set via a Cloud Dataflow
          # `UpdateJob` call, but only as a transition from `JOB_STATE_RUNNING`. Jobs
          # that are draining may only transition to `JOB_STATE_DRAINED`,
          # `JOB_STATE_CANCELLED`, or `JOB_STATE_FAILED`.
          JOB_STATE_DRAINING = 7

          # `JOB_STATE_DRAINED` indicates that the job has been drained.
          # A drained job terminated by stopping pulling from its input sources and
          # processing any data that remained in-flight when draining was requested.
          # This state is a terminal state, may only be set by the Cloud Dataflow
          # service, and only as a transition from `JOB_STATE_DRAINING`.
          JOB_STATE_DRAINED = 8

          # `JOB_STATE_PENDING` indicates that the job has been created but is not yet
          # running.  Jobs that are pending may only transition to `JOB_STATE_RUNNING`,
          # or `JOB_STATE_FAILED`.
          JOB_STATE_PENDING = 9

          # `JOB_STATE_CANCELLING` indicates that the job has been explicitly cancelled
          # and is in the process of stopping.  Jobs that are cancelling may only
          # transition to `JOB_STATE_CANCELLED` or `JOB_STATE_FAILED`.
          JOB_STATE_CANCELLING = 10

          # `JOB_STATE_QUEUED` indicates that the job has been created but is being
          # delayed until launch. Jobs that are queued may only transition to
          # `JOB_STATE_PENDING` or `JOB_STATE_CANCELLED`.
          JOB_STATE_QUEUED = 11

          # `JOB_STATE_RESOURCE_CLEANING_UP` indicates that the batch job's associated
          # resources are currently being cleaned up after a successful run.
          # Currently, this is an opt-in feature, please reach out to Cloud support
          # team if you are interested.
          JOB_STATE_RESOURCE_CLEANING_UP = 12
        end

        # Selector for how much information is returned in Job responses.
        module JobView
          # The job view to return isn't specified, or is unknown.
          # Responses will contain at least the `JOB_VIEW_SUMMARY` information,
          # and may contain additional information.
          JOB_VIEW_UNKNOWN = 0

          # Request summary information only:
          # Project ID, Job ID, job name, job type, job status, start/end time,
          # and Cloud SDK version details.
          JOB_VIEW_SUMMARY = 1

          # Request all information available for this job. When the job is in
          # `JOB_STATE_PENDING`, the job has been created but is not yet running, and
          # not all job information is available. For complete
          # job information, wait until the job in is `JOB_STATE_RUNNING`. For more
          # information, see
          # [JobState](https://cloud.google.com/dataflow/docs/reference/rest/v1b3/projects.jobs#jobstate).
          JOB_VIEW_ALL = 2

          # Request summary info and limited job description data for steps, labels and
          # environment.
          JOB_VIEW_DESCRIPTION = 3
        end
      end
    end
  end
end
