# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/dataflow/v1beta3/templates.proto for package 'Google.Cloud.Dataflow.V1beta3'
# Original file comments:
# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/dataflow/v1beta3/templates_pb'

module Google
  module Cloud
    module Dataflow
      module V1beta3
        module TemplatesService
          # Provides a method to create Cloud Dataflow jobs from templates.
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'google.dataflow.v1beta3.TemplatesService'

            # Creates a Cloud Dataflow job from a template. Do not enter confidential
            # information when you supply string values using the API.
            #
            # To create a job, we recommend using `projects.locations.templates.create`
            # with a [regional endpoint]
            # (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using
            # `projects.templates.create` is not recommended, because your job will
            # always start in `us-central1`.
            rpc :CreateJobFromTemplate, ::Google::Cloud::Dataflow::V1beta3::CreateJobFromTemplateRequest, ::Google::Cloud::Dataflow::V1beta3::Job
            # Launches a template.
            #
            # To launch a template, we recommend using
            # `projects.locations.templates.launch` with a [regional endpoint]
            # (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using
            # `projects.templates.launch` is not recommended, because jobs launched
            # from the template will always start in `us-central1`.
            rpc :LaunchTemplate, ::Google::Cloud::Dataflow::V1beta3::LaunchTemplateRequest, ::Google::Cloud::Dataflow::V1beta3::LaunchTemplateResponse
            # Get the template associated with a template.
            #
            # To get the template, we recommend using `projects.locations.templates.get`
            # with a [regional endpoint]
            # (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using
            # `projects.templates.get` is not recommended, because only
            # templates that are running in `us-central1` are retrieved.
            rpc :GetTemplate, ::Google::Cloud::Dataflow::V1beta3::GetTemplateRequest, ::Google::Cloud::Dataflow::V1beta3::GetTemplateResponse
          end

          Stub = Service.rpc_stub_class
        end
        module FlexTemplatesService
          # Provides a service for Flex templates.
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'google.dataflow.v1beta3.FlexTemplatesService'

            # Launch a job with a FlexTemplate.
            rpc :LaunchFlexTemplate, ::Google::Cloud::Dataflow::V1beta3::LaunchFlexTemplateRequest, ::Google::Cloud::Dataflow::V1beta3::LaunchFlexTemplateResponse
          end

          Stub = Service.rpc_stub_class
        end
      end
    end
  end
end
