# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/dataflow/v1beta3/jobs.proto for package 'Google.Cloud.Dataflow.V1beta3'
# Original file comments:
# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/dataflow/v1beta3/jobs_pb'

module Google
  module Cloud
    module Dataflow
      module V1beta3
        module JobsV1Beta3
          # Provides a method to create and modify Google Cloud Dataflow jobs.
          # A Job is a multi-stage computation graph run by the Cloud Dataflow service.
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'google.dataflow.v1beta3.JobsV1Beta3'

            # Creates a Cloud Dataflow job.
            #
            # To create a job, we recommend using `projects.locations.jobs.create` with a
            # [regional endpoint]
            # (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using
            # `projects.jobs.create` is not recommended, as your job will always start
            # in `us-central1`.
            #
            # Do not enter confidential information when you supply string values using
            # the API.
            rpc :CreateJob, ::Google::Cloud::Dataflow::V1beta3::CreateJobRequest, ::Google::Cloud::Dataflow::V1beta3::Job
            # Gets the state of the specified Cloud Dataflow job.
            #
            # To get the state of a job, we recommend using `projects.locations.jobs.get`
            # with a [regional endpoint]
            # (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using
            # `projects.jobs.get` is not recommended, as you can only get the state of
            # jobs that are running in `us-central1`.
            rpc :GetJob, ::Google::Cloud::Dataflow::V1beta3::GetJobRequest, ::Google::Cloud::Dataflow::V1beta3::Job
            # Updates the state of an existing Cloud Dataflow job.
            #
            # To update the state of an existing job, we recommend using
            # `projects.locations.jobs.update` with a [regional endpoint]
            # (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using
            # `projects.jobs.update` is not recommended, as you can only update the state
            # of jobs that are running in `us-central1`.
            rpc :UpdateJob, ::Google::Cloud::Dataflow::V1beta3::UpdateJobRequest, ::Google::Cloud::Dataflow::V1beta3::Job
            # List the jobs of a project.
            #
            # To list the jobs of a project in a region, we recommend using
            # `projects.locations.jobs.list` with a [regional endpoint]
            # (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). To
            # list the all jobs across all regions, use `projects.jobs.aggregated`. Using
            # `projects.jobs.list` is not recommended, because you can only get the list
            # of jobs that are running in `us-central1`.
            #
            # `projects.locations.jobs.list` and `projects.jobs.list` support filtering
            # the list of jobs by name. Filtering by name isn't supported by
            # `projects.jobs.aggregated`.
            rpc :ListJobs, ::Google::Cloud::Dataflow::V1beta3::ListJobsRequest, ::Google::Cloud::Dataflow::V1beta3::ListJobsResponse
            # List the jobs of a project across all regions.
            #
            # **Note:** This method doesn't support filtering the list of
            # jobs by name.
            rpc :AggregatedListJobs, ::Google::Cloud::Dataflow::V1beta3::ListJobsRequest, ::Google::Cloud::Dataflow::V1beta3::ListJobsResponse
            # Check for existence of active jobs in the given project across all regions.
            rpc :CheckActiveJobs, ::Google::Cloud::Dataflow::V1beta3::CheckActiveJobsRequest, ::Google::Cloud::Dataflow::V1beta3::CheckActiveJobsResponse
            # Snapshot the state of a streaming job.
            rpc :SnapshotJob, ::Google::Cloud::Dataflow::V1beta3::SnapshotJobRequest, ::Google::Cloud::Dataflow::V1beta3::Snapshot
          end

          Stub = Service.rpc_stub_class
        end
      end
    end
  end
end
