# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/dataflow/v1beta3/jobs_pb"
require "google/cloud/dataflow/v1beta3/jobs/rest/service_stub"

module Google
  module Cloud
    module Dataflow
      module V1beta3
        module Jobs
          module Rest
            ##
            # REST client for the Jobs service.
            #
            # Provides a method to create and modify Google Cloud Dataflow jobs.
            # A Job is a multi-stage computation graph run by the Cloud Dataflow service.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "dataflow.$UNIVERSE_DOMAIN$"

              # @private
              attr_reader :jobs_stub

              ##
              # Configure the Jobs Client class.
              #
              # See {::Google::Cloud::Dataflow::V1beta3::Jobs::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all Jobs clients
              #   ::Google::Cloud::Dataflow::V1beta3::Jobs::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "Dataflow", "V1beta3"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.timeout = 60.0

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the Jobs Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::Dataflow::V1beta3::Jobs::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @jobs_stub.universe_domain
              end

              ##
              # Create a new Jobs REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::Dataflow::V1beta3::Jobs::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::Dataflow::V1beta3::Jobs::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Jobs client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @jobs_stub = ::Google::Cloud::Dataflow::V1beta3::Jobs::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @jobs_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end
              end

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @jobs_stub.logger
              end

              # Service calls

              ##
              # Creates a Cloud Dataflow job.
              #
              # To create a job, we recommend using `projects.locations.jobs.create` with a
              # [regional endpoint]
              # (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using
              # `projects.jobs.create` is not recommended, as your job will always start
              # in `us-central1`.
              #
              # Do not enter confidential information when you supply string values using
              # the API.
              #
              # @overload create_job(request, options = nil)
              #   Pass arguments to `create_job` via a request object, either of type
              #   {::Google::Cloud::Dataflow::V1beta3::CreateJobRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataflow::V1beta3::CreateJobRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_job(project_id: nil, job: nil, view: nil, replace_job_id: nil, location: nil)
              #   Pass arguments to `create_job` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param project_id [::String]
              #     The ID of the Cloud Platform project that the job belongs to.
              #   @param job [::Google::Cloud::Dataflow::V1beta3::Job, ::Hash]
              #     The job to create.
              #   @param view [::Google::Cloud::Dataflow::V1beta3::JobView]
              #     The level of information requested in response.
              #   @param replace_job_id [::String]
              #     Deprecated. This field is now in the Job message.
              #   @param location [::String]
              #     The [regional endpoint]
              #     (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
              #     contains this job.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dataflow::V1beta3::Job]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dataflow::V1beta3::Job]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataflow/v1beta3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataflow::V1beta3::Jobs::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataflow::V1beta3::CreateJobRequest.new
              #
              #   # Call the create_job method.
              #   result = client.create_job request
              #
              #   # The returned object is of type Google::Cloud::Dataflow::V1beta3::Job.
              #   p result
              #
              def create_job request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataflow::V1beta3::CreateJobRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_job.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataflow::V1beta3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_job.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_job.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @jobs_stub.create_job request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the state of the specified Cloud Dataflow job.
              #
              # To get the state of a job, we recommend using `projects.locations.jobs.get`
              # with a [regional endpoint]
              # (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using
              # `projects.jobs.get` is not recommended, as you can only get the state of
              # jobs that are running in `us-central1`.
              #
              # @overload get_job(request, options = nil)
              #   Pass arguments to `get_job` via a request object, either of type
              #   {::Google::Cloud::Dataflow::V1beta3::GetJobRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataflow::V1beta3::GetJobRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_job(project_id: nil, job_id: nil, view: nil, location: nil)
              #   Pass arguments to `get_job` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param project_id [::String]
              #     The ID of the Cloud Platform project that the job belongs to.
              #   @param job_id [::String]
              #     The job ID.
              #   @param view [::Google::Cloud::Dataflow::V1beta3::JobView]
              #     The level of information requested in response.
              #   @param location [::String]
              #     The [regional endpoint]
              #     (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
              #     contains this job.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dataflow::V1beta3::Job]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dataflow::V1beta3::Job]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataflow/v1beta3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataflow::V1beta3::Jobs::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataflow::V1beta3::GetJobRequest.new
              #
              #   # Call the get_job method.
              #   result = client.get_job request
              #
              #   # The returned object is of type Google::Cloud::Dataflow::V1beta3::Job.
              #   p result
              #
              def get_job request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataflow::V1beta3::GetJobRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_job.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataflow::V1beta3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_job.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_job.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @jobs_stub.get_job request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the state of an existing Cloud Dataflow job.
              #
              # To update the state of an existing job, we recommend using
              # `projects.locations.jobs.update` with a [regional endpoint]
              # (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using
              # `projects.jobs.update` is not recommended, as you can only update the state
              # of jobs that are running in `us-central1`.
              #
              # @overload update_job(request, options = nil)
              #   Pass arguments to `update_job` via a request object, either of type
              #   {::Google::Cloud::Dataflow::V1beta3::UpdateJobRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataflow::V1beta3::UpdateJobRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_job(project_id: nil, job_id: nil, job: nil, location: nil, update_mask: nil)
              #   Pass arguments to `update_job` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param project_id [::String]
              #     The ID of the Cloud Platform project that the job belongs to.
              #   @param job_id [::String]
              #     The job ID.
              #   @param job [::Google::Cloud::Dataflow::V1beta3::Job, ::Hash]
              #     The updated job.
              #     Only the job state is updatable; other fields will be ignored.
              #   @param location [::String]
              #     The [regional endpoint]
              #     (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
              #     contains this job.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     The list of fields to update relative to Job. If empty, only
              #     RequestedJobState will be considered for update. If the FieldMask is not
              #     empty and RequestedJobState is none/empty, The fields specified in the
              #     update mask will be the only ones considered for update. If both
              #     RequestedJobState and update_mask are specified, an error will be returned
              #     as we cannot update both state and mask.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dataflow::V1beta3::Job]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dataflow::V1beta3::Job]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataflow/v1beta3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataflow::V1beta3::Jobs::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataflow::V1beta3::UpdateJobRequest.new
              #
              #   # Call the update_job method.
              #   result = client.update_job request
              #
              #   # The returned object is of type Google::Cloud::Dataflow::V1beta3::Job.
              #   p result
              #
              def update_job request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataflow::V1beta3::UpdateJobRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_job.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataflow::V1beta3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_job.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_job.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @jobs_stub.update_job request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # List the jobs of a project.
              #
              # To list the jobs of a project in a region, we recommend using
              # `projects.locations.jobs.list` with a [regional endpoint]
              # (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). To
              # list the all jobs across all regions, use `projects.jobs.aggregated`. Using
              # `projects.jobs.list` is not recommended, because you can only get the list
              # of jobs that are running in `us-central1`.
              #
              # `projects.locations.jobs.list` and `projects.jobs.list` support filtering
              # the list of jobs by name. Filtering by name isn't supported by
              # `projects.jobs.aggregated`.
              #
              # @overload list_jobs(request, options = nil)
              #   Pass arguments to `list_jobs` via a request object, either of type
              #   {::Google::Cloud::Dataflow::V1beta3::ListJobsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataflow::V1beta3::ListJobsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_jobs(filter: nil, project_id: nil, view: nil, page_size: nil, page_token: nil, location: nil, name: nil)
              #   Pass arguments to `list_jobs` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param filter [::Google::Cloud::Dataflow::V1beta3::ListJobsRequest::Filter]
              #     The kind of filter to use.
              #   @param project_id [::String]
              #     The project which owns the jobs.
              #   @param view [::Google::Cloud::Dataflow::V1beta3::JobView]
              #     Deprecated. ListJobs always returns summaries now.
              #     Use GetJob for other JobViews.
              #   @param page_size [::Integer]
              #     If there are many jobs, limit response to at most this many.
              #     The actual number of jobs returned will be the lesser of max_responses
              #     and an unspecified server-defined limit.
              #   @param page_token [::String]
              #     Set this to the 'next_page_token' field of a previous response
              #     to request additional results in a long list.
              #   @param location [::String]
              #     The [regional endpoint]
              #     (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
              #     contains this job.
              #   @param name [::String]
              #     Optional. The job name.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dataflow::V1beta3::Job>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dataflow::V1beta3::Job>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataflow/v1beta3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataflow::V1beta3::Jobs::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataflow::V1beta3::ListJobsRequest.new
              #
              #   # Call the list_jobs method.
              #   result = client.list_jobs request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Dataflow::V1beta3::Job.
              #     p item
              #   end
              #
              def list_jobs request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataflow::V1beta3::ListJobsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_jobs.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataflow::V1beta3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_jobs.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_jobs.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @jobs_stub.list_jobs request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @jobs_stub, :list_jobs, "jobs", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # List the jobs of a project across all regions.
              #
              # **Note:** This method doesn't support filtering the list of
              # jobs by name.
              #
              # @overload aggregated_list_jobs(request, options = nil)
              #   Pass arguments to `aggregated_list_jobs` via a request object, either of type
              #   {::Google::Cloud::Dataflow::V1beta3::ListJobsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataflow::V1beta3::ListJobsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload aggregated_list_jobs(filter: nil, project_id: nil, view: nil, page_size: nil, page_token: nil, location: nil, name: nil)
              #   Pass arguments to `aggregated_list_jobs` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param filter [::Google::Cloud::Dataflow::V1beta3::ListJobsRequest::Filter]
              #     The kind of filter to use.
              #   @param project_id [::String]
              #     The project which owns the jobs.
              #   @param view [::Google::Cloud::Dataflow::V1beta3::JobView]
              #     Deprecated. ListJobs always returns summaries now.
              #     Use GetJob for other JobViews.
              #   @param page_size [::Integer]
              #     If there are many jobs, limit response to at most this many.
              #     The actual number of jobs returned will be the lesser of max_responses
              #     and an unspecified server-defined limit.
              #   @param page_token [::String]
              #     Set this to the 'next_page_token' field of a previous response
              #     to request additional results in a long list.
              #   @param location [::String]
              #     The [regional endpoint]
              #     (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that
              #     contains this job.
              #   @param name [::String]
              #     Optional. The job name.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dataflow::V1beta3::Job>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dataflow::V1beta3::Job>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataflow/v1beta3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataflow::V1beta3::Jobs::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataflow::V1beta3::ListJobsRequest.new
              #
              #   # Call the aggregated_list_jobs method.
              #   result = client.aggregated_list_jobs request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Dataflow::V1beta3::Job.
              #     p item
              #   end
              #
              def aggregated_list_jobs request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataflow::V1beta3::ListJobsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.aggregated_list_jobs.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataflow::V1beta3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.aggregated_list_jobs.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.aggregated_list_jobs.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @jobs_stub.aggregated_list_jobs request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @jobs_stub, :aggregated_list_jobs, "jobs", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Snapshot the state of a streaming job.
              #
              # @overload snapshot_job(request, options = nil)
              #   Pass arguments to `snapshot_job` via a request object, either of type
              #   {::Google::Cloud::Dataflow::V1beta3::SnapshotJobRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataflow::V1beta3::SnapshotJobRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload snapshot_job(project_id: nil, job_id: nil, ttl: nil, location: nil, snapshot_sources: nil, description: nil)
              #   Pass arguments to `snapshot_job` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param project_id [::String]
              #     The project which owns the job to be snapshotted.
              #   @param job_id [::String]
              #     The job to be snapshotted.
              #   @param ttl [::Google::Protobuf::Duration, ::Hash]
              #     TTL for the snapshot.
              #   @param location [::String]
              #     The location that contains this job.
              #   @param snapshot_sources [::Boolean]
              #     If true, perform snapshots for sources which support this.
              #   @param description [::String]
              #     User specified description of the snapshot. Maybe empty.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dataflow::V1beta3::Snapshot]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dataflow::V1beta3::Snapshot]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataflow/v1beta3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataflow::V1beta3::Jobs::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataflow::V1beta3::SnapshotJobRequest.new
              #
              #   # Call the snapshot_job method.
              #   result = client.snapshot_job request
              #
              #   # The returned object is of type Google::Cloud::Dataflow::V1beta3::Snapshot.
              #   p result
              #
              def snapshot_job request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataflow::V1beta3::SnapshotJobRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.snapshot_job.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataflow::V1beta3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.snapshot_job.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.snapshot_job.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @jobs_stub.snapshot_job request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the Jobs REST API.
              #
              # This class represents the configuration for Jobs REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::Dataflow::V1beta3::Jobs::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # create_job to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::Dataflow::V1beta3::Jobs::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_job.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::Dataflow::V1beta3::Jobs::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_job.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "dataflow.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the Jobs API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `create_job`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_job
                  ##
                  # RPC-specific configuration for `get_job`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_job
                  ##
                  # RPC-specific configuration for `update_job`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_job
                  ##
                  # RPC-specific configuration for `list_jobs`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_jobs
                  ##
                  # RPC-specific configuration for `aggregated_list_jobs`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :aggregated_list_jobs
                  ##
                  # RPC-specific configuration for `snapshot_job`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :snapshot_job

                  # @private
                  def initialize parent_rpcs = nil
                    create_job_config = parent_rpcs.create_job if parent_rpcs.respond_to? :create_job
                    @create_job = ::Gapic::Config::Method.new create_job_config
                    get_job_config = parent_rpcs.get_job if parent_rpcs.respond_to? :get_job
                    @get_job = ::Gapic::Config::Method.new get_job_config
                    update_job_config = parent_rpcs.update_job if parent_rpcs.respond_to? :update_job
                    @update_job = ::Gapic::Config::Method.new update_job_config
                    list_jobs_config = parent_rpcs.list_jobs if parent_rpcs.respond_to? :list_jobs
                    @list_jobs = ::Gapic::Config::Method.new list_jobs_config
                    aggregated_list_jobs_config = parent_rpcs.aggregated_list_jobs if parent_rpcs.respond_to? :aggregated_list_jobs
                    @aggregated_list_jobs = ::Gapic::Config::Method.new aggregated_list_jobs_config
                    snapshot_job_config = parent_rpcs.snapshot_job if parent_rpcs.respond_to? :snapshot_job
                    @snapshot_job = ::Gapic::Config::Method.new snapshot_job_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
