# frozen_string_literal: true

# Copyright 2026 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/databasecenter/v1beta/service_pb"
require "google/cloud/database_center/v1beta/database_center"

class ::Google::Cloud::DatabaseCenter::V1beta::DatabaseCenter::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_query_products
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DatabaseCenter::V1beta::QueryProductsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    query_products_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :query_products, name
      assert_kind_of ::Google::Cloud::DatabaseCenter::V1beta::QueryProductsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, query_products_client_stub do
      # Create client
      client = ::Google::Cloud::DatabaseCenter::V1beta::DatabaseCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.query_products({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.query_products parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.query_products ::Google::Cloud::DatabaseCenter::V1beta::QueryProductsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.query_products({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.query_products(::Google::Cloud::DatabaseCenter::V1beta::QueryProductsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, query_products_client_stub.call_rpc_count
    end
  end

  def test_aggregate_fleet
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DatabaseCenter::V1beta::AggregateFleetResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    group_by = "hello world"
    order_by = "hello world"
    page_size = 42
    page_token = "hello world"
    baseline_date = {}

    aggregate_fleet_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :aggregate_fleet, name
      assert_kind_of ::Google::Cloud::DatabaseCenter::V1beta::AggregateFleetRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["group_by"]
      assert_equal "hello world", request["order_by"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Type::Date), request["baseline_date"]
      assert request.has_baseline_date?
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, aggregate_fleet_client_stub do
      # Create client
      client = ::Google::Cloud::DatabaseCenter::V1beta::DatabaseCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.aggregate_fleet({ parent: parent, filter: filter, group_by: group_by, order_by: order_by, page_size: page_size, page_token: page_token, baseline_date: baseline_date }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.aggregate_fleet parent: parent, filter: filter, group_by: group_by, order_by: order_by, page_size: page_size, page_token: page_token, baseline_date: baseline_date do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.aggregate_fleet ::Google::Cloud::DatabaseCenter::V1beta::AggregateFleetRequest.new(parent: parent, filter: filter, group_by: group_by, order_by: order_by, page_size: page_size, page_token: page_token, baseline_date: baseline_date) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.aggregate_fleet({ parent: parent, filter: filter, group_by: group_by, order_by: order_by, page_size: page_size, page_token: page_token, baseline_date: baseline_date }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.aggregate_fleet(::Google::Cloud::DatabaseCenter::V1beta::AggregateFleetRequest.new(parent: parent, filter: filter, group_by: group_by, order_by: order_by, page_size: page_size, page_token: page_token, baseline_date: baseline_date), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, aggregate_fleet_client_stub.call_rpc_count
    end
  end

  def test_query_database_resource_groups
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DatabaseCenter::V1beta::QueryDatabaseResourceGroupsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    signal_type_groups = [{}]
    signal_filters = [{}]
    order_by = "hello world"
    page_size = 42
    page_token = "hello world"

    query_database_resource_groups_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :query_database_resource_groups, name
      assert_kind_of ::Google::Cloud::DatabaseCenter::V1beta::QueryDatabaseResourceGroupsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["filter"]
      assert_kind_of ::Google::Cloud::DatabaseCenter::V1beta::SignalTypeGroup, request["signal_type_groups"].first
      assert_kind_of ::Google::Cloud::DatabaseCenter::V1beta::SignalFilter, request["signal_filters"].first
      assert_equal "hello world", request["order_by"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, query_database_resource_groups_client_stub do
      # Create client
      client = ::Google::Cloud::DatabaseCenter::V1beta::DatabaseCenter::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.query_database_resource_groups({ parent: parent, filter: filter, signal_type_groups: signal_type_groups, signal_filters: signal_filters, order_by: order_by, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.query_database_resource_groups parent: parent, filter: filter, signal_type_groups: signal_type_groups, signal_filters: signal_filters, order_by: order_by, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.query_database_resource_groups ::Google::Cloud::DatabaseCenter::V1beta::QueryDatabaseResourceGroupsRequest.new(parent: parent, filter: filter, signal_type_groups: signal_type_groups, signal_filters: signal_filters, order_by: order_by, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.query_database_resource_groups({ parent: parent, filter: filter, signal_type_groups: signal_type_groups, signal_filters: signal_filters, order_by: order_by, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.query_database_resource_groups(::Google::Cloud::DatabaseCenter::V1beta::QueryDatabaseResourceGroupsRequest.new(parent: parent, filter: filter, signal_type_groups: signal_type_groups, signal_filters: signal_filters, order_by: order_by, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, query_database_resource_groups_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::DatabaseCenter::V1beta::DatabaseCenter::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::DatabaseCenter::V1beta::DatabaseCenter::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::DatabaseCenter::V1beta::DatabaseCenter::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::DatabaseCenter::V1beta::DatabaseCenter::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
