# frozen_string_literal: true

# Copyright 2026 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/databasecenter/v1beta/service_pb"
require "google/cloud/database_center/v1beta/database_center/rest"


class ::Google::Cloud::DatabaseCenter::V1beta::DatabaseCenter::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_query_products
    # Create test objects.
    client_result = ::Google::Cloud::DatabaseCenter::V1beta::QueryProductsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    query_products_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DatabaseCenter::V1beta::DatabaseCenter::Rest::ServiceStub.stub :transcode_query_products_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, query_products_client_stub do
        # Create client
        client = ::Google::Cloud::DatabaseCenter::V1beta::DatabaseCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.query_products({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.query_products parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.query_products ::Google::Cloud::DatabaseCenter::V1beta::QueryProductsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.query_products({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.query_products(::Google::Cloud::DatabaseCenter::V1beta::QueryProductsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, query_products_client_stub.call_count
      end
    end
  end

  def test_aggregate_fleet
    # Create test objects.
    client_result = ::Google::Cloud::DatabaseCenter::V1beta::AggregateFleetResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    group_by = "hello world"
    order_by = "hello world"
    page_size = 42
    page_token = "hello world"
    baseline_date = {}

    aggregate_fleet_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DatabaseCenter::V1beta::DatabaseCenter::Rest::ServiceStub.stub :transcode_aggregate_fleet_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, aggregate_fleet_client_stub do
        # Create client
        client = ::Google::Cloud::DatabaseCenter::V1beta::DatabaseCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.aggregate_fleet({ parent: parent, filter: filter, group_by: group_by, order_by: order_by, page_size: page_size, page_token: page_token, baseline_date: baseline_date }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.aggregate_fleet parent: parent, filter: filter, group_by: group_by, order_by: order_by, page_size: page_size, page_token: page_token, baseline_date: baseline_date do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.aggregate_fleet ::Google::Cloud::DatabaseCenter::V1beta::AggregateFleetRequest.new(parent: parent, filter: filter, group_by: group_by, order_by: order_by, page_size: page_size, page_token: page_token, baseline_date: baseline_date) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.aggregate_fleet({ parent: parent, filter: filter, group_by: group_by, order_by: order_by, page_size: page_size, page_token: page_token, baseline_date: baseline_date }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.aggregate_fleet(::Google::Cloud::DatabaseCenter::V1beta::AggregateFleetRequest.new(parent: parent, filter: filter, group_by: group_by, order_by: order_by, page_size: page_size, page_token: page_token, baseline_date: baseline_date), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, aggregate_fleet_client_stub.call_count
      end
    end
  end

  def test_query_database_resource_groups
    # Create test objects.
    client_result = ::Google::Cloud::DatabaseCenter::V1beta::QueryDatabaseResourceGroupsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    signal_type_groups = [{}]
    signal_filters = [{}]
    order_by = "hello world"
    page_size = 42
    page_token = "hello world"

    query_database_resource_groups_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DatabaseCenter::V1beta::DatabaseCenter::Rest::ServiceStub.stub :transcode_query_database_resource_groups_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, query_database_resource_groups_client_stub do
        # Create client
        client = ::Google::Cloud::DatabaseCenter::V1beta::DatabaseCenter::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.query_database_resource_groups({ parent: parent, filter: filter, signal_type_groups: signal_type_groups, signal_filters: signal_filters, order_by: order_by, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.query_database_resource_groups parent: parent, filter: filter, signal_type_groups: signal_type_groups, signal_filters: signal_filters, order_by: order_by, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.query_database_resource_groups ::Google::Cloud::DatabaseCenter::V1beta::QueryDatabaseResourceGroupsRequest.new(parent: parent, filter: filter, signal_type_groups: signal_type_groups, signal_filters: signal_filters, order_by: order_by, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.query_database_resource_groups({ parent: parent, filter: filter, signal_type_groups: signal_type_groups, signal_filters: signal_filters, order_by: order_by, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.query_database_resource_groups(::Google::Cloud::DatabaseCenter::V1beta::QueryDatabaseResourceGroupsRequest.new(parent: parent, filter: filter, signal_type_groups: signal_type_groups, signal_filters: signal_filters, order_by: order_by, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, query_database_resource_groups_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::DatabaseCenter::V1beta::DatabaseCenter::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::DatabaseCenter::V1beta::DatabaseCenter::Rest::Client::Configuration, config
  end
end
