# frozen_string_literal: true

# Copyright 2026 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DatabaseCenter
      module V1beta
        # A group of signal types that specifies what the user is interested in.
        #
        # Used by QueryDatabaseResourceGroups API.
        #
        # Example:
        #
        # signal_type_group {
        #   name = "AVAILABILITY"
        #   types = [SIGNAL_TYPE_NO_PROMOTABLE_REPLICA]
        # }
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. The display name of a signal group.
        # @!attribute [rw] signal_types
        #   @return [::Array<::Google::Cloud::DatabaseCenter::V1beta::SignalType>]
        #     Optional. List of signal types present in the group.
        class SignalTypeGroup
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A filter for Signals.
        #
        # If signal_type is left unset, all signals should be returned.
        # For example, the following filter returns all issues.
        #   signal_filter: {
        #     signal_status: SIGNAL_STATUS_ISSUE;
        #   }
        #
        # Another example, the following filter returns issues of the given type:
        # signal_filter: {
        #   type: SIGNAL_TYPE_NO_PROMOTABLE_REPLICA
        #   signal_status: ISSUE
        # }
        #
        # If signal_status is left unset or set to SIGNAL_STATE_UNSPECIFIED, an error
        # should be returned.
        # @!attribute [rw] signal_type
        #   @return [::Google::Cloud::DatabaseCenter::V1beta::SignalType]
        #     Optional. Represents the type of the Signal for which the filter is for.
        # @!attribute [rw] signal_status
        #   @return [::Google::Cloud::DatabaseCenter::V1beta::SignalStatus]
        #     Optional. Represents the status of the Signal for which the filter is for.
        class SignalFilter
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A group of signals and their counts.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Title of a signal group corresponding to the request.
        # @!attribute [rw] issue_count
        #   @return [::Integer]
        #     When applied to a DatabaseResource represents count of issues associated
        #     with the resource. A signal is an issue when its SignalStatus field is
        #     set to SIGNAL_STATUS_ISSUE.
        # @!attribute [rw] signals
        #   @return [::Array<::Google::Cloud::DatabaseCenter::V1beta::Signal>]
        #     List of signals present in the group and associated with the resource.
        #
        #     Only applies to a DatabaseResource.
        class SignalGroup
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Count of issues for a group of signals.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Title of a signal group corresponding to the request.
        # @!attribute [rw] issue_count
        #   @return [::Integer]
        #     The count of the number of issues associated with those resources that
        #     are explicitly filtered in by the filters present in the request.
        #     A signal is an issue when its SignalStatus field is set to
        #     SIGNAL_STATUS_ISSUE.
        class IssueCount
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Details related to signal.
        # @!attribute [rw] short_backup_retention_info
        #   @return [::Google::Cloud::DatabaseCenter::V1beta::RetentionSettingsInfo]
        #     Short backup retention information applies to signals with type
        #     SIGNAL_TYPE_SHORT_BACKUP_RETENTION.
        #
        #     Note: The following fields are mutually exclusive: `short_backup_retention_info`, `backup_run_info`, `scc_info`, `recommendation_info`, `automated_backup_policy_info`, `deletion_protection_info`, `resource_suspension_info`, `inefficient_query_info`, `outdated_minor_version_info`, `maintenance_recommendation_info`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] backup_run_info
        #   @return [::Google::Cloud::DatabaseCenter::V1beta::BackupRunInfo]
        #     Backup run information applies to signals with types
        #     SIGNAL_TYPE_LAST_BACKUP_FAILED and SIGNAL_TYPE_LAST_BACKUP_OLD.
        #
        #     Note: The following fields are mutually exclusive: `backup_run_info`, `short_backup_retention_info`, `scc_info`, `recommendation_info`, `automated_backup_policy_info`, `deletion_protection_info`, `resource_suspension_info`, `inefficient_query_info`, `outdated_minor_version_info`, `maintenance_recommendation_info`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] scc_info
        #   @return [::Google::Cloud::DatabaseCenter::V1beta::SCCInfo]
        #     SCC information applies to SCC signals.
        #
        #     Note: The following fields are mutually exclusive: `scc_info`, `short_backup_retention_info`, `backup_run_info`, `recommendation_info`, `automated_backup_policy_info`, `deletion_protection_info`, `resource_suspension_info`, `inefficient_query_info`, `outdated_minor_version_info`, `maintenance_recommendation_info`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] recommendation_info
        #   @return [::Google::Cloud::DatabaseCenter::V1beta::RecommendationInfo]
        #     Recommendation information applies to recommendations.
        #
        #     Note: The following fields are mutually exclusive: `recommendation_info`, `short_backup_retention_info`, `backup_run_info`, `scc_info`, `automated_backup_policy_info`, `deletion_protection_info`, `resource_suspension_info`, `inefficient_query_info`, `outdated_minor_version_info`, `maintenance_recommendation_info`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] automated_backup_policy_info
        #   @return [::Google::Cloud::DatabaseCenter::V1beta::AutomatedBackupPolicyInfo]
        #     Automated backup policy information applies to signals with type
        #     SIGNAL_TYPE_NO_AUTOMATED_BACKUP_POLICY.
        #
        #     Note: The following fields are mutually exclusive: `automated_backup_policy_info`, `short_backup_retention_info`, `backup_run_info`, `scc_info`, `recommendation_info`, `deletion_protection_info`, `resource_suspension_info`, `inefficient_query_info`, `outdated_minor_version_info`, `maintenance_recommendation_info`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] deletion_protection_info
        #   @return [::Google::Cloud::DatabaseCenter::V1beta::DeletionProtectionInfo]
        #     Deletion protection information applies to signals with type
        #     {::Google::Cloud::DatabaseCenter::V1beta::SignalType::SIGNAL_TYPE_NO_DELETION_PROTECTION SIGNAL_TYPE_NO_DELETION_PROTECTION}
        #
        #     Note: The following fields are mutually exclusive: `deletion_protection_info`, `short_backup_retention_info`, `backup_run_info`, `scc_info`, `recommendation_info`, `automated_backup_policy_info`, `resource_suspension_info`, `inefficient_query_info`, `outdated_minor_version_info`, `maintenance_recommendation_info`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] resource_suspension_info
        #   @return [::Google::Cloud::DatabaseCenter::V1beta::ResourceSuspensionInfo]
        #     Resource suspension information applies to signals with type
        #     {::Google::Cloud::DatabaseCenter::V1beta::SignalType::SIGNAL_TYPE_RESOURCE_SUSPENDED SIGNAL_TYPE_RESOURCE_SUSPENDED}.
        #
        #     Note: The following fields are mutually exclusive: `resource_suspension_info`, `short_backup_retention_info`, `backup_run_info`, `scc_info`, `recommendation_info`, `automated_backup_policy_info`, `deletion_protection_info`, `inefficient_query_info`, `outdated_minor_version_info`, `maintenance_recommendation_info`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] inefficient_query_info
        #   @return [::Google::Cloud::DatabaseCenter::V1beta::InefficientQueryInfo]
        #     Inefficient query information applies to signals with type
        #     {::Google::Cloud::DatabaseCenter::V1beta::SignalType::SIGNAL_TYPE_INEFFICIENT_QUERY SIGNAL_TYPE_INEFFICIENT_QUERY}.
        #
        #     Note: The following fields are mutually exclusive: `inefficient_query_info`, `short_backup_retention_info`, `backup_run_info`, `scc_info`, `recommendation_info`, `automated_backup_policy_info`, `deletion_protection_info`, `resource_suspension_info`, `outdated_minor_version_info`, `maintenance_recommendation_info`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] outdated_minor_version_info
        #   @return [::Google::Cloud::DatabaseCenter::V1beta::OutdatedMinorVersionInfo]
        #     Outdated minor version information applies to signals with type
        #     SIGNAL_TYPE_OUTDATED_MINOR_VERSION.
        #
        #     Note: The following fields are mutually exclusive: `outdated_minor_version_info`, `short_backup_retention_info`, `backup_run_info`, `scc_info`, `recommendation_info`, `automated_backup_policy_info`, `deletion_protection_info`, `resource_suspension_info`, `inefficient_query_info`, `maintenance_recommendation_info`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] maintenance_recommendation_info
        #   @return [::Google::Cloud::DatabaseCenter::V1beta::MaintenanceRecommendationInfo]
        #     Maintenance recommendation information applies to signals
        #     with type SIGNAL_TYPE_RECOMMENDED_MAINTENANCE_POLICIES.
        #
        #     Note: The following fields are mutually exclusive: `maintenance_recommendation_info`, `short_backup_retention_info`, `backup_run_info`, `scc_info`, `recommendation_info`, `automated_backup_policy_info`, `deletion_protection_info`, `resource_suspension_info`, `inefficient_query_info`, `outdated_minor_version_info`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] signal_source
        #   @return [::Google::Cloud::DatabaseCenter::V1beta::SignalSource]
        #     Where the signal is coming from.
        # @!attribute [rw] signal_type
        #   @return [::Google::Cloud::DatabaseCenter::V1beta::SignalType]
        #     Type of the signal.
        # @!attribute [rw] signal_event_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Event time when signal was recorded by source service.
        class AdditionalDetail
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Sub resource details
        # For Spanner/Bigtable instance certain data protection settings are at
        # sub resource level like database/table.
        # This message is used to capture such sub resource details.
        # @!attribute [rw] resource_type
        #   @return [::String]
        #     Optional. Resource type associated with the sub resource where backup
        #     settings are configured. E.g. "spanner.googleapis.com/Database" for Spanner
        #     where backup retention is configured on database within an instance
        #     OPTIONAL
        # @!attribute [rw] full_resource_name
        #   @return [::String]
        #     Optional. Resource name associated with the sub resource where backup
        #     settings are configured.
        #     E.g."//spanner.googleapis.com/projects/project1/instances/inst1/databases/db1"
        #     for Spanner where backup retention is configured on database within
        #     an instance
        #     OPTIONAL
        # @!attribute [rw] product
        #   @return [::Google::Cloud::DatabaseCenter::V1beta::Product]
        #     Optional. Product information associated with the sub resource where
        #     backup retention settings are configured.
        #     e.g.
        #     ```
        #     product: {
        #      type   : PRODUCT_TYPE_SPANNER
        #      engine : ENGINE_CLOUD_SPANNER_WITH_POSTGRES_DIALECT
        #     }
        #     ```
        #     for Spanner where backup is configured on database within
        #     an instance
        #     OPTIONAL
        # @!attribute [rw] container
        #   @return [::String]
        #     Specifies where the resource is created. For GCP, it is the full name of
        #     the project.
        class SubResource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata about backup retention settings for a database resource.
        # @!attribute [rw] quantity_based_retention
        #   @return [::Google::Protobuf::Int32Value]
        #     Number of backups that will be retained.
        #
        #     Note: The following fields are mutually exclusive: `quantity_based_retention`, `duration_based_retention`, `timestamp_based_retention_time`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] duration_based_retention
        #   @return [::Google::Protobuf::Duration]
        #     Duration based retention period i.e. 172800 seconds (2 days)
        #
        #     Note: The following fields are mutually exclusive: `duration_based_retention`, `quantity_based_retention`, `timestamp_based_retention_time`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] timestamp_based_retention_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Timestamp based retention period i.e. till 2024-05-01T00:00:00Z
        #
        #     Note: The following fields are mutually exclusive: `timestamp_based_retention_time`, `quantity_based_retention`, `duration_based_retention`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] sub_resource
        #   @return [::Google::Cloud::DatabaseCenter::V1beta::SubResource]
        #     Optional. Sub resource details associated with the backup configuration.
        class RetentionSettingsInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Automated backup policy signal info
        # @!attribute [rw] sub_resource
        #   @return [::Google::Cloud::DatabaseCenter::V1beta::SubResource]
        #     Optional. Sub resource details associated with the signal.
        # @!attribute [rw] is_enabled
        #   @return [::Boolean]
        #     Is automated policy enabled.
        class AutomatedBackupPolicyInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Deletion protection signal info for a database resource.
        # @!attribute [rw] sub_resource
        #   @return [::Google::Cloud::DatabaseCenter::V1beta::SubResource]
        #     Optional. Sub resource details associated with the signal.
        # @!attribute [rw] deletion_protection_enabled
        #   @return [::Boolean]
        #     Is deletion protection enabled.
        class DeletionProtectionInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Resource suspension info for a database resource.
        # @!attribute [rw] resource_suspended
        #   @return [::Boolean]
        #     Is resource suspended.
        # @!attribute [rw] suspension_reason
        #   @return [::Google::Cloud::DatabaseCenter::V1beta::SuspensionReason]
        #     Suspension reason for the resource.
        class ResourceSuspensionInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata about latest backup run state for a database resource.
        # @!attribute [rw] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time the backup operation started.
        # @!attribute [rw] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time the backup operation completed.
        # @!attribute [r] state
        #   @return [::Google::Cloud::DatabaseCenter::V1beta::BackupRunInfo::State]
        #     Output only. The state of this run.
        # @!attribute [rw] error_message
        #   @return [::String]
        #     Additional information about the error encountered.
        # @!attribute [rw] operation_error_type
        #   @return [::Google::Cloud::DatabaseCenter::V1beta::OperationErrorType]
        #     Optional. OperationErrorType to expose specific error when backup operation
        #     of database resource failed, that is state is FAILED.
        # @!attribute [rw] sub_resource
        #   @return [::Google::Cloud::DatabaseCenter::V1beta::SubResource]
        #     Optional. Sub resource details associated with the backup run.
        class BackupRunInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The status of a backup run.
          module State
            # Unspecified.
            STATE_UNSPECIFIED = 0

            # The backup succeeded.
            SUCCEEDED = 1

            # The backup was unsuccessful.
            FAILED = 2
          end
        end

        # Metadata about inefficient query signal info for a database resource.
        # @!attribute [rw] database
        #   @return [::String]
        #     Name of the database where index is required. For example, "db1", which is
        #     the name of the database present in the instance.
        # @!attribute [rw] table
        #   @return [::String]
        #     Name of the table where index is required
        # @!attribute [rw] sql_index_statement
        #   @return [::String]
        #     SQL statement of the index. Based on the ddl type, this will be either
        #     CREATE INDEX or DROP INDEX.
        # @!attribute [rw] storage_cost_bytes
        #   @return [::Integer]
        #     Cost of additional disk usage in bytes
        # @!attribute [rw] impacted_queries_count
        #   @return [::Integer]
        #     Count of queries to be impacted if index is applied
        class InefficientQueryInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Info associated with SCC signals.
        # @!attribute [rw] signal
        #   @return [::String]
        #     Name of the signal.
        # @!attribute [rw] category
        #   @return [::String]
        #     Name by which SCC calls this signal.
        # @!attribute [rw] regulatory_standards
        #   @return [::Array<::Google::Cloud::DatabaseCenter::V1beta::RegulatoryStandard>]
        #     Compliances that are associated with the signal.
        # @!attribute [rw] external_uri
        #   @return [::String]
        #     External URI which points to a SCC page associated with the signal.
        class SCCInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Info associated with recommendation.
        # @!attribute [rw] recommender
        #   @return [::String]
        #     Name of recommendation.
        #     Examples:
        #     organizations/1234/locations/us-central1/recommenders/google.cloudsql.instance.PerformanceRecommender/recommendations/9876
        # @!attribute [rw] recommender_id
        #   @return [::String]
        #     ID of recommender.
        #     Examples: "google.cloudsql.instance.PerformanceRecommender"
        # @!attribute [rw] recommender_subtype
        #   @return [::String]
        #     Contains an identifier for a subtype of recommendations produced for the
        #     same recommender. Subtype is a function of content and impact, meaning a
        #     new subtype might be added when significant changes to `content` or
        #     `primary_impact.category` are introduced. See the Recommenders section
        #     to see a list of subtypes for a given Recommender.
        #
        #     Examples:
        #       For recommender = "google.cloudsql.instance.PerformanceRecommender",
        #       recommender_subtype can be
        #       "MYSQL_HIGH_NUMBER_OF_OPEN_TABLES_BEST_PRACTICE"/"POSTGRES_HIGH_TRANSACTION_ID_UTILIZATION_BEST_PRACTICE"
        class RecommendationInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Compliances associated with signals.
        # @!attribute [rw] standard
        #   @return [::String]
        #     Name of industry compliance standards, such as such as CIS, PCI, and
        #     OWASP.
        # @!attribute [rw] version
        #   @return [::String]
        #     Version of the standard or benchmark, for example, 1.1.
        class RegulatoryStandard
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Info associated with outdated minor version.
        # @!attribute [rw] recommended_minor_version
        #   @return [::String]
        #     Recommended minor version of the underlying database engine. Example
        #     values: For MySQL, it could be "8.0.35", "5.7.25" etc. For PostgreSQL, it
        #     could be "14.4", "15.5" etc.
        class OutdatedMinorVersionInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Info associated with maintenance recommendation.
        # @!attribute [rw] resource_maintenance_schedules
        #   @return [::Array<::Google::Cloud::DatabaseCenter::V1beta::ResourceMaintenanceSchedule>]
        #     Optional. List of recommended maintenance schedules for the database
        #     resource.
        class MaintenanceRecommendationInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a signal.
        # @!attribute [rw] signal_type
        #   @return [::Google::Cloud::DatabaseCenter::V1beta::SignalType]
        #     Type of the signal.
        # @!attribute [rw] signal_status
        #   @return [::Google::Cloud::DatabaseCenter::V1beta::SignalStatus]
        #     Status of the signal.
        # @!attribute [rw] additional_details
        #   @return [::Array<::Google::Cloud::DatabaseCenter::V1beta::AdditionalDetail>]
        #     Additional information related to the signal.
        #     In the case of composite signals, this field encapsulates details
        #     associated with granular signals, having a signal status of "ISSUE";
        #     signals with a status of "OK" are not included.
        #     For granular signals, it encompasses information relevant to the signal,
        #     regardless of the signal status.
        # @!attribute [rw] issue_severity
        #   @return [::Google::Cloud::DatabaseCenter::V1beta::IssueSeverity]
        #     Severity of the issue.
        # @!attribute [rw] issue_create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Timestamp when the issue was created (when signal status is ISSUE).
        class Signal
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the state of a signal. More enum values are expected to be added
        # as needed.
        module SignalStatus
          # Unspecified.
          SIGNAL_STATUS_UNSPECIFIED = 0

          # Signal is not applicable to the resource.
          SIGNAL_STATUS_NOT_APPLICABLE = 1

          # Signal is not an issue.
          SIGNAL_STATUS_OK = 2

          # Signal is an issue.
          SIGNAL_STATUS_ISSUE = 3

          # Signal is not enabled for the resource.
          SIGNAL_STATUS_NOT_ENABLED = 4
        end

        # Represents the source system from where a signal comes from.
        # More enum values are expected to be added as needed.
        module SignalSource
          # Unspecified.
          SIGNAL_SOURCE_UNSPECIFIED = 0

          # Signal comes from resource metadata.
          SIGNAL_SOURCE_RESOURCE_METADATA = 1

          # Signal comes from SCC findings.
          SIGNAL_SOURCE_SECURITY_FINDINGS = 2

          # Signal comes from recommender hub.
          SIGNAL_SOURCE_RECOMMENDER = 3

          # Signal comes from modern observability platform.
          SIGNAL_SOURCE_MODERN_OBSERVABILITY = 4
        end

        # IssueSeverity represents the severity of an issue.
        module IssueSeverity
          # Unspecified.
          ISSUE_SEVERITY_UNSPECIFIED = 0

          # Low severity.
          ISSUE_SEVERITY_LOW = 1

          # Medium severity.
          ISSUE_SEVERITY_MEDIUM = 2

          # High severity.
          ISSUE_SEVERITY_HIGH = 3

          # Critical severity.
          ISSUE_SEVERITY_CRITICAL = 4

          # Irrelevant severity. This means the issue should not be surfaced at all.
          ISSUE_SEVERITY_IRRELEVANT = 5
        end

        # Represents the type of a signal. More values are expected to be added
        # as needed.
        module SignalType
          # Unspecified.
          SIGNAL_TYPE_UNSPECIFIED = 0

          # Represents if a resource is protected by automatic failover.
          # Checks for resources that are configured to have redundancy
          # within a region that enables automatic failover.
          SIGNAL_TYPE_RESOURCE_FAILOVER_PROTECTED = 1

          # Represents if a group is replicating across regions.
          # Checks for resources that are configured to have redundancy,
          # and ongoing replication, across regions.
          SIGNAL_TYPE_GROUP_MULTIREGIONAL = 2

          # Represents if a resource has an automated backup policy.
          SIGNAL_TYPE_NO_AUTOMATED_BACKUP_POLICY = 4

          # Represents if a resources has a short backup retention period.
          SIGNAL_TYPE_SHORT_BACKUP_RETENTION = 5

          # Represents if the last backup of a resource failed.
          SIGNAL_TYPE_LAST_BACKUP_FAILED = 6

          # Represents if the last backup of a resource is older than some threshold
          # value.
          SIGNAL_TYPE_LAST_BACKUP_OLD = 7

          # Represents if a resource violates CIS GCP Foundation 2.0.
          SIGNAL_TYPE_VIOLATES_CIS_GCP_FOUNDATION_2_0 = 8

          # Represents if a resource violates CIS GCP Foundation 1.3.
          SIGNAL_TYPE_VIOLATES_CIS_GCP_FOUNDATION_1_3 = 9

          # Represents if a resource violates CIS GCP Foundation 1.2.
          SIGNAL_TYPE_VIOLATES_CIS_GCP_FOUNDATION_1_2 = 10

          # Represents if a resource violates CIS GCP Foundation 1.1.
          SIGNAL_TYPE_VIOLATES_CIS_GCP_FOUNDATION_1_1 = 11

          # Represents if a resource violates CIS GCP Foundation 1.0.
          SIGNAL_TYPE_VIOLATES_CIS_GCP_FOUNDATION_1_0 = 12

          # Represents if a resource violates CIS Controls 8.0.
          SIGNAL_TYPE_VIOLATES_CIS_CONTROLS_V8_0 = 76

          # Represents if a resource violates NIST 800-53.
          SIGNAL_TYPE_VIOLATES_NIST_800_53 = 13

          # Represents if a resource violates NIST 800-53 R5.
          SIGNAL_TYPE_VIOLATES_NIST_800_53_R5 = 69

          # Represents if a resource violates NIST Cybersecurity Framework 1.0.
          SIGNAL_TYPE_VIOLATES_NIST_CYBERSECURITY_FRAMEWORK_V1_0 = 72

          # Represents if a resource violates ISO-27001.
          SIGNAL_TYPE_VIOLATES_ISO_27001 = 14

          # Represents if a resource violates ISO 27001 2022.
          SIGNAL_TYPE_VIOLATES_ISO_27001_V2022 = 70

          # Represents if a resource violates PCI-DSS v3.2.1.
          SIGNAL_TYPE_VIOLATES_PCI_DSS_V3_2_1 = 15

          # Represents if a resource violates PCI-DSS v4.0.
          SIGNAL_TYPE_VIOLATES_PCI_DSS_V4_0 = 71

          # Represents if a resource violates Cloud Controls Matrix v4.0.
          SIGNAL_TYPE_VIOLATES_CLOUD_CONTROLS_MATRIX_V4 = 73

          # Represents if a resource violates HIPAA.
          SIGNAL_TYPE_VIOLATES_HIPAA = 74

          # Represents if a resource violates SOC2 v2017.
          SIGNAL_TYPE_VIOLATES_SOC2_V2017 = 75

          # Represents if log_checkpoints database flag for a Cloud SQL for PostgreSQL
          # instance is not set to on.
          SIGNAL_TYPE_LOGS_NOT_OPTIMIZED_FOR_TROUBLESHOOTING = 16

          # Represents if the log_duration database flag for a Cloud SQL for PostgreSQL
          # instance is not set to on.
          SIGNAL_TYPE_QUERY_DURATIONS_NOT_LOGGED = 17

          # Represents if the log_error_verbosity database flag for a Cloud SQL for
          # PostgreSQL instance is not set to default or stricter (default or terse).
          SIGNAL_TYPE_VERBOSE_ERROR_LOGGING = 18

          # Represents if the log_lock_waits database flag for a Cloud SQL for
          # PostgreSQL instance is not set to on.
          SIGNAL_TYPE_QUERY_LOCK_WAITS_NOT_LOGGED = 19

          # Represents if the log_min_error_statement database flag for a Cloud SQL
          # for PostgreSQL instance is not set appropriately.
          SIGNAL_TYPE_LOGGING_MOST_ERRORS = 20

          # Represents if the log_min_error_statement database flag for a Cloud SQL
          # for PostgreSQL instance does not have an appropriate severity level.
          SIGNAL_TYPE_LOGGING_ONLY_CRITICAL_ERRORS = 21

          # Represents if the log_min_messages database flag for a Cloud SQL for
          # PostgreSQL instance is not set to warning or another recommended value.
          SIGNAL_TYPE_MINIMAL_ERROR_LOGGING = 22

          # Represents if the databaseFlags property of instance metadata for
          # the log_executor_status field is set to on.
          SIGNAL_TYPE_QUERY_STATS_LOGGED = 23

          # Represents if the log_hostname database flag for a Cloud SQL for
          # PostgreSQL instance is not set to off.
          SIGNAL_TYPE_EXCESSIVE_LOGGING_OF_CLIENT_HOSTNAME = 24

          # Represents if the log_parser_stats database flag for a Cloud SQL for
          # PostgreSQL instance is not set to off.
          SIGNAL_TYPE_EXCESSIVE_LOGGING_OF_PARSER_STATS = 25

          # Represents if the log_planner_stats database flag for a Cloud SQL for
          # PostgreSQL instance is not set to off.
          SIGNAL_TYPE_EXCESSIVE_LOGGING_OF_PLANNER_STATS = 26

          # Represents if the log_statement database flag for a Cloud SQL for
          # PostgreSQL instance is not set to DDL (all data definition statements).
          SIGNAL_TYPE_NOT_LOGGING_ONLY_DDL_STATEMENTS = 27

          # Represents if the log_statement_stats database flag for a Cloud SQL for
          # PostgreSQL instance is not set to off.
          SIGNAL_TYPE_LOGGING_QUERY_STATS = 28

          # Represents if the log_temp_files database flag for a Cloud SQL for
          # PostgreSQL instance is not set to "0". (NOTE: 0 = ON)
          SIGNAL_TYPE_NOT_LOGGING_TEMPORARY_FILES = 29

          # Represents if the user connections database flag for a Cloud SQL for SQL
          # Server instance is configured.
          SIGNAL_TYPE_CONNECTION_MAX_NOT_CONFIGURED = 30

          # Represents if the user options database flag for Cloud SQL SQL Server
          # instance is configured or not.
          SIGNAL_TYPE_USER_OPTIONS_CONFIGURED = 31

          # Represents if a resource is exposed to public access.
          SIGNAL_TYPE_EXPOSED_TO_PUBLIC_ACCESS = 32

          # Represents if a resources requires all incoming connections to use SSL
          # or not.
          SIGNAL_TYPE_UNENCRYPTED_CONNECTIONS = 33

          # Represents if a Cloud SQL database has a password configured for the
          # root account or not.
          SIGNAL_TYPE_NO_ROOT_PASSWORD = 34

          # Represents if a Cloud SQL database has a weak password configured for the
          # root account.
          SIGNAL_TYPE_WEAK_ROOT_PASSWORD = 35

          # Represents if a SQL database instance is not encrypted with
          # customer-managed encryption keys (CMEK).
          SIGNAL_TYPE_ENCRYPTION_KEY_NOT_CUSTOMER_MANAGED = 36

          # Represents if The contained database authentication database flag for a
          # Cloud SQL for SQL Server instance is not set to off.
          SIGNAL_TYPE_SERVER_AUTHENTICATION_NOT_REQUIRED = 37

          # Represents if he external scripts enabled database flag for a Cloud SQL
          # for SQL Server instance is not set to off.
          SIGNAL_TYPE_EXPOSED_TO_EXTERNAL_SCRIPTS = 39

          # Represents if the local_infile database flag for a Cloud SQL for MySQL
          # instance is not set to off.
          SIGNAL_TYPE_EXPOSED_TO_LOCAL_DATA_LOADS = 40

          # Represents if the log_connections database flag for a Cloud SQL for
          # PostgreSQL instance is not set to on.
          SIGNAL_TYPE_CONNECTION_ATTEMPTS_NOT_LOGGED = 41

          # Represents if the log_disconnections database flag for a Cloud SQL for
          # PostgreSQL instance is not set to on.
          SIGNAL_TYPE_DISCONNECTIONS_NOT_LOGGED = 42

          # Represents if the log_min_duration_statement database flag for a Cloud SQL
          # for PostgreSQL instance is not set to -1.
          SIGNAL_TYPE_LOGGING_EXCESSIVE_STATEMENT_INFO = 43

          # Represents if the remote access database flag for a Cloud SQL for SQL
          # Server instance is not set to off.
          SIGNAL_TYPE_EXPOSED_TO_REMOTE_ACCESS = 44

          # Represents if the skip_show_database database flag for a Cloud SQL for
          # MySQL instance is not set to on.
          SIGNAL_TYPE_DATABASE_NAMES_EXPOSED = 45

          # Represents if the 3625 (trace flag) database flag for a Cloud SQL for
          # SQL Server instance is not set to on.
          SIGNAL_TYPE_SENSITIVE_TRACE_INFO_NOT_MASKED = 46

          # Represents if public IP is enabled.
          SIGNAL_TYPE_PUBLIC_IP_ENABLED = 47

          # Represents idle instance helps to reduce costs.
          SIGNAL_TYPE_IDLE = 48

          # Represents instances that are unnecessarily large for given workload.
          SIGNAL_TYPE_OVERPROVISIONED = 49

          # Represents high number of concurrently opened tables.
          SIGNAL_TYPE_HIGH_NUMBER_OF_OPEN_TABLES = 50

          # Represents high table count close to SLA limit.
          SIGNAL_TYPE_HIGH_NUMBER_OF_TABLES = 51

          # Represents high number of unvacuumed transactions
          SIGNAL_TYPE_HIGH_TRANSACTION_ID_UTILIZATION = 52

          # Represents need for more CPU and/or memory
          SIGNAL_TYPE_UNDERPROVISIONED = 53

          # Represents out of disk.
          SIGNAL_TYPE_OUT_OF_DISK = 54

          # Represents server certificate is near expiry.
          SIGNAL_TYPE_SERVER_CERTIFICATE_NEAR_EXPIRY = 55

          # Represents database auditing is disabled.
          SIGNAL_TYPE_DATABASE_AUDITING_DISABLED = 56

          # Represents not restricted to authorized networks.
          SIGNAL_TYPE_RESTRICT_AUTHORIZED_NETWORKS = 57

          # Represents violate org policy restrict public ip.
          SIGNAL_TYPE_VIOLATE_POLICY_RESTRICT_PUBLIC_IP = 58

          # Cluster nearing quota limit
          SIGNAL_TYPE_QUOTA_LIMIT = 59

          # No password policy set on resources
          SIGNAL_TYPE_NO_PASSWORD_POLICY = 60

          # Performance impact of connections settings
          SIGNAL_TYPE_CONNECTIONS_PERFORMANCE_IMPACT = 61

          # Performance impact of temporary tables settings
          SIGNAL_TYPE_TMP_TABLES_PERFORMANCE_IMPACT = 62

          # Performance impact of transaction logs settings
          SIGNAL_TYPE_TRANS_LOGS_PERFORMANCE_IMPACT = 63

          # Performance impact of high joins without indexes
          SIGNAL_TYPE_HIGH_JOINS_WITHOUT_INDEXES = 64

          # Detects events where a database superuser (postgres for PostgreSQL servers
          # or root for MySQL users) writes to non-system tables.
          SIGNAL_TYPE_SUPERUSER_WRITING_TO_USER_TABLES = 65

          # Detects events where a database user or role has been granted all
          # privileges to a database, or to all tables, procedures, or functions in a
          # schema.
          SIGNAL_TYPE_USER_GRANTED_ALL_PERMISSIONS = 66

          # Detects if database instance data exported to a Cloud Storage bucket
          # outside of the organization.
          SIGNAL_TYPE_DATA_EXPORT_TO_EXTERNAL_CLOUD_STORAGE_BUCKET = 67

          # Detects if database instance data exported to a Cloud Storage bucket that
          # is owned by the organization and is publicly accessible.
          SIGNAL_TYPE_DATA_EXPORT_TO_PUBLIC_CLOUD_STORAGE_BUCKET = 68

          # Detects if a database instance is using a weak password hash algorithm.
          SIGNAL_TYPE_WEAK_PASSWORD_HASH_ALGORITHM = 77

          # Detects if a database instance has no user password policy set.
          SIGNAL_TYPE_NO_USER_PASSWORD_POLICY = 78

          # Detects if a database instance/cluster has a hot node.
          SIGNAL_TYPE_HOT_NODE = 79

          # Deletion Protection Disabled for the resource
          SIGNAL_TYPE_NO_DELETION_PROTECTION = 80

          # Detects if a database instance has no point in time recovery enabled.
          SIGNAL_TYPE_NO_POINT_IN_TIME_RECOVERY = 81

          # Detects if a database instance/cluster has suspended resources.
          SIGNAL_TYPE_RESOURCE_SUSPENDED = 82

          # Detects that expensive commands are being run on a database instance
          # impacting overall performance.
          SIGNAL_TYPE_EXPENSIVE_COMMANDS = 83

          # Indicates that the instance does not have a maintenance policy configured.
          SIGNAL_TYPE_NO_MAINTENANCE_POLICY_CONFIGURED = 84

          # Indicates that the instance has inefficient queries detected.
          SIGNAL_TYPE_INEFFICIENT_QUERY = 85

          # Indicates that the instance has read intensive workload.
          SIGNAL_TYPE_READ_INTENSIVE_WORKLOAD = 86

          # Indicates that the instance is nearing memory limit.
          SIGNAL_TYPE_MEMORY_LIMIT = 87

          # Indicates that the instance's max server memory is configured higher than
          # the recommended value.
          SIGNAL_TYPE_MAX_SERVER_MEMORY = 88

          # Indicates that the database has large rows beyond the recommended limit.
          SIGNAL_TYPE_LARGE_ROWS = 89

          # Heavy write pressure on the database rows.
          SIGNAL_TYPE_HIGH_WRITE_PRESSURE = 90

          # Heavy read pressure on the database rows.
          SIGNAL_TYPE_HIGH_READ_PRESSURE = 91

          # Encryption org policy not satisfied.
          SIGNAL_TYPE_ENCRYPTION_ORG_POLICY_NOT_SATISFIED = 92

          # Location org policy not satisfied.
          SIGNAL_TYPE_LOCATION_ORG_POLICY_NOT_SATISFIED = 93

          # Outdated DB minor version.
          SIGNAL_TYPE_OUTDATED_MINOR_VERSION = 94

          # Schema not optimized.
          SIGNAL_TYPE_SCHEMA_NOT_OPTIMIZED = 95

          # Replication delay.
          SIGNAL_TYPE_REPLICATION_LAG = 97

          # Outdated client.
          SIGNAL_TYPE_OUTDATED_CLIENT = 99

          # Databoost is disabled.
          SIGNAL_TYPE_DATABOOST_DISABLED = 100

          # Recommended maintenance policy.
          SIGNAL_TYPE_RECOMMENDED_MAINTENANCE_POLICIES = 101

          # Resource version is in extended support.
          SIGNAL_TYPE_EXTENDED_SUPPORT = 102
        end
      end
    end
  end
end
