# frozen_string_literal: true

# Copyright 2026 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DatabaseCenter
      module V1beta
        # QueryProductsRequest is the request to get a list of products.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent can be a project, a folder, or an organization.
        #
        #     The allowed values are:
        #
        #     * projects/\\{PROJECT_ID}/locations/\\{LOCATION}
        #     (e.g.,"projects/foo-bar/locations/us-central1")
        #     * projects/\\{PROJECT_NUMBER}/locations/\\{LOCATION}
        #     (e.g.,"projects/12345678/locations/us-central1")
        #     * folders/\\{FOLDER_NUMBER}/locations/\\{LOCATION}
        #     (e.g.,"folders/1234567/locations/us-central1")
        #     * organizations/\\{ORGANIZATION_NUMBER}/locations/\\{LOCATION}
        #     (e.g.,"organizations/123456/locations/us-central1")
        #     * projects/\\{PROJECT_ID} (e.g., "projects/foo-bar")
        #     * projects/\\{PROJECT_NUMBER} (e.g., "projects/12345678")
        #     * folders/\\{FOLDER_NUMBER} (e.g., "folders/1234567")
        #     * organizations/\\{ORGANIZATION_NUMBER} (e.g., "organizations/123456")
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. If unspecified, at most 50 products will be returned.
        #     The maximum value is 1000; values above 1000 will be coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous `ListLocations` call.
        #     Provide this to retrieve the subsequent page.
        #     All other parameters except page size should match the call that provided
        #     the page page token.
        class QueryProductsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # QueryProductsResponse represents the response containing a list of products.
        # @!attribute [rw] products
        #   @return [::Array<::Google::Cloud::DatabaseCenter::V1beta::Product>]
        #     List of database products returned.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token that can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Unordered list. List of unreachable regions from where data could not be
        #     retrieved.
        class QueryProductsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # QueryDatabaseResourceGroupsRequest is the request to get a list of database
        # groups.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent can be a project, a folder, or an organization. The search
        #     is limited to the resources within the `scope`.
        #
        #     The allowed values are:
        #
        #     * projects/\\{PROJECT_ID} (e.g., "projects/foo-bar")
        #     * projects/\\{PROJECT_NUMBER} (e.g., "projects/12345678")
        #     * folders/\\{FOLDER_NUMBER} (e.g., "folders/1234567")
        #     * organizations/\\{ORGANIZATION_NUMBER} (e.g., "organizations/123456")
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. The expression to filter resources.
        #
        #     The following fields are filterable:
        #       * full_resource_name
        #       * resource_type
        #       * container
        #       * product.type
        #       * product.engine
        #       * product.version
        #       * location
        #       * labels
        #       * resource_category
        #       * machine_config.cpu_count
        #       * machine_config.memory_size_bytes
        #       * machine_config.shard_count
        #       * resource_name
        #       * tags
        #       * backupdr_config.backupdr_managed
        #       * edition
        #
        #     The expression is a list of zero or more restrictions combined via logical
        #     operators `AND` and `OR`. When `AND` and `OR` are both used in the
        #     expression, parentheses must be appropriately used to group the
        #     combinations.
        #
        #     Example: location="us-east1"
        #     Example: container="projects/123" OR container="projects/456"
        #     Example: (container="projects/123" OR
        #               container="projects/456") AND location="us-east1"
        #     Example: full_resource_name=~"test"
        #     Example: full_resource_name=~"test.*master"
        # @!attribute [rw] signal_type_groups
        #   @return [::Array<::Google::Cloud::DatabaseCenter::V1beta::SignalTypeGroup>]
        #     Optional. Groups of signal types that are requested.
        # @!attribute [rw] signal_filters
        #   @return [::Array<::Google::Cloud::DatabaseCenter::V1beta::SignalFilter>]
        #     Optional. Filters based on signals. The list will be ORed together and then
        #     ANDed with the `filters` field above.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. A field that specifies the sort order of the results.
        #
        #     The following fields are sortable:
        #       * full_resource_name
        #       * product.type
        #       * product.engine
        #       * product.version
        #       * container
        #       * issue_count
        #       * machine_config.vcpu_count
        #       * machine_config.memory_size_bytes
        #       * machine_config.shard_count
        #       * resource_name
        #       * issue_severity
        #       * signal_type
        #       * location
        #       * resource_type
        #       * instance_type
        #       * edition
        #       * metrics.p99_cpu_utilization
        #       * metrics.p95_cpu_utilization
        #       * metrics.current_storage_used_bytes
        #       * metrics.node_count
        #       * metrics.processing_unit_count
        #       * metrics.current_memory_used_bytes
        #       * metrics.peak_storage_utilization
        #       * metrics.peak_number_connections
        #       * metrics.peak_memory_utilization
        #
        #     The default order is ascending. Add "DESC" after the field name to indicate
        #     descending order. Add "ASC" after the field name to indicate ascending
        #     order. It only supports a single field at a time.
        #
        #     For example:
        #      order_by = "full_resource_name" sorts response in ascending order
        #      order_by = "full_resource_name DESC" sorts response in descending order
        #      order_by = "issue_count DESC" sorts response in descending order of
        #      count of all issues associated with a resource.
        #
        #     More explicitly, order_by = "full_resource_name, product" is not supported.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. If unspecified, at most 50 resource groups will be returned.
        #     The maximum value is 1000; values above 1000 will be coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous
        #     `QueryDatabaseResourceGroupsRequest` call. Provide this to retrieve the
        #     subsequent page. All parameters except page_token should match the
        #     parameters in the call that provided the page page token.
        class QueryDatabaseResourceGroupsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # QueryDatabaseResourceGroupsResponse represents the response message
        # containing a list of resource groups.
        # @!attribute [rw] resource_groups
        #   @return [::Array<::Google::Cloud::DatabaseCenter::V1beta::DatabaseResourceGroup>]
        #     List of database resource groups that pass the filter.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token that can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Unordered list. List of unreachable regions from where data could not be
        #     retrieved.
        class QueryDatabaseResourceGroupsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # DatabaseResourceGroup represents all resources that serve a common data set.
        # It is considered notionally as a single entity, powered by any number of
        # units of compute and storage.
        # @!attribute [rw] root_resources
        #   @return [::Array<::Google::Cloud::DatabaseCenter::V1beta::DatabaseResource>]
        #     A database resource that serves as a root of the group of database
        #     resources. It is repeated just in case we have the concept of multiple
        #     roots in the future, however, it will only be populated with a single value
        #     for now.
        # @!attribute [rw] signal_groups
        #   @return [::Array<::Google::Cloud::DatabaseCenter::V1beta::IssueCount>]
        #     The filtered signal groups and the count of issues associated with the
        #     resources that have been filtered in.
        class DatabaseResourceGroup
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # DatabaseResource represents every individually configured database unit
        # representing compute and/or storage.
        # NextId: 20
        # @!attribute [rw] child_resources
        #   @return [::Array<::Google::Cloud::DatabaseCenter::V1beta::DatabaseResource>]
        #     List of children associated with a database group.
        # @!attribute [rw] full_resource_name
        #   @return [::String]
        #     The full resource name, based on CAIS resource name format
        #     https://cloud.google.com/asset-inventory/docs/resource-name-format
        #
        #     Example:
        #
        #      `//cloudsql.googleapis.com/projects/project-number/instances/mysql-1`
        #      `//cloudsql.googleapis.com/projects/project-number/instances/postgres-1`
        #      `//spanner.googleapis.com/projects/project-number/instances/spanner-instance-1`
        #      `//alloydb.googleapis.com/projects/project-number/locations/us-central1/clusters/c1`
        #      `//alloydb.googleapis.com/projects/project-number/locations/us-central1/clusters/c1/instances/i1`
        # @!attribute [rw] container
        #   @return [::String]
        #     Specifies where the resource is created. For GCP, it is the full name of
        #     the project.
        # @!attribute [rw] product
        #   @return [::Google::Cloud::DatabaseCenter::V1beta::Product]
        #     The product this resource represents.
        # @!attribute [rw] location
        #   @return [::String]
        #     The location of the resources. It supports returning only regional
        #     locations in GCP. These are of the form: "us-central1", "us-east1", etc.
        #     See https://cloud.google.com/about/locations for a list of such regions.
        # @!attribute [rw] labels
        #   @return [::Array<::Google::Cloud::DatabaseCenter::V1beta::Label>]
        #     Labels applied on the resource. The requirements for labels assigned to
        #     Google Cloud resources may be found at
        #     https://cloud.google.com/resource-manager/docs/labels-overview#requirements
        # @!attribute [rw] tags
        #   @return [::Array<::Google::Cloud::DatabaseCenter::V1beta::Tag>]
        #     Tags applied on the resource. The requirements for tags assigned to
        #     Google Cloud resources may be found at
        #     https://cloud.google.com/resource-manager/docs/tags/tags-overview
        # @!attribute [rw] resource_type
        #   @return [::String]
        #     The type of resource defined according to the pattern:
        #     \\{Service Name}/\\{Type}. Ex:
        #     sqladmin.googleapis.com/Instance
        #     alloydb.googleapis.com/Cluster
        #     alloydb.googleapis.com/Instance
        #     spanner.googleapis.com/Instance
        # @!attribute [rw] sub_resource_type
        #   @return [::Google::Cloud::DatabaseCenter::V1beta::SubResourceType]
        #     Subtype of the resource specified at creation time.
        # @!attribute [rw] machine_config
        #   @return [::Google::Cloud::DatabaseCenter::V1beta::MachineConfig]
        #     Machine configuration like CPU, memory, etc for the resource.
        # @!attribute [rw] signal_groups
        #   @return [::Array<::Google::Cloud::DatabaseCenter::V1beta::SignalGroup>]
        #     The list of signal groups and count of issues related to the resource.
        #     Only those signals which have been requested would be included.
        # @!attribute [rw] metrics
        #   @return [::Google::Cloud::DatabaseCenter::V1beta::Metrics]
        #     Observable metrics for the resource e.g. CPU utilization, memory
        #     utilization, etc.
        # @!attribute [rw] resource_category
        #   @return [::Google::Cloud::DatabaseCenter::V1beta::ResourceCategory]
        #     The category of the resource.
        # @!attribute [rw] resource_name
        #   @return [::String]
        #     The name of the resource(The last part of the full resource name).
        #     Example:
        #     For full resource name -
        #     `//cloudsql.googleapis.com/projects/project-number/instances/mysql-1`,
        #     resource name - `mysql-1`
        #     For full resource name -
        #     `//cloudsql.googleapis.com/projects/project-number/instances/postgres-1` ,
        #     resource name - `postgres-1`
        #     Note: In some cases, there might be more than one resource with the same
        #     resource name.
        # @!attribute [rw] backupdr_config
        #   @return [::Google::Cloud::DatabaseCenter::V1beta::BackupDRConfig]
        #     Optional. Backup and disaster recovery details for the resource.
        # @!attribute [rw] edition
        #   @return [::Google::Cloud::DatabaseCenter::V1beta::Edition]
        #     The edition of the resource.
        # @!attribute [rw] maintenance_info
        #   @return [::Google::Cloud::DatabaseCenter::V1beta::MaintenanceInfo]
        #     Optional. The maintenance information of the resource.
        class DatabaseResource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Label is a key value pair applied to a resource.
        # @!attribute [rw] key
        #   @return [::String]
        #     The key part of the label.
        # @!attribute [rw] value
        #   @return [::String]
        #     The value part of the label.
        # @!attribute [rw] source
        #   @return [::String]
        #     The source of the Label. Source is empty if the label is directly attached
        #     to the resource and not inherited.
        class Label
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message to aggregate fleet which are grouped by a field.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent can be a project, a folder, or an organization. The search
        #     is limited to the resources within the `scope`.
        #
        #     The allowed values are:
        #
        #     * projects/\\{PROJECT_ID} (e.g., "projects/foo-bar")
        #     * projects/\\{PROJECT_NUMBER} (e.g., "projects/12345678")
        #     * folders/\\{FOLDER_NUMBER} (e.g., "folders/1234567")
        #     * organizations/\\{ORGANIZATION_NUMBER} (e.g.,
        #     "organizations/123456")
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. The expression to filter resources.
        #
        #     Supported fields are: `full_resource_name`, `resource_type`, `container`,
        #       `product.type`, `product.engine`, `product.version`, `location`,
        #       `labels`, `issues`, fields of availability_info, data_protection_info,
        #       'resource_name', etc.
        #
        #     The expression is a list of zero or more restrictions combined via logical
        #     operators `AND` and `OR`. When `AND` and `OR` are both used in the
        #     expression, parentheses must be appropriately used to group the
        #     combinations.
        #
        #     Example: location="us-east1"
        #     Example: container="projects/123" OR container="projects/456"
        #     Example: (container="projects/123" OR
        #               container="projects/456") AND location="us-east1"
        # @!attribute [rw] group_by
        #   @return [::String]
        #     Optional. A field that statistics are grouped by.
        #     Valid values are any combination of the following:
        #       * container
        #       * product.type
        #       * product.engine
        #       * product.version
        #       * location
        #       * sub_resource_type
        #       * management_type
        #       * tag.key
        #       * tag.value
        #       * tag.source
        #       * tag.inherited
        #       * label.key
        #       * label.value
        #       * label.source
        #       * has_maintenance_schedule
        #       * has_deny_maintenance_schedules
        #     Comma separated list.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Valid values to order by are:
        #       * resource_groups_count
        #       * resources_count
        #       * and all fields supported by `group_by`
        #     The default order is ascending. Add "DESC" after the field name to indicate
        #     descending order. Add "ASC" after the field name to indicate ascending
        #     order. It supports ordering using multiple fields.
        #     For example:
        #      order_by = "resource_groups_count" sorts response in ascending order
        #      order_by = "resource_groups_count DESC" sorts response in descending order
        #      order_by = "product.type, product.version DESC, location" orders by type
        #      in ascending order, version in descending order and location in ascending
        #      order
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. If unspecified, at most 50 items will be returned.
        #     The maximum value is 1000; values above 1000 will be coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous `AggregateFleet` call.
        #     Provide this to retrieve the subsequent page.
        #     All other parameters should match the parameters in the call that provided
        #     the page token except for page_size which can be different.
        # @!attribute [rw] baseline_date
        #   @return [::Google::Type::Date]
        #     Optional. The baseline date w.r.t. which the delta counts are calculated.
        #     If not set, delta counts are not included in the response and the response
        #     indicates the current state of the fleet.
        class AggregateFleetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response message to aggregate a fleet by some group by fields.
        # @!attribute [rw] rows
        #   @return [::Array<::Google::Cloud::DatabaseCenter::V1beta::AggregateFleetRow>]
        #     Represents a row grouped by the fields in the input.
        # @!attribute [rw] resource_groups_total_count
        #   @return [::Integer]
        #     Count of all resource groups in the fleet. This includes counts from all
        #     pages.
        # @!attribute [rw] resource_total_count
        #   @return [::Integer]
        #     Count of all resources in the fleet. This includes counts from all pages.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token that can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Unordered list. List of unreachable regions from where data could not be
        #     retrieved.
        class AggregateFleetResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Individual row grouped by a particular dimension.
        # @!attribute [rw] dimension
        #   @return [::Array<::Google::Cloud::DatabaseCenter::V1beta::Dimension>]
        #     Group by dimension.
        # @!attribute [rw] resource_groups_count
        #   @return [::Integer]
        #     Number of resource groups that have a particular dimension.
        # @!attribute [rw] resources_count
        #   @return [::Integer]
        #     Number of resources that have a particular dimension.
        # @!attribute [rw] delta_details
        #   @return [::Google::Cloud::DatabaseCenter::V1beta::DeltaDetails]
        #     Optional. Delta counts and details of resources which were added to/deleted
        #     from fleet.
        class AggregateFleetRow
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Dimension used to aggregate the fleet.
        # @!attribute [rw] container
        #   @return [::String]
        #     Specifies where the resource is created. For GCP, it is the full name of
        #     the project.
        #
        #     Note: The following fields are mutually exclusive: `container`, `product_type`, `product_engine`, `product_version`, `location`, `resource_type`, `sub_resource_type`, `resource_category`, `management_type`, `edition`, `tag_key`, `tag_value`, `tag_source`, `tag_inherited`, `label_key`, `label_value`, `label_source`, `has_maintenance_schedule`, `has_deny_maintenance_schedules`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] product_type
        #   @return [::Google::Cloud::DatabaseCenter::V1beta::ProductType]
        #     Type to identify a product
        #
        #     Note: The following fields are mutually exclusive: `product_type`, `container`, `product_engine`, `product_version`, `location`, `resource_type`, `sub_resource_type`, `resource_category`, `management_type`, `edition`, `tag_key`, `tag_value`, `tag_source`, `tag_inherited`, `label_key`, `label_value`, `label_source`, `has_maintenance_schedule`, `has_deny_maintenance_schedules`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] product_engine
        #   @return [::Google::Cloud::DatabaseCenter::V1beta::Engine]
        #     Engine refers to underlying database binary running in an instance.
        #
        #     Note: The following fields are mutually exclusive: `product_engine`, `container`, `product_type`, `product_version`, `location`, `resource_type`, `sub_resource_type`, `resource_category`, `management_type`, `edition`, `tag_key`, `tag_value`, `tag_source`, `tag_inherited`, `label_key`, `label_value`, `label_source`, `has_maintenance_schedule`, `has_deny_maintenance_schedules`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] product_version
        #   @return [::String]
        #     Version of the underlying database engine
        #
        #     Note: The following fields are mutually exclusive: `product_version`, `container`, `product_type`, `product_engine`, `location`, `resource_type`, `sub_resource_type`, `resource_category`, `management_type`, `edition`, `tag_key`, `tag_value`, `tag_source`, `tag_inherited`, `label_key`, `label_value`, `label_source`, `has_maintenance_schedule`, `has_deny_maintenance_schedules`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] location
        #   @return [::String]
        #     The location of the resources. It supports returning only regional
        #     locations in GCP.
        #
        #     Note: The following fields are mutually exclusive: `location`, `container`, `product_type`, `product_engine`, `product_version`, `resource_type`, `sub_resource_type`, `resource_category`, `management_type`, `edition`, `tag_key`, `tag_value`, `tag_source`, `tag_inherited`, `label_key`, `label_value`, `label_source`, `has_maintenance_schedule`, `has_deny_maintenance_schedules`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] resource_type
        #   @return [::String]
        #     The type of resource defined according to the pattern:
        #     \\{Service Name}/\\{Type}. Ex:
        #     sqladmin.googleapis.com/Instance
        #     alloydb.googleapis.com/Cluster
        #     alloydb.googleapis.com/Instance
        #     spanner.googleapis.com/Instance
        #
        #     Note: The following fields are mutually exclusive: `resource_type`, `container`, `product_type`, `product_engine`, `product_version`, `location`, `sub_resource_type`, `resource_category`, `management_type`, `edition`, `tag_key`, `tag_value`, `tag_source`, `tag_inherited`, `label_key`, `label_value`, `label_source`, `has_maintenance_schedule`, `has_deny_maintenance_schedules`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] sub_resource_type
        #   @return [::Google::Cloud::DatabaseCenter::V1beta::SubResourceType]
        #     Subtype of the resource specified at creation time.
        #
        #     Note: The following fields are mutually exclusive: `sub_resource_type`, `container`, `product_type`, `product_engine`, `product_version`, `location`, `resource_type`, `resource_category`, `management_type`, `edition`, `tag_key`, `tag_value`, `tag_source`, `tag_inherited`, `label_key`, `label_value`, `label_source`, `has_maintenance_schedule`, `has_deny_maintenance_schedules`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] resource_category
        #   @return [::Google::Cloud::DatabaseCenter::V1beta::ResourceCategory]
        #     The category of the resource.
        #
        #     Note: The following fields are mutually exclusive: `resource_category`, `container`, `product_type`, `product_engine`, `product_version`, `location`, `resource_type`, `sub_resource_type`, `management_type`, `edition`, `tag_key`, `tag_value`, `tag_source`, `tag_inherited`, `label_key`, `label_value`, `label_source`, `has_maintenance_schedule`, `has_deny_maintenance_schedules`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] management_type
        #   @return [::Google::Cloud::DatabaseCenter::V1beta::ManagementType]
        #     The management type of the resource.
        #
        #     Note: The following fields are mutually exclusive: `management_type`, `container`, `product_type`, `product_engine`, `product_version`, `location`, `resource_type`, `sub_resource_type`, `resource_category`, `edition`, `tag_key`, `tag_value`, `tag_source`, `tag_inherited`, `label_key`, `label_value`, `label_source`, `has_maintenance_schedule`, `has_deny_maintenance_schedules`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] edition
        #   @return [::Google::Cloud::DatabaseCenter::V1beta::Edition]
        #     The edition of the resource.
        #
        #     Note: The following fields are mutually exclusive: `edition`, `container`, `product_type`, `product_engine`, `product_version`, `location`, `resource_type`, `sub_resource_type`, `resource_category`, `management_type`, `tag_key`, `tag_value`, `tag_source`, `tag_inherited`, `label_key`, `label_value`, `label_source`, `has_maintenance_schedule`, `has_deny_maintenance_schedules`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] tag_key
        #   @return [::String]
        #     Tag key of the resource.
        #
        #     Note: The following fields are mutually exclusive: `tag_key`, `container`, `product_type`, `product_engine`, `product_version`, `location`, `resource_type`, `sub_resource_type`, `resource_category`, `management_type`, `edition`, `tag_value`, `tag_source`, `tag_inherited`, `label_key`, `label_value`, `label_source`, `has_maintenance_schedule`, `has_deny_maintenance_schedules`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] tag_value
        #   @return [::String]
        #     Tag value of the resource.
        #
        #     Note: The following fields are mutually exclusive: `tag_value`, `container`, `product_type`, `product_engine`, `product_version`, `location`, `resource_type`, `sub_resource_type`, `resource_category`, `management_type`, `edition`, `tag_key`, `tag_source`, `tag_inherited`, `label_key`, `label_value`, `label_source`, `has_maintenance_schedule`, `has_deny_maintenance_schedules`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] tag_source
        #   @return [::String]
        #     Tag source of the resource.
        #
        #     Note: The following fields are mutually exclusive: `tag_source`, `container`, `product_type`, `product_engine`, `product_version`, `location`, `resource_type`, `sub_resource_type`, `resource_category`, `management_type`, `edition`, `tag_key`, `tag_value`, `tag_inherited`, `label_key`, `label_value`, `label_source`, `has_maintenance_schedule`, `has_deny_maintenance_schedules`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] tag_inherited
        #   @return [::Boolean]
        #     Tag inheritance value of the resource.
        #
        #     Note: The following fields are mutually exclusive: `tag_inherited`, `container`, `product_type`, `product_engine`, `product_version`, `location`, `resource_type`, `sub_resource_type`, `resource_category`, `management_type`, `edition`, `tag_key`, `tag_value`, `tag_source`, `label_key`, `label_value`, `label_source`, `has_maintenance_schedule`, `has_deny_maintenance_schedules`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] label_key
        #   @return [::String]
        #     Label key of the resource.
        #
        #     Note: The following fields are mutually exclusive: `label_key`, `container`, `product_type`, `product_engine`, `product_version`, `location`, `resource_type`, `sub_resource_type`, `resource_category`, `management_type`, `edition`, `tag_key`, `tag_value`, `tag_source`, `tag_inherited`, `label_value`, `label_source`, `has_maintenance_schedule`, `has_deny_maintenance_schedules`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] label_value
        #   @return [::String]
        #     Label value of the resource.
        #
        #     Note: The following fields are mutually exclusive: `label_value`, `container`, `product_type`, `product_engine`, `product_version`, `location`, `resource_type`, `sub_resource_type`, `resource_category`, `management_type`, `edition`, `tag_key`, `tag_value`, `tag_source`, `tag_inherited`, `label_key`, `label_source`, `has_maintenance_schedule`, `has_deny_maintenance_schedules`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] label_source
        #   @return [::String]
        #     Label source of the resource.
        #
        #     Note: The following fields are mutually exclusive: `label_source`, `container`, `product_type`, `product_engine`, `product_version`, `location`, `resource_type`, `sub_resource_type`, `resource_category`, `management_type`, `edition`, `tag_key`, `tag_value`, `tag_source`, `tag_inherited`, `label_key`, `label_value`, `has_maintenance_schedule`, `has_deny_maintenance_schedules`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] has_maintenance_schedule
        #   @return [::Boolean]
        #     Whether the resource has a maintenance schedule.
        #
        #     Note: The following fields are mutually exclusive: `has_maintenance_schedule`, `container`, `product_type`, `product_engine`, `product_version`, `location`, `resource_type`, `sub_resource_type`, `resource_category`, `management_type`, `edition`, `tag_key`, `tag_value`, `tag_source`, `tag_inherited`, `label_key`, `label_value`, `label_source`, `has_deny_maintenance_schedules`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] has_deny_maintenance_schedules
        #   @return [::Boolean]
        #     Whether the resource has deny maintenance schedules.
        #
        #     Note: The following fields are mutually exclusive: `has_deny_maintenance_schedules`, `container`, `product_type`, `product_engine`, `product_version`, `location`, `resource_type`, `sub_resource_type`, `resource_category`, `management_type`, `edition`, `tag_key`, `tag_value`, `tag_source`, `tag_inherited`, `label_key`, `label_value`, `label_source`, `has_maintenance_schedule`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class Dimension
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # BackupDRConfig to capture the backup and disaster recovery details of
        # database resource.
        # @!attribute [rw] backupdr_managed
        #   @return [::Boolean]
        #     Indicates if the resource is managed by BackupDR.
        class BackupDRConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Tag is a key value pair attached to a resource.
        # @!attribute [rw] key
        #   @return [::String]
        # @!attribute [rw] value
        #   @return [::String]
        #     The value part of the tag.
        # @!attribute [rw] source
        #   @return [::String]
        #     The source of the tag. According to
        #     https://cloud.google.com/resource-manager/docs/tags/tags-overview#tags_and_labels,
        #     tags can be created only at the project or organization level. Tags can be
        #     inherited from different project as well not just the current project where
        #     the database resource is present.
        #     Format:
        #     "projects/\\{PROJECT_ID}",
        #     "projects/\\{PROJECT_NUMBER}",
        #     "organizations/\\{ORGANIZATION_ID}"
        # @!attribute [rw] inherited
        #   @return [::Boolean]
        #     Indicates the inheritance status of a tag value
        #     attached to the given resource. If the tag value is inherited from one of
        #     the resource's ancestors, inherited will be true. If false, then the tag
        #     value is directly attached to the resource.
        class Tag
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Capture the resource details for resources that are included in the delta
        # counts.
        # @!attribute [rw] full_resource_name
        #   @return [::String]
        #     Full resource name of the resource.
        # @!attribute [rw] container
        #   @return [::String]
        #     Specifies where the resource is created. For GCP, it is the full name of
        #     the project.
        # @!attribute [rw] product
        #   @return [::Google::Cloud::DatabaseCenter::V1beta::Product]
        #     Product type of the resource.
        # @!attribute [rw] location
        #   @return [::String]
        #     Location of the resource.
        class ResourceDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Captures the details of items that have increased or decreased in some bucket
        # when compared to some point in history.
        # It is currently used to capture the delta of resources that have been added
        # or removed in the fleet as well as to capture the resources that have a
        # change in Issue/Signal status.
        # @!attribute [rw] increased_resources
        #   @return [::Array<::Google::Cloud::DatabaseCenter::V1beta::ResourceDetails>]
        #     Details of resources that have increased.
        # @!attribute [rw] decreased_resources
        #   @return [::Array<::Google::Cloud::DatabaseCenter::V1beta::ResourceDetails>]
        #     Details of resources that have decreased.
        class DeltaDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The enum value corresponds to 'type' suffix in the resource_type field.
        module ResourceCategory
          # Unspecified.
          RESOURCE_CATEGORY_UNSPECIFIED = 0

          # A resource that is an Instance.
          INSTANCE = 1

          # A resource that is a Cluster.
          CLUSTER = 2

          # A resource that is a Database.
          DATABASE = 3
        end

        # Proto representing the edition of the instance.
        # NextId: 4.
        module Edition
          # Default, to make it consistent with instance edition enum.
          EDITION_UNSPECIFIED = 0

          # Represents the enterprise edition.
          EDITION_ENTERPRISE = 1

          # Represents the enterprise plus edition.
          EDITION_ENTERPRISE_PLUS = 2

          # Represents the standard edition.
          EDITION_STANDARD = 3
        end

        # SubResourceType refers to the sub-type of database resource.
        module SubResourceType
          # Unspecified.
          SUB_RESOURCE_TYPE_UNSPECIFIED = 0

          # A resource acting as a primary.
          SUB_RESOURCE_TYPE_PRIMARY = 1

          # A resource acting as a secondary.
          SUB_RESOURCE_TYPE_SECONDARY = 2

          # A resource acting as a read-replica.
          SUB_RESOURCE_TYPE_READ_REPLICA = 3

          # A resource acting as an external primary.
          SUB_RESOURCE_TYPE_EXTERNAL_PRIMARY = 5

          # For the rest of the categories.
          SUB_RESOURCE_TYPE_OTHER = 4
        end

        # The management type of the resource.
        module ManagementType
          # Unspecified.
          MANAGEMENT_TYPE_UNSPECIFIED = 0

          # Google-managed resource.
          MANAGEMENT_TYPE_GCP_MANAGED = 1

          # Self-managed resource.
          MANAGEMENT_TYPE_SELF_MANAGED = 2
        end
      end
    end
  end
end
