# frozen_string_literal: true

# Copyright 2026 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DatabaseCenter
      module V1beta
        # Product specification for databasecenter resources.
        # @!attribute [rw] type
        #   @return [::Google::Cloud::DatabaseCenter::V1beta::ProductType]
        #     Optional. Type of specific database product. It could be CloudSQL, AlloyDB
        #     etc..
        # @!attribute [rw] engine
        #   @return [::Google::Cloud::DatabaseCenter::V1beta::Engine]
        #     Optional. The specific engine that the underlying database is running.
        # @!attribute [rw] version
        #   @return [::String]
        #     Optional. Version of the underlying database engine. Example values: For
        #     MySQL, it could be "8.0", "5.7" etc. For Postgres, it could be "14", "15"
        #     etc.
        # @!attribute [rw] minor_version
        #   @return [::String]
        #     Optional. Minor version of the underlying database engine. Example values:
        #     For MySQL, it could be "8.0.35", "5.7.25" etc. For PostgreSQL, it could be
        #     "14.4", "15.5" etc.
        class Product
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Engine refers to underlying database binary running in an instance.
        module Engine
          # UNSPECIFIED means engine type is not known or available.
          ENGINE_UNSPECIFIED = 0

          # MySQL binary running as an engine in the database instance.
          ENGINE_MYSQL = 1

          # Postgres binary running as engine in database instance.
          ENGINE_POSTGRES = 2

          # SQLServer binary running as engine in database instance.
          ENGINE_SQL_SERVER = 3

          # Native database binary running as engine in instance.
          ENGINE_NATIVE = 4

          # Memorystore with Redis dialect.
          ENGINE_MEMORYSTORE_FOR_REDIS = 8

          # Memorystore with Redis cluster dialect.
          ENGINE_MEMORYSTORE_FOR_REDIS_CLUSTER = 9

          # Firestore with native mode.
          ENGINE_FIRESTORE_WITH_NATIVE_MODE = 10

          # Firestore with datastore mode.
          ENGINE_FIRESTORE_WITH_DATASTORE_MODE = 11

          # Oracle Exadata engine.
          ENGINE_EXADATA_ORACLE = 12

          # Oracle Autonomous DB Serverless engine.
          ENGINE_ADB_SERVERLESS_ORACLE = 13

          # Firestore with MongoDB compatibility.
          ENGINE_FIRESTORE_WITH_MONGODB_COMPATIBILITY_MODE = 14

          # Other refers to rest of other database engine. This is to be when engine is
          # known, but it is not present in this enum.
          ENGINE_OTHER = 6
        end

        # ProductType is used to identify a database service offering either in a cloud
        # provider or on-premise. This enum needs to be updated whenever we introduce
        # a new ProductType.
        module ProductType
          # PRODUCT_TYPE_UNSPECIFIED means product type is not known or that the user
          # didn't provide this field in the request.
          PRODUCT_TYPE_UNSPECIFIED = 0

          # Cloud SQL product area in GCP
          PRODUCT_TYPE_CLOUD_SQL = 1

          # AlloyDB product area in GCP
          PRODUCT_TYPE_ALLOYDB = 2

          # Spanner product area in GCP
          PRODUCT_TYPE_SPANNER = 3

          # Bigtable product area in GCP
          PRODUCT_TYPE_BIGTABLE = 6

          # Memorystore product area in GCP
          PRODUCT_TYPE_MEMORYSTORE = 7

          # Firestore product area in GCP
          PRODUCT_TYPE_FIRESTORE = 8

          # Compute Engine self managed databases
          PRODUCT_TYPE_COMPUTE_ENGINE = 9

          # Oracle product area in GCP
          PRODUCT_TYPE_ORACLE_ON_GCP = 10

          # BigQuery product area in GCP
          PRODUCT_TYPE_BIGQUERY = 11

          # Other refers to rest of other product type. This is to be when product type
          # is known, but it is not present in this enum.
          PRODUCT_TYPE_OTHER = 5
        end
      end
    end
  end
end
