# frozen_string_literal: true

# Copyright 2026 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DatabaseCenter
      module V1beta
        # Metrics represents the metrics for a database resource.
        # @!attribute [rw] p99_cpu_utilization
        #   @return [::Google::Cloud::DatabaseCenter::V1beta::MetricData]
        #     P99 CPU utilization observed for the resource. The value is a
        #     fraction between 0.0 and 1.0 (may momentarily exceed 1.0 in some cases).
        # @!attribute [rw] p95_cpu_utilization
        #   @return [::Google::Cloud::DatabaseCenter::V1beta::MetricData]
        #     P95 CPU utilization observed for the resource. The value is a
        #     fraction between 0.0 and 1.0 (may momentarily exceed 1.0 in some cases).
        # @!attribute [rw] current_storage_used_bytes
        #   @return [::Google::Cloud::DatabaseCenter::V1beta::MetricData]
        #     Current storage used by the resource in bytes.
        # @!attribute [rw] peak_storage_utilization
        #   @return [::Google::Cloud::DatabaseCenter::V1beta::MetricData]
        #     Peak storage utilization observed for the resource. The value is a
        #     fraction between 0.0 and 1.0 (may momentarily exceed 1.0 in some cases).
        # @!attribute [rw] peak_memory_utilization
        #   @return [::Google::Cloud::DatabaseCenter::V1beta::MetricData]
        #     Peak memory utilization observed for the resource. The value is a
        #     fraction between 0.0 and 1.0 (may momentarily exceed 1.0 in some cases).
        # @!attribute [rw] peak_number_connections
        #   @return [::Google::Cloud::DatabaseCenter::V1beta::MetricData]
        #     Peak number of connections observed for the resource. The value is a
        #     positive integer.
        # @!attribute [rw] node_count
        #   @return [::Google::Cloud::DatabaseCenter::V1beta::MetricData]
        #     Number of nodes in instance for spanner or bigtable.
        # @!attribute [rw] processing_unit_count
        #   @return [::Google::Cloud::DatabaseCenter::V1beta::MetricData]
        #     Number of processing units in spanner.
        # @!attribute [rw] current_memory_used_bytes
        #   @return [::Google::Cloud::DatabaseCenter::V1beta::MetricData]
        #     Current memory used by the resource in bytes.
        class Metrics
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # MetricData represents the metric data for a database resource.
        # @!attribute [rw] value
        #   @return [::Google::Cloud::DatabaseCenter::V1beta::TypedValue]
        #     The value associated with the metric.
        # @!attribute [rw] observation_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time the metric was observed in the metric source service.
        class MetricData
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # TypedValue represents the value of the metric based on data type.
        # @!attribute [rw] double_value
        #   @return [::Float]
        #     The value of the metric as double.
        #
        #     Note: The following fields are mutually exclusive: `double_value`, `int64_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] int64_value
        #   @return [::Integer]
        #     The value of the metric as int.
        #
        #     Note: The following fields are mutually exclusive: `int64_value`, `double_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class TypedValue
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
