# frozen_string_literal: true

# Copyright 2026 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DatabaseCenter
      module V1beta
        # Maintenance window for the database resource. It specifies preferred time
        # and day of the week and phase in some cases, when the maintenance can start.
        # @!attribute [rw] start_time
        #   @return [::Google::Type::TimeOfDay]
        #     Optional. Preferred time to start the maintenance operation on the
        #     specified day.
        # @!attribute [rw] day
        #   @return [::Google::Type::DayOfWeek]
        #     Optional. Preferred day of the week for maintenance, e.g. MONDAY, TUESDAY,
        #     etc.
        # @!attribute [rw] phase
        #   @return [::Google::Cloud::DatabaseCenter::V1beta::Phase]
        #     Optional. Phase of the maintenance window. This is to capture order of
        #     maintenance. For example, for Cloud SQL resources, this can be used to
        #     capture if the maintenance window is in Week1, Week2, Week5, etc. Non
        #     production resources are usually part of early phase.
        #     For more details, refer to Cloud SQL resources -
        #     https://cloud.google.com/sql/docs/mysql/maintenance
        class ResourceMaintenanceSchedule
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Deny maintenance period for the database resource. It specifies the time
        # range during which the maintenance cannot start. This is configured by the
        # customer.
        # @!attribute [rw] start_date
        #   @return [::Google::Type::Date]
        #     Optional. The start date of the deny maintenance period.
        # @!attribute [rw] end_date
        #   @return [::Google::Type::Date]
        #     Optional. Deny period end date.
        # @!attribute [rw] time
        #   @return [::Google::Type::TimeOfDay]
        #     Optional. Time in UTC when the deny period starts on start_date and ends on
        #     end_date.
        class ResourceMaintenanceDenySchedule
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # MaintenanceInfo to capture the maintenance details of database resource.
        # @!attribute [rw] maintenance_schedule
        #   @return [::Google::Cloud::DatabaseCenter::V1beta::ResourceMaintenanceSchedule]
        #     Optional. Maintenance window for the database resource.
        # @!attribute [rw] deny_maintenance_schedules
        #   @return [::Array<::Google::Cloud::DatabaseCenter::V1beta::ResourceMaintenanceDenySchedule>]
        #     Optional. List of Deny maintenance period for the database resource.
        # @!attribute [rw] maintenance_version
        #   @return [::String]
        #     Optional. Current Maintenance version of the database resource. Example:
        #     "MYSQL_8_0_41.R20250531.01_15"
        class MaintenanceInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Phase/Week of the maintenance window. This is to capture order of
        # maintenance. For example, for Cloud SQL resources -
        # https://cloud.google.com/sql/docs/mysql/maintenance.
        # This enum can be extended to support DB Center specific phases for
        # recommendation plan generation.
        module Phase
          # Phase is unspecified.
          PHASE_UNSPECIFIED = 0

          # Week 1.
          PHASE_WEEK1 = 1

          # Week 2.
          PHASE_WEEK2 = 2

          # Week 5.
          PHASE_WEEK5 = 3

          # Any phase.
          PHASE_ANY = 4
        end
      end
    end
  end
end
