# frozen_string_literal: true

# Copyright 2026 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/databasecenter/v1beta/service_pb"

module Google
  module Cloud
    module DatabaseCenter
      module V1beta
        module DatabaseCenter
          ##
          # Client for the DatabaseCenter service.
          #
          # DatabaseCenter contains methods to query fleet view for database resources.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "databasecenter.$UNIVERSE_DOMAIN$"

            # @private
            attr_reader :database_center_stub

            ##
            # Configure the DatabaseCenter Client class.
            #
            # See {::Google::Cloud::DatabaseCenter::V1beta::DatabaseCenter::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all DatabaseCenter clients
            #   ::Google::Cloud::DatabaseCenter::V1beta::DatabaseCenter::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "DatabaseCenter", "V1beta"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the DatabaseCenter Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::DatabaseCenter::V1beta::DatabaseCenter::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @database_center_stub.universe_domain
            end

            ##
            # Create a new DatabaseCenter client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::DatabaseCenter::V1beta::DatabaseCenter::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::DatabaseCenter::V1beta::DatabaseCenter::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the DatabaseCenter client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/databasecenter/v1beta/service_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @database_center_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::DatabaseCenter::V1beta::DatabaseCenter::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @database_center_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end
            end

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @database_center_stub.logger
            end

            # Service calls

            ##
            # QueryProducts provides a list of all possible products which can be used to
            # filter database resources.
            #
            # @overload query_products(request, options = nil)
            #   Pass arguments to `query_products` via a request object, either of type
            #   {::Google::Cloud::DatabaseCenter::V1beta::QueryProductsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DatabaseCenter::V1beta::QueryProductsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload query_products(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `query_products` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Parent can be a project, a folder, or an organization.
            #
            #     The allowed values are:
            #
            #     * projects/\\{PROJECT_ID}/locations/\\{LOCATION}
            #     (e.g.,"projects/foo-bar/locations/us-central1")
            #     * projects/\\{PROJECT_NUMBER}/locations/\\{LOCATION}
            #     (e.g.,"projects/12345678/locations/us-central1")
            #     * folders/\\{FOLDER_NUMBER}/locations/\\{LOCATION}
            #     (e.g.,"folders/1234567/locations/us-central1")
            #     * organizations/\\{ORGANIZATION_NUMBER}/locations/\\{LOCATION}
            #     (e.g.,"organizations/123456/locations/us-central1")
            #     * projects/\\{PROJECT_ID} (e.g., "projects/foo-bar")
            #     * projects/\\{PROJECT_NUMBER} (e.g., "projects/12345678")
            #     * folders/\\{FOLDER_NUMBER} (e.g., "folders/1234567")
            #     * organizations/\\{ORGANIZATION_NUMBER} (e.g., "organizations/123456")
            #   @param page_size [::Integer]
            #     Optional. If unspecified, at most 50 products will be returned.
            #     The maximum value is 1000; values above 1000 will be coerced to 1000.
            #   @param page_token [::String]
            #     Optional. A page token, received from a previous `ListLocations` call.
            #     Provide this to retrieve the subsequent page.
            #     All other parameters except page size should match the call that provided
            #     the page page token.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::DatabaseCenter::V1beta::Product>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::DatabaseCenter::V1beta::Product>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/database_center/v1beta"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DatabaseCenter::V1beta::DatabaseCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DatabaseCenter::V1beta::QueryProductsRequest.new
            #
            #   # Call the query_products method.
            #   result = client.query_products request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::DatabaseCenter::V1beta::Product.
            #     p item
            #   end
            #
            def query_products request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DatabaseCenter::V1beta::QueryProductsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.query_products.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DatabaseCenter::V1beta::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              options.apply_defaults timeout:      @config.rpcs.query_products.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.query_products.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @database_center_stub.call_rpc :query_products, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @database_center_stub, :query_products, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # AggregateFleet provides statistics about the fleet grouped by various
            # fields.
            #
            # @overload aggregate_fleet(request, options = nil)
            #   Pass arguments to `aggregate_fleet` via a request object, either of type
            #   {::Google::Cloud::DatabaseCenter::V1beta::AggregateFleetRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DatabaseCenter::V1beta::AggregateFleetRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload aggregate_fleet(parent: nil, filter: nil, group_by: nil, order_by: nil, page_size: nil, page_token: nil, baseline_date: nil)
            #   Pass arguments to `aggregate_fleet` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Parent can be a project, a folder, or an organization. The search
            #     is limited to the resources within the `scope`.
            #
            #     The allowed values are:
            #
            #     * projects/\\{PROJECT_ID} (e.g., "projects/foo-bar")
            #     * projects/\\{PROJECT_NUMBER} (e.g., "projects/12345678")
            #     * folders/\\{FOLDER_NUMBER} (e.g., "folders/1234567")
            #     * organizations/\\{ORGANIZATION_NUMBER} (e.g.,
            #     "organizations/123456")
            #   @param filter [::String]
            #     Optional. The expression to filter resources.
            #
            #     Supported fields are: `full_resource_name`, `resource_type`, `container`,
            #       `product.type`, `product.engine`, `product.version`, `location`,
            #       `labels`, `issues`, fields of availability_info, data_protection_info,
            #       'resource_name', etc.
            #
            #     The expression is a list of zero or more restrictions combined via logical
            #     operators `AND` and `OR`. When `AND` and `OR` are both used in the
            #     expression, parentheses must be appropriately used to group the
            #     combinations.
            #
            #     Example: location="us-east1"
            #     Example: container="projects/123" OR container="projects/456"
            #     Example: (container="projects/123" OR
            #               container="projects/456") AND location="us-east1"
            #   @param group_by [::String]
            #     Optional. A field that statistics are grouped by.
            #     Valid values are any combination of the following:
            #       * container
            #       * product.type
            #       * product.engine
            #       * product.version
            #       * location
            #       * sub_resource_type
            #       * management_type
            #       * tag.key
            #       * tag.value
            #       * tag.source
            #       * tag.inherited
            #       * label.key
            #       * label.value
            #       * label.source
            #       * has_maintenance_schedule
            #       * has_deny_maintenance_schedules
            #     Comma separated list.
            #   @param order_by [::String]
            #     Optional. Valid values to order by are:
            #       * resource_groups_count
            #       * resources_count
            #       * and all fields supported by `group_by`
            #     The default order is ascending. Add "DESC" after the field name to indicate
            #     descending order. Add "ASC" after the field name to indicate ascending
            #     order. It supports ordering using multiple fields.
            #     For example:
            #      order_by = "resource_groups_count" sorts response in ascending order
            #      order_by = "resource_groups_count DESC" sorts response in descending order
            #      order_by = "product.type, product.version DESC, location" orders by type
            #      in ascending order, version in descending order and location in ascending
            #      order
            #   @param page_size [::Integer]
            #     Optional. If unspecified, at most 50 items will be returned.
            #     The maximum value is 1000; values above 1000 will be coerced to 1000.
            #   @param page_token [::String]
            #     Optional. A page token, received from a previous `AggregateFleet` call.
            #     Provide this to retrieve the subsequent page.
            #     All other parameters should match the parameters in the call that provided
            #     the page token except for page_size which can be different.
            #   @param baseline_date [::Google::Type::Date, ::Hash]
            #     Optional. The baseline date w.r.t. which the delta counts are calculated.
            #     If not set, delta counts are not included in the response and the response
            #     indicates the current state of the fleet.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::DatabaseCenter::V1beta::AggregateFleetRow>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::DatabaseCenter::V1beta::AggregateFleetRow>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/database_center/v1beta"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DatabaseCenter::V1beta::DatabaseCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DatabaseCenter::V1beta::AggregateFleetRequest.new
            #
            #   # Call the aggregate_fleet method.
            #   result = client.aggregate_fleet request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::DatabaseCenter::V1beta::AggregateFleetRow.
            #     p item
            #   end
            #
            def aggregate_fleet request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DatabaseCenter::V1beta::AggregateFleetRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.aggregate_fleet.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DatabaseCenter::V1beta::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              options.apply_defaults timeout:      @config.rpcs.aggregate_fleet.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.aggregate_fleet.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @database_center_stub.call_rpc :aggregate_fleet, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @database_center_stub, :aggregate_fleet, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # QueryDatabaseResourceGroups returns paginated results of database groups.
            #
            # @overload query_database_resource_groups(request, options = nil)
            #   Pass arguments to `query_database_resource_groups` via a request object, either of type
            #   {::Google::Cloud::DatabaseCenter::V1beta::QueryDatabaseResourceGroupsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DatabaseCenter::V1beta::QueryDatabaseResourceGroupsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload query_database_resource_groups(parent: nil, filter: nil, signal_type_groups: nil, signal_filters: nil, order_by: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `query_database_resource_groups` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Parent can be a project, a folder, or an organization. The search
            #     is limited to the resources within the `scope`.
            #
            #     The allowed values are:
            #
            #     * projects/\\{PROJECT_ID} (e.g., "projects/foo-bar")
            #     * projects/\\{PROJECT_NUMBER} (e.g., "projects/12345678")
            #     * folders/\\{FOLDER_NUMBER} (e.g., "folders/1234567")
            #     * organizations/\\{ORGANIZATION_NUMBER} (e.g., "organizations/123456")
            #   @param filter [::String]
            #     Optional. The expression to filter resources.
            #
            #     The following fields are filterable:
            #       * full_resource_name
            #       * resource_type
            #       * container
            #       * product.type
            #       * product.engine
            #       * product.version
            #       * location
            #       * labels
            #       * resource_category
            #       * machine_config.cpu_count
            #       * machine_config.memory_size_bytes
            #       * machine_config.shard_count
            #       * resource_name
            #       * tags
            #       * backupdr_config.backupdr_managed
            #       * edition
            #
            #     The expression is a list of zero or more restrictions combined via logical
            #     operators `AND` and `OR`. When `AND` and `OR` are both used in the
            #     expression, parentheses must be appropriately used to group the
            #     combinations.
            #
            #     Example: location="us-east1"
            #     Example: container="projects/123" OR container="projects/456"
            #     Example: (container="projects/123" OR
            #               container="projects/456") AND location="us-east1"
            #     Example: full_resource_name=~"test"
            #     Example: full_resource_name=~"test.*master"
            #   @param signal_type_groups [::Array<::Google::Cloud::DatabaseCenter::V1beta::SignalTypeGroup, ::Hash>]
            #     Optional. Groups of signal types that are requested.
            #   @param signal_filters [::Array<::Google::Cloud::DatabaseCenter::V1beta::SignalFilter, ::Hash>]
            #     Optional. Filters based on signals. The list will be ORed together and then
            #     ANDed with the `filters` field above.
            #   @param order_by [::String]
            #     Optional. A field that specifies the sort order of the results.
            #
            #     The following fields are sortable:
            #       * full_resource_name
            #       * product.type
            #       * product.engine
            #       * product.version
            #       * container
            #       * issue_count
            #       * machine_config.vcpu_count
            #       * machine_config.memory_size_bytes
            #       * machine_config.shard_count
            #       * resource_name
            #       * issue_severity
            #       * signal_type
            #       * location
            #       * resource_type
            #       * instance_type
            #       * edition
            #       * metrics.p99_cpu_utilization
            #       * metrics.p95_cpu_utilization
            #       * metrics.current_storage_used_bytes
            #       * metrics.node_count
            #       * metrics.processing_unit_count
            #       * metrics.current_memory_used_bytes
            #       * metrics.peak_storage_utilization
            #       * metrics.peak_number_connections
            #       * metrics.peak_memory_utilization
            #
            #     The default order is ascending. Add "DESC" after the field name to indicate
            #     descending order. Add "ASC" after the field name to indicate ascending
            #     order. It only supports a single field at a time.
            #
            #     For example:
            #      order_by = "full_resource_name" sorts response in ascending order
            #      order_by = "full_resource_name DESC" sorts response in descending order
            #      order_by = "issue_count DESC" sorts response in descending order of
            #      count of all issues associated with a resource.
            #
            #     More explicitly, order_by = "full_resource_name, product" is not supported.
            #   @param page_size [::Integer]
            #     Optional. If unspecified, at most 50 resource groups will be returned.
            #     The maximum value is 1000; values above 1000 will be coerced to 1000.
            #   @param page_token [::String]
            #     Optional. A page token, received from a previous
            #     `QueryDatabaseResourceGroupsRequest` call. Provide this to retrieve the
            #     subsequent page. All parameters except page_token should match the
            #     parameters in the call that provided the page page token.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::DatabaseCenter::V1beta::DatabaseResourceGroup>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::DatabaseCenter::V1beta::DatabaseResourceGroup>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/database_center/v1beta"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DatabaseCenter::V1beta::DatabaseCenter::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DatabaseCenter::V1beta::QueryDatabaseResourceGroupsRequest.new
            #
            #   # Call the query_database_resource_groups method.
            #   result = client.query_database_resource_groups request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::DatabaseCenter::V1beta::DatabaseResourceGroup.
            #     p item
            #   end
            #
            def query_database_resource_groups request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DatabaseCenter::V1beta::QueryDatabaseResourceGroupsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.query_database_resource_groups.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DatabaseCenter::V1beta::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              options.apply_defaults timeout:      @config.rpcs.query_database_resource_groups.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.query_database_resource_groups.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @database_center_stub.call_rpc :query_database_resource_groups, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @database_center_stub, :query_database_resource_groups, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the DatabaseCenter API.
            #
            # This class represents the configuration for DatabaseCenter,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::DatabaseCenter::V1beta::DatabaseCenter::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # query_products to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::DatabaseCenter::V1beta::DatabaseCenter::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.query_products.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::DatabaseCenter::V1beta::DatabaseCenter::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.query_products.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::DatabaseCenter::V1beta::DatabaseCenter::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "databasecenter.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the DatabaseCenter API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `query_products`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :query_products
                ##
                # RPC-specific configuration for `aggregate_fleet`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :aggregate_fleet
                ##
                # RPC-specific configuration for `query_database_resource_groups`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :query_database_resource_groups

                # @private
                def initialize parent_rpcs = nil
                  query_products_config = parent_rpcs.query_products if parent_rpcs.respond_to? :query_products
                  @query_products = ::Gapic::Config::Method.new query_products_config
                  aggregate_fleet_config = parent_rpcs.aggregate_fleet if parent_rpcs.respond_to? :aggregate_fleet
                  @aggregate_fleet = ::Gapic::Config::Method.new aggregate_fleet_config
                  query_database_resource_groups_config = parent_rpcs.query_database_resource_groups if parent_rpcs.respond_to? :query_database_resource_groups
                  @query_database_resource_groups = ::Gapic::Config::Method.new query_database_resource_groups_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
