# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/datalabeling/v1beta1/data_labeling_service_pb"
require "google/cloud/data_labeling/v1beta1/data_labeling_service"

class ::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_dataset
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DataLabeling::V1beta1::Dataset.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    dataset = {}

    create_dataset_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_dataset, name
      assert_kind_of ::Google::Cloud::DataLabeling::V1beta1::CreateDatasetRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::DataLabeling::V1beta1::Dataset), request["dataset"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_dataset_client_stub do
      # Create client
      client = ::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_dataset({ parent: parent, dataset: dataset }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_dataset parent: parent, dataset: dataset do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_dataset ::Google::Cloud::DataLabeling::V1beta1::CreateDatasetRequest.new(parent: parent, dataset: dataset) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_dataset({ parent: parent, dataset: dataset }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_dataset(::Google::Cloud::DataLabeling::V1beta1::CreateDatasetRequest.new(parent: parent, dataset: dataset), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_dataset_client_stub.call_rpc_count
    end
  end

  def test_get_dataset
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DataLabeling::V1beta1::Dataset.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_dataset_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_dataset, name
      assert_kind_of ::Google::Cloud::DataLabeling::V1beta1::GetDatasetRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_dataset_client_stub do
      # Create client
      client = ::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_dataset({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_dataset name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_dataset ::Google::Cloud::DataLabeling::V1beta1::GetDatasetRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_dataset({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_dataset(::Google::Cloud::DataLabeling::V1beta1::GetDatasetRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_dataset_client_stub.call_rpc_count
    end
  end

  def test_list_datasets
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DataLabeling::V1beta1::ListDatasetsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"

    list_datasets_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_datasets, name
      assert_kind_of ::Google::Cloud::DataLabeling::V1beta1::ListDatasetsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["filter"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_datasets_client_stub do
      # Create client
      client = ::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_datasets({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_datasets parent: parent, filter: filter, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_datasets ::Google::Cloud::DataLabeling::V1beta1::ListDatasetsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_datasets({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_datasets(::Google::Cloud::DataLabeling::V1beta1::ListDatasetsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_datasets_client_stub.call_rpc_count
    end
  end

  def test_delete_dataset
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_dataset_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_dataset, name
      assert_kind_of ::Google::Cloud::DataLabeling::V1beta1::DeleteDatasetRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_dataset_client_stub do
      # Create client
      client = ::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_dataset({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_dataset name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_dataset ::Google::Cloud::DataLabeling::V1beta1::DeleteDatasetRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_dataset({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_dataset(::Google::Cloud::DataLabeling::V1beta1::DeleteDatasetRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_dataset_client_stub.call_rpc_count
    end
  end

  def test_import_data
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    input_config = {}
    user_email_address = "hello world"

    import_data_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :import_data, name
      assert_kind_of ::Google::Cloud::DataLabeling::V1beta1::ImportDataRequest, request
      assert_equal "hello world", request["name"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::DataLabeling::V1beta1::InputConfig), request["input_config"]
      assert_equal "hello world", request["user_email_address"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, import_data_client_stub do
      # Create client
      client = ::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.import_data({ name: name, input_config: input_config, user_email_address: user_email_address }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.import_data name: name, input_config: input_config, user_email_address: user_email_address do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.import_data ::Google::Cloud::DataLabeling::V1beta1::ImportDataRequest.new(name: name, input_config: input_config, user_email_address: user_email_address) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.import_data({ name: name, input_config: input_config, user_email_address: user_email_address }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.import_data(::Google::Cloud::DataLabeling::V1beta1::ImportDataRequest.new(name: name, input_config: input_config, user_email_address: user_email_address), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, import_data_client_stub.call_rpc_count
    end
  end

  def test_export_data
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    annotated_dataset = "hello world"
    filter = "hello world"
    output_config = {}
    user_email_address = "hello world"

    export_data_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :export_data, name
      assert_kind_of ::Google::Cloud::DataLabeling::V1beta1::ExportDataRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["annotated_dataset"]
      assert_equal "hello world", request["filter"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::DataLabeling::V1beta1::OutputConfig), request["output_config"]
      assert_equal "hello world", request["user_email_address"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, export_data_client_stub do
      # Create client
      client = ::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.export_data({ name: name, annotated_dataset: annotated_dataset, filter: filter, output_config: output_config, user_email_address: user_email_address }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.export_data name: name, annotated_dataset: annotated_dataset, filter: filter, output_config: output_config, user_email_address: user_email_address do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.export_data ::Google::Cloud::DataLabeling::V1beta1::ExportDataRequest.new(name: name, annotated_dataset: annotated_dataset, filter: filter, output_config: output_config, user_email_address: user_email_address) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.export_data({ name: name, annotated_dataset: annotated_dataset, filter: filter, output_config: output_config, user_email_address: user_email_address }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.export_data(::Google::Cloud::DataLabeling::V1beta1::ExportDataRequest.new(name: name, annotated_dataset: annotated_dataset, filter: filter, output_config: output_config, user_email_address: user_email_address), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, export_data_client_stub.call_rpc_count
    end
  end

  def test_get_data_item
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DataLabeling::V1beta1::DataItem.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_data_item_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_data_item, name
      assert_kind_of ::Google::Cloud::DataLabeling::V1beta1::GetDataItemRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_data_item_client_stub do
      # Create client
      client = ::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_data_item({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_data_item name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_data_item ::Google::Cloud::DataLabeling::V1beta1::GetDataItemRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_data_item({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_data_item(::Google::Cloud::DataLabeling::V1beta1::GetDataItemRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_data_item_client_stub.call_rpc_count
    end
  end

  def test_list_data_items
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DataLabeling::V1beta1::ListDataItemsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"

    list_data_items_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_data_items, name
      assert_kind_of ::Google::Cloud::DataLabeling::V1beta1::ListDataItemsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["filter"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_data_items_client_stub do
      # Create client
      client = ::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_data_items({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_data_items parent: parent, filter: filter, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_data_items ::Google::Cloud::DataLabeling::V1beta1::ListDataItemsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_data_items({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_data_items(::Google::Cloud::DataLabeling::V1beta1::ListDataItemsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_data_items_client_stub.call_rpc_count
    end
  end

  def test_get_annotated_dataset
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DataLabeling::V1beta1::AnnotatedDataset.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_annotated_dataset_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_annotated_dataset, name
      assert_kind_of ::Google::Cloud::DataLabeling::V1beta1::GetAnnotatedDatasetRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_annotated_dataset_client_stub do
      # Create client
      client = ::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_annotated_dataset({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_annotated_dataset name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_annotated_dataset ::Google::Cloud::DataLabeling::V1beta1::GetAnnotatedDatasetRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_annotated_dataset({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_annotated_dataset(::Google::Cloud::DataLabeling::V1beta1::GetAnnotatedDatasetRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_annotated_dataset_client_stub.call_rpc_count
    end
  end

  def test_list_annotated_datasets
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DataLabeling::V1beta1::ListAnnotatedDatasetsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"

    list_annotated_datasets_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_annotated_datasets, name
      assert_kind_of ::Google::Cloud::DataLabeling::V1beta1::ListAnnotatedDatasetsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["filter"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_annotated_datasets_client_stub do
      # Create client
      client = ::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_annotated_datasets({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_annotated_datasets parent: parent, filter: filter, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_annotated_datasets ::Google::Cloud::DataLabeling::V1beta1::ListAnnotatedDatasetsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_annotated_datasets({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_annotated_datasets(::Google::Cloud::DataLabeling::V1beta1::ListAnnotatedDatasetsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_annotated_datasets_client_stub.call_rpc_count
    end
  end

  def test_delete_annotated_dataset
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_annotated_dataset_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_annotated_dataset, name
      assert_kind_of ::Google::Cloud::DataLabeling::V1beta1::DeleteAnnotatedDatasetRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_annotated_dataset_client_stub do
      # Create client
      client = ::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_annotated_dataset({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_annotated_dataset name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_annotated_dataset ::Google::Cloud::DataLabeling::V1beta1::DeleteAnnotatedDatasetRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_annotated_dataset({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_annotated_dataset(::Google::Cloud::DataLabeling::V1beta1::DeleteAnnotatedDatasetRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_annotated_dataset_client_stub.call_rpc_count
    end
  end

  def test_label_image
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    image_classification_config = {}
    parent = "hello world"
    basic_config = {}
    feature = :FEATURE_UNSPECIFIED

    label_image_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :label_image, name
      assert_kind_of ::Google::Cloud::DataLabeling::V1beta1::LabelImageRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::DataLabeling::V1beta1::ImageClassificationConfig), request["image_classification_config"]
      assert_equal :image_classification_config, request.request_config
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::DataLabeling::V1beta1::HumanAnnotationConfig), request["basic_config"]
      assert_equal :FEATURE_UNSPECIFIED, request["feature"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, label_image_client_stub do
      # Create client
      client = ::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.label_image({ image_classification_config: image_classification_config, parent: parent, basic_config: basic_config, feature: feature }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.label_image image_classification_config: image_classification_config, parent: parent, basic_config: basic_config, feature: feature do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.label_image ::Google::Cloud::DataLabeling::V1beta1::LabelImageRequest.new(image_classification_config: image_classification_config, parent: parent, basic_config: basic_config, feature: feature) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.label_image({ image_classification_config: image_classification_config, parent: parent, basic_config: basic_config, feature: feature }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.label_image(::Google::Cloud::DataLabeling::V1beta1::LabelImageRequest.new(image_classification_config: image_classification_config, parent: parent, basic_config: basic_config, feature: feature), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, label_image_client_stub.call_rpc_count
    end
  end

  def test_label_video
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    video_classification_config = {}
    parent = "hello world"
    basic_config = {}
    feature = :FEATURE_UNSPECIFIED

    label_video_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :label_video, name
      assert_kind_of ::Google::Cloud::DataLabeling::V1beta1::LabelVideoRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::DataLabeling::V1beta1::VideoClassificationConfig), request["video_classification_config"]
      assert_equal :video_classification_config, request.request_config
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::DataLabeling::V1beta1::HumanAnnotationConfig), request["basic_config"]
      assert_equal :FEATURE_UNSPECIFIED, request["feature"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, label_video_client_stub do
      # Create client
      client = ::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.label_video({ video_classification_config: video_classification_config, parent: parent, basic_config: basic_config, feature: feature }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.label_video video_classification_config: video_classification_config, parent: parent, basic_config: basic_config, feature: feature do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.label_video ::Google::Cloud::DataLabeling::V1beta1::LabelVideoRequest.new(video_classification_config: video_classification_config, parent: parent, basic_config: basic_config, feature: feature) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.label_video({ video_classification_config: video_classification_config, parent: parent, basic_config: basic_config, feature: feature }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.label_video(::Google::Cloud::DataLabeling::V1beta1::LabelVideoRequest.new(video_classification_config: video_classification_config, parent: parent, basic_config: basic_config, feature: feature), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, label_video_client_stub.call_rpc_count
    end
  end

  def test_label_text
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    text_classification_config = {}
    parent = "hello world"
    basic_config = {}
    feature = :FEATURE_UNSPECIFIED

    label_text_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :label_text, name
      assert_kind_of ::Google::Cloud::DataLabeling::V1beta1::LabelTextRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::DataLabeling::V1beta1::TextClassificationConfig), request["text_classification_config"]
      assert_equal :text_classification_config, request.request_config
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::DataLabeling::V1beta1::HumanAnnotationConfig), request["basic_config"]
      assert_equal :FEATURE_UNSPECIFIED, request["feature"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, label_text_client_stub do
      # Create client
      client = ::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.label_text({ text_classification_config: text_classification_config, parent: parent, basic_config: basic_config, feature: feature }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.label_text text_classification_config: text_classification_config, parent: parent, basic_config: basic_config, feature: feature do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.label_text ::Google::Cloud::DataLabeling::V1beta1::LabelTextRequest.new(text_classification_config: text_classification_config, parent: parent, basic_config: basic_config, feature: feature) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.label_text({ text_classification_config: text_classification_config, parent: parent, basic_config: basic_config, feature: feature }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.label_text(::Google::Cloud::DataLabeling::V1beta1::LabelTextRequest.new(text_classification_config: text_classification_config, parent: parent, basic_config: basic_config, feature: feature), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, label_text_client_stub.call_rpc_count
    end
  end

  def test_get_example
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DataLabeling::V1beta1::Example.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    filter = "hello world"

    get_example_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_example, name
      assert_kind_of ::Google::Cloud::DataLabeling::V1beta1::GetExampleRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_example_client_stub do
      # Create client
      client = ::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_example({ name: name, filter: filter }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_example name: name, filter: filter do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_example ::Google::Cloud::DataLabeling::V1beta1::GetExampleRequest.new(name: name, filter: filter) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_example({ name: name, filter: filter }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_example(::Google::Cloud::DataLabeling::V1beta1::GetExampleRequest.new(name: name, filter: filter), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_example_client_stub.call_rpc_count
    end
  end

  def test_list_examples
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DataLabeling::V1beta1::ListExamplesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"

    list_examples_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_examples, name
      assert_kind_of ::Google::Cloud::DataLabeling::V1beta1::ListExamplesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["filter"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_examples_client_stub do
      # Create client
      client = ::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_examples({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_examples parent: parent, filter: filter, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_examples ::Google::Cloud::DataLabeling::V1beta1::ListExamplesRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_examples({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_examples(::Google::Cloud::DataLabeling::V1beta1::ListExamplesRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_examples_client_stub.call_rpc_count
    end
  end

  def test_create_annotation_spec_set
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DataLabeling::V1beta1::AnnotationSpecSet.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    annotation_spec_set = {}

    create_annotation_spec_set_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_annotation_spec_set, name
      assert_kind_of ::Google::Cloud::DataLabeling::V1beta1::CreateAnnotationSpecSetRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::DataLabeling::V1beta1::AnnotationSpecSet), request["annotation_spec_set"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_annotation_spec_set_client_stub do
      # Create client
      client = ::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_annotation_spec_set({ parent: parent, annotation_spec_set: annotation_spec_set }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_annotation_spec_set parent: parent, annotation_spec_set: annotation_spec_set do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_annotation_spec_set ::Google::Cloud::DataLabeling::V1beta1::CreateAnnotationSpecSetRequest.new(parent: parent, annotation_spec_set: annotation_spec_set) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_annotation_spec_set({ parent: parent, annotation_spec_set: annotation_spec_set }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_annotation_spec_set(::Google::Cloud::DataLabeling::V1beta1::CreateAnnotationSpecSetRequest.new(parent: parent, annotation_spec_set: annotation_spec_set), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_annotation_spec_set_client_stub.call_rpc_count
    end
  end

  def test_get_annotation_spec_set
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DataLabeling::V1beta1::AnnotationSpecSet.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_annotation_spec_set_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_annotation_spec_set, name
      assert_kind_of ::Google::Cloud::DataLabeling::V1beta1::GetAnnotationSpecSetRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_annotation_spec_set_client_stub do
      # Create client
      client = ::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_annotation_spec_set({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_annotation_spec_set name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_annotation_spec_set ::Google::Cloud::DataLabeling::V1beta1::GetAnnotationSpecSetRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_annotation_spec_set({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_annotation_spec_set(::Google::Cloud::DataLabeling::V1beta1::GetAnnotationSpecSetRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_annotation_spec_set_client_stub.call_rpc_count
    end
  end

  def test_list_annotation_spec_sets
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DataLabeling::V1beta1::ListAnnotationSpecSetsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"

    list_annotation_spec_sets_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_annotation_spec_sets, name
      assert_kind_of ::Google::Cloud::DataLabeling::V1beta1::ListAnnotationSpecSetsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["filter"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_annotation_spec_sets_client_stub do
      # Create client
      client = ::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_annotation_spec_sets({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_annotation_spec_sets parent: parent, filter: filter, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_annotation_spec_sets ::Google::Cloud::DataLabeling::V1beta1::ListAnnotationSpecSetsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_annotation_spec_sets({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_annotation_spec_sets(::Google::Cloud::DataLabeling::V1beta1::ListAnnotationSpecSetsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_annotation_spec_sets_client_stub.call_rpc_count
    end
  end

  def test_delete_annotation_spec_set
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_annotation_spec_set_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_annotation_spec_set, name
      assert_kind_of ::Google::Cloud::DataLabeling::V1beta1::DeleteAnnotationSpecSetRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_annotation_spec_set_client_stub do
      # Create client
      client = ::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_annotation_spec_set({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_annotation_spec_set name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_annotation_spec_set ::Google::Cloud::DataLabeling::V1beta1::DeleteAnnotationSpecSetRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_annotation_spec_set({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_annotation_spec_set(::Google::Cloud::DataLabeling::V1beta1::DeleteAnnotationSpecSetRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_annotation_spec_set_client_stub.call_rpc_count
    end
  end

  def test_create_instruction
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    instruction = {}

    create_instruction_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_instruction, name
      assert_kind_of ::Google::Cloud::DataLabeling::V1beta1::CreateInstructionRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::DataLabeling::V1beta1::Instruction), request["instruction"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_instruction_client_stub do
      # Create client
      client = ::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_instruction({ parent: parent, instruction: instruction }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_instruction parent: parent, instruction: instruction do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_instruction ::Google::Cloud::DataLabeling::V1beta1::CreateInstructionRequest.new(parent: parent, instruction: instruction) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_instruction({ parent: parent, instruction: instruction }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_instruction(::Google::Cloud::DataLabeling::V1beta1::CreateInstructionRequest.new(parent: parent, instruction: instruction), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_instruction_client_stub.call_rpc_count
    end
  end

  def test_get_instruction
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DataLabeling::V1beta1::Instruction.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_instruction_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_instruction, name
      assert_kind_of ::Google::Cloud::DataLabeling::V1beta1::GetInstructionRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_instruction_client_stub do
      # Create client
      client = ::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_instruction({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_instruction name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_instruction ::Google::Cloud::DataLabeling::V1beta1::GetInstructionRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_instruction({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_instruction(::Google::Cloud::DataLabeling::V1beta1::GetInstructionRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_instruction_client_stub.call_rpc_count
    end
  end

  def test_list_instructions
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DataLabeling::V1beta1::ListInstructionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"

    list_instructions_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_instructions, name
      assert_kind_of ::Google::Cloud::DataLabeling::V1beta1::ListInstructionsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["filter"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_instructions_client_stub do
      # Create client
      client = ::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_instructions({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_instructions parent: parent, filter: filter, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_instructions ::Google::Cloud::DataLabeling::V1beta1::ListInstructionsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_instructions({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_instructions(::Google::Cloud::DataLabeling::V1beta1::ListInstructionsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_instructions_client_stub.call_rpc_count
    end
  end

  def test_delete_instruction
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_instruction_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_instruction, name
      assert_kind_of ::Google::Cloud::DataLabeling::V1beta1::DeleteInstructionRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_instruction_client_stub do
      # Create client
      client = ::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_instruction({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_instruction name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_instruction ::Google::Cloud::DataLabeling::V1beta1::DeleteInstructionRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_instruction({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_instruction(::Google::Cloud::DataLabeling::V1beta1::DeleteInstructionRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_instruction_client_stub.call_rpc_count
    end
  end

  def test_get_evaluation
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DataLabeling::V1beta1::Evaluation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_evaluation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_evaluation, name
      assert_kind_of ::Google::Cloud::DataLabeling::V1beta1::GetEvaluationRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_evaluation_client_stub do
      # Create client
      client = ::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_evaluation({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_evaluation name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_evaluation ::Google::Cloud::DataLabeling::V1beta1::GetEvaluationRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_evaluation({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_evaluation(::Google::Cloud::DataLabeling::V1beta1::GetEvaluationRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_evaluation_client_stub.call_rpc_count
    end
  end

  def test_search_evaluations
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DataLabeling::V1beta1::SearchEvaluationsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"

    search_evaluations_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :search_evaluations, name
      assert_kind_of ::Google::Cloud::DataLabeling::V1beta1::SearchEvaluationsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["filter"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, search_evaluations_client_stub do
      # Create client
      client = ::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.search_evaluations({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.search_evaluations parent: parent, filter: filter, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.search_evaluations ::Google::Cloud::DataLabeling::V1beta1::SearchEvaluationsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.search_evaluations({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.search_evaluations(::Google::Cloud::DataLabeling::V1beta1::SearchEvaluationsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, search_evaluations_client_stub.call_rpc_count
    end
  end

  def test_search_example_comparisons
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DataLabeling::V1beta1::SearchExampleComparisonsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    search_example_comparisons_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :search_example_comparisons, name
      assert_kind_of ::Google::Cloud::DataLabeling::V1beta1::SearchExampleComparisonsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, search_example_comparisons_client_stub do
      # Create client
      client = ::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.search_example_comparisons({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.search_example_comparisons parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.search_example_comparisons ::Google::Cloud::DataLabeling::V1beta1::SearchExampleComparisonsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.search_example_comparisons({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.search_example_comparisons(::Google::Cloud::DataLabeling::V1beta1::SearchExampleComparisonsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, search_example_comparisons_client_stub.call_rpc_count
    end
  end

  def test_create_evaluation_job
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DataLabeling::V1beta1::EvaluationJob.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    job = {}

    create_evaluation_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_evaluation_job, name
      assert_kind_of ::Google::Cloud::DataLabeling::V1beta1::CreateEvaluationJobRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::DataLabeling::V1beta1::EvaluationJob), request["job"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_evaluation_job_client_stub do
      # Create client
      client = ::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_evaluation_job({ parent: parent, job: job }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_evaluation_job parent: parent, job: job do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_evaluation_job ::Google::Cloud::DataLabeling::V1beta1::CreateEvaluationJobRequest.new(parent: parent, job: job) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_evaluation_job({ parent: parent, job: job }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_evaluation_job(::Google::Cloud::DataLabeling::V1beta1::CreateEvaluationJobRequest.new(parent: parent, job: job), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_evaluation_job_client_stub.call_rpc_count
    end
  end

  def test_update_evaluation_job
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DataLabeling::V1beta1::EvaluationJob.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    evaluation_job = {}
    update_mask = {}

    update_evaluation_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_evaluation_job, name
      assert_kind_of ::Google::Cloud::DataLabeling::V1beta1::UpdateEvaluationJobRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::DataLabeling::V1beta1::EvaluationJob), request["evaluation_job"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_evaluation_job_client_stub do
      # Create client
      client = ::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_evaluation_job({ evaluation_job: evaluation_job, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_evaluation_job evaluation_job: evaluation_job, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_evaluation_job ::Google::Cloud::DataLabeling::V1beta1::UpdateEvaluationJobRequest.new(evaluation_job: evaluation_job, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_evaluation_job({ evaluation_job: evaluation_job, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_evaluation_job(::Google::Cloud::DataLabeling::V1beta1::UpdateEvaluationJobRequest.new(evaluation_job: evaluation_job, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_evaluation_job_client_stub.call_rpc_count
    end
  end

  def test_get_evaluation_job
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DataLabeling::V1beta1::EvaluationJob.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_evaluation_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_evaluation_job, name
      assert_kind_of ::Google::Cloud::DataLabeling::V1beta1::GetEvaluationJobRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_evaluation_job_client_stub do
      # Create client
      client = ::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_evaluation_job({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_evaluation_job name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_evaluation_job ::Google::Cloud::DataLabeling::V1beta1::GetEvaluationJobRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_evaluation_job({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_evaluation_job(::Google::Cloud::DataLabeling::V1beta1::GetEvaluationJobRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_evaluation_job_client_stub.call_rpc_count
    end
  end

  def test_pause_evaluation_job
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    pause_evaluation_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :pause_evaluation_job, name
      assert_kind_of ::Google::Cloud::DataLabeling::V1beta1::PauseEvaluationJobRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, pause_evaluation_job_client_stub do
      # Create client
      client = ::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.pause_evaluation_job({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.pause_evaluation_job name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.pause_evaluation_job ::Google::Cloud::DataLabeling::V1beta1::PauseEvaluationJobRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.pause_evaluation_job({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.pause_evaluation_job(::Google::Cloud::DataLabeling::V1beta1::PauseEvaluationJobRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, pause_evaluation_job_client_stub.call_rpc_count
    end
  end

  def test_resume_evaluation_job
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    resume_evaluation_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :resume_evaluation_job, name
      assert_kind_of ::Google::Cloud::DataLabeling::V1beta1::ResumeEvaluationJobRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, resume_evaluation_job_client_stub do
      # Create client
      client = ::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.resume_evaluation_job({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.resume_evaluation_job name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.resume_evaluation_job ::Google::Cloud::DataLabeling::V1beta1::ResumeEvaluationJobRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.resume_evaluation_job({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.resume_evaluation_job(::Google::Cloud::DataLabeling::V1beta1::ResumeEvaluationJobRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, resume_evaluation_job_client_stub.call_rpc_count
    end
  end

  def test_delete_evaluation_job
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_evaluation_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_evaluation_job, name
      assert_kind_of ::Google::Cloud::DataLabeling::V1beta1::DeleteEvaluationJobRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_evaluation_job_client_stub do
      # Create client
      client = ::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_evaluation_job({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_evaluation_job name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_evaluation_job ::Google::Cloud::DataLabeling::V1beta1::DeleteEvaluationJobRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_evaluation_job({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_evaluation_job(::Google::Cloud::DataLabeling::V1beta1::DeleteEvaluationJobRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_evaluation_job_client_stub.call_rpc_count
    end
  end

  def test_list_evaluation_jobs
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DataLabeling::V1beta1::ListEvaluationJobsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"

    list_evaluation_jobs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_evaluation_jobs, name
      assert_kind_of ::Google::Cloud::DataLabeling::V1beta1::ListEvaluationJobsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["filter"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_evaluation_jobs_client_stub do
      # Create client
      client = ::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_evaluation_jobs({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_evaluation_jobs parent: parent, filter: filter, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_evaluation_jobs ::Google::Cloud::DataLabeling::V1beta1::ListEvaluationJobsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_evaluation_jobs({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_evaluation_jobs(::Google::Cloud::DataLabeling::V1beta1::ListEvaluationJobsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_evaluation_jobs_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Operations, client.operations_client
  end
end
