# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/data_labeling/v1beta1/data_labeling_service"

class ::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::ClientPathsTest < Minitest::Test
  class DummyStub
    def endpoint
      "endpoint.example.com"
    end
  
    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_annotated_dataset_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.annotated_dataset_path project: "value0", dataset: "value1", annotated_dataset: "value2"
      assert_equal "projects/value0/datasets/value1/annotatedDatasets/value2", path
    end
  end

  def test_annotation_spec_set_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.annotation_spec_set_path project: "value0", annotation_spec_set: "value1"
      assert_equal "projects/value0/annotationSpecSets/value1", path
    end
  end

  def test_data_item_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.data_item_path project: "value0", dataset: "value1", data_item: "value2"
      assert_equal "projects/value0/datasets/value1/dataItems/value2", path
    end
  end

  def test_dataset_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.dataset_path project: "value0", dataset: "value1"
      assert_equal "projects/value0/datasets/value1", path
    end
  end

  def test_evaluation_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.evaluation_path project: "value0", dataset: "value1", evaluation: "value2"
      assert_equal "projects/value0/datasets/value1/evaluations/value2", path
    end
  end

  def test_evaluation_job_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.evaluation_job_path project: "value0", evaluation_job: "value1"
      assert_equal "projects/value0/evaluationJobs/value1", path
    end
  end

  def test_example_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.example_path project: "value0", dataset: "value1", annotated_dataset: "value2", example: "value3"
      assert_equal "projects/value0/datasets/value1/annotatedDatasets/value2/examples/value3", path
    end
  end

  def test_instruction_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.instruction_path project: "value0", instruction: "value1"
      assert_equal "projects/value0/instructions/value1", path
    end
  end

  def test_project_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.project_path project: "value0"
      assert_equal "projects/value0", path
    end
  end
end
