# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DataLabeling
      module V1beta1
        # Container of information about an image.
        # @!attribute [rw] mime_type
        #   @return [::String]
        #     Image format.
        # @!attribute [rw] image_thumbnail
        #   @return [::String]
        #     A byte string of a thumbnail image.
        # @!attribute [rw] image_uri
        #   @return [::String]
        #     Image uri from the user bucket.
        # @!attribute [rw] signed_uri
        #   @return [::String]
        #     Signed uri of the image file in the service bucket.
        class ImagePayload
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Container of information about a piece of text.
        # @!attribute [rw] text_content
        #   @return [::String]
        #     Text content.
        class TextPayload
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Container of information of a video thumbnail.
        # @!attribute [rw] thumbnail
        #   @return [::String]
        #     A byte string of the video frame.
        # @!attribute [rw] time_offset
        #   @return [::Google::Protobuf::Duration]
        #     Time offset relative to the beginning of the video, corresponding to the
        #     video frame where the thumbnail has been extracted from.
        class VideoThumbnail
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Container of information of a video.
        # @!attribute [rw] mime_type
        #   @return [::String]
        #     Video format.
        # @!attribute [rw] video_uri
        #   @return [::String]
        #     Video uri from the user bucket.
        # @!attribute [rw] video_thumbnails
        #   @return [::Array<::Google::Cloud::DataLabeling::V1beta1::VideoThumbnail>]
        #     The list of video thumbnails.
        # @!attribute [rw] frame_rate
        #   @return [::Float]
        #     FPS of the video.
        # @!attribute [rw] signed_uri
        #   @return [::String]
        #     Signed uri of the video file in the service bucket.
        class VideoPayload
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
