# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DataLabeling
      module V1beta1
        # Annotation for Example. Each example may have one or more annotations. For
        # example in image classification problem, each image might have one or more
        # labels. We call labels binded with this image an Annotation.
        # @!attribute [rw] name
        #   @return [::String]
        #     Output only. Unique name of this annotation, format is:
        #
        #     projects/\\{project_id}/datasets/\\{dataset_id}/annotatedDatasets/\\{annotated_dataset}/examples/\\{example_id}/annotations/\\{annotation_id}
        # @!attribute [rw] annotation_source
        #   @return [::Google::Cloud::DataLabeling::V1beta1::AnnotationSource]
        #     Output only. The source of the annotation.
        # @!attribute [rw] annotation_value
        #   @return [::Google::Cloud::DataLabeling::V1beta1::AnnotationValue]
        #     Output only. This is the actual annotation value, e.g classification,
        #     bounding box values are stored here.
        # @!attribute [rw] annotation_metadata
        #   @return [::Google::Cloud::DataLabeling::V1beta1::AnnotationMetadata]
        #     Output only. Annotation metadata, including information like votes
        #     for labels.
        # @!attribute [rw] annotation_sentiment
        #   @return [::Google::Cloud::DataLabeling::V1beta1::AnnotationSentiment]
        #     Output only. Sentiment for this annotation.
        class Annotation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Annotation value for an example.
        # @!attribute [rw] image_classification_annotation
        #   @return [::Google::Cloud::DataLabeling::V1beta1::ImageClassificationAnnotation]
        #     Annotation value for image classification case.
        #
        #     Note: The following fields are mutually exclusive: `image_classification_annotation`, `image_bounding_poly_annotation`, `image_polyline_annotation`, `image_segmentation_annotation`, `text_classification_annotation`, `text_entity_extraction_annotation`, `video_classification_annotation`, `video_object_tracking_annotation`, `video_event_annotation`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] image_bounding_poly_annotation
        #   @return [::Google::Cloud::DataLabeling::V1beta1::ImageBoundingPolyAnnotation]
        #     Annotation value for image bounding box, oriented bounding box
        #     and polygon cases.
        #
        #     Note: The following fields are mutually exclusive: `image_bounding_poly_annotation`, `image_classification_annotation`, `image_polyline_annotation`, `image_segmentation_annotation`, `text_classification_annotation`, `text_entity_extraction_annotation`, `video_classification_annotation`, `video_object_tracking_annotation`, `video_event_annotation`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] image_polyline_annotation
        #   @return [::Google::Cloud::DataLabeling::V1beta1::ImagePolylineAnnotation]
        #     Annotation value for image polyline cases.
        #     Polyline here is different from BoundingPoly. It is formed by
        #     line segments connected to each other but not closed form(Bounding Poly).
        #     The line segments can cross each other.
        #
        #     Note: The following fields are mutually exclusive: `image_polyline_annotation`, `image_classification_annotation`, `image_bounding_poly_annotation`, `image_segmentation_annotation`, `text_classification_annotation`, `text_entity_extraction_annotation`, `video_classification_annotation`, `video_object_tracking_annotation`, `video_event_annotation`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] image_segmentation_annotation
        #   @return [::Google::Cloud::DataLabeling::V1beta1::ImageSegmentationAnnotation]
        #     Annotation value for image segmentation.
        #
        #     Note: The following fields are mutually exclusive: `image_segmentation_annotation`, `image_classification_annotation`, `image_bounding_poly_annotation`, `image_polyline_annotation`, `text_classification_annotation`, `text_entity_extraction_annotation`, `video_classification_annotation`, `video_object_tracking_annotation`, `video_event_annotation`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] text_classification_annotation
        #   @return [::Google::Cloud::DataLabeling::V1beta1::TextClassificationAnnotation]
        #     Annotation value for text classification case.
        #
        #     Note: The following fields are mutually exclusive: `text_classification_annotation`, `image_classification_annotation`, `image_bounding_poly_annotation`, `image_polyline_annotation`, `image_segmentation_annotation`, `text_entity_extraction_annotation`, `video_classification_annotation`, `video_object_tracking_annotation`, `video_event_annotation`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] text_entity_extraction_annotation
        #   @return [::Google::Cloud::DataLabeling::V1beta1::TextEntityExtractionAnnotation]
        #     Annotation value for text entity extraction case.
        #
        #     Note: The following fields are mutually exclusive: `text_entity_extraction_annotation`, `image_classification_annotation`, `image_bounding_poly_annotation`, `image_polyline_annotation`, `image_segmentation_annotation`, `text_classification_annotation`, `video_classification_annotation`, `video_object_tracking_annotation`, `video_event_annotation`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] video_classification_annotation
        #   @return [::Google::Cloud::DataLabeling::V1beta1::VideoClassificationAnnotation]
        #     Annotation value for video classification case.
        #
        #     Note: The following fields are mutually exclusive: `video_classification_annotation`, `image_classification_annotation`, `image_bounding_poly_annotation`, `image_polyline_annotation`, `image_segmentation_annotation`, `text_classification_annotation`, `text_entity_extraction_annotation`, `video_object_tracking_annotation`, `video_event_annotation`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] video_object_tracking_annotation
        #   @return [::Google::Cloud::DataLabeling::V1beta1::VideoObjectTrackingAnnotation]
        #     Annotation value for video object detection and tracking case.
        #
        #     Note: The following fields are mutually exclusive: `video_object_tracking_annotation`, `image_classification_annotation`, `image_bounding_poly_annotation`, `image_polyline_annotation`, `image_segmentation_annotation`, `text_classification_annotation`, `text_entity_extraction_annotation`, `video_classification_annotation`, `video_event_annotation`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] video_event_annotation
        #   @return [::Google::Cloud::DataLabeling::V1beta1::VideoEventAnnotation]
        #     Annotation value for video event case.
        #
        #     Note: The following fields are mutually exclusive: `video_event_annotation`, `image_classification_annotation`, `image_bounding_poly_annotation`, `image_polyline_annotation`, `image_segmentation_annotation`, `text_classification_annotation`, `text_entity_extraction_annotation`, `video_classification_annotation`, `video_object_tracking_annotation`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class AnnotationValue
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Image classification annotation definition.
        # @!attribute [rw] annotation_spec
        #   @return [::Google::Cloud::DataLabeling::V1beta1::AnnotationSpec]
        #     Label of image.
        class ImageClassificationAnnotation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A vertex represents a 2D point in the image.
        # NOTE: the vertex coordinates are in the same scale as the original image.
        # @!attribute [rw] x
        #   @return [::Integer]
        #     X coordinate.
        # @!attribute [rw] y
        #   @return [::Integer]
        #     Y coordinate.
        class Vertex
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A vertex represents a 2D point in the image.
        # NOTE: the normalized vertex coordinates are relative to the original image
        # and range from 0 to 1.
        # @!attribute [rw] x
        #   @return [::Float]
        #     X coordinate.
        # @!attribute [rw] y
        #   @return [::Float]
        #     Y coordinate.
        class NormalizedVertex
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A bounding polygon in the image.
        # @!attribute [rw] vertices
        #   @return [::Array<::Google::Cloud::DataLabeling::V1beta1::Vertex>]
        #     The bounding polygon vertices.
        class BoundingPoly
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Normalized bounding polygon.
        # @!attribute [rw] normalized_vertices
        #   @return [::Array<::Google::Cloud::DataLabeling::V1beta1::NormalizedVertex>]
        #     The bounding polygon normalized vertices.
        class NormalizedBoundingPoly
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Image bounding poly annotation. It represents a polygon including
        # bounding box in the image.
        # @!attribute [rw] bounding_poly
        #   @return [::Google::Cloud::DataLabeling::V1beta1::BoundingPoly]
        #     Note: The following fields are mutually exclusive: `bounding_poly`, `normalized_bounding_poly`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] normalized_bounding_poly
        #   @return [::Google::Cloud::DataLabeling::V1beta1::NormalizedBoundingPoly]
        #     Note: The following fields are mutually exclusive: `normalized_bounding_poly`, `bounding_poly`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] annotation_spec
        #   @return [::Google::Cloud::DataLabeling::V1beta1::AnnotationSpec]
        #     Label of object in this bounding polygon.
        class ImageBoundingPolyAnnotation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A line with multiple line segments.
        # @!attribute [rw] vertices
        #   @return [::Array<::Google::Cloud::DataLabeling::V1beta1::Vertex>]
        #     The polyline vertices.
        class Polyline
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Normalized polyline.
        # @!attribute [rw] normalized_vertices
        #   @return [::Array<::Google::Cloud::DataLabeling::V1beta1::NormalizedVertex>]
        #     The normalized polyline vertices.
        class NormalizedPolyline
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A polyline for the image annotation.
        # @!attribute [rw] polyline
        #   @return [::Google::Cloud::DataLabeling::V1beta1::Polyline]
        #     Note: The following fields are mutually exclusive: `polyline`, `normalized_polyline`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] normalized_polyline
        #   @return [::Google::Cloud::DataLabeling::V1beta1::NormalizedPolyline]
        #     Note: The following fields are mutually exclusive: `normalized_polyline`, `polyline`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] annotation_spec
        #   @return [::Google::Cloud::DataLabeling::V1beta1::AnnotationSpec]
        #     Label of this polyline.
        class ImagePolylineAnnotation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Image segmentation annotation.
        # @!attribute [rw] annotation_colors
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::DataLabeling::V1beta1::AnnotationSpec}]
        #     The mapping between rgb color and annotation spec. The key is the rgb
        #     color represented in format of rgb(0, 0, 0). The value is the
        #     AnnotationSpec.
        # @!attribute [rw] mime_type
        #   @return [::String]
        #     Image format.
        # @!attribute [rw] image_bytes
        #   @return [::String]
        #     A byte string of a full image's color map.
        class ImageSegmentationAnnotation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::DataLabeling::V1beta1::AnnotationSpec]
          class AnnotationColorsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Text classification annotation.
        # @!attribute [rw] annotation_spec
        #   @return [::Google::Cloud::DataLabeling::V1beta1::AnnotationSpec]
        #     Label of the text.
        class TextClassificationAnnotation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Text entity extraction annotation.
        # @!attribute [rw] annotation_spec
        #   @return [::Google::Cloud::DataLabeling::V1beta1::AnnotationSpec]
        #     Label of the text entities.
        # @!attribute [rw] sequential_segment
        #   @return [::Google::Cloud::DataLabeling::V1beta1::SequentialSegment]
        #     Position of the entity.
        class TextEntityExtractionAnnotation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Start and end position in a sequence (e.g. text segment).
        # @!attribute [rw] start
        #   @return [::Integer]
        #     Start position (inclusive).
        # @!attribute [rw] end
        #   @return [::Integer]
        #     End position (exclusive).
        class SequentialSegment
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A time period inside of an example that has a time dimension (e.g. video).
        # @!attribute [rw] start_time_offset
        #   @return [::Google::Protobuf::Duration]
        #     Start of the time segment (inclusive), represented as the duration since
        #     the example start.
        # @!attribute [rw] end_time_offset
        #   @return [::Google::Protobuf::Duration]
        #     End of the time segment (exclusive), represented as the duration since the
        #     example start.
        class TimeSegment
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Video classification annotation.
        # @!attribute [rw] time_segment
        #   @return [::Google::Cloud::DataLabeling::V1beta1::TimeSegment]
        #     The time segment of the video to which the annotation applies.
        # @!attribute [rw] annotation_spec
        #   @return [::Google::Cloud::DataLabeling::V1beta1::AnnotationSpec]
        #     Label of the segment specified by time_segment.
        class VideoClassificationAnnotation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Video frame level annotation for object detection and tracking.
        # @!attribute [rw] bounding_poly
        #   @return [::Google::Cloud::DataLabeling::V1beta1::BoundingPoly]
        #     Note: The following fields are mutually exclusive: `bounding_poly`, `normalized_bounding_poly`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] normalized_bounding_poly
        #   @return [::Google::Cloud::DataLabeling::V1beta1::NormalizedBoundingPoly]
        #     Note: The following fields are mutually exclusive: `normalized_bounding_poly`, `bounding_poly`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] time_offset
        #   @return [::Google::Protobuf::Duration]
        #     The time offset of this frame relative to the beginning of the video.
        class ObjectTrackingFrame
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Video object tracking annotation.
        # @!attribute [rw] annotation_spec
        #   @return [::Google::Cloud::DataLabeling::V1beta1::AnnotationSpec]
        #     Label of the object tracked in this annotation.
        # @!attribute [rw] time_segment
        #   @return [::Google::Cloud::DataLabeling::V1beta1::TimeSegment]
        #     The time segment of the video to which object tracking applies.
        # @!attribute [rw] object_tracking_frames
        #   @return [::Array<::Google::Cloud::DataLabeling::V1beta1::ObjectTrackingFrame>]
        #     The list of frames where this object track appears.
        class VideoObjectTrackingAnnotation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Video event annotation.
        # @!attribute [rw] annotation_spec
        #   @return [::Google::Cloud::DataLabeling::V1beta1::AnnotationSpec]
        #     Label of the event in this annotation.
        # @!attribute [rw] time_segment
        #   @return [::Google::Cloud::DataLabeling::V1beta1::TimeSegment]
        #     The time segment of the video to which the annotation applies.
        class VideoEventAnnotation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Additional information associated with the annotation.
        # @!attribute [rw] operator_metadata
        #   @return [::Google::Cloud::DataLabeling::V1beta1::OperatorMetadata]
        #     Metadata related to human labeling.
        class AnnotationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # General information useful for labels coming from contributors.
        # @!attribute [rw] score
        #   @return [::Float]
        #     Confidence score corresponding to a label. For examle, if 3 contributors
        #     have answered the question and 2 of them agree on the final label, the
        #     confidence score will be 0.67 (2/3).
        # @!attribute [rw] total_votes
        #   @return [::Integer]
        #     The total number of contributors that answer this question.
        # @!attribute [rw] label_votes
        #   @return [::Integer]
        #     The total number of contributors that choose this label.
        # @!attribute [rw] comments
        #   @return [::Array<::String>]
        #     Comments from contributors.
        class OperatorMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Specifies where the annotation comes from (whether it was provided by a
        # human labeler or a different source).
        module AnnotationSource
          ANNOTATION_SOURCE_UNSPECIFIED = 0

          # Answer is provided by a human contributor.
          OPERATOR = 3
        end

        module AnnotationSentiment
          ANNOTATION_SENTIMENT_UNSPECIFIED = 0

          # This annotation describes negatively about the data.
          NEGATIVE = 1

          # This label describes positively about the data.
          POSITIVE = 2
        end

        module AnnotationType
          ANNOTATION_TYPE_UNSPECIFIED = 0

          # Classification annotations in an image. Allowed for continuous evaluation.
          IMAGE_CLASSIFICATION_ANNOTATION = 1

          # Bounding box annotations in an image. A form of image object detection.
          # Allowed for continuous evaluation.
          IMAGE_BOUNDING_BOX_ANNOTATION = 2

          # Oriented bounding box. The box does not have to be parallel to horizontal
          # line.
          IMAGE_ORIENTED_BOUNDING_BOX_ANNOTATION = 13

          # Bounding poly annotations in an image.
          IMAGE_BOUNDING_POLY_ANNOTATION = 10

          # Polyline annotations in an image.
          IMAGE_POLYLINE_ANNOTATION = 11

          # Segmentation annotations in an image.
          IMAGE_SEGMENTATION_ANNOTATION = 12

          # Classification annotations in video shots.
          VIDEO_SHOTS_CLASSIFICATION_ANNOTATION = 3

          # Video object tracking annotation.
          VIDEO_OBJECT_TRACKING_ANNOTATION = 4

          # Video object detection annotation.
          VIDEO_OBJECT_DETECTION_ANNOTATION = 5

          # Video event annotation.
          VIDEO_EVENT_ANNOTATION = 6

          # Classification for text. Allowed for continuous evaluation.
          TEXT_CLASSIFICATION_ANNOTATION = 8

          # Entity extraction for text.
          TEXT_ENTITY_EXTRACTION_ANNOTATION = 9

          # General classification. Allowed for continuous evaluation.
          GENERAL_CLASSIFICATION_ANNOTATION = 14
        end
      end
    end
  end
end
