# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/datalabeling/v1beta1/data_labeling_service_pb"

module Google
  module Cloud
    module DataLabeling
      module V1beta1
        module DataLabelingService
          ##
          # Client for the DataLabelingService service.
          #
          # Service for the AI Platform Data Labeling API.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "datalabeling.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :data_labeling_service_stub

            ##
            # Configure the DataLabelingService Client class.
            #
            # See {::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all DataLabelingService clients
            #   ::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "DataLabeling", "V1beta1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.rpcs.create_dataset.timeout = 30.0

                default_config.rpcs.get_dataset.timeout = 30.0
                default_config.rpcs.get_dataset.retry_policy = {
                  initial_delay: 0.1, max_delay: 30.0, multiplier: 1.3, retry_codes: [4, 14]
                }

                default_config.rpcs.list_datasets.timeout = 30.0
                default_config.rpcs.list_datasets.retry_policy = {
                  initial_delay: 0.1, max_delay: 30.0, multiplier: 1.3, retry_codes: [4, 14]
                }

                default_config.rpcs.delete_dataset.timeout = 30.0
                default_config.rpcs.delete_dataset.retry_policy = {
                  initial_delay: 0.1, max_delay: 30.0, multiplier: 1.3, retry_codes: [4, 14]
                }

                default_config.rpcs.import_data.timeout = 30.0

                default_config.rpcs.export_data.timeout = 30.0
                default_config.rpcs.export_data.retry_policy = {
                  initial_delay: 0.1, max_delay: 30.0, multiplier: 1.3, retry_codes: [4, 14]
                }

                default_config.rpcs.get_data_item.timeout = 30.0
                default_config.rpcs.get_data_item.retry_policy = {
                  initial_delay: 0.1, max_delay: 30.0, multiplier: 1.3, retry_codes: [4, 14]
                }

                default_config.rpcs.list_data_items.timeout = 30.0
                default_config.rpcs.list_data_items.retry_policy = {
                  initial_delay: 0.1, max_delay: 30.0, multiplier: 1.3, retry_codes: [4, 14]
                }

                default_config.rpcs.get_annotated_dataset.timeout = 30.0
                default_config.rpcs.get_annotated_dataset.retry_policy = {
                  initial_delay: 0.1, max_delay: 30.0, multiplier: 1.3, retry_codes: [4, 14]
                }

                default_config.rpcs.list_annotated_datasets.timeout = 30.0
                default_config.rpcs.list_annotated_datasets.retry_policy = {
                  initial_delay: 0.1, max_delay: 30.0, multiplier: 1.3, retry_codes: [4, 14]
                }

                default_config.rpcs.label_image.timeout = 30.0

                default_config.rpcs.label_video.timeout = 30.0

                default_config.rpcs.label_text.timeout = 30.0

                default_config.rpcs.get_example.timeout = 30.0
                default_config.rpcs.get_example.retry_policy = {
                  initial_delay: 0.1, max_delay: 30.0, multiplier: 1.3, retry_codes: [4, 14]
                }

                default_config.rpcs.list_examples.timeout = 30.0
                default_config.rpcs.list_examples.retry_policy = {
                  initial_delay: 0.1, max_delay: 30.0, multiplier: 1.3, retry_codes: [4, 14]
                }

                default_config.rpcs.create_annotation_spec_set.timeout = 30.0

                default_config.rpcs.get_annotation_spec_set.timeout = 30.0
                default_config.rpcs.get_annotation_spec_set.retry_policy = {
                  initial_delay: 0.1, max_delay: 30.0, multiplier: 1.3, retry_codes: [4, 14]
                }

                default_config.rpcs.list_annotation_spec_sets.timeout = 30.0
                default_config.rpcs.list_annotation_spec_sets.retry_policy = {
                  initial_delay: 0.1, max_delay: 30.0, multiplier: 1.3, retry_codes: [4, 14]
                }

                default_config.rpcs.delete_annotation_spec_set.timeout = 30.0
                default_config.rpcs.delete_annotation_spec_set.retry_policy = {
                  initial_delay: 0.1, max_delay: 30.0, multiplier: 1.3, retry_codes: [4, 14]
                }

                default_config.rpcs.create_instruction.timeout = 30.0

                default_config.rpcs.get_instruction.timeout = 30.0
                default_config.rpcs.get_instruction.retry_policy = {
                  initial_delay: 0.1, max_delay: 30.0, multiplier: 1.3, retry_codes: [4, 14]
                }

                default_config.rpcs.list_instructions.timeout = 30.0
                default_config.rpcs.list_instructions.retry_policy = {
                  initial_delay: 0.1, max_delay: 30.0, multiplier: 1.3, retry_codes: [4, 14]
                }

                default_config.rpcs.delete_instruction.timeout = 30.0
                default_config.rpcs.delete_instruction.retry_policy = {
                  initial_delay: 0.1, max_delay: 30.0, multiplier: 1.3, retry_codes: [4, 14]
                }

                default_config.rpcs.get_evaluation.timeout = 30.0
                default_config.rpcs.get_evaluation.retry_policy = {
                  initial_delay: 0.1, max_delay: 30.0, multiplier: 1.3, retry_codes: [4, 14]
                }

                default_config.rpcs.search_evaluations.timeout = 30.0
                default_config.rpcs.search_evaluations.retry_policy = {
                  initial_delay: 0.1, max_delay: 30.0, multiplier: 1.3, retry_codes: [4, 14]
                }

                default_config.rpcs.search_example_comparisons.timeout = 30.0

                default_config.rpcs.create_evaluation_job.timeout = 30.0

                default_config.rpcs.update_evaluation_job.timeout = 30.0

                default_config.rpcs.get_evaluation_job.timeout = 30.0
                default_config.rpcs.get_evaluation_job.retry_policy = {
                  initial_delay: 0.1, max_delay: 30.0, multiplier: 1.3, retry_codes: [4, 14]
                }

                default_config.rpcs.pause_evaluation_job.timeout = 30.0

                default_config.rpcs.resume_evaluation_job.timeout = 30.0

                default_config.rpcs.delete_evaluation_job.timeout = 30.0
                default_config.rpcs.delete_evaluation_job.retry_policy = {
                  initial_delay: 0.1, max_delay: 30.0, multiplier: 1.3, retry_codes: [4, 14]
                }

                default_config.rpcs.list_evaluation_jobs.timeout = 30.0
                default_config.rpcs.list_evaluation_jobs.retry_policy = {
                  initial_delay: 0.1, max_delay: 30.0, multiplier: 1.3, retry_codes: [4, 14]
                }

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the DataLabelingService Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @data_labeling_service_stub.universe_domain
            end

            ##
            # Create a new DataLabelingService client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the DataLabelingService client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/datalabeling/v1beta1/data_labeling_service_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @data_labeling_service_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @data_labeling_service_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Operations]
            #
            attr_reader :operations_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @data_labeling_service_stub.logger
            end

            # Service calls

            ##
            # Creates dataset. If success return a Dataset resource.
            #
            # @overload create_dataset(request, options = nil)
            #   Pass arguments to `create_dataset` via a request object, either of type
            #   {::Google::Cloud::DataLabeling::V1beta1::CreateDatasetRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DataLabeling::V1beta1::CreateDatasetRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_dataset(parent: nil, dataset: nil)
            #   Pass arguments to `create_dataset` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Dataset resource parent, format:
            #     projects/\\{project_id}
            #   @param dataset [::Google::Cloud::DataLabeling::V1beta1::Dataset, ::Hash]
            #     Required. The dataset to be created.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::DataLabeling::V1beta1::Dataset]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::DataLabeling::V1beta1::Dataset]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_labeling/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DataLabeling::V1beta1::CreateDatasetRequest.new
            #
            #   # Call the create_dataset method.
            #   result = client.create_dataset request
            #
            #   # The returned object is of type Google::Cloud::DataLabeling::V1beta1::Dataset.
            #   p result
            #
            def create_dataset request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataLabeling::V1beta1::CreateDatasetRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_dataset.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataLabeling::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_dataset.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_dataset.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_labeling_service_stub.call_rpc :create_dataset, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets dataset by resource name.
            #
            # @overload get_dataset(request, options = nil)
            #   Pass arguments to `get_dataset` via a request object, either of type
            #   {::Google::Cloud::DataLabeling::V1beta1::GetDatasetRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DataLabeling::V1beta1::GetDatasetRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_dataset(name: nil)
            #   Pass arguments to `get_dataset` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Dataset resource name, format:
            #     projects/\\{project_id}/datasets/\\{dataset_id}
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::DataLabeling::V1beta1::Dataset]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::DataLabeling::V1beta1::Dataset]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_labeling/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DataLabeling::V1beta1::GetDatasetRequest.new
            #
            #   # Call the get_dataset method.
            #   result = client.get_dataset request
            #
            #   # The returned object is of type Google::Cloud::DataLabeling::V1beta1::Dataset.
            #   p result
            #
            def get_dataset request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataLabeling::V1beta1::GetDatasetRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_dataset.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataLabeling::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_dataset.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_dataset.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_labeling_service_stub.call_rpc :get_dataset, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists datasets under a project. Pagination is supported.
            #
            # @overload list_datasets(request, options = nil)
            #   Pass arguments to `list_datasets` via a request object, either of type
            #   {::Google::Cloud::DataLabeling::V1beta1::ListDatasetsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DataLabeling::V1beta1::ListDatasetsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_datasets(parent: nil, filter: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_datasets` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Dataset resource parent, format:
            #     projects/\\{project_id}
            #   @param filter [::String]
            #     Optional. Filter on dataset is not supported at this moment.
            #   @param page_size [::Integer]
            #     Optional. Requested page size. Server may return fewer results than
            #     requested. Default value is 100.
            #   @param page_token [::String]
            #     Optional. A token identifying a page of results for the server to return.
            #     Typically obtained by
            #     {::Google::Cloud::DataLabeling::V1beta1::ListDatasetsResponse#next_page_token ListDatasetsResponse.next_page_token} of the previous
            #     [DataLabelingService.ListDatasets] call.
            #     Returns the first page if empty.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::DataLabeling::V1beta1::Dataset>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::DataLabeling::V1beta1::Dataset>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_labeling/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DataLabeling::V1beta1::ListDatasetsRequest.new
            #
            #   # Call the list_datasets method.
            #   result = client.list_datasets request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::DataLabeling::V1beta1::Dataset.
            #     p item
            #   end
            #
            def list_datasets request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataLabeling::V1beta1::ListDatasetsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_datasets.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataLabeling::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_datasets.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_datasets.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_labeling_service_stub.call_rpc :list_datasets, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @data_labeling_service_stub, :list_datasets, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a dataset by resource name.
            #
            # @overload delete_dataset(request, options = nil)
            #   Pass arguments to `delete_dataset` via a request object, either of type
            #   {::Google::Cloud::DataLabeling::V1beta1::DeleteDatasetRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DataLabeling::V1beta1::DeleteDatasetRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_dataset(name: nil)
            #   Pass arguments to `delete_dataset` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Dataset resource name, format:
            #     projects/\\{project_id}/datasets/\\{dataset_id}
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_labeling/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DataLabeling::V1beta1::DeleteDatasetRequest.new
            #
            #   # Call the delete_dataset method.
            #   result = client.delete_dataset request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_dataset request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataLabeling::V1beta1::DeleteDatasetRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_dataset.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataLabeling::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_dataset.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_dataset.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_labeling_service_stub.call_rpc :delete_dataset, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Imports data into dataset based on source locations defined in request.
            # It can be called multiple times for the same dataset. Each dataset can
            # only have one long running operation running on it. For example, no
            # labeling task (also long running operation) can be started while
            # importing is still ongoing. Vice versa.
            #
            # @overload import_data(request, options = nil)
            #   Pass arguments to `import_data` via a request object, either of type
            #   {::Google::Cloud::DataLabeling::V1beta1::ImportDataRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DataLabeling::V1beta1::ImportDataRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload import_data(name: nil, input_config: nil, user_email_address: nil)
            #   Pass arguments to `import_data` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Dataset resource name, format:
            #     projects/\\{project_id}/datasets/\\{dataset_id}
            #   @param input_config [::Google::Cloud::DataLabeling::V1beta1::InputConfig, ::Hash]
            #     Required. Specify the input source of the data.
            #   @param user_email_address [::String]
            #     Email of the user who started the import task and should be notified by
            #     email. If empty no notification will be sent.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_labeling/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DataLabeling::V1beta1::ImportDataRequest.new
            #
            #   # Call the import_data method.
            #   result = client.import_data request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def import_data request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataLabeling::V1beta1::ImportDataRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.import_data.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataLabeling::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.import_data.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.import_data.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_labeling_service_stub.call_rpc :import_data, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Exports data and annotations from dataset.
            #
            # @overload export_data(request, options = nil)
            #   Pass arguments to `export_data` via a request object, either of type
            #   {::Google::Cloud::DataLabeling::V1beta1::ExportDataRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DataLabeling::V1beta1::ExportDataRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload export_data(name: nil, annotated_dataset: nil, filter: nil, output_config: nil, user_email_address: nil)
            #   Pass arguments to `export_data` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Dataset resource name, format:
            #     projects/\\{project_id}/datasets/\\{dataset_id}
            #   @param annotated_dataset [::String]
            #     Required. Annotated dataset resource name. DataItem in
            #     Dataset and their annotations in specified annotated dataset will be
            #     exported. It's in format of
            #     projects/\\{project_id}/datasets/\\{dataset_id}/annotatedDatasets/
            #     \\{annotated_dataset_id}
            #   @param filter [::String]
            #     Optional. Filter is not supported at this moment.
            #   @param output_config [::Google::Cloud::DataLabeling::V1beta1::OutputConfig, ::Hash]
            #     Required. Specify the output destination.
            #   @param user_email_address [::String]
            #     Email of the user who started the export task and should be notified by
            #     email. If empty no notification will be sent.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_labeling/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DataLabeling::V1beta1::ExportDataRequest.new
            #
            #   # Call the export_data method.
            #   result = client.export_data request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def export_data request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataLabeling::V1beta1::ExportDataRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.export_data.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataLabeling::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.export_data.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.export_data.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_labeling_service_stub.call_rpc :export_data, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a data item in a dataset by resource name. This API can be
            # called after data are imported into dataset.
            #
            # @overload get_data_item(request, options = nil)
            #   Pass arguments to `get_data_item` via a request object, either of type
            #   {::Google::Cloud::DataLabeling::V1beta1::GetDataItemRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DataLabeling::V1beta1::GetDataItemRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_data_item(name: nil)
            #   Pass arguments to `get_data_item` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the data item to get, format:
            #     projects/\\{project_id}/datasets/\\{dataset_id}/dataItems/\\{data_item_id}
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::DataLabeling::V1beta1::DataItem]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::DataLabeling::V1beta1::DataItem]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_labeling/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DataLabeling::V1beta1::GetDataItemRequest.new
            #
            #   # Call the get_data_item method.
            #   result = client.get_data_item request
            #
            #   # The returned object is of type Google::Cloud::DataLabeling::V1beta1::DataItem.
            #   p result
            #
            def get_data_item request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataLabeling::V1beta1::GetDataItemRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_data_item.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataLabeling::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_data_item.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_data_item.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_labeling_service_stub.call_rpc :get_data_item, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists data items in a dataset. This API can be called after data
            # are imported into dataset. Pagination is supported.
            #
            # @overload list_data_items(request, options = nil)
            #   Pass arguments to `list_data_items` via a request object, either of type
            #   {::Google::Cloud::DataLabeling::V1beta1::ListDataItemsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DataLabeling::V1beta1::ListDataItemsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_data_items(parent: nil, filter: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_data_items` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Name of the dataset to list data items, format:
            #     projects/\\{project_id}/datasets/\\{dataset_id}
            #   @param filter [::String]
            #     Optional. Filter is not supported at this moment.
            #   @param page_size [::Integer]
            #     Optional. Requested page size. Server may return fewer results than
            #     requested. Default value is 100.
            #   @param page_token [::String]
            #     Optional. A token identifying a page of results for the server to return.
            #     Typically obtained by
            #     {::Google::Cloud::DataLabeling::V1beta1::ListDataItemsResponse#next_page_token ListDataItemsResponse.next_page_token} of the previous
            #     [DataLabelingService.ListDataItems] call.
            #     Return first page if empty.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::DataLabeling::V1beta1::DataItem>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::DataLabeling::V1beta1::DataItem>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_labeling/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DataLabeling::V1beta1::ListDataItemsRequest.new
            #
            #   # Call the list_data_items method.
            #   result = client.list_data_items request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::DataLabeling::V1beta1::DataItem.
            #     p item
            #   end
            #
            def list_data_items request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataLabeling::V1beta1::ListDataItemsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_data_items.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataLabeling::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_data_items.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_data_items.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_labeling_service_stub.call_rpc :list_data_items, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @data_labeling_service_stub, :list_data_items, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets an annotated dataset by resource name.
            #
            # @overload get_annotated_dataset(request, options = nil)
            #   Pass arguments to `get_annotated_dataset` via a request object, either of type
            #   {::Google::Cloud::DataLabeling::V1beta1::GetAnnotatedDatasetRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DataLabeling::V1beta1::GetAnnotatedDatasetRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_annotated_dataset(name: nil)
            #   Pass arguments to `get_annotated_dataset` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the annotated dataset to get, format:
            #     projects/\\{project_id}/datasets/\\{dataset_id}/annotatedDatasets/
            #     \\{annotated_dataset_id}
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::DataLabeling::V1beta1::AnnotatedDataset]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::DataLabeling::V1beta1::AnnotatedDataset]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_labeling/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DataLabeling::V1beta1::GetAnnotatedDatasetRequest.new
            #
            #   # Call the get_annotated_dataset method.
            #   result = client.get_annotated_dataset request
            #
            #   # The returned object is of type Google::Cloud::DataLabeling::V1beta1::AnnotatedDataset.
            #   p result
            #
            def get_annotated_dataset request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataLabeling::V1beta1::GetAnnotatedDatasetRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_annotated_dataset.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataLabeling::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_annotated_dataset.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_annotated_dataset.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_labeling_service_stub.call_rpc :get_annotated_dataset, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists annotated datasets for a dataset. Pagination is supported.
            #
            # @overload list_annotated_datasets(request, options = nil)
            #   Pass arguments to `list_annotated_datasets` via a request object, either of type
            #   {::Google::Cloud::DataLabeling::V1beta1::ListAnnotatedDatasetsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DataLabeling::V1beta1::ListAnnotatedDatasetsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_annotated_datasets(parent: nil, filter: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_annotated_datasets` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Name of the dataset to list annotated datasets, format:
            #     projects/\\{project_id}/datasets/\\{dataset_id}
            #   @param filter [::String]
            #     Optional. Filter is not supported at this moment.
            #   @param page_size [::Integer]
            #     Optional. Requested page size. Server may return fewer results than
            #     requested. Default value is 100.
            #   @param page_token [::String]
            #     Optional. A token identifying a page of results for the server to return.
            #     Typically obtained by
            #     {::Google::Cloud::DataLabeling::V1beta1::ListAnnotatedDatasetsResponse#next_page_token ListAnnotatedDatasetsResponse.next_page_token} of the previous
            #     [DataLabelingService.ListAnnotatedDatasets] call.
            #     Return first page if empty.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::DataLabeling::V1beta1::AnnotatedDataset>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::DataLabeling::V1beta1::AnnotatedDataset>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_labeling/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DataLabeling::V1beta1::ListAnnotatedDatasetsRequest.new
            #
            #   # Call the list_annotated_datasets method.
            #   result = client.list_annotated_datasets request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::DataLabeling::V1beta1::AnnotatedDataset.
            #     p item
            #   end
            #
            def list_annotated_datasets request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataLabeling::V1beta1::ListAnnotatedDatasetsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_annotated_datasets.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataLabeling::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_annotated_datasets.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_annotated_datasets.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_labeling_service_stub.call_rpc :list_annotated_datasets, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @data_labeling_service_stub, :list_annotated_datasets, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes an annotated dataset by resource name.
            #
            # @overload delete_annotated_dataset(request, options = nil)
            #   Pass arguments to `delete_annotated_dataset` via a request object, either of type
            #   {::Google::Cloud::DataLabeling::V1beta1::DeleteAnnotatedDatasetRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DataLabeling::V1beta1::DeleteAnnotatedDatasetRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_annotated_dataset(name: nil)
            #   Pass arguments to `delete_annotated_dataset` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the annotated dataset to delete, format:
            #     projects/\\{project_id}/datasets/\\{dataset_id}/annotatedDatasets/
            #     \\{annotated_dataset_id}
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_labeling/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DataLabeling::V1beta1::DeleteAnnotatedDatasetRequest.new
            #
            #   # Call the delete_annotated_dataset method.
            #   result = client.delete_annotated_dataset request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_annotated_dataset request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataLabeling::V1beta1::DeleteAnnotatedDatasetRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_annotated_dataset.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataLabeling::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_annotated_dataset.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_annotated_dataset.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_labeling_service_stub.call_rpc :delete_annotated_dataset, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Starts a labeling task for image. The type of image labeling task is
            # configured by feature in the request.
            #
            # @overload label_image(request, options = nil)
            #   Pass arguments to `label_image` via a request object, either of type
            #   {::Google::Cloud::DataLabeling::V1beta1::LabelImageRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DataLabeling::V1beta1::LabelImageRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload label_image(image_classification_config: nil, bounding_poly_config: nil, polyline_config: nil, segmentation_config: nil, parent: nil, basic_config: nil, feature: nil)
            #   Pass arguments to `label_image` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param image_classification_config [::Google::Cloud::DataLabeling::V1beta1::ImageClassificationConfig, ::Hash]
            #     Configuration for image classification task.
            #     One of image_classification_config, bounding_poly_config,
            #     polyline_config and segmentation_config are required.
            #
            #     Note: The following parameters are mutually exclusive: `image_classification_config`, `bounding_poly_config`, `polyline_config`, `segmentation_config`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param bounding_poly_config [::Google::Cloud::DataLabeling::V1beta1::BoundingPolyConfig, ::Hash]
            #     Configuration for bounding box and bounding poly task.
            #     One of image_classification_config, bounding_poly_config,
            #     polyline_config and segmentation_config are required.
            #
            #     Note: The following parameters are mutually exclusive: `bounding_poly_config`, `image_classification_config`, `polyline_config`, `segmentation_config`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param polyline_config [::Google::Cloud::DataLabeling::V1beta1::PolylineConfig, ::Hash]
            #     Configuration for polyline task.
            #     One of image_classification_config, bounding_poly_config,
            #     polyline_config and segmentation_config are required.
            #
            #     Note: The following parameters are mutually exclusive: `polyline_config`, `image_classification_config`, `bounding_poly_config`, `segmentation_config`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param segmentation_config [::Google::Cloud::DataLabeling::V1beta1::SegmentationConfig, ::Hash]
            #     Configuration for segmentation task.
            #     One of image_classification_config, bounding_poly_config,
            #     polyline_config and segmentation_config are required.
            #
            #     Note: The following parameters are mutually exclusive: `segmentation_config`, `image_classification_config`, `bounding_poly_config`, `polyline_config`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param parent [::String]
            #     Required. Name of the dataset to request labeling task, format:
            #     projects/\\{project_id}/datasets/\\{dataset_id}
            #   @param basic_config [::Google::Cloud::DataLabeling::V1beta1::HumanAnnotationConfig, ::Hash]
            #     Required. Basic human annotation config.
            #   @param feature [::Google::Cloud::DataLabeling::V1beta1::LabelImageRequest::Feature]
            #     Required. The type of image labeling task.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_labeling/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DataLabeling::V1beta1::LabelImageRequest.new
            #
            #   # Call the label_image method.
            #   result = client.label_image request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def label_image request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataLabeling::V1beta1::LabelImageRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.label_image.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataLabeling::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.label_image.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.label_image.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_labeling_service_stub.call_rpc :label_image, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Starts a labeling task for video. The type of video labeling task is
            # configured by feature in the request.
            #
            # @overload label_video(request, options = nil)
            #   Pass arguments to `label_video` via a request object, either of type
            #   {::Google::Cloud::DataLabeling::V1beta1::LabelVideoRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DataLabeling::V1beta1::LabelVideoRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload label_video(video_classification_config: nil, object_detection_config: nil, object_tracking_config: nil, event_config: nil, parent: nil, basic_config: nil, feature: nil)
            #   Pass arguments to `label_video` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param video_classification_config [::Google::Cloud::DataLabeling::V1beta1::VideoClassificationConfig, ::Hash]
            #     Configuration for video classification task.
            #     One of video_classification_config, object_detection_config,
            #     object_tracking_config and event_config is required.
            #
            #     Note: The following parameters are mutually exclusive: `video_classification_config`, `object_detection_config`, `object_tracking_config`, `event_config`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param object_detection_config [::Google::Cloud::DataLabeling::V1beta1::ObjectDetectionConfig, ::Hash]
            #     Configuration for video object detection task.
            #     One of video_classification_config, object_detection_config,
            #     object_tracking_config and event_config is required.
            #
            #     Note: The following parameters are mutually exclusive: `object_detection_config`, `video_classification_config`, `object_tracking_config`, `event_config`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param object_tracking_config [::Google::Cloud::DataLabeling::V1beta1::ObjectTrackingConfig, ::Hash]
            #     Configuration for video object tracking task.
            #     One of video_classification_config, object_detection_config,
            #     object_tracking_config and event_config is required.
            #
            #     Note: The following parameters are mutually exclusive: `object_tracking_config`, `video_classification_config`, `object_detection_config`, `event_config`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param event_config [::Google::Cloud::DataLabeling::V1beta1::EventConfig, ::Hash]
            #     Configuration for video event task.
            #     One of video_classification_config, object_detection_config,
            #     object_tracking_config and event_config is required.
            #
            #     Note: The following parameters are mutually exclusive: `event_config`, `video_classification_config`, `object_detection_config`, `object_tracking_config`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param parent [::String]
            #     Required. Name of the dataset to request labeling task, format:
            #     projects/\\{project_id}/datasets/\\{dataset_id}
            #   @param basic_config [::Google::Cloud::DataLabeling::V1beta1::HumanAnnotationConfig, ::Hash]
            #     Required. Basic human annotation config.
            #   @param feature [::Google::Cloud::DataLabeling::V1beta1::LabelVideoRequest::Feature]
            #     Required. The type of video labeling task.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_labeling/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DataLabeling::V1beta1::LabelVideoRequest.new
            #
            #   # Call the label_video method.
            #   result = client.label_video request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def label_video request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataLabeling::V1beta1::LabelVideoRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.label_video.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataLabeling::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.label_video.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.label_video.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_labeling_service_stub.call_rpc :label_video, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Starts a labeling task for text. The type of text labeling task is
            # configured by feature in the request.
            #
            # @overload label_text(request, options = nil)
            #   Pass arguments to `label_text` via a request object, either of type
            #   {::Google::Cloud::DataLabeling::V1beta1::LabelTextRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DataLabeling::V1beta1::LabelTextRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload label_text(text_classification_config: nil, text_entity_extraction_config: nil, parent: nil, basic_config: nil, feature: nil)
            #   Pass arguments to `label_text` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param text_classification_config [::Google::Cloud::DataLabeling::V1beta1::TextClassificationConfig, ::Hash]
            #     Configuration for text classification task.
            #     One of text_classification_config and text_entity_extraction_config
            #     is required.
            #
            #     Note: The following parameters are mutually exclusive: `text_classification_config`, `text_entity_extraction_config`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param text_entity_extraction_config [::Google::Cloud::DataLabeling::V1beta1::TextEntityExtractionConfig, ::Hash]
            #     Configuration for entity extraction task.
            #     One of text_classification_config and text_entity_extraction_config
            #     is required.
            #
            #     Note: The following parameters are mutually exclusive: `text_entity_extraction_config`, `text_classification_config`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param parent [::String]
            #     Required. Name of the data set to request labeling task, format:
            #     projects/\\{project_id}/datasets/\\{dataset_id}
            #   @param basic_config [::Google::Cloud::DataLabeling::V1beta1::HumanAnnotationConfig, ::Hash]
            #     Required. Basic human annotation config.
            #   @param feature [::Google::Cloud::DataLabeling::V1beta1::LabelTextRequest::Feature]
            #     Required. The type of text labeling task.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_labeling/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DataLabeling::V1beta1::LabelTextRequest.new
            #
            #   # Call the label_text method.
            #   result = client.label_text request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def label_text request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataLabeling::V1beta1::LabelTextRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.label_text.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataLabeling::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.label_text.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.label_text.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_labeling_service_stub.call_rpc :label_text, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets an example by resource name, including both data and annotation.
            #
            # @overload get_example(request, options = nil)
            #   Pass arguments to `get_example` via a request object, either of type
            #   {::Google::Cloud::DataLabeling::V1beta1::GetExampleRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DataLabeling::V1beta1::GetExampleRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_example(name: nil, filter: nil)
            #   Pass arguments to `get_example` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of example, format:
            #     projects/\\{project_id}/datasets/\\{dataset_id}/annotatedDatasets/
            #     \\{annotated_dataset_id}/examples/\\{example_id}
            #   @param filter [::String]
            #     Optional. An expression for filtering Examples. Filter by
            #     annotation_spec.display_name is supported. Format
            #     "annotation_spec.display_name = \\{display_name}"
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::DataLabeling::V1beta1::Example]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::DataLabeling::V1beta1::Example]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_labeling/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DataLabeling::V1beta1::GetExampleRequest.new
            #
            #   # Call the get_example method.
            #   result = client.get_example request
            #
            #   # The returned object is of type Google::Cloud::DataLabeling::V1beta1::Example.
            #   p result
            #
            def get_example request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataLabeling::V1beta1::GetExampleRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_example.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataLabeling::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_example.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_example.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_labeling_service_stub.call_rpc :get_example, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists examples in an annotated dataset. Pagination is supported.
            #
            # @overload list_examples(request, options = nil)
            #   Pass arguments to `list_examples` via a request object, either of type
            #   {::Google::Cloud::DataLabeling::V1beta1::ListExamplesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DataLabeling::V1beta1::ListExamplesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_examples(parent: nil, filter: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_examples` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Example resource parent.
            #   @param filter [::String]
            #     Optional. An expression for filtering Examples. For annotated datasets that
            #     have annotation spec set, filter by
            #     annotation_spec.display_name is supported. Format
            #     "annotation_spec.display_name = \\{display_name}"
            #   @param page_size [::Integer]
            #     Optional. Requested page size. Server may return fewer results than
            #     requested. Default value is 100.
            #   @param page_token [::String]
            #     Optional. A token identifying a page of results for the server to return.
            #     Typically obtained by
            #     {::Google::Cloud::DataLabeling::V1beta1::ListExamplesResponse#next_page_token ListExamplesResponse.next_page_token} of the previous
            #     [DataLabelingService.ListExamples] call.
            #     Return first page if empty.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::DataLabeling::V1beta1::Example>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::DataLabeling::V1beta1::Example>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_labeling/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DataLabeling::V1beta1::ListExamplesRequest.new
            #
            #   # Call the list_examples method.
            #   result = client.list_examples request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::DataLabeling::V1beta1::Example.
            #     p item
            #   end
            #
            def list_examples request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataLabeling::V1beta1::ListExamplesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_examples.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataLabeling::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_examples.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_examples.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_labeling_service_stub.call_rpc :list_examples, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @data_labeling_service_stub, :list_examples, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates an annotation spec set by providing a set of labels.
            #
            # @overload create_annotation_spec_set(request, options = nil)
            #   Pass arguments to `create_annotation_spec_set` via a request object, either of type
            #   {::Google::Cloud::DataLabeling::V1beta1::CreateAnnotationSpecSetRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DataLabeling::V1beta1::CreateAnnotationSpecSetRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_annotation_spec_set(parent: nil, annotation_spec_set: nil)
            #   Pass arguments to `create_annotation_spec_set` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. AnnotationSpecSet resource parent, format:
            #     projects/\\{project_id}
            #   @param annotation_spec_set [::Google::Cloud::DataLabeling::V1beta1::AnnotationSpecSet, ::Hash]
            #     Required. Annotation spec set to create. Annotation specs must be included.
            #     Only one annotation spec will be accepted for annotation specs with same
            #     display_name.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::DataLabeling::V1beta1::AnnotationSpecSet]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::DataLabeling::V1beta1::AnnotationSpecSet]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_labeling/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DataLabeling::V1beta1::CreateAnnotationSpecSetRequest.new
            #
            #   # Call the create_annotation_spec_set method.
            #   result = client.create_annotation_spec_set request
            #
            #   # The returned object is of type Google::Cloud::DataLabeling::V1beta1::AnnotationSpecSet.
            #   p result
            #
            def create_annotation_spec_set request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataLabeling::V1beta1::CreateAnnotationSpecSetRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_annotation_spec_set.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataLabeling::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_annotation_spec_set.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_annotation_spec_set.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_labeling_service_stub.call_rpc :create_annotation_spec_set, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets an annotation spec set by resource name.
            #
            # @overload get_annotation_spec_set(request, options = nil)
            #   Pass arguments to `get_annotation_spec_set` via a request object, either of type
            #   {::Google::Cloud::DataLabeling::V1beta1::GetAnnotationSpecSetRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DataLabeling::V1beta1::GetAnnotationSpecSetRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_annotation_spec_set(name: nil)
            #   Pass arguments to `get_annotation_spec_set` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. AnnotationSpecSet resource name, format:
            #     projects/\\{project_id}/annotationSpecSets/\\{annotation_spec_set_id}
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::DataLabeling::V1beta1::AnnotationSpecSet]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::DataLabeling::V1beta1::AnnotationSpecSet]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_labeling/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DataLabeling::V1beta1::GetAnnotationSpecSetRequest.new
            #
            #   # Call the get_annotation_spec_set method.
            #   result = client.get_annotation_spec_set request
            #
            #   # The returned object is of type Google::Cloud::DataLabeling::V1beta1::AnnotationSpecSet.
            #   p result
            #
            def get_annotation_spec_set request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataLabeling::V1beta1::GetAnnotationSpecSetRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_annotation_spec_set.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataLabeling::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_annotation_spec_set.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_annotation_spec_set.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_labeling_service_stub.call_rpc :get_annotation_spec_set, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists annotation spec sets for a project. Pagination is supported.
            #
            # @overload list_annotation_spec_sets(request, options = nil)
            #   Pass arguments to `list_annotation_spec_sets` via a request object, either of type
            #   {::Google::Cloud::DataLabeling::V1beta1::ListAnnotationSpecSetsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DataLabeling::V1beta1::ListAnnotationSpecSetsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_annotation_spec_sets(parent: nil, filter: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_annotation_spec_sets` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Parent of AnnotationSpecSet resource, format:
            #     projects/\\{project_id}
            #   @param filter [::String]
            #     Optional. Filter is not supported at this moment.
            #   @param page_size [::Integer]
            #     Optional. Requested page size. Server may return fewer results than
            #     requested. Default value is 100.
            #   @param page_token [::String]
            #     Optional. A token identifying a page of results for the server to return.
            #     Typically obtained by
            #     {::Google::Cloud::DataLabeling::V1beta1::ListAnnotationSpecSetsResponse#next_page_token ListAnnotationSpecSetsResponse.next_page_token} of the previous
            #     [DataLabelingService.ListAnnotationSpecSets] call.
            #     Return first page if empty.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::DataLabeling::V1beta1::AnnotationSpecSet>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::DataLabeling::V1beta1::AnnotationSpecSet>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_labeling/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DataLabeling::V1beta1::ListAnnotationSpecSetsRequest.new
            #
            #   # Call the list_annotation_spec_sets method.
            #   result = client.list_annotation_spec_sets request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::DataLabeling::V1beta1::AnnotationSpecSet.
            #     p item
            #   end
            #
            def list_annotation_spec_sets request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataLabeling::V1beta1::ListAnnotationSpecSetsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_annotation_spec_sets.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataLabeling::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_annotation_spec_sets.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_annotation_spec_sets.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_labeling_service_stub.call_rpc :list_annotation_spec_sets, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @data_labeling_service_stub, :list_annotation_spec_sets, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes an annotation spec set by resource name.
            #
            # @overload delete_annotation_spec_set(request, options = nil)
            #   Pass arguments to `delete_annotation_spec_set` via a request object, either of type
            #   {::Google::Cloud::DataLabeling::V1beta1::DeleteAnnotationSpecSetRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DataLabeling::V1beta1::DeleteAnnotationSpecSetRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_annotation_spec_set(name: nil)
            #   Pass arguments to `delete_annotation_spec_set` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. AnnotationSpec resource name, format:
            #     `projects/{project_id}/annotationSpecSets/{annotation_spec_set_id}`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_labeling/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DataLabeling::V1beta1::DeleteAnnotationSpecSetRequest.new
            #
            #   # Call the delete_annotation_spec_set method.
            #   result = client.delete_annotation_spec_set request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_annotation_spec_set request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataLabeling::V1beta1::DeleteAnnotationSpecSetRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_annotation_spec_set.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataLabeling::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_annotation_spec_set.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_annotation_spec_set.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_labeling_service_stub.call_rpc :delete_annotation_spec_set, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates an instruction for how data should be labeled.
            #
            # @overload create_instruction(request, options = nil)
            #   Pass arguments to `create_instruction` via a request object, either of type
            #   {::Google::Cloud::DataLabeling::V1beta1::CreateInstructionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DataLabeling::V1beta1::CreateInstructionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_instruction(parent: nil, instruction: nil)
            #   Pass arguments to `create_instruction` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Instruction resource parent, format:
            #     projects/\\{project_id}
            #   @param instruction [::Google::Cloud::DataLabeling::V1beta1::Instruction, ::Hash]
            #     Required. Instruction of how to perform the labeling task.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_labeling/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DataLabeling::V1beta1::CreateInstructionRequest.new
            #
            #   # Call the create_instruction method.
            #   result = client.create_instruction request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_instruction request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataLabeling::V1beta1::CreateInstructionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_instruction.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataLabeling::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_instruction.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_instruction.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_labeling_service_stub.call_rpc :create_instruction, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets an instruction by resource name.
            #
            # @overload get_instruction(request, options = nil)
            #   Pass arguments to `get_instruction` via a request object, either of type
            #   {::Google::Cloud::DataLabeling::V1beta1::GetInstructionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DataLabeling::V1beta1::GetInstructionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_instruction(name: nil)
            #   Pass arguments to `get_instruction` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Instruction resource name, format:
            #     projects/\\{project_id}/instructions/\\{instruction_id}
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::DataLabeling::V1beta1::Instruction]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::DataLabeling::V1beta1::Instruction]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_labeling/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DataLabeling::V1beta1::GetInstructionRequest.new
            #
            #   # Call the get_instruction method.
            #   result = client.get_instruction request
            #
            #   # The returned object is of type Google::Cloud::DataLabeling::V1beta1::Instruction.
            #   p result
            #
            def get_instruction request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataLabeling::V1beta1::GetInstructionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_instruction.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataLabeling::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_instruction.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_instruction.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_labeling_service_stub.call_rpc :get_instruction, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists instructions for a project. Pagination is supported.
            #
            # @overload list_instructions(request, options = nil)
            #   Pass arguments to `list_instructions` via a request object, either of type
            #   {::Google::Cloud::DataLabeling::V1beta1::ListInstructionsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DataLabeling::V1beta1::ListInstructionsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_instructions(parent: nil, filter: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_instructions` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Instruction resource parent, format:
            #     projects/\\{project_id}
            #   @param filter [::String]
            #     Optional. Filter is not supported at this moment.
            #   @param page_size [::Integer]
            #     Optional. Requested page size. Server may return fewer results than
            #     requested. Default value is 100.
            #   @param page_token [::String]
            #     Optional. A token identifying a page of results for the server to return.
            #     Typically obtained by
            #     {::Google::Cloud::DataLabeling::V1beta1::ListInstructionsResponse#next_page_token ListInstructionsResponse.next_page_token} of the previous
            #     [DataLabelingService.ListInstructions] call.
            #     Return first page if empty.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::DataLabeling::V1beta1::Instruction>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::DataLabeling::V1beta1::Instruction>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_labeling/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DataLabeling::V1beta1::ListInstructionsRequest.new
            #
            #   # Call the list_instructions method.
            #   result = client.list_instructions request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::DataLabeling::V1beta1::Instruction.
            #     p item
            #   end
            #
            def list_instructions request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataLabeling::V1beta1::ListInstructionsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_instructions.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataLabeling::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_instructions.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_instructions.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_labeling_service_stub.call_rpc :list_instructions, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @data_labeling_service_stub, :list_instructions, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes an instruction object by resource name.
            #
            # @overload delete_instruction(request, options = nil)
            #   Pass arguments to `delete_instruction` via a request object, either of type
            #   {::Google::Cloud::DataLabeling::V1beta1::DeleteInstructionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DataLabeling::V1beta1::DeleteInstructionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_instruction(name: nil)
            #   Pass arguments to `delete_instruction` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Instruction resource name, format:
            #     projects/\\{project_id}/instructions/\\{instruction_id}
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_labeling/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DataLabeling::V1beta1::DeleteInstructionRequest.new
            #
            #   # Call the delete_instruction method.
            #   result = client.delete_instruction request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_instruction request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataLabeling::V1beta1::DeleteInstructionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_instruction.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataLabeling::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_instruction.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_instruction.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_labeling_service_stub.call_rpc :delete_instruction, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets an evaluation by resource name (to search, use
            # {::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client#search_evaluations projects.evaluations.search}).
            #
            # @overload get_evaluation(request, options = nil)
            #   Pass arguments to `get_evaluation` via a request object, either of type
            #   {::Google::Cloud::DataLabeling::V1beta1::GetEvaluationRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DataLabeling::V1beta1::GetEvaluationRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_evaluation(name: nil)
            #   Pass arguments to `get_evaluation` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the evaluation. Format:
            #
            #     "projects/<var>\\{project_id}</var>/datasets/<var>\\{dataset_id}</var>/evaluations/<var>\\{evaluation_id}</var>'
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::DataLabeling::V1beta1::Evaluation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::DataLabeling::V1beta1::Evaluation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_labeling/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DataLabeling::V1beta1::GetEvaluationRequest.new
            #
            #   # Call the get_evaluation method.
            #   result = client.get_evaluation request
            #
            #   # The returned object is of type Google::Cloud::DataLabeling::V1beta1::Evaluation.
            #   p result
            #
            def get_evaluation request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataLabeling::V1beta1::GetEvaluationRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_evaluation.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataLabeling::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_evaluation.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_evaluation.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_labeling_service_stub.call_rpc :get_evaluation, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Searches {::Google::Cloud::DataLabeling::V1beta1::Evaluation evaluations} within a project.
            #
            # @overload search_evaluations(request, options = nil)
            #   Pass arguments to `search_evaluations` via a request object, either of type
            #   {::Google::Cloud::DataLabeling::V1beta1::SearchEvaluationsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DataLabeling::V1beta1::SearchEvaluationsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload search_evaluations(parent: nil, filter: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `search_evaluations` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Evaluation search parent (project ID). Format:
            #     "projects/<var>\\{project_id}</var>"
            #   @param filter [::String]
            #     Optional. To search evaluations, you can filter by the following:
            #
            #     * evaluation<span>_</span>job.evaluation_job_id (the last part of
            #       {::Google::Cloud::DataLabeling::V1beta1::EvaluationJob#name EvaluationJob.name})
            #     * evaluation<span>_</span>job.model_id (the <var>\\{model_name}</var> portion
            #       of {::Google::Cloud::DataLabeling::V1beta1::EvaluationJob#model_version EvaluationJob.modelVersion})
            #     * evaluation<span>_</span>job.evaluation_job_run_time_start (Minimum
            #       threshold for the
            #       {::Google::Cloud::DataLabeling::V1beta1::Evaluation#evaluation_job_run_time evaluationJobRunTime} that created
            #       the evaluation)
            #     * evaluation<span>_</span>job.evaluation_job_run_time_end (Maximum
            #       threshold for the
            #       {::Google::Cloud::DataLabeling::V1beta1::Evaluation#evaluation_job_run_time evaluationJobRunTime} that created
            #       the evaluation)
            #     * evaluation<span>_</span>job.job_state ({::Google::Cloud::DataLabeling::V1beta1::EvaluationJob#state EvaluationJob.state})
            #     * annotation<span>_</span>spec.display_name (the Evaluation contains a
            #       metric for the annotation spec with this
            #       {::Google::Cloud::DataLabeling::V1beta1::AnnotationSpec#display_name displayName})
            #
            #     To filter by multiple critiera, use the `AND` operator or the `OR`
            #     operator. The following examples shows a string that filters by several
            #     critiera:
            #
            #     "evaluation<span>_</span>job.evaluation_job_id =
            #     <var>\\{evaluation_job_id}</var> AND evaluation<span>_</span>job.model_id =
            #     <var>\\{model_name}</var> AND
            #     evaluation<span>_</span>job.evaluation_job_run_time_start =
            #     <var>\\{timestamp_1}</var> AND
            #     evaluation<span>_</span>job.evaluation_job_run_time_end =
            #     <var>\\{timestamp_2}</var> AND annotation<span>_</span>spec.display_name =
            #     <var>\\{display_name}</var>"
            #   @param page_size [::Integer]
            #     Optional. Requested page size. Server may return fewer results than
            #     requested. Default value is 100.
            #   @param page_token [::String]
            #     Optional. A token identifying a page of results for the server to return.
            #     Typically obtained by the
            #     {::Google::Cloud::DataLabeling::V1beta1::SearchEvaluationsResponse#next_page_token nextPageToken} of the response
            #     to a previous search request.
            #
            #     If you don't specify this field, the API call requests the first page of
            #     the search.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::DataLabeling::V1beta1::Evaluation>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::DataLabeling::V1beta1::Evaluation>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_labeling/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DataLabeling::V1beta1::SearchEvaluationsRequest.new
            #
            #   # Call the search_evaluations method.
            #   result = client.search_evaluations request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::DataLabeling::V1beta1::Evaluation.
            #     p item
            #   end
            #
            def search_evaluations request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataLabeling::V1beta1::SearchEvaluationsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.search_evaluations.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataLabeling::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.search_evaluations.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.search_evaluations.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_labeling_service_stub.call_rpc :search_evaluations, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @data_labeling_service_stub, :search_evaluations, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Searches example comparisons from an evaluation. The return format is a
            # list of example comparisons that show ground truth and prediction(s) for
            # a single input. Search by providing an evaluation ID.
            #
            # @overload search_example_comparisons(request, options = nil)
            #   Pass arguments to `search_example_comparisons` via a request object, either of type
            #   {::Google::Cloud::DataLabeling::V1beta1::SearchExampleComparisonsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DataLabeling::V1beta1::SearchExampleComparisonsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload search_example_comparisons(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `search_example_comparisons` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Name of the {::Google::Cloud::DataLabeling::V1beta1::Evaluation Evaluation} resource to search for example
            #     comparisons from. Format:
            #
            #     "projects/<var>\\{project_id}</var>/datasets/<var>\\{dataset_id}</var>/evaluations/<var>\\{evaluation_id}</var>"
            #   @param page_size [::Integer]
            #     Optional. Requested page size. Server may return fewer results than
            #     requested. Default value is 100.
            #   @param page_token [::String]
            #     Optional. A token identifying a page of results for the server to return.
            #     Typically obtained by the
            #     [nextPageToken][SearchExampleComparisons.next_page_token] of the response
            #     to a previous search rquest.
            #
            #     If you don't specify this field, the API call requests the first page of
            #     the search.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::DataLabeling::V1beta1::SearchExampleComparisonsResponse::ExampleComparison>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::DataLabeling::V1beta1::SearchExampleComparisonsResponse::ExampleComparison>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_labeling/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DataLabeling::V1beta1::SearchExampleComparisonsRequest.new
            #
            #   # Call the search_example_comparisons method.
            #   result = client.search_example_comparisons request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::DataLabeling::V1beta1::SearchExampleComparisonsResponse::ExampleComparison.
            #     p item
            #   end
            #
            def search_example_comparisons request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataLabeling::V1beta1::SearchExampleComparisonsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.search_example_comparisons.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataLabeling::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.search_example_comparisons.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.search_example_comparisons.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_labeling_service_stub.call_rpc :search_example_comparisons, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @data_labeling_service_stub, :search_example_comparisons, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates an evaluation job.
            #
            # @overload create_evaluation_job(request, options = nil)
            #   Pass arguments to `create_evaluation_job` via a request object, either of type
            #   {::Google::Cloud::DataLabeling::V1beta1::CreateEvaluationJobRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DataLabeling::V1beta1::CreateEvaluationJobRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_evaluation_job(parent: nil, job: nil)
            #   Pass arguments to `create_evaluation_job` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Evaluation job resource parent. Format:
            #     "projects/<var>\\{project_id}</var>"
            #   @param job [::Google::Cloud::DataLabeling::V1beta1::EvaluationJob, ::Hash]
            #     Required. The evaluation job to create.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::DataLabeling::V1beta1::EvaluationJob]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::DataLabeling::V1beta1::EvaluationJob]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_labeling/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DataLabeling::V1beta1::CreateEvaluationJobRequest.new
            #
            #   # Call the create_evaluation_job method.
            #   result = client.create_evaluation_job request
            #
            #   # The returned object is of type Google::Cloud::DataLabeling::V1beta1::EvaluationJob.
            #   p result
            #
            def create_evaluation_job request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataLabeling::V1beta1::CreateEvaluationJobRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_evaluation_job.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataLabeling::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_evaluation_job.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_evaluation_job.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_labeling_service_stub.call_rpc :create_evaluation_job, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates an evaluation job. You can only update certain fields of the job's
            # {::Google::Cloud::DataLabeling::V1beta1::EvaluationJobConfig EvaluationJobConfig}: `humanAnnotationConfig.instruction`,
            # `exampleCount`, and `exampleSamplePercentage`.
            #
            # If you want to change any other aspect of the evaluation job, you must
            # delete the job and create a new one.
            #
            # @overload update_evaluation_job(request, options = nil)
            #   Pass arguments to `update_evaluation_job` via a request object, either of type
            #   {::Google::Cloud::DataLabeling::V1beta1::UpdateEvaluationJobRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DataLabeling::V1beta1::UpdateEvaluationJobRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_evaluation_job(evaluation_job: nil, update_mask: nil)
            #   Pass arguments to `update_evaluation_job` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param evaluation_job [::Google::Cloud::DataLabeling::V1beta1::EvaluationJob, ::Hash]
            #     Required. Evaluation job that is going to be updated.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Optional. Mask for which fields to update. You can only provide the
            #     following fields:
            #
            #     * `evaluationJobConfig.humanAnnotationConfig.instruction`
            #     * `evaluationJobConfig.exampleCount`
            #     * `evaluationJobConfig.exampleSamplePercentage`
            #
            #     You can provide more than one of these fields by separating them with
            #     commas.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::DataLabeling::V1beta1::EvaluationJob]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::DataLabeling::V1beta1::EvaluationJob]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_labeling/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DataLabeling::V1beta1::UpdateEvaluationJobRequest.new
            #
            #   # Call the update_evaluation_job method.
            #   result = client.update_evaluation_job request
            #
            #   # The returned object is of type Google::Cloud::DataLabeling::V1beta1::EvaluationJob.
            #   p result
            #
            def update_evaluation_job request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataLabeling::V1beta1::UpdateEvaluationJobRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_evaluation_job.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataLabeling::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.evaluation_job&.name
                header_params["evaluation_job.name"] = request.evaluation_job.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_evaluation_job.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_evaluation_job.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_labeling_service_stub.call_rpc :update_evaluation_job, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets an evaluation job by resource name.
            #
            # @overload get_evaluation_job(request, options = nil)
            #   Pass arguments to `get_evaluation_job` via a request object, either of type
            #   {::Google::Cloud::DataLabeling::V1beta1::GetEvaluationJobRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DataLabeling::V1beta1::GetEvaluationJobRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_evaluation_job(name: nil)
            #   Pass arguments to `get_evaluation_job` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the evaluation job. Format:
            #
            #     "projects/<var>\\{project_id}</var>/evaluationJobs/<var>\\{evaluation_job_id}</var>"
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::DataLabeling::V1beta1::EvaluationJob]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::DataLabeling::V1beta1::EvaluationJob]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_labeling/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DataLabeling::V1beta1::GetEvaluationJobRequest.new
            #
            #   # Call the get_evaluation_job method.
            #   result = client.get_evaluation_job request
            #
            #   # The returned object is of type Google::Cloud::DataLabeling::V1beta1::EvaluationJob.
            #   p result
            #
            def get_evaluation_job request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataLabeling::V1beta1::GetEvaluationJobRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_evaluation_job.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataLabeling::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_evaluation_job.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_evaluation_job.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_labeling_service_stub.call_rpc :get_evaluation_job, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Pauses an evaluation job. Pausing an evaluation job that is already in a
            # `PAUSED` state is a no-op.
            #
            # @overload pause_evaluation_job(request, options = nil)
            #   Pass arguments to `pause_evaluation_job` via a request object, either of type
            #   {::Google::Cloud::DataLabeling::V1beta1::PauseEvaluationJobRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DataLabeling::V1beta1::PauseEvaluationJobRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload pause_evaluation_job(name: nil)
            #   Pass arguments to `pause_evaluation_job` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the evaluation job that is going to be paused. Format:
            #
            #     "projects/<var>\\{project_id}</var>/evaluationJobs/<var>\\{evaluation_job_id}</var>"
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_labeling/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DataLabeling::V1beta1::PauseEvaluationJobRequest.new
            #
            #   # Call the pause_evaluation_job method.
            #   result = client.pause_evaluation_job request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def pause_evaluation_job request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataLabeling::V1beta1::PauseEvaluationJobRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.pause_evaluation_job.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataLabeling::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.pause_evaluation_job.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.pause_evaluation_job.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_labeling_service_stub.call_rpc :pause_evaluation_job, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Resumes a paused evaluation job. A deleted evaluation job can't be resumed.
            # Resuming a running or scheduled evaluation job is a no-op.
            #
            # @overload resume_evaluation_job(request, options = nil)
            #   Pass arguments to `resume_evaluation_job` via a request object, either of type
            #   {::Google::Cloud::DataLabeling::V1beta1::ResumeEvaluationJobRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DataLabeling::V1beta1::ResumeEvaluationJobRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload resume_evaluation_job(name: nil)
            #   Pass arguments to `resume_evaluation_job` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the evaluation job that is going to be resumed. Format:
            #
            #     "projects/<var>\\{project_id}</var>/evaluationJobs/<var>\\{evaluation_job_id}</var>"
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_labeling/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DataLabeling::V1beta1::ResumeEvaluationJobRequest.new
            #
            #   # Call the resume_evaluation_job method.
            #   result = client.resume_evaluation_job request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def resume_evaluation_job request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataLabeling::V1beta1::ResumeEvaluationJobRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.resume_evaluation_job.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataLabeling::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.resume_evaluation_job.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.resume_evaluation_job.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_labeling_service_stub.call_rpc :resume_evaluation_job, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Stops and deletes an evaluation job.
            #
            # @overload delete_evaluation_job(request, options = nil)
            #   Pass arguments to `delete_evaluation_job` via a request object, either of type
            #   {::Google::Cloud::DataLabeling::V1beta1::DeleteEvaluationJobRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DataLabeling::V1beta1::DeleteEvaluationJobRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_evaluation_job(name: nil)
            #   Pass arguments to `delete_evaluation_job` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the evaluation job that is going to be deleted. Format:
            #
            #     "projects/<var>\\{project_id}</var>/evaluationJobs/<var>\\{evaluation_job_id}</var>"
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_labeling/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DataLabeling::V1beta1::DeleteEvaluationJobRequest.new
            #
            #   # Call the delete_evaluation_job method.
            #   result = client.delete_evaluation_job request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_evaluation_job request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataLabeling::V1beta1::DeleteEvaluationJobRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_evaluation_job.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataLabeling::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_evaluation_job.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_evaluation_job.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_labeling_service_stub.call_rpc :delete_evaluation_job, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists all evaluation jobs within a project with possible filters.
            # Pagination is supported.
            #
            # @overload list_evaluation_jobs(request, options = nil)
            #   Pass arguments to `list_evaluation_jobs` via a request object, either of type
            #   {::Google::Cloud::DataLabeling::V1beta1::ListEvaluationJobsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DataLabeling::V1beta1::ListEvaluationJobsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_evaluation_jobs(parent: nil, filter: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_evaluation_jobs` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Evaluation job resource parent. Format:
            #     "projects/<var>\\{project_id}</var>"
            #   @param filter [::String]
            #     Optional. You can filter the jobs to list by model_id (also known as
            #     model_name, as described in
            #     {::Google::Cloud::DataLabeling::V1beta1::EvaluationJob#model_version EvaluationJob.modelVersion}) or by
            #     evaluation job state (as described in {::Google::Cloud::DataLabeling::V1beta1::EvaluationJob#state EvaluationJob.state}). To filter
            #     by both criteria, use the `AND` operator or the `OR` operator. For example,
            #     you can use the following string for your filter:
            #     "evaluation<span>_</span>job.model_id = <var>\\{model_name}</var> AND
            #     evaluation<span>_</span>job.state = <var>\\{evaluation_job_state}</var>"
            #   @param page_size [::Integer]
            #     Optional. Requested page size. Server may return fewer results than
            #     requested. Default value is 100.
            #   @param page_token [::String]
            #     Optional. A token identifying a page of results for the server to return.
            #     Typically obtained by the
            #     {::Google::Cloud::DataLabeling::V1beta1::ListEvaluationJobsResponse#next_page_token nextPageToken} in the response
            #     to the previous request. The request returns the first page if this is
            #     empty.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::DataLabeling::V1beta1::EvaluationJob>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::DataLabeling::V1beta1::EvaluationJob>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_labeling/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DataLabeling::V1beta1::ListEvaluationJobsRequest.new
            #
            #   # Call the list_evaluation_jobs method.
            #   result = client.list_evaluation_jobs request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::DataLabeling::V1beta1::EvaluationJob.
            #     p item
            #   end
            #
            def list_evaluation_jobs request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataLabeling::V1beta1::ListEvaluationJobsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_evaluation_jobs.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataLabeling::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_evaluation_jobs.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_evaluation_jobs.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_labeling_service_stub.call_rpc :list_evaluation_jobs, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @data_labeling_service_stub, :list_evaluation_jobs, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the DataLabelingService API.
            #
            # This class represents the configuration for DataLabelingService,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # create_dataset to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_dataset.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_dataset.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::DataLabeling::V1beta1::DataLabelingService::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "datalabeling.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the DataLabelingService API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `create_dataset`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_dataset
                ##
                # RPC-specific configuration for `get_dataset`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_dataset
                ##
                # RPC-specific configuration for `list_datasets`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_datasets
                ##
                # RPC-specific configuration for `delete_dataset`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_dataset
                ##
                # RPC-specific configuration for `import_data`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :import_data
                ##
                # RPC-specific configuration for `export_data`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :export_data
                ##
                # RPC-specific configuration for `get_data_item`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_data_item
                ##
                # RPC-specific configuration for `list_data_items`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_data_items
                ##
                # RPC-specific configuration for `get_annotated_dataset`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_annotated_dataset
                ##
                # RPC-specific configuration for `list_annotated_datasets`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_annotated_datasets
                ##
                # RPC-specific configuration for `delete_annotated_dataset`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_annotated_dataset
                ##
                # RPC-specific configuration for `label_image`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :label_image
                ##
                # RPC-specific configuration for `label_video`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :label_video
                ##
                # RPC-specific configuration for `label_text`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :label_text
                ##
                # RPC-specific configuration for `get_example`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_example
                ##
                # RPC-specific configuration for `list_examples`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_examples
                ##
                # RPC-specific configuration for `create_annotation_spec_set`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_annotation_spec_set
                ##
                # RPC-specific configuration for `get_annotation_spec_set`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_annotation_spec_set
                ##
                # RPC-specific configuration for `list_annotation_spec_sets`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_annotation_spec_sets
                ##
                # RPC-specific configuration for `delete_annotation_spec_set`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_annotation_spec_set
                ##
                # RPC-specific configuration for `create_instruction`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_instruction
                ##
                # RPC-specific configuration for `get_instruction`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_instruction
                ##
                # RPC-specific configuration for `list_instructions`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_instructions
                ##
                # RPC-specific configuration for `delete_instruction`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_instruction
                ##
                # RPC-specific configuration for `get_evaluation`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_evaluation
                ##
                # RPC-specific configuration for `search_evaluations`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :search_evaluations
                ##
                # RPC-specific configuration for `search_example_comparisons`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :search_example_comparisons
                ##
                # RPC-specific configuration for `create_evaluation_job`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_evaluation_job
                ##
                # RPC-specific configuration for `update_evaluation_job`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_evaluation_job
                ##
                # RPC-specific configuration for `get_evaluation_job`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_evaluation_job
                ##
                # RPC-specific configuration for `pause_evaluation_job`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :pause_evaluation_job
                ##
                # RPC-specific configuration for `resume_evaluation_job`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :resume_evaluation_job
                ##
                # RPC-specific configuration for `delete_evaluation_job`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_evaluation_job
                ##
                # RPC-specific configuration for `list_evaluation_jobs`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_evaluation_jobs

                # @private
                def initialize parent_rpcs = nil
                  create_dataset_config = parent_rpcs.create_dataset if parent_rpcs.respond_to? :create_dataset
                  @create_dataset = ::Gapic::Config::Method.new create_dataset_config
                  get_dataset_config = parent_rpcs.get_dataset if parent_rpcs.respond_to? :get_dataset
                  @get_dataset = ::Gapic::Config::Method.new get_dataset_config
                  list_datasets_config = parent_rpcs.list_datasets if parent_rpcs.respond_to? :list_datasets
                  @list_datasets = ::Gapic::Config::Method.new list_datasets_config
                  delete_dataset_config = parent_rpcs.delete_dataset if parent_rpcs.respond_to? :delete_dataset
                  @delete_dataset = ::Gapic::Config::Method.new delete_dataset_config
                  import_data_config = parent_rpcs.import_data if parent_rpcs.respond_to? :import_data
                  @import_data = ::Gapic::Config::Method.new import_data_config
                  export_data_config = parent_rpcs.export_data if parent_rpcs.respond_to? :export_data
                  @export_data = ::Gapic::Config::Method.new export_data_config
                  get_data_item_config = parent_rpcs.get_data_item if parent_rpcs.respond_to? :get_data_item
                  @get_data_item = ::Gapic::Config::Method.new get_data_item_config
                  list_data_items_config = parent_rpcs.list_data_items if parent_rpcs.respond_to? :list_data_items
                  @list_data_items = ::Gapic::Config::Method.new list_data_items_config
                  get_annotated_dataset_config = parent_rpcs.get_annotated_dataset if parent_rpcs.respond_to? :get_annotated_dataset
                  @get_annotated_dataset = ::Gapic::Config::Method.new get_annotated_dataset_config
                  list_annotated_datasets_config = parent_rpcs.list_annotated_datasets if parent_rpcs.respond_to? :list_annotated_datasets
                  @list_annotated_datasets = ::Gapic::Config::Method.new list_annotated_datasets_config
                  delete_annotated_dataset_config = parent_rpcs.delete_annotated_dataset if parent_rpcs.respond_to? :delete_annotated_dataset
                  @delete_annotated_dataset = ::Gapic::Config::Method.new delete_annotated_dataset_config
                  label_image_config = parent_rpcs.label_image if parent_rpcs.respond_to? :label_image
                  @label_image = ::Gapic::Config::Method.new label_image_config
                  label_video_config = parent_rpcs.label_video if parent_rpcs.respond_to? :label_video
                  @label_video = ::Gapic::Config::Method.new label_video_config
                  label_text_config = parent_rpcs.label_text if parent_rpcs.respond_to? :label_text
                  @label_text = ::Gapic::Config::Method.new label_text_config
                  get_example_config = parent_rpcs.get_example if parent_rpcs.respond_to? :get_example
                  @get_example = ::Gapic::Config::Method.new get_example_config
                  list_examples_config = parent_rpcs.list_examples if parent_rpcs.respond_to? :list_examples
                  @list_examples = ::Gapic::Config::Method.new list_examples_config
                  create_annotation_spec_set_config = parent_rpcs.create_annotation_spec_set if parent_rpcs.respond_to? :create_annotation_spec_set
                  @create_annotation_spec_set = ::Gapic::Config::Method.new create_annotation_spec_set_config
                  get_annotation_spec_set_config = parent_rpcs.get_annotation_spec_set if parent_rpcs.respond_to? :get_annotation_spec_set
                  @get_annotation_spec_set = ::Gapic::Config::Method.new get_annotation_spec_set_config
                  list_annotation_spec_sets_config = parent_rpcs.list_annotation_spec_sets if parent_rpcs.respond_to? :list_annotation_spec_sets
                  @list_annotation_spec_sets = ::Gapic::Config::Method.new list_annotation_spec_sets_config
                  delete_annotation_spec_set_config = parent_rpcs.delete_annotation_spec_set if parent_rpcs.respond_to? :delete_annotation_spec_set
                  @delete_annotation_spec_set = ::Gapic::Config::Method.new delete_annotation_spec_set_config
                  create_instruction_config = parent_rpcs.create_instruction if parent_rpcs.respond_to? :create_instruction
                  @create_instruction = ::Gapic::Config::Method.new create_instruction_config
                  get_instruction_config = parent_rpcs.get_instruction if parent_rpcs.respond_to? :get_instruction
                  @get_instruction = ::Gapic::Config::Method.new get_instruction_config
                  list_instructions_config = parent_rpcs.list_instructions if parent_rpcs.respond_to? :list_instructions
                  @list_instructions = ::Gapic::Config::Method.new list_instructions_config
                  delete_instruction_config = parent_rpcs.delete_instruction if parent_rpcs.respond_to? :delete_instruction
                  @delete_instruction = ::Gapic::Config::Method.new delete_instruction_config
                  get_evaluation_config = parent_rpcs.get_evaluation if parent_rpcs.respond_to? :get_evaluation
                  @get_evaluation = ::Gapic::Config::Method.new get_evaluation_config
                  search_evaluations_config = parent_rpcs.search_evaluations if parent_rpcs.respond_to? :search_evaluations
                  @search_evaluations = ::Gapic::Config::Method.new search_evaluations_config
                  search_example_comparisons_config = parent_rpcs.search_example_comparisons if parent_rpcs.respond_to? :search_example_comparisons
                  @search_example_comparisons = ::Gapic::Config::Method.new search_example_comparisons_config
                  create_evaluation_job_config = parent_rpcs.create_evaluation_job if parent_rpcs.respond_to? :create_evaluation_job
                  @create_evaluation_job = ::Gapic::Config::Method.new create_evaluation_job_config
                  update_evaluation_job_config = parent_rpcs.update_evaluation_job if parent_rpcs.respond_to? :update_evaluation_job
                  @update_evaluation_job = ::Gapic::Config::Method.new update_evaluation_job_config
                  get_evaluation_job_config = parent_rpcs.get_evaluation_job if parent_rpcs.respond_to? :get_evaluation_job
                  @get_evaluation_job = ::Gapic::Config::Method.new get_evaluation_job_config
                  pause_evaluation_job_config = parent_rpcs.pause_evaluation_job if parent_rpcs.respond_to? :pause_evaluation_job
                  @pause_evaluation_job = ::Gapic::Config::Method.new pause_evaluation_job_config
                  resume_evaluation_job_config = parent_rpcs.resume_evaluation_job if parent_rpcs.respond_to? :resume_evaluation_job
                  @resume_evaluation_job = ::Gapic::Config::Method.new resume_evaluation_job_config
                  delete_evaluation_job_config = parent_rpcs.delete_evaluation_job if parent_rpcs.respond_to? :delete_evaluation_job
                  @delete_evaluation_job = ::Gapic::Config::Method.new delete_evaluation_job_config
                  list_evaluation_jobs_config = parent_rpcs.list_evaluation_jobs if parent_rpcs.respond_to? :list_evaluation_jobs
                  @list_evaluation_jobs = ::Gapic::Config::Method.new list_evaluation_jobs_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
