# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/datacatalog/v1beta1/datacatalog_pb"
require "google/cloud/data_catalog/v1beta1/data_catalog/rest"


class ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_search_catalog
    # Create test objects.
    client_result = ::Google::Cloud::DataCatalog::V1beta1::SearchCatalogResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    scope = {}
    query = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"

    search_catalog_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Rest::ServiceStub.stub :transcode_search_catalog_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, search_catalog_client_stub do
        # Create client
        client = ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.search_catalog({ scope: scope, query: query, page_size: page_size, page_token: page_token, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.search_catalog scope: scope, query: query, page_size: page_size, page_token: page_token, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.search_catalog ::Google::Cloud::DataCatalog::V1beta1::SearchCatalogRequest.new(scope: scope, query: query, page_size: page_size, page_token: page_token, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.search_catalog({ scope: scope, query: query, page_size: page_size, page_token: page_token, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.search_catalog(::Google::Cloud::DataCatalog::V1beta1::SearchCatalogRequest.new(scope: scope, query: query, page_size: page_size, page_token: page_token, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, search_catalog_client_stub.call_count
      end
    end
  end

  def test_create_entry_group
    # Create test objects.
    client_result = ::Google::Cloud::DataCatalog::V1beta1::EntryGroup.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    entry_group_id = "hello world"
    entry_group = {}

    create_entry_group_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Rest::ServiceStub.stub :transcode_create_entry_group_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_entry_group_client_stub do
        # Create client
        client = ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_entry_group({ parent: parent, entry_group_id: entry_group_id, entry_group: entry_group }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_entry_group parent: parent, entry_group_id: entry_group_id, entry_group: entry_group do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_entry_group ::Google::Cloud::DataCatalog::V1beta1::CreateEntryGroupRequest.new(parent: parent, entry_group_id: entry_group_id, entry_group: entry_group) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_entry_group({ parent: parent, entry_group_id: entry_group_id, entry_group: entry_group }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_entry_group(::Google::Cloud::DataCatalog::V1beta1::CreateEntryGroupRequest.new(parent: parent, entry_group_id: entry_group_id, entry_group: entry_group), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_entry_group_client_stub.call_count
      end
    end
  end

  def test_update_entry_group
    # Create test objects.
    client_result = ::Google::Cloud::DataCatalog::V1beta1::EntryGroup.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    entry_group = {}
    update_mask = {}

    update_entry_group_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Rest::ServiceStub.stub :transcode_update_entry_group_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_entry_group_client_stub do
        # Create client
        client = ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_entry_group({ entry_group: entry_group, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_entry_group entry_group: entry_group, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_entry_group ::Google::Cloud::DataCatalog::V1beta1::UpdateEntryGroupRequest.new(entry_group: entry_group, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_entry_group({ entry_group: entry_group, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_entry_group(::Google::Cloud::DataCatalog::V1beta1::UpdateEntryGroupRequest.new(entry_group: entry_group, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_entry_group_client_stub.call_count
      end
    end
  end

  def test_get_entry_group
    # Create test objects.
    client_result = ::Google::Cloud::DataCatalog::V1beta1::EntryGroup.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    read_mask = {}

    get_entry_group_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Rest::ServiceStub.stub :transcode_get_entry_group_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_entry_group_client_stub do
        # Create client
        client = ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_entry_group({ name: name, read_mask: read_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_entry_group name: name, read_mask: read_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_entry_group ::Google::Cloud::DataCatalog::V1beta1::GetEntryGroupRequest.new(name: name, read_mask: read_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_entry_group({ name: name, read_mask: read_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_entry_group(::Google::Cloud::DataCatalog::V1beta1::GetEntryGroupRequest.new(name: name, read_mask: read_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_entry_group_client_stub.call_count
      end
    end
  end

  def test_delete_entry_group
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    force = true

    delete_entry_group_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Rest::ServiceStub.stub :transcode_delete_entry_group_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_entry_group_client_stub do
        # Create client
        client = ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_entry_group({ name: name, force: force }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_entry_group name: name, force: force do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_entry_group ::Google::Cloud::DataCatalog::V1beta1::DeleteEntryGroupRequest.new(name: name, force: force) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_entry_group({ name: name, force: force }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_entry_group(::Google::Cloud::DataCatalog::V1beta1::DeleteEntryGroupRequest.new(name: name, force: force), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_entry_group_client_stub.call_count
      end
    end
  end

  def test_list_entry_groups
    # Create test objects.
    client_result = ::Google::Cloud::DataCatalog::V1beta1::ListEntryGroupsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_entry_groups_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Rest::ServiceStub.stub :transcode_list_entry_groups_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_entry_groups_client_stub do
        # Create client
        client = ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_entry_groups({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_entry_groups parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_entry_groups ::Google::Cloud::DataCatalog::V1beta1::ListEntryGroupsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_entry_groups({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_entry_groups(::Google::Cloud::DataCatalog::V1beta1::ListEntryGroupsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_entry_groups_client_stub.call_count
      end
    end
  end

  def test_create_entry
    # Create test objects.
    client_result = ::Google::Cloud::DataCatalog::V1beta1::Entry.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    entry_id = "hello world"
    entry = {}

    create_entry_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Rest::ServiceStub.stub :transcode_create_entry_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_entry_client_stub do
        # Create client
        client = ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_entry({ parent: parent, entry_id: entry_id, entry: entry }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_entry parent: parent, entry_id: entry_id, entry: entry do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_entry ::Google::Cloud::DataCatalog::V1beta1::CreateEntryRequest.new(parent: parent, entry_id: entry_id, entry: entry) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_entry({ parent: parent, entry_id: entry_id, entry: entry }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_entry(::Google::Cloud::DataCatalog::V1beta1::CreateEntryRequest.new(parent: parent, entry_id: entry_id, entry: entry), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_entry_client_stub.call_count
      end
    end
  end

  def test_update_entry
    # Create test objects.
    client_result = ::Google::Cloud::DataCatalog::V1beta1::Entry.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    entry = {}
    update_mask = {}

    update_entry_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Rest::ServiceStub.stub :transcode_update_entry_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_entry_client_stub do
        # Create client
        client = ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_entry({ entry: entry, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_entry entry: entry, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_entry ::Google::Cloud::DataCatalog::V1beta1::UpdateEntryRequest.new(entry: entry, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_entry({ entry: entry, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_entry(::Google::Cloud::DataCatalog::V1beta1::UpdateEntryRequest.new(entry: entry, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_entry_client_stub.call_count
      end
    end
  end

  def test_delete_entry
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_entry_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Rest::ServiceStub.stub :transcode_delete_entry_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_entry_client_stub do
        # Create client
        client = ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_entry({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_entry name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_entry ::Google::Cloud::DataCatalog::V1beta1::DeleteEntryRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_entry({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_entry(::Google::Cloud::DataCatalog::V1beta1::DeleteEntryRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_entry_client_stub.call_count
      end
    end
  end

  def test_get_entry
    # Create test objects.
    client_result = ::Google::Cloud::DataCatalog::V1beta1::Entry.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_entry_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Rest::ServiceStub.stub :transcode_get_entry_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_entry_client_stub do
        # Create client
        client = ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_entry({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_entry name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_entry ::Google::Cloud::DataCatalog::V1beta1::GetEntryRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_entry({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_entry(::Google::Cloud::DataCatalog::V1beta1::GetEntryRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_entry_client_stub.call_count
      end
    end
  end

  def test_lookup_entry
    # Create test objects.
    client_result = ::Google::Cloud::DataCatalog::V1beta1::Entry.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    linked_resource = "hello world"

    lookup_entry_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Rest::ServiceStub.stub :transcode_lookup_entry_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, lookup_entry_client_stub do
        # Create client
        client = ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.lookup_entry({ linked_resource: linked_resource }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.lookup_entry linked_resource: linked_resource do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.lookup_entry ::Google::Cloud::DataCatalog::V1beta1::LookupEntryRequest.new(linked_resource: linked_resource) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.lookup_entry({ linked_resource: linked_resource }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.lookup_entry(::Google::Cloud::DataCatalog::V1beta1::LookupEntryRequest.new(linked_resource: linked_resource), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, lookup_entry_client_stub.call_count
      end
    end
  end

  def test_list_entries
    # Create test objects.
    client_result = ::Google::Cloud::DataCatalog::V1beta1::ListEntriesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    read_mask = {}

    list_entries_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Rest::ServiceStub.stub :transcode_list_entries_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_entries_client_stub do
        # Create client
        client = ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_entries({ parent: parent, page_size: page_size, page_token: page_token, read_mask: read_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_entries parent: parent, page_size: page_size, page_token: page_token, read_mask: read_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_entries ::Google::Cloud::DataCatalog::V1beta1::ListEntriesRequest.new(parent: parent, page_size: page_size, page_token: page_token, read_mask: read_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_entries({ parent: parent, page_size: page_size, page_token: page_token, read_mask: read_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_entries(::Google::Cloud::DataCatalog::V1beta1::ListEntriesRequest.new(parent: parent, page_size: page_size, page_token: page_token, read_mask: read_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_entries_client_stub.call_count
      end
    end
  end

  def test_create_tag_template
    # Create test objects.
    client_result = ::Google::Cloud::DataCatalog::V1beta1::TagTemplate.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    tag_template_id = "hello world"
    tag_template = {}

    create_tag_template_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Rest::ServiceStub.stub :transcode_create_tag_template_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_tag_template_client_stub do
        # Create client
        client = ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_tag_template({ parent: parent, tag_template_id: tag_template_id, tag_template: tag_template }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_tag_template parent: parent, tag_template_id: tag_template_id, tag_template: tag_template do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_tag_template ::Google::Cloud::DataCatalog::V1beta1::CreateTagTemplateRequest.new(parent: parent, tag_template_id: tag_template_id, tag_template: tag_template) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_tag_template({ parent: parent, tag_template_id: tag_template_id, tag_template: tag_template }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_tag_template(::Google::Cloud::DataCatalog::V1beta1::CreateTagTemplateRequest.new(parent: parent, tag_template_id: tag_template_id, tag_template: tag_template), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_tag_template_client_stub.call_count
      end
    end
  end

  def test_get_tag_template
    # Create test objects.
    client_result = ::Google::Cloud::DataCatalog::V1beta1::TagTemplate.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_tag_template_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Rest::ServiceStub.stub :transcode_get_tag_template_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_tag_template_client_stub do
        # Create client
        client = ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_tag_template({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_tag_template name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_tag_template ::Google::Cloud::DataCatalog::V1beta1::GetTagTemplateRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_tag_template({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_tag_template(::Google::Cloud::DataCatalog::V1beta1::GetTagTemplateRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_tag_template_client_stub.call_count
      end
    end
  end

  def test_update_tag_template
    # Create test objects.
    client_result = ::Google::Cloud::DataCatalog::V1beta1::TagTemplate.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    tag_template = {}
    update_mask = {}

    update_tag_template_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Rest::ServiceStub.stub :transcode_update_tag_template_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_tag_template_client_stub do
        # Create client
        client = ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_tag_template({ tag_template: tag_template, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_tag_template tag_template: tag_template, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_tag_template ::Google::Cloud::DataCatalog::V1beta1::UpdateTagTemplateRequest.new(tag_template: tag_template, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_tag_template({ tag_template: tag_template, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_tag_template(::Google::Cloud::DataCatalog::V1beta1::UpdateTagTemplateRequest.new(tag_template: tag_template, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_tag_template_client_stub.call_count
      end
    end
  end

  def test_delete_tag_template
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    force = true

    delete_tag_template_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Rest::ServiceStub.stub :transcode_delete_tag_template_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_tag_template_client_stub do
        # Create client
        client = ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_tag_template({ name: name, force: force }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_tag_template name: name, force: force do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_tag_template ::Google::Cloud::DataCatalog::V1beta1::DeleteTagTemplateRequest.new(name: name, force: force) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_tag_template({ name: name, force: force }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_tag_template(::Google::Cloud::DataCatalog::V1beta1::DeleteTagTemplateRequest.new(name: name, force: force), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_tag_template_client_stub.call_count
      end
    end
  end

  def test_create_tag_template_field
    # Create test objects.
    client_result = ::Google::Cloud::DataCatalog::V1beta1::TagTemplateField.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    tag_template_field_id = "hello world"
    tag_template_field = {}

    create_tag_template_field_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Rest::ServiceStub.stub :transcode_create_tag_template_field_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_tag_template_field_client_stub do
        # Create client
        client = ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_tag_template_field({ parent: parent, tag_template_field_id: tag_template_field_id, tag_template_field: tag_template_field }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_tag_template_field parent: parent, tag_template_field_id: tag_template_field_id, tag_template_field: tag_template_field do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_tag_template_field ::Google::Cloud::DataCatalog::V1beta1::CreateTagTemplateFieldRequest.new(parent: parent, tag_template_field_id: tag_template_field_id, tag_template_field: tag_template_field) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_tag_template_field({ parent: parent, tag_template_field_id: tag_template_field_id, tag_template_field: tag_template_field }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_tag_template_field(::Google::Cloud::DataCatalog::V1beta1::CreateTagTemplateFieldRequest.new(parent: parent, tag_template_field_id: tag_template_field_id, tag_template_field: tag_template_field), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_tag_template_field_client_stub.call_count
      end
    end
  end

  def test_update_tag_template_field
    # Create test objects.
    client_result = ::Google::Cloud::DataCatalog::V1beta1::TagTemplateField.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    tag_template_field = {}
    update_mask = {}

    update_tag_template_field_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Rest::ServiceStub.stub :transcode_update_tag_template_field_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_tag_template_field_client_stub do
        # Create client
        client = ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_tag_template_field({ name: name, tag_template_field: tag_template_field, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_tag_template_field name: name, tag_template_field: tag_template_field, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_tag_template_field ::Google::Cloud::DataCatalog::V1beta1::UpdateTagTemplateFieldRequest.new(name: name, tag_template_field: tag_template_field, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_tag_template_field({ name: name, tag_template_field: tag_template_field, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_tag_template_field(::Google::Cloud::DataCatalog::V1beta1::UpdateTagTemplateFieldRequest.new(name: name, tag_template_field: tag_template_field, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_tag_template_field_client_stub.call_count
      end
    end
  end

  def test_rename_tag_template_field
    # Create test objects.
    client_result = ::Google::Cloud::DataCatalog::V1beta1::TagTemplateField.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    new_tag_template_field_id = "hello world"

    rename_tag_template_field_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Rest::ServiceStub.stub :transcode_rename_tag_template_field_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, rename_tag_template_field_client_stub do
        # Create client
        client = ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.rename_tag_template_field({ name: name, new_tag_template_field_id: new_tag_template_field_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.rename_tag_template_field name: name, new_tag_template_field_id: new_tag_template_field_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.rename_tag_template_field ::Google::Cloud::DataCatalog::V1beta1::RenameTagTemplateFieldRequest.new(name: name, new_tag_template_field_id: new_tag_template_field_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.rename_tag_template_field({ name: name, new_tag_template_field_id: new_tag_template_field_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.rename_tag_template_field(::Google::Cloud::DataCatalog::V1beta1::RenameTagTemplateFieldRequest.new(name: name, new_tag_template_field_id: new_tag_template_field_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, rename_tag_template_field_client_stub.call_count
      end
    end
  end

  def test_rename_tag_template_field_enum_value
    # Create test objects.
    client_result = ::Google::Cloud::DataCatalog::V1beta1::TagTemplateField.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    new_enum_value_display_name = "hello world"

    rename_tag_template_field_enum_value_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Rest::ServiceStub.stub :transcode_rename_tag_template_field_enum_value_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, rename_tag_template_field_enum_value_client_stub do
        # Create client
        client = ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.rename_tag_template_field_enum_value({ name: name, new_enum_value_display_name: new_enum_value_display_name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.rename_tag_template_field_enum_value name: name, new_enum_value_display_name: new_enum_value_display_name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.rename_tag_template_field_enum_value ::Google::Cloud::DataCatalog::V1beta1::RenameTagTemplateFieldEnumValueRequest.new(name: name, new_enum_value_display_name: new_enum_value_display_name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.rename_tag_template_field_enum_value({ name: name, new_enum_value_display_name: new_enum_value_display_name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.rename_tag_template_field_enum_value(::Google::Cloud::DataCatalog::V1beta1::RenameTagTemplateFieldEnumValueRequest.new(name: name, new_enum_value_display_name: new_enum_value_display_name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, rename_tag_template_field_enum_value_client_stub.call_count
      end
    end
  end

  def test_delete_tag_template_field
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    force = true

    delete_tag_template_field_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Rest::ServiceStub.stub :transcode_delete_tag_template_field_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_tag_template_field_client_stub do
        # Create client
        client = ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_tag_template_field({ name: name, force: force }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_tag_template_field name: name, force: force do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_tag_template_field ::Google::Cloud::DataCatalog::V1beta1::DeleteTagTemplateFieldRequest.new(name: name, force: force) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_tag_template_field({ name: name, force: force }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_tag_template_field(::Google::Cloud::DataCatalog::V1beta1::DeleteTagTemplateFieldRequest.new(name: name, force: force), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_tag_template_field_client_stub.call_count
      end
    end
  end

  def test_create_tag
    # Create test objects.
    client_result = ::Google::Cloud::DataCatalog::V1beta1::Tag.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    tag = {}

    create_tag_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Rest::ServiceStub.stub :transcode_create_tag_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_tag_client_stub do
        # Create client
        client = ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_tag({ parent: parent, tag: tag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_tag parent: parent, tag: tag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_tag ::Google::Cloud::DataCatalog::V1beta1::CreateTagRequest.new(parent: parent, tag: tag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_tag({ parent: parent, tag: tag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_tag(::Google::Cloud::DataCatalog::V1beta1::CreateTagRequest.new(parent: parent, tag: tag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_tag_client_stub.call_count
      end
    end
  end

  def test_update_tag
    # Create test objects.
    client_result = ::Google::Cloud::DataCatalog::V1beta1::Tag.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    tag = {}
    update_mask = {}

    update_tag_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Rest::ServiceStub.stub :transcode_update_tag_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_tag_client_stub do
        # Create client
        client = ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_tag({ tag: tag, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_tag tag: tag, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_tag ::Google::Cloud::DataCatalog::V1beta1::UpdateTagRequest.new(tag: tag, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_tag({ tag: tag, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_tag(::Google::Cloud::DataCatalog::V1beta1::UpdateTagRequest.new(tag: tag, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_tag_client_stub.call_count
      end
    end
  end

  def test_delete_tag
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_tag_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Rest::ServiceStub.stub :transcode_delete_tag_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_tag_client_stub do
        # Create client
        client = ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_tag({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_tag name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_tag ::Google::Cloud::DataCatalog::V1beta1::DeleteTagRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_tag({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_tag(::Google::Cloud::DataCatalog::V1beta1::DeleteTagRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_tag_client_stub.call_count
      end
    end
  end

  def test_list_tags
    # Create test objects.
    client_result = ::Google::Cloud::DataCatalog::V1beta1::ListTagsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_tags_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Rest::ServiceStub.stub :transcode_list_tags_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_tags_client_stub do
        # Create client
        client = ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_tags({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_tags parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_tags ::Google::Cloud::DataCatalog::V1beta1::ListTagsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_tags({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_tags(::Google::Cloud::DataCatalog::V1beta1::ListTagsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_tags_client_stub.call_count
      end
    end
  end

  def test_set_iam_policy
    # Create test objects.
    client_result = ::Google::Iam::V1::Policy.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    resource = "hello world"
    policy = {}
    update_mask = {}

    set_iam_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Rest::ServiceStub.stub :transcode_set_iam_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, set_iam_policy_client_stub do
        # Create client
        client = ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.set_iam_policy({ resource: resource, policy: policy, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.set_iam_policy resource: resource, policy: policy, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.set_iam_policy ::Google::Iam::V1::SetIamPolicyRequest.new(resource: resource, policy: policy, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.set_iam_policy({ resource: resource, policy: policy, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.set_iam_policy(::Google::Iam::V1::SetIamPolicyRequest.new(resource: resource, policy: policy, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, set_iam_policy_client_stub.call_count
      end
    end
  end

  def test_get_iam_policy
    # Create test objects.
    client_result = ::Google::Iam::V1::Policy.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    resource = "hello world"
    options = {}

    get_iam_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Rest::ServiceStub.stub :transcode_get_iam_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_iam_policy_client_stub do
        # Create client
        client = ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_iam_policy({ resource: resource, options: options }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_iam_policy resource: resource, options: options do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_iam_policy ::Google::Iam::V1::GetIamPolicyRequest.new(resource: resource, options: options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_iam_policy({ resource: resource, options: options }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_iam_policy(::Google::Iam::V1::GetIamPolicyRequest.new(resource: resource, options: options), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_iam_policy_client_stub.call_count
      end
    end
  end

  def test_test_iam_permissions
    # Create test objects.
    client_result = ::Google::Iam::V1::TestIamPermissionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    resource = "hello world"
    permissions = ["hello world"]

    test_iam_permissions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Rest::ServiceStub.stub :transcode_test_iam_permissions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, test_iam_permissions_client_stub do
        # Create client
        client = ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.test_iam_permissions({ resource: resource, permissions: permissions }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.test_iam_permissions resource: resource, permissions: permissions do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.test_iam_permissions ::Google::Iam::V1::TestIamPermissionsRequest.new(resource: resource, permissions: permissions) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.test_iam_permissions({ resource: resource, permissions: permissions }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.test_iam_permissions(::Google::Iam::V1::TestIamPermissionsRequest.new(resource: resource, permissions: permissions), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, test_iam_permissions_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Rest::Client::Configuration, config
  end
end
