# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DataCatalog
      module V1beta1
        # Represents a schema (e.g. BigQuery, GoogleSQL, Avro schema).
        # @!attribute [rw] columns
        #   @return [::Array<::Google::Cloud::DataCatalog::V1beta1::ColumnSchema>]
        #     Required. Schema of columns. A maximum of 10,000 columns and sub-columns
        #     can be specified.
        class Schema
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Representation of a column within a schema. Columns could be nested inside
        # other columns.
        # @!attribute [rw] column
        #   @return [::String]
        #     Required. Name of the column.
        # @!attribute [rw] type
        #   @return [::String]
        #     Required. Type of the column.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. Description of the column. Default value is an empty string.
        # @!attribute [rw] mode
        #   @return [::String]
        #     Optional. A column's mode indicates whether the values in this column are
        #     required, nullable, etc. Only `NULLABLE`, `REQUIRED` and `REPEATED` are
        #     supported. Default mode is `NULLABLE`.
        # @!attribute [rw] subcolumns
        #   @return [::Array<::Google::Cloud::DataCatalog::V1beta1::ColumnSchema>]
        #     Optional. Schema of sub-columns. A column can have zero or more
        #     sub-columns.
        class ColumnSchema
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
