# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DataCatalog
      module V1beta1
        # Request message for
        # {::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client#search_catalog SearchCatalog}.
        # @!attribute [rw] scope
        #   @return [::Google::Cloud::DataCatalog::V1beta1::SearchCatalogRequest::Scope]
        #     Required. The scope of this search request. A `scope` that has empty
        #     `include_org_ids`, `include_project_ids` AND false
        #     `include_gcp_public_datasets` is considered invalid. Data Catalog will
        #     return an error in such a case.
        # @!attribute [rw] query
        #   @return [::String]
        #     Optional. The query string in search query syntax. An empty query string
        #     will result in all data assets (in the specified scope) that the user has
        #     access to. Query strings can be simple as "x" or more qualified as:
        #
        #     * name:x
        #     * column:x
        #     * description:y
        #
        #     Note: Query tokens need to have a minimum of 3 characters for substring
        #     matching to work correctly. See [Data Catalog Search
        #     Syntax](https://cloud.google.com/data-catalog/docs/how-to/search-reference)
        #     for more information.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Number of results in the search page. If <=0 then defaults to 10. Max limit
        #     for page_size is 1000. Throws an invalid argument for page_size > 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. Pagination token returned in an earlier
        #     {::Google::Cloud::DataCatalog::V1beta1::SearchCatalogResponse#next_page_token SearchCatalogResponse.next_page_token},
        #     which indicates that this is a continuation of a prior
        #     {::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client#search_catalog SearchCatalogRequest}
        #     call, and that the system should return the next page of data. If empty,
        #     the first page is returned.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Specifies the ordering of results, currently supported case-sensitive
        #     choices are:
        #
        #       * `relevance`, only supports descending
        #       * `last_modified_timestamp [asc|desc]`, defaults to descending if not
        #         specified
        #       * `default` that can only be descending
        #
        #     If not specified, defaults to `relevance` descending.
        class SearchCatalogRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The criteria that select the subspace used for query matching.
          # @!attribute [rw] include_org_ids
          #   @return [::Array<::String>]
          #     The list of organization IDs to search within. To find your organization
          #     ID, follow instructions in
          #     https://cloud.google.com/resource-manager/docs/creating-managing-organization.
          # @!attribute [rw] include_project_ids
          #   @return [::Array<::String>]
          #     The list of project IDs to search within. To learn more about the
          #     distinction between project names/IDs/numbers, go to
          #     https://cloud.google.com/docs/overview/#projects.
          # @!attribute [rw] include_gcp_public_datasets
          #   @return [::Boolean]
          #     If `true`, include Google Cloud public datasets in the
          #     search results. Info on Google Cloud public datasets is available at
          #     https://cloud.google.com/public-datasets/. By default, Google Cloud
          #     public datasets are excluded.
          # @!attribute [rw] restricted_locations
          #   @return [::Array<::String>]
          #     Optional. The list of locations to search within.
          #     1. If empty, search will be performed in all locations;
          #     2. If any of the locations are NOT in the valid locations list, error
          #     will be returned;
          #     3. Otherwise, search only the given locations for matching results.
          #     Typical usage is to leave this field empty. When a location is
          #     unreachable as returned in the `SearchCatalogResponse.unreachable` field,
          #     users can repeat the search request with this parameter set to get
          #     additional information on the error.
          #
          #     Valid locations:
          #      * asia-east1
          #      * asia-east2
          #      * asia-northeast1
          #      * asia-northeast2
          #      * asia-northeast3
          #      * asia-south1
          #      * asia-southeast1
          #      * australia-southeast1
          #      * eu
          #      * europe-north1
          #      * europe-west1
          #      * europe-west2
          #      * europe-west3
          #      * europe-west4
          #      * europe-west6
          #      * global
          #      * northamerica-northeast1
          #      * southamerica-east1
          #      * us
          #      * us-central1
          #      * us-east1
          #      * us-east4
          #      * us-west1
          #      * us-west2
          class Scope
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Response message for
        # {::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client#search_catalog SearchCatalog}.
        # @!attribute [rw] results
        #   @return [::Array<::Google::Cloud::DataCatalog::V1beta1::SearchCatalogResult>]
        #     Search results.
        # @!attribute [rw] total_size
        #   @return [::Integer]
        #     The approximate total number of entries matched by the query.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     The token that can be used to retrieve the next page of results.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Unreachable locations. Search result does not include data from those
        #     locations. Users can get additional information on the error by repeating
        #     the search request with a more restrictive parameter -- setting the value
        #     for `SearchDataCatalogRequest.scope.restricted_locations`.
        class SearchCatalogResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client#create_entry_group CreateEntryGroup}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the project this entry group is in. Example:
        #
        #     * projects/\\{project_id}/locations/\\{location}
        #
        #     Note that this EntryGroup and its child resources may not actually be
        #     stored in the location in this name.
        # @!attribute [rw] entry_group_id
        #   @return [::String]
        #     Required. The id of the entry group to create.
        #     The id must begin with a letter or underscore, contain only English
        #     letters, numbers and underscores, and be at most 64 characters.
        # @!attribute [rw] entry_group
        #   @return [::Google::Cloud::DataCatalog::V1beta1::EntryGroup]
        #     The entry group to create. Defaults to an empty entry group.
        class CreateEntryGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client#update_entry_group UpdateEntryGroup}.
        # @!attribute [rw] entry_group
        #   @return [::Google::Cloud::DataCatalog::V1beta1::EntryGroup]
        #     Required. The updated entry group. "name" field must be set.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Names of fields whose values to overwrite on an entry group.
        #
        #     If this parameter is absent or empty, all modifiable fields
        #     are overwritten. If such fields are non-required and omitted in the
        #     request body, their values are emptied.
        class UpdateEntryGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client#get_entry_group GetEntryGroup}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the entry group. For example,
        #     `projects/{project_id}/locations/{location}/entryGroups/{entry_group_id}`.
        # @!attribute [rw] read_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The fields to return. If not set or empty, all fields are returned.
        class GetEntryGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client#delete_entry_group DeleteEntryGroup}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the entry group. For example,
        #     `projects/{project_id}/locations/{location}/entryGroups/{entry_group_id}`.
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     Optional. If true, deletes all entries in the entry group.
        class DeleteEntryGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client#list_entry_groups ListEntryGroups}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the location that contains the entry groups, which
        #     can be provided in URL format. Example:
        #
        #     * projects/\\{project_id}/locations/\\{location}
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of items to return. Default is 10. Max limit
        #     is 1000. Throws an invalid argument for `page_size > 1000`.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. Token that specifies which page is requested. If empty, the first
        #     page is returned.
        class ListEntryGroupsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client#list_entry_groups ListEntryGroups}.
        # @!attribute [rw] entry_groups
        #   @return [::Array<::Google::Cloud::DataCatalog::V1beta1::EntryGroup>]
        #     EntryGroup details.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to retrieve the next page of results. It is set to empty if no items
        #     remain in results.
        class ListEntryGroupsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client#create_entry CreateEntry}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the entry group this entry is in. Example:
        #
        #     * projects/\\{project_id}/locations/\\{location}/entryGroups/\\{entry_group_id}
        #
        #     Note that this Entry and its child resources may not actually be stored in
        #     the location in this name.
        # @!attribute [rw] entry_id
        #   @return [::String]
        #     Required. The id of the entry to create.
        # @!attribute [rw] entry
        #   @return [::Google::Cloud::DataCatalog::V1beta1::Entry]
        #     Required. The entry to create.
        class CreateEntryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client#update_entry UpdateEntry}.
        # @!attribute [rw] entry
        #   @return [::Google::Cloud::DataCatalog::V1beta1::Entry]
        #     Required. The updated entry. The "name" field must be set.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Names of fields whose values to overwrite on an entry.
        #
        #     If this parameter is absent or empty, all modifiable fields
        #     are overwritten. If such fields are non-required and omitted in the
        #     request body, their values are emptied.
        #
        #     The following fields are modifiable:
        #
        #     * For entries with type `DATA_STREAM`:
        #        * `schema`
        #     * For entries with type `FILESET`:
        #        * `schema`
        #        * `display_name`
        #        * `description`
        #        * `gcs_fileset_spec`
        #        * `gcs_fileset_spec.file_patterns`
        #     * For entries with `user_specified_type`:
        #        * `schema`
        #        * `display_name`
        #        * `description`
        #        * `user_specified_type`
        #        * `user_specified_system`
        #        * `linked_resource`
        #        * `source_system_timestamps`
        class UpdateEntryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client#delete_entry DeleteEntry}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the entry. Example:
        #
        #     * projects/\\{project_id}/locations/\\{location}/entryGroups/\\{entry_group_id}/entries/\\{entry_id}
        class DeleteEntryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client#get_entry GetEntry}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the entry. Example:
        #
        #     * projects/\\{project_id}/locations/\\{location}/entryGroups/\\{entry_group_id}/entries/\\{entry_id}
        class GetEntryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client#lookup_entry LookupEntry}.
        # @!attribute [rw] linked_resource
        #   @return [::String]
        #     The full name of the Google Cloud Platform resource the Data Catalog
        #     entry represents. See:
        #     https://cloud.google.com/apis/design/resource_names#full_resource_name.
        #     Full names are case-sensitive.
        #
        #     Examples:
        #
        #      * //bigquery.googleapis.com/projects/projectId/datasets/datasetId/tables/tableId
        #      * //pubsub.googleapis.com/projects/projectId/topics/topicId
        #
        #     Note: The following fields are mutually exclusive: `linked_resource`, `sql_resource`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] sql_resource
        #   @return [::String]
        #     The SQL name of the entry. SQL names are case-sensitive.
        #
        #     Examples:
        #
        #       * `pubsub.project_id.topic_id`
        #       * ``pubsub.project_id.`topic.id.with.dots` ``
        #       * `bigquery.table.project_id.dataset_id.table_id`
        #       * `bigquery.dataset.project_id.dataset_id`
        #       * `datacatalog.entry.project_id.location_id.entry_group_id.entry_id`
        #
        #     `*_id`s should satisfy the GoogleSQL rules for identifiers.
        #     https://cloud.google.com/bigquery/docs/reference/standard-sql/lexical.
        #
        #     Note: The following fields are mutually exclusive: `sql_resource`, `linked_resource`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class LookupEntryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Entry Metadata.
        # A Data Catalog Entry resource represents another resource in Google
        # Cloud Platform (such as a BigQuery dataset or a Pub/Sub topic), or
        # outside of Google Cloud Platform. Clients can use the `linked_resource` field
        # in the Entry resource to refer to the original resource ID of the source
        # system.
        #
        # An Entry resource contains resource details, such as its schema. An Entry can
        # also be used to attach flexible metadata, such as a
        # {::Google::Cloud::DataCatalog::V1beta1::Tag Tag}.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Identifier. The Data Catalog resource name of the entry in URL
        #     format. Example:
        #
        #     * projects/\\{project_id}/locations/\\{location}/entryGroups/\\{entry_group_id}/entries/\\{entry_id}
        #
        #     Note that this Entry and its child resources may not actually be stored in
        #     the location in this name.
        # @!attribute [rw] linked_resource
        #   @return [::String]
        #     The resource this metadata entry refers to.
        #
        #     For Google Cloud Platform resources, `linked_resource` is the [full name of
        #     the
        #     resource](https://cloud.google.com/apis/design/resource_names#full_resource_name).
        #     For example, the `linked_resource` for a table resource from BigQuery is:
        #
        #     * //bigquery.googleapis.com/projects/projectId/datasets/datasetId/tables/tableId
        #
        #     Output only when Entry is of type in the EntryType enum. For entries with
        #     user_specified_type, this field is optional and defaults to an empty
        #     string.
        # @!attribute [rw] type
        #   @return [::Google::Cloud::DataCatalog::V1beta1::EntryType]
        #     The type of the entry.
        #     Only used for Entries with types in the EntryType enum.
        #
        #     Note: The following fields are mutually exclusive: `type`, `user_specified_type`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] user_specified_type
        #   @return [::String]
        #     Entry type if it does not fit any of the input-allowed values listed in
        #     `EntryType` enum above. When creating an entry, users should check the
        #     enum values first, if nothing matches the entry to be created, then
        #     provide a custom value, for example "my_special_type".
        #     `user_specified_type` strings must begin with a letter or underscore and
        #     can only contain letters, numbers, and underscores; are case insensitive;
        #     must be at least 1 character and at most 64 characters long.
        #
        #     Currently, only FILESET enum value is allowed. All other entries created
        #     through Data Catalog must use `user_specified_type`.
        #
        #     Note: The following fields are mutually exclusive: `user_specified_type`, `type`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] integrated_system
        #   @return [::Google::Cloud::DataCatalog::V1beta1::IntegratedSystem]
        #     Output only. This field indicates the entry's source system that Data
        #     Catalog integrates with, such as BigQuery or Pub/Sub.
        #
        #     Note: The following fields are mutually exclusive: `integrated_system`, `user_specified_system`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] user_specified_system
        #   @return [::String]
        #     This field indicates the entry's source system that Data Catalog does not
        #     integrate with. `user_specified_system` strings must begin with a letter
        #     or underscore and can only contain letters, numbers, and underscores; are
        #     case insensitive; must be at least 1 character and at most 64 characters
        #     long.
        #
        #     Note: The following fields are mutually exclusive: `user_specified_system`, `integrated_system`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] gcs_fileset_spec
        #   @return [::Google::Cloud::DataCatalog::V1beta1::GcsFilesetSpec]
        #     Specification that applies to a Cloud Storage fileset. This is only valid
        #     on entries of type FILESET.
        #
        #     Note: The following fields are mutually exclusive: `gcs_fileset_spec`, `bigquery_table_spec`, `bigquery_date_sharded_spec`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] bigquery_table_spec
        #   @return [::Google::Cloud::DataCatalog::V1beta1::BigQueryTableSpec]
        #     Specification that applies to a BigQuery table. This is only valid on
        #     entries of type `TABLE`.
        #
        #     Note: The following fields are mutually exclusive: `bigquery_table_spec`, `gcs_fileset_spec`, `bigquery_date_sharded_spec`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] bigquery_date_sharded_spec
        #   @return [::Google::Cloud::DataCatalog::V1beta1::BigQueryDateShardedSpec]
        #     Specification for a group of BigQuery tables with name pattern
        #     `[prefix]YYYYMMDD`. Context:
        #     https://cloud.google.com/bigquery/docs/partitioned-tables#partitioning_versus_sharding.
        #
        #     Note: The following fields are mutually exclusive: `bigquery_date_sharded_spec`, `gcs_fileset_spec`, `bigquery_table_spec`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Display information such as title and description. A short name to identify
        #     the entry, for example, "Analytics Data - Jan 2011". Default value is an
        #     empty string.
        # @!attribute [rw] description
        #   @return [::String]
        #     Entry description, which can consist of several sentences or paragraphs
        #     that describe entry contents. Default value is an empty string.
        # @!attribute [rw] schema
        #   @return [::Google::Cloud::DataCatalog::V1beta1::Schema]
        #     Schema of the entry. An entry might not have any schema attached to it.
        # @!attribute [r] source_system_timestamps
        #   @return [::Google::Cloud::DataCatalog::V1beta1::SystemTimestamps]
        #     Output only. Timestamps about the underlying resource, not about this Data
        #     Catalog entry. Output only when Entry is of type in the EntryType enum. For
        #     entries with user_specified_type, this field is optional and defaults to an
        #     empty timestamp.
        # @!attribute [r] usage_signal
        #   @return [::Google::Cloud::DataCatalog::V1beta1::UsageSignal]
        #     Output only. Statistics on the usage level of the resource.
        class Entry
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # EntryGroup Metadata.
        # An EntryGroup resource represents a logical grouping of zero or more
        # Data Catalog {::Google::Cloud::DataCatalog::V1beta1::Entry Entry} resources.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The resource name of the entry group in URL format. Example:
        #
        #     * projects/\\{project_id}/locations/\\{location}/entryGroups/\\{entry_group_id}
        #
        #     Note that this EntryGroup and its child resources may not actually be
        #     stored in the location in this name.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     A short name to identify the entry group, for example,
        #     "analytics data - jan 2011". Default value is an empty string.
        # @!attribute [rw] description
        #   @return [::String]
        #     Entry group description, which can consist of several sentences or
        #     paragraphs that describe entry group contents. Default value is an empty
        #     string.
        # @!attribute [r] data_catalog_timestamps
        #   @return [::Google::Cloud::DataCatalog::V1beta1::SystemTimestamps]
        #     Output only. Timestamps about this EntryGroup. Default value is empty
        #     timestamps.
        class EntryGroup
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client#create_tag_template CreateTagTemplate}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the project and the template location
        #     [region](https://cloud.google.com/data-catalog/docs/concepts/regions.
        #
        #     Example:
        #
        #     * projects/\\{project_id}/locations/us-central1
        # @!attribute [rw] tag_template_id
        #   @return [::String]
        #     Required. The id of the tag template to create.
        # @!attribute [rw] tag_template
        #   @return [::Google::Cloud::DataCatalog::V1beta1::TagTemplate]
        #     Required. The tag template to create.
        class CreateTagTemplateRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client#get_tag_template GetTagTemplate}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the tag template. Example:
        #
        #     * projects/\\{project_id}/locations/\\{location}/tagTemplates/\\{tag_template_id}
        class GetTagTemplateRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client#update_tag_template UpdateTagTemplate}.
        # @!attribute [rw] tag_template
        #   @return [::Google::Cloud::DataCatalog::V1beta1::TagTemplate]
        #     Required. The template to update. The "name" field must be set.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Names of fields whose values to overwrite on a tag template. Currently,
        #     only `display_name` can be overwritten.
        #
        #     In general, if this parameter is absent or empty, all modifiable fields
        #     are overwritten. If such fields are non-required and omitted in the
        #     request body, their values are emptied.
        class UpdateTagTemplateRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client#delete_tag_template DeleteTagTemplate}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the tag template to delete. Example:
        #
        #     * projects/\\{project_id}/locations/\\{location}/tagTemplates/\\{tag_template_id}
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     Required. Currently, this field must always be set to `true`.
        #     This confirms the deletion of any possible tags using this template.
        #     `force = false` will be supported in the future.
        class DeleteTagTemplateRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client#create_tag CreateTag}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the resource to attach this tag to. Tags can be
        #     attached to
        #      Entries. Example:
        #
        #      * projects/\\{project_id}/locations/\\{location}/entryGroups/\\{entry_group_id}/entries/\\{entry_id}
        #
        #      Note that this Tag and its child resources may not actually be stored in
        #      the location in this name.
        # @!attribute [rw] tag
        #   @return [::Google::Cloud::DataCatalog::V1beta1::Tag]
        #     Required. The tag to create.
        class CreateTagRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client#update_tag UpdateTag}.
        # @!attribute [rw] tag
        #   @return [::Google::Cloud::DataCatalog::V1beta1::Tag]
        #     Required. The updated tag. The "name" field must be set.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Note: Currently, this parameter can only take `"fields"` as value.
        #
        #     Names of fields whose values to overwrite on a tag. Currently, a tag has
        #     the only modifiable field with the name `fields`.
        #
        #     In general, if this parameter is absent or empty, all modifiable fields
        #     are overwritten. If such fields are non-required and omitted in the
        #     request body, their values are emptied.
        class UpdateTagRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client#delete_tag DeleteTag}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the tag to delete. Example:
        #
        #     * projects/\\{project_id}/locations/\\{location}/entryGroups/\\{entry_group_id}/entries/\\{entry_id}/tags/\\{tag_id}
        class DeleteTagRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client#create_tag_template_field CreateTagTemplateField}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the project and the template location
        #     [region](https://cloud.google.com/data-catalog/docs/concepts/regions).
        #
        #     Example:
        #
        #     * projects/\\{project_id}/locations/us-central1/tagTemplates/\\{tag_template_id}
        # @!attribute [rw] tag_template_field_id
        #   @return [::String]
        #     Required. The ID of the tag template field to create.
        #     Field ids can contain letters (both uppercase and lowercase), numbers
        #     (0-9), underscores (_) and dashes (-). Field IDs must be at least 1
        #     character long and at most 128 characters long. Field IDs must also be
        #     unique within their template.
        # @!attribute [rw] tag_template_field
        #   @return [::Google::Cloud::DataCatalog::V1beta1::TagTemplateField]
        #     Required. The tag template field to create.
        class CreateTagTemplateFieldRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client#update_tag_template_field UpdateTagTemplateField}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the tag template field. Example:
        #
        #     * projects/\\{project_id}/locations/\\{location}/tagTemplates/\\{tag_template_id}/fields/\\{tag_template_field_id}
        # @!attribute [rw] tag_template_field
        #   @return [::Google::Cloud::DataCatalog::V1beta1::TagTemplateField]
        #     Required. The template to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Names of fields whose values to overwrite on an individual field
        #     of a tag template. The following fields are modifiable:
        #
        #       * `display_name`
        #       * `type.enum_type`
        #       * `is_required`
        #
        #     If this parameter is absent or empty, all modifiable fields
        #     are overwritten. If such fields are non-required and omitted in the request
        #     body, their values are emptied with one exception: when updating an enum
        #     type, the provided values are merged with the existing values. Therefore,
        #     enum values can only be added, existing enum values cannot be deleted or
        #     renamed.
        #
        #     Additionally, updating a template field from optional to required is
        #     *not* allowed.
        class UpdateTagTemplateFieldRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client#rename_tag_template_field RenameTagTemplateField}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the tag template. Example:
        #
        #     * projects/\\{project_id}/locations/\\{location}/tagTemplates/\\{tag_template_id}/fields/\\{tag_template_field_id}
        # @!attribute [rw] new_tag_template_field_id
        #   @return [::String]
        #     Required. The new ID of this tag template field. For example,
        #     `my_new_field`.
        class RenameTagTemplateFieldRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # [RenameTagTemplateFieldEnumValue][google.cloud.datacatalog.v1.DataCatalog.RenameTagTemplateFieldEnumValue].
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the enum field value. Example:
        #
        #     * projects/\\{project_id}/locations/\\{location}/tagTemplates/\\{tag_template_id}/fields/\\{tag_template_field_id}/enumValues/\\{enum_value_display_name}
        # @!attribute [rw] new_enum_value_display_name
        #   @return [::String]
        #     Required. The new display name of the enum value. For example,
        #     `my_new_enum_value`.
        class RenameTagTemplateFieldEnumValueRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client#delete_tag_template_field DeleteTagTemplateField}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the tag template field to delete. Example:
        #
        #     * projects/\\{project_id}/locations/\\{location}/tagTemplates/\\{tag_template_id}/fields/\\{tag_template_field_id}
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     Required. Currently, this field must always be set to `true`.
        #     This confirms the deletion of this field from any tags using this field.
        #     `force = false` will be supported in the future.
        class DeleteTagTemplateFieldRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client#list_tags ListTags}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the Data Catalog resource to list the tags of. The
        #     resource could be an {::Google::Cloud::DataCatalog::V1beta1::Entry Entry} or an
        #     {::Google::Cloud::DataCatalog::V1beta1::EntryGroup EntryGroup}.
        #
        #     Examples:
        #
        #     * projects/\\{project_id}/locations/\\{location}/entryGroups/\\{entry_group_id}
        #     * projects/\\{project_id}/locations/\\{location}/entryGroups/\\{entry_group_id}/entries/\\{entry_id}
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of tags to return. Default is 10. Max limit is 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Token that specifies which page is requested. If empty, the first page is
        #     returned.
        class ListTagsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client#list_tags ListTags}.
        # @!attribute [rw] tags
        #   @return [::Array<::Google::Cloud::DataCatalog::V1beta1::Tag>]
        #     {::Google::Cloud::DataCatalog::V1beta1::Tag Tag} details.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to retrieve the next page of results. It is set to empty if no items
        #     remain in results.
        class ListTagsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client#list_entries ListEntries}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the entry group that contains the entries, which can
        #     be provided in URL format. Example:
        #
        #     * projects/\\{project_id}/locations/\\{location}/entryGroups/\\{entry_group_id}
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of items to return. Default is 10. Max limit is 1000.
        #     Throws an invalid argument for `page_size > 1000`.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Token that specifies which page is requested. If empty, the first page is
        #     returned.
        # @!attribute [rw] read_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The fields to return for each Entry. If not set or empty, all
        #     fields are returned.
        #     For example, setting read_mask to contain only one path "name" will cause
        #     ListEntries to return a list of Entries with only "name" field.
        class ListEntriesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client#list_entries ListEntries}.
        # @!attribute [rw] entries
        #   @return [::Array<::Google::Cloud::DataCatalog::V1beta1::Entry>]
        #     Entry details.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to retrieve the next page of results. It is set to empty if no items
        #     remain in results.
        class ListEntriesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Entry resources in Data Catalog can be of different types e.g. a BigQuery
        # Table entry is of type `TABLE`. This enum describes all the possible types
        # Data Catalog contains.
        module EntryType
          # Default unknown type.
          ENTRY_TYPE_UNSPECIFIED = 0

          # Output only. The type of entry that has a GoogleSQL schema, including
          # logical views.
          TABLE = 2

          # Output only. The type of models.
          # https://cloud.google.com/bigquery-ml/docs/bigqueryml-intro
          MODEL = 5

          # Output only. An entry type which is used for streaming entries. Example:
          # Pub/Sub topic.
          DATA_STREAM = 3

          # An entry type which is a set of files or objects. Example:
          # Cloud Storage fileset.
          FILESET = 4
        end
      end
    end
  end
end
