# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/datacatalog/v1beta1/datacatalog_pb"
require "google/iam/v1"

module Google
  module Cloud
    module DataCatalog
      module V1beta1
        module DataCatalog
          ##
          # Client for the DataCatalog service.
          #
          # Deprecated: Please use Dataplex Catalog instead.
          #
          # Data Catalog API service allows clients to discover, understand, and manage
          # their data.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "datacatalog.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :data_catalog_stub

            ##
            # Configure the DataCatalog Client class.
            #
            # See {::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @deprecated This service is deprecated and may be removed in the next major version update.
            #
            # @example
            #
            #   # Modify the configuration for all DataCatalog clients
            #   ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "DataCatalog", "V1beta1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.timeout = 60.0
                default_config.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 8, 13]
                }

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the DataCatalog Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @data_catalog_stub.universe_domain
            end

            ##
            # Create a new DataCatalog client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the DataCatalog client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/datacatalog/v1beta1/datacatalog_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @data_catalog_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @data_catalog_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @iam_policy_client = Google::Iam::V1::IAMPolicy::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @data_catalog_stub.endpoint
                config.universe_domain = @data_catalog_stub.universe_domain
                config.logger = @data_catalog_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for mix-in of the IAMPolicy.
            #
            # @return [Google::Iam::V1::IAMPolicy::Client]
            #
            attr_reader :iam_policy_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @data_catalog_stub.logger
            end

            # Service calls

            ##
            # Searches Data Catalog for multiple resources like entries, tags that
            # match a query.
            #
            # This is a custom method
            # (https://cloud.google.com/apis/design/custom_methods) and does not return
            # the complete resource, only the resource identifier and high level
            # fields. Clients can subsequently call `Get` methods.
            #
            # Note that Data Catalog search queries do not guarantee full recall. Query
            # results that match your query may not be returned, even in subsequent
            # result pages. Also note that results returned (and not returned) can vary
            # across repeated search queries.
            #
            # See [Data Catalog Search
            # Syntax](https://cloud.google.com/data-catalog/docs/how-to/search-reference)
            # for more information.
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload search_catalog(request, options = nil)
            #   Pass arguments to `search_catalog` via a request object, either of type
            #   {::Google::Cloud::DataCatalog::V1beta1::SearchCatalogRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DataCatalog::V1beta1::SearchCatalogRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload search_catalog(scope: nil, query: nil, page_size: nil, page_token: nil, order_by: nil)
            #   Pass arguments to `search_catalog` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param scope [::Google::Cloud::DataCatalog::V1beta1::SearchCatalogRequest::Scope, ::Hash]
            #     Required. The scope of this search request. A `scope` that has empty
            #     `include_org_ids`, `include_project_ids` AND false
            #     `include_gcp_public_datasets` is considered invalid. Data Catalog will
            #     return an error in such a case.
            #   @param query [::String]
            #     Optional. The query string in search query syntax. An empty query string
            #     will result in all data assets (in the specified scope) that the user has
            #     access to. Query strings can be simple as "x" or more qualified as:
            #
            #     * name:x
            #     * column:x
            #     * description:y
            #
            #     Note: Query tokens need to have a minimum of 3 characters for substring
            #     matching to work correctly. See [Data Catalog Search
            #     Syntax](https://cloud.google.com/data-catalog/docs/how-to/search-reference)
            #     for more information.
            #   @param page_size [::Integer]
            #     Number of results in the search page. If <=0 then defaults to 10. Max limit
            #     for page_size is 1000. Throws an invalid argument for page_size > 1000.
            #   @param page_token [::String]
            #     Optional. Pagination token returned in an earlier
            #     {::Google::Cloud::DataCatalog::V1beta1::SearchCatalogResponse#next_page_token SearchCatalogResponse.next_page_token},
            #     which indicates that this is a continuation of a prior
            #     {::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client#search_catalog SearchCatalogRequest}
            #     call, and that the system should return the next page of data. If empty,
            #     the first page is returned.
            #   @param order_by [::String]
            #     Specifies the ordering of results, currently supported case-sensitive
            #     choices are:
            #
            #       * `relevance`, only supports descending
            #       * `last_modified_timestamp [asc|desc]`, defaults to descending if not
            #         specified
            #       * `default` that can only be descending
            #
            #     If not specified, defaults to `relevance` descending.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::DataCatalog::V1beta1::SearchCatalogResult>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::DataCatalog::V1beta1::SearchCatalogResult>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_catalog/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DataCatalog::V1beta1::SearchCatalogRequest.new
            #
            #   # Call the search_catalog method.
            #   result = client.search_catalog request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::DataCatalog::V1beta1::SearchCatalogResult.
            #     p item
            #   end
            #
            def search_catalog request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::V1beta1::SearchCatalogRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.search_catalog.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataCatalog::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              options.apply_defaults timeout:      @config.rpcs.search_catalog.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.search_catalog.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_catalog_stub.call_rpc :search_catalog, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @data_catalog_stub, :search_catalog, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # A maximum of 10,000 entry groups may be created per organization across all
            # locations.
            #
            # Users should enable the Data Catalog API in the project identified by
            # the `parent` parameter (see [Data Catalog Resource Project]
            # (https://cloud.google.com/data-catalog/docs/concepts/resource-project) for
            # more information).
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload create_entry_group(request, options = nil)
            #   Pass arguments to `create_entry_group` via a request object, either of type
            #   {::Google::Cloud::DataCatalog::V1beta1::CreateEntryGroupRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DataCatalog::V1beta1::CreateEntryGroupRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_entry_group(parent: nil, entry_group_id: nil, entry_group: nil)
            #   Pass arguments to `create_entry_group` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The name of the project this entry group is in. Example:
            #
            #     * projects/\\{project_id}/locations/\\{location}
            #
            #     Note that this EntryGroup and its child resources may not actually be
            #     stored in the location in this name.
            #   @param entry_group_id [::String]
            #     Required. The id of the entry group to create.
            #     The id must begin with a letter or underscore, contain only English
            #     letters, numbers and underscores, and be at most 64 characters.
            #   @param entry_group [::Google::Cloud::DataCatalog::V1beta1::EntryGroup, ::Hash]
            #     The entry group to create. Defaults to an empty entry group.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::DataCatalog::V1beta1::EntryGroup]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::DataCatalog::V1beta1::EntryGroup]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_catalog/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DataCatalog::V1beta1::CreateEntryGroupRequest.new
            #
            #   # Call the create_entry_group method.
            #   result = client.create_entry_group request
            #
            #   # The returned object is of type Google::Cloud::DataCatalog::V1beta1::EntryGroup.
            #   p result
            #
            def create_entry_group request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::V1beta1::CreateEntryGroupRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_entry_group.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataCatalog::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_entry_group.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_entry_group.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_catalog_stub.call_rpc :create_entry_group, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates an EntryGroup. The user should enable the Data Catalog API in the
            # project identified by the `entry_group.name` parameter (see [Data Catalog
            # Resource Project]
            # (https://cloud.google.com/data-catalog/docs/concepts/resource-project) for
            # more information).
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload update_entry_group(request, options = nil)
            #   Pass arguments to `update_entry_group` via a request object, either of type
            #   {::Google::Cloud::DataCatalog::V1beta1::UpdateEntryGroupRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DataCatalog::V1beta1::UpdateEntryGroupRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_entry_group(entry_group: nil, update_mask: nil)
            #   Pass arguments to `update_entry_group` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param entry_group [::Google::Cloud::DataCatalog::V1beta1::EntryGroup, ::Hash]
            #     Required. The updated entry group. "name" field must be set.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Names of fields whose values to overwrite on an entry group.
            #
            #     If this parameter is absent or empty, all modifiable fields
            #     are overwritten. If such fields are non-required and omitted in the
            #     request body, their values are emptied.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::DataCatalog::V1beta1::EntryGroup]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::DataCatalog::V1beta1::EntryGroup]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_catalog/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DataCatalog::V1beta1::UpdateEntryGroupRequest.new
            #
            #   # Call the update_entry_group method.
            #   result = client.update_entry_group request
            #
            #   # The returned object is of type Google::Cloud::DataCatalog::V1beta1::EntryGroup.
            #   p result
            #
            def update_entry_group request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::V1beta1::UpdateEntryGroupRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_entry_group.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataCatalog::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.entry_group&.name
                header_params["entry_group.name"] = request.entry_group.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_entry_group.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_entry_group.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_catalog_stub.call_rpc :update_entry_group, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets an EntryGroup.
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload get_entry_group(request, options = nil)
            #   Pass arguments to `get_entry_group` via a request object, either of type
            #   {::Google::Cloud::DataCatalog::V1beta1::GetEntryGroupRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DataCatalog::V1beta1::GetEntryGroupRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_entry_group(name: nil, read_mask: nil)
            #   Pass arguments to `get_entry_group` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the entry group. For example,
            #     `projects/{project_id}/locations/{location}/entryGroups/{entry_group_id}`.
            #   @param read_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     The fields to return. If not set or empty, all fields are returned.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::DataCatalog::V1beta1::EntryGroup]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::DataCatalog::V1beta1::EntryGroup]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_catalog/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DataCatalog::V1beta1::GetEntryGroupRequest.new
            #
            #   # Call the get_entry_group method.
            #   result = client.get_entry_group request
            #
            #   # The returned object is of type Google::Cloud::DataCatalog::V1beta1::EntryGroup.
            #   p result
            #
            def get_entry_group request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::V1beta1::GetEntryGroupRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_entry_group.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataCatalog::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_entry_group.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_entry_group.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_catalog_stub.call_rpc :get_entry_group, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes an EntryGroup. Only entry groups that do not contain entries can be
            # deleted. Users should enable the Data Catalog API in the project
            # identified by the `name` parameter (see [Data Catalog Resource Project]
            # (https://cloud.google.com/data-catalog/docs/concepts/resource-project) for
            # more information).
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload delete_entry_group(request, options = nil)
            #   Pass arguments to `delete_entry_group` via a request object, either of type
            #   {::Google::Cloud::DataCatalog::V1beta1::DeleteEntryGroupRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DataCatalog::V1beta1::DeleteEntryGroupRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_entry_group(name: nil, force: nil)
            #   Pass arguments to `delete_entry_group` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the entry group. For example,
            #     `projects/{project_id}/locations/{location}/entryGroups/{entry_group_id}`.
            #   @param force [::Boolean]
            #     Optional. If true, deletes all entries in the entry group.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_catalog/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DataCatalog::V1beta1::DeleteEntryGroupRequest.new
            #
            #   # Call the delete_entry_group method.
            #   result = client.delete_entry_group request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_entry_group request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::V1beta1::DeleteEntryGroupRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_entry_group.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataCatalog::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_entry_group.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_entry_group.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_catalog_stub.call_rpc :delete_entry_group, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists entry groups.
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload list_entry_groups(request, options = nil)
            #   Pass arguments to `list_entry_groups` via a request object, either of type
            #   {::Google::Cloud::DataCatalog::V1beta1::ListEntryGroupsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DataCatalog::V1beta1::ListEntryGroupsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_entry_groups(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_entry_groups` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The name of the location that contains the entry groups, which
            #     can be provided in URL format. Example:
            #
            #     * projects/\\{project_id}/locations/\\{location}
            #   @param page_size [::Integer]
            #     Optional. The maximum number of items to return. Default is 10. Max limit
            #     is 1000. Throws an invalid argument for `page_size > 1000`.
            #   @param page_token [::String]
            #     Optional. Token that specifies which page is requested. If empty, the first
            #     page is returned.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::DataCatalog::V1beta1::EntryGroup>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::DataCatalog::V1beta1::EntryGroup>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_catalog/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DataCatalog::V1beta1::ListEntryGroupsRequest.new
            #
            #   # Call the list_entry_groups method.
            #   result = client.list_entry_groups request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::DataCatalog::V1beta1::EntryGroup.
            #     p item
            #   end
            #
            def list_entry_groups request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::V1beta1::ListEntryGroupsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_entry_groups.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataCatalog::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_entry_groups.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_entry_groups.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_catalog_stub.call_rpc :list_entry_groups, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @data_catalog_stub, :list_entry_groups, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates an entry. Only entries of 'FILESET' type or user-specified type can
            # be created.
            #
            # Users should enable the Data Catalog API in the project identified by
            # the `parent` parameter (see [Data Catalog Resource Project]
            # (https://cloud.google.com/data-catalog/docs/concepts/resource-project) for
            # more information).
            #
            # A maximum of 100,000 entries may be created per entry group.
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload create_entry(request, options = nil)
            #   Pass arguments to `create_entry` via a request object, either of type
            #   {::Google::Cloud::DataCatalog::V1beta1::CreateEntryRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DataCatalog::V1beta1::CreateEntryRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_entry(parent: nil, entry_id: nil, entry: nil)
            #   Pass arguments to `create_entry` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The name of the entry group this entry is in. Example:
            #
            #     * projects/\\{project_id}/locations/\\{location}/entryGroups/\\{entry_group_id}
            #
            #     Note that this Entry and its child resources may not actually be stored in
            #     the location in this name.
            #   @param entry_id [::String]
            #     Required. The id of the entry to create.
            #   @param entry [::Google::Cloud::DataCatalog::V1beta1::Entry, ::Hash]
            #     Required. The entry to create.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::DataCatalog::V1beta1::Entry]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::DataCatalog::V1beta1::Entry]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_catalog/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DataCatalog::V1beta1::CreateEntryRequest.new
            #
            #   # Call the create_entry method.
            #   result = client.create_entry request
            #
            #   # The returned object is of type Google::Cloud::DataCatalog::V1beta1::Entry.
            #   p result
            #
            def create_entry request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::V1beta1::CreateEntryRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_entry.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataCatalog::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_entry.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_entry.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_catalog_stub.call_rpc :create_entry, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates an existing entry.
            # Users should enable the Data Catalog API in the project identified by
            # the `entry.name` parameter (see [Data Catalog Resource Project]
            # (https://cloud.google.com/data-catalog/docs/concepts/resource-project) for
            # more information).
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload update_entry(request, options = nil)
            #   Pass arguments to `update_entry` via a request object, either of type
            #   {::Google::Cloud::DataCatalog::V1beta1::UpdateEntryRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DataCatalog::V1beta1::UpdateEntryRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_entry(entry: nil, update_mask: nil)
            #   Pass arguments to `update_entry` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param entry [::Google::Cloud::DataCatalog::V1beta1::Entry, ::Hash]
            #     Required. The updated entry. The "name" field must be set.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Names of fields whose values to overwrite on an entry.
            #
            #     If this parameter is absent or empty, all modifiable fields
            #     are overwritten. If such fields are non-required and omitted in the
            #     request body, their values are emptied.
            #
            #     The following fields are modifiable:
            #
            #     * For entries with type `DATA_STREAM`:
            #        * `schema`
            #     * For entries with type `FILESET`:
            #        * `schema`
            #        * `display_name`
            #        * `description`
            #        * `gcs_fileset_spec`
            #        * `gcs_fileset_spec.file_patterns`
            #     * For entries with `user_specified_type`:
            #        * `schema`
            #        * `display_name`
            #        * `description`
            #        * `user_specified_type`
            #        * `user_specified_system`
            #        * `linked_resource`
            #        * `source_system_timestamps`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::DataCatalog::V1beta1::Entry]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::DataCatalog::V1beta1::Entry]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_catalog/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DataCatalog::V1beta1::UpdateEntryRequest.new
            #
            #   # Call the update_entry method.
            #   result = client.update_entry request
            #
            #   # The returned object is of type Google::Cloud::DataCatalog::V1beta1::Entry.
            #   p result
            #
            def update_entry request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::V1beta1::UpdateEntryRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_entry.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataCatalog::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.entry&.name
                header_params["entry.name"] = request.entry.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_entry.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_entry.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_catalog_stub.call_rpc :update_entry, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes an existing entry. Only entries created through
            # {::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client#create_entry CreateEntry}
            # method can be deleted.
            # Users should enable the Data Catalog API in the project identified by
            # the `name` parameter (see [Data Catalog Resource Project]
            # (https://cloud.google.com/data-catalog/docs/concepts/resource-project) for
            # more information).
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload delete_entry(request, options = nil)
            #   Pass arguments to `delete_entry` via a request object, either of type
            #   {::Google::Cloud::DataCatalog::V1beta1::DeleteEntryRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DataCatalog::V1beta1::DeleteEntryRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_entry(name: nil)
            #   Pass arguments to `delete_entry` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the entry. Example:
            #
            #     * projects/\\{project_id}/locations/\\{location}/entryGroups/\\{entry_group_id}/entries/\\{entry_id}
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_catalog/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DataCatalog::V1beta1::DeleteEntryRequest.new
            #
            #   # Call the delete_entry method.
            #   result = client.delete_entry request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_entry request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::V1beta1::DeleteEntryRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_entry.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataCatalog::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_entry.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_entry.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_catalog_stub.call_rpc :delete_entry, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets an entry.
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload get_entry(request, options = nil)
            #   Pass arguments to `get_entry` via a request object, either of type
            #   {::Google::Cloud::DataCatalog::V1beta1::GetEntryRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DataCatalog::V1beta1::GetEntryRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_entry(name: nil)
            #   Pass arguments to `get_entry` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the entry. Example:
            #
            #     * projects/\\{project_id}/locations/\\{location}/entryGroups/\\{entry_group_id}/entries/\\{entry_id}
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::DataCatalog::V1beta1::Entry]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::DataCatalog::V1beta1::Entry]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_catalog/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DataCatalog::V1beta1::GetEntryRequest.new
            #
            #   # Call the get_entry method.
            #   result = client.get_entry request
            #
            #   # The returned object is of type Google::Cloud::DataCatalog::V1beta1::Entry.
            #   p result
            #
            def get_entry request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::V1beta1::GetEntryRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_entry.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataCatalog::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_entry.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_entry.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_catalog_stub.call_rpc :get_entry, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Get an entry by target resource name. This method allows clients to use
            # the resource name from the source Google Cloud Platform service to get the
            # Data Catalog Entry.
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload lookup_entry(request, options = nil)
            #   Pass arguments to `lookup_entry` via a request object, either of type
            #   {::Google::Cloud::DataCatalog::V1beta1::LookupEntryRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DataCatalog::V1beta1::LookupEntryRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload lookup_entry(linked_resource: nil, sql_resource: nil)
            #   Pass arguments to `lookup_entry` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param linked_resource [::String]
            #     The full name of the Google Cloud Platform resource the Data Catalog
            #     entry represents. See:
            #     https://cloud.google.com/apis/design/resource_names#full_resource_name.
            #     Full names are case-sensitive.
            #
            #     Examples:
            #
            #      * //bigquery.googleapis.com/projects/projectId/datasets/datasetId/tables/tableId
            #      * //pubsub.googleapis.com/projects/projectId/topics/topicId
            #
            #     Note: The following parameters are mutually exclusive: `linked_resource`, `sql_resource`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param sql_resource [::String]
            #     The SQL name of the entry. SQL names are case-sensitive.
            #
            #     Examples:
            #
            #       * `pubsub.project_id.topic_id`
            #       * ``pubsub.project_id.`topic.id.with.dots` ``
            #       * `bigquery.table.project_id.dataset_id.table_id`
            #       * `bigquery.dataset.project_id.dataset_id`
            #       * `datacatalog.entry.project_id.location_id.entry_group_id.entry_id`
            #
            #     `*_id`s should satisfy the GoogleSQL rules for identifiers.
            #     https://cloud.google.com/bigquery/docs/reference/standard-sql/lexical.
            #
            #     Note: The following parameters are mutually exclusive: `sql_resource`, `linked_resource`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::DataCatalog::V1beta1::Entry]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::DataCatalog::V1beta1::Entry]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_catalog/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DataCatalog::V1beta1::LookupEntryRequest.new
            #
            #   # Call the lookup_entry method.
            #   result = client.lookup_entry request
            #
            #   # The returned object is of type Google::Cloud::DataCatalog::V1beta1::Entry.
            #   p result
            #
            def lookup_entry request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::V1beta1::LookupEntryRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.lookup_entry.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataCatalog::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              options.apply_defaults timeout:      @config.rpcs.lookup_entry.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.lookup_entry.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_catalog_stub.call_rpc :lookup_entry, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists entries.
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload list_entries(request, options = nil)
            #   Pass arguments to `list_entries` via a request object, either of type
            #   {::Google::Cloud::DataCatalog::V1beta1::ListEntriesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DataCatalog::V1beta1::ListEntriesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_entries(parent: nil, page_size: nil, page_token: nil, read_mask: nil)
            #   Pass arguments to `list_entries` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The name of the entry group that contains the entries, which can
            #     be provided in URL format. Example:
            #
            #     * projects/\\{project_id}/locations/\\{location}/entryGroups/\\{entry_group_id}
            #   @param page_size [::Integer]
            #     The maximum number of items to return. Default is 10. Max limit is 1000.
            #     Throws an invalid argument for `page_size > 1000`.
            #   @param page_token [::String]
            #     Token that specifies which page is requested. If empty, the first page is
            #     returned.
            #   @param read_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     The fields to return for each Entry. If not set or empty, all
            #     fields are returned.
            #     For example, setting read_mask to contain only one path "name" will cause
            #     ListEntries to return a list of Entries with only "name" field.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::DataCatalog::V1beta1::Entry>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::DataCatalog::V1beta1::Entry>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_catalog/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DataCatalog::V1beta1::ListEntriesRequest.new
            #
            #   # Call the list_entries method.
            #   result = client.list_entries request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::DataCatalog::V1beta1::Entry.
            #     p item
            #   end
            #
            def list_entries request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::V1beta1::ListEntriesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_entries.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataCatalog::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_entries.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_entries.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_catalog_stub.call_rpc :list_entries, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @data_catalog_stub, :list_entries, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a tag template. The user should enable the Data Catalog API in
            # the project identified by the `parent` parameter (see [Data Catalog
            # Resource
            # Project](https://cloud.google.com/data-catalog/docs/concepts/resource-project)
            # for more information).
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload create_tag_template(request, options = nil)
            #   Pass arguments to `create_tag_template` via a request object, either of type
            #   {::Google::Cloud::DataCatalog::V1beta1::CreateTagTemplateRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DataCatalog::V1beta1::CreateTagTemplateRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_tag_template(parent: nil, tag_template_id: nil, tag_template: nil)
            #   Pass arguments to `create_tag_template` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The name of the project and the template location
            #     [region](https://cloud.google.com/data-catalog/docs/concepts/regions.
            #
            #     Example:
            #
            #     * projects/\\{project_id}/locations/us-central1
            #   @param tag_template_id [::String]
            #     Required. The id of the tag template to create.
            #   @param tag_template [::Google::Cloud::DataCatalog::V1beta1::TagTemplate, ::Hash]
            #     Required. The tag template to create.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::DataCatalog::V1beta1::TagTemplate]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::DataCatalog::V1beta1::TagTemplate]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_catalog/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DataCatalog::V1beta1::CreateTagTemplateRequest.new
            #
            #   # Call the create_tag_template method.
            #   result = client.create_tag_template request
            #
            #   # The returned object is of type Google::Cloud::DataCatalog::V1beta1::TagTemplate.
            #   p result
            #
            def create_tag_template request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::V1beta1::CreateTagTemplateRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_tag_template.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataCatalog::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_tag_template.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_tag_template.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_catalog_stub.call_rpc :create_tag_template, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a tag template.
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload get_tag_template(request, options = nil)
            #   Pass arguments to `get_tag_template` via a request object, either of type
            #   {::Google::Cloud::DataCatalog::V1beta1::GetTagTemplateRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DataCatalog::V1beta1::GetTagTemplateRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_tag_template(name: nil)
            #   Pass arguments to `get_tag_template` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the tag template. Example:
            #
            #     * projects/\\{project_id}/locations/\\{location}/tagTemplates/\\{tag_template_id}
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::DataCatalog::V1beta1::TagTemplate]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::DataCatalog::V1beta1::TagTemplate]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_catalog/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DataCatalog::V1beta1::GetTagTemplateRequest.new
            #
            #   # Call the get_tag_template method.
            #   result = client.get_tag_template request
            #
            #   # The returned object is of type Google::Cloud::DataCatalog::V1beta1::TagTemplate.
            #   p result
            #
            def get_tag_template request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::V1beta1::GetTagTemplateRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_tag_template.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataCatalog::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_tag_template.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_tag_template.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_catalog_stub.call_rpc :get_tag_template, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a tag template. This method cannot be used to update the fields of
            # a template. The tag template fields are represented as separate resources
            # and should be updated using their own create/update/delete methods.
            # Users should enable the Data Catalog API in the project identified by
            # the `tag_template.name` parameter (see [Data Catalog Resource Project]
            # (https://cloud.google.com/data-catalog/docs/concepts/resource-project) for
            # more information).
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload update_tag_template(request, options = nil)
            #   Pass arguments to `update_tag_template` via a request object, either of type
            #   {::Google::Cloud::DataCatalog::V1beta1::UpdateTagTemplateRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DataCatalog::V1beta1::UpdateTagTemplateRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_tag_template(tag_template: nil, update_mask: nil)
            #   Pass arguments to `update_tag_template` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param tag_template [::Google::Cloud::DataCatalog::V1beta1::TagTemplate, ::Hash]
            #     Required. The template to update. The "name" field must be set.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Names of fields whose values to overwrite on a tag template. Currently,
            #     only `display_name` can be overwritten.
            #
            #     In general, if this parameter is absent or empty, all modifiable fields
            #     are overwritten. If such fields are non-required and omitted in the
            #     request body, their values are emptied.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::DataCatalog::V1beta1::TagTemplate]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::DataCatalog::V1beta1::TagTemplate]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_catalog/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DataCatalog::V1beta1::UpdateTagTemplateRequest.new
            #
            #   # Call the update_tag_template method.
            #   result = client.update_tag_template request
            #
            #   # The returned object is of type Google::Cloud::DataCatalog::V1beta1::TagTemplate.
            #   p result
            #
            def update_tag_template request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::V1beta1::UpdateTagTemplateRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_tag_template.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataCatalog::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.tag_template&.name
                header_params["tag_template.name"] = request.tag_template.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_tag_template.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_tag_template.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_catalog_stub.call_rpc :update_tag_template, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a tag template and all tags using the template.
            # Users should enable the Data Catalog API in the project identified by
            # the `name` parameter (see [Data Catalog Resource Project]
            # (https://cloud.google.com/data-catalog/docs/concepts/resource-project) for
            # more information).
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload delete_tag_template(request, options = nil)
            #   Pass arguments to `delete_tag_template` via a request object, either of type
            #   {::Google::Cloud::DataCatalog::V1beta1::DeleteTagTemplateRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DataCatalog::V1beta1::DeleteTagTemplateRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_tag_template(name: nil, force: nil)
            #   Pass arguments to `delete_tag_template` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the tag template to delete. Example:
            #
            #     * projects/\\{project_id}/locations/\\{location}/tagTemplates/\\{tag_template_id}
            #   @param force [::Boolean]
            #     Required. Currently, this field must always be set to `true`.
            #     This confirms the deletion of any possible tags using this template.
            #     `force = false` will be supported in the future.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_catalog/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DataCatalog::V1beta1::DeleteTagTemplateRequest.new
            #
            #   # Call the delete_tag_template method.
            #   result = client.delete_tag_template request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_tag_template request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::V1beta1::DeleteTagTemplateRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_tag_template.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataCatalog::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_tag_template.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_tag_template.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_catalog_stub.call_rpc :delete_tag_template, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a field in a tag template. The user should enable the Data Catalog
            # API in the project identified by the `parent` parameter (see
            # [Data Catalog Resource
            # Project](https://cloud.google.com/data-catalog/docs/concepts/resource-project)
            # for more information).
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload create_tag_template_field(request, options = nil)
            #   Pass arguments to `create_tag_template_field` via a request object, either of type
            #   {::Google::Cloud::DataCatalog::V1beta1::CreateTagTemplateFieldRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DataCatalog::V1beta1::CreateTagTemplateFieldRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_tag_template_field(parent: nil, tag_template_field_id: nil, tag_template_field: nil)
            #   Pass arguments to `create_tag_template_field` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The name of the project and the template location
            #     [region](https://cloud.google.com/data-catalog/docs/concepts/regions).
            #
            #     Example:
            #
            #     * projects/\\{project_id}/locations/us-central1/tagTemplates/\\{tag_template_id}
            #   @param tag_template_field_id [::String]
            #     Required. The ID of the tag template field to create.
            #     Field ids can contain letters (both uppercase and lowercase), numbers
            #     (0-9), underscores (_) and dashes (-). Field IDs must be at least 1
            #     character long and at most 128 characters long. Field IDs must also be
            #     unique within their template.
            #   @param tag_template_field [::Google::Cloud::DataCatalog::V1beta1::TagTemplateField, ::Hash]
            #     Required. The tag template field to create.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::DataCatalog::V1beta1::TagTemplateField]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::DataCatalog::V1beta1::TagTemplateField]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_catalog/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DataCatalog::V1beta1::CreateTagTemplateFieldRequest.new
            #
            #   # Call the create_tag_template_field method.
            #   result = client.create_tag_template_field request
            #
            #   # The returned object is of type Google::Cloud::DataCatalog::V1beta1::TagTemplateField.
            #   p result
            #
            def create_tag_template_field request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::V1beta1::CreateTagTemplateFieldRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_tag_template_field.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataCatalog::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_tag_template_field.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_tag_template_field.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_catalog_stub.call_rpc :create_tag_template_field, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a field in a tag template. This method cannot be used to update the
            # field type. Users should enable the Data Catalog API in the project
            # identified by the `name` parameter (see [Data Catalog Resource Project]
            # (https://cloud.google.com/data-catalog/docs/concepts/resource-project) for
            # more information).
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload update_tag_template_field(request, options = nil)
            #   Pass arguments to `update_tag_template_field` via a request object, either of type
            #   {::Google::Cloud::DataCatalog::V1beta1::UpdateTagTemplateFieldRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DataCatalog::V1beta1::UpdateTagTemplateFieldRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_tag_template_field(name: nil, tag_template_field: nil, update_mask: nil)
            #   Pass arguments to `update_tag_template_field` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the tag template field. Example:
            #
            #     * projects/\\{project_id}/locations/\\{location}/tagTemplates/\\{tag_template_id}/fields/\\{tag_template_field_id}
            #   @param tag_template_field [::Google::Cloud::DataCatalog::V1beta1::TagTemplateField, ::Hash]
            #     Required. The template to update.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Optional. Names of fields whose values to overwrite on an individual field
            #     of a tag template. The following fields are modifiable:
            #
            #       * `display_name`
            #       * `type.enum_type`
            #       * `is_required`
            #
            #     If this parameter is absent or empty, all modifiable fields
            #     are overwritten. If such fields are non-required and omitted in the request
            #     body, their values are emptied with one exception: when updating an enum
            #     type, the provided values are merged with the existing values. Therefore,
            #     enum values can only be added, existing enum values cannot be deleted or
            #     renamed.
            #
            #     Additionally, updating a template field from optional to required is
            #     *not* allowed.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::DataCatalog::V1beta1::TagTemplateField]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::DataCatalog::V1beta1::TagTemplateField]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_catalog/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DataCatalog::V1beta1::UpdateTagTemplateFieldRequest.new
            #
            #   # Call the update_tag_template_field method.
            #   result = client.update_tag_template_field request
            #
            #   # The returned object is of type Google::Cloud::DataCatalog::V1beta1::TagTemplateField.
            #   p result
            #
            def update_tag_template_field request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::V1beta1::UpdateTagTemplateFieldRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_tag_template_field.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataCatalog::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_tag_template_field.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_tag_template_field.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_catalog_stub.call_rpc :update_tag_template_field, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Renames a field in a tag template. The user should enable the Data Catalog
            # API in the project identified by the `name` parameter (see [Data Catalog
            # Resource
            # Project](https://cloud.google.com/data-catalog/docs/concepts/resource-project)
            # for more information).
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload rename_tag_template_field(request, options = nil)
            #   Pass arguments to `rename_tag_template_field` via a request object, either of type
            #   {::Google::Cloud::DataCatalog::V1beta1::RenameTagTemplateFieldRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DataCatalog::V1beta1::RenameTagTemplateFieldRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload rename_tag_template_field(name: nil, new_tag_template_field_id: nil)
            #   Pass arguments to `rename_tag_template_field` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the tag template. Example:
            #
            #     * projects/\\{project_id}/locations/\\{location}/tagTemplates/\\{tag_template_id}/fields/\\{tag_template_field_id}
            #   @param new_tag_template_field_id [::String]
            #     Required. The new ID of this tag template field. For example,
            #     `my_new_field`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::DataCatalog::V1beta1::TagTemplateField]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::DataCatalog::V1beta1::TagTemplateField]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_catalog/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DataCatalog::V1beta1::RenameTagTemplateFieldRequest.new
            #
            #   # Call the rename_tag_template_field method.
            #   result = client.rename_tag_template_field request
            #
            #   # The returned object is of type Google::Cloud::DataCatalog::V1beta1::TagTemplateField.
            #   p result
            #
            def rename_tag_template_field request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::V1beta1::RenameTagTemplateFieldRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.rename_tag_template_field.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataCatalog::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.rename_tag_template_field.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.rename_tag_template_field.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_catalog_stub.call_rpc :rename_tag_template_field, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Renames an enum value in a tag template. The enum values have to be unique
            # within one enum field. Thus, an enum value cannot be renamed with a name
            # used in any other enum value within the same enum field.
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload rename_tag_template_field_enum_value(request, options = nil)
            #   Pass arguments to `rename_tag_template_field_enum_value` via a request object, either of type
            #   {::Google::Cloud::DataCatalog::V1beta1::RenameTagTemplateFieldEnumValueRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DataCatalog::V1beta1::RenameTagTemplateFieldEnumValueRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload rename_tag_template_field_enum_value(name: nil, new_enum_value_display_name: nil)
            #   Pass arguments to `rename_tag_template_field_enum_value` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the enum field value. Example:
            #
            #     * projects/\\{project_id}/locations/\\{location}/tagTemplates/\\{tag_template_id}/fields/\\{tag_template_field_id}/enumValues/\\{enum_value_display_name}
            #   @param new_enum_value_display_name [::String]
            #     Required. The new display name of the enum value. For example,
            #     `my_new_enum_value`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::DataCatalog::V1beta1::TagTemplateField]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::DataCatalog::V1beta1::TagTemplateField]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_catalog/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DataCatalog::V1beta1::RenameTagTemplateFieldEnumValueRequest.new
            #
            #   # Call the rename_tag_template_field_enum_value method.
            #   result = client.rename_tag_template_field_enum_value request
            #
            #   # The returned object is of type Google::Cloud::DataCatalog::V1beta1::TagTemplateField.
            #   p result
            #
            def rename_tag_template_field_enum_value request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::V1beta1::RenameTagTemplateFieldEnumValueRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.rename_tag_template_field_enum_value.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataCatalog::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.rename_tag_template_field_enum_value.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.rename_tag_template_field_enum_value.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_catalog_stub.call_rpc :rename_tag_template_field_enum_value, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a field in a tag template and all uses of that field.
            # Users should enable the Data Catalog API in the project identified by
            # the `name` parameter (see [Data Catalog Resource Project]
            # (https://cloud.google.com/data-catalog/docs/concepts/resource-project) for
            # more information).
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload delete_tag_template_field(request, options = nil)
            #   Pass arguments to `delete_tag_template_field` via a request object, either of type
            #   {::Google::Cloud::DataCatalog::V1beta1::DeleteTagTemplateFieldRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DataCatalog::V1beta1::DeleteTagTemplateFieldRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_tag_template_field(name: nil, force: nil)
            #   Pass arguments to `delete_tag_template_field` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the tag template field to delete. Example:
            #
            #     * projects/\\{project_id}/locations/\\{location}/tagTemplates/\\{tag_template_id}/fields/\\{tag_template_field_id}
            #   @param force [::Boolean]
            #     Required. Currently, this field must always be set to `true`.
            #     This confirms the deletion of this field from any tags using this field.
            #     `force = false` will be supported in the future.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_catalog/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DataCatalog::V1beta1::DeleteTagTemplateFieldRequest.new
            #
            #   # Call the delete_tag_template_field method.
            #   result = client.delete_tag_template_field request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_tag_template_field request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::V1beta1::DeleteTagTemplateFieldRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_tag_template_field.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataCatalog::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_tag_template_field.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_tag_template_field.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_catalog_stub.call_rpc :delete_tag_template_field, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a tag on an {::Google::Cloud::DataCatalog::V1beta1::Entry Entry}.
            # Note: The project identified by the `parent` parameter for the
            # [tag](https://cloud.google.com/data-catalog/docs/reference/rest/v1beta1/projects.locations.entryGroups.entries.tags/create#path-parameters)
            # and the
            # [tag
            # template](https://cloud.google.com/data-catalog/docs/reference/rest/v1beta1/projects.locations.tagTemplates/create#path-parameters)
            # used to create the tag must be from the same organization.
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload create_tag(request, options = nil)
            #   Pass arguments to `create_tag` via a request object, either of type
            #   {::Google::Cloud::DataCatalog::V1beta1::CreateTagRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DataCatalog::V1beta1::CreateTagRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_tag(parent: nil, tag: nil)
            #   Pass arguments to `create_tag` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The name of the resource to attach this tag to. Tags can be
            #     attached to
            #      Entries. Example:
            #
            #      * projects/\\{project_id}/locations/\\{location}/entryGroups/\\{entry_group_id}/entries/\\{entry_id}
            #
            #      Note that this Tag and its child resources may not actually be stored in
            #      the location in this name.
            #   @param tag [::Google::Cloud::DataCatalog::V1beta1::Tag, ::Hash]
            #     Required. The tag to create.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::DataCatalog::V1beta1::Tag]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::DataCatalog::V1beta1::Tag]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_catalog/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DataCatalog::V1beta1::CreateTagRequest.new
            #
            #   # Call the create_tag method.
            #   result = client.create_tag request
            #
            #   # The returned object is of type Google::Cloud::DataCatalog::V1beta1::Tag.
            #   p result
            #
            def create_tag request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::V1beta1::CreateTagRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_tag.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataCatalog::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_tag.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_tag.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_catalog_stub.call_rpc :create_tag, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates an existing tag.
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload update_tag(request, options = nil)
            #   Pass arguments to `update_tag` via a request object, either of type
            #   {::Google::Cloud::DataCatalog::V1beta1::UpdateTagRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DataCatalog::V1beta1::UpdateTagRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_tag(tag: nil, update_mask: nil)
            #   Pass arguments to `update_tag` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param tag [::Google::Cloud::DataCatalog::V1beta1::Tag, ::Hash]
            #     Required. The updated tag. The "name" field must be set.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Note: Currently, this parameter can only take `"fields"` as value.
            #
            #     Names of fields whose values to overwrite on a tag. Currently, a tag has
            #     the only modifiable field with the name `fields`.
            #
            #     In general, if this parameter is absent or empty, all modifiable fields
            #     are overwritten. If such fields are non-required and omitted in the
            #     request body, their values are emptied.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::DataCatalog::V1beta1::Tag]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::DataCatalog::V1beta1::Tag]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_catalog/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DataCatalog::V1beta1::UpdateTagRequest.new
            #
            #   # Call the update_tag method.
            #   result = client.update_tag request
            #
            #   # The returned object is of type Google::Cloud::DataCatalog::V1beta1::Tag.
            #   p result
            #
            def update_tag request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::V1beta1::UpdateTagRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_tag.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataCatalog::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.tag&.name
                header_params["tag.name"] = request.tag.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_tag.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_tag.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_catalog_stub.call_rpc :update_tag, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a tag.
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload delete_tag(request, options = nil)
            #   Pass arguments to `delete_tag` via a request object, either of type
            #   {::Google::Cloud::DataCatalog::V1beta1::DeleteTagRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DataCatalog::V1beta1::DeleteTagRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_tag(name: nil)
            #   Pass arguments to `delete_tag` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the tag to delete. Example:
            #
            #     * projects/\\{project_id}/locations/\\{location}/entryGroups/\\{entry_group_id}/entries/\\{entry_id}/tags/\\{tag_id}
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_catalog/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DataCatalog::V1beta1::DeleteTagRequest.new
            #
            #   # Call the delete_tag method.
            #   result = client.delete_tag request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_tag request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::V1beta1::DeleteTagRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_tag.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataCatalog::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_tag.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_tag.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_catalog_stub.call_rpc :delete_tag, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists tags assigned to an {::Google::Cloud::DataCatalog::V1beta1::Entry Entry}.
            # The {::Google::Cloud::DataCatalog::V1beta1::Tag#column columns} in the response
            # are lowercased.
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload list_tags(request, options = nil)
            #   Pass arguments to `list_tags` via a request object, either of type
            #   {::Google::Cloud::DataCatalog::V1beta1::ListTagsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DataCatalog::V1beta1::ListTagsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_tags(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_tags` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The name of the Data Catalog resource to list the tags of. The
            #     resource could be an {::Google::Cloud::DataCatalog::V1beta1::Entry Entry} or an
            #     {::Google::Cloud::DataCatalog::V1beta1::EntryGroup EntryGroup}.
            #
            #     Examples:
            #
            #     * projects/\\{project_id}/locations/\\{location}/entryGroups/\\{entry_group_id}
            #     * projects/\\{project_id}/locations/\\{location}/entryGroups/\\{entry_group_id}/entries/\\{entry_id}
            #   @param page_size [::Integer]
            #     The maximum number of tags to return. Default is 10. Max limit is 1000.
            #   @param page_token [::String]
            #     Token that specifies which page is requested. If empty, the first page is
            #     returned.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::DataCatalog::V1beta1::Tag>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::DataCatalog::V1beta1::Tag>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_catalog/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DataCatalog::V1beta1::ListTagsRequest.new
            #
            #   # Call the list_tags method.
            #   result = client.list_tags request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::DataCatalog::V1beta1::Tag.
            #     p item
            #   end
            #
            def list_tags request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DataCatalog::V1beta1::ListTagsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_tags.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataCatalog::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_tags.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_tags.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_catalog_stub.call_rpc :list_tags, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @data_catalog_stub, :list_tags, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Sets the access control policy for a resource. Replaces any existing
            # policy.
            # Supported resources are:
            #   - Tag templates.
            #   - Entries.
            #   - Entry groups.
            # Note, this method cannot be used to manage policies for BigQuery, Pub/Sub
            # and any external Google Cloud Platform resources synced to Data Catalog.
            #
            # Callers must have following Google IAM permission
            #   - `datacatalog.tagTemplates.setIamPolicy` to set policies on tag
            #     templates.
            #   - `datacatalog.entries.setIamPolicy` to set policies on entries.
            #   - `datacatalog.entryGroups.setIamPolicy` to set policies on entry groups.
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload set_iam_policy(request, options = nil)
            #   Pass arguments to `set_iam_policy` via a request object, either of type
            #   {::Google::Iam::V1::SetIamPolicyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Iam::V1::SetIamPolicyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload set_iam_policy(resource: nil, policy: nil, update_mask: nil)
            #   Pass arguments to `set_iam_policy` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param resource [::String]
            #     REQUIRED: The resource for which the policy is being specified.
            #     See the operation documentation for the appropriate value for this field.
            #   @param policy [::Google::Iam::V1::Policy, ::Hash]
            #     REQUIRED: The complete policy to be applied to the `resource`. The size of
            #     the policy is limited to a few 10s of KB. An empty policy is a
            #     valid policy but certain Cloud Platform services (such as Projects)
            #     might reject them.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     OPTIONAL: A FieldMask specifying which fields of the policy to modify. Only
            #     the fields in the mask will be modified. If no mask is provided, the
            #     following default mask is used:
            #
            #     `paths: "bindings, etag"`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Iam::V1::Policy]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Iam::V1::Policy]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_catalog/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Iam::V1::SetIamPolicyRequest.new
            #
            #   # Call the set_iam_policy method.
            #   result = client.set_iam_policy request
            #
            #   # The returned object is of type Google::Iam::V1::Policy.
            #   p result
            #
            def set_iam_policy request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::SetIamPolicyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.set_iam_policy.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataCatalog::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.resource
                header_params["resource"] = request.resource
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.set_iam_policy.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.set_iam_policy.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_catalog_stub.call_rpc :set_iam_policy, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets the access control policy for a resource. A `NOT_FOUND` error
            # is returned if the resource does not exist. An empty policy is returned
            # if the resource exists but does not have a policy set on it.
            #
            # Supported resources are:
            #   - Tag templates.
            #   - Entries.
            #   - Entry groups.
            # Note, this method cannot be used to manage policies for BigQuery, Pub/Sub
            # and any external Google Cloud Platform resources synced to Data Catalog.
            #
            # Callers must have following Google IAM permission
            #   - `datacatalog.tagTemplates.getIamPolicy` to get policies on tag
            #     templates.
            #   - `datacatalog.entries.getIamPolicy` to get policies on entries.
            #   - `datacatalog.entryGroups.getIamPolicy` to get policies on entry groups.
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload get_iam_policy(request, options = nil)
            #   Pass arguments to `get_iam_policy` via a request object, either of type
            #   {::Google::Iam::V1::GetIamPolicyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Iam::V1::GetIamPolicyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_iam_policy(resource: nil, options: nil)
            #   Pass arguments to `get_iam_policy` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param resource [::String]
            #     REQUIRED: The resource for which the policy is being requested.
            #     See the operation documentation for the appropriate value for this field.
            #   @param options [::Google::Iam::V1::GetPolicyOptions, ::Hash]
            #     OPTIONAL: A `GetPolicyOptions` object for specifying options to
            #     `GetIamPolicy`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Iam::V1::Policy]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Iam::V1::Policy]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_catalog/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Iam::V1::GetIamPolicyRequest.new
            #
            #   # Call the get_iam_policy method.
            #   result = client.get_iam_policy request
            #
            #   # The returned object is of type Google::Iam::V1::Policy.
            #   p result
            #
            def get_iam_policy request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::GetIamPolicyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_iam_policy.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataCatalog::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.resource
                header_params["resource"] = request.resource
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_iam_policy.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_iam_policy.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_catalog_stub.call_rpc :get_iam_policy, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns the caller's permissions on a resource.
            # If the resource does not exist, an empty set of permissions is returned
            # (We don't return a `NOT_FOUND` error).
            #
            # Supported resources are:
            #   - Tag templates.
            #   - Entries.
            #   - Entry groups.
            # Note, this method cannot be used to manage policies for BigQuery, Pub/Sub
            # and any external Google Cloud Platform resources synced to Data Catalog.
            #
            # A caller is not required to have Google IAM permission to make this
            # request.
            #
            # @deprecated This method is deprecated and may be removed in the next major version update.
            #
            # @overload test_iam_permissions(request, options = nil)
            #   Pass arguments to `test_iam_permissions` via a request object, either of type
            #   {::Google::Iam::V1::TestIamPermissionsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Iam::V1::TestIamPermissionsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload test_iam_permissions(resource: nil, permissions: nil)
            #   Pass arguments to `test_iam_permissions` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param resource [::String]
            #     REQUIRED: The resource for which the policy detail is being requested.
            #     See the operation documentation for the appropriate value for this field.
            #   @param permissions [::Array<::String>]
            #     The set of permissions to check for the `resource`. Permissions with
            #     wildcards (such as '*' or 'storage.*') are not allowed. For more
            #     information see
            #     [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Iam::V1::TestIamPermissionsResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Iam::V1::TestIamPermissionsResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/data_catalog/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Iam::V1::TestIamPermissionsRequest.new
            #
            #   # Call the test_iam_permissions method.
            #   result = client.test_iam_permissions request
            #
            #   # The returned object is of type Google::Iam::V1::TestIamPermissionsResponse.
            #   p result
            #
            def test_iam_permissions request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::TestIamPermissionsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.test_iam_permissions.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DataCatalog::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.resource
                header_params["resource"] = request.resource
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.test_iam_permissions.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.test_iam_permissions.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_catalog_stub.call_rpc :test_iam_permissions, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the DataCatalog API.
            #
            # This class represents the configuration for DataCatalog,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # search_catalog to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.search_catalog.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.search_catalog.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::DataCatalog::V1beta1::DataCatalog::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "datacatalog.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the DataCatalog API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `search_catalog`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :search_catalog
                ##
                # RPC-specific configuration for `create_entry_group`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_entry_group
                ##
                # RPC-specific configuration for `update_entry_group`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_entry_group
                ##
                # RPC-specific configuration for `get_entry_group`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_entry_group
                ##
                # RPC-specific configuration for `delete_entry_group`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_entry_group
                ##
                # RPC-specific configuration for `list_entry_groups`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_entry_groups
                ##
                # RPC-specific configuration for `create_entry`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_entry
                ##
                # RPC-specific configuration for `update_entry`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_entry
                ##
                # RPC-specific configuration for `delete_entry`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_entry
                ##
                # RPC-specific configuration for `get_entry`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_entry
                ##
                # RPC-specific configuration for `lookup_entry`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :lookup_entry
                ##
                # RPC-specific configuration for `list_entries`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_entries
                ##
                # RPC-specific configuration for `create_tag_template`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_tag_template
                ##
                # RPC-specific configuration for `get_tag_template`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_tag_template
                ##
                # RPC-specific configuration for `update_tag_template`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_tag_template
                ##
                # RPC-specific configuration for `delete_tag_template`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_tag_template
                ##
                # RPC-specific configuration for `create_tag_template_field`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_tag_template_field
                ##
                # RPC-specific configuration for `update_tag_template_field`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_tag_template_field
                ##
                # RPC-specific configuration for `rename_tag_template_field`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :rename_tag_template_field
                ##
                # RPC-specific configuration for `rename_tag_template_field_enum_value`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :rename_tag_template_field_enum_value
                ##
                # RPC-specific configuration for `delete_tag_template_field`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_tag_template_field
                ##
                # RPC-specific configuration for `create_tag`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_tag
                ##
                # RPC-specific configuration for `update_tag`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_tag
                ##
                # RPC-specific configuration for `delete_tag`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_tag
                ##
                # RPC-specific configuration for `list_tags`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_tags
                ##
                # RPC-specific configuration for `set_iam_policy`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :set_iam_policy
                ##
                # RPC-specific configuration for `get_iam_policy`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_iam_policy
                ##
                # RPC-specific configuration for `test_iam_permissions`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :test_iam_permissions

                # @private
                def initialize parent_rpcs = nil
                  search_catalog_config = parent_rpcs.search_catalog if parent_rpcs.respond_to? :search_catalog
                  @search_catalog = ::Gapic::Config::Method.new search_catalog_config
                  create_entry_group_config = parent_rpcs.create_entry_group if parent_rpcs.respond_to? :create_entry_group
                  @create_entry_group = ::Gapic::Config::Method.new create_entry_group_config
                  update_entry_group_config = parent_rpcs.update_entry_group if parent_rpcs.respond_to? :update_entry_group
                  @update_entry_group = ::Gapic::Config::Method.new update_entry_group_config
                  get_entry_group_config = parent_rpcs.get_entry_group if parent_rpcs.respond_to? :get_entry_group
                  @get_entry_group = ::Gapic::Config::Method.new get_entry_group_config
                  delete_entry_group_config = parent_rpcs.delete_entry_group if parent_rpcs.respond_to? :delete_entry_group
                  @delete_entry_group = ::Gapic::Config::Method.new delete_entry_group_config
                  list_entry_groups_config = parent_rpcs.list_entry_groups if parent_rpcs.respond_to? :list_entry_groups
                  @list_entry_groups = ::Gapic::Config::Method.new list_entry_groups_config
                  create_entry_config = parent_rpcs.create_entry if parent_rpcs.respond_to? :create_entry
                  @create_entry = ::Gapic::Config::Method.new create_entry_config
                  update_entry_config = parent_rpcs.update_entry if parent_rpcs.respond_to? :update_entry
                  @update_entry = ::Gapic::Config::Method.new update_entry_config
                  delete_entry_config = parent_rpcs.delete_entry if parent_rpcs.respond_to? :delete_entry
                  @delete_entry = ::Gapic::Config::Method.new delete_entry_config
                  get_entry_config = parent_rpcs.get_entry if parent_rpcs.respond_to? :get_entry
                  @get_entry = ::Gapic::Config::Method.new get_entry_config
                  lookup_entry_config = parent_rpcs.lookup_entry if parent_rpcs.respond_to? :lookup_entry
                  @lookup_entry = ::Gapic::Config::Method.new lookup_entry_config
                  list_entries_config = parent_rpcs.list_entries if parent_rpcs.respond_to? :list_entries
                  @list_entries = ::Gapic::Config::Method.new list_entries_config
                  create_tag_template_config = parent_rpcs.create_tag_template if parent_rpcs.respond_to? :create_tag_template
                  @create_tag_template = ::Gapic::Config::Method.new create_tag_template_config
                  get_tag_template_config = parent_rpcs.get_tag_template if parent_rpcs.respond_to? :get_tag_template
                  @get_tag_template = ::Gapic::Config::Method.new get_tag_template_config
                  update_tag_template_config = parent_rpcs.update_tag_template if parent_rpcs.respond_to? :update_tag_template
                  @update_tag_template = ::Gapic::Config::Method.new update_tag_template_config
                  delete_tag_template_config = parent_rpcs.delete_tag_template if parent_rpcs.respond_to? :delete_tag_template
                  @delete_tag_template = ::Gapic::Config::Method.new delete_tag_template_config
                  create_tag_template_field_config = parent_rpcs.create_tag_template_field if parent_rpcs.respond_to? :create_tag_template_field
                  @create_tag_template_field = ::Gapic::Config::Method.new create_tag_template_field_config
                  update_tag_template_field_config = parent_rpcs.update_tag_template_field if parent_rpcs.respond_to? :update_tag_template_field
                  @update_tag_template_field = ::Gapic::Config::Method.new update_tag_template_field_config
                  rename_tag_template_field_config = parent_rpcs.rename_tag_template_field if parent_rpcs.respond_to? :rename_tag_template_field
                  @rename_tag_template_field = ::Gapic::Config::Method.new rename_tag_template_field_config
                  rename_tag_template_field_enum_value_config = parent_rpcs.rename_tag_template_field_enum_value if parent_rpcs.respond_to? :rename_tag_template_field_enum_value
                  @rename_tag_template_field_enum_value = ::Gapic::Config::Method.new rename_tag_template_field_enum_value_config
                  delete_tag_template_field_config = parent_rpcs.delete_tag_template_field if parent_rpcs.respond_to? :delete_tag_template_field
                  @delete_tag_template_field = ::Gapic::Config::Method.new delete_tag_template_field_config
                  create_tag_config = parent_rpcs.create_tag if parent_rpcs.respond_to? :create_tag
                  @create_tag = ::Gapic::Config::Method.new create_tag_config
                  update_tag_config = parent_rpcs.update_tag if parent_rpcs.respond_to? :update_tag
                  @update_tag = ::Gapic::Config::Method.new update_tag_config
                  delete_tag_config = parent_rpcs.delete_tag if parent_rpcs.respond_to? :delete_tag
                  @delete_tag = ::Gapic::Config::Method.new delete_tag_config
                  list_tags_config = parent_rpcs.list_tags if parent_rpcs.respond_to? :list_tags
                  @list_tags = ::Gapic::Config::Method.new list_tags_config
                  set_iam_policy_config = parent_rpcs.set_iam_policy if parent_rpcs.respond_to? :set_iam_policy
                  @set_iam_policy = ::Gapic::Config::Method.new set_iam_policy_config
                  get_iam_policy_config = parent_rpcs.get_iam_policy if parent_rpcs.respond_to? :get_iam_policy
                  @get_iam_policy = ::Gapic::Config::Method.new get_iam_policy_config
                  test_iam_permissions_config = parent_rpcs.test_iam_permissions if parent_rpcs.respond_to? :test_iam_permissions
                  @test_iam_permissions = ::Gapic::Config::Method.new test_iam_permissions_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
