# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DataCatalog
      module V1
        # Detailed statistics on the entry's usage.
        #
        # Usage statistics have the following limitations:
        #
        # - Only BigQuery tables have them.
        # - They only include BigQuery query jobs.
        # - They might be underestimated because wildcard table references
        #   are not yet counted. For more information, see
        #   [Querying multiple tables using a wildcard table]
        #   (https://cloud.google.com/bigquery/docs/querying-wildcard-tables)
        # @!attribute [rw] total_completions
        #   @return [::Float]
        #     The number of successful uses of the underlying entry.
        # @!attribute [rw] total_failures
        #   @return [::Float]
        #     The number of failed attempts to use the underlying entry.
        # @!attribute [rw] total_cancellations
        #   @return [::Float]
        #     The number of cancelled attempts to use the underlying entry.
        # @!attribute [rw] total_execution_time_for_completions_millis
        #   @return [::Float]
        #     Total time spent only on successful uses, in milliseconds.
        class UsageStats
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Common statistics on the entry's usage.
        #
        # They can be set on any system.
        # @!attribute [rw] view_count
        #   @return [::Integer]
        #     View count in source system.
        class CommonUsageStats
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The set of all usage signals that Data Catalog stores.
        #
        # Note: Usually, these signals are updated daily. In rare cases, an update may
        # fail but will be performed again on the next day.
        # @!attribute [rw] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The end timestamp of the duration of usage statistics.
        # @!attribute [r] usage_within_time_range
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::DataCatalog::V1::UsageStats}]
        #     Output only. BigQuery usage statistics over each of the predefined time
        #     ranges.
        #
        #     Supported time ranges are `{"24H", "7D", "30D"}`.
        # @!attribute [rw] common_usage_within_time_range
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::DataCatalog::V1::CommonUsageStats}]
        #     Common usage statistics over each of the predefined time ranges.
        #
        #     Supported time ranges are `{"24H", "7D", "30D", "Lifetime"}`.
        # @!attribute [rw] favorite_count
        #   @return [::Integer]
        #     Favorite count in the source system.
        class UsageSignal
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::DataCatalog::V1::UsageStats]
          class UsageWithinTimeRangeEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::DataCatalog::V1::CommonUsageStats]
          class CommonUsageWithinTimeRangeEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
