# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DataCatalog
      module V1
        # Tags contain custom metadata and are attached to Data Catalog resources. Tags
        # conform with the specification of their tag template.
        #
        # See [Data Catalog
        # IAM](https://cloud.google.com/data-catalog/docs/concepts/iam) for information
        # on the permissions needed to create or view tags.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The resource name of the tag in URL format where tag ID is a
        #     system-generated identifier.
        #
        #     Note: The tag itself might not be stored in the location specified in its
        #     name.
        # @!attribute [rw] template
        #   @return [::String]
        #     Required. The resource name of the tag template this tag uses. Example:
        #
        #     `projects/{PROJECT_ID}/locations/{LOCATION}/tagTemplates/{TAG_TEMPLATE_ID}`
        #
        #     This field cannot be modified after creation.
        # @!attribute [r] template_display_name
        #   @return [::String]
        #     Output only. The display name of the tag template.
        # @!attribute [rw] column
        #   @return [::String]
        #     Resources like entry can have schemas associated with them. This scope
        #     allows you to attach tags to an individual column based on that schema.
        #
        #     To attach a tag to a nested column, separate column names with a dot
        #     (`.`). Example: `column.nested_column`.
        # @!attribute [rw] fields
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::DataCatalog::V1::TagField}]
        #     Required. Maps the ID of a tag field to its value and additional
        #     information about that field.
        #
        #     Tag template defines valid field IDs. A tag
        #     must have at least 1 field and at most 500 fields.
        # @!attribute [r] dataplex_transfer_status
        #   @return [::Google::Cloud::DataCatalog::V1::TagTemplate::DataplexTransferStatus]
        #     Output only. Denotes the transfer status of the Tag Template.
        class Tag
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::DataCatalog::V1::TagField]
          class FieldsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Contains the value and additional information on a field within
        # a {::Google::Cloud::DataCatalog::V1::Tag Tag}.
        # @!attribute [r] display_name
        #   @return [::String]
        #     Output only. The display name of this field.
        # @!attribute [rw] double_value
        #   @return [::Float]
        #     The value of a tag field with a double type.
        #
        #     Note: The following fields are mutually exclusive: `double_value`, `string_value`, `bool_value`, `timestamp_value`, `enum_value`, `richtext_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] string_value
        #   @return [::String]
        #     The value of a tag field with a string type.
        #
        #     The maximum length is 2000 UTF-8 characters.
        #
        #     Note: The following fields are mutually exclusive: `string_value`, `double_value`, `bool_value`, `timestamp_value`, `enum_value`, `richtext_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] bool_value
        #   @return [::Boolean]
        #     The value of a tag field with a boolean type.
        #
        #     Note: The following fields are mutually exclusive: `bool_value`, `double_value`, `string_value`, `timestamp_value`, `enum_value`, `richtext_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] timestamp_value
        #   @return [::Google::Protobuf::Timestamp]
        #     The value of a tag field with a timestamp type.
        #
        #     Note: The following fields are mutually exclusive: `timestamp_value`, `double_value`, `string_value`, `bool_value`, `enum_value`, `richtext_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] enum_value
        #   @return [::Google::Cloud::DataCatalog::V1::TagField::EnumValue]
        #     The value of a tag field with an enum type.
        #
        #     This value must be one of the allowed values listed in this enum.
        #
        #     Note: The following fields are mutually exclusive: `enum_value`, `double_value`, `string_value`, `bool_value`, `timestamp_value`, `richtext_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] richtext_value
        #   @return [::String]
        #     The value of a tag field with a rich text type.
        #
        #     The maximum length is 10 MiB as this value holds HTML descriptions
        #     including encoded images. The maximum length of the text without images
        #     is 100 KiB.
        #
        #     Note: The following fields are mutually exclusive: `richtext_value`, `double_value`, `string_value`, `bool_value`, `timestamp_value`, `enum_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] order
        #   @return [::Integer]
        #     Output only. The order of this field with respect to other fields in this
        #     tag. Can be set by
        #     {::Google::Cloud::DataCatalog::V1::TagTemplateField#order Tag}.
        #
        #     For example, a higher value can indicate a more important field.
        #     The value can be negative. Multiple fields can have the same order, and
        #     field orders within a tag don't have to be sequential.
        class TagField
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # An enum value.
          # @!attribute [rw] display_name
          #   @return [::String]
          #     The display name of the enum value.
          class EnumValue
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # A tag template defines a tag that can have one or more typed fields.
        #
        # The template is used to create tags that are attached to Google Cloud
        #  resources. [Tag template roles]
        # (https://cloud.google.com/iam/docs/understanding-roles#data-catalog-roles)
        # provide permissions to create, edit, and use the template. For example,
        # see the [TagTemplate User]
        # (https://cloud.google.com/data-catalog/docs/how-to/template-user) role
        # that includes a permission to use the tag template to tag resources.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The resource name of the tag template in URL format.
        #
        #     Note: The tag template itself and its child resources might not be
        #     stored in the location specified in its name.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Display name for this template. Defaults to an empty string.
        #
        #     The name must contain only Unicode letters, numbers (0-9), underscores (_),
        #     dashes (-), spaces ( ), and can't start or end with spaces.
        #     The maximum length is 200 characters.
        # @!attribute [rw] is_publicly_readable
        #   @return [::Boolean]
        #     Indicates whether tags created with this template are public. Public tags
        #     do not require tag template access to appear in
        #     {::Google::Cloud::DataCatalog::V1::DataCatalog::Client#list_tags ListTags} API response.
        #
        #     Additionally, you can search for a public tag by value with a
        #     simple search query in addition to using a ``tag:`` predicate.
        # @!attribute [rw] fields
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::DataCatalog::V1::TagTemplateField}]
        #     Required. Map of tag template field IDs to the settings for the field.
        #     This map is an exhaustive list of the allowed fields. The map must contain
        #     at least one field and at most 500 fields.
        #
        #     The keys to this map are tag template field IDs. The IDs have the
        #     following limitations:
        #
        #     * Can contain uppercase and lowercase letters, numbers (0-9) and
        #       underscores (_).
        #     * Must be at least 1 character and at most 64 characters long.
        #     * Must start with a letter or underscore.
        # @!attribute [rw] dataplex_transfer_status
        #   @return [::Google::Cloud::DataCatalog::V1::TagTemplate::DataplexTransferStatus]
        #     Optional. Transfer status of the TagTemplate
        class TagTemplate
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::DataCatalog::V1::TagTemplateField]
          class FieldsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # This enum describes TagTemplate transfer status to Dataplex service.
          module DataplexTransferStatus
            # Default value. TagTemplate and its tags are only visible and editable in
            # DataCatalog.
            DATAPLEX_TRANSFER_STATUS_UNSPECIFIED = 0

            # TagTemplate and its tags are auto-copied to Dataplex service.
            # Visible in both services. Editable in DataCatalog, read-only in Dataplex.
            # Deprecated: Individual TagTemplate migration is deprecated in favor of
            # organization or project wide TagTemplate migration opt-in.
            MIGRATED = 1

            # TagTemplate and its tags are auto-copied to Dataplex service.
            # Visible in both services. Editable in Dataplex, read-only in DataCatalog.
            TRANSFERRED = 2
          end
        end

        # The template for an individual field within a tag template.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The resource name of the tag template field in URL format.
        #     Example:
        #
        #     `projects/{PROJECT_ID}/locations/{LOCATION}/tagTemplates/{TAG_TEMPLATE}/fields/{FIELD}`
        #
        #     Note: The tag template field itself might not be stored in the location
        #     specified in its name.
        #
        #     The name must contain only letters (a-z, A-Z), numbers (0-9),
        #     or underscores (_), and must start with a letter or underscore.
        #     The maximum length is 64 characters.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     The display name for this field. Defaults to an empty string.
        #
        #     The name must contain only Unicode letters, numbers (0-9), underscores (_),
        #     dashes (-), spaces ( ), and can't start or end with spaces.
        #     The maximum length is 200 characters.
        # @!attribute [rw] type
        #   @return [::Google::Cloud::DataCatalog::V1::FieldType]
        #     Required. The type of value this tag field can contain.
        # @!attribute [rw] is_required
        #   @return [::Boolean]
        #     If true, this field is required. Defaults to false.
        # @!attribute [rw] description
        #   @return [::String]
        #     The description for this field. Defaults to an empty string.
        # @!attribute [rw] order
        #   @return [::Integer]
        #     The order of this field with respect to other fields in this tag
        #     template.
        #
        #     For example, a higher value can indicate a more important field.
        #     The value can be negative. Multiple fields can have the same order and
        #     field orders within a tag don't have to be sequential.
        class TagTemplateField
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] primitive_type
        #   @return [::Google::Cloud::DataCatalog::V1::FieldType::PrimitiveType]
        #     Primitive types, such as string, boolean, etc.
        #
        #     Note: The following fields are mutually exclusive: `primitive_type`, `enum_type`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] enum_type
        #   @return [::Google::Cloud::DataCatalog::V1::FieldType::EnumType]
        #     An enum type.
        #
        #     Note: The following fields are mutually exclusive: `enum_type`, `primitive_type`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class FieldType
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] allowed_values
          #   @return [::Array<::Google::Cloud::DataCatalog::V1::FieldType::EnumType::EnumValue>]
          #     The set of allowed values for this enum.
          #
          #     This set must not be empty and can include up to 100 allowed values.
          #     The display names of the values in this set must not be empty and must
          #     be case-insensitively unique within this set.
          #
          #     The order of items in this set is preserved. This field can be used to
          #     create, remove, and reorder enum values. To rename enum values, use the
          #     `RenameTagTemplateFieldEnumValue` method.
          class EnumType
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # @!attribute [rw] display_name
            #   @return [::String]
            #     Required. The display name of the enum value. Must not be an empty
            #     string.
            #
            #     The name must contain only Unicode letters, numbers (0-9), underscores
            #     (_), dashes (-), spaces ( ), and can't start or end with spaces. The
            #     maximum length is 200 characters.
            class EnumValue
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          module PrimitiveType
            # The default invalid value for a type.
            PRIMITIVE_TYPE_UNSPECIFIED = 0

            # A double precision number.
            DOUBLE = 1

            # An UTF-8 string.
            STRING = 2

            # A boolean value.
            BOOL = 3

            # A timestamp.
            TIMESTAMP = 4

            # A Richtext description.
            RICHTEXT = 5
          end
        end
      end
    end
  end
end
