# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DataCatalog
      module V1
        # Common Dataplex fields.
        # @!attribute [rw] asset
        #   @return [::String]
        #     Fully qualified resource name of an asset in Dataplex, to which the
        #     underlying data source (Cloud Storage bucket or BigQuery dataset) of the
        #     entity is attached.
        # @!attribute [rw] data_format
        #   @return [::Google::Cloud::DataCatalog::V1::PhysicalSchema]
        #     Format of the data.
        # @!attribute [rw] compression_format
        #   @return [::String]
        #     Compression format of the data, e.g., zip, gzip etc.
        # @!attribute [rw] project_id
        #   @return [::String]
        #     Project ID of the underlying Cloud Storage or BigQuery data. Note that
        #     this may not be the same project as the correspondingly Dataplex lake /
        #     zone / asset.
        class DataplexSpec
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Entry specyfication for a Dataplex fileset.
        # @!attribute [rw] dataplex_spec
        #   @return [::Google::Cloud::DataCatalog::V1::DataplexSpec]
        #     Common Dataplex fields.
        class DataplexFilesetSpec
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Entry specification for a Dataplex table.
        # @!attribute [rw] external_tables
        #   @return [::Array<::Google::Cloud::DataCatalog::V1::DataplexExternalTable>]
        #     List of external tables registered by Dataplex in other systems based on
        #     the same underlying data.
        #
        #     External tables allow to query this data in those systems.
        # @!attribute [rw] dataplex_spec
        #   @return [::Google::Cloud::DataCatalog::V1::DataplexSpec]
        #     Common Dataplex fields.
        # @!attribute [rw] user_managed
        #   @return [::Boolean]
        #     Indicates if the table schema is managed by the user or not.
        class DataplexTableSpec
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # External table registered by Dataplex.
        # Dataplex publishes data discovered from an asset into multiple other systems
        # (BigQuery, DPMS) in form of tables. We call them "external tables". External
        # tables are also synced into the Data Catalog.
        # This message contains pointers to
        # those external tables (fully qualified name, resource name et cetera) within
        # the Data Catalog.
        # @!attribute [rw] system
        #   @return [::Google::Cloud::DataCatalog::V1::IntegratedSystem]
        #     Service in which the external table is registered.
        # @!attribute [rw] fully_qualified_name
        #   @return [::String]
        #     Fully qualified name (FQN) of the external table.
        # @!attribute [rw] google_cloud_resource
        #   @return [::String]
        #     Google Cloud resource name of the external table.
        # @!attribute [rw] data_catalog_entry
        #   @return [::String]
        #     Name of the Data Catalog entry representing the external table.
        class DataplexExternalTable
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
