# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DataCatalog
      module V1
        # Request message for
        # {::Google::Cloud::DataCatalog::V1::DataCatalog::Client#search_catalog SearchCatalog}.
        # @!attribute [rw] scope
        #   @return [::Google::Cloud::DataCatalog::V1::SearchCatalogRequest::Scope]
        #     Required. The scope of this search request.
        #
        #     The `scope` is invalid if `include_org_ids`, `include_project_ids` are
        #     empty AND `include_gcp_public_datasets` is set to `false`. In this case,
        #     the request returns an error.
        # @!attribute [rw] query
        #   @return [::String]
        #     Optional. The query string with a minimum of 3 characters and specific
        #     syntax. For more information, see [Data Catalog search
        #     syntax](https://cloud.google.com/data-catalog/docs/how-to/search-reference).
        #
        #     An empty query string returns all data assets (in the specified scope)
        #     that you have access to.
        #
        #     A query string can be a simple `xyz` or qualified by predicates:
        #
        #     * `name:x`
        #     * `column:y`
        #     * `description:z`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Upper bound on the number of results you can get in a single response.
        #
        #     Can't be negative or 0, defaults to 10 in this case.
        #     The maximum number is 1000. If exceeded, throws an "invalid argument"
        #     exception.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. Pagination token that, if specified, returns the next page of
        #     search results. If empty, returns the first page.
        #
        #     This token is returned in the
        #     {::Google::Cloud::DataCatalog::V1::SearchCatalogResponse#next_page_token SearchCatalogResponse.next_page_token}
        #     field of the response to a previous
        #     {::Google::Cloud::DataCatalog::V1::DataCatalog::Client#search_catalog SearchCatalogRequest}
        #     call.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Specifies the order of results.
        #
        #     Currently supported case-sensitive values are:
        #
        #     * `relevance` that can only be descending
        #     * `last_modified_timestamp [asc|desc]` with descending (`desc`) as default
        #     * `default` that can only be descending
        #
        #     Search queries don't guarantee full recall. Results that match your query
        #     might not be returned, even in subsequent result pages. Additionally,
        #     returned (and not returned) results can vary if you repeat search queries.
        #     If you are experiencing recall issues and you don't have to fetch the
        #     results in any specific order, consider setting this parameter to
        #     `default`.
        #
        #     If this parameter is omitted, it defaults to the descending `relevance`.
        # @!attribute [rw] admin_search
        #   @return [::Boolean]
        #     Optional. If set, use searchAll permission granted on organizations from
        #     `include_org_ids` and projects from `include_project_ids` instead of the
        #     fine grained per resource permissions when filtering the search results.
        #     The only allowed `order_by` criteria for admin_search mode is `default`.
        #     Using this flags guarantees a full recall of the search results.
        class SearchCatalogRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The criteria that select the subspace used for query matching.
          # @!attribute [rw] include_org_ids
          #   @return [::Array<::String>]
          #     The list of organization IDs to search within.
          #
          #     To find your organization ID, follow the steps from
          #     [Creating and managing organizations]
          #     (/resource-manager/docs/creating-managing-organization).
          # @!attribute [rw] include_project_ids
          #   @return [::Array<::String>]
          #     The list of project IDs to search within.
          #
          #     For more information on the distinction between project names, IDs, and
          #     numbers, see [Projects](/docs/overview/#projects).
          # @!attribute [rw] include_gcp_public_datasets
          #   @return [::Boolean]
          #     If `true`, include Google Cloud public datasets in
          #     search results. By default, they are excluded.
          #
          #     See [Google Cloud Public Datasets](/public-datasets) for more
          #     information.
          # @!attribute [rw] restricted_locations
          #   @return [::Array<::String>]
          #     Optional. The list of locations to search within. If empty, all locations
          #     are searched.
          #
          #     Returns an error if any location in the list isn't one of the [Supported
          #     regions](https://cloud.google.com/data-catalog/docs/concepts/regions#supported_regions).
          #
          #     If a location is unreachable, its name is returned in the
          #     `SearchCatalogResponse.unreachable` field. To get additional information
          #     on the error, repeat the search request and set the location name as the
          #     value of this parameter.
          # @!attribute [rw] starred_only
          #   @return [::Boolean]
          #     Optional. If `true`, search only among starred entries.
          #
          #     By default, all results are returned, starred or not.
          # @!attribute [rw] include_public_tag_templates
          #   @deprecated This field is deprecated and may be removed in the next major version update.
          #   @return [::Boolean]
          #     Optional. This field is deprecated. The search mechanism for public and
          #     private tag templates is the same.
          class Scope
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Response message for
        # {::Google::Cloud::DataCatalog::V1::DataCatalog::Client#search_catalog SearchCatalog}.
        # @!attribute [rw] results
        #   @return [::Array<::Google::Cloud::DataCatalog::V1::SearchCatalogResult>]
        #     Search results.
        # @!attribute [rw] total_size
        #   @return [::Integer]
        #     The approximate total number of entries matched by the query.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Pagination token that can be used in subsequent calls to retrieve the next
        #     page of results.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Unreachable locations. Search results don't include data from those
        #     locations.
        #
        #     To get additional information on an error, repeat the search request and
        #     restrict it to specific locations by setting the
        #     `SearchCatalogRequest.scope.restricted_locations` parameter.
        class SearchCatalogResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DataCatalog::V1::DataCatalog::Client#create_entry_group CreateEntryGroup}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The names of the project and location that the new entry group
        #     belongs to.
        #
        #     Note: The entry group itself and its child resources might not be
        #     stored in the location specified in its name.
        # @!attribute [rw] entry_group_id
        #   @return [::String]
        #     Required. The ID of the entry group to create.
        #
        #     The ID must contain only letters (a-z, A-Z), numbers (0-9),
        #     underscores (_), and must start with a letter or underscore.
        #     The maximum size is 64 bytes when encoded in UTF-8.
        # @!attribute [rw] entry_group
        #   @return [::Google::Cloud::DataCatalog::V1::EntryGroup]
        #     The entry group to create. Defaults to empty.
        class CreateEntryGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DataCatalog::V1::DataCatalog::Client#update_entry_group UpdateEntryGroup}.
        # @!attribute [rw] entry_group
        #   @return [::Google::Cloud::DataCatalog::V1::EntryGroup]
        #     Required. Updates for the entry group. The `name` field must be set.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Names of fields whose values to overwrite on an entry group.
        #
        #     If this parameter is absent or empty, all modifiable fields
        #     are overwritten. If such fields are non-required and omitted in the
        #     request body, their values are emptied.
        class UpdateEntryGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DataCatalog::V1::DataCatalog::Client#get_entry_group GetEntryGroup}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the entry group to get.
        # @!attribute [rw] read_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The fields to return. If empty or omitted, all fields are returned.
        class GetEntryGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DataCatalog::V1::DataCatalog::Client#delete_entry_group DeleteEntryGroup}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the entry group to delete.
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     Optional. If true, deletes all entries in the entry group.
        class DeleteEntryGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DataCatalog::V1::DataCatalog::Client#list_entry_groups ListEntryGroups}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the location that contains the entry groups to list.
        #
        #     Can be provided as a URL.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of items to return.
        #
        #     Default is 10. Maximum limit is 1000.
        #     Throws an invalid argument if `page_size` is greater than 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. Pagination token that specifies the next page to return.
        #     If empty, returns the first page.
        class ListEntryGroupsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::DataCatalog::V1::DataCatalog::Client#list_entry_groups ListEntryGroups}.
        # @!attribute [rw] entry_groups
        #   @return [::Array<::Google::Cloud::DataCatalog::V1::EntryGroup>]
        #     Entry group details.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Pagination token to specify in the next call to retrieve the next page of
        #     results. Empty if there are no more items.
        class ListEntryGroupsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DataCatalog::V1::DataCatalog::Client#create_entry CreateEntry}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the entry group this entry belongs to.
        #
        #     Note: The entry itself and its child resources might not be stored in
        #     the location specified in its name.
        # @!attribute [rw] entry_id
        #   @return [::String]
        #     Required. The ID of the entry to create.
        #
        #     The ID must contain only letters (a-z, A-Z), numbers (0-9),
        #     and underscores (_).
        #     The maximum size is 64 bytes when encoded in UTF-8.
        # @!attribute [rw] entry
        #   @return [::Google::Cloud::DataCatalog::V1::Entry]
        #     Required. The entry to create.
        class CreateEntryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DataCatalog::V1::DataCatalog::Client#update_entry UpdateEntry}.
        # @!attribute [rw] entry
        #   @return [::Google::Cloud::DataCatalog::V1::Entry]
        #     Required. Updates for the entry. The `name` field must be set.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Names of fields whose values to overwrite on an entry.
        #
        #     If this parameter is absent or empty, all modifiable fields
        #     are overwritten. If such fields are non-required and omitted in the
        #     request body, their values are emptied.
        #
        #     You can modify only the fields listed below.
        #
        #     For entries with type `DATA_STREAM`:
        #
        #     * `schema`
        #
        #     For entries with type `FILESET`:
        #
        #     * `schema`
        #     * `display_name`
        #     * `description`
        #     * `gcs_fileset_spec`
        #     * `gcs_fileset_spec.file_patterns`
        #
        #     For entries with `user_specified_type`:
        #
        #     * `schema`
        #     * `display_name`
        #     * `description`
        #     * `user_specified_type`
        #     * `user_specified_system`
        #     * `linked_resource`
        #     * `source_system_timestamps`
        class UpdateEntryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DataCatalog::V1::DataCatalog::Client#delete_entry DeleteEntry}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the entry to delete.
        class DeleteEntryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DataCatalog::V1::DataCatalog::Client#get_entry GetEntry}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the entry to get.
        class GetEntryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DataCatalog::V1::DataCatalog::Client#lookup_entry LookupEntry}.
        # @!attribute [rw] linked_resource
        #   @return [::String]
        #     The full name of the Google Cloud Platform resource the Data Catalog
        #     entry represents. For more information, see [Full Resource Name]
        #     (https://cloud.google.com/apis/design/resource_names#full_resource_name).
        #
        #     Full names are case-sensitive. For example:
        #
        #      * `//bigquery.googleapis.com/projects/{PROJECT_ID}/datasets/{DATASET_ID}/tables/{TABLE_ID}`
        #      * `//pubsub.googleapis.com/projects/{PROJECT_ID}/topics/{TOPIC_ID}`
        #
        #     Note: The following fields are mutually exclusive: `linked_resource`, `sql_resource`, `fully_qualified_name`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] sql_resource
        #   @return [::String]
        #     The SQL name of the entry. SQL names are case-sensitive.
        #
        #     Examples:
        #
        #     * `pubsub.topic.{PROJECT_ID}.{TOPIC_ID}`
        #     * `pubsub.topic.{PROJECT_ID}.`\``{TOPIC.ID.SEPARATED.WITH.DOTS}`\`
        #     * `bigquery.table.{PROJECT_ID}.{DATASET_ID}.{TABLE_ID}`
        #     * `bigquery.dataset.{PROJECT_ID}.{DATASET_ID}`
        #     * `datacatalog.entry.{PROJECT_ID}.{LOCATION_ID}.{ENTRY_GROUP_ID}.{ENTRY_ID}`
        #
        #     Identifiers (`*_ID`) should comply with the
        #     [Lexical structure in GoogleSQL]
        #     (https://cloud.google.com/bigquery/docs/reference/standard-sql/lexical).
        #
        #     Note: The following fields are mutually exclusive: `sql_resource`, `linked_resource`, `fully_qualified_name`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] fully_qualified_name
        #   @return [::String]
        #     [Fully Qualified Name
        #     (FQN)](https://cloud.google.com//data-catalog/docs/fully-qualified-names)
        #     of the resource.
        #
        #     FQNs take two forms:
        #
        #     * For non-regionalized resources:
        #
        #       `{SYSTEM}:{PROJECT}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}`
        #
        #     * For regionalized resources:
        #
        #       `{SYSTEM}:{PROJECT}.{LOCATION_ID}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}`
        #
        #     Example for a DPMS table:
        #
        #     `dataproc_metastore:{PROJECT_ID}.{LOCATION_ID}.{INSTANCE_ID}.{DATABASE_ID}.{TABLE_ID}`
        #
        #     Note: The following fields are mutually exclusive: `fully_qualified_name`, `linked_resource`, `sql_resource`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] project
        #   @return [::String]
        #     Project where the lookup should be performed. Required to lookup
        #     entry that is not a part of `DPMS` or `DATAPLEX` `integrated_system`
        #     using its `fully_qualified_name`. Ignored in other cases.
        # @!attribute [rw] location
        #   @return [::String]
        #     Location where the lookup should be performed. Required to lookup
        #     entry that is not a part of `DPMS` or `DATAPLEX` `integrated_system`
        #     using its `fully_qualified_name`. Ignored in other cases.
        class LookupEntryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Entry metadata.
        # A Data Catalog entry represents another resource in Google
        # Cloud Platform (such as a BigQuery dataset or a Pub/Sub topic) or
        # outside of it. You can use the `linked_resource` field
        # in the entry resource to refer to the original resource ID of the source
        # system.
        #
        # An entry resource contains resource details, for example, its schema.
        # Additionally, you can attach flexible metadata to an entry in the form of a
        # {::Google::Cloud::DataCatalog::V1::Tag Tag}.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Identifier. The resource name of an entry in URL format.
        #
        #     Note: The entry itself and its child resources might not be
        #     stored in the location specified in its name.
        # @!attribute [rw] linked_resource
        #   @return [::String]
        #     The resource this metadata entry refers to.
        #
        #     For Google Cloud Platform resources, `linked_resource` is the
        #     [Full Resource Name]
        #     (https://cloud.google.com/apis/design/resource_names#full_resource_name).
        #     For example, the `linked_resource` for a table resource from BigQuery is:
        #
        #     `//bigquery.googleapis.com/projects/{PROJECT_ID}/datasets/{DATASET_ID}/tables/{TABLE_ID}`
        #
        #     Output only when the entry is one of the types in the `EntryType` enum.
        #
        #     For entries with a `user_specified_type`, this field is optional and
        #     defaults to an empty string.
        #
        #     The resource string must contain only letters (a-z, A-Z), numbers (0-9),
        #     underscores (_), periods (.), colons (:), slashes (/), dashes (-),
        #     and hashes (#).
        #     The maximum size is 200 bytes when encoded in UTF-8.
        # @!attribute [rw] fully_qualified_name
        #   @return [::String]
        #     [Fully Qualified Name
        #     (FQN)](https://cloud.google.com//data-catalog/docs/fully-qualified-names)
        #     of the resource. Set automatically for entries representing resources from
        #     synced systems. Settable only during creation, and read-only later. Can
        #     be used for search and lookup of the entries.
        # @!attribute [rw] type
        #   @return [::Google::Cloud::DataCatalog::V1::EntryType]
        #     The type of the entry.
        #
        #     For details, see [`EntryType`](#entrytype).
        #
        #     Note: The following fields are mutually exclusive: `type`, `user_specified_type`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] user_specified_type
        #   @return [::String]
        #     Custom entry type that doesn't match any of the values allowed for input
        #     and listed in the `EntryType` enum.
        #
        #     When creating an entry, first check the type values in the enum.
        #     If there are no appropriate types for the new entry,
        #     provide a custom value, for example, `my_special_type`.
        #
        #     The `user_specified_type` string has the following limitations:
        #
        #     * Is case insensitive.
        #     * Must begin with a letter or underscore.
        #     * Can only contain letters, numbers, and underscores.
        #     * Must be at least 1 character and at most 64 characters long.
        #
        #     Note: The following fields are mutually exclusive: `user_specified_type`, `type`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] integrated_system
        #   @return [::Google::Cloud::DataCatalog::V1::IntegratedSystem]
        #     Output only. Indicates the entry's source system that Data Catalog
        #     integrates with, such as BigQuery, Pub/Sub, or Dataproc Metastore.
        #
        #     Note: The following fields are mutually exclusive: `integrated_system`, `user_specified_system`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] user_specified_system
        #   @return [::String]
        #     Indicates the entry's source system that Data Catalog doesn't
        #     automatically integrate with.
        #
        #     The `user_specified_system` string has the following limitations:
        #
        #     * Is case insensitive.
        #     * Must begin with a letter or underscore.
        #     * Can only contain letters, numbers, and underscores.
        #     * Must be at least 1 character and at most 64 characters long.
        #
        #     Note: The following fields are mutually exclusive: `user_specified_system`, `integrated_system`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] sql_database_system_spec
        #   @return [::Google::Cloud::DataCatalog::V1::SqlDatabaseSystemSpec]
        #     Specification that applies to a relational database system. Only settable
        #     when `user_specified_system` is equal to `SQL_DATABASE`
        #
        #     Note: The following fields are mutually exclusive: `sql_database_system_spec`, `looker_system_spec`, `cloud_bigtable_system_spec`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] looker_system_spec
        #   @return [::Google::Cloud::DataCatalog::V1::LookerSystemSpec]
        #     Specification that applies to Looker sysstem. Only settable when
        #     `user_specified_system` is equal to `LOOKER`
        #
        #     Note: The following fields are mutually exclusive: `looker_system_spec`, `sql_database_system_spec`, `cloud_bigtable_system_spec`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] cloud_bigtable_system_spec
        #   @return [::Google::Cloud::DataCatalog::V1::CloudBigtableSystemSpec]
        #     Specification that applies to Cloud Bigtable system. Only settable when
        #     `integrated_system` is equal to `CLOUD_BIGTABLE`
        #
        #     Note: The following fields are mutually exclusive: `cloud_bigtable_system_spec`, `sql_database_system_spec`, `looker_system_spec`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] gcs_fileset_spec
        #   @return [::Google::Cloud::DataCatalog::V1::GcsFilesetSpec]
        #     Specification that applies to a Cloud Storage fileset. Valid only
        #     for entries with the `FILESET` type.
        #
        #     Note: The following fields are mutually exclusive: `gcs_fileset_spec`, `bigquery_table_spec`, `bigquery_date_sharded_spec`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] bigquery_table_spec
        #   @return [::Google::Cloud::DataCatalog::V1::BigQueryTableSpec]
        #     Output only. Specification that applies to a BigQuery table. Valid only
        #     for entries with the `TABLE` type.
        #
        #     Note: The following fields are mutually exclusive: `bigquery_table_spec`, `gcs_fileset_spec`, `bigquery_date_sharded_spec`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] bigquery_date_sharded_spec
        #   @return [::Google::Cloud::DataCatalog::V1::BigQueryDateShardedSpec]
        #     Output only. Specification for a group of BigQuery tables with
        #     the `[prefix]YYYYMMDD` name pattern.
        #
        #     For more information, see [Introduction to partitioned tables]
        #     (https://cloud.google.com/bigquery/docs/partitioned-tables#partitioning_versus_sharding).
        #
        #     Note: The following fields are mutually exclusive: `bigquery_date_sharded_spec`, `gcs_fileset_spec`, `bigquery_table_spec`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] database_table_spec
        #   @return [::Google::Cloud::DataCatalog::V1::DatabaseTableSpec]
        #     Specification that applies to a table resource. Valid only
        #     for entries with the `TABLE` or `EXPLORE` type.
        #
        #     Note: The following fields are mutually exclusive: `database_table_spec`, `data_source_connection_spec`, `routine_spec`, `dataset_spec`, `fileset_spec`, `service_spec`, `model_spec`, `feature_online_store_spec`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] data_source_connection_spec
        #   @return [::Google::Cloud::DataCatalog::V1::DataSourceConnectionSpec]
        #     Specification that applies to a data source connection. Valid only
        #     for entries with the `DATA_SOURCE_CONNECTION` type.
        #
        #     Note: The following fields are mutually exclusive: `data_source_connection_spec`, `database_table_spec`, `routine_spec`, `dataset_spec`, `fileset_spec`, `service_spec`, `model_spec`, `feature_online_store_spec`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] routine_spec
        #   @return [::Google::Cloud::DataCatalog::V1::RoutineSpec]
        #     Specification that applies to a user-defined function or procedure. Valid
        #     only for entries with the `ROUTINE` type.
        #
        #     Note: The following fields are mutually exclusive: `routine_spec`, `database_table_spec`, `data_source_connection_spec`, `dataset_spec`, `fileset_spec`, `service_spec`, `model_spec`, `feature_online_store_spec`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] dataset_spec
        #   @return [::Google::Cloud::DataCatalog::V1::DatasetSpec]
        #     Specification that applies to a dataset.
        #
        #     Note: The following fields are mutually exclusive: `dataset_spec`, `database_table_spec`, `data_source_connection_spec`, `routine_spec`, `fileset_spec`, `service_spec`, `model_spec`, `feature_online_store_spec`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] fileset_spec
        #   @return [::Google::Cloud::DataCatalog::V1::FilesetSpec]
        #     Specification that applies to a fileset resource. Valid only
        #     for entries with the `FILESET` type.
        #
        #     Note: The following fields are mutually exclusive: `fileset_spec`, `database_table_spec`, `data_source_connection_spec`, `routine_spec`, `dataset_spec`, `service_spec`, `model_spec`, `feature_online_store_spec`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] service_spec
        #   @return [::Google::Cloud::DataCatalog::V1::ServiceSpec]
        #     Specification that applies to a Service resource.
        #
        #     Note: The following fields are mutually exclusive: `service_spec`, `database_table_spec`, `data_source_connection_spec`, `routine_spec`, `dataset_spec`, `fileset_spec`, `model_spec`, `feature_online_store_spec`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] model_spec
        #   @return [::Google::Cloud::DataCatalog::V1::ModelSpec]
        #     Model specification.
        #
        #     Note: The following fields are mutually exclusive: `model_spec`, `database_table_spec`, `data_source_connection_spec`, `routine_spec`, `dataset_spec`, `fileset_spec`, `service_spec`, `feature_online_store_spec`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] feature_online_store_spec
        #   @return [::Google::Cloud::DataCatalog::V1::FeatureOnlineStoreSpec]
        #     FeatureonlineStore spec for Vertex AI Feature Store.
        #
        #     Note: The following fields are mutually exclusive: `feature_online_store_spec`, `database_table_spec`, `data_source_connection_spec`, `routine_spec`, `dataset_spec`, `fileset_spec`, `service_spec`, `model_spec`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Display name of an entry.
        #
        #     The maximum size is 500 bytes when encoded in UTF-8.
        #     Default value is an empty string.
        # @!attribute [rw] description
        #   @return [::String]
        #     Entry description that can consist of several sentences or paragraphs
        #     that describe entry contents.
        #
        #     The description must not contain Unicode non-characters as well as C0
        #     and C1 control codes except tabs (HT), new lines (LF), carriage returns
        #     (CR), and page breaks (FF).
        #     The maximum size is 2000 bytes when encoded in UTF-8.
        #     Default value is an empty string.
        # @!attribute [rw] business_context
        #   @return [::Google::Cloud::DataCatalog::V1::BusinessContext]
        #     Business Context of the entry. Not supported for BigQuery datasets
        # @!attribute [rw] schema
        #   @return [::Google::Cloud::DataCatalog::V1::Schema]
        #     Schema of the entry. An entry might not have any schema attached to it.
        # @!attribute [rw] source_system_timestamps
        #   @return [::Google::Cloud::DataCatalog::V1::SystemTimestamps]
        #     Timestamps from the underlying resource, not from the Data Catalog
        #     entry.
        #
        #     Output only when the entry has a system listed in the `IntegratedSystem`
        #     enum. For entries with `user_specified_system`, this field is optional
        #     and defaults to an empty timestamp.
        # @!attribute [rw] usage_signal
        #   @return [::Google::Cloud::DataCatalog::V1::UsageSignal]
        #     Resource usage statistics.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Cloud labels attached to the entry.
        #
        #     In Data Catalog, you can create and modify labels attached only to custom
        #     entries. Synced entries have unmodifiable labels that come from the source
        #     system.
        # @!attribute [r] data_source
        #   @return [::Google::Cloud::DataCatalog::V1::DataSource]
        #     Output only. Physical location of the entry.
        # @!attribute [r] personal_details
        #   @return [::Google::Cloud::DataCatalog::V1::PersonalDetails]
        #     Output only. Additional information related to the entry. Private to the
        #     current user.
        class Entry
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Specification that applies to a table resource. Valid only
        # for entries with the `TABLE` type.
        # @!attribute [rw] type
        #   @return [::Google::Cloud::DataCatalog::V1::DatabaseTableSpec::TableType]
        #     Type of this table.
        # @!attribute [r] dataplex_table
        #   @return [::Google::Cloud::DataCatalog::V1::DataplexTableSpec]
        #     Output only. Fields specific to a Dataplex table and present only in the
        #     Dataplex table entries.
        # @!attribute [rw] database_view_spec
        #   @return [::Google::Cloud::DataCatalog::V1::DatabaseTableSpec::DatabaseViewSpec]
        #     Spec what applies to tables that are actually views.
        #     Not set for "real" tables.
        class DatabaseTableSpec
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Specification that applies to database view.
          # @!attribute [rw] view_type
          #   @return [::Google::Cloud::DataCatalog::V1::DatabaseTableSpec::DatabaseViewSpec::ViewType]
          #     Type of this view.
          # @!attribute [rw] base_table
          #   @return [::String]
          #     Name of a singular table this view reflects one to one.
          #
          #     Note: The following fields are mutually exclusive: `base_table`, `sql_query`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] sql_query
          #   @return [::String]
          #     SQL query used to generate this view.
          #
          #     Note: The following fields are mutually exclusive: `sql_query`, `base_table`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class DatabaseViewSpec
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Concrete type of the view.
            module ViewType
              # Default unknown view type.
              VIEW_TYPE_UNSPECIFIED = 0

              # Standard view.
              STANDARD_VIEW = 1

              # Materialized view.
              MATERIALIZED_VIEW = 2
            end
          end

          # Type of the table.
          module TableType
            # Default unknown table type.
            TABLE_TYPE_UNSPECIFIED = 0

            # Native table.
            NATIVE = 1

            # External table.
            EXTERNAL = 2
          end
        end

        # Specification that applies to a fileset. Valid only for entries with the
        # 'FILESET' type.
        # @!attribute [rw] dataplex_fileset
        #   @return [::Google::Cloud::DataCatalog::V1::DataplexFilesetSpec]
        #     Fields specific to a Dataplex fileset and present only in the Dataplex
        #     fileset entries.
        class FilesetSpec
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Specification that applies to a data source connection. Valid only for
        # entries with the `DATA_SOURCE_CONNECTION` type.
        # Only one of internal specs can be set at the time, and cannot
        # be changed later.
        # @!attribute [rw] bigquery_connection_spec
        #   @return [::Google::Cloud::DataCatalog::V1::BigQueryConnectionSpec]
        #     Output only. Fields specific to BigQuery connections.
        class DataSourceConnectionSpec
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Specification that applies to a routine. Valid only for
        # entries with the `ROUTINE` type.
        # @!attribute [rw] routine_type
        #   @return [::Google::Cloud::DataCatalog::V1::RoutineSpec::RoutineType]
        #     The type of the routine.
        # @!attribute [rw] language
        #   @return [::String]
        #     The language the routine is written in. The exact value depends on the
        #     source system. For BigQuery routines, possible values are:
        #
        #     * `SQL`
        #     * `JAVASCRIPT`
        # @!attribute [rw] routine_arguments
        #   @return [::Array<::Google::Cloud::DataCatalog::V1::RoutineSpec::Argument>]
        #     Arguments of the routine.
        # @!attribute [rw] return_type
        #   @return [::String]
        #     Return type of the argument. The exact value depends on the source system
        #     and the language.
        # @!attribute [rw] definition_body
        #   @return [::String]
        #     The body of the routine.
        # @!attribute [rw] bigquery_routine_spec
        #   @return [::Google::Cloud::DataCatalog::V1::BigQueryRoutineSpec]
        #     Fields specific for BigQuery routines.
        class RoutineSpec
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Input or output argument of a function or stored procedure.
          # @!attribute [rw] name
          #   @return [::String]
          #     The name of the argument. A return argument of a function might not have
          #     a name.
          # @!attribute [rw] mode
          #   @return [::Google::Cloud::DataCatalog::V1::RoutineSpec::Argument::Mode]
          #     Specifies whether the argument is input or output.
          # @!attribute [rw] type
          #   @return [::String]
          #     Type of the argument. The exact value depends on the source system and
          #     the language.
          class Argument
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The input or output mode of the argument.
            module Mode
              # Unspecified mode.
              MODE_UNSPECIFIED = 0

              # The argument is input-only.
              IN = 1

              # The argument is output-only.
              OUT = 2

              # The argument is both an input and an output.
              INOUT = 3
            end
          end

          # The fine-grained type of the routine.
          module RoutineType
            # Unspecified type.
            ROUTINE_TYPE_UNSPECIFIED = 0

            # Non-builtin permanent scalar function.
            SCALAR_FUNCTION = 1

            # Stored procedure.
            PROCEDURE = 2
          end
        end

        # Specification that applies to a dataset. Valid only for
        # entries with the `DATASET` type.
        # @!attribute [rw] vertex_dataset_spec
        #   @return [::Google::Cloud::DataCatalog::V1::VertexDatasetSpec]
        #     Vertex AI Dataset specific fields
        class DatasetSpec
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Specification that applies to
        # entries that are part `SQL_DATABASE` system
        # (user_specified_type)
        # @!attribute [rw] sql_engine
        #   @return [::String]
        #     SQL Database Engine.
        #     enum SqlEngine {
        #      UNDEFINED = 0;
        #      MY_SQL = 1;
        #      POSTGRE_SQL = 2;
        #      SQL_SERVER = 3;
        #     }
        #     Engine of the enclosing database instance.
        # @!attribute [rw] database_version
        #   @return [::String]
        #     Version of the database engine.
        # @!attribute [rw] instance_host
        #   @return [::String]
        #     Host of the SQL database
        #     enum InstanceHost {
        #      UNDEFINED = 0;
        #      SELF_HOSTED = 1;
        #      CLOUD_SQL = 2;
        #      AMAZON_RDS = 3;
        #      AZURE_SQL = 4;
        #     }
        #     Host of the enclousing database instance.
        class SqlDatabaseSystemSpec
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Specification that applies to
        # entries that are part `LOOKER` system
        # (user_specified_type)
        # @!attribute [rw] parent_instance_id
        #   @return [::String]
        #     ID of the parent Looker Instance. Empty if it does not exist.
        #     Example value: `someinstance.looker.com`
        # @!attribute [rw] parent_instance_display_name
        #   @return [::String]
        #     Name of the parent Looker Instance. Empty if it does not exist.
        # @!attribute [rw] parent_model_id
        #   @return [::String]
        #     ID of the parent Model. Empty if it does not exist.
        # @!attribute [rw] parent_model_display_name
        #   @return [::String]
        #     Name of the parent Model. Empty if it does not exist.
        # @!attribute [rw] parent_view_id
        #   @return [::String]
        #     ID of the parent View. Empty if it does not exist.
        # @!attribute [rw] parent_view_display_name
        #   @return [::String]
        #     Name of the parent View. Empty if it does not exist.
        class LookerSystemSpec
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Specification that applies to
        # all entries that are part of `CLOUD_BIGTABLE` system
        # (user_specified_type)
        # @!attribute [rw] instance_display_name
        #   @return [::String]
        #     Display name of the Instance. This is user specified and different from
        #     the resource name.
        class CloudBigtableSystemSpec
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Specification that applies to Instance
        # entries that are part of `CLOUD_BIGTABLE` system.
        # (user_specified_type)
        # @!attribute [rw] cloud_bigtable_cluster_specs
        #   @return [::Array<::Google::Cloud::DataCatalog::V1::CloudBigtableInstanceSpec::CloudBigtableClusterSpec>]
        #     The list of clusters for the Instance.
        class CloudBigtableInstanceSpec
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Spec that applies to clusters of an Instance of Cloud Bigtable.
          # @!attribute [rw] display_name
          #   @return [::String]
          #     Name of the cluster.
          # @!attribute [rw] location
          #   @return [::String]
          #     Location of the cluster, typically a Cloud zone.
          # @!attribute [rw] type
          #   @return [::String]
          #     Type of the resource. For a cluster this would be "CLUSTER".
          # @!attribute [rw] linked_resource
          #   @return [::String]
          #     A link back to the parent resource, in this case Instance.
          class CloudBigtableClusterSpec
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Specification that applies to a Service resource. Valid only
        # for entries with the `SERVICE` type.
        # @!attribute [rw] cloud_bigtable_instance_spec
        #   @return [::Google::Cloud::DataCatalog::V1::CloudBigtableInstanceSpec]
        #     Specification that applies to Instance entries of `CLOUD_BIGTABLE`
        #     system.
        class ServiceSpec
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Detail description of the source information of a Vertex model.
        # @!attribute [rw] source_type
        #   @return [::Google::Cloud::DataCatalog::V1::VertexModelSourceInfo::ModelSourceType]
        #     Type of the model source.
        # @!attribute [rw] copy
        #   @return [::Boolean]
        #     If this Model is copy of another Model. If true then
        #     {::Google::Cloud::DataCatalog::V1::VertexModelSourceInfo#source_type source_type}
        #     pertains to the original.
        class VertexModelSourceInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Source of the model.
          module ModelSourceType
            # Should not be used.
            MODEL_SOURCE_TYPE_UNSPECIFIED = 0

            # The Model is uploaded by automl training pipeline.
            AUTOML = 1

            # The Model is uploaded by user or custom training pipeline.
            CUSTOM = 2

            # The Model is registered and sync'ed from BigQuery ML.
            BQML = 3

            # The Model is saved or tuned from Model Garden.
            MODEL_GARDEN = 4

            # The Model is saved or tuned from Genie.
            GENIE = 5

            # The Model is uploaded by text embedding finetuning pipeline.
            CUSTOM_TEXT_EMBEDDING = 6

            # The Model is saved or tuned from Marketplace.
            MARKETPLACE = 7
          end
        end

        # Specification for vertex model resources.
        # @!attribute [rw] version_id
        #   @return [::String]
        #     The version ID of the model.
        # @!attribute [rw] version_aliases
        #   @return [::Array<::String>]
        #     User provided version aliases so that a model version can be referenced via
        #     alias
        # @!attribute [rw] version_description
        #   @return [::String]
        #     The description of this version.
        # @!attribute [rw] vertex_model_source_info
        #   @return [::Google::Cloud::DataCatalog::V1::VertexModelSourceInfo]
        #     Source of a Vertex model.
        # @!attribute [rw] container_image_uri
        #   @return [::String]
        #     URI of the Docker image to be used as the custom container for serving
        #     predictions.
        class VertexModelSpec
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Specification for vertex dataset resources.
        # @!attribute [rw] data_item_count
        #   @return [::Integer]
        #     The number of DataItems in this Dataset. Only apply for non-structured
        #     Dataset.
        # @!attribute [rw] data_type
        #   @return [::Google::Cloud::DataCatalog::V1::VertexDatasetSpec::DataType]
        #     Type of the dataset.
        class VertexDatasetSpec
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Type of data stored in the dataset.
          module DataType
            # Should not be used.
            DATA_TYPE_UNSPECIFIED = 0

            # Structured data dataset.
            TABLE = 1

            # Image dataset which supports ImageClassification, ImageObjectDetection
            # and ImageSegmentation problems.
            IMAGE = 2

            # Document dataset which supports TextClassification, TextExtraction and
            # TextSentiment problems.
            TEXT = 3

            # Video dataset which supports VideoClassification, VideoObjectTracking and
            # VideoActionRecognition problems.
            VIDEO = 4

            # Conversation dataset which supports conversation problems.
            CONVERSATION = 5

            # TimeSeries dataset.
            TIME_SERIES = 6

            # Document dataset which supports DocumentAnnotation problems.
            DOCUMENT = 7

            # TextToSpeech dataset which supports TextToSpeech problems.
            TEXT_TO_SPEECH = 8

            # Translation dataset which supports Translation problems.
            TRANSLATION = 9

            # Store Vision dataset which is used for HITL integration.
            STORE_VISION = 10

            # Enterprise Knowledge Graph dataset which is used for HITL labeling
            # integration.
            ENTERPRISE_KNOWLEDGE_GRAPH = 11

            # Text prompt dataset which supports Large Language Models.
            TEXT_PROMPT = 12
          end
        end

        # Specification that applies to a model. Valid only for
        # entries with the `MODEL` type.
        # @!attribute [rw] vertex_model_spec
        #   @return [::Google::Cloud::DataCatalog::V1::VertexModelSpec]
        #     Specification for vertex model resources.
        class ModelSpec
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Detail description of the source information of a Vertex Feature Online
        # Store.
        # @!attribute [r] storage_type
        #   @return [::Google::Cloud::DataCatalog::V1::FeatureOnlineStoreSpec::StorageType]
        #     Output only. Type of underlying storage for the FeatureOnlineStore.
        class FeatureOnlineStoreSpec
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Type of underlying storage type.
          module StorageType
            # Should not be used.
            STORAGE_TYPE_UNSPECIFIED = 0

            # Underlsying storgae is Bigtable.
            BIGTABLE = 1

            # Underlying is optimized online server (Lightning).
            OPTIMIZED = 2
          end
        end

        # Business Context of the entry.
        # @!attribute [rw] entry_overview
        #   @return [::Google::Cloud::DataCatalog::V1::EntryOverview]
        #     Entry overview fields for rich text descriptions of entries.
        # @!attribute [rw] contacts
        #   @return [::Google::Cloud::DataCatalog::V1::Contacts]
        #     Contact people for the entry.
        class BusinessContext
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Entry overview fields for rich text descriptions of entries.
        # @!attribute [rw] overview
        #   @return [::String]
        #     Entry overview with support for rich text.
        #
        #     The overview must only contain Unicode characters, and should be
        #     formatted using HTML.
        #     The maximum length is 10 MiB as this value holds HTML descriptions
        #     including encoded images. The maximum length of the text without images
        #     is 100 KiB.
        class EntryOverview
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Contact people for the entry.
        # @!attribute [rw] people
        #   @return [::Array<::Google::Cloud::DataCatalog::V1::Contacts::Person>]
        #     The list of contact people for the entry.
        class Contacts
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A contact person for the entry.
          # @!attribute [rw] designation
          #   @return [::String]
          #     Designation of the person, for example, Data Steward.
          # @!attribute [rw] email
          #   @return [::String]
          #     Email of the person in the format of `john.doe@xyz`,
          #     `<john.doe@xyz>`, or `John Doe<john.doe@xyz>`.
          class Person
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Entry group metadata.
        #
        #  An `EntryGroup` resource represents a logical grouping of zero or more
        #  Data Catalog {::Google::Cloud::DataCatalog::V1::Entry Entry} resources.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The resource name of the entry group in URL format.
        #
        #     Note: The entry group itself and its child resources might not be
        #     stored in the location specified in its name.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     A short name to identify the entry group, for example,
        #     "analytics data - jan 2011". Default value is an empty string.
        # @!attribute [rw] description
        #   @return [::String]
        #     Entry group description. Can consist of several sentences or
        #     paragraphs that describe the entry group contents.
        #     Default value is an empty string.
        # @!attribute [r] data_catalog_timestamps
        #   @return [::Google::Cloud::DataCatalog::V1::SystemTimestamps]
        #     Output only. Timestamps of the entry group. Default value is empty.
        # @!attribute [rw] transferred_to_dataplex
        #   @return [::Boolean]
        #     Optional. When set to [true], it means DataCatalog EntryGroup was
        #     transferred to Dataplex Catalog Service. It makes EntryGroup and its
        #     Entries to be read-only in DataCatalog. However, new Tags on EntryGroup and
        #     its Entries can be created. After setting the flag to [true] it cannot be
        #     unset.
        class EntryGroup
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DataCatalog::V1::DataCatalog::Client#create_tag_template CreateTagTemplate}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the project and the template location
        #     [region](https://cloud.google.com/data-catalog/docs/concepts/regions).
        # @!attribute [rw] tag_template_id
        #   @return [::String]
        #     Required. The ID of the tag template to create.
        #
        #     The ID must contain only lowercase letters (a-z), numbers (0-9),
        #     or underscores (_), and must start with a letter or underscore.
        #     The maximum size is 64 bytes when encoded in UTF-8.
        # @!attribute [rw] tag_template
        #   @return [::Google::Cloud::DataCatalog::V1::TagTemplate]
        #     Required. The tag template to create.
        class CreateTagTemplateRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DataCatalog::V1::DataCatalog::Client#get_tag_template GetTagTemplate}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the tag template to get.
        class GetTagTemplateRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DataCatalog::V1::DataCatalog::Client#update_tag_template UpdateTagTemplate}.
        # @!attribute [rw] tag_template
        #   @return [::Google::Cloud::DataCatalog::V1::TagTemplate]
        #     Required. The template to update. The `name` field must be set.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Names of fields whose values to overwrite on a tag template. Currently,
        #     only `display_name` and `is_publicly_readable` can be overwritten.
        #
        #     If this parameter is absent or empty, all modifiable fields
        #     are overwritten. If such fields are non-required and omitted in the
        #     request body, their values are emptied.
        #
        #     Note: Updating the `is_publicly_readable` field may require up to 12
        #     hours to take effect in search results.
        class UpdateTagTemplateRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DataCatalog::V1::DataCatalog::Client#delete_tag_template DeleteTagTemplate}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the tag template to delete.
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     Required. If true, deletes all tags that use this template.
        #
        #     Currently, `true` is the only supported value.
        class DeleteTagTemplateRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DataCatalog::V1::DataCatalog::Client#create_tag CreateTag}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the resource to attach this tag to.
        #
        #     Tags can be attached to entries or entry groups. An entry can have up to
        #     1000 attached tags.
        #
        #     Note: The tag and its child resources might not be stored in
        #     the location specified in its name.
        # @!attribute [rw] tag
        #   @return [::Google::Cloud::DataCatalog::V1::Tag]
        #     Required. The tag to create.
        class CreateTagRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DataCatalog::V1::DataCatalog::Client#update_tag UpdateTag}.
        # @!attribute [rw] tag
        #   @return [::Google::Cloud::DataCatalog::V1::Tag]
        #     Required. The updated tag. The "name" field must be set.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Names of fields whose values to overwrite on a tag. Currently, a tag has
        #     the only modifiable field with the name `fields`.
        #
        #     In general, if this parameter is absent or empty, all modifiable fields
        #     are overwritten. If such fields are non-required and omitted in the
        #     request body, their values are emptied.
        class UpdateTagRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DataCatalog::V1::DataCatalog::Client#delete_tag DeleteTag}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the tag to delete.
        class DeleteTagRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DataCatalog::V1::DataCatalog::Client#create_tag_template_field CreateTagTemplateField}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the project and the template location
        #     [region](https://cloud.google.com/data-catalog/docs/concepts/regions).
        # @!attribute [rw] tag_template_field_id
        #   @return [::String]
        #     Required. The ID of the tag template field to create.
        #
        #     Note: Adding a required field to an existing template is *not* allowed.
        #
        #     Field IDs can contain letters (both uppercase and lowercase), numbers
        #     (0-9), underscores (_) and dashes (-). Field IDs must be at least 1
        #     character long and at most 128 characters long. Field IDs must also be
        #     unique within their template.
        # @!attribute [rw] tag_template_field
        #   @return [::Google::Cloud::DataCatalog::V1::TagTemplateField]
        #     Required. The tag template field to create.
        class CreateTagTemplateFieldRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DataCatalog::V1::DataCatalog::Client#update_tag_template_field UpdateTagTemplateField}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the tag template field.
        # @!attribute [rw] tag_template_field
        #   @return [::Google::Cloud::DataCatalog::V1::TagTemplateField]
        #     Required. The template to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Names of fields whose values to overwrite on an individual field
        #     of a tag template. The following fields are modifiable:
        #
        #     * `display_name`
        #     * `type.enum_type`
        #     * `is_required`
        #
        #     If this parameter is absent or empty, all modifiable fields
        #     are overwritten. If such fields are non-required and omitted in the request
        #     body, their values are emptied with one exception: when updating an enum
        #     type, the provided values are merged with the existing values. Therefore,
        #     enum values can only be added, existing enum values cannot be deleted or
        #     renamed.
        #
        #     Additionally, updating a template field from optional to required is
        #     *not* allowed.
        class UpdateTagTemplateFieldRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DataCatalog::V1::DataCatalog::Client#rename_tag_template_field RenameTagTemplateField}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the tag template field.
        # @!attribute [rw] new_tag_template_field_id
        #   @return [::String]
        #     Required. The new ID of this tag template field. For example,
        #     `my_new_field`.
        class RenameTagTemplateFieldRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DataCatalog::V1::DataCatalog::Client#rename_tag_template_field_enum_value RenameTagTemplateFieldEnumValue}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the enum field value.
        # @!attribute [rw] new_enum_value_display_name
        #   @return [::String]
        #     Required. The new display name of the enum value. For example,
        #     `my_new_enum_value`.
        class RenameTagTemplateFieldEnumValueRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DataCatalog::V1::DataCatalog::Client#delete_tag_template_field DeleteTagTemplateField}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the tag template field to delete.
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     Required. If true, deletes this field from any tags that use it.
        #
        #     Currently, `true` is the only supported value.
        class DeleteTagTemplateFieldRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DataCatalog::V1::DataCatalog::Client#list_tags ListTags}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the Data Catalog resource to list the tags of.
        #
        #     The resource can be an {::Google::Cloud::DataCatalog::V1::Entry Entry}
        #     or an {::Google::Cloud::DataCatalog::V1::EntryGroup EntryGroup}
        #     (without `/entries/{entries}` at the end).
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of tags to return. Default is 10. Maximum limit is 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Pagination token that specifies the next page to return. If empty, the
        #     first page is returned.
        class ListTagsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::DataCatalog::V1::DataCatalog::Client#list_tags ListTags}.
        # @!attribute [rw] tags
        #   @return [::Array<::Google::Cloud::DataCatalog::V1::Tag>]
        #     {::Google::Cloud::DataCatalog::V1::Tag Tag} details.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Pagination token of the next results page. Empty if there are
        #     no more items in results.
        class ListTagsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DataCatalog::V1::DataCatalog::Client#reconcile_tags ReconcileTags}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Name of {::Google::Cloud::DataCatalog::V1::Entry Entry} to be tagged.
        # @!attribute [rw] tag_template
        #   @return [::String]
        #     Required. The name of the tag template, which is used for reconciliation.
        # @!attribute [rw] force_delete_missing
        #   @return [::Boolean]
        #     If set to `true`, deletes entry tags related to a tag template
        #     not listed in the tags source from an entry. If set to `false`,
        #     unlisted tags are retained.
        # @!attribute [rw] tags
        #   @return [::Array<::Google::Cloud::DataCatalog::V1::Tag>]
        #     A list of tags to apply to an entry. A tag can specify a
        #     tag template, which must be the template specified in the
        #     `ReconcileTagsRequest`.
        #     The sole entry and each of its columns must be mentioned at most once.
        class ReconcileTagsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # {::Google::Longrunning::Operation Long-running operation}
        # response message returned by
        # {::Google::Cloud::DataCatalog::V1::DataCatalog::Client#reconcile_tags ReconcileTags}.
        # @!attribute [rw] created_tags_count
        #   @return [::Integer]
        #     Number of tags created in the request.
        # @!attribute [rw] updated_tags_count
        #   @return [::Integer]
        #     Number of tags updated in the request.
        # @!attribute [rw] deleted_tags_count
        #   @return [::Integer]
        #     Number of tags deleted in the request.
        class ReconcileTagsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # {::Google::Longrunning::Operation Long-running operation}
        # metadata message returned by the
        # {::Google::Cloud::DataCatalog::V1::DataCatalog::Client#reconcile_tags ReconcileTags}.
        # @!attribute [rw] state
        #   @return [::Google::Cloud::DataCatalog::V1::ReconcileTagsMetadata::ReconciliationState]
        #     State of the reconciliation operation.
        # @!attribute [rw] errors
        #   @return [::Google::Protobuf::Map{::String => ::Google::Rpc::Status}]
        #     Maps the name of each tagged column (or empty string for a
        #     sole entry) to tagging operation {::Google::Rpc::Status status}.
        class ReconcileTagsMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Rpc::Status]
          class ErrorsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Enum holding possible states of the reconciliation operation.
          module ReconciliationState
            # Default value. This value is unused.
            RECONCILIATION_STATE_UNSPECIFIED = 0

            # The reconciliation has been queued and awaits for execution.
            RECONCILIATION_QUEUED = 1

            # The reconciliation is in progress.
            RECONCILIATION_IN_PROGRESS = 2

            # The reconciliation has been finished.
            RECONCILIATION_DONE = 3
          end
        end

        # Request message for
        # {::Google::Cloud::DataCatalog::V1::DataCatalog::Client#list_entries ListEntries}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the entry group that contains the entries to list.
        #
        #     Can be provided in URL format.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of items to return. Default is 10. Maximum limit is
        #     1000. Throws an invalid argument if `page_size` is more than 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Pagination token that specifies the next page to return. If empty, the
        #     first page is returned.
        # @!attribute [rw] read_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The fields to return for each entry. If empty or omitted, all
        #     fields are returned.
        #
        #     For example, to return a list of entries with only the `name` field,
        #     set `read_mask` to only one path with the `name` value.
        class ListEntriesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::DataCatalog::V1::DataCatalog::Client#list_entries ListEntries}.
        # @!attribute [rw] entries
        #   @return [::Array<::Google::Cloud::DataCatalog::V1::Entry>]
        #     Entry details.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Pagination token of the next results page. Empty if there are no more items
        #     in results.
        class ListEntriesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DataCatalog::V1::DataCatalog::Client#star_entry StarEntry}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the entry to mark as starred.
        class StarEntryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::DataCatalog::V1::DataCatalog::Client#star_entry StarEntry}.
        # Empty for now
        class StarEntryResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DataCatalog::V1::DataCatalog::Client#unstar_entry UnstarEntry}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the entry to mark as **not** starred.
        class UnstarEntryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::DataCatalog::V1::DataCatalog::Client#unstar_entry UnstarEntry}.
        # Empty for now
        class UnstarEntryResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DataCatalog::V1::DataCatalog::Client#import_entries ImportEntries}
        # method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Target entry group for ingested entries.
        # @!attribute [rw] gcs_bucket_path
        #   @return [::String]
        #     Path to a Cloud Storage bucket that contains a dump ready for ingestion.
        # @!attribute [rw] job_id
        #   @return [::String]
        #     Optional. (Optional) Dataplex task job id, if specified will be used as
        #     part of ImportEntries LRO ID
        class ImportEntriesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for {::Google::Longrunning::Operation long-running operation}
        # returned by the
        # {::Google::Cloud::DataCatalog::V1::DataCatalog::Client#import_entries ImportEntries}.
        # @!attribute [rw] upserted_entries_count
        #   @return [::Integer]
        #     Cumulative number of entries created and entries updated as a result of
        #     import operation.
        # @!attribute [rw] deleted_entries_count
        #   @return [::Integer]
        #     Number of entries deleted as a result of import operation.
        class ImportEntriesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata message for {::Google::Longrunning::Operation long-running operation}
        # returned by the
        # {::Google::Cloud::DataCatalog::V1::DataCatalog::Client#import_entries ImportEntries}.
        # @!attribute [rw] state
        #   @return [::Google::Cloud::DataCatalog::V1::ImportEntriesMetadata::ImportState]
        #     State of the import operation.
        # @!attribute [rw] errors
        #   @return [::Array<::Google::Rpc::Status>]
        #     Partial errors that are encountered during the ImportEntries operation.
        #     There is no guarantee that all the encountered errors are reported.
        #     However, if no errors are reported, it means that no errors were
        #     encountered.
        class ImportEntriesMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Enum holding possible states of the import operation.
          module ImportState
            # Default value. This value is unused.
            IMPORT_STATE_UNSPECIFIED = 0

            # The dump with entries has been queued for import.
            IMPORT_QUEUED = 1

            # The import of entries is in progress.
            IMPORT_IN_PROGRESS = 2

            # The import of entries has been finished.
            IMPORT_DONE = 3

            # The import of entries has been abandoned in favor of a newer request.
            IMPORT_OBSOLETE = 4
          end
        end

        # Request message for
        # {::Google::Cloud::DataCatalog::V1::DataCatalog::Client#modify_entry_overview ModifyEntryOverview}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The full resource name of the entry.
        # @!attribute [rw] entry_overview
        #   @return [::Google::Cloud::DataCatalog::V1::EntryOverview]
        #     Required. The new value for the Entry Overview.
        class ModifyEntryOverviewRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DataCatalog::V1::DataCatalog::Client#modify_entry_contacts ModifyEntryContacts}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The full resource name of the entry.
        # @!attribute [rw] contacts
        #   @return [::Google::Cloud::DataCatalog::V1::Contacts]
        #     Required. The new value for the Contacts.
        class ModifyEntryContactsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DataCatalog::V1::DataCatalog::Client#set_config SetConfig}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The organization or project whose config is being specified.
        # @!attribute [rw] tag_template_migration
        #   @return [::Google::Cloud::DataCatalog::V1::TagTemplateMigration]
        #     Opt-in status for the migration of Tag Templates to Dataplex.
        #
        #     Note: The following fields are mutually exclusive: `tag_template_migration`, `catalog_ui_experience`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] catalog_ui_experience
        #   @return [::Google::Cloud::DataCatalog::V1::CatalogUIExperience]
        #     Opt-in status for the UI switch to Dataplex.
        #
        #     Note: The following fields are mutually exclusive: `catalog_ui_experience`, `tag_template_migration`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class SetConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DataCatalog::V1::DataCatalog::Client#retrieve_config RetrieveConfig}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The organization whose config is being retrieved.
        class RetrieveConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DataCatalog::V1::DataCatalog::Client#retrieve_effective_config RetrieveEffectiveConfig}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource whose effective config is being retrieved.
        class RetrieveEffectiveConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The configuration related to the migration from Data Catalog to Dataplex that
        # has been applied to an organization and any projects under it. It is the
        # response message for
        # {::Google::Cloud::DataCatalog::V1::DataCatalog::Client#retrieve_config RetrieveConfig}.
        # @!attribute [rw] config
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::DataCatalog::V1::MigrationConfig}]
        #     Map of organizations and project resource names and their configuration.
        #     The format for the map keys is `organizations/{organizationId}` or
        #     `projects/{projectId}`.
        class OrganizationConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::DataCatalog::V1::MigrationConfig]
          class ConfigEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The configuration related to the migration to Dataplex applied to an
        # organization or project.
        # It is the response message for
        # {::Google::Cloud::DataCatalog::V1::DataCatalog::Client#set_config SetConfig} and
        # {::Google::Cloud::DataCatalog::V1::DataCatalog::Client#retrieve_effective_config RetrieveEffectiveConfig}.
        # @!attribute [rw] tag_template_migration
        #   @return [::Google::Cloud::DataCatalog::V1::TagTemplateMigration]
        #     Opt-in status for the migration of Tag Templates to Dataplex.
        # @!attribute [rw] catalog_ui_experience
        #   @return [::Google::Cloud::DataCatalog::V1::CatalogUIExperience]
        #     Opt-in status for the UI switch to Dataplex.
        # @!attribute [rw] template_migration_enabled_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time when the Tag Template migration was enabled.
        #     If the Tag Template migration is not enabled, this field is not set.
        class MigrationConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata automatically ingested from Google Cloud resources like BigQuery
        # tables or Pub/Sub topics always uses enum values from `EntryType` as the type
        # of entry.
        #
        # Other sources of metadata like Hive or Oracle databases can identify the type
        # by either using one of the enum values from `EntryType` (for example,
        # `FILESET` for a Cloud Storage fileset) or specifying a custom value using
        # the [`Entry`](#resource:-entry) field `user_specified_type`. For more
        # information, see
        # [Surface files from Cloud Storage with fileset
        # entries](/data-catalog/docs/how-to/filesets) or [Create custom entries for
        # your data sources](/data-catalog/docs/how-to/custom-entries).
        module EntryType
          # Default unknown type.
          ENTRY_TYPE_UNSPECIFIED = 0

          # The entry type that has a GoogleSQL schema, including
          # logical views.
          TABLE = 2

          # The type of models.
          #
          # For more information, see [Supported models in BigQuery
          # ML](/bigquery/docs/bqml-introduction#supported_models).
          MODEL = 5

          # An entry type for streaming entries. For example, a Pub/Sub topic.
          DATA_STREAM = 3

          # An entry type for a set of files or objects. For example, a
          # Cloud Storage fileset.
          FILESET = 4

          # A group of servers that work together. For example, a Kafka cluster.
          CLUSTER = 6

          # A database.
          DATABASE = 7

          # Connection to a data source. For example, a BigQuery
          # connection.
          DATA_SOURCE_CONNECTION = 8

          # Routine, for example, a BigQuery routine.
          ROUTINE = 9

          # A Dataplex lake.
          LAKE = 10

          # A Dataplex zone.
          ZONE = 11

          # A service, for example, a Dataproc Metastore service.
          SERVICE = 14

          # Schema within a relational database.
          DATABASE_SCHEMA = 15

          # A Dashboard, for example from Looker.
          DASHBOARD = 16

          # A Looker Explore.
          #
          # For more information, see [Looker Explore API]
          # (https://developers.looker.com/api/explorer/4.0/methods/LookmlModel/lookml_model_explore).
          EXPLORE = 17

          # A Looker Look.
          #
          # For more information, see [Looker Look API]
          # (https://developers.looker.com/api/explorer/4.0/methods/Look).
          LOOK = 18

          # Feature Online Store resource in Vertex AI Feature Store.
          FEATURE_ONLINE_STORE = 19

          # Feature View resource in Vertex AI Feature Store.
          FEATURE_VIEW = 20

          # Feature Group resource in Vertex AI Feature Store.
          FEATURE_GROUP = 21
        end

        # Configuration related to the opt-in status for the migration of TagTemplates
        # to Dataplex.
        module TagTemplateMigration
          # Default value. Migration of Tag Templates from Data Catalog to Dataplex is
          # not performed.
          TAG_TEMPLATE_MIGRATION_UNSPECIFIED = 0

          # Migration of Tag Templates from Data Catalog to Dataplex is enabled.
          TAG_TEMPLATE_MIGRATION_ENABLED = 1

          # Migration of Tag Templates from Data Catalog to Dataplex is disabled.
          TAG_TEMPLATE_MIGRATION_DISABLED = 2
        end

        # Configuration related to the opt-in status for the UI switch to Dataplex.
        module CatalogUIExperience
          # Default value. The default UI is Dataplex.
          CATALOG_UI_EXPERIENCE_UNSPECIFIED = 0

          # The UI is Dataplex.
          CATALOG_UI_EXPERIENCE_ENABLED = 1

          # The UI is Data Catalog.
          CATALOG_UI_EXPERIENCE_DISABLED = 2
        end
      end
    end
  end
end
