# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/cloud/datacatalog/v1/policytagmanagerserialization.proto for package 'Google.Cloud.DataCatalog.V1'
# Original file comments:
# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/cloud/datacatalog/v1/policytagmanagerserialization_pb'

module Google
  module Cloud
    module DataCatalog
      module V1
        module PolicyTagManagerSerialization
          # Policy Tag Manager Serialization API service allows you to manipulate
          # your policy tags and taxonomies in a serialized format.
          #
          # Taxonomy is a hierarchical group of policy tags.
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'google.cloud.datacatalog.v1.PolicyTagManagerSerialization'

            # Replaces (updates) a taxonomy and all its policy tags.
            #
            # The taxonomy and its entire hierarchy of policy tags must be
            # represented literally by `SerializedTaxonomy` and the nested
            # `SerializedPolicyTag` messages.
            #
            # This operation automatically does the following:
            #
            # - Deletes the existing policy tags that are missing from the
            #   `SerializedPolicyTag`.
            # - Creates policy tags that don't have resource names. They are considered
            #   new.
            # - Updates policy tags with valid resources names accordingly.
            rpc :ReplaceTaxonomy, ::Google::Cloud::DataCatalog::V1::ReplaceTaxonomyRequest, ::Google::Cloud::DataCatalog::V1::Taxonomy
            # Creates new taxonomies (including their policy tags) in a given project
            # by importing from inlined or cross-regional sources.
            #
            # For a cross-regional source, new taxonomies are created by copying
            # from a source in another region.
            #
            # For an inlined source, taxonomies and policy tags are created in bulk using
            # nested protocol buffer structures.
            rpc :ImportTaxonomies, ::Google::Cloud::DataCatalog::V1::ImportTaxonomiesRequest, ::Google::Cloud::DataCatalog::V1::ImportTaxonomiesResponse
            # Exports taxonomies in the requested type and returns them,
            # including their policy tags. The requested taxonomies must belong to the
            # same project.
            #
            # This method generates `SerializedTaxonomy` protocol buffers with nested
            # policy tags that can be used as input for `ImportTaxonomies` calls.
            rpc :ExportTaxonomies, ::Google::Cloud::DataCatalog::V1::ExportTaxonomiesRequest, ::Google::Cloud::DataCatalog::V1::ExportTaxonomiesResponse
          end

          Stub = Service.rpc_stub_class
        end
      end
    end
  end
end
