# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/cloud/datacatalog/v1/policytagmanager.proto for package 'Google.Cloud.DataCatalog.V1'
# Original file comments:
# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/cloud/datacatalog/v1/policytagmanager_pb'

module Google
  module Cloud
    module DataCatalog
      module V1
        module PolicyTagManager
          # Policy Tag Manager API service allows you to manage your policy tags and
          # taxonomies.
          #
          # Policy tags are used to tag BigQuery columns and apply additional access
          # control policies. A taxonomy is a hierarchical grouping of policy tags that
          # classify data along a common axis.
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'google.cloud.datacatalog.v1.PolicyTagManager'

            # Creates a taxonomy in a specified project.
            #
            # The taxonomy is initially empty, that is, it doesn't contain policy tags.
            rpc :CreateTaxonomy, ::Google::Cloud::DataCatalog::V1::CreateTaxonomyRequest, ::Google::Cloud::DataCatalog::V1::Taxonomy
            # Deletes a taxonomy, including all policy tags in this
            # taxonomy, their associated policies, and the policy tags references from
            # BigQuery columns.
            rpc :DeleteTaxonomy, ::Google::Cloud::DataCatalog::V1::DeleteTaxonomyRequest, ::Google::Protobuf::Empty
            # Updates a taxonomy, including its display name,
            # description, and activated policy types.
            rpc :UpdateTaxonomy, ::Google::Cloud::DataCatalog::V1::UpdateTaxonomyRequest, ::Google::Cloud::DataCatalog::V1::Taxonomy
            # Lists all taxonomies in a project in a particular location that you
            # have a permission to view.
            rpc :ListTaxonomies, ::Google::Cloud::DataCatalog::V1::ListTaxonomiesRequest, ::Google::Cloud::DataCatalog::V1::ListTaxonomiesResponse
            # Gets a taxonomy.
            rpc :GetTaxonomy, ::Google::Cloud::DataCatalog::V1::GetTaxonomyRequest, ::Google::Cloud::DataCatalog::V1::Taxonomy
            # Creates a policy tag in a taxonomy.
            rpc :CreatePolicyTag, ::Google::Cloud::DataCatalog::V1::CreatePolicyTagRequest, ::Google::Cloud::DataCatalog::V1::PolicyTag
            # Deletes a policy tag together with the following:
            #
            # * All of its descendant policy tags, if any
            # * Policies associated with the policy tag and its descendants
            # * References from BigQuery table schema of the policy tag and its
            #   descendants
            rpc :DeletePolicyTag, ::Google::Cloud::DataCatalog::V1::DeletePolicyTagRequest, ::Google::Protobuf::Empty
            # Updates a policy tag, including its display
            # name, description, and parent policy tag.
            rpc :UpdatePolicyTag, ::Google::Cloud::DataCatalog::V1::UpdatePolicyTagRequest, ::Google::Cloud::DataCatalog::V1::PolicyTag
            # Lists all policy tags in a taxonomy.
            rpc :ListPolicyTags, ::Google::Cloud::DataCatalog::V1::ListPolicyTagsRequest, ::Google::Cloud::DataCatalog::V1::ListPolicyTagsResponse
            # Gets a policy tag.
            rpc :GetPolicyTag, ::Google::Cloud::DataCatalog::V1::GetPolicyTagRequest, ::Google::Cloud::DataCatalog::V1::PolicyTag
            # Gets the IAM policy for a policy tag or a taxonomy.
            rpc :GetIamPolicy, ::Google::Iam::V1::GetIamPolicyRequest, ::Google::Iam::V1::Policy
            # Sets the IAM policy for a policy tag or a taxonomy.
            rpc :SetIamPolicy, ::Google::Iam::V1::SetIamPolicyRequest, ::Google::Iam::V1::Policy
            # Returns your permissions on a specified policy tag or
            # taxonomy.
            rpc :TestIamPermissions, ::Google::Iam::V1::TestIamPermissionsRequest, ::Google::Iam::V1::TestIamPermissionsResponse
          end

          Stub = Service.rpc_stub_class
        end
      end
    end
  end
end
