# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "gapic/common"
require "gapic/config"
require "gapic/config/method"

require "google/cloud/data_catalog/v1/version"

require "google/cloud/data_catalog/v1/policy_tag_manager_serialization/credentials"
require "google/cloud/data_catalog/v1/policy_tag_manager_serialization/paths"
require "google/cloud/data_catalog/v1/policy_tag_manager_serialization/client"
require "google/cloud/data_catalog/v1/policy_tag_manager_serialization/rest"

module Google
  module Cloud
    module DataCatalog
      module V1
        ##
        # Policy Tag Manager Serialization API service allows you to manipulate
        # your policy tags and taxonomies in a serialized format.
        #
        # Taxonomy is a hierarchical group of policy tags.
        #
        # @example Load this service and instantiate a gRPC client
        #
        #     require "google/cloud/data_catalog/v1/policy_tag_manager_serialization"
        #     client = ::Google::Cloud::DataCatalog::V1::PolicyTagManagerSerialization::Client.new
        #
        # @example Load this service and instantiate a REST client
        #
        #     require "google/cloud/data_catalog/v1/policy_tag_manager_serialization/rest"
        #     client = ::Google::Cloud::DataCatalog::V1::PolicyTagManagerSerialization::Rest::Client.new
        #
        module PolicyTagManagerSerialization
        end
      end
    end
  end
end

helper_path = ::File.join __dir__, "policy_tag_manager_serialization", "helpers.rb"
require "google/cloud/data_catalog/v1/policy_tag_manager_serialization/helpers" if ::File.file? helper_path
